# selector-no-qualifying-type

Disallow qualifying a selector by type.

<!-- prettier-ignore -->
```css
    a.foo {}
/** ↑
 * This type selector is qualifying the class */
```

A type selector is "qualifying" when it is compounded with (chained to) another selector (e.g. `a.foo`, `a#foo`). This rule does not regulate type selectors that are combined with other selectors via a combinator (e.g. `a > .foo`, `a #foo`).

The [`message` secondary option](../../../docs/user-guide/configure.md#message) can accept the arguments of this rule.

## Options

### `true`

```json
{
  "selector-no-qualifying-type": true
}
```

The following patterns are considered problems:

<!-- prettier-ignore -->
```css
a.foo {
  margin: 0
}
```

<!-- prettier-ignore -->
```css
a#foo {
  margin: 0
}
```

<!-- prettier-ignore -->
```css
input[type='button'] {
  margin: 0
}
```

The following patterns are _not_ considered problems:

<!-- prettier-ignore -->
```css
.foo {
  margin: 0
}
```

<!-- prettier-ignore -->
```css
#foo {
  margin: 0
}
```

<!-- prettier-ignore -->
```css
input {
  margin: 0
}
```

## Optional secondary options

### `ignore`

```json
{ "ignore": ["array", "of", "options"] }
```

#### `"attribute"`

Allow attribute selectors qualified by type.

```json
{
  "selector-no-qualifying-type": [true, { "ignore": ["attribute"] }]
}
```

The following patterns are _not_ considered problems:

<!-- prettier-ignore -->
```css
input[type='button'] {
  margin: 0
}
```

#### `"class"`

Allow class selectors qualified by type.

```json
{
  "selector-no-qualifying-type": [true, { "ignore": ["class"] }]
}
```

The following patterns are _not_ considered problems:

<!-- prettier-ignore -->
```css
a.foo {
  margin: 0
}
```

#### `"id"`

Allow ID selectors qualified by type.

```json
{
  "selector-no-qualifying-type": [true, { "ignore": ["id"] }]
}
```

The following patterns are _not_ considered problems:

<!-- prettier-ignore -->
```css
a#foo {
  margin: 0
}
```
