/* src/bazaar.p/bz-pride-flag-config.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-pride-flag-config.h"



struct _BzPrideFlagConfig
{
  GObject parent_instance;

  GListModel *flag_specs;
};

G_DEFINE_FINAL_TYPE (BzPrideFlagConfig, bz_pride_flag_config, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_FLAG_SPECS,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_pride_flag_config_dispose (GObject *object)
{
  BzPrideFlagConfig *self = BZ_PRIDE_FLAG_CONFIG (object);

  g_clear_pointer (&self->flag_specs, g_object_unref);

  G_OBJECT_CLASS (bz_pride_flag_config_parent_class)->dispose (object);
}

static void
bz_pride_flag_config_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzPrideFlagConfig *self = BZ_PRIDE_FLAG_CONFIG (object);

  switch (prop_id)
    {
    case PROP_FLAG_SPECS:
      g_value_set_object (value, bz_pride_flag_config_get_flag_specs (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_pride_flag_config_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzPrideFlagConfig *self = BZ_PRIDE_FLAG_CONFIG (object);

  switch (prop_id)
    {
    case PROP_FLAG_SPECS:
      bz_pride_flag_config_set_flag_specs (self, g_value_get_object (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_pride_flag_config_class_init (BzPrideFlagConfigClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_ensure (BZ_TYPE_PRIDE_FLAG_SPEC);

  object_class->set_property = bz_pride_flag_config_set_property;
  object_class->get_property = bz_pride_flag_config_get_property;
  object_class->dispose      = bz_pride_flag_config_dispose;

  props[PROP_FLAG_SPECS] =
      g_param_spec_object (
          "flag-specs",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_pride_flag_config_init (BzPrideFlagConfig *self)
{
}

BzPrideFlagConfig *
bz_pride_flag_config_new (void){
  return g_object_new (BZ_TYPE_PRIDE_FLAG_CONFIG, NULL);
}

GListModel *
bz_pride_flag_config_get_flag_specs (BzPrideFlagConfig *self){
  g_return_val_if_fail (BZ_IS_PRIDE_FLAG_CONFIG (self), NULL);
  return self->flag_specs;
}

void
bz_pride_flag_config_set_flag_specs (BzPrideFlagConfig *self,
    GListModel *flag_specs){
  g_return_if_fail (BZ_IS_PRIDE_FLAG_CONFIG (self));

  if (flag_specs == self->flag_specs)
    return;

  g_clear_pointer (&self->flag_specs, g_object_unref);
  if (flag_specs != NULL)
    self->flag_specs = g_object_ref (flag_specs);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_FLAG_SPECS]);
}

/* End of src/bazaar.p/bz-pride-flag-config.c */
