//////////////////////////////////////////////////////////////////////
//
// BeeBEEP Copyright (C) 2010-2021 Marco Mastroddi
//
// BeeBEEP is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 3 of the License,
// or (at your option) any later version.
//
// BeeBEEP is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with BeeBEEP. If not, see <http://www.gnu.org/licenses/>.
//
// Author: Marco Mastroddi <marco.mastroddi(AT)gmail.com>
//
// $Id: IconManager.cpp 1455 2020-12-23 10:17:53Z mastroddi $
//
//////////////////////////////////////////////////////////////////////

#include "IconManager.h"


IconManager* IconManager::mp_instance = Q_NULLPTR;


IconManager::IconManager()
 : m_defaultSourcePath( ":/images" ), m_sourcePath( "" )
{
}

QString IconManager::iconPath( const QString& icon_name ) const
{
  if( hasDefaultIcons() )
    return defaulIconPath( icon_name );

  QString custom_icon_path = customIconPath( icon_name );
  if( QFile::exists( custom_icon_path ) )
    return custom_icon_path;
  else
    return defaulIconPath( icon_name );
}
