/* NotificationsApplet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from NotificationsApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "notificationsapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <libpeas.h>

#define ALERT_SYMBOLIC "notification-alert-symbolic"
#define DND_SYMBOLIC "notification-disabled-symbolic"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NOTIFICATIONS_PLUGIN_0_PROPERTY,
	NOTIFICATIONS_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* notifications_plugin_properties[NOTIFICATIONS_PLUGIN_NUM_PROPERTIES];
enum  {
	RAVEN_REMOTE_NOTIFICATIONS_CHANGED_SIGNAL,
	RAVEN_REMOTE_UNREAD_NOTIFICATIONS_SIGNAL,
	RAVEN_REMOTE_READ_NOTIFICATIONS_SIGNAL,
	RAVEN_REMOTE_NUM_SIGNALS
};
static guint raven_remote_signals[RAVEN_REMOTE_NUM_SIGNALS] = {0};
typedef GDBusProxy RavenRemoteProxy;
typedef GDBusProxyClass RavenRemoteProxyClass;
typedef struct _raven_remote_ToggleNotificationsViewReadyData raven_remote_ToggleNotificationsViewReadyData;
typedef struct _raven_remote_GetNotificationCountReadyData raven_remote_GetNotificationCountReadyData;
enum  {
	DISPATCHER_REMOTE_DO_NOT_DISTURB_CHANGED_SIGNAL,
	DISPATCHER_REMOTE_NUM_SIGNALS
};
static guint dispatcher_remote_signals[DISPATCHER_REMOTE_NUM_SIGNALS] = {0};
typedef GDBusProxy DispatcherRemoteProxy;
typedef GDBusProxyClass DispatcherRemoteProxyClass;
enum  {
	NOTIFICATIONS_APPLET_0_PROPERTY,
	NOTIFICATIONS_APPLET_NUM_PROPERTIES
};
static GParamSpec* notifications_applet_properties[NOTIFICATIONS_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _raven_remote_ToggleNotificationsViewReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _raven_remote_GetNotificationCountReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _NotificationsAppletPrivate {
	GtkEventBox* widget;
	GtkImage* icon;
	GdkPixbuf* dnd_pixbuf;
	RavenRemote* raven_proxy;
	DispatcherRemote* dispatcher;
};

static gpointer notifications_plugin_parent_class = NULL;
static BudgiePluginIface * notifications_plugin_budgie_plugin_parent_iface = NULL;
static GType notifications_plugin_type_id = 0;
static GType raven_remote_type_id = 0;
static GType dispatcher_remote_type_id = 0;
static gint NotificationsApplet_private_offset;
static gpointer notifications_applet_parent_class = NULL;
static GType notifications_applet_type_id = 0;

static BudgieApplet* notifications_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                          const gchar* uuid);
static void raven_remote_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void _dbus_handle_raven_remote_notifications_changed (RavenRemote* self,
                                                      GVariant* parameters);
static void _dbus_handle_raven_remote_unread_notifications (RavenRemote* self,
                                                     GVariant* parameters);
static void _dbus_handle_raven_remote_read_notifications (RavenRemote* self,
                                                   GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void raven_remote_proxy_ToggleNotificationsView_async (RavenRemote* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void raven_remote_proxy_ToggleNotificationsView_finish (RavenRemote* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void raven_remote_proxy_GetNotificationCount_async (RavenRemote* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static guint raven_remote_proxy_GetNotificationCount_finish (RavenRemote* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void raven_remote_proxy_raven_remote_interface_init (RavenRemoteIface* iface);
static void _dbus_raven_remote_ToggleNotificationsView (RavenRemote* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_raven_remote_ToggleNotificationsView_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_raven_remote_GetNotificationCount (RavenRemote* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_raven_remote_GetNotificationCount_ready (GObject * source_object,
                                                    GAsyncResult * _res_,
                                                    gpointer _user_data_);
static void raven_remote_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* raven_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean raven_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _dbus_raven_remote_notifications_changed (GObject* _sender,
                                               gpointer* _data);
static void _dbus_raven_remote_unread_notifications (GObject* _sender,
                                              gpointer* _data);
static void _dbus_raven_remote_read_notifications (GObject* _sender,
                                            gpointer* _data);
static void _raven_remote_unregister_object (gpointer user_data);
static void dispatcher_remote_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void _dbus_handle_dispatcher_remote_do_not_disturb_changed (DispatcherRemote* self,
                                                            GVariant* parameters);
static void dispatcher_remote_proxy_dispatcher_remote_interface_init (DispatcherRemoteIface* iface);
static void dispatcher_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* dispatcher_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean dispatcher_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _dbus_dispatcher_remote_do_not_disturb_changed (GObject* _sender,
                                                     gboolean value,
                                                     gpointer* _data);
static void _dispatcher_remote_unregister_object (gpointer user_data);
static void notifications_applet_on_raven_get (NotificationsApplet* self,
                                        GObject* o,
                                        GAsyncResult* res);
static void _notifications_applet_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self);
static void notifications_applet_on_dispatcher_get (NotificationsApplet* self,
                                             GObject* o,
                                             GAsyncResult* res);
static void _notifications_applet_on_dispatcher_get_gasync_ready_callback (GObject* source_object,
                                                                    GAsyncResult* res,
                                                                    gpointer self);
static gboolean notifications_applet_on_button_release (NotificationsApplet* self,
                                                 GdkEventButton* button);
static gboolean _notifications_applet_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                  GdkEventButton* event,
                                                                                  gpointer self);
static void notifications_applet_on_notifications_changed (NotificationsApplet* self);
static void _notifications_applet_on_notifications_changed_raven_remote_notifications_changed (RavenRemote* _sender,
                                                                                        gpointer self);
static void notifications_applet_on_notifications_unread (NotificationsApplet* self);
static void _notifications_applet_on_notifications_unread_raven_remote_unread_notifications (RavenRemote* _sender,
                                                                                      gpointer self);
static void notifications_applet_on_notifications_read (NotificationsApplet* self);
static void _notifications_applet_on_notifications_read_raven_remote_read_notifications (RavenRemote* _sender,
                                                                                  gpointer self);
static void notifications_applet_on_get_count (NotificationsApplet* self,
                                        GObject* o,
                                        GAsyncResult* res);
static void _notifications_applet_on_get_count_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self);
static void notifications_applet_on_dnd_changed (NotificationsApplet* self,
                                          gboolean active);
static void _notifications_applet_on_dnd_changed_dispatcher_remote_do_not_disturb_changed (DispatcherRemote* _sender,
                                                                                    gboolean value,
                                                                                    gpointer self);
static void notifications_applet_set_dnd_state (NotificationsApplet* self,
                                         gboolean enabled);
static void __lambda4_ (NotificationsApplet* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void notifications_applet_finalize (GObject * obj);

static const GDBusArgInfo * const _raven_remote_dbus_arg_info_ToggleNotificationsView_in[] = {NULL};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_ToggleNotificationsView_out[] = {NULL};
static const GDBusMethodInfo _raven_remote_dbus_method_info_ToggleNotificationsView = {-1, "ToggleNotificationsView", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_ToggleNotificationsView_in), (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_ToggleNotificationsView_out), NULL};
static const GDBusArgInfo _raven_remote_dbus_arg_info_GetNotificationCount_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_GetNotificationCount_in[] = {NULL};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_GetNotificationCount_out[] = {&_raven_remote_dbus_arg_info_GetNotificationCount_result, NULL};
static const GDBusMethodInfo _raven_remote_dbus_method_info_GetNotificationCount = {-1, "GetNotificationCount", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_GetNotificationCount_in), (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_GetNotificationCount_out), NULL};
static const GDBusMethodInfo * const _raven_remote_dbus_method_info[] = {&_raven_remote_dbus_method_info_ToggleNotificationsView, &_raven_remote_dbus_method_info_GetNotificationCount, NULL};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_notifications_changed[] = {NULL};
static const GDBusSignalInfo _raven_remote_dbus_signal_info_notifications_changed = {-1, "NotificationsChanged", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_notifications_changed), NULL};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_unread_notifications[] = {NULL};
static const GDBusSignalInfo _raven_remote_dbus_signal_info_unread_notifications = {-1, "UnreadNotifications", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_unread_notifications), NULL};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_read_notifications[] = {NULL};
static const GDBusSignalInfo _raven_remote_dbus_signal_info_read_notifications = {-1, "ReadNotifications", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_read_notifications), NULL};
static const GDBusSignalInfo * const _raven_remote_dbus_signal_info[] = {&_raven_remote_dbus_signal_info_notifications_changed, &_raven_remote_dbus_signal_info_unread_notifications, &_raven_remote_dbus_signal_info_read_notifications, NULL};
static const GDBusPropertyInfo * const _raven_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _raven_remote_dbus_interface_info = {-1, "org.budgie_desktop.Raven", (GDBusMethodInfo **) (&_raven_remote_dbus_method_info), (GDBusSignalInfo **) (&_raven_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_raven_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _raven_remote_dbus_interface_vtable = {raven_remote_dbus_interface_method_call, raven_remote_dbus_interface_get_property, raven_remote_dbus_interface_set_property};
static const GDBusMethodInfo * const _dispatcher_remote_dbus_method_info[] = {NULL};
static const GDBusArgInfo _dispatcher_remote_dbus_arg_info_do_not_disturb_changed_value = {-1, "value", "b", NULL};
static const GDBusArgInfo * const _dispatcher_remote_dbus_arg_info_do_not_disturb_changed[] = {&_dispatcher_remote_dbus_arg_info_do_not_disturb_changed_value, NULL};
static const GDBusSignalInfo _dispatcher_remote_dbus_signal_info_do_not_disturb_changed = {-1, "DoNotDisturbChanged", (GDBusArgInfo **) (&_dispatcher_remote_dbus_arg_info_do_not_disturb_changed), NULL};
static const GDBusSignalInfo * const _dispatcher_remote_dbus_signal_info[] = {&_dispatcher_remote_dbus_signal_info_do_not_disturb_changed, NULL};
static const GDBusPropertyInfo * const _dispatcher_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dispatcher_remote_dbus_interface_info = {-1, "org.buddiesofbudgie.budgie.Dispatcher", (GDBusMethodInfo **) (&_dispatcher_remote_dbus_method_info), (GDBusSignalInfo **) (&_dispatcher_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_dispatcher_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _dispatcher_remote_dbus_interface_vtable = {dispatcher_remote_dbus_interface_method_call, dispatcher_remote_dbus_interface_get_property, dispatcher_remote_dbus_interface_set_property};

static BudgieApplet*
notifications_plugin_real_get_panel_widget (BudgiePlugin* base,
                                            const gchar* uuid)
{
	NotificationsPlugin * self;
	NotificationsApplet* _tmp0_;
	BudgieApplet* result;
	self = (NotificationsPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = notifications_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

NotificationsPlugin*
notifications_plugin_construct (GType object_type)
{
	NotificationsPlugin * self = NULL;
	self = (NotificationsPlugin*) g_object_new (object_type, NULL);
	return self;
}

NotificationsPlugin*
notifications_plugin_new (void)
{
	return notifications_plugin_construct (TYPE_NOTIFICATIONS_PLUGIN);
}

static void
notifications_plugin_class_init (NotificationsPluginClass * klass,
                                 gpointer klass_data)
{
	notifications_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
notifications_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                                   gpointer iface_data)
{
	notifications_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) notifications_plugin_real_get_panel_widget;
}

static void
notifications_plugin_instance_init (NotificationsPlugin * self,
                                    gpointer klass)
{
}

GType
notifications_plugin_get_type (void)
{
	return notifications_plugin_type_id;
}

GType
notifications_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsPlugin), 0, (GInstanceInitFunc) notifications_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) notifications_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	notifications_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "NotificationsPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, notifications_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return notifications_plugin_type_id;
}

void
raven_remote_ToggleNotificationsView (RavenRemote* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	RavenRemoteIface* _iface_;
	_iface_ = RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->ToggleNotificationsView) {
		_iface_->ToggleNotificationsView (self, _callback_, _user_data_);
	}
}

void
raven_remote_ToggleNotificationsView_finish (RavenRemote* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	RavenRemoteIface* _iface_;
	_iface_ = RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->ToggleNotificationsView_finish) {
		_iface_->ToggleNotificationsView_finish (self, _res_, error);
	}
}

void
raven_remote_GetNotificationCount (RavenRemote* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RavenRemoteIface* _iface_;
	_iface_ = RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->GetNotificationCount) {
		_iface_->GetNotificationCount (self, _callback_, _user_data_);
	}
}

guint
raven_remote_GetNotificationCount_finish (RavenRemote* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	RavenRemoteIface* _iface_;
	_iface_ = RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->GetNotificationCount_finish) {
		return _iface_->GetNotificationCount_finish (self, _res_, error);
	}
	return 0U;
}

static void
raven_remote_default_init (RavenRemoteIface * iface,
                           gpointer iface_data)
{
	raven_remote_signals[RAVEN_REMOTE_NOTIFICATIONS_CHANGED_SIGNAL] = g_signal_new ("notifications-changed", TYPE_RAVEN_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	raven_remote_signals[RAVEN_REMOTE_UNREAD_NOTIFICATIONS_SIGNAL] = g_signal_new ("unread-notifications", TYPE_RAVEN_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	raven_remote_signals[RAVEN_REMOTE_READ_NOTIFICATIONS_SIGNAL] = g_signal_new ("read-notifications", TYPE_RAVEN_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

GType
raven_remote_get_type (void)
{
	return raven_remote_type_id;
}

GType
raven_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (RavenRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raven_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	raven_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "RavenRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (raven_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (raven_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) raven_remote_proxy_get_type);
	g_type_set_qdata (raven_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.Raven");
	g_type_set_qdata (raven_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_raven_remote_dbus_interface_info));
	g_type_set_qdata (raven_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) raven_remote_register_object);
	return raven_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (RavenRemoteProxy, raven_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_RAVEN_REMOTE, raven_remote_proxy_raven_remote_interface_init) )
static void
raven_remote_proxy_class_init (RavenRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = raven_remote_proxy_g_signal;
}

static void
_dbus_handle_raven_remote_notifications_changed (RavenRemote* self,
                                                 GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "notifications-changed");
}

static void
_dbus_handle_raven_remote_unread_notifications (RavenRemote* self,
                                                GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "unread-notifications");
}

static void
_dbus_handle_raven_remote_read_notifications (RavenRemote* self,
                                              GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "read-notifications");
}

static void
raven_remote_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
	if (strcmp (signal_name, "NotificationsChanged") == 0) {
		_dbus_handle_raven_remote_notifications_changed ((RavenRemote*) proxy, parameters);
	} else if (strcmp (signal_name, "UnreadNotifications") == 0) {
		_dbus_handle_raven_remote_unread_notifications ((RavenRemote*) proxy, parameters);
	} else if (strcmp (signal_name, "ReadNotifications") == 0) {
		_dbus_handle_raven_remote_read_notifications ((RavenRemote*) proxy, parameters);
	}
}

static void
raven_remote_proxy_class_finalize (RavenRemoteProxyClass* klass)
{
}

void
raven_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	raven_remote_proxy_register_type (module);
}

static void
raven_remote_proxy_init (RavenRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_raven_remote_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
raven_remote_proxy_ToggleNotificationsView_async (RavenRemote* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "ToggleNotificationsView");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
raven_remote_proxy_ToggleNotificationsView_finish (RavenRemote* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
raven_remote_proxy_GetNotificationCount_async (RavenRemote* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "GetNotificationCount");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static guint
raven_remote_proxy_GetNotificationCount_finish (RavenRemote* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint _result = 0U;
	GVariant* _tmp2_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		guint _tmp0_ = 0U;
		return _tmp0_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		guint _tmp1_ = 0U;
		g_object_unref (_reply_message);
		return _tmp1_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}

static void
raven_remote_proxy_raven_remote_interface_init (RavenRemoteIface* iface)
{
	iface->ToggleNotificationsView = raven_remote_proxy_ToggleNotificationsView_async;
	iface->ToggleNotificationsView_finish = raven_remote_proxy_ToggleNotificationsView_finish;
	iface->GetNotificationCount = raven_remote_proxy_GetNotificationCount_async;
	iface->GetNotificationCount_finish = raven_remote_proxy_GetNotificationCount_finish;
}

static void
_dbus_raven_remote_ToggleNotificationsView (RavenRemote* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	raven_remote_ToggleNotificationsViewReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (raven_remote_ToggleNotificationsViewReadyData);
	_ready_data->_invocation_ = invocation;
	raven_remote_ToggleNotificationsView (self, (GAsyncReadyCallback) _dbus_raven_remote_ToggleNotificationsView_ready, _ready_data);
}

static void
_dbus_raven_remote_ToggleNotificationsView_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	raven_remote_ToggleNotificationsViewReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	raven_remote_ToggleNotificationsView_finish ((RavenRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (raven_remote_ToggleNotificationsViewReadyData, _ready_data);
}

static void
_dbus_raven_remote_GetNotificationCount (RavenRemote* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	raven_remote_GetNotificationCountReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (raven_remote_GetNotificationCountReadyData);
	_ready_data->_invocation_ = invocation;
	raven_remote_GetNotificationCount (self, (GAsyncReadyCallback) _dbus_raven_remote_GetNotificationCount_ready, _ready_data);
}

static void
_dbus_raven_remote_GetNotificationCount_ready (GObject * source_object,
                                               GAsyncResult * _res_,
                                               gpointer _user_data_)
{
	raven_remote_GetNotificationCountReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = raven_remote_GetNotificationCount_finish ((RavenRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (raven_remote_GetNotificationCountReadyData, _ready_data);
}

static void
raven_remote_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ToggleNotificationsView") == 0) {
		_dbus_raven_remote_ToggleNotificationsView (object, parameters, invocation);
	} else if (strcmp (method_name, "GetNotificationCount") == 0) {
		_dbus_raven_remote_GetNotificationCount (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
raven_remote_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
raven_remote_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_raven_remote_notifications_changed (GObject* _sender,
                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "NotificationsChanged", _arguments, NULL);
}

static void
_dbus_raven_remote_unread_notifications (GObject* _sender,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "UnreadNotifications", _arguments, NULL);
}

static void
_dbus_raven_remote_read_notifications (GObject* _sender,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "ReadNotifications", _arguments, NULL);
}

guint
raven_remote_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_raven_remote_dbus_interface_info), &_raven_remote_dbus_interface_vtable, data, _raven_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "notifications-changed", (GCallback) _dbus_raven_remote_notifications_changed, data);
	g_signal_connect (object, "unread-notifications", (GCallback) _dbus_raven_remote_unread_notifications, data);
	g_signal_connect (object, "read-notifications", (GCallback) _dbus_raven_remote_read_notifications, data);
	return result;
}

static void
_raven_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_remote_notifications_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_remote_unread_notifications, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_remote_read_notifications, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
dispatcher_remote_default_init (DispatcherRemoteIface * iface,
                                gpointer iface_data)
{
	dispatcher_remote_signals[DISPATCHER_REMOTE_DO_NOT_DISTURB_CHANGED_SIGNAL] = g_signal_new ("do-not-disturb-changed", TYPE_DISPATCHER_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

GType
dispatcher_remote_get_type (void)
{
	return dispatcher_remote_type_id;
}

GType
dispatcher_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (DispatcherRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dispatcher_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	dispatcher_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "DispatcherRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (dispatcher_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (dispatcher_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dispatcher_remote_proxy_get_type);
	g_type_set_qdata (dispatcher_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.buddiesofbudgie.budgie.Dispatcher");
	g_type_set_qdata (dispatcher_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_dispatcher_remote_dbus_interface_info));
	g_type_set_qdata (dispatcher_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dispatcher_remote_register_object);
	return dispatcher_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (DispatcherRemoteProxy, dispatcher_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_DISPATCHER_REMOTE, dispatcher_remote_proxy_dispatcher_remote_interface_init) )
static void
dispatcher_remote_proxy_class_init (DispatcherRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = dispatcher_remote_proxy_g_signal;
}

static void
_dbus_handle_dispatcher_remote_do_not_disturb_changed (DispatcherRemote* self,
                                                       GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gboolean value = FALSE;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	value = g_variant_get_boolean (_tmp3_);
	g_variant_unref (_tmp3_);
	g_signal_emit_by_name (self, "do-not-disturb-changed", value);
}

static void
dispatcher_remote_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
	if (strcmp (signal_name, "DoNotDisturbChanged") == 0) {
		_dbus_handle_dispatcher_remote_do_not_disturb_changed ((DispatcherRemote*) proxy, parameters);
	}
}

static void
dispatcher_remote_proxy_class_finalize (DispatcherRemoteProxyClass* klass)
{
}

void
dispatcher_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	dispatcher_remote_proxy_register_type (module);
}

static void
dispatcher_remote_proxy_init (DispatcherRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_dispatcher_remote_dbus_interface_info));
}

static void
dispatcher_remote_proxy_dispatcher_remote_interface_init (DispatcherRemoteIface* iface)
{
}

static void
dispatcher_remote_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
dispatcher_remote_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
dispatcher_remote_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_dispatcher_remote_do_not_disturb_changed (GObject* _sender,
                                                gboolean value,
                                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.buddiesofbudgie.budgie.Dispatcher", "DoNotDisturbChanged", _arguments, NULL);
}

guint
dispatcher_remote_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dispatcher_remote_dbus_interface_info), &_dispatcher_remote_dbus_interface_vtable, data, _dispatcher_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "do-not-disturb-changed", (GCallback) _dbus_dispatcher_remote_do_not_disturb_changed, data);
	return result;
}

static void
_dispatcher_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dispatcher_remote_do_not_disturb_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
notifications_applet_get_instance_private (NotificationsApplet* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsApplet_private_offset);
}

static void
_notifications_applet_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self)
{
	notifications_applet_on_raven_get ((NotificationsApplet*) self, source_object, res);
	g_object_unref (self);
}

static void
_notifications_applet_on_dispatcher_get_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self)
{
	notifications_applet_on_dispatcher_get ((NotificationsApplet*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
_notifications_applet_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self)
{
	gboolean result;
	result = notifications_applet_on_button_release ((NotificationsApplet*) self, event);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

NotificationsApplet*
notifications_applet_construct (GType object_type)
{
	NotificationsApplet * self = NULL;
	GtkEventBox* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkImage* _tmp2_;
	GtkEventBox* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkEventBox* _tmp7_;
	GError* _inner_error0_ = NULL;
	self = (NotificationsApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp0_;
	_tmp1_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name (ALERT_SYMBOLIC, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp2_;
	_tmp3_ = self->priv->widget;
	_tmp4_ = self->priv->icon;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->icon;
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	_tmp6_ = self->priv->icon;
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	g_async_initable_new_async (TYPE_RAVEN_REMOTE_PROXY, 0, NULL, _notifications_applet_on_raven_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", RAVEN_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RAVEN_DBUS_OBJECT_PATH, "g-interface-name", "org.budgie_desktop.Raven", NULL);
	g_async_initable_new_async (TYPE_DISPATCHER_REMOTE_PROXY, 0, NULL, _notifications_applet_on_dispatcher_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", NOTIFICATION_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", NOTIFICATION_DBUS_OBJECT_PATH, "g-interface-name", "org.buddiesofbudgie.budgie.Dispatcher", NULL);
	_tmp7_ = self->priv->widget;
	g_signal_connect_object ((GtkWidget*) _tmp7_, "button-release-event", (GCallback) _notifications_applet_on_button_release_gtk_widget_button_release_event, self, 0);
	{
		GtkIconTheme* current_theme = NULL;
		GtkIconTheme* _tmp8_;
		GtkIconTheme* _tmp9_;
		gboolean _tmp10_ = FALSE;
		GtkIconTheme* _tmp11_;
		_tmp8_ = gtk_icon_theme_get_default ();
		_tmp9_ = _g_object_ref0 (_tmp8_);
		current_theme = _tmp9_;
		_tmp11_ = current_theme;
		if (_tmp11_ != NULL) {
			GtkIconTheme* _tmp12_;
			_tmp12_ = current_theme;
			_tmp10_ = gtk_icon_theme_has_icon (_tmp12_, DND_SYMBOLIC);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GdkPixbuf* _tmp13_ = NULL;
			GtkIconTheme* _tmp14_;
			GdkPixbuf* _tmp15_;
			GdkPixbuf* _tmp16_;
			GdkPixbuf* _tmp17_;
			GdkPixbuf* _tmp18_;
			_tmp14_ = current_theme;
			_tmp15_ = gtk_icon_theme_load_icon (_tmp14_, DND_SYMBOLIC, 16, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error0_);
			_tmp13_ = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (current_theme);
				goto __catch0_g_error;
			}
			_tmp16_ = _tmp13_;
			_tmp13_ = NULL;
			_g_object_unref0 (self->priv->dnd_pixbuf);
			self->priv->dnd_pixbuf = _tmp16_;
			_tmp17_ = self->priv->dnd_pixbuf;
			_tmp18_ = gdk_pixbuf_scale_simple (_tmp17_, 14, 14, GDK_INTERP_BILINEAR);
			_g_object_unref0 (self->priv->dnd_pixbuf);
			self->priv->dnd_pixbuf = _tmp18_;
			_g_object_unref0 (_tmp13_);
		}
		_g_object_unref0 (current_theme);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("NotificationsApplet.vala:69: Failed to generate our DND pixbuf: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

NotificationsApplet*
notifications_applet_new (void)
{
	return notifications_applet_construct (TYPE_NOTIFICATIONS_APPLET);
}

static void
_notifications_applet_on_notifications_changed_raven_remote_notifications_changed (RavenRemote* _sender,
                                                                                   gpointer self)
{
	notifications_applet_on_notifications_changed ((NotificationsApplet*) self);
}

static void
_notifications_applet_on_notifications_unread_raven_remote_unread_notifications (RavenRemote* _sender,
                                                                                 gpointer self)
{
	notifications_applet_on_notifications_unread ((NotificationsApplet*) self);
}

static void
_notifications_applet_on_notifications_read_raven_remote_read_notifications (RavenRemote* _sender,
                                                                             gpointer self)
{
	notifications_applet_on_notifications_read ((NotificationsApplet*) self);
}

static void
_notifications_applet_on_get_count_gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self)
{
	notifications_applet_on_get_count ((NotificationsApplet*) self, source_object, res);
	g_object_unref (self);
}

static void
notifications_applet_on_raven_get (NotificationsApplet* self,
                                   GObject* o,
                                   GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RavenRemote* _tmp0_ = NULL;
		RavenRemote* _tmp1_;
		RavenRemote* _tmp2_;
		RavenRemote* _tmp3_;
		RavenRemote* _tmp4_;
		RavenRemote* _tmp5_;
		RavenRemote* _tmp6_;
		RavenRemote* _tmp7_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (RavenRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (RavenRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->raven_proxy);
		self->priv->raven_proxy = _tmp3_;
		_tmp4_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp4_, "notifications-changed", (GCallback) _notifications_applet_on_notifications_changed_raven_remote_notifications_changed, self, 0);
		_tmp5_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp5_, "unread-notifications", (GCallback) _notifications_applet_on_notifications_unread_raven_remote_unread_notifications, self, 0);
		_tmp6_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp6_, "read-notifications", (GCallback) _notifications_applet_on_notifications_read_raven_remote_read_notifications, self, 0);
		_tmp7_ = self->priv->raven_proxy;
		raven_remote_GetNotificationCount (_tmp7_, _notifications_applet_on_get_count_gasync_ready_callback, g_object_ref (self));
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("NotificationsApplet.vala:84: Failed to get Raven proxy: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_notifications_applet_on_dnd_changed_dispatcher_remote_do_not_disturb_changed (DispatcherRemote* _sender,
                                                                               gboolean value,
                                                                               gpointer self)
{
	notifications_applet_on_dnd_changed ((NotificationsApplet*) self, value);
}

static void
notifications_applet_on_dispatcher_get (NotificationsApplet* self,
                                        GObject* o,
                                        GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		DispatcherRemote* _tmp0_ = NULL;
		DispatcherRemote* _tmp1_;
		DispatcherRemote* _tmp2_;
		DispatcherRemote* _tmp3_;
		DispatcherRemote* _tmp4_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (DispatcherRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (DispatcherRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->dispatcher);
		self->priv->dispatcher = _tmp3_;
		_tmp4_ = self->priv->dispatcher;
		g_signal_connect_object (_tmp4_, "do-not-disturb-changed", (GCallback) _notifications_applet_on_dnd_changed_dispatcher_remote_do_not_disturb_changed, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("NotificationsApplet.vala:94: Failed to get notification dispatcher pro" \
"xy: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
notifications_applet_on_dnd_changed (NotificationsApplet* self,
                                     gboolean active)
{
	g_return_if_fail (self != NULL);
	notifications_applet_set_dnd_state (self, active);
}

static void
notifications_applet_on_notifications_read (NotificationsApplet* self)
{
	GtkImage* _tmp0_;
	GtkStyleContext* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, "alert");
}

static void
notifications_applet_on_notifications_unread (NotificationsApplet* self)
{
	GtkImage* _tmp0_;
	GtkStyleContext* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_add_class (_tmp1_, "alert");
}

static void
notifications_applet_on_get_count (NotificationsApplet* self,
                                   GObject* o,
                                   GAsyncResult* res)
{
	guint count = 0U;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	count = (guint) 0;
	{
		guint _tmp0_ = 0U;
		RavenRemote* _tmp1_;
		_tmp1_ = self->priv->raven_proxy;
		_tmp0_ = raven_remote_GetNotificationCount_finish (_tmp1_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		count = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("NotificationsApplet.vala:116: Error getting notifications: %s", _tmp3_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (count > ((guint) 0)) {
		GtkImage* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->icon;
		_tmp5_ = g_strdup_printf (ngettext ("%u unread notification", "%u unread notifications", (gulong) count), count);
		_tmp6_ = _tmp5_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		GtkImage* _tmp7_;
		_tmp7_ = self->priv->icon;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _ ("No unread notifications"));
	}
}

static void
notifications_applet_set_dnd_state (NotificationsApplet* self,
                                    gboolean enabled)
{
	g_return_if_fail (self != NULL);
	if (enabled) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = self->priv->dnd_pixbuf;
		if (_tmp0_ != NULL) {
			GtkImage* _tmp1_;
			GdkPixbuf* _tmp2_;
			_tmp1_ = self->priv->icon;
			_tmp2_ = self->priv->dnd_pixbuf;
			gtk_image_set_from_pixbuf (_tmp1_, _tmp2_);
		} else {
			GtkImage* _tmp3_;
			_tmp3_ = self->priv->icon;
			gtk_image_set_from_icon_name (_tmp3_, DND_SYMBOLIC, (GtkIconSize) GTK_ICON_SIZE_MENU);
		}
	} else {
		GtkImage* _tmp4_;
		_tmp4_ = self->priv->icon;
		gtk_image_set_from_icon_name (_tmp4_, ALERT_SYMBOLIC, (GtkIconSize) GTK_ICON_SIZE_MENU);
	}
}

static void
notifications_applet_on_notifications_changed (NotificationsApplet* self)
{
	RavenRemote* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven_proxy;
	raven_remote_GetNotificationCount (_tmp0_, _notifications_applet_on_get_count_gasync_ready_callback, g_object_ref (self));
}

static void
__lambda4_ (NotificationsApplet* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		RavenRemote* _tmp0_;
		_tmp0_ = self->priv->raven_proxy;
		raven_remote_ToggleNotificationsView_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_message ("NotificationsApplet.vala:156: Failed to toggle Raven: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((NotificationsApplet*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
notifications_applet_on_button_release (NotificationsApplet* self,
                                        GdkEventButton* button)
{
	RavenRemote* _tmp0_;
	RavenRemote* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	if (button->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp1_ = self->priv->raven_proxy;
	raven_remote_ToggleNotificationsView (_tmp1_, ___lambda4__gasync_ready_callback, g_object_ref (self));
	result = GDK_EVENT_STOP;
	return result;
}

static void
notifications_applet_class_init (NotificationsAppletClass * klass,
                                 gpointer klass_data)
{
	notifications_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsApplet_private_offset);
	G_OBJECT_CLASS (klass)->finalize = notifications_applet_finalize;
}

static void
notifications_applet_instance_init (NotificationsApplet * self,
                                    gpointer klass)
{
	self->priv = notifications_applet_get_instance_private (self);
	self->priv->dnd_pixbuf = NULL;
	self->priv->raven_proxy = NULL;
	self->priv->dispatcher = NULL;
}

static void
notifications_applet_finalize (GObject * obj)
{
	NotificationsApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFICATIONS_APPLET, NotificationsApplet);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->dnd_pixbuf);
	_g_object_unref0 (self->priv->raven_proxy);
	_g_object_unref0 (self->priv->dispatcher);
	G_OBJECT_CLASS (notifications_applet_parent_class)->finalize (obj);
}

GType
notifications_applet_get_type (void)
{
	return notifications_applet_type_id;
}

GType
notifications_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsApplet), 0, (GInstanceInitFunc) notifications_applet_instance_init, NULL };
	notifications_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "NotificationsApplet", &g_define_type_info, 0);
	NotificationsApplet_private_offset = sizeof (NotificationsAppletPrivate);
	return notifications_applet_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	notifications_plugin_register_type (module);
	notifications_applet_register_type (module);
	raven_remote_register_type (module);
	raven_remote_proxy_register_dynamic_type (module);
	dispatcher_remote_register_type (module);
	dispatcher_remote_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_NOTIFICATIONS_PLUGIN);
	_g_object_unref0 (objmodule);
}

