/* key-model.c generated by valac 0.56.18, the Vala compiler
 * generated from key-model.vala, do not modify */

#include "caribou.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CARIBOU_KEY_MODEL_0_PROPERTY,
	CARIBOU_KEY_MODEL_ALIGN_PROPERTY,
	CARIBOU_KEY_MODEL_WIDTH_PROPERTY,
	CARIBOU_KEY_MODEL_TOGGLE_PROPERTY,
	CARIBOU_KEY_MODEL_REPEATABLE_PROPERTY,
	CARIBOU_KEY_MODEL_IS_MODIFIER_PROPERTY,
	CARIBOU_KEY_MODEL_SHOW_SUBKEYS_PROPERTY,
	CARIBOU_KEY_MODEL_NAME_PROPERTY,
	CARIBOU_KEY_MODEL_KEYVAL_PROPERTY,
	CARIBOU_KEY_MODEL_TEXT_PROPERTY,
	CARIBOU_KEY_MODEL_LABEL_PROPERTY,
	CARIBOU_KEY_MODEL_SCAN_STEPPING_PROPERTY,
	CARIBOU_KEY_MODEL_SCAN_SELECTED_PROPERTY,
	CARIBOU_KEY_MODEL_NUM_PROPERTIES
};
static GParamSpec* caribou_key_model_properties[CARIBOU_KEY_MODEL_NUM_PROPERTIES];

#define CARIBOU_TYPE_MODIFIER_MAP_ENTRY (caribou_modifier_map_entry_get_type ())
typedef struct _CaribouModifierMapEntry CaribouModifierMapEntry;

#define CARIBOU_TYPE_LABEL_MAP_ENTRY (caribou_label_map_entry_get_type ())
typedef struct _CaribouLabelMapEntry CaribouLabelMapEntry;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	CARIBOU_KEY_MODEL_KEY_HOLD_END_SIGNAL,
	CARIBOU_KEY_MODEL_KEY_HOLD_SIGNAL,
	CARIBOU_KEY_MODEL_NUM_SIGNALS
};
static guint caribou_key_model_signals[CARIBOU_KEY_MODEL_NUM_SIGNALS] = {0};

struct _CaribouKeyModelPrivate {
	gchar* _align;
	gdouble _width;
	gchar* _toggle;
	gboolean _repeatable;
	GdkModifierType mod_mask;
	gboolean _show_subkeys;
	gchar* _name;
	guint _keyval;
	gchar* _text;
	guint* _keyvals;
	gint _keyvals_length1;
	gint __keyvals_size_;
	gchar* _label;
	gboolean _scan_stepping;
	gboolean _scan_selected;
	guint hold_tid;
	CaribouDisplayAdapter* xadapter;
	GeeArrayList* extended_keys;
};

struct _CaribouModifierMapEntry {
	gchar* name;
	GdkModifierType mask;
};

struct _CaribouLabelMapEntry {
	gchar* name;
	gchar* label;
};

static gint CaribouKeyModel_private_offset;
static gpointer caribou_key_model_parent_class = NULL;
static CaribouIScannableItemIface * caribou_key_model_caribou_iscannable_item_parent_iface = NULL;
static CaribouIKeyboardObjectIface * caribou_key_model_caribou_ikeyboard_object_parent_iface = NULL;

VALA_EXTERN GType caribou_modifier_map_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CaribouModifierMapEntry* caribou_modifier_map_entry_dup (const CaribouModifierMapEntry* self);
VALA_EXTERN void caribou_modifier_map_entry_free (CaribouModifierMapEntry* self);
VALA_EXTERN void caribou_modifier_map_entry_copy (const CaribouModifierMapEntry* self,
                                      CaribouModifierMapEntry* dest);
VALA_EXTERN void caribou_modifier_map_entry_destroy (CaribouModifierMapEntry* self);
VALA_EXTERN GType caribou_label_map_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CaribouLabelMapEntry* caribou_label_map_entry_dup (const CaribouLabelMapEntry* self);
VALA_EXTERN void caribou_label_map_entry_free (CaribouLabelMapEntry* self);
VALA_EXTERN void caribou_label_map_entry_copy (const CaribouLabelMapEntry* self,
                                   CaribouLabelMapEntry* dest);
VALA_EXTERN void caribou_label_map_entry_destroy (CaribouLabelMapEntry* self);
static void caribou_key_model_set_name (CaribouKeyModel* self,
                                 const gchar* value);
static void caribou_key_model_set_text (CaribouKeyModel* self,
                                 const gchar* value);
static void _vala_array_add3 (guint* * array,
                       gint* length,
                       gint* size,
                       guint value);
static void _vala_array_add4 (guint* * array,
                       gint* length,
                       gint* size,
                       guint value);
static void caribou_key_model_set_keyval (CaribouKeyModel* self,
                                   guint value);
VALA_EXTERN void caribou_key_model_add_subkey (CaribouKeyModel* self,
                                   CaribouKeyModel* key);
static void caribou_key_model_on_subkey_released (CaribouKeyModel* self,
                                           CaribouKeyModel* key);
static void _caribou_key_model_on_subkey_released_caribou_ikeyboard_object_key_released (CaribouIKeyboardObject* _sender,
                                                                                  CaribouKeyModel* key,
                                                                                  gpointer self);
static void caribou_key_model_set_show_subkeys (CaribouKeyModel* self,
                                         gboolean value);
static gboolean caribou_key_model_on_key_held (CaribouKeyModel* self);
static gboolean _caribou_key_model_on_key_held_gsource_func (gpointer self);
static CaribouKeyModel** caribou_key_model_real_get_keys (CaribouIKeyboardObject* base,
                                                   gint* result_length1);
static CaribouIKeyboardObject** caribou_key_model_real_get_children (CaribouIKeyboardObject* base,
                                                              gint* result_length1);
static gboolean __lambda4_ (CaribouKeyModel* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static void caribou_key_model_finalize (GObject * obj);
static GType caribou_key_model_get_type_once (void);
static void _vala_caribou_key_model_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_caribou_key_model_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static const CaribouModifierMapEntry CARIBOU_KEY_MODEL_mod_map[3] = {{"Control_L", GDK_CONTROL_MASK}, {"Alt_L", GDK_MOD1_MASK}, {NULL, 0}};
static const CaribouLabelMapEntry CARIBOU_KEY_MODEL_label_map[24] = {{"BackSpace", "\xe2\x8c\xab"}, {"space", " "}, {"Delete", "\xe2\x8c\xa6"}, {"Return", "\xe2\x8f\x8e"}, {"Escape", "Esc"}, {"Tab", "\xe2\x86\xb9"}, {"Control_L", "Ctrl"}, {"Control_R", "Ctrl"}, {"Alt_L", "Alt"}, {"Alt_R", "Alt"}, {"Up", "\xe2\x87\xa1"}, {"Down", "\xe2\x87\xa3"}, {"Left", "\xe2\x87\xa0"}, {"Right", "\xe2\x87\xa2"}, {"Prior", "Page\nUp"}, {"Next", "Page\nDown"}, {"Caribou_Prefs", "\xe2\x8c\xa8"}, {"Caribou_ShiftUp", "\xe2\xac\x86"}, {"Caribou_ShiftDown", "\xe2\xac\x87"}, {"Caribou_Emoticons", "\xe2\x98\xba"}, {"Caribou_Symbols", "123"}, {"Caribou_Symbols_More", "{#*"}, {"Caribou_Alpha", "Abc"}, {"Caribou_Repeat", "\xe2\x99\xbb"}};

static inline gpointer
caribou_key_model_get_instance_private (CaribouKeyModel* self)
{
	return G_STRUCT_MEMBER_P (self, CaribouKeyModel_private_offset);
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static void
_vala_array_add3 (guint* * array,
                  gint* length,
                  gint* size,
                  guint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add4 (guint* * array,
                  gint* length,
                  gint* size,
                  guint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

CaribouKeyModel*
caribou_key_model_construct (GType object_type,
                             const gchar* name,
                             const gchar* text)
{
	CaribouKeyModel * self = NULL;
	gint i = 0;
	CaribouDisplayAdapter* _tmp49_;
	GeeArrayList* _tmp50_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (CaribouKeyModel*) g_object_new (object_type, NULL);
	caribou_key_model_set_name (self, name);
	caribou_key_model_set_text (self, text);
	self->priv->mod_mask = (GdkModifierType) 0;
	i = 0;
	{
		CaribouModifierMapEntry entry = {0};
		CaribouModifierMapEntry _tmp0_;
		CaribouModifierMapEntry _tmp1_;
		CaribouModifierMapEntry _tmp2_ = {0};
		_tmp0_ = CARIBOU_KEY_MODEL_mod_map[i];
		_tmp1_ = _tmp0_;
		caribou_modifier_map_entry_copy (&_tmp1_, &_tmp2_);
		entry = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				CaribouModifierMapEntry _tmp8_;
				const gchar* _tmp9_;
				CaribouModifierMapEntry _tmp10_;
				const gchar* _tmp11_;
				if (!_tmp3_) {
					gint _tmp4_;
					CaribouModifierMapEntry _tmp5_;
					CaribouModifierMapEntry _tmp6_;
					CaribouModifierMapEntry _tmp7_ = {0};
					i = i + 1;
					_tmp4_ = i;
					_tmp5_ = CARIBOU_KEY_MODEL_mod_map[_tmp4_];
					_tmp6_ = _tmp5_;
					caribou_modifier_map_entry_copy (&_tmp6_, &_tmp7_);
					caribou_modifier_map_entry_destroy (&entry);
					entry = _tmp7_;
				}
				_tmp3_ = FALSE;
				_tmp8_ = entry;
				_tmp9_ = _tmp8_.name;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = entry;
				_tmp11_ = _tmp10_.name;
				if (g_strcmp0 (name, _tmp11_) == 0) {
					CaribouModifierMapEntry _tmp12_;
					_tmp12_ = entry;
					self->priv->mod_mask = _tmp12_.mask;
				}
			}
		}
		caribou_modifier_map_entry_destroy (&entry);
	}
	if (self->priv->mod_mask == 0) {
		if (text != NULL) {
			gint index = 0;
			gunichar uc = 0U;
			index = 0;
			while (TRUE) {
				gunichar _tmp13_ = 0U;
				gboolean _tmp14_;
				guint keyval = 0U;
				_tmp14_ = string_get_next_char (text, &index, &_tmp13_);
				uc = _tmp13_;
				if (!_tmp14_) {
					break;
				}
				keyval = gdk_unicode_to_keyval ((guint32) uc);
				if (keyval != ((guint) (uc | 0x01000000))) {
					_vala_array_add3 (&self->priv->_keyvals, &self->priv->_keyvals_length1, &self->priv->__keyvals_size_, keyval);
				}
			}
		} else {
			guint keyval = 0U;
			gboolean _tmp15_ = FALSE;
			keyval = gdk_keyval_from_name (name);
			if (keyval != GDK_KEY_VoidSymbol) {
				_tmp15_ = keyval != ((guint) 0);
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				_vala_array_add4 (&self->priv->_keyvals, &self->priv->_keyvals_length1, &self->priv->__keyvals_size_, keyval);
			}
			caribou_key_model_set_keyval (self, keyval);
		}
	}
	{
		gboolean _tmp16_ = FALSE;
		i = 0;
		_tmp16_ = TRUE;
		while (TRUE) {
			CaribouLabelMapEntry _tmp18_;
			const gchar* _tmp19_;
			if (!_tmp16_) {
				gint _tmp17_;
				_tmp17_ = i;
				i = _tmp17_ + 1;
			}
			_tmp16_ = FALSE;
			if (!(i < G_N_ELEMENTS (CARIBOU_KEY_MODEL_label_map))) {
				break;
			}
			_tmp18_ = CARIBOU_KEY_MODEL_label_map[i];
			_tmp19_ = _tmp18_.name;
			if (g_strcmp0 (_tmp19_, name) == 0) {
				CaribouLabelMapEntry _tmp20_;
				const gchar* _tmp21_;
				_tmp20_ = CARIBOU_KEY_MODEL_label_map[i];
				_tmp21_ = _tmp20_.label;
				caribou_key_model_set_label (self, _tmp21_);
				break;
			}
		}
	}
	if (i == G_N_ELEMENTS (CARIBOU_KEY_MODEL_label_map)) {
		if (text != NULL) {
			caribou_key_model_set_label (self, text);
		} else {
			if (g_str_has_prefix (name, "Caribou_")) {
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp22_ = strlen ("Caribou_");
				_tmp23_ = _tmp22_;
				_tmp24_ = strlen (name);
				_tmp25_ = _tmp24_;
				_tmp26_ = string_slice (name, (glong) _tmp23_, (glong) _tmp25_);
				_tmp27_ = _tmp26_;
				caribou_key_model_set_label (self, _tmp27_);
				_g_free0 (_tmp27_);
			} else {
				guint* _tmp28_;
				gint _tmp28__length1;
				gboolean _tmp34_ = FALSE;
				const gchar* _tmp35_;
				gboolean _tmp46_ = FALSE;
				const gchar* _tmp47_;
				_tmp28_ = self->priv->_keyvals;
				_tmp28__length1 = self->priv->_keyvals_length1;
				if (_tmp28__length1 > 0) {
					gunichar uc = 0U;
					guint* _tmp29_;
					gint _tmp29__length1;
					guint _tmp30_;
					gboolean _tmp31_ = FALSE;
					_tmp29_ = self->priv->_keyvals;
					_tmp29__length1 = self->priv->_keyvals_length1;
					_tmp30_ = _tmp29_[0];
					uc = (gunichar) gdk_keyval_to_unicode (_tmp30_);
					if (!g_unichar_isspace (uc)) {
						_tmp31_ = uc != ((gunichar) 0);
					} else {
						_tmp31_ = FALSE;
					}
					if (_tmp31_) {
						gchar* _tmp32_;
						gchar* _tmp33_;
						_tmp32_ = g_unichar_to_string (uc);
						_tmp33_ = _tmp32_;
						caribou_key_model_set_label (self, _tmp33_);
						_g_free0 (_tmp33_);
					}
				}
				_tmp35_ = self->priv->_label;
				if (g_strcmp0 (_tmp35_, "") == 0) {
					_tmp34_ = g_str_has_prefix (name, "dead_");
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					guint keyval = 0U;
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					guint _tmp42_;
					gunichar uc = 0U;
					gboolean _tmp43_ = FALSE;
					_tmp36_ = strlen ("dead_");
					_tmp37_ = _tmp36_;
					_tmp38_ = strlen (name);
					_tmp39_ = _tmp38_;
					_tmp40_ = string_slice (name, (glong) _tmp37_, (glong) _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = gdk_keyval_from_name (_tmp41_);
					_g_free0 (_tmp41_);
					keyval = _tmp42_;
					uc = (gunichar) gdk_keyval_to_unicode (keyval);
					if (!g_unichar_isspace (uc)) {
						_tmp43_ = uc != ((gunichar) 0);
					} else {
						_tmp43_ = FALSE;
					}
					if (_tmp43_) {
						gchar* _tmp44_;
						gchar* _tmp45_;
						_tmp44_ = g_unichar_to_string (uc);
						_tmp45_ = _tmp44_;
						caribou_key_model_set_label (self, _tmp45_);
						_g_free0 (_tmp45_);
					}
				}
				_tmp47_ = self->priv->_label;
				if (g_strcmp0 (_tmp47_, "") == 0) {
					guint* _tmp48_;
					gint _tmp48__length1;
					_tmp48_ = self->priv->_keyvals;
					_tmp48__length1 = self->priv->_keyvals_length1;
					_tmp46_ = _tmp48__length1 > 0;
				} else {
					_tmp46_ = FALSE;
				}
				if (_tmp46_) {
					caribou_key_model_set_label (self, name);
				}
			}
		}
	}
	_tmp49_ = caribou_display_adapter_get_default ();
	_g_object_unref0 (self->priv->xadapter);
	self->priv->xadapter = _tmp49_;
	_tmp50_ = gee_array_list_new (CARIBOU_TYPE_KEY_MODEL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->extended_keys);
	self->priv->extended_keys = _tmp50_;
	return self;
}

CaribouKeyModel*
caribou_key_model_new (const gchar* name,
                       const gchar* text)
{
	return caribou_key_model_construct (CARIBOU_TYPE_KEY_MODEL, name, text);
}

static void
_caribou_key_model_on_subkey_released_caribou_ikeyboard_object_key_released (CaribouIKeyboardObject* _sender,
                                                                             CaribouKeyModel* key,
                                                                             gpointer self)
{
	caribou_key_model_on_subkey_released ((CaribouKeyModel*) self, key);
}

void
caribou_key_model_add_subkey (CaribouKeyModel* self,
                              CaribouKeyModel* key)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_signal_connect_object ((CaribouIKeyboardObject*) key, "key-released", (GCallback) _caribou_key_model_on_subkey_released_caribou_ikeyboard_object_key_released, self, 0);
	_tmp0_ = self->priv->extended_keys;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, key);
}

static void
caribou_key_model_on_subkey_released (CaribouKeyModel* self,
                                      CaribouKeyModel* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_signal_emit_by_name ((CaribouIKeyboardObject*) self, "key-released", key);
	caribou_key_model_set_show_subkeys (self, FALSE);
}

static gboolean
_caribou_key_model_on_key_held_gsource_func (gpointer self)
{
	gboolean result;
	result = caribou_key_model_on_key_held ((CaribouKeyModel*) self);
	return result;
}

void
caribou_key_model_press (CaribouKeyModel* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = caribou_key_model_get_is_modifier (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		if (self->modifier_state == CARIBOU_MODIFIER_STATE_NONE) {
			CaribouDisplayAdapter* _tmp2_;
			self->modifier_state = CARIBOU_MODIFIER_STATE_LATCHED;
			_tmp2_ = self->priv->xadapter;
			caribou_display_adapter_mod_lock (_tmp2_, (guint) self->priv->mod_mask);
		} else {
			self->modifier_state = CARIBOU_MODIFIER_STATE_NONE;
		}
	}
	_tmp3_ = self->priv->_repeatable;
	if (_tmp3_) {
		CaribouDisplayAdapter* _tmp4_;
		guint _tmp5_;
		_tmp4_ = self->priv->xadapter;
		_tmp5_ = self->priv->_keyval;
		caribou_display_adapter_keyval_press (_tmp4_, _tmp5_);
	} else {
		self->priv->hold_tid = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _caribou_key_model_on_key_held_gsource_func, g_object_ref (self), g_object_unref);
	}
	g_signal_emit_by_name ((CaribouIKeyboardObject*) self, "key-pressed", self);
}

void
caribou_key_model_release (CaribouKeyModel* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->hold_tid != ((guint) 0)) {
		g_source_remove (self->priv->hold_tid);
	}
	_tmp0_ = caribou_key_model_get_is_modifier (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		if (self->modifier_state == CARIBOU_MODIFIER_STATE_NONE) {
			CaribouDisplayAdapter* _tmp2_;
			_tmp2_ = self->priv->xadapter;
			caribou_display_adapter_mod_unlock (_tmp2_, (guint) self->priv->mod_mask);
		} else {
			return;
		}
	}
	_tmp3_ = self->priv->_repeatable;
	if (_tmp3_) {
		CaribouDisplayAdapter* _tmp4_;
		guint _tmp5_;
		_tmp4_ = self->priv->xadapter;
		_tmp5_ = self->priv->_keyval;
		caribou_display_adapter_keyval_release (_tmp4_, _tmp5_);
	} else {
		guint* _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = self->priv->_keyvals;
		_tmp6__length1 = self->priv->_keyvals_length1;
		{
			guint* keyval_collection = NULL;
			gint keyval_collection_length1 = 0;
			gint _keyval_collection_size_ = 0;
			gint keyval_it = 0;
			keyval_collection = _tmp6_;
			keyval_collection_length1 = _tmp6__length1;
			for (keyval_it = 0; keyval_it < keyval_collection_length1; keyval_it = keyval_it + 1) {
				guint keyval = 0U;
				keyval = keyval_collection[keyval_it];
				{
					CaribouDisplayAdapter* _tmp7_;
					CaribouDisplayAdapter* _tmp8_;
					_tmp7_ = self->priv->xadapter;
					caribou_display_adapter_keyval_press (_tmp7_, keyval);
					_tmp8_ = self->priv->xadapter;
					caribou_display_adapter_keyval_release (_tmp8_, keyval);
				}
			}
		}
	}
	g_signal_emit_by_name ((CaribouIKeyboardObject*) self, "key-released", self);
	if (self->priv->hold_tid != ((guint) 0)) {
		g_signal_emit_by_name ((CaribouIKeyboardObject*) self, "key-clicked", self);
		self->priv->hold_tid = (guint) 0;
	} else {
		g_signal_emit (self, caribou_key_model_signals[CARIBOU_KEY_MODEL_KEY_HOLD_END_SIGNAL], 0);
	}
}

static gboolean
caribou_key_model_on_key_held (CaribouKeyModel* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->hold_tid = (guint) 0;
	_tmp0_ = self->priv->extended_keys;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 0) {
		caribou_key_model_set_show_subkeys (self, TRUE);
	}
	_tmp4_ = caribou_key_model_get_is_modifier (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp3_ = self->modifier_state == CARIBOU_MODIFIER_STATE_LATCHED;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		self->modifier_state = CARIBOU_MODIFIER_STATE_LOCKED;
	}
	g_signal_emit (self, caribou_key_model_signals[CARIBOU_KEY_MODEL_KEY_HOLD_SIGNAL], 0);
	result = FALSE;
	return result;
}

CaribouKeyModel**
caribou_key_model_get_extended_keys (CaribouKeyModel* self,
                                     gint* result_length1)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	CaribouKeyModel** _tmp3_;
	gint _tmp3__length1;
	CaribouKeyModel** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->extended_keys;
	_tmp2_ = gee_collection_to_array ((GeeCollection*) _tmp0_, &_tmp1_);
	_tmp3_ = (CaribouKeyModel**) _tmp2_;
	_tmp3__length1 = (_tmp1_ * sizeof (CaribouKeyModel*)) / sizeof (CaribouKeyModel*);
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static CaribouKeyModel**
caribou_key_model_real_get_keys (CaribouIKeyboardObject* base,
                                 gint* result_length1)
{
	CaribouKeyModel * self;
	GeeArrayList* all_keys = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	CaribouKeyModel** _tmp4_;
	gint _tmp4__length1;
	CaribouKeyModel** result;
	self = (CaribouKeyModel*) base;
	_tmp0_ = gee_array_list_new (CARIBOU_TYPE_KEY_MODEL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_keys = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) all_keys, self);
	_tmp1_ = self->priv->extended_keys;
	gee_array_list_add_all (all_keys, (GeeCollection*) _tmp1_);
	_tmp3_ = gee_collection_to_array ((GeeCollection*) all_keys, &_tmp2_);
	_tmp4_ = (CaribouKeyModel**) _tmp3_;
	_tmp4__length1 = (_tmp2_ * sizeof (CaribouKeyModel*)) / sizeof (CaribouKeyModel*);
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (all_keys);
	return result;
}

static CaribouIKeyboardObject**
caribou_key_model_real_get_children (CaribouIKeyboardObject* base,
                                     gint* result_length1)
{
	CaribouKeyModel * self;
	GeeArrayList* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	CaribouIKeyboardObject** _tmp3_;
	gint _tmp3__length1;
	CaribouIKeyboardObject** result;
	self = (CaribouKeyModel*) base;
	_tmp0_ = self->priv->extended_keys;
	_tmp2_ = gee_collection_to_array ((GeeCollection*) _tmp0_, &_tmp1_);
	_tmp3_ = (CaribouIKeyboardObject**) _tmp2_;
	_tmp3__length1 = (_tmp1_ * sizeof (CaribouKeyModel*)) / sizeof (CaribouIKeyboardObject*);
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gboolean
__lambda4_ (CaribouKeyModel* self)
{
	gboolean result;
	caribou_key_model_release (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((CaribouKeyModel*) self);
	return result;
}

void
caribou_key_model_activate (CaribouKeyModel* self)
{
	g_return_if_fail (self != NULL);
	caribou_key_model_press (self);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}

const gchar*
caribou_key_model_get_align (CaribouKeyModel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_align;
	result = _tmp0_;
	return result;
}

void
caribou_key_model_set_align (CaribouKeyModel* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_key_model_get_align (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_align);
		self->priv->_align = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_ALIGN_PROPERTY]);
	}
}

gdouble
caribou_key_model_get_width (CaribouKeyModel* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_width;
	return result;
}

void
caribou_key_model_set_width (CaribouKeyModel* self,
                             gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_key_model_get_width (self);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_WIDTH_PROPERTY]);
	}
}

const gchar*
caribou_key_model_get_toggle (CaribouKeyModel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_toggle;
	result = _tmp0_;
	return result;
}

void
caribou_key_model_set_toggle (CaribouKeyModel* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_key_model_get_toggle (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_toggle);
		self->priv->_toggle = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_TOGGLE_PROPERTY]);
	}
}

gboolean
caribou_key_model_get_repeatable (CaribouKeyModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_repeatable;
	return result;
}

void
caribou_key_model_set_repeatable (CaribouKeyModel* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_key_model_get_repeatable (self);
	if (old_value != value) {
		self->priv->_repeatable = value;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_REPEATABLE_PROPERTY]);
	}
}

gboolean
caribou_key_model_get_is_modifier (CaribouKeyModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->mod_mask != 0;
	return result;
}

void
caribou_key_model_set_is_modifier (CaribouKeyModel* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_IS_MODIFIER_PROPERTY]);
}

gboolean
caribou_key_model_get_show_subkeys (CaribouKeyModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_subkeys;
	return result;
}

static void
caribou_key_model_set_show_subkeys (CaribouKeyModel* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_key_model_get_show_subkeys (self);
	if (old_value != value) {
		self->priv->_show_subkeys = value;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_SHOW_SUBKEYS_PROPERTY]);
	}
}

const gchar*
caribou_key_model_get_name (CaribouKeyModel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
caribou_key_model_set_name (CaribouKeyModel* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_key_model_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_NAME_PROPERTY]);
	}
}

guint
caribou_key_model_get_keyval (CaribouKeyModel* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_keyval;
	return result;
}

static void
caribou_key_model_set_keyval (CaribouKeyModel* self,
                              guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_key_model_get_keyval (self);
	if (old_value != value) {
		self->priv->_keyval = value;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_KEYVAL_PROPERTY]);
	}
}

const gchar*
caribou_key_model_get_text (CaribouKeyModel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
caribou_key_model_set_text (CaribouKeyModel* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_key_model_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_TEXT_PROPERTY]);
	}
}

const gchar*
caribou_key_model_get_label (CaribouKeyModel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
caribou_key_model_set_label (CaribouKeyModel* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = caribou_key_model_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_LABEL_PROPERTY]);
	}
}

static gboolean
caribou_key_model_real_get_scan_stepping (CaribouIScannableItem* base)
{
	gboolean result;
	CaribouKeyModel* self;
	self = (CaribouKeyModel*) base;
	result = self->priv->_scan_stepping;
	return result;
}

static void
caribou_key_model_real_set_scan_stepping (CaribouIScannableItem* base,
                                          gboolean value)
{
	CaribouKeyModel* self;
	gboolean old_value;
	self = (CaribouKeyModel*) base;
	old_value = caribou_key_model_real_get_scan_stepping (base);
	if (old_value != value) {
		self->priv->_scan_stepping = value;
		g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_SCAN_STEPPING_PROPERTY]);
	}
}

static gboolean
caribou_key_model_real_get_scan_selected (CaribouIScannableItem* base)
{
	gboolean result;
	CaribouKeyModel* self;
	self = (CaribouKeyModel*) base;
	result = self->priv->_scan_selected;
	return result;
}

static void
caribou_key_model_real_set_scan_selected (CaribouIScannableItem* base,
                                          gboolean value)
{
	CaribouKeyModel* self;
	self = (CaribouKeyModel*) base;
	self->priv->_scan_selected = value;
	if (self->priv->_scan_selected) {
		caribou_key_model_activate (self);
	}
	g_object_notify_by_pspec ((GObject *) self, caribou_key_model_properties[CARIBOU_KEY_MODEL_SCAN_SELECTED_PROPERTY]);
}

static void
caribou_key_model_class_init (CaribouKeyModelClass * klass,
                              gpointer klass_data)
{
	caribou_key_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CaribouKeyModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_caribou_key_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_caribou_key_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = caribou_key_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_ALIGN_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_ALIGN_PROPERTY] = g_param_spec_string ("align", "align", "align", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_WIDTH_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_WIDTH_PROPERTY] = g_param_spec_double ("width", "width", "width", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_TOGGLE_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_TOGGLE_PROPERTY] = g_param_spec_string ("toggle", "toggle", "toggle", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_REPEATABLE_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_REPEATABLE_PROPERTY] = g_param_spec_boolean ("repeatable", "repeatable", "repeatable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_IS_MODIFIER_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_IS_MODIFIER_PROPERTY] = g_param_spec_boolean ("is-modifier", "is-modifier", "is-modifier", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_SHOW_SUBKEYS_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_SHOW_SUBKEYS_PROPERTY] = g_param_spec_boolean ("show-subkeys", "show-subkeys", "show-subkeys", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_NAME_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_KEYVAL_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_KEYVAL_PROPERTY] = g_param_spec_uint ("keyval", "keyval", "keyval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_TEXT_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_LABEL_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_SCAN_STEPPING_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_SCAN_STEPPING_PROPERTY] = g_param_spec_boolean ("scan-stepping", "scan-stepping", "scan-stepping", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CARIBOU_KEY_MODEL_SCAN_SELECTED_PROPERTY, caribou_key_model_properties[CARIBOU_KEY_MODEL_SCAN_SELECTED_PROPERTY] = g_param_spec_boolean ("scan-selected", "scan-selected", "scan-selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	caribou_key_model_signals[CARIBOU_KEY_MODEL_KEY_HOLD_END_SIGNAL] = g_signal_new ("key-hold-end", CARIBOU_TYPE_KEY_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	caribou_key_model_signals[CARIBOU_KEY_MODEL_KEY_HOLD_SIGNAL] = g_signal_new ("key-hold", CARIBOU_TYPE_KEY_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
caribou_key_model_caribou_iscannable_item_interface_init (CaribouIScannableItemIface * iface,
                                                          gpointer iface_data)
{
	caribou_key_model_caribou_iscannable_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_scan_stepping = caribou_key_model_real_get_scan_stepping;
	iface->set_scan_stepping = caribou_key_model_real_set_scan_stepping;
	iface->get_scan_selected = caribou_key_model_real_get_scan_selected;
	iface->set_scan_selected = caribou_key_model_real_set_scan_selected;
}

static void
caribou_key_model_caribou_ikeyboard_object_interface_init (CaribouIKeyboardObjectIface * iface,
                                                           gpointer iface_data)
{
	caribou_key_model_caribou_ikeyboard_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_keys = (CaribouKeyModel** (*) (CaribouIKeyboardObject*, gint*)) caribou_key_model_real_get_keys;
	iface->get_children = (CaribouIKeyboardObject** (*) (CaribouIKeyboardObject*, gint*)) caribou_key_model_real_get_children;
}

static void
caribou_key_model_instance_init (CaribouKeyModel * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	guint* _tmp2_;
	gchar* _tmp3_;
	self->priv = caribou_key_model_get_instance_private (self);
	_tmp0_ = g_strdup ("center");
	self->priv->_align = _tmp0_;
	self->priv->_width = 1.0;
	_tmp1_ = g_strdup ("");
	self->priv->_toggle = _tmp1_;
	self->priv->_repeatable = FALSE;
	self->priv->_show_subkeys = FALSE;
	self->priv->_text = NULL;
	_tmp2_ = g_new0 (guint, 0);
	self->priv->_keyvals = _tmp2_;
	self->priv->_keyvals_length1 = 0;
	self->priv->__keyvals_size_ = self->priv->_keyvals_length1;
	_tmp3_ = g_strdup ("");
	self->priv->_label = _tmp3_;
}

static void
caribou_key_model_finalize (GObject * obj)
{
	CaribouKeyModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CARIBOU_TYPE_KEY_MODEL, CaribouKeyModel);
	_g_free0 (self->priv->_align);
	_g_free0 (self->priv->_toggle);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_text);
	self->priv->_keyvals = (g_free (self->priv->_keyvals), NULL);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->xadapter);
	_g_object_unref0 (self->priv->extended_keys);
	G_OBJECT_CLASS (caribou_key_model_parent_class)->finalize (obj);
}

/**
     * Object representing a key in a column.
     *
     * This is used for implementing custom keyboard service.
     */
static GType
caribou_key_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CaribouKeyModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) caribou_key_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaribouKeyModel), 0, (GInstanceInitFunc) caribou_key_model_instance_init, NULL };
	static const GInterfaceInfo caribou_iscannable_item_info = { (GInterfaceInitFunc) caribou_key_model_caribou_iscannable_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo caribou_ikeyboard_object_info = { (GInterfaceInitFunc) caribou_key_model_caribou_ikeyboard_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType caribou_key_model_type_id;
	caribou_key_model_type_id = g_type_register_static (G_TYPE_OBJECT, "CaribouKeyModel", &g_define_type_info, 0);
	g_type_add_interface_static (caribou_key_model_type_id, CARIBOU_TYPE_ISCANNABLE_ITEM, &caribou_iscannable_item_info);
	g_type_add_interface_static (caribou_key_model_type_id, CARIBOU_TYPE_IKEYBOARD_OBJECT, &caribou_ikeyboard_object_info);
	CaribouKeyModel_private_offset = g_type_add_instance_private (caribou_key_model_type_id, sizeof (CaribouKeyModelPrivate));
	return caribou_key_model_type_id;
}

GType
caribou_key_model_get_type (void)
{
	static volatile gsize caribou_key_model_type_id__once = 0;
	if (g_once_init_enter (&caribou_key_model_type_id__once)) {
		GType caribou_key_model_type_id;
		caribou_key_model_type_id = caribou_key_model_get_type_once ();
		g_once_init_leave (&caribou_key_model_type_id__once, caribou_key_model_type_id);
	}
	return caribou_key_model_type_id__once;
}

static void
_vala_caribou_key_model_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	CaribouKeyModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CARIBOU_TYPE_KEY_MODEL, CaribouKeyModel);
	switch (property_id) {
		case CARIBOU_KEY_MODEL_ALIGN_PROPERTY:
		g_value_set_string (value, caribou_key_model_get_align (self));
		break;
		case CARIBOU_KEY_MODEL_WIDTH_PROPERTY:
		g_value_set_double (value, caribou_key_model_get_width (self));
		break;
		case CARIBOU_KEY_MODEL_TOGGLE_PROPERTY:
		g_value_set_string (value, caribou_key_model_get_toggle (self));
		break;
		case CARIBOU_KEY_MODEL_REPEATABLE_PROPERTY:
		g_value_set_boolean (value, caribou_key_model_get_repeatable (self));
		break;
		case CARIBOU_KEY_MODEL_IS_MODIFIER_PROPERTY:
		g_value_set_boolean (value, caribou_key_model_get_is_modifier (self));
		break;
		case CARIBOU_KEY_MODEL_SHOW_SUBKEYS_PROPERTY:
		g_value_set_boolean (value, caribou_key_model_get_show_subkeys (self));
		break;
		case CARIBOU_KEY_MODEL_NAME_PROPERTY:
		g_value_set_string (value, caribou_key_model_get_name (self));
		break;
		case CARIBOU_KEY_MODEL_KEYVAL_PROPERTY:
		g_value_set_uint (value, caribou_key_model_get_keyval (self));
		break;
		case CARIBOU_KEY_MODEL_TEXT_PROPERTY:
		g_value_set_string (value, caribou_key_model_get_text (self));
		break;
		case CARIBOU_KEY_MODEL_LABEL_PROPERTY:
		g_value_set_string (value, caribou_key_model_get_label (self));
		break;
		case CARIBOU_KEY_MODEL_SCAN_STEPPING_PROPERTY:
		g_value_set_boolean (value, caribou_iscannable_item_get_scan_stepping ((CaribouIScannableItem*) self));
		break;
		case CARIBOU_KEY_MODEL_SCAN_SELECTED_PROPERTY:
		g_value_set_boolean (value, caribou_iscannable_item_get_scan_selected ((CaribouIScannableItem*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_caribou_key_model_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	CaribouKeyModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CARIBOU_TYPE_KEY_MODEL, CaribouKeyModel);
	switch (property_id) {
		case CARIBOU_KEY_MODEL_ALIGN_PROPERTY:
		caribou_key_model_set_align (self, g_value_get_string (value));
		break;
		case CARIBOU_KEY_MODEL_WIDTH_PROPERTY:
		caribou_key_model_set_width (self, g_value_get_double (value));
		break;
		case CARIBOU_KEY_MODEL_TOGGLE_PROPERTY:
		caribou_key_model_set_toggle (self, g_value_get_string (value));
		break;
		case CARIBOU_KEY_MODEL_REPEATABLE_PROPERTY:
		caribou_key_model_set_repeatable (self, g_value_get_boolean (value));
		break;
		case CARIBOU_KEY_MODEL_IS_MODIFIER_PROPERTY:
		caribou_key_model_set_is_modifier (self, g_value_get_boolean (value));
		break;
		case CARIBOU_KEY_MODEL_SHOW_SUBKEYS_PROPERTY:
		caribou_key_model_set_show_subkeys (self, g_value_get_boolean (value));
		break;
		case CARIBOU_KEY_MODEL_NAME_PROPERTY:
		caribou_key_model_set_name (self, g_value_get_string (value));
		break;
		case CARIBOU_KEY_MODEL_KEYVAL_PROPERTY:
		caribou_key_model_set_keyval (self, g_value_get_uint (value));
		break;
		case CARIBOU_KEY_MODEL_TEXT_PROPERTY:
		caribou_key_model_set_text (self, g_value_get_string (value));
		break;
		case CARIBOU_KEY_MODEL_LABEL_PROPERTY:
		caribou_key_model_set_label (self, g_value_get_string (value));
		break;
		case CARIBOU_KEY_MODEL_SCAN_STEPPING_PROPERTY:
		caribou_iscannable_item_set_scan_stepping ((CaribouIScannableItem*) self, g_value_get_boolean (value));
		break;
		case CARIBOU_KEY_MODEL_SCAN_SELECTED_PROPERTY:
		caribou_iscannable_item_set_scan_selected ((CaribouIScannableItem*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
caribou_modifier_state_get_type_once (void)
{
	static const GEnumValue values[] = {{CARIBOU_MODIFIER_STATE_NONE, "CARIBOU_MODIFIER_STATE_NONE", "none"}, {CARIBOU_MODIFIER_STATE_LATCHED, "CARIBOU_MODIFIER_STATE_LATCHED", "latched"}, {CARIBOU_MODIFIER_STATE_LOCKED, "CARIBOU_MODIFIER_STATE_LOCKED", "locked"}, {0, NULL, NULL}};
	GType caribou_modifier_state_type_id;
	caribou_modifier_state_type_id = g_enum_register_static ("CaribouModifierState", values);
	return caribou_modifier_state_type_id;
}

GType
caribou_modifier_state_get_type (void)
{
	static volatile gsize caribou_modifier_state_type_id__once = 0;
	if (g_once_init_enter (&caribou_modifier_state_type_id__once)) {
		GType caribou_modifier_state_type_id;
		caribou_modifier_state_type_id = caribou_modifier_state_get_type_once ();
		g_once_init_leave (&caribou_modifier_state_type_id__once, caribou_modifier_state_type_id);
	}
	return caribou_modifier_state_type_id__once;
}

void
caribou_modifier_map_entry_copy (const CaribouModifierMapEntry* self,
                                 CaribouModifierMapEntry* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	(*dest).mask = (*self).mask;
}

void
caribou_modifier_map_entry_destroy (CaribouModifierMapEntry* self)
{
	_g_free0 ((*self).name);
}

CaribouModifierMapEntry*
caribou_modifier_map_entry_dup (const CaribouModifierMapEntry* self)
{
	CaribouModifierMapEntry* dup;
	dup = g_new0 (CaribouModifierMapEntry, 1);
	caribou_modifier_map_entry_copy (self, dup);
	return dup;
}

void
caribou_modifier_map_entry_free (CaribouModifierMapEntry* self)
{
	caribou_modifier_map_entry_destroy (self);
	g_free (self);
}

static GType
caribou_modifier_map_entry_get_type_once (void)
{
	GType caribou_modifier_map_entry_type_id;
	caribou_modifier_map_entry_type_id = g_boxed_type_register_static ("CaribouModifierMapEntry", (GBoxedCopyFunc) caribou_modifier_map_entry_dup, (GBoxedFreeFunc) caribou_modifier_map_entry_free);
	return caribou_modifier_map_entry_type_id;
}

GType
caribou_modifier_map_entry_get_type (void)
{
	static volatile gsize caribou_modifier_map_entry_type_id__once = 0;
	if (g_once_init_enter (&caribou_modifier_map_entry_type_id__once)) {
		GType caribou_modifier_map_entry_type_id;
		caribou_modifier_map_entry_type_id = caribou_modifier_map_entry_get_type_once ();
		g_once_init_leave (&caribou_modifier_map_entry_type_id__once, caribou_modifier_map_entry_type_id);
	}
	return caribou_modifier_map_entry_type_id__once;
}

void
caribou_label_map_entry_copy (const CaribouLabelMapEntry* self,
                              CaribouLabelMapEntry* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).label;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp3_;
}

void
caribou_label_map_entry_destroy (CaribouLabelMapEntry* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).label);
}

CaribouLabelMapEntry*
caribou_label_map_entry_dup (const CaribouLabelMapEntry* self)
{
	CaribouLabelMapEntry* dup;
	dup = g_new0 (CaribouLabelMapEntry, 1);
	caribou_label_map_entry_copy (self, dup);
	return dup;
}

void
caribou_label_map_entry_free (CaribouLabelMapEntry* self)
{
	caribou_label_map_entry_destroy (self);
	g_free (self);
}

static GType
caribou_label_map_entry_get_type_once (void)
{
	GType caribou_label_map_entry_type_id;
	caribou_label_map_entry_type_id = g_boxed_type_register_static ("CaribouLabelMapEntry", (GBoxedCopyFunc) caribou_label_map_entry_dup, (GBoxedFreeFunc) caribou_label_map_entry_free);
	return caribou_label_map_entry_type_id;
}

GType
caribou_label_map_entry_get_type (void)
{
	static volatile gsize caribou_label_map_entry_type_id__once = 0;
	if (g_once_init_enter (&caribou_label_map_entry_type_id__once)) {
		GType caribou_label_map_entry_type_id;
		caribou_label_map_entry_type_id = caribou_label_map_entry_get_type_once ();
		g_once_init_leave (&caribou_label_map_entry_type_id__once, caribou_label_map_entry_type_id);
	}
	return caribou_label_map_entry_type_id__once;
}

