/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__ARITH_H
#define CVC4__OPTIONS__ARITH_H

#include "options/options.h"




#define CVC4_OPTIONS__ARITH__FOR_OPTION_HOLDER \
  maxApproxDepth__option_t::type maxApproxDepth;\
  bool maxApproxDepth__setByUser__; \
  brabTest__option_t::type brabTest;\
  bool brabTest__setByUser__; \
  arithNoPartialFun__option_t::type arithNoPartialFun;\
  bool arithNoPartialFun__setByUser__; \
  arithPropAsLemmaLength__option_t::type arithPropAsLemmaLength;\
  bool arithPropAsLemmaLength__setByUser__; \
  arithPropagationMode__option_t::type arithPropagationMode;\
  bool arithPropagationMode__setByUser__; \
  arithRewriteEq__option_t::type arithRewriteEq;\
  bool arithRewriteEq__setByUser__; \
  collectPivots__option_t::type collectPivots;\
  bool collectPivots__setByUser__; \
  doCutAllBounded__option_t::type doCutAllBounded;\
  bool doCutAllBounded__setByUser__; \
  exportDioDecompositions__option_t::type exportDioDecompositions;\
  bool exportDioDecompositions__setByUser__; \
  dioRepeat__option_t::type dioRepeat;\
  bool dioRepeat__setByUser__; \
  arithDioSolver__option_t::type arithDioSolver;\
  bool arithDioSolver__setByUser__; \
  dioSolverTurns__option_t::type dioSolverTurns;\
  bool dioSolverTurns__setByUser__; \
  arithErrorSelectionRule__option_t::type arithErrorSelectionRule;\
  bool arithErrorSelectionRule__setByUser__; \
  havePenalties__option_t::type havePenalties;\
  bool havePenalties__setByUser__; \
  arithHeuristicPivots__option_t::type arithHeuristicPivots;\
  bool arithHeuristicPivots__setByUser__; \
  replayFailureLemma__option_t::type replayFailureLemma;\
  bool replayFailureLemma__setByUser__; \
  maxCutsInContext__option_t::type maxCutsInContext;\
  bool maxCutsInContext__setByUser__; \
  arithMLTrick__option_t::type arithMLTrick;\
  bool arithMLTrick__setByUser__; \
  arithMLTrickSubstitutions__option_t::type arithMLTrickSubstitutions;\
  bool arithMLTrickSubstitutions__setByUser__; \
  newProp__option_t::type newProp;\
  bool newProp__setByUser__; \
  nlExt__option_t::type nlExt;\
  bool nlExt__setByUser__; \
  nlExtEntailConflicts__option_t::type nlExtEntailConflicts;\
  bool nlExtEntailConflicts__setByUser__; \
  nlExtFactor__option_t::type nlExtFactor;\
  bool nlExtFactor__setByUser__; \
  nlExtIncPrecision__option_t::type nlExtIncPrecision;\
  bool nlExtIncPrecision__setByUser__; \
  nlExtPurify__option_t::type nlExtPurify;\
  bool nlExtPurify__setByUser__; \
  nlExtResBound__option_t::type nlExtResBound;\
  bool nlExtResBound__setByUser__; \
  nlExtRewrites__option_t::type nlExtRewrites;\
  bool nlExtRewrites__setByUser__; \
  nlExtSplitZero__option_t::type nlExtSplitZero;\
  bool nlExtSplitZero__setByUser__; \
  nlExtTfTaylorDegree__option_t::type nlExtTfTaylorDegree;\
  bool nlExtTfTaylorDegree__setByUser__; \
  nlExtTfTangentPlanes__option_t::type nlExtTfTangentPlanes;\
  bool nlExtTfTangentPlanes__setByUser__; \
  nlExtTangentPlanes__option_t::type nlExtTangentPlanes;\
  bool nlExtTangentPlanes__setByUser__; \
  nlExtTangentPlanesInterleave__option_t::type nlExtTangentPlanesInterleave;\
  bool nlExtTangentPlanesInterleave__setByUser__; \
  pbRewrites__option_t::type pbRewrites;\
  bool pbRewrites__setByUser__; \
  arithPivotThreshold__option_t::type arithPivotThreshold;\
  bool arithPivotThreshold__setByUser__; \
  ppAssertMaxSubSize__option_t::type ppAssertMaxSubSize;\
  bool ppAssertMaxSubSize__setByUser__; \
  arithPropagateMaxLength__option_t::type arithPropagateMaxLength;\
  bool arithPropagateMaxLength__setByUser__; \
  replayEarlyCloseDepths__option_t::type replayEarlyCloseDepths;\
  bool replayEarlyCloseDepths__setByUser__; \
  replayFailurePenalty__option_t::type replayFailurePenalty;\
  bool replayFailurePenalty__setByUser__; \
  lemmaRejectCutSize__option_t::type lemmaRejectCutSize;\
  bool lemmaRejectCutSize__setByUser__; \
  replayNumericFailurePenalty__option_t::type replayNumericFailurePenalty;\
  bool replayNumericFailurePenalty__setByUser__; \
  replayRejectCutSize__option_t::type replayRejectCutSize;\
  bool replayRejectCutSize__setByUser__; \
  soiApproxMajorFailurePen__option_t::type soiApproxMajorFailurePen;\
  bool soiApproxMajorFailurePen__setByUser__; \
  soiApproxMajorFailure__option_t::type soiApproxMajorFailure;\
  bool soiApproxMajorFailure__setByUser__; \
  soiApproxMinorFailurePen__option_t::type soiApproxMinorFailurePen;\
  bool soiApproxMinorFailurePen__setByUser__; \
  soiApproxMinorFailure__option_t::type soiApproxMinorFailure;\
  bool soiApproxMinorFailure__setByUser__; \
  restrictedPivots__option_t::type restrictedPivots;\
  bool restrictedPivots__setByUser__; \
  revertArithModels__option_t::type revertArithModels;\
  bool revertArithModels__setByUser__; \
  rrTurns__option_t::type rrTurns;\
  bool rrTurns__setByUser__; \
  trySolveIntStandardEffort__option_t::type trySolveIntStandardEffort;\
  bool trySolveIntStandardEffort__setByUser__; \
  arithSimplexCheckPeriod__option_t::type arithSimplexCheckPeriod;\
  bool arithSimplexCheckPeriod__setByUser__; \
  soiQuickExplain__option_t::type soiQuickExplain;\
  bool soiQuickExplain__setByUser__; \
  arithStandardCheckVarOrderPivots__option_t::type arithStandardCheckVarOrderPivots;\
  bool arithStandardCheckVarOrderPivots__setByUser__; \
  arithUnateLemmaMode__option_t::type arithUnateLemmaMode;\
  bool arithUnateLemmaMode__setByUser__; \
  useApprox__option_t::type useApprox;\
  bool useApprox__setByUser__; \
  useFC__option_t::type useFC;\
  bool useFC__setByUser__; \
  useSOI__option_t::type useSOI;\
  bool useSOI__setByUser__;


namespace CVC4 {

namespace options {


enum class ArithPropagationMode
{
  NO_PROP,
  UNATE_PROP,
  BOUND_INFERENCE_PROP,
  BOTH_PROP
};
std::ostream&
operator<<(std::ostream& os, ArithPropagationMode mode) CVC4_PUBLIC;
ArithPropagationMode
stringToArithPropagationMode(const std::string& option, const std::string& optarg);
enum class ErrorSelectionRule
{
  MINIMUM_AMOUNT,
  VAR_ORDER,
  MAXIMUM_AMOUNT,
  SUM_METRIC
};
std::ostream&
operator<<(std::ostream& os, ErrorSelectionRule mode) CVC4_PUBLIC;
ErrorSelectionRule
stringToErrorSelectionRule(const std::string& option, const std::string& optarg);
enum class ArithUnateLemmaMode
{
  ALL,
  EQUALITY,
  INEQUALITY,
  NO
};
std::ostream&
operator<<(std::ostream& os, ArithUnateLemmaMode mode) CVC4_PUBLIC;
ArithUnateLemmaMode
stringToArithUnateLemmaMode(const std::string& option, const std::string& optarg);

extern struct CVC4_PUBLIC maxApproxDepth__option_t
{
  typedef int16_t type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} maxApproxDepth CVC4_PUBLIC;
extern struct CVC4_PUBLIC brabTest__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} brabTest CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithNoPartialFun__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} arithNoPartialFun CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithPropAsLemmaLength__option_t
{
  typedef uint16_t type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arithPropAsLemmaLength CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithPropagationMode__option_t
{
  typedef ArithPropagationMode type;
  type operator()() const;
  bool wasSetByUser() const;
} arithPropagationMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithRewriteEq__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arithRewriteEq CVC4_PUBLIC;
extern struct CVC4_PUBLIC collectPivots__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} collectPivots CVC4_PUBLIC;
extern struct CVC4_PUBLIC doCutAllBounded__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} doCutAllBounded CVC4_PUBLIC;
extern struct CVC4_PUBLIC exportDioDecompositions__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} exportDioDecompositions CVC4_PUBLIC;
extern struct CVC4_PUBLIC dioRepeat__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dioRepeat CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithDioSolver__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} arithDioSolver CVC4_PUBLIC;
extern struct CVC4_PUBLIC dioSolverTurns__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} dioSolverTurns CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithErrorSelectionRule__option_t
{
  typedef ErrorSelectionRule type;
  type operator()() const;
  bool wasSetByUser() const;
} arithErrorSelectionRule CVC4_PUBLIC;
extern struct CVC4_PUBLIC havePenalties__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} havePenalties CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithHeuristicPivots__option_t
{
  typedef int16_t type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arithHeuristicPivots CVC4_PUBLIC;
extern struct CVC4_PUBLIC replayFailureLemma__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} replayFailureLemma CVC4_PUBLIC;
extern struct CVC4_PUBLIC maxCutsInContext__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} maxCutsInContext CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithMLTrick__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arithMLTrick CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithMLTrickSubstitutions__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} arithMLTrickSubstitutions CVC4_PUBLIC;
extern struct CVC4_PUBLIC newProp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} newProp CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExt CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtEntailConflicts__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExtEntailConflicts CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtFactor__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExtFactor CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtIncPrecision__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExtIncPrecision CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtPurify__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExtPurify CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtResBound__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExtResBound CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtRewrites__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExtRewrites CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtSplitZero__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExtSplitZero CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtTfTaylorDegree__option_t
{
  typedef int16_t type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} nlExtTfTaylorDegree CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtTfTangentPlanes__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExtTfTangentPlanes CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtTangentPlanes__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} nlExtTangentPlanes CVC4_PUBLIC;
extern struct CVC4_PUBLIC nlExtTangentPlanesInterleave__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} nlExtTangentPlanesInterleave CVC4_PUBLIC;
extern struct CVC4_PUBLIC pbRewrites__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} pbRewrites CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithPivotThreshold__option_t
{
  typedef uint16_t type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arithPivotThreshold CVC4_PUBLIC;
extern struct CVC4_PUBLIC ppAssertMaxSubSize__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} ppAssertMaxSubSize CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithPropagateMaxLength__option_t
{
  typedef uint16_t type;
  type operator()() const;
  bool wasSetByUser() const;
} arithPropagateMaxLength CVC4_PUBLIC;
extern struct CVC4_PUBLIC replayEarlyCloseDepths__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} replayEarlyCloseDepths CVC4_PUBLIC;
extern struct CVC4_PUBLIC replayFailurePenalty__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} replayFailurePenalty CVC4_PUBLIC;
extern struct CVC4_PUBLIC lemmaRejectCutSize__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} lemmaRejectCutSize CVC4_PUBLIC;
extern struct CVC4_PUBLIC replayNumericFailurePenalty__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} replayNumericFailurePenalty CVC4_PUBLIC;
extern struct CVC4_PUBLIC replayRejectCutSize__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} replayRejectCutSize CVC4_PUBLIC;
extern struct CVC4_PUBLIC soiApproxMajorFailurePen__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} soiApproxMajorFailurePen CVC4_PUBLIC;
extern struct CVC4_PUBLIC soiApproxMajorFailure__option_t
{
  typedef double type;
  type operator()() const;
  bool wasSetByUser() const;
} soiApproxMajorFailure CVC4_PUBLIC;
extern struct CVC4_PUBLIC soiApproxMinorFailurePen__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} soiApproxMinorFailurePen CVC4_PUBLIC;
extern struct CVC4_PUBLIC soiApproxMinorFailure__option_t
{
  typedef double type;
  type operator()() const;
  bool wasSetByUser() const;
} soiApproxMinorFailure CVC4_PUBLIC;
extern struct CVC4_PUBLIC restrictedPivots__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} restrictedPivots CVC4_PUBLIC;
extern struct CVC4_PUBLIC revertArithModels__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} revertArithModels CVC4_PUBLIC;
extern struct CVC4_PUBLIC rrTurns__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} rrTurns CVC4_PUBLIC;
extern struct CVC4_PUBLIC trySolveIntStandardEffort__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} trySolveIntStandardEffort CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithSimplexCheckPeriod__option_t
{
  typedef uint16_t type;
  type operator()() const;
  bool wasSetByUser() const;
} arithSimplexCheckPeriod CVC4_PUBLIC;
extern struct CVC4_PUBLIC soiQuickExplain__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} soiQuickExplain CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithStandardCheckVarOrderPivots__option_t
{
  typedef int16_t type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arithStandardCheckVarOrderPivots CVC4_PUBLIC;
extern struct CVC4_PUBLIC arithUnateLemmaMode__option_t
{
  typedef ArithUnateLemmaMode type;
  type operator()() const;
  bool wasSetByUser() const;
} arithUnateLemmaMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC useApprox__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} useApprox CVC4_PUBLIC;
extern struct CVC4_PUBLIC useFC__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} useFC CVC4_PUBLIC;
extern struct CVC4_PUBLIC useSOI__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} useSOI CVC4_PUBLIC;

}  // namespace options

template <> void Options::set(
    options::maxApproxDepth__option_t,
    const options::maxApproxDepth__option_t::type& x);
template <> const options::maxApproxDepth__option_t::type& Options::operator[](
    options::maxApproxDepth__option_t) const;
template <> bool Options::wasSetByUser(options::maxApproxDepth__option_t) const;
template <> void Options::assign(
    options::maxApproxDepth__option_t,
    std::string option,
    std::string value);
template <> const options::brabTest__option_t::type& Options::operator[](
    options::brabTest__option_t) const;
template <> bool Options::wasSetByUser(options::brabTest__option_t) const;
template <> void Options::assignBool(
    options::brabTest__option_t,
    std::string option,
    bool value);
template <> const options::arithNoPartialFun__option_t::type& Options::operator[](
    options::arithNoPartialFun__option_t) const;
template <> bool Options::wasSetByUser(options::arithNoPartialFun__option_t) const;
template <> void Options::assignBool(
    options::arithNoPartialFun__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arithPropAsLemmaLength__option_t,
    const options::arithPropAsLemmaLength__option_t::type& x);
template <> const options::arithPropAsLemmaLength__option_t::type& Options::operator[](
    options::arithPropAsLemmaLength__option_t) const;
template <> bool Options::wasSetByUser(options::arithPropAsLemmaLength__option_t) const;
template <> void Options::assign(
    options::arithPropAsLemmaLength__option_t,
    std::string option,
    std::string value);
template <> const options::arithPropagationMode__option_t::type& Options::operator[](
    options::arithPropagationMode__option_t) const;
template <> bool Options::wasSetByUser(options::arithPropagationMode__option_t) const;
template <> void Options::assign(
    options::arithPropagationMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::arithRewriteEq__option_t,
    const options::arithRewriteEq__option_t::type& x);
template <> const options::arithRewriteEq__option_t::type& Options::operator[](
    options::arithRewriteEq__option_t) const;
template <> bool Options::wasSetByUser(options::arithRewriteEq__option_t) const;
template <> void Options::assignBool(
    options::arithRewriteEq__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::collectPivots__option_t,
    const options::collectPivots__option_t::type& x);
template <> const options::collectPivots__option_t::type& Options::operator[](
    options::collectPivots__option_t) const;
template <> bool Options::wasSetByUser(options::collectPivots__option_t) const;
template <> void Options::assignBool(
    options::collectPivots__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::doCutAllBounded__option_t,
    const options::doCutAllBounded__option_t::type& x);
template <> const options::doCutAllBounded__option_t::type& Options::operator[](
    options::doCutAllBounded__option_t) const;
template <> bool Options::wasSetByUser(options::doCutAllBounded__option_t) const;
template <> void Options::assignBool(
    options::doCutAllBounded__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::exportDioDecompositions__option_t,
    const options::exportDioDecompositions__option_t::type& x);
template <> const options::exportDioDecompositions__option_t::type& Options::operator[](
    options::exportDioDecompositions__option_t) const;
template <> bool Options::wasSetByUser(options::exportDioDecompositions__option_t) const;
template <> void Options::assignBool(
    options::exportDioDecompositions__option_t,
    std::string option,
    bool value);
template <> const options::dioRepeat__option_t::type& Options::operator[](
    options::dioRepeat__option_t) const;
template <> bool Options::wasSetByUser(options::dioRepeat__option_t) const;
template <> void Options::assignBool(
    options::dioRepeat__option_t,
    std::string option,
    bool value);
template <> const options::arithDioSolver__option_t::type& Options::operator[](
    options::arithDioSolver__option_t) const;
template <> bool Options::wasSetByUser(options::arithDioSolver__option_t) const;
template <> void Options::assignBool(
    options::arithDioSolver__option_t,
    std::string option,
    bool value);
template <> const options::dioSolverTurns__option_t::type& Options::operator[](
    options::dioSolverTurns__option_t) const;
template <> bool Options::wasSetByUser(options::dioSolverTurns__option_t) const;
template <> void Options::assign(
    options::dioSolverTurns__option_t,
    std::string option,
    std::string value);
template <> const options::arithErrorSelectionRule__option_t::type& Options::operator[](
    options::arithErrorSelectionRule__option_t) const;
template <> bool Options::wasSetByUser(options::arithErrorSelectionRule__option_t) const;
template <> void Options::assign(
    options::arithErrorSelectionRule__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::havePenalties__option_t,
    const options::havePenalties__option_t::type& x);
template <> const options::havePenalties__option_t::type& Options::operator[](
    options::havePenalties__option_t) const;
template <> bool Options::wasSetByUser(options::havePenalties__option_t) const;
template <> void Options::assignBool(
    options::havePenalties__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arithHeuristicPivots__option_t,
    const options::arithHeuristicPivots__option_t::type& x);
template <> const options::arithHeuristicPivots__option_t::type& Options::operator[](
    options::arithHeuristicPivots__option_t) const;
template <> bool Options::wasSetByUser(options::arithHeuristicPivots__option_t) const;
template <> void Options::assign(
    options::arithHeuristicPivots__option_t,
    std::string option,
    std::string value);
template <> const options::replayFailureLemma__option_t::type& Options::operator[](
    options::replayFailureLemma__option_t) const;
template <> bool Options::wasSetByUser(options::replayFailureLemma__option_t) const;
template <> void Options::assignBool(
    options::replayFailureLemma__option_t,
    std::string option,
    bool value);
template <> const options::maxCutsInContext__option_t::type& Options::operator[](
    options::maxCutsInContext__option_t) const;
template <> bool Options::wasSetByUser(options::maxCutsInContext__option_t) const;
template <> void Options::assign(
    options::maxCutsInContext__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::arithMLTrick__option_t,
    const options::arithMLTrick__option_t::type& x);
template <> const options::arithMLTrick__option_t::type& Options::operator[](
    options::arithMLTrick__option_t) const;
template <> bool Options::wasSetByUser(options::arithMLTrick__option_t) const;
template <> void Options::assignBool(
    options::arithMLTrick__option_t,
    std::string option,
    bool value);
template <> const options::arithMLTrickSubstitutions__option_t::type& Options::operator[](
    options::arithMLTrickSubstitutions__option_t) const;
template <> bool Options::wasSetByUser(options::arithMLTrickSubstitutions__option_t) const;
template <> void Options::assign(
    options::arithMLTrickSubstitutions__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::newProp__option_t,
    const options::newProp__option_t::type& x);
template <> const options::newProp__option_t::type& Options::operator[](
    options::newProp__option_t) const;
template <> bool Options::wasSetByUser(options::newProp__option_t) const;
template <> void Options::assignBool(
    options::newProp__option_t,
    std::string option,
    bool value);
template <> const options::nlExt__option_t::type& Options::operator[](
    options::nlExt__option_t) const;
template <> bool Options::wasSetByUser(options::nlExt__option_t) const;
template <> void Options::assignBool(
    options::nlExt__option_t,
    std::string option,
    bool value);
template <> const options::nlExtEntailConflicts__option_t::type& Options::operator[](
    options::nlExtEntailConflicts__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtEntailConflicts__option_t) const;
template <> void Options::assignBool(
    options::nlExtEntailConflicts__option_t,
    std::string option,
    bool value);
template <> const options::nlExtFactor__option_t::type& Options::operator[](
    options::nlExtFactor__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtFactor__option_t) const;
template <> void Options::assignBool(
    options::nlExtFactor__option_t,
    std::string option,
    bool value);
template <> const options::nlExtIncPrecision__option_t::type& Options::operator[](
    options::nlExtIncPrecision__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtIncPrecision__option_t) const;
template <> void Options::assignBool(
    options::nlExtIncPrecision__option_t,
    std::string option,
    bool value);
template <> const options::nlExtPurify__option_t::type& Options::operator[](
    options::nlExtPurify__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtPurify__option_t) const;
template <> void Options::assignBool(
    options::nlExtPurify__option_t,
    std::string option,
    bool value);
template <> const options::nlExtResBound__option_t::type& Options::operator[](
    options::nlExtResBound__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtResBound__option_t) const;
template <> void Options::assignBool(
    options::nlExtResBound__option_t,
    std::string option,
    bool value);
template <> const options::nlExtRewrites__option_t::type& Options::operator[](
    options::nlExtRewrites__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtRewrites__option_t) const;
template <> void Options::assignBool(
    options::nlExtRewrites__option_t,
    std::string option,
    bool value);
template <> const options::nlExtSplitZero__option_t::type& Options::operator[](
    options::nlExtSplitZero__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtSplitZero__option_t) const;
template <> void Options::assignBool(
    options::nlExtSplitZero__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::nlExtTfTaylorDegree__option_t,
    const options::nlExtTfTaylorDegree__option_t::type& x);
template <> const options::nlExtTfTaylorDegree__option_t::type& Options::operator[](
    options::nlExtTfTaylorDegree__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtTfTaylorDegree__option_t) const;
template <> void Options::assign(
    options::nlExtTfTaylorDegree__option_t,
    std::string option,
    std::string value);
template <> const options::nlExtTfTangentPlanes__option_t::type& Options::operator[](
    options::nlExtTfTangentPlanes__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtTfTangentPlanes__option_t) const;
template <> void Options::assignBool(
    options::nlExtTfTangentPlanes__option_t,
    std::string option,
    bool value);
template <> const options::nlExtTangentPlanes__option_t::type& Options::operator[](
    options::nlExtTangentPlanes__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtTangentPlanes__option_t) const;
template <> void Options::assignBool(
    options::nlExtTangentPlanes__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::nlExtTangentPlanesInterleave__option_t,
    const options::nlExtTangentPlanesInterleave__option_t::type& x);
template <> const options::nlExtTangentPlanesInterleave__option_t::type& Options::operator[](
    options::nlExtTangentPlanesInterleave__option_t) const;
template <> bool Options::wasSetByUser(options::nlExtTangentPlanesInterleave__option_t) const;
template <> void Options::assignBool(
    options::nlExtTangentPlanesInterleave__option_t,
    std::string option,
    bool value);
template <> const options::pbRewrites__option_t::type& Options::operator[](
    options::pbRewrites__option_t) const;
template <> bool Options::wasSetByUser(options::pbRewrites__option_t) const;
template <> void Options::assignBool(
    options::pbRewrites__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arithPivotThreshold__option_t,
    const options::arithPivotThreshold__option_t::type& x);
template <> const options::arithPivotThreshold__option_t::type& Options::operator[](
    options::arithPivotThreshold__option_t) const;
template <> bool Options::wasSetByUser(options::arithPivotThreshold__option_t) const;
template <> void Options::assign(
    options::arithPivotThreshold__option_t,
    std::string option,
    std::string value);
template <> const options::ppAssertMaxSubSize__option_t::type& Options::operator[](
    options::ppAssertMaxSubSize__option_t) const;
template <> bool Options::wasSetByUser(options::ppAssertMaxSubSize__option_t) const;
template <> void Options::assign(
    options::ppAssertMaxSubSize__option_t,
    std::string option,
    std::string value);
template <> const options::arithPropagateMaxLength__option_t::type& Options::operator[](
    options::arithPropagateMaxLength__option_t) const;
template <> bool Options::wasSetByUser(options::arithPropagateMaxLength__option_t) const;
template <> void Options::assign(
    options::arithPropagateMaxLength__option_t,
    std::string option,
    std::string value);
template <> const options::replayEarlyCloseDepths__option_t::type& Options::operator[](
    options::replayEarlyCloseDepths__option_t) const;
template <> bool Options::wasSetByUser(options::replayEarlyCloseDepths__option_t) const;
template <> void Options::assign(
    options::replayEarlyCloseDepths__option_t,
    std::string option,
    std::string value);
template <> const options::replayFailurePenalty__option_t::type& Options::operator[](
    options::replayFailurePenalty__option_t) const;
template <> bool Options::wasSetByUser(options::replayFailurePenalty__option_t) const;
template <> void Options::assign(
    options::replayFailurePenalty__option_t,
    std::string option,
    std::string value);
template <> const options::lemmaRejectCutSize__option_t::type& Options::operator[](
    options::lemmaRejectCutSize__option_t) const;
template <> bool Options::wasSetByUser(options::lemmaRejectCutSize__option_t) const;
template <> void Options::assign(
    options::lemmaRejectCutSize__option_t,
    std::string option,
    std::string value);
template <> const options::replayNumericFailurePenalty__option_t::type& Options::operator[](
    options::replayNumericFailurePenalty__option_t) const;
template <> bool Options::wasSetByUser(options::replayNumericFailurePenalty__option_t) const;
template <> void Options::assign(
    options::replayNumericFailurePenalty__option_t,
    std::string option,
    std::string value);
template <> const options::replayRejectCutSize__option_t::type& Options::operator[](
    options::replayRejectCutSize__option_t) const;
template <> bool Options::wasSetByUser(options::replayRejectCutSize__option_t) const;
template <> void Options::assign(
    options::replayRejectCutSize__option_t,
    std::string option,
    std::string value);
template <> const options::soiApproxMajorFailurePen__option_t::type& Options::operator[](
    options::soiApproxMajorFailurePen__option_t) const;
template <> bool Options::wasSetByUser(options::soiApproxMajorFailurePen__option_t) const;
template <> void Options::assign(
    options::soiApproxMajorFailurePen__option_t,
    std::string option,
    std::string value);
template <> const options::soiApproxMajorFailure__option_t::type& Options::operator[](
    options::soiApproxMajorFailure__option_t) const;
template <> bool Options::wasSetByUser(options::soiApproxMajorFailure__option_t) const;
template <> void Options::assign(
    options::soiApproxMajorFailure__option_t,
    std::string option,
    std::string value);
template <> const options::soiApproxMinorFailurePen__option_t::type& Options::operator[](
    options::soiApproxMinorFailurePen__option_t) const;
template <> bool Options::wasSetByUser(options::soiApproxMinorFailurePen__option_t) const;
template <> void Options::assign(
    options::soiApproxMinorFailurePen__option_t,
    std::string option,
    std::string value);
template <> const options::soiApproxMinorFailure__option_t::type& Options::operator[](
    options::soiApproxMinorFailure__option_t) const;
template <> bool Options::wasSetByUser(options::soiApproxMinorFailure__option_t) const;
template <> void Options::assign(
    options::soiApproxMinorFailure__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::restrictedPivots__option_t,
    const options::restrictedPivots__option_t::type& x);
template <> const options::restrictedPivots__option_t::type& Options::operator[](
    options::restrictedPivots__option_t) const;
template <> bool Options::wasSetByUser(options::restrictedPivots__option_t) const;
template <> void Options::assignBool(
    options::restrictedPivots__option_t,
    std::string option,
    bool value);
template <> const options::revertArithModels__option_t::type& Options::operator[](
    options::revertArithModels__option_t) const;
template <> bool Options::wasSetByUser(options::revertArithModels__option_t) const;
template <> void Options::assignBool(
    options::revertArithModels__option_t,
    std::string option,
    bool value);
template <> const options::rrTurns__option_t::type& Options::operator[](
    options::rrTurns__option_t) const;
template <> bool Options::wasSetByUser(options::rrTurns__option_t) const;
template <> void Options::assign(
    options::rrTurns__option_t,
    std::string option,
    std::string value);
template <> const options::trySolveIntStandardEffort__option_t::type& Options::operator[](
    options::trySolveIntStandardEffort__option_t) const;
template <> bool Options::wasSetByUser(options::trySolveIntStandardEffort__option_t) const;
template <> void Options::assignBool(
    options::trySolveIntStandardEffort__option_t,
    std::string option,
    bool value);
template <> const options::arithSimplexCheckPeriod__option_t::type& Options::operator[](
    options::arithSimplexCheckPeriod__option_t) const;
template <> bool Options::wasSetByUser(options::arithSimplexCheckPeriod__option_t) const;
template <> void Options::assign(
    options::arithSimplexCheckPeriod__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::soiQuickExplain__option_t,
    const options::soiQuickExplain__option_t::type& x);
template <> const options::soiQuickExplain__option_t::type& Options::operator[](
    options::soiQuickExplain__option_t) const;
template <> bool Options::wasSetByUser(options::soiQuickExplain__option_t) const;
template <> void Options::assignBool(
    options::soiQuickExplain__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arithStandardCheckVarOrderPivots__option_t,
    const options::arithStandardCheckVarOrderPivots__option_t::type& x);
template <> const options::arithStandardCheckVarOrderPivots__option_t::type& Options::operator[](
    options::arithStandardCheckVarOrderPivots__option_t) const;
template <> bool Options::wasSetByUser(options::arithStandardCheckVarOrderPivots__option_t) const;
template <> void Options::assign(
    options::arithStandardCheckVarOrderPivots__option_t,
    std::string option,
    std::string value);
template <> const options::arithUnateLemmaMode__option_t::type& Options::operator[](
    options::arithUnateLemmaMode__option_t) const;
template <> bool Options::wasSetByUser(options::arithUnateLemmaMode__option_t) const;
template <> void Options::assign(
    options::arithUnateLemmaMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::useApprox__option_t,
    const options::useApprox__option_t::type& x);
template <> const options::useApprox__option_t::type& Options::operator[](
    options::useApprox__option_t) const;
template <> bool Options::wasSetByUser(options::useApprox__option_t) const;
template <> void Options::assignBool(
    options::useApprox__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::useFC__option_t,
    const options::useFC__option_t::type& x);
template <> const options::useFC__option_t::type& Options::operator[](
    options::useFC__option_t) const;
template <> bool Options::wasSetByUser(options::useFC__option_t) const;
template <> void Options::assignBool(
    options::useFC__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::useSOI__option_t,
    const options::useSOI__option_t::type& x);
template <> const options::useSOI__option_t::type& Options::operator[](
    options::useSOI__option_t) const;
template <> bool Options::wasSetByUser(options::useSOI__option_t) const;
template <> void Options::assignBool(
    options::useSOI__option_t,
    std::string option,
    bool value);


namespace options {

inline maxApproxDepth__option_t::type maxApproxDepth__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool maxApproxDepth__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void maxApproxDepth__option_t::set(const maxApproxDepth__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline brabTest__option_t::type brabTest__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool brabTest__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline arithNoPartialFun__option_t::type arithNoPartialFun__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithNoPartialFun__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline arithPropAsLemmaLength__option_t::type arithPropAsLemmaLength__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithPropAsLemmaLength__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arithPropAsLemmaLength__option_t::set(const arithPropAsLemmaLength__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arithPropagationMode__option_t::type arithPropagationMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithPropagationMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline arithRewriteEq__option_t::type arithRewriteEq__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithRewriteEq__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arithRewriteEq__option_t::set(const arithRewriteEq__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline collectPivots__option_t::type collectPivots__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool collectPivots__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void collectPivots__option_t::set(const collectPivots__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline doCutAllBounded__option_t::type doCutAllBounded__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool doCutAllBounded__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void doCutAllBounded__option_t::set(const doCutAllBounded__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline exportDioDecompositions__option_t::type exportDioDecompositions__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool exportDioDecompositions__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void exportDioDecompositions__option_t::set(const exportDioDecompositions__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline dioRepeat__option_t::type dioRepeat__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dioRepeat__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline arithDioSolver__option_t::type arithDioSolver__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithDioSolver__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dioSolverTurns__option_t::type dioSolverTurns__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dioSolverTurns__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline arithErrorSelectionRule__option_t::type arithErrorSelectionRule__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithErrorSelectionRule__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline havePenalties__option_t::type havePenalties__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool havePenalties__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void havePenalties__option_t::set(const havePenalties__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arithHeuristicPivots__option_t::type arithHeuristicPivots__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithHeuristicPivots__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arithHeuristicPivots__option_t::set(const arithHeuristicPivots__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline replayFailureLemma__option_t::type replayFailureLemma__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool replayFailureLemma__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline maxCutsInContext__option_t::type maxCutsInContext__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool maxCutsInContext__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline arithMLTrick__option_t::type arithMLTrick__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithMLTrick__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arithMLTrick__option_t::set(const arithMLTrick__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arithMLTrickSubstitutions__option_t::type arithMLTrickSubstitutions__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithMLTrickSubstitutions__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline newProp__option_t::type newProp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool newProp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void newProp__option_t::set(const newProp__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline nlExt__option_t::type nlExt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtEntailConflicts__option_t::type nlExtEntailConflicts__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtEntailConflicts__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtFactor__option_t::type nlExtFactor__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtFactor__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtIncPrecision__option_t::type nlExtIncPrecision__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtIncPrecision__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtPurify__option_t::type nlExtPurify__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtPurify__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtResBound__option_t::type nlExtResBound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtResBound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtRewrites__option_t::type nlExtRewrites__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtRewrites__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtSplitZero__option_t::type nlExtSplitZero__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtSplitZero__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtTfTaylorDegree__option_t::type nlExtTfTaylorDegree__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtTfTaylorDegree__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void nlExtTfTaylorDegree__option_t::set(const nlExtTfTaylorDegree__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline nlExtTfTangentPlanes__option_t::type nlExtTfTangentPlanes__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtTfTangentPlanes__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtTangentPlanes__option_t::type nlExtTangentPlanes__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtTangentPlanes__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline nlExtTangentPlanesInterleave__option_t::type nlExtTangentPlanesInterleave__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool nlExtTangentPlanesInterleave__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void nlExtTangentPlanesInterleave__option_t::set(const nlExtTangentPlanesInterleave__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline pbRewrites__option_t::type pbRewrites__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool pbRewrites__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline arithPivotThreshold__option_t::type arithPivotThreshold__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithPivotThreshold__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arithPivotThreshold__option_t::set(const arithPivotThreshold__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline ppAssertMaxSubSize__option_t::type ppAssertMaxSubSize__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ppAssertMaxSubSize__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline arithPropagateMaxLength__option_t::type arithPropagateMaxLength__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithPropagateMaxLength__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline replayEarlyCloseDepths__option_t::type replayEarlyCloseDepths__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool replayEarlyCloseDepths__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline replayFailurePenalty__option_t::type replayFailurePenalty__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool replayFailurePenalty__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline lemmaRejectCutSize__option_t::type lemmaRejectCutSize__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool lemmaRejectCutSize__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline replayNumericFailurePenalty__option_t::type replayNumericFailurePenalty__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool replayNumericFailurePenalty__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline replayRejectCutSize__option_t::type replayRejectCutSize__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool replayRejectCutSize__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline soiApproxMajorFailurePen__option_t::type soiApproxMajorFailurePen__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool soiApproxMajorFailurePen__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline soiApproxMajorFailure__option_t::type soiApproxMajorFailure__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool soiApproxMajorFailure__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline soiApproxMinorFailurePen__option_t::type soiApproxMinorFailurePen__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool soiApproxMinorFailurePen__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline soiApproxMinorFailure__option_t::type soiApproxMinorFailure__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool soiApproxMinorFailure__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline restrictedPivots__option_t::type restrictedPivots__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool restrictedPivots__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void restrictedPivots__option_t::set(const restrictedPivots__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline revertArithModels__option_t::type revertArithModels__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool revertArithModels__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline rrTurns__option_t::type rrTurns__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool rrTurns__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline trySolveIntStandardEffort__option_t::type trySolveIntStandardEffort__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool trySolveIntStandardEffort__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline arithSimplexCheckPeriod__option_t::type arithSimplexCheckPeriod__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithSimplexCheckPeriod__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline soiQuickExplain__option_t::type soiQuickExplain__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool soiQuickExplain__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void soiQuickExplain__option_t::set(const soiQuickExplain__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arithStandardCheckVarOrderPivots__option_t::type arithStandardCheckVarOrderPivots__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithStandardCheckVarOrderPivots__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arithStandardCheckVarOrderPivots__option_t::set(const arithStandardCheckVarOrderPivots__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arithUnateLemmaMode__option_t::type arithUnateLemmaMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arithUnateLemmaMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline useApprox__option_t::type useApprox__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool useApprox__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void useApprox__option_t::set(const useApprox__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline useFC__option_t::type useFC__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool useFC__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void useFC__option_t::set(const useFC__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline useSOI__option_t::type useSOI__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool useSOI__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void useSOI__option_t::set(const useSOI__option_t::type& v)
{
  Options::current()->set(*this, v);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__ARITH_H */
