/*
 * This file was generated by qdbusxml2cpp-fix version 0.8
 * Command line was: qdbusxml2cpp-fix -c InputDevices -p generated/com_deepin_daemon_inputdevices ../xml/com.deepin.daemon.InputDevices.xml
 *
 * qdbusxml2cpp-fix is Copyright (C) 2016 Deepin Technology Co., Ltd.
 *
 * This is an auto-generated file.
 * This file may have been hand-edited. Look for HAND-EDIT comments
 * before re-generating it.
 */

#include "generated/com_deepin_daemon_inputdevices.h"

/*
 * Implementation of interface class __InputDevices
 */

class __InputDevicesPrivate
{
public:
   __InputDevicesPrivate() = default;

    // begin member variables
    InputDeviceList Infos;
    uint WheelSpeed;

public:
    QMap<QString, QDBusPendingCallWatcher *> m_processingCalls;
    QMap<QString, QList<QVariant>> m_waittingCalls;
};

__InputDevices::__InputDevices(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent)
    : DBusExtendedAbstractInterface(service, path, staticInterfaceName(), connection, parent)
    , d_ptr(new __InputDevicesPrivate)
{
    connect(this, &__InputDevices::propertyChanged, this, &__InputDevices::onPropertyChanged);

    if (QMetaType::type("InputDeviceList") == QMetaType::UnknownType)
        registerInputDeviceListMetaType();
}

__InputDevices::~__InputDevices()
{
    qDeleteAll(d_ptr->m_processingCalls.values());
    delete d_ptr;
}

void __InputDevices::onPropertyChanged(const QString &propName, const QVariant &value)
{
    if (propName == QStringLiteral("Infos"))
    {
        const InputDeviceList &Infos = qvariant_cast<InputDeviceList>(value);
        if (d_ptr->Infos != Infos)
        {
            d_ptr->Infos = Infos;
            Q_EMIT InfosChanged(d_ptr->Infos);
        }
        return;
    }

    if (propName == QStringLiteral("WheelSpeed"))
    {
        const uint &WheelSpeed = qvariant_cast<uint>(value);
        if (d_ptr->WheelSpeed != WheelSpeed)
        {
            d_ptr->WheelSpeed = WheelSpeed;
            Q_EMIT WheelSpeedChanged(d_ptr->WheelSpeed);
        }
        return;
    }

    qWarning() << "property not handle: " << propName;
    return;
}

InputDeviceList __InputDevices::infos()
{
    return qvariant_cast<InputDeviceList>(internalPropGet("Infos", &d_ptr->Infos));
}

uint __InputDevices::wheelSpeed()
{
    return qvariant_cast<uint>(internalPropGet("WheelSpeed", &d_ptr->WheelSpeed));
}

void __InputDevices::setWheelSpeed(uint value)
{

   internalPropSet("WheelSpeed", QVariant::fromValue(value), &d_ptr->WheelSpeed);
}

void __InputDevices::CallQueued(const QString &callName, const QList<QVariant> &args)
{
    if (d_ptr->m_waittingCalls.contains(callName))
    {
        d_ptr->m_waittingCalls[callName] = args;
        return;
    }
    if (d_ptr->m_processingCalls.contains(callName))
    {
        d_ptr->m_waittingCalls.insert(callName, args);
    } else {
        QDBusPendingCallWatcher *watcher = new QDBusPendingCallWatcher(asyncCallWithArgumentList(callName, args));
        connect(watcher, &QDBusPendingCallWatcher::finished, this, &__InputDevices::onPendingCallFinished);
        d_ptr->m_processingCalls.insert(callName, watcher);
    }
}

void __InputDevices::onPendingCallFinished(QDBusPendingCallWatcher *w)
{
    w->deleteLater();
    const auto callName = d_ptr->m_processingCalls.key(w);
    Q_ASSERT(!callName.isEmpty());
    if (callName.isEmpty())
        return;
    d_ptr->m_processingCalls.remove(callName);
    if (!d_ptr->m_waittingCalls.contains(callName))
        return;
    const auto args = d_ptr->m_waittingCalls.take(callName);
    CallQueued(callName, args);
}
