/* about_widget.c generated by valac 0.56.17, the Vala compiler
 * generated from about_widget.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#define CONSTANT_VERSION "5.0.4.4"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_ABOUT_WIDGET (widgets_about_widget_get_type ())
#define WIDGETS_ABOUT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ABOUT_WIDGET, WidgetsAboutWidget))
#define WIDGETS_ABOUT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ABOUT_WIDGET, WidgetsAboutWidgetClass))
#define WIDGETS_IS_ABOUT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ABOUT_WIDGET))
#define WIDGETS_IS_ABOUT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ABOUT_WIDGET))
#define WIDGETS_ABOUT_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ABOUT_WIDGET, WidgetsAboutWidgetClass))

typedef struct _WidgetsAboutWidget WidgetsAboutWidget;
typedef struct _WidgetsAboutWidgetClass WidgetsAboutWidgetClass;
typedef struct _WidgetsAboutWidgetPrivate WidgetsAboutWidgetPrivate;
enum  {
	WIDGETS_ABOUT_WIDGET_0_PROPERTY,
	WIDGETS_ABOUT_WIDGET_NUM_PROPERTIES
};
static GParamSpec* widgets_about_widget_properties[WIDGETS_ABOUT_WIDGET_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define WIDGETS_TYPE_CLICK_EVENT_BOX (widgets_click_event_box_get_type ())
#define WIDGETS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBox))
#define WIDGETS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))
#define WIDGETS_IS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_IS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_CLICK_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))

typedef struct _WidgetsClickEventBox WidgetsClickEventBox;
typedef struct _WidgetsClickEventBoxClass WidgetsClickEventBoxClass;

#define WIDGETS_TYPE_LINK_BUTTON (widgets_link_button_get_type ())
#define WIDGETS_LINK_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_LINK_BUTTON, WidgetsLinkButton))
#define WIDGETS_LINK_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_LINK_BUTTON, WidgetsLinkButtonClass))
#define WIDGETS_IS_LINK_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_LINK_BUTTON))
#define WIDGETS_IS_LINK_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_LINK_BUTTON))
#define WIDGETS_LINK_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_LINK_BUTTON, WidgetsLinkButtonClass))

typedef struct _WidgetsLinkButton WidgetsLinkButton;
typedef struct _WidgetsLinkButtonClass WidgetsLinkButtonClass;

struct _WidgetsAboutWidget {
	GtkBox parent_instance;
	WidgetsAboutWidgetPrivate * priv;
	cairo_surface_t* icon_surface;
	cairo_surface_t* logo_surface;
	gint about_height;
	gint about_x;
	gint about_y;
	gint acknowledgments_y;
	gint height;
	gint homepage_y;
	gint icon_y;
	gint logo_y;
	gint name_height;
	gint name_y;
	gint version_height;
	gint version_size;
	gint version_y;
	gchar* about_text;
	gchar* product_name_text;
};

struct _WidgetsAboutWidgetClass {
	GtkBoxClass parent_class;
};

static gpointer widgets_about_widget_parent_class = NULL;

VALA_EXTERN GType widgets_about_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsAboutWidget, g_object_unref)
VALA_EXTERN WidgetsAboutWidget* widgets_about_widget_new (void);
VALA_EXTERN WidgetsAboutWidget* widgets_about_widget_construct (GType object_type);
VALA_EXTERN gchar* utils_get_image_path (const gchar* image_name);
VALA_EXTERN cairo_surface_t* utils_create_image_surface (const gchar* surface_path);
VALA_EXTERN cairo_surface_t* utils_create_image_surface_from_file (const gchar* file_path);
VALA_EXTERN GType widgets_click_event_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsClickEventBox, g_object_unref)
VALA_EXTERN GType widgets_link_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsLinkButton, g_object_unref)
VALA_EXTERN WidgetsLinkButton* widgets_link_button_new (const gchar* link_name,
                                            const gchar* link_uri,
                                            const gchar* link_css);
VALA_EXTERN WidgetsLinkButton* widgets_link_button_construct (GType object_type,
                                                  const gchar* link_name,
                                                  const gchar* link_uri,
                                                  const gchar* link_css);
static gboolean widgets_about_widget_on_draw (WidgetsAboutWidget* self,
                                       GtkWidget* widget,
                                       cairo_t* cr);
static gboolean _widgets_about_widget_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                        cairo_t* cr,
                                                        gpointer self);
VALA_EXTERN void draw_draw_surface (cairo_t* cr,
                        cairo_surface_t* surface,
                        gint x,
                        gint y,
                        gint width,
                        gint height);
VALA_EXTERN void draw_draw_text (cairo_t* cr,
                     const gchar* text,
                     gint x,
                     gint y,
                     gint width,
                     gint height,
                     gint size,
                     PangoAlignment horizontal_alignment,
                     const gchar* vertical_align,
                     gint* wrap_width);
VALA_EXTERN void utils_propagate_draw (GtkContainer* widget,
                           cairo_t* cr);
static void widgets_about_widget_finalize (GObject * obj);
static GType widgets_about_widget_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
_widgets_about_widget_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                               cairo_t* cr,
                                               gpointer self)
{
	gboolean result;
	result = widgets_about_widget_on_draw ((WidgetsAboutWidget*) self, _sender, cr);
	return result;
}

WidgetsAboutWidget*
widgets_about_widget_construct (GType object_type)
{
	WidgetsAboutWidget * self = NULL;
	GKeyFile* distribution_info_file = NULL;
	GKeyFile* _tmp0_;
	gboolean dif_loaded = FALSE;
	gchar* logo_path = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	cairo_surface_t* _tmp21_;
	const gchar* _tmp22_;
	cairo_surface_t* _tmp23_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	WidgetsLinkButton* acknowledgments_area = NULL;
	WidgetsLinkButton* _tmp61_;
	GtkBox* _tmp62_;
	GtkBox* _tmp63_;
	GError* _inner_error0_ = NULL;
	self = (WidgetsAboutWidget*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	_tmp0_ = g_key_file_new ();
	distribution_info_file = _tmp0_;
	dif_loaded = FALSE;
	{
		gboolean _tmp1_ = FALSE;
		GKeyFile* _tmp2_;
		_tmp2_ = distribution_info_file;
		_tmp1_ = g_key_file_load_from_file (_tmp2_, "/usr/share/deepin/distribution.info", G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_key_file_unref0 (distribution_info_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		dif_loaded = _tmp1_;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		if (!g_error_matches (_tmp3_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_print ("distribution_info_file load error (FileError): %s", _tmp5_);
		}
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_print ("distribution_info_file load error (KeyFileError): %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (distribution_info_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp8_ = utils_get_image_path ("logo.svg");
	logo_path = _tmp8_;
	if (dif_loaded) {
		_tmp9_ = _ ("Terminal is an advanced terminal emulator with workspace, multiple win" \
"dows, remote management, quake mode and other features.");
	} else {
		_tmp9_ = _ ("Deepin Terminal is an advanced terminal emulator with workspace, multi" \
"ple windows, remote management, quake mode and other features.\n" \
"\n" \
"It sharpens your focus in the world of command line!");
	}
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (self->about_text);
	self->about_text = _tmp10_;
	if (dif_loaded) {
		_tmp11_ = _ ("Terminal");
	} else {
		_tmp11_ = _ ("Deepin Terminal");
	}
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (self->product_name_text);
	self->product_name_text = _tmp12_;
	{
		const gchar* _tmp17_;
		if (dif_loaded) {
			gchar* _tmp13_ = NULL;
			GKeyFile* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp14_ = distribution_info_file;
			_tmp15_ = g_key_file_get_string (_tmp14_, "Distribution", "LogoLight", &_inner_error0_);
			_tmp13_ = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp16_ = _tmp13_;
			_tmp13_ = NULL;
			_g_free0 (logo_path);
			logo_path = _tmp16_;
			_g_free0 (_tmp13_);
		}
		_tmp17_ = logo_path;
		if (g_strcmp0 (_tmp17_, "") == 0) {
			gchar* _tmp18_;
			_tmp18_ = utils_get_image_path ("logo.svg");
			_g_free0 (logo_path);
			logo_path = _tmp18_;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_print ("distribution_info_file process error: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (logo_path);
		_g_key_file_unref0 (distribution_info_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp21_ = utils_create_image_surface ("icon.svg");
	_cairo_surface_destroy0 (self->icon_surface);
	self->icon_surface = _tmp21_;
	_tmp22_ = logo_path;
	_tmp23_ = utils_create_image_surface_from_file (_tmp22_);
	_cairo_surface_destroy0 (self->logo_surface);
	self->logo_surface = _tmp23_;
	gtk_widget_set_size_request ((GtkWidget*) self, -1, self->height);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp24_);
	content_box = _tmp24_;
	_tmp25_ = content_box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp25_, self->homepage_y);
	{
		gchar* os_version_path = NULL;
		gchar* _tmp26_;
		gboolean is_professional = FALSE;
		GFile* version_file = NULL;
		const gchar* _tmp27_;
		GFile* _tmp28_;
		GFile* _tmp29_;
		const gchar* _tmp36_ = NULL;
		gchar* homepage_name = NULL;
		gchar* _tmp37_;
		gchar* homepage_link = NULL;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		WidgetsLinkButton* homepage_area = NULL;
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		WidgetsLinkButton* _tmp56_;
		GtkBox* _tmp57_;
		WidgetsLinkButton* _tmp58_;
		_tmp26_ = g_strdup ("/etc/deepin-version");
		os_version_path = _tmp26_;
		is_professional = FALSE;
		_tmp27_ = os_version_path;
		_tmp28_ = g_file_new_for_path (_tmp27_);
		version_file = _tmp28_;
		_tmp29_ = version_file;
		if (g_file_query_exists (_tmp29_, NULL)) {
			GKeyFile* version_config_file = NULL;
			GKeyFile* _tmp30_;
			GKeyFile* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_ = NULL;
			GKeyFile* _tmp34_;
			gchar* _tmp35_;
			_tmp30_ = g_key_file_new ();
			version_config_file = _tmp30_;
			_tmp31_ = version_config_file;
			_tmp32_ = os_version_path;
			g_key_file_load_from_file (_tmp31_, _tmp32_, G_KEY_FILE_NONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (version_config_file);
				_g_object_unref0 (version_file);
				_g_free0 (os_version_path);
				goto __catch2_g_error;
			}
			_tmp34_ = version_config_file;
			_tmp35_ = g_key_file_get_string (_tmp34_, "Release", "Type", &_inner_error0_);
			_tmp33_ = _tmp35_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (version_config_file);
				_g_object_unref0 (version_file);
				_g_free0 (os_version_path);
				goto __catch2_g_error;
			}
			is_professional = g_strcmp0 (_tmp33_, "Professional") == 0;
			_g_free0 (_tmp33_);
			_g_key_file_unref0 (version_config_file);
		}
		if (is_professional) {
			_tmp36_ = "www.deepin.com";
		} else {
			_tmp36_ = "www.deepin.org";
		}
		_tmp37_ = g_strdup (_tmp36_);
		homepage_name = _tmp37_;
		_tmp38_ = homepage_name;
		_tmp39_ = g_strconcat ("https://", _tmp38_, NULL);
		homepage_link = _tmp39_;
		if (dif_loaded) {
			gchar* dif_homepage_name = NULL;
			GKeyFile* _tmp40_;
			gchar* _tmp41_;
			gchar* dif_homepage_link = NULL;
			GKeyFile* _tmp42_;
			gchar* _tmp43_;
			const gchar* _tmp44_ = NULL;
			const gchar* _tmp45_;
			gchar* _tmp48_;
			const gchar* _tmp49_ = NULL;
			const gchar* _tmp50_;
			gchar* _tmp53_;
			_tmp40_ = distribution_info_file;
			_tmp41_ = g_key_file_get_string (_tmp40_, "Distribution", "WebsiteName", &_inner_error0_);
			dif_homepage_name = _tmp41_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (homepage_link);
				_g_free0 (homepage_name);
				_g_object_unref0 (version_file);
				_g_free0 (os_version_path);
				goto __catch2_g_error;
			}
			_tmp42_ = distribution_info_file;
			_tmp43_ = g_key_file_get_string (_tmp42_, "Distribution", "Website", &_inner_error0_);
			dif_homepage_link = _tmp43_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (dif_homepage_name);
				_g_free0 (homepage_link);
				_g_free0 (homepage_name);
				_g_object_unref0 (version_file);
				_g_free0 (os_version_path);
				goto __catch2_g_error;
			}
			_tmp45_ = dif_homepage_name;
			if (g_strcmp0 (_tmp45_, "") == 0) {
				const gchar* _tmp46_;
				_tmp46_ = homepage_name;
				_tmp44_ = _tmp46_;
			} else {
				const gchar* _tmp47_;
				_tmp47_ = dif_homepage_name;
				_tmp44_ = _tmp47_;
			}
			_tmp48_ = g_strdup (_tmp44_);
			_g_free0 (homepage_name);
			homepage_name = _tmp48_;
			_tmp50_ = dif_homepage_link;
			if (g_strcmp0 (_tmp50_, "") == 0) {
				const gchar* _tmp51_;
				_tmp51_ = homepage_link;
				_tmp49_ = _tmp51_;
			} else {
				const gchar* _tmp52_;
				_tmp52_ = dif_homepage_link;
				_tmp49_ = _tmp52_;
			}
			_tmp53_ = g_strdup (_tmp49_);
			_g_free0 (homepage_link);
			homepage_link = _tmp53_;
			_g_free0 (dif_homepage_link);
			_g_free0 (dif_homepage_name);
		}
		_tmp54_ = homepage_name;
		_tmp55_ = homepage_link;
		_tmp56_ = widgets_link_button_new (_tmp54_, _tmp55_, "homepage");
		g_object_ref_sink (_tmp56_);
		homepage_area = _tmp56_;
		_tmp57_ = content_box;
		_tmp58_ = homepage_area;
		gtk_box_pack_start (_tmp57_, (GtkWidget*) _tmp58_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (homepage_area);
		_g_free0 (homepage_link);
		_g_free0 (homepage_name);
		_g_object_unref0 (version_file);
		_g_free0 (os_version_path);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp59_;
		const gchar* _tmp60_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp59_ = e;
		_tmp60_ = _tmp59_->message;
		g_print ("AboutWidget error: %s", _tmp60_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (content_box);
		_g_free0 (logo_path);
		_g_key_file_unref0 (distribution_info_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp61_ = widgets_link_button_new (_ ("Acknowledgments"), "https://www.deepin.org/acknowledgments/deepin-terminal-gtk", "acknowledgments");
	g_object_ref_sink (_tmp61_);
	acknowledgments_area = _tmp61_;
	gtk_widget_set_margin_top ((GtkWidget*) acknowledgments_area, self->acknowledgments_y);
	_tmp62_ = content_box;
	gtk_box_pack_start (_tmp62_, (GtkWidget*) acknowledgments_area, FALSE, FALSE, (guint) 0);
	_tmp63_ = content_box;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp63_, TRUE, TRUE, (guint) 0);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_about_widget_on_draw_gtk_widget_draw, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (acknowledgments_area);
	_g_object_unref0 (content_box);
	_g_free0 (logo_path);
	_g_key_file_unref0 (distribution_info_file);
	return self;
}

WidgetsAboutWidget*
widgets_about_widget_new (void)
{
	return widgets_about_widget_construct (WIDGETS_TYPE_ABOUT_WIDGET);
}

static gboolean
widgets_about_widget_on_draw (WidgetsAboutWidget* self,
                              GtkWidget* widget,
                              cairo_t* cr)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	cairo_surface_t* _tmp1_;
	GtkAllocation _tmp2_;
	cairo_surface_t* _tmp3_;
	const gchar* _tmp4_;
	GtkAllocation _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkAllocation _tmp8_;
	cairo_surface_t* _tmp9_;
	GtkAllocation _tmp10_;
	cairo_surface_t* _tmp11_;
	const gchar* _tmp12_;
	GtkAllocation _tmp13_;
	GtkAllocation _tmp14_;
	gint _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (widget, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = self->icon_surface;
	_tmp2_ = rect;
	_tmp3_ = self->icon_surface;
	draw_draw_surface (cr, _tmp1_, (_tmp2_.width - (cairo_image_surface_get_width (_tmp3_) / gtk_widget_get_scale_factor ((GtkWidget*) self))) / 2, self->icon_y, 0, 0);
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	_tmp4_ = self->product_name_text;
	_tmp5_ = rect;
	draw_draw_text (cr, _tmp4_, 0, self->name_y, _tmp5_.width, self->name_height, self->name_height, PANGO_ALIGN_CENTER, "top", NULL);
	cairo_set_source_rgba (cr, 0.4, 0.4, 0.4, (gdouble) 1);
	_tmp6_ = g_strdup_printf ("%s %s", _ ("Version:"), CONSTANT_VERSION);
	_tmp7_ = _tmp6_;
	_tmp8_ = rect;
	draw_draw_text (cr, _tmp7_, 0, self->version_y, _tmp8_.width, self->version_height, self->version_size, PANGO_ALIGN_CENTER, "top", NULL);
	_g_free0 (_tmp7_);
	_tmp9_ = self->logo_surface;
	_tmp10_ = rect;
	_tmp11_ = self->logo_surface;
	draw_draw_surface (cr, _tmp9_, (_tmp10_.width - (cairo_image_surface_get_width (_tmp11_) / gtk_widget_get_scale_factor ((GtkWidget*) self))) / 2, self->logo_y, 0, 0);
	cairo_set_source_rgba (cr, 0.1, 0.1, 0.1, (gdouble) 1);
	_tmp12_ = self->about_text;
	_tmp13_ = rect;
	_tmp14_ = rect;
	_tmp15_ = _tmp14_.width - (self->about_x * 2);
	draw_draw_text (cr, _tmp12_, self->about_x, self->about_y, _tmp13_.width - (self->about_x * 2), self->about_height, self->about_height, PANGO_ALIGN_CENTER, "top", &_tmp15_);
	utils_propagate_draw ((GtkContainer*) self, cr);
	result = TRUE;
	return result;
}

static void
widgets_about_widget_class_init (WidgetsAboutWidgetClass * klass,
                                 gpointer klass_data)
{
	widgets_about_widget_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_about_widget_finalize;
}

static void
widgets_about_widget_instance_init (WidgetsAboutWidget * self,
                                    gpointer klass)
{
	self->about_height = 9;
	self->about_x = 38;
	self->about_y = 270;
	self->acknowledgments_y = 10;
	self->height = 320;
	self->homepage_y = 200;
	self->icon_y = 13;
	self->logo_y = 176;
	self->name_height = 13;
	self->name_y = 106;
	self->version_height = 12;
	self->version_size = 9;
	self->version_y = 146;
}

static void
widgets_about_widget_finalize (GObject * obj)
{
	WidgetsAboutWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_ABOUT_WIDGET, WidgetsAboutWidget);
	_cairo_surface_destroy0 (self->icon_surface);
	_cairo_surface_destroy0 (self->logo_surface);
	_g_free0 (self->about_text);
	_g_free0 (self->product_name_text);
	G_OBJECT_CLASS (widgets_about_widget_parent_class)->finalize (obj);
}

static GType
widgets_about_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsAboutWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_about_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsAboutWidget), 0, (GInstanceInitFunc) widgets_about_widget_instance_init, NULL };
	GType widgets_about_widget_type_id;
	widgets_about_widget_type_id = g_type_register_static (gtk_box_get_type (), "WidgetsAboutWidget", &g_define_type_info, 0);
	return widgets_about_widget_type_id;
}

GType
widgets_about_widget_get_type (void)
{
	static volatile gsize widgets_about_widget_type_id__once = 0;
	if (g_once_init_enter (&widgets_about_widget_type_id__once)) {
		GType widgets_about_widget_type_id;
		widgets_about_widget_type_id = widgets_about_widget_get_type_once ();
		g_once_init_leave (&widgets_about_widget_type_id__once, widgets_about_widget_type_id);
	}
	return widgets_about_widget_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

