/* search_panel.c generated by valac 0.56.17, the Vala compiler
 * generated from search_panel.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <vte/vte.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_SEARCH_PANEL (widgets_search_panel_get_type ())
#define WIDGETS_SEARCH_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_SEARCH_PANEL, WidgetsSearchPanel))
#define WIDGETS_SEARCH_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_SEARCH_PANEL, WidgetsSearchPanelClass))
#define WIDGETS_IS_SEARCH_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_SEARCH_PANEL))
#define WIDGETS_IS_SEARCH_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_SEARCH_PANEL))
#define WIDGETS_SEARCH_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_SEARCH_PANEL, WidgetsSearchPanelClass))

typedef struct _WidgetsSearchPanel WidgetsSearchPanel;
typedef struct _WidgetsSearchPanelClass WidgetsSearchPanelClass;
typedef struct _WidgetsSearchPanelPrivate WidgetsSearchPanelPrivate;

#define WIDGETS_TYPE_ENTRY (widgets_entry_get_type ())
#define WIDGETS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ENTRY, WidgetsEntry))
#define WIDGETS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ENTRY, WidgetsEntryClass))
#define WIDGETS_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ENTRY))
#define WIDGETS_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ENTRY))
#define WIDGETS_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ENTRY, WidgetsEntryClass))

typedef struct _WidgetsEntry WidgetsEntry;
typedef struct _WidgetsEntryClass WidgetsEntryClass;

#define WIDGETS_TYPE_CLICK_EVENT_BOX (widgets_click_event_box_get_type ())
#define WIDGETS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBox))
#define WIDGETS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))
#define WIDGETS_IS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_IS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_CLICK_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))

typedef struct _WidgetsClickEventBox WidgetsClickEventBox;
typedef struct _WidgetsClickEventBoxClass WidgetsClickEventBoxClass;

#define WIDGETS_TYPE_IMAGE_BUTTON (widgets_image_button_get_type ())
#define WIDGETS_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButton))
#define WIDGETS_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButtonClass))
#define WIDGETS_IS_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_IMAGE_BUTTON))
#define WIDGETS_IS_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_IMAGE_BUTTON))
#define WIDGETS_IMAGE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButtonClass))

typedef struct _WidgetsImageButton WidgetsImageButton;
typedef struct _WidgetsImageButtonClass WidgetsImageButtonClass;

#define WIDGETS_TYPE_TERM (widgets_term_get_type ())
#define WIDGETS_TERM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TERM, WidgetsTerm))
#define WIDGETS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TERM, WidgetsTermClass))
#define WIDGETS_IS_TERM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TERM))
#define WIDGETS_IS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TERM))
#define WIDGETS_TERM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TERM, WidgetsTermClass))

typedef struct _WidgetsTerm WidgetsTerm;
typedef struct _WidgetsTermClass WidgetsTermClass;
enum  {
	WIDGETS_SEARCH_PANEL_0_PROPERTY,
	WIDGETS_SEARCH_PANEL_NUM_PROPERTIES
};
static GParamSpec* widgets_search_panel_properties[WIDGETS_SEARCH_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
typedef struct _Block38Data Block38Data;
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;
typedef struct _WidgetsTermPrivate WidgetsTermPrivate;

#define MENU_TYPE_MENU (menu_menu_get_type ())
#define MENU_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MENU_TYPE_MENU, MenuMenu))
#define MENU_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MENU_TYPE_MENU, MenuMenuClass))
#define MENU_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MENU_TYPE_MENU))
#define MENU_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MENU_TYPE_MENU))
#define MENU_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MENU_TYPE_MENU, MenuMenuClass))

typedef struct _MenuMenu MenuMenu;
typedef struct _MenuMenuClass MenuMenuClass;
#define _vte_regex_unref0(var) ((var == NULL) ? NULL : (var = (vte_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	WIDGETS_SEARCH_PANEL_QUIT_SEARCH_SIGNAL,
	WIDGETS_SEARCH_PANEL_NUM_SIGNALS
};
static guint widgets_search_panel_signals[WIDGETS_SEARCH_PANEL_NUM_SIGNALS] = {0};

struct _WidgetsSearchPanel {
	GtkHBox parent_instance;
	WidgetsSearchPanelPrivate * priv;
	WidgetsEntry* search_entry;
	GtkBox* clear_button_box;
	WidgetsImageButton* clear_button;
	WidgetsImageButton* search_next_button;
	WidgetsImageButton* search_previous_button;
	WidgetsTerm* terminal;
	WidgetsImageButton* search_image;
	gint button_margin;
	gint margin_horizontal;
	gchar* search_text;
};

struct _WidgetsSearchPanelClass {
	GtkHBoxClass parent_class;
};

struct _Block38Data {
	int _ref_count_;
	WidgetsSearchPanel* self;
	WidgetsConfigWindow* config_window;
};

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _WidgetsTerm {
	GtkOverlay parent_instance;
	WidgetsTermPrivate * priv;
	GeeArrayList* command_execute_y_coordinates;
	GPid child_pid;
	GdkRGBA background_color;
	GdkRGBA foreground_color;
	GtkScrollbar* scrollbar;
	MenuMenu* menu;
	VteTerminal* term;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean child_has_exit;
	gboolean has_print_exit_notify;
	gboolean has_select_all;
	gboolean is_first_term;
	gboolean is_press_scrollbar;
	gboolean login_remote_server;
	gboolean press_anything;
	gdouble zoom_factor;
	gint font_size;
	gint hide_scrollbar_offset;
	gint show_scrollbar_offset;
	gchar* current_dir;
	gchar* current_title;
	gchar* expect_file_path;
	gchar* customize_title;
	gchar* remote_server_title;
	gchar* uri_at_right_press;
	gchar* server_info;
	guint launch_idle_id;
	guint* hide_scrollbar_timeout_source_id;
	GKeyFile* search_engine_config_file;
	gchar* search_engine_config_file_path;
};

struct _WidgetsTermClass {
	GtkOverlayClass parent_class;
};

static gpointer widgets_search_panel_parent_class = NULL;
VALA_EXTERN gint constant_SEARCH_PANEL_WIDTH;
VALA_EXTERN gint constant_TITLEBAR_HEIGHT;

VALA_EXTERN GType widgets_search_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsSearchPanel, g_object_unref)
VALA_EXTERN GType widgets_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsEntry, g_object_unref)
VALA_EXTERN GType widgets_click_event_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsClickEventBox, g_object_unref)
VALA_EXTERN GType widgets_image_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsImageButton, g_object_unref)
VALA_EXTERN GType widgets_term_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTerm, g_object_unref)
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN WidgetsSearchPanel* widgets_search_panel_new (WidgetsConfigWindow* config_window,
                                              WidgetsTerm* term,
                                              const gchar* init_search_text);
VALA_EXTERN WidgetsSearchPanel* widgets_search_panel_construct (GType object_type,
                                                    WidgetsConfigWindow* config_window,
                                                    WidgetsTerm* term,
                                                    const gchar* init_search_text);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
VALA_EXTERN WidgetsImageButton* widgets_image_button_new (const gchar* image_path,
                                              gboolean theme_button,
                                              const gchar* text,
                                              gint text_size);
VALA_EXTERN WidgetsImageButton* widgets_image_button_construct (GType object_type,
                                                    const gchar* image_path,
                                                    gboolean theme_button,
                                                    const gchar* text,
                                                    gint text_size);
VALA_EXTERN WidgetsEntry* widgets_entry_new (void);
VALA_EXTERN WidgetsEntry* widgets_entry_construct (GType object_type);
VALA_EXTERN void widgets_search_panel_adjust_css_with_theme (WidgetsSearchPanel* self,
                                                 WidgetsConfigWindow* config_window);
static void __lambda96_ (Block38Data* _data38_,
                  GtkWidget* w);
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
static void __lambda97_ (Block38Data* _data38_,
                  ConfigConfig* w);
static void ___lambda97__config_config_update (ConfigConfig* _sender,
                                        gpointer self);
static void ___lambda96__gtk_widget_realize (GtkWidget* _sender,
                                      gpointer self);
static gboolean __lambda98_ (WidgetsSearchPanel* self,
                      GtkWidget* w,
                      GdkEventKey* e);
VALA_EXTERN gchar* keymap_get_keyevent_name (GdkEventKey* key_event);
VALA_EXTERN void widgets_search_panel_update_search_text (WidgetsSearchPanel* self);
VALA_EXTERN GType menu_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuMenu, g_object_unref)
static gboolean ___lambda98__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
static void __lambda99_ (WidgetsSearchPanel* self,
                  GtkEntryBuffer* buffer,
                  guint p,
                  guint nc);
VALA_EXTERN void widgets_search_panel_hide_clear_button (WidgetsSearchPanel* self);
static void ___lambda99__gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender,
                                                 guint position,
                                                 guint n_chars,
                                                 gpointer self);
static void __lambda100_ (WidgetsSearchPanel* self,
                   GtkEntryBuffer* buffer,
                   guint p,
                   const gchar* c,
                   guint nc);
VALA_EXTERN void widgets_search_panel_show_clear_button (WidgetsSearchPanel* self);
static void ___lambda100__gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender,
                                                   guint position,
                                                   const gchar* chars,
                                                   guint n_chars,
                                                   gpointer self);
static gboolean __lambda101_ (WidgetsSearchPanel* self,
                       GtkWidget* w,
                       GdkEventButton* e);
static gboolean ___lambda101__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static void __lambda102_ (WidgetsSearchPanel* self,
                   GtkEntry* w);
static void ___lambda102__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static gboolean __lambda103_ (WidgetsSearchPanel* self,
                       GtkWidget* w,
                       GdkEventButton* e);
static gboolean ___lambda103__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda104_ (WidgetsSearchPanel* self,
                       GtkWidget* w,
                       GdkEventButton* e);
static gboolean ___lambda104__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
VALA_EXTERN void utils_remove_all_children (GtkContainer* container);
static void widgets_search_panel_finalize (GObject * obj);
static GType widgets_search_panel_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		WidgetsSearchPanel* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->config_window);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}

static void
__lambda97_ (Block38Data* _data38_,
             ConfigConfig* w)
{
	WidgetsSearchPanel* self;
	self = _data38_->self;
	g_return_if_fail (w != NULL);
	widgets_search_panel_adjust_css_with_theme (self, _data38_->config_window);
}

static void
___lambda97__config_config_update (ConfigConfig* _sender,
                                   gpointer self)
{
	__lambda97_ (self, _sender);
}

static void
__lambda96_ (Block38Data* _data38_,
             GtkWidget* w)
{
	WidgetsSearchPanel* self;
	GtkWidget* _tmp0_;
	ConfigConfig* _tmp1_;
	self = _data38_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow)->config;
	g_signal_connect_data (_tmp1_, "update", (GCallback) ___lambda97__config_config_update, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
}

static void
___lambda96__gtk_widget_realize (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda96_ (self, _sender);
}

static gboolean
__lambda98_ (WidgetsSearchPanel* self,
             GtkWidget* w,
             GdkEventKey* e)
{
	gchar* keyname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = keymap_get_keyevent_name (e);
	keyname = _tmp0_;
	_tmp1_ = keyname;
	if (g_strcmp0 (_tmp1_, "Esc") == 0) {
		g_signal_emit (self, widgets_search_panel_signals[WIDGETS_SEARCH_PANEL_QUIT_SEARCH_SIGNAL], 0);
	} else {
		const gchar* _tmp2_;
		_tmp2_ = keyname;
		if (g_strcmp0 (_tmp2_, "Enter") == 0) {
			widgets_search_panel_update_search_text (self);
		} else {
			const gchar* _tmp3_;
			_tmp3_ = keyname;
			if (g_strcmp0 (_tmp3_, "Shift + Enter") == 0) {
				WidgetsTerm* _tmp4_;
				VteTerminal* _tmp5_;
				widgets_search_panel_update_search_text (self);
				_tmp4_ = self->terminal;
				_tmp5_ = _tmp4_->term;
				vte_terminal_search_find_previous (_tmp5_);
			}
		}
	}
	result = FALSE;
	_g_free0 (keyname);
	return result;
}

static gboolean
___lambda98__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda98_ ((WidgetsSearchPanel*) self, _sender, event);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
__lambda99_ (WidgetsSearchPanel* self,
             GtkEntryBuffer* buffer,
             guint p,
             guint nc)
{
	gchar* entry_text = NULL;
	WidgetsEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (buffer != NULL);
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = string_strip (_tmp1_);
	entry_text = _tmp2_;
	_tmp3_ = entry_text;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		widgets_search_panel_hide_clear_button (self);
	}
	widgets_search_panel_update_search_text (self);
	_g_free0 (entry_text);
}

static void
___lambda99__gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender,
                                            guint position,
                                            guint n_chars,
                                            gpointer self)
{
	__lambda99_ ((WidgetsSearchPanel*) self, _sender, position, n_chars);
}

static void
__lambda100_ (WidgetsSearchPanel* self,
              GtkEntryBuffer* buffer,
              guint p,
              const gchar* c,
              guint nc)
{
	gchar* entry_text = NULL;
	WidgetsEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = string_strip (_tmp1_);
	entry_text = _tmp2_;
	_tmp3_ = entry_text;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		widgets_search_panel_show_clear_button (self);
	}
	widgets_search_panel_update_search_text (self);
	_g_free0 (entry_text);
}

static void
___lambda100__gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender,
                                              guint position,
                                              const gchar* chars,
                                              guint n_chars,
                                              gpointer self)
{
	__lambda100_ ((WidgetsSearchPanel*) self, _sender, position, chars, n_chars);
}

static gboolean
__lambda101_ (WidgetsSearchPanel* self,
              GtkWidget* w,
              GdkEventButton* e)
{
	WidgetsEntry* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
	widgets_search_panel_update_search_text (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda101__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda101_ ((WidgetsSearchPanel*) self, _sender, event);
	return result;
}

static void
__lambda102_ (WidgetsSearchPanel* self,
              GtkEntry* w)
{
	const gchar* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->search_text;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		WidgetsTerm* _tmp1_;
		VteTerminal* _tmp2_;
		_tmp1_ = self->terminal;
		_tmp2_ = _tmp1_->term;
		vte_terminal_search_find_next (_tmp2_);
	}
}

static void
___lambda102__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	__lambda102_ ((WidgetsSearchPanel*) self, _sender);
}

static gboolean
__lambda103_ (WidgetsSearchPanel* self,
              GtkWidget* w,
              GdkEventButton* e)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->search_text;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		WidgetsTerm* _tmp1_;
		VteTerminal* _tmp2_;
		widgets_search_panel_update_search_text (self);
		_tmp1_ = self->terminal;
		_tmp2_ = _tmp1_->term;
		vte_terminal_search_find_next (_tmp2_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda103__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda103_ ((WidgetsSearchPanel*) self, _sender, event);
	return result;
}

static gboolean
__lambda104_ (WidgetsSearchPanel* self,
              GtkWidget* w,
              GdkEventButton* e)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->search_text;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		WidgetsTerm* _tmp1_;
		VteTerminal* _tmp2_;
		widgets_search_panel_update_search_text (self);
		_tmp1_ = self->terminal;
		_tmp2_ = _tmp1_->term;
		vte_terminal_search_find_previous (_tmp2_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda104__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda104_ ((WidgetsSearchPanel*) self, _sender, event);
	return result;
}

WidgetsSearchPanel*
widgets_search_panel_construct (GType object_type,
                                WidgetsConfigWindow* config_window,
                                WidgetsTerm* term,
                                const gchar* init_search_text)
{
	WidgetsSearchPanel * self = NULL;
	Block38Data* _data38_;
	WidgetsConfigWindow* _tmp0_;
	WidgetsTerm* _tmp1_;
	gchar* _tmp2_;
	WidgetsImageButton* _tmp3_;
	WidgetsEntry* _tmp4_;
	GtkBox* _tmp5_;
	WidgetsImageButton* _tmp6_;
	WidgetsImageButton* _tmp7_;
	WidgetsImageButton* _tmp8_;
	WidgetsEntry* _tmp9_;
	WidgetsImageButton* _tmp10_;
	WidgetsEntry* _tmp11_;
	GtkBox* _tmp12_;
	WidgetsImageButton* _tmp13_;
	WidgetsImageButton* _tmp14_;
	WidgetsImageButton* _tmp15_;
	WidgetsEntry* _tmp16_;
	WidgetsImageButton* _tmp17_;
	WidgetsImageButton* _tmp18_;
	GtkBox* _tmp19_;
	WidgetsImageButton* _tmp20_;
	GtkBox* _tmp21_;
	WidgetsImageButton* _tmp22_;
	WidgetsEntry* _tmp23_;
	WidgetsImageButton* _tmp24_;
	WidgetsEntry* _tmp25_;
	WidgetsEntry* _tmp26_;
	GtkEntryBuffer* _tmp27_;
	WidgetsEntry* _tmp28_;
	GtkEntryBuffer* _tmp29_;
	WidgetsImageButton* _tmp30_;
	WidgetsEntry* _tmp31_;
	WidgetsImageButton* _tmp32_;
	WidgetsImageButton* _tmp33_;
	g_return_val_if_fail (config_window != NULL, NULL);
	g_return_val_if_fail (term != NULL, NULL);
	g_return_val_if_fail (init_search_text != NULL, NULL);
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (config_window);
	_g_object_unref0 (_data38_->config_window);
	_data38_->config_window = _tmp0_;
	self = (WidgetsSearchPanel*) g_object_new (object_type, NULL);
	_data38_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (term);
	_g_object_unref0 (self->terminal);
	self->terminal = _tmp1_;
	_tmp2_ = g_strdup (init_search_text);
	_g_free0 (self->search_text);
	self->search_text = _tmp2_;
	_tmp3_ = widgets_image_button_new ("search", TRUE, NULL, 12);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->search_image);
	self->search_image = _tmp3_;
	_tmp4_ = widgets_entry_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp4_;
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->clear_button_box);
	self->clear_button_box = _tmp5_;
	_tmp6_ = widgets_image_button_new ("search_clear", TRUE, NULL, 12);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->clear_button);
	self->clear_button = _tmp6_;
	_tmp7_ = widgets_image_button_new ("search_next", TRUE, NULL, 12);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->search_next_button);
	self->search_next_button = _tmp7_;
	_tmp8_ = widgets_image_button_new ("search_previous", TRUE, NULL, 12);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->search_previous_button);
	self->search_previous_button = _tmp8_;
	_tmp9_ = self->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp9_, init_search_text);
	_tmp10_ = self->search_image;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 0);
	_tmp11_ = self->search_entry;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp11_, TRUE, TRUE, (guint) 0);
	_tmp12_ = self->clear_button_box;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp12_, FALSE, FALSE, (guint) 0);
	_tmp13_ = self->search_previous_button;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
	_tmp14_ = self->search_next_button;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = self->search_image;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	_tmp16_ = self->search_entry;
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
	_tmp17_ = self->search_next_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
	_tmp18_ = self->search_previous_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
	_tmp19_ = self->clear_button_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_CENTER);
	_tmp20_ = self->search_image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp20_, self->margin_horizontal);
	_tmp21_ = self->clear_button_box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp21_, self->margin_horizontal);
	_tmp22_ = self->search_previous_button;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp22_, self->margin_horizontal);
	_tmp23_ = self->search_entry;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp23_, self->button_margin);
	_tmp24_ = self->search_next_button;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp24_, self->button_margin);
	gtk_widget_set_size_request ((GtkWidget*) self, constant_SEARCH_PANEL_WIDTH, constant_TITLEBAR_HEIGHT);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_END);
	widgets_search_panel_adjust_css_with_theme (self, _data38_->config_window);
	g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) ___lambda96__gtk_widget_realize, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
	_tmp25_ = self->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp25_, "key-press-event", (GCallback) ___lambda98__gtk_widget_key_press_event, self, 0);
	_tmp26_ = self->search_entry;
	_tmp27_ = gtk_entry_get_buffer ((GtkEntry*) _tmp26_);
	g_signal_connect_object (_tmp27_, "deleted-text", (GCallback) ___lambda99__gtk_entry_buffer_deleted_text, self, 0);
	_tmp28_ = self->search_entry;
	_tmp29_ = gtk_entry_get_buffer ((GtkEntry*) _tmp28_);
	g_signal_connect_object (_tmp29_, "inserted-text", (GCallback) ___lambda100__gtk_entry_buffer_inserted_text, self, 0);
	_tmp30_ = self->clear_button;
	g_signal_connect_object ((GtkWidget*) _tmp30_, "button-press-event", (GCallback) ___lambda101__gtk_widget_button_press_event, self, 0);
	_tmp31_ = self->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp31_, "activate", (GCallback) ___lambda102__gtk_entry_activate, self, 0);
	_tmp32_ = self->search_next_button;
	g_signal_connect_object ((GtkWidget*) _tmp32_, "button-press-event", (GCallback) ___lambda103__gtk_widget_button_press_event, self, 0);
	_tmp33_ = self->search_previous_button;
	g_signal_connect_object ((GtkWidget*) _tmp33_, "button-press-event", (GCallback) ___lambda104__gtk_widget_button_press_event, self, 0);
	block38_data_unref (_data38_);
	_data38_ = NULL;
	return self;
}

WidgetsSearchPanel*
widgets_search_panel_new (WidgetsConfigWindow* config_window,
                          WidgetsTerm* term,
                          const gchar* init_search_text)
{
	return widgets_search_panel_construct (WIDGETS_TYPE_SEARCH_PANEL, config_window, term, init_search_text);
}

void
widgets_search_panel_update_search_text (WidgetsSearchPanel* self)
{
	gchar* entry_text = NULL;
	WidgetsEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = string_strip (_tmp1_);
	entry_text = _tmp2_;
	_tmp3_ = g_strdup (entry_text);
	_g_free0 (self->search_text);
	self->search_text = _tmp3_;
	{
		gchar* pattern = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		guint flags = 0U;
		VteRegex* regex = NULL;
		VteRegex* _tmp6_;
		WidgetsTerm* _tmp7_;
		VteTerminal* _tmp8_;
		WidgetsTerm* _tmp9_;
		VteTerminal* _tmp10_;
		_tmp4_ = self->search_text;
		_tmp5_ = g_regex_escape_string (_tmp4_, -1);
		pattern = _tmp5_;
		flags = 0x00000400U | 0x00000008U;
		_tmp6_ = vte_regex_new_for_search (pattern, (gssize) -1, (guint32) flags, &_inner_error0_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (pattern);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			goto __finally0;
		}
		_tmp7_ = self->terminal;
		_tmp8_ = _tmp7_->term;
		vte_terminal_search_set_regex (_tmp8_, regex, (guint32) 0);
		_tmp9_ = self->terminal;
		_tmp10_ = _tmp9_->term;
		vte_terminal_search_set_wrap_around (_tmp10_, TRUE);
		_vte_regex_unref0 (regex);
		_g_free0 (pattern);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		FILE* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = stdout;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "Got error %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (entry_text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (entry_text);
}

void
widgets_search_panel_adjust_css_with_theme (WidgetsSearchPanel* self,
                                            WidgetsConfigWindow* config_window)
{
	gboolean is_light_theme = FALSE;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	WidgetsEntry* _tmp2_;
	GtkStyleContext* _tmp3_;
	WidgetsEntry* _tmp4_;
	GtkStyleContext* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config_window != NULL);
	is_light_theme = widgets_config_window_is_light_theme (config_window);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp0_, "search_light_box");
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp1_, "search_dark_box");
	_tmp2_ = self->search_entry;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_remove_class (_tmp3_, "search_dark_entry");
	_tmp4_ = self->search_entry;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_remove_class (_tmp5_, "search_light_entry");
	if (is_light_theme) {
		WidgetsEntry* _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkStyleContext* _tmp8_;
		_tmp6_ = self->search_entry;
		_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
		gtk_style_context_add_class (_tmp7_, "search_light_entry");
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp8_, "search_light_box");
	} else {
		WidgetsEntry* _tmp9_;
		GtkStyleContext* _tmp10_;
		GtkStyleContext* _tmp11_;
		_tmp9_ = self->search_entry;
		_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
		gtk_style_context_add_class (_tmp10_, "search_dark_entry");
		_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp11_, "search_dark_box");
	}
}

void
widgets_search_panel_show_clear_button (WidgetsSearchPanel* self)
{
	GtkBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->clear_button_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_) == ((guint) 0);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	if (_tmp3_) {
		GtkBox* _tmp4_;
		WidgetsImageButton* _tmp5_;
		_tmp4_ = self->clear_button_box;
		_tmp5_ = self->clear_button;
		gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
		gtk_widget_show_all ((GtkWidget*) self);
	}
}

void
widgets_search_panel_hide_clear_button (WidgetsSearchPanel* self)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->clear_button_box;
	utils_remove_all_children ((GtkContainer*) _tmp0_);
}

static void
widgets_search_panel_class_init (WidgetsSearchPanelClass * klass,
                                 gpointer klass_data)
{
	widgets_search_panel_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_search_panel_finalize;
	widgets_search_panel_signals[WIDGETS_SEARCH_PANEL_QUIT_SEARCH_SIGNAL] = g_signal_new ("quit-search", WIDGETS_TYPE_SEARCH_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
widgets_search_panel_instance_init (WidgetsSearchPanel * self,
                                    gpointer klass)
{
	self->button_margin = 4;
	self->margin_horizontal = 10;
}

static void
widgets_search_panel_finalize (GObject * obj)
{
	WidgetsSearchPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_SEARCH_PANEL, WidgetsSearchPanel);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->clear_button_box);
	_g_object_unref0 (self->clear_button);
	_g_object_unref0 (self->search_next_button);
	_g_object_unref0 (self->search_previous_button);
	_g_object_unref0 (self->terminal);
	_g_object_unref0 (self->search_image);
	_g_free0 (self->search_text);
	G_OBJECT_CLASS (widgets_search_panel_parent_class)->finalize (obj);
}

static GType
widgets_search_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsSearchPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_search_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsSearchPanel), 0, (GInstanceInitFunc) widgets_search_panel_instance_init, NULL };
	GType widgets_search_panel_type_id;
	widgets_search_panel_type_id = g_type_register_static (gtk_hbox_get_type (), "WidgetsSearchPanel", &g_define_type_info, 0);
	return widgets_search_panel_type_id;
}

GType
widgets_search_panel_get_type (void)
{
	static volatile gsize widgets_search_panel_type_id__once = 0;
	if (g_once_init_enter (&widgets_search_panel_type_id__once)) {
		GType widgets_search_panel_type_id;
		widgets_search_panel_type_id = widgets_search_panel_get_type_once ();
		g_once_init_leave (&widgets_search_panel_type_id__once, widgets_search_panel_type_id);
	}
	return widgets_search_panel_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

