// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/*****************************************************************************/
#ifndef SIMD_AS_HWINTRINSIC
#error Define SIMD_AS_HWINTRINSIC before including this file
#endif

#if defined(SIMD_AS_HWINTRINSIC_ID) || defined(SIMD_AS_HWINTRINSIC_NM)
#error SIMD_AS_HWINTRINSIC_ID and SIMD_AS_HWINTRINSIC_NM should not be defined before including this file
#endif
/*****************************************************************************/

// clang-format off

#ifdef FEATURE_HW_INTRINSICS

// Defines a SimdAsHWIntrinsic where the name is implicitly taken from the id
#define SIMD_AS_HWINTRINSIC_ID(classId, id, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)                      \
    SIMD_AS_HWINTRINSIC(classId, id, #id, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)

// Defines a SimdAsHWIntrinsic where the name is explicit
#define SIMD_AS_HWINTRINSIC_NM(classId, id, name, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)                \
    SIMD_AS_HWINTRINSIC(classId, id, name, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)

/* Note
    * Each intrinsic has a unique Intrinsic ID with type of `enum NamedIntrinsic`
    * Each intrinsic has a `NumArg` for number of parameters
    * Each intrinsic has 10 `NamedIntrinsic` fields that list the HWIntrinsic that should be generated based-on the base type
        * NI_Illegal is used to represent an unsupported type
        * Using the same Intrinsic ID as the represented entry is used to indicate special handling is required
    * Each intrinsic has one or more flags with type of `enum SimdAsHWIntrinsicFlag`
*/

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                           Flags
//                                                                                                     {TYP_BYTE,                                  TYP_UBYTE,                                  TYP_SHORT,                                  TYP_USHORT,                                 TYP_INT,                                    TYP_UINT,                                   TYP_LONG,                                   TYP_ULONG,                                  TYP_FLOAT,                                  TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector2 Intrinsics
SIMD_AS_HWINTRINSIC_ID(Vector2,     Abs,                                                    1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector2_Abs,                             NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector2,     CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector2_CreateBroadcast,                 NI_Illegal},                                SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Dot,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_Dot,                           NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     get_One,                                                0,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector2_get_One,                         NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     get_Zero,                                               0,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector2_get_Zero,                        NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Max,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Max,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Min,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Min,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Addition,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Add,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Division,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector2_op_Division,                     NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Equality,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_op_Equality,                   NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Inequality,                                          2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_op_Inequality,                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Multiply,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Multiply,                            NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Subtraction,                                         2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Subtract,                            NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     SquareRoot,                                             1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Sqrt,                                NI_Illegal},                                SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                           Flags
//                                                                                                     {TYP_BYTE,                                  TYP_UBYTE,                                  TYP_SHORT,                                  TYP_USHORT,                                 TYP_INT,                                    TYP_UINT,                                   TYP_LONG,                                   TYP_ULONG,                                  TYP_FLOAT,                                  TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector3 Intrinsics
SIMD_AS_HWINTRINSIC_ID(Vector3,     Abs,                                                    1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector3_Abs,                             NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector3,     CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector3_CreateBroadcast,                 NI_Illegal},                                SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Dot,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_Dot,                           NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_One,                                                0,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector3_get_One,                         NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_Zero,                                               0,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector3_get_Zero,                        NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Max,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Max,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Min,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Min,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Addition,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Add,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Division,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector3_op_Division,                     NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Equality,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_op_Equality,                   NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Inequality,                                          2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_op_Inequality,                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Multiply,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Multiply,                            NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Subtraction,                                         2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Subtract,                            NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     SquareRoot,                                             1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Sqrt,                                NI_Illegal},                                SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                           Flags
//                                                                                                     {TYP_BYTE,                                  TYP_UBYTE,                                  TYP_SHORT,                                  TYP_USHORT,                                 TYP_INT,                                    TYP_UINT,                                   TYP_LONG,                                   TYP_ULONG,                                  TYP_FLOAT,                                  TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector4 Intrinsics
SIMD_AS_HWINTRINSIC_ID(Vector4,     Abs,                                                    1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector4_Abs,                             NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector4,     CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector4_CreateBroadcast,                 NI_Illegal},                                SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Dot,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_Dot,                           NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_One,                                                0,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector4_get_One,                         NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_Zero,                                               0,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector4_get_Zero,                        NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Max,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Max,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Min,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Min,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Addition,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Add,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Division,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Divide,                              NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Equality,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_op_Equality,                   NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Inequality,                                          2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_op_Inequality,                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Multiply,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Multiply,                            NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Subtraction,                                         2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Subtract,                            NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     SquareRoot,                                             1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Sqrt,                                NI_Illegal},                                SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                           Flags
//                                                                                                     {TYP_BYTE,                                  TYP_UBYTE,                                  TYP_SHORT,                                  TYP_USHORT,                                 TYP_INT,                                    TYP_UINT,                                   TYP_LONG,                                   TYP_ULONG,                                  TYP_FLOAT,                                  TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector<T> Intrinsics
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Abs,                                                    1,         {NI_VectorT128_Abs,                         NI_VectorT128_Abs,                          NI_VectorT128_Abs,                          NI_VectorT128_Abs,                          NI_VectorT128_Abs,                          NI_VectorT128_Abs,                          NI_VectorT128_Abs,                          NI_VectorT128_Abs,                          NI_VectorT128_Abs,                          NI_VectorT128_Abs},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AndNot,                                                 2,         {NI_SSE2_AndNot,                            NI_SSE2_AndNot,                             NI_SSE2_AndNot,                             NI_SSE2_AndNot,                             NI_SSE2_AndNot,                             NI_SSE2_AndNot,                             NI_SSE2_AndNot,                             NI_SSE2_AndNot,                             NI_SSE_AndNot,                              NI_SSE2_AndNot},                            SimdAsHWIntrinsicFlag::NeedsOperandsSwapped | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  As,                                                     1,         {NI_VectorT128_As,                          NI_VectorT128_As,                           NI_VectorT128_As,                           NI_VectorT128_As,                           NI_VectorT128_As,                           NI_VectorT128_As,                           NI_VectorT128_As,                           NI_VectorT128_As,                           NI_VectorT128_As,                           NI_VectorT128_As},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Ceiling,                                                1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE41_Ceiling,                           NI_SSE41_Ceiling},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConditionalSelect,                                      3,         {NI_VectorT128_ConditionalSelect,           NI_VectorT128_ConditionalSelect,            NI_VectorT128_ConditionalSelect,            NI_VectorT128_ConditionalSelect,            NI_VectorT128_ConditionalSelect,            NI_VectorT128_ConditionalSelect,            NI_VectorT128_ConditionalSelect,            NI_VectorT128_ConditionalSelect,            NI_VectorT128_ConditionalSelect,            NI_VectorT128_ConditionalSelect},           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToDouble,                                        1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT128_ConvertToDouble,              NI_VectorT128_ConvertToDouble,              NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToInt32,                                         1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT128_ConvertToInt32,               NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToInt64,                                         1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT128_ConvertToInt64},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToSingle,                                        1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT128_ConvertToSingle,              NI_VectorT128_ConvertToSingle,              NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToUInt32,                                        1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT128_ConvertToUInt32,              NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConvertToUInt64,                                        1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT128_ConvertToUInt64},             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(VectorT128,  CreateBroadcast,            ".ctor",                    2,         {NI_VectorT128_CreateBroadcast,             NI_VectorT128_CreateBroadcast,              NI_VectorT128_CreateBroadcast,              NI_VectorT128_CreateBroadcast,              NI_VectorT128_CreateBroadcast,              NI_VectorT128_CreateBroadcast,              NI_VectorT128_CreateBroadcast,              NI_VectorT128_CreateBroadcast,              NI_VectorT128_CreateBroadcast,              NI_VectorT128_CreateBroadcast},             SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Dot,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Vector128_Dot,                           NI_Vector128_Dot,                           NI_VectorT128_Dot,                          NI_VectorT128_Dot,                          NI_Illegal,                                 NI_Illegal,                                 NI_Vector128_Dot,                           NI_Vector128_Dot},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Equals,                                                 2,         {NI_SSE2_CompareEqual,                      NI_SSE2_CompareEqual,                       NI_SSE2_CompareEqual,                       NI_SSE2_CompareEqual,                       NI_SSE2_CompareEqual,                       NI_SSE2_CompareEqual,                       NI_VectorT128_Equals,                       NI_VectorT128_Equals,                       NI_SSE_CompareEqual,                        NI_SSE2_CompareEqual},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Floor,                                                  1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE41_Floor,                             NI_SSE41_Floor},                            SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_AllBitsSet,                                         0,         {NI_VectorT128_get_AllBitsSet,              NI_VectorT128_get_AllBitsSet,               NI_VectorT128_get_AllBitsSet,               NI_VectorT128_get_AllBitsSet,               NI_VectorT128_get_AllBitsSet,               NI_VectorT128_get_AllBitsSet,               NI_VectorT128_get_AllBitsSet,               NI_VectorT128_get_AllBitsSet,               NI_VectorT128_get_AllBitsSet,               NI_VectorT128_get_AllBitsSet},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_Count,                                              0,         {NI_VectorT128_get_Count,                   NI_VectorT128_get_Count,                    NI_VectorT128_get_Count,                    NI_VectorT128_get_Count,                    NI_VectorT128_get_Count,                    NI_VectorT128_get_Count,                    NI_VectorT128_get_Count,                    NI_VectorT128_get_Count,                    NI_VectorT128_get_Count,                    NI_VectorT128_get_Count},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_Item,                                               2,         {NI_VectorT128_get_Item,                    NI_VectorT128_get_Item,                     NI_VectorT128_get_Item,                     NI_VectorT128_get_Item,                     NI_VectorT128_get_Item,                     NI_VectorT128_get_Item,                     NI_VectorT128_get_Item,                     NI_VectorT128_get_Item,                     NI_VectorT128_get_Item,                     NI_VectorT128_get_Item},                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_One,                                                0,         {NI_VectorT128_get_One,                     NI_VectorT128_get_One,                      NI_VectorT128_get_One,                      NI_VectorT128_get_One,                      NI_VectorT128_get_One,                      NI_VectorT128_get_One,                      NI_VectorT128_get_One,                      NI_VectorT128_get_One,                      NI_VectorT128_get_One,                      NI_VectorT128_get_One},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_Zero,                                               0,         {NI_VectorT128_get_Zero,                    NI_VectorT128_get_Zero,                     NI_VectorT128_get_Zero,                     NI_VectorT128_get_Zero,                     NI_VectorT128_get_Zero,                     NI_VectorT128_get_Zero,                     NI_VectorT128_get_Zero,                     NI_VectorT128_get_Zero,                     NI_VectorT128_get_Zero,                     NI_VectorT128_get_Zero},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThan,                                            2,         {NI_SSE2_CompareGreaterThan,                NI_VectorT128_GreaterThan,                  NI_SSE2_CompareGreaterThan,                 NI_VectorT128_GreaterThan,                  NI_SSE2_CompareGreaterThan,                 NI_VectorT128_GreaterThan,                  NI_VectorT128_GreaterThan,                  NI_VectorT128_GreaterThan,                  NI_SSE_CompareGreaterThan,                  NI_SSE2_CompareGreaterThan},                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThanOrEqual,                                     2,         {NI_VectorT128_GreaterThanOrEqual,          NI_VectorT128_GreaterThanOrEqual,           NI_VectorT128_GreaterThanOrEqual,           NI_VectorT128_GreaterThanOrEqual,           NI_VectorT128_GreaterThanOrEqual,           NI_VectorT128_GreaterThanOrEqual,           NI_VectorT128_GreaterThanOrEqual,           NI_VectorT128_GreaterThanOrEqual,           NI_SSE_CompareGreaterThanOrEqual,           NI_SSE2_CompareGreaterThanOrEqual},         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThan,                                               2,         {NI_SSE2_CompareLessThan,                   NI_VectorT128_LessThan,                     NI_SSE2_CompareLessThan,                    NI_VectorT128_LessThan,                     NI_SSE2_CompareLessThan,                    NI_VectorT128_LessThan,                     NI_VectorT128_LessThan,                     NI_VectorT128_LessThan,                     NI_SSE_CompareLessThan,                     NI_SSE2_CompareLessThan},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThanOrEqual,                                        2,         {NI_VectorT128_LessThanOrEqual,             NI_VectorT128_LessThanOrEqual,              NI_VectorT128_LessThanOrEqual,              NI_VectorT128_LessThanOrEqual,              NI_VectorT128_LessThanOrEqual,              NI_VectorT128_LessThanOrEqual,              NI_VectorT128_LessThanOrEqual,              NI_VectorT128_LessThanOrEqual,              NI_SSE_CompareLessThanOrEqual,              NI_SSE2_CompareLessThanOrEqual},            SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Max,                                                    2,         {NI_VectorT128_Max,                         NI_SSE2_Max,                                NI_SSE2_Max,                                NI_VectorT128_Max,                          NI_VectorT128_Max,                          NI_VectorT128_Max,                          NI_VectorT128_Max,                          NI_VectorT128_Max,                          NI_SSE_Max,                                 NI_SSE2_Max},                               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Min,                                                    2,         {NI_VectorT128_Min,                         NI_SSE2_Min,                                NI_SSE2_Min,                                NI_VectorT128_Min,                          NI_VectorT128_Min,                          NI_VectorT128_Min,                          NI_VectorT128_Min,                          NI_VectorT128_Min,                          NI_SSE_Min,                                 NI_SSE2_Min},                               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Narrow,                                                 2,         {NI_VectorT128_Narrow,                      NI_VectorT128_Narrow,                       NI_VectorT128_Narrow,                       NI_VectorT128_Narrow,                       NI_VectorT128_Narrow,                       NI_VectorT128_Narrow,                       NI_VectorT128_Narrow,                       NI_VectorT128_Narrow,                       NI_VectorT128_Narrow,                       NI_VectorT128_Narrow},                      SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Addition,                                            2,         {NI_SSE2_Add,                               NI_SSE2_Add,                                NI_SSE2_Add,                                NI_SSE2_Add,                                NI_SSE2_Add,                                NI_SSE2_Add,                                NI_SSE2_Add,                                NI_SSE2_Add,                                NI_SSE_Add,                                 NI_SSE2_Add},                               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_BitwiseAnd,                                          2,         {NI_SSE2_And,                               NI_SSE2_And,                                NI_SSE2_And,                                NI_SSE2_And,                                NI_SSE2_And,                                NI_SSE2_And,                                NI_SSE2_And,                                NI_SSE2_And,                                NI_SSE_And,                                 NI_SSE2_And},                               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_BitwiseOr,                                           2,         {NI_SSE2_Or,                                NI_SSE2_Or,                                 NI_SSE2_Or,                                 NI_SSE2_Or,                                 NI_SSE2_Or,                                 NI_SSE2_Or,                                 NI_SSE2_Or,                                 NI_SSE2_Or,                                 NI_SSE_Or,                                  NI_SSE2_Or},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Division,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Divide,                              NI_SSE2_Divide},                            SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Equality,                                            2,         {NI_Vector128_op_Equality,                  NI_Vector128_op_Equality,                   NI_Vector128_op_Equality,                   NI_Vector128_op_Equality,                   NI_Vector128_op_Equality,                   NI_Vector128_op_Equality,                   NI_Vector128_op_Equality,                   NI_Vector128_op_Equality,                   NI_Vector128_op_Equality,                   NI_Vector128_op_Equality},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_ExclusiveOr,                                         2,         {NI_SSE2_Xor,                               NI_SSE2_Xor,                                NI_SSE2_Xor,                                NI_SSE2_Xor,                                NI_SSE2_Xor,                                NI_SSE2_Xor,                                NI_SSE2_Xor,                                NI_SSE2_Xor,                                NI_SSE_Xor,                                 NI_SSE2_Xor},                               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Explicit,                                            1,         {NI_VectorT128_op_Explicit,                 NI_VectorT128_op_Explicit,                  NI_VectorT128_op_Explicit,                  NI_VectorT128_op_Explicit,                  NI_VectorT128_op_Explicit,                  NI_VectorT128_op_Explicit,                  NI_VectorT128_op_Explicit,                  NI_VectorT128_op_Explicit,                  NI_VectorT128_op_Explicit,                  NI_VectorT128_op_Explicit},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Inequality,                                          2,         {NI_Vector128_op_Inequality,                NI_Vector128_op_Inequality,                 NI_Vector128_op_Inequality,                 NI_Vector128_op_Inequality,                 NI_Vector128_op_Inequality,                 NI_Vector128_op_Inequality,                 NI_Vector128_op_Inequality,                 NI_Vector128_op_Inequality,                 NI_Vector128_op_Inequality,                 NI_Vector128_op_Inequality},                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Multiply,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT128_op_Multiply,                  NI_VectorT128_op_Multiply,                  NI_VectorT128_op_Multiply,                  NI_VectorT128_op_Multiply,                  NI_Illegal,                                 NI_Illegal,                                 NI_VectorT128_op_Multiply,                  NI_VectorT128_op_Multiply},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Subtraction,                                         2,         {NI_SSE2_Subtract,                          NI_SSE2_Subtract,                           NI_SSE2_Subtract,                           NI_SSE2_Subtract,                           NI_SSE2_Subtract,                           NI_SSE2_Subtract,                           NI_SSE2_Subtract,                           NI_SSE2_Subtract,                           NI_SSE_Subtract,                            NI_SSE2_Subtract},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ShiftLeft,                                              2,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT128_ShiftLeft,                    NI_VectorT128_ShiftLeft,                    NI_VectorT128_ShiftLeft,                    NI_VectorT128_ShiftLeft,                    NI_VectorT128_ShiftLeft,                    NI_VectorT128_ShiftLeft,                    NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ShiftRightArithmetic,                                   2,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT128_ShiftRightArithmetic,         NI_Illegal,                                 NI_VectorT128_ShiftRightArithmetic,         NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ShiftRightLogical,                                      2,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT128_ShiftRightLogical,            NI_VectorT128_ShiftRightLogical,            NI_VectorT128_ShiftRightLogical,            NI_VectorT128_ShiftRightLogical,            NI_VectorT128_ShiftRightLogical,            NI_VectorT128_ShiftRightLogical,            NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  SquareRoot,                                             1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_SSE_Sqrt,                                NI_SSE2_Sqrt},                              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Sum,                                                    1,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT128_Sum,                          NI_VectorT128_Sum,                          NI_VectorT128_Sum,                          NI_VectorT128_Sum,                          NI_Illegal,                                 NI_Illegal,                                 NI_VectorT128_Sum,                          NI_VectorT128_Sum},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  WidenLower,                                             1,         {NI_VectorT128_WidenLower,                  NI_VectorT128_WidenLower,                   NI_VectorT128_WidenLower,                   NI_VectorT128_WidenLower,                   NI_VectorT128_WidenLower,                   NI_VectorT128_WidenLower,                   NI_VectorT128_WidenLower,                   NI_VectorT128_WidenLower,                   NI_VectorT128_WidenLower,                   NI_VectorT128_WidenLower},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  WidenUpper,                                             1,         {NI_VectorT128_WidenUpper,                  NI_VectorT128_WidenUpper,                   NI_VectorT128_WidenUpper,                   NI_VectorT128_WidenUpper,                   NI_VectorT128_WidenUpper,                   NI_VectorT128_WidenUpper,                   NI_VectorT128_WidenUpper,                   NI_VectorT128_WidenUpper,                   NI_VectorT128_WidenUpper,                   NI_VectorT128_WidenUpper},                  SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                           Flags
//                                                                                                     {TYP_BYTE,                                  TYP_UBYTE,                                  TYP_SHORT,                                  TYP_USHORT,                                 TYP_INT,                                    TYP_UINT,                                   TYP_LONG,                                   TYP_ULONG,                                  TYP_FLOAT,                                  TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector<T> Intrinsics
SIMD_AS_HWINTRINSIC_ID(VectorT256,  Abs,                                                    1,         {NI_AVX2_Abs,                               NI_VectorT256_Abs,                          NI_AVX2_Abs,                                NI_VectorT256_Abs,                          NI_AVX2_Abs,                                NI_VectorT256_Abs,                          NI_VectorT256_Abs,                          NI_VectorT256_Abs,                          NI_VectorT256_Abs,                          NI_VectorT256_Abs},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  AndNot,                                                 2,         {NI_AVX2_AndNot,                            NI_AVX2_AndNot,                             NI_AVX2_AndNot,                             NI_AVX2_AndNot,                             NI_AVX2_AndNot,                             NI_AVX2_AndNot,                             NI_AVX2_AndNot,                             NI_AVX2_AndNot,                             NI_AVX_AndNot,                              NI_AVX_AndNot},                             SimdAsHWIntrinsicFlag::NeedsOperandsSwapped | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  As,                                                     1,         {NI_VectorT256_As,                          NI_VectorT256_As,                           NI_VectorT256_As,                           NI_VectorT256_As,                           NI_VectorT256_As,                           NI_VectorT256_As,                           NI_VectorT256_As,                           NI_VectorT256_As,                           NI_VectorT256_As,                           NI_VectorT256_As},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  Ceiling,                                                1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_AVX_Ceiling,                             NI_AVX_Ceiling},                            SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ConditionalSelect,                                      3,         {NI_VectorT256_ConditionalSelect,           NI_VectorT256_ConditionalSelect,            NI_VectorT256_ConditionalSelect,            NI_VectorT256_ConditionalSelect,            NI_VectorT256_ConditionalSelect,            NI_VectorT256_ConditionalSelect,            NI_VectorT256_ConditionalSelect,            NI_VectorT256_ConditionalSelect,            NI_VectorT256_ConditionalSelect,            NI_VectorT256_ConditionalSelect},           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ConvertToDouble,                                        1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT256_ConvertToDouble,              NI_VectorT256_ConvertToDouble,              NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ConvertToInt32,                                         1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT256_ConvertToInt32,               NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ConvertToInt64,                                         1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT256_ConvertToInt64},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ConvertToSingle,                                        1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT256_ConvertToSingle,              NI_VectorT256_ConvertToSingle,              NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ConvertToUInt32,                                        1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT256_ConvertToUInt32,              NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ConvertToUInt64,                                        1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT256_ConvertToUInt64},             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(VectorT256,  CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_VectorT256_CreateBroadcast,              NI_VectorT256_CreateBroadcast,              NI_VectorT256_CreateBroadcast,              NI_VectorT256_CreateBroadcast,              NI_VectorT256_CreateBroadcast,              NI_VectorT256_CreateBroadcast},             SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::SpillSideEffectsOp1)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  Dot,                                                    2,         {NI_Illegal,                                NI_Illegal,                                 NI_Vector256_Dot,                           NI_Vector256_Dot,                           NI_Vector256_Dot,                           NI_Vector256_Dot,                           NI_Illegal,                                 NI_Illegal,                                 NI_Vector256_Dot,                           NI_Vector256_Dot},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  Equals,                                                 2,         {NI_AVX2_CompareEqual,                      NI_AVX2_CompareEqual,                       NI_AVX2_CompareEqual,                       NI_AVX2_CompareEqual,                       NI_AVX2_CompareEqual,                       NI_AVX2_CompareEqual,                       NI_AVX2_CompareEqual,                       NI_AVX2_CompareEqual,                       NI_AVX_CompareEqual,                        NI_AVX_CompareEqual},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  Floor,                                                  1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_AVX_Floor,                               NI_AVX_Floor},                              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  get_AllBitsSet,                                         0,         {NI_VectorT256_get_AllBitsSet,              NI_VectorT256_get_AllBitsSet,               NI_VectorT256_get_AllBitsSet,               NI_VectorT256_get_AllBitsSet,               NI_VectorT256_get_AllBitsSet,               NI_VectorT256_get_AllBitsSet,               NI_VectorT256_get_AllBitsSet,               NI_VectorT256_get_AllBitsSet,               NI_VectorT256_get_AllBitsSet,               NI_VectorT256_get_AllBitsSet},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  get_Count,                                              0,         {NI_VectorT256_get_Count,                   NI_VectorT256_get_Count,                    NI_VectorT256_get_Count,                    NI_VectorT256_get_Count,                    NI_VectorT256_get_Count,                    NI_VectorT256_get_Count,                    NI_VectorT256_get_Count,                    NI_VectorT256_get_Count,                    NI_VectorT256_get_Count,                    NI_VectorT256_get_Count},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  get_Item,                                               2,         {NI_VectorT256_get_Item,                    NI_VectorT256_get_Item,                     NI_VectorT256_get_Item,                     NI_VectorT256_get_Item,                     NI_VectorT256_get_Item,                     NI_VectorT256_get_Item,                     NI_VectorT256_get_Item,                     NI_VectorT256_get_Item,                     NI_VectorT256_get_Item,                     NI_VectorT256_get_Item},                    SimdAsHWIntrinsicFlag::InstanceMethod | SimdAsHWIntrinsicFlag::BaseTypeFromThisArg)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  get_One,                                                0,         {NI_VectorT256_get_One,                     NI_VectorT256_get_One,                      NI_VectorT256_get_One,                      NI_VectorT256_get_One,                      NI_VectorT256_get_One,                      NI_VectorT256_get_One,                      NI_VectorT256_get_One,                      NI_VectorT256_get_One,                      NI_VectorT256_get_One,                      NI_VectorT256_get_One},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  get_Zero,                                               0,         {NI_VectorT256_get_Zero,                    NI_VectorT256_get_Zero,                     NI_VectorT256_get_Zero,                     NI_VectorT256_get_Zero,                     NI_VectorT256_get_Zero,                     NI_VectorT256_get_Zero,                     NI_VectorT256_get_Zero,                     NI_VectorT256_get_Zero,                     NI_VectorT256_get_Zero,                     NI_VectorT256_get_Zero},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  GreaterThan,                                            2,         {NI_AVX2_CompareGreaterThan,                NI_VectorT256_GreaterThan,                  NI_AVX2_CompareGreaterThan,                 NI_VectorT256_GreaterThan,                  NI_AVX2_CompareGreaterThan,                 NI_VectorT256_GreaterThan,                  NI_AVX2_CompareGreaterThan,                 NI_VectorT256_GreaterThan,                  NI_AVX_CompareGreaterThan,                  NI_AVX_CompareGreaterThan},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  GreaterThanOrEqual,                                     2,         {NI_VectorT256_GreaterThanOrEqual,          NI_VectorT256_GreaterThanOrEqual,           NI_VectorT256_GreaterThanOrEqual,           NI_VectorT256_GreaterThanOrEqual,           NI_VectorT256_GreaterThanOrEqual,           NI_VectorT256_GreaterThanOrEqual,           NI_VectorT256_GreaterThanOrEqual,           NI_VectorT256_GreaterThanOrEqual,           NI_AVX_CompareGreaterThanOrEqual,           NI_AVX_CompareGreaterThanOrEqual},          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  LessThan,                                               2,         {NI_AVX2_CompareLessThan,                   NI_VectorT256_LessThan,                     NI_AVX2_CompareLessThan,                    NI_VectorT256_LessThan,                     NI_AVX2_CompareLessThan,                    NI_VectorT256_LessThan,                     NI_AVX2_CompareLessThan,                    NI_VectorT256_LessThan,                     NI_AVX_CompareLessThan,                     NI_AVX_CompareLessThan},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  LessThanOrEqual,                                        2,         {NI_VectorT256_LessThanOrEqual,             NI_VectorT256_LessThanOrEqual,              NI_VectorT256_LessThanOrEqual,              NI_VectorT256_LessThanOrEqual,              NI_VectorT256_LessThanOrEqual,              NI_VectorT256_LessThanOrEqual,              NI_VectorT256_LessThanOrEqual,              NI_VectorT256_LessThanOrEqual,              NI_AVX_CompareLessThanOrEqual,              NI_AVX_CompareLessThanOrEqual},             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  Max,                                                    2,         {NI_AVX2_Max,                               NI_AVX2_Max,                                NI_AVX2_Max,                                NI_AVX2_Max,                                NI_AVX2_Max,                                NI_AVX2_Max,                                NI_VectorT256_Max,                          NI_VectorT256_Max,                          NI_AVX_Max,                                 NI_AVX_Max},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  Min,                                                    2,         {NI_AVX2_Min,                               NI_AVX2_Min,                                NI_AVX2_Min,                                NI_AVX2_Min,                                NI_AVX2_Min,                                NI_AVX2_Min,                                NI_VectorT256_Min,                          NI_VectorT256_Min,                          NI_AVX_Min,                                 NI_AVX_Min},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  Narrow,                                                 2,         {NI_VectorT256_Narrow,                      NI_VectorT256_Narrow,                       NI_VectorT256_Narrow,                       NI_VectorT256_Narrow,                       NI_VectorT256_Narrow,                       NI_VectorT256_Narrow,                       NI_VectorT256_Narrow,                       NI_VectorT256_Narrow,                       NI_VectorT256_Narrow,                       NI_VectorT256_Narrow},                      SimdAsHWIntrinsicFlag::KeepBaseTypeFromRet)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_Addition,                                            2,         {NI_AVX2_Add,                               NI_AVX2_Add,                                NI_AVX2_Add,                                NI_AVX2_Add,                                NI_AVX2_Add,                                NI_AVX2_Add,                                NI_AVX2_Add,                                NI_AVX2_Add,                                NI_AVX_Add,                                 NI_AVX_Add},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_BitwiseAnd,                                          2,         {NI_AVX2_And,                               NI_AVX2_And,                                NI_AVX2_And,                                NI_AVX2_And,                                NI_AVX2_And,                                NI_AVX2_And,                                NI_AVX2_And,                                NI_AVX2_And,                                NI_AVX_And,                                 NI_AVX_And},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_BitwiseOr,                                           2,         {NI_AVX2_Or,                                NI_AVX2_Or,                                 NI_AVX2_Or,                                 NI_AVX2_Or,                                 NI_AVX2_Or,                                 NI_AVX2_Or,                                 NI_AVX2_Or,                                 NI_AVX2_Or,                                 NI_AVX_Or,                                  NI_AVX_Or},                                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_Division,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_AVX_Divide,                              NI_AVX_Divide},                             SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_Equality,                                            2,         {NI_Vector256_op_Equality,                  NI_Vector256_op_Equality,                   NI_Vector256_op_Equality,                   NI_Vector256_op_Equality,                   NI_Vector256_op_Equality,                   NI_Vector256_op_Equality,                   NI_Vector256_op_Equality,                   NI_Vector256_op_Equality,                   NI_Vector256_op_Equality,                   NI_Vector256_op_Equality},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_ExclusiveOr,                                         2,         {NI_AVX2_Xor,                               NI_AVX2_Xor,                                NI_AVX2_Xor,                                NI_AVX2_Xor,                                NI_AVX2_Xor,                                NI_AVX2_Xor,                                NI_AVX2_Xor,                                NI_AVX2_Xor,                                NI_AVX_Xor,                                 NI_AVX_Xor},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_Explicit,                                            1,         {NI_VectorT256_op_Explicit,                 NI_VectorT256_op_Explicit,                  NI_VectorT256_op_Explicit,                  NI_VectorT256_op_Explicit,                  NI_VectorT256_op_Explicit,                  NI_VectorT256_op_Explicit,                  NI_VectorT256_op_Explicit,                  NI_VectorT256_op_Explicit,                  NI_VectorT256_op_Explicit,                  NI_VectorT256_op_Explicit},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_Inequality,                                          2,         {NI_Vector256_op_Inequality,                NI_Vector256_op_Inequality,                 NI_Vector256_op_Inequality,                 NI_Vector256_op_Inequality,                 NI_Vector256_op_Inequality,                 NI_Vector256_op_Inequality,                 NI_Vector256_op_Inequality,                 NI_Vector256_op_Inequality,                 NI_Vector256_op_Inequality,                 NI_Vector256_op_Inequality},                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_Multiply,                                            2,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT256_op_Multiply,                  NI_VectorT256_op_Multiply,                  NI_VectorT256_op_Multiply,                  NI_VectorT256_op_Multiply,                  NI_Illegal,                                 NI_Illegal,                                 NI_VectorT256_op_Multiply,                  NI_VectorT256_op_Multiply},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  op_Subtraction,                                         2,         {NI_AVX2_Subtract,                          NI_AVX2_Subtract,                           NI_AVX2_Subtract,                           NI_AVX2_Subtract,                           NI_AVX2_Subtract,                           NI_AVX2_Subtract,                           NI_AVX2_Subtract,                           NI_AVX2_Subtract,                           NI_AVX_Subtract,                            NI_AVX_Subtract},                           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ShiftLeft,                                              2,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT256_ShiftLeft,                    NI_VectorT256_ShiftLeft,                    NI_VectorT256_ShiftLeft,                    NI_VectorT256_ShiftLeft,                    NI_VectorT256_ShiftLeft,                    NI_VectorT256_ShiftLeft,                    NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ShiftRightArithmetic,                                   2,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT256_ShiftRightArithmetic,         NI_Illegal,                                 NI_VectorT256_ShiftRightArithmetic,         NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  ShiftRightLogical,                                      2,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT256_ShiftRightLogical,            NI_VectorT256_ShiftRightLogical,            NI_VectorT256_ShiftRightLogical,            NI_VectorT256_ShiftRightLogical,            NI_VectorT256_ShiftRightLogical,            NI_VectorT256_ShiftRightLogical,            NI_Illegal,                                 NI_Illegal},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  SquareRoot,                                             1,         {NI_Illegal,                                NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_Illegal,                                 NI_AVX_Sqrt,                                NI_AVX_Sqrt},                               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  Sum,                                                    1,         {NI_Illegal,                                NI_Illegal,                                 NI_VectorT256_Sum,                          NI_VectorT256_Sum,                          NI_VectorT256_Sum,                          NI_VectorT256_Sum,                          NI_Illegal,                                 NI_Illegal,                                 NI_VectorT256_Sum,                          NI_VectorT256_Sum},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  WidenLower,                                             1,         {NI_VectorT256_WidenLower,                  NI_VectorT256_WidenLower,                   NI_VectorT256_WidenLower,                   NI_VectorT256_WidenLower,                   NI_VectorT256_WidenLower,                   NI_VectorT256_WidenLower,                   NI_VectorT256_WidenLower,                   NI_VectorT256_WidenLower,                   NI_VectorT256_WidenLower,                   NI_VectorT256_WidenLower},                  SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT256,  WidenUpper,                                             1,         {NI_VectorT256_WidenUpper,                  NI_VectorT256_WidenUpper,                   NI_VectorT256_WidenUpper,                   NI_VectorT256_WidenUpper,                   NI_VectorT256_WidenUpper,                   NI_VectorT256_WidenUpper,                   NI_VectorT256_WidenUpper,                   NI_VectorT256_WidenUpper,                   NI_VectorT256_WidenUpper,                   NI_VectorT256_WidenUpper},                  SimdAsHWIntrinsicFlag::None)

#undef SIMD_AS_HWINTRINSIC_NM
#undef SIMD_AS_HWINTRINSIC_ID

#endif // FEATURE_HW_INTRINSICS

#undef SIMD_AS_HWINTRINSIC

// clang-format on
