// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/client-management.xml

#ifndef QT_WAYLAND_SERVER_COM_DEEPIN_CLIENT_MANAGEMENT
#define QT_WAYLAND_SERVER_COM_DEEPIN_CLIENT_MANAGEMENT

#include "wayland-server-core.h"
#include "wayland-com-deepin-client-management-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  com_deepin_client_management
    {
    public:
        com_deepin_client_management(struct ::wl_client *client, int id, int version);
        com_deepin_client_management(struct ::wl_display *display, int version);
        com_deepin_client_management(struct ::wl_resource *resource);
        com_deepin_client_management();

        virtual ~com_deepin_client_management();

        class Resource
        {
        public:
            Resource() : com_deepin_client_management_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            com_deepin_client_management *com_deepin_client_management_object;
            com_deepin_client_management *object() { return com_deepin_client_management_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_window_states(uint32_t count, const QByteArray &states);
        void send_window_states(struct ::wl_resource *resource, uint32_t count, const QByteArray &states);
        void send_capture_callback(int32_t window_id, int32_t succeed, struct ::wl_resource *buffer);
        void send_capture_callback(struct ::wl_resource *resource, int32_t window_id, int32_t succeed, struct ::wl_resource *buffer);
        void send_split_change(const QString &uuid, uint32_t splitable);
        void send_split_change(struct ::wl_resource *resource, const QString &uuid, uint32_t splitable);

    protected:
        virtual Resource *com_deepin_client_management_allocate();

        virtual void com_deepin_client_management_destroy_global();

        virtual void com_deepin_client_management_bind_resource(Resource *resource);
        virtual void com_deepin_client_management_destroy_resource(Resource *resource);

        virtual void com_deepin_client_management_get_window_states(Resource *resource);
        virtual void com_deepin_client_management_capture_window_image(Resource *resource, int32_t window_id, struct ::wl_resource *buffer);
        virtual void com_deepin_client_management_split_window(Resource *resource, const QString &uuid, int32_t split_type);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::com_deepin_client_management_interface m_com_deepin_client_management_interface;

        static void handle_get_window_states(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_capture_window_image(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t window_id,
            struct ::wl_resource *buffer);
        static void handle_split_window(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *uuid,
            int32_t split_type);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            com_deepin_client_management *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
