// This file is generated by kconfig_compiler_kf6 from easyeffects_db_exciter.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_EXCITER_H
#define DB_EXCITER_H

#include "kconfig_base_ee.hpp"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace db {

class Exciter : public KConfigBaseEE
{
  Q_OBJECT
  public:

    Exciter( const QString & masterGroup, const QString & instanceIndex );
    ~Exciter() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set amount
    */
    void setAmount( double v )
    {
      if (v < -100)
      {
        qDebug() << "setAmount: value " << v << " is less than the minimum value of -100";
        v = -100;
      }

      if (v > 36)
      {
        qDebug() << "setAmount: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mAmount && !isAmountImmutable()) {
        mAmount = v;
        Q_EMIT amountChanged();
      }
    }

    Q_PROPERTY(double amount READ amount WRITE setAmount NOTIFY amountChanged)
    Q_PROPERTY(bool isAmountImmutable READ isAmountImmutable CONSTANT)
    Q_PROPERTY(double defaultAmountValue READ defaultAmountValue CONSTANT)
    /**
      Get amount
    */
    double amount() const
    {
      return mAmount;
    }

    /**
      Is amount Immutable
    */
    bool isAmountImmutable() const
    {
      return isImmutable( QStringLiteral( "amount" ) );
    }

    /**
      Get amount default value
    */
    double defaultAmountValue() const
    {
        return defaultAmountValue_helper();
    }

    /**
      Set harmonics
    */
    void setHarmonics( double v )
    {
      if (v < 0.1)
      {
        qDebug() << "setHarmonics: value " << v << " is less than the minimum value of 0.1";
        v = 0.1;
      }

      if (v > 10)
      {
        qDebug() << "setHarmonics: value " << v << " is greater than the maximum value of 10";
        v = 10;
      }

      if (v != mHarmonics && !isHarmonicsImmutable()) {
        mHarmonics = v;
        Q_EMIT harmonicsChanged();
      }
    }

    Q_PROPERTY(double harmonics READ harmonics WRITE setHarmonics NOTIFY harmonicsChanged)
    Q_PROPERTY(bool isHarmonicsImmutable READ isHarmonicsImmutable CONSTANT)
    Q_PROPERTY(double defaultHarmonicsValue READ defaultHarmonicsValue CONSTANT)
    /**
      Get harmonics
    */
    double harmonics() const
    {
      return mHarmonics;
    }

    /**
      Is harmonics Immutable
    */
    bool isHarmonicsImmutable() const
    {
      return isImmutable( QStringLiteral( "harmonics" ) );
    }

    /**
      Get harmonics default value
    */
    double defaultHarmonicsValue() const
    {
        return defaultHarmonicsValue_helper();
    }

    /**
      Set scope
    */
    void setScope( double v )
    {
      if (v < 2000)
      {
        qDebug() << "setScope: value " << v << " is less than the minimum value of 2000";
        v = 2000;
      }

      if (v > 12000)
      {
        qDebug() << "setScope: value " << v << " is greater than the maximum value of 12000";
        v = 12000;
      }

      if (v != mScope && !isScopeImmutable()) {
        mScope = v;
        Q_EMIT scopeChanged();
      }
    }

    Q_PROPERTY(double scope READ scope WRITE setScope NOTIFY scopeChanged)
    Q_PROPERTY(bool isScopeImmutable READ isScopeImmutable CONSTANT)
    Q_PROPERTY(double defaultScopeValue READ defaultScopeValue CONSTANT)
    /**
      Get scope
    */
    double scope() const
    {
      return mScope;
    }

    /**
      Is scope Immutable
    */
    bool isScopeImmutable() const
    {
      return isImmutable( QStringLiteral( "scope" ) );
    }

    /**
      Get scope default value
    */
    double defaultScopeValue() const
    {
        return defaultScopeValue_helper();
    }

    /**
      Set ceil
    */
    void setCeil( double v )
    {
      if (v < 10000)
      {
        qDebug() << "setCeil: value " << v << " is less than the minimum value of 10000";
        v = 10000;
      }

      if (v > 20000)
      {
        qDebug() << "setCeil: value " << v << " is greater than the maximum value of 20000";
        v = 20000;
      }

      if (v != mCeil && !isCeilImmutable()) {
        mCeil = v;
        Q_EMIT ceilChanged();
      }
    }

    Q_PROPERTY(double ceil READ ceil WRITE setCeil NOTIFY ceilChanged)
    Q_PROPERTY(bool isCeilImmutable READ isCeilImmutable CONSTANT)
    Q_PROPERTY(double defaultCeilValue READ defaultCeilValue CONSTANT)
    /**
      Get ceil
    */
    double ceil() const
    {
      return mCeil;
    }

    /**
      Is ceil Immutable
    */
    bool isCeilImmutable() const
    {
      return isImmutable( QStringLiteral( "ceil" ) );
    }

    /**
      Get ceil default value
    */
    double defaultCeilValue() const
    {
        return defaultCeilValue_helper();
    }

    /**
      Set blend
    */
    void setBlend( double v )
    {
      if (v < -10)
      {
        qDebug() << "setBlend: value " << v << " is less than the minimum value of -10";
        v = -10;
      }

      if (v > 10)
      {
        qDebug() << "setBlend: value " << v << " is greater than the maximum value of 10";
        v = 10;
      }

      if (v != mBlend && !isBlendImmutable()) {
        mBlend = v;
        Q_EMIT blendChanged();
      }
    }

    Q_PROPERTY(double blend READ blend WRITE setBlend NOTIFY blendChanged)
    Q_PROPERTY(bool isBlendImmutable READ isBlendImmutable CONSTANT)
    Q_PROPERTY(double defaultBlendValue READ defaultBlendValue CONSTANT)
    /**
      Get blend
    */
    double blend() const
    {
      return mBlend;
    }

    /**
      Is blend Immutable
    */
    bool isBlendImmutable() const
    {
      return isImmutable( QStringLiteral( "blend" ) );
    }

    /**
      Get blend default value
    */
    double defaultBlendValue() const
    {
        return defaultBlendValue_helper();
    }

    /**
      Set ceilActive
    */
    void setCeilActive( bool v )
    {
      if (v != mCeilActive && !isCeilActiveImmutable()) {
        mCeilActive = v;
        Q_EMIT ceilActiveChanged();
      }
    }

    Q_PROPERTY(bool ceilActive READ ceilActive WRITE setCeilActive NOTIFY ceilActiveChanged)
    Q_PROPERTY(bool isCeilActiveImmutable READ isCeilActiveImmutable CONSTANT)
    Q_PROPERTY(bool defaultCeilActiveValue READ defaultCeilActiveValue CONSTANT)
    /**
      Get ceilActive
    */
    bool ceilActive() const
    {
      return mCeilActive;
    }

    /**
      Is ceilActive Immutable
    */
    bool isCeilActiveImmutable() const
    {
      return isImmutable( QStringLiteral( "ceilActive" ) );
    }

    /**
      Get ceilActive default value
    */
    bool defaultCeilActiveValue() const
    {
        return defaultCeilActiveValue_helper();
    }

    /**
      Set listen
    */
    void setListen( bool v )
    {
      if (v != mListen && !isListenImmutable()) {
        mListen = v;
        Q_EMIT listenChanged();
      }
    }

    Q_PROPERTY(bool listen READ listen WRITE setListen NOTIFY listenChanged)
    Q_PROPERTY(bool isListenImmutable READ isListenImmutable CONSTANT)
    Q_PROPERTY(bool defaultListenValue READ defaultListenValue CONSTANT)
    /**
      Get listen
    */
    bool listen() const
    {
      return mListen;
    }

    /**
      Is listen Immutable
    */
    bool isListenImmutable() const
    {
      return isImmutable( QStringLiteral( "listen" ) );
    }

    /**
      Get listen default value
    */
    bool defaultListenValue() const
    {
        return defaultListenValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalAmountChanged = 4,
      signalHarmonicsChanged = 5,
      signalScopeChanged = 6,
      signalCeilChanged = 7,
      signalBlendChanged = 8,
      signalCeilActiveChanged = 9,
      signalListenChanged = 10
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void amountChanged();

    void harmonicsChanged();

    void scopeChanged();

    void ceilChanged();

    void blendChanged();

    void ceilActiveChanged();

    void listenChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // Exciter#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    double mAmount;
    double defaultAmountValue_helper() const;
    double mHarmonics;
    double defaultHarmonicsValue_helper() const;
    double mScope;
    double defaultScopeValue_helper() const;
    double mCeil;
    double defaultCeilValue_helper() const;
    double mBlend;
    double defaultBlendValue_helper() const;
    bool mCeilActive;
    bool defaultCeilActiveValue_helper() const;
    bool mListen;
    bool defaultListenValue_helper() const;
};

}

#endif

