// This file is generated by kconfig_compiler_kf6 from easyeffects_db_spectrum.kcfg.
// All changes you do to this file will be lost.

#include "easyeffects_db_spectrum.h"

#include <qglobal.h>
#include <QFile>

using namespace db;

namespace db {

class SpectrumHelper
{
  public:
    SpectrumHelper() : q(nullptr) {}
    ~SpectrumHelper() { delete q; q = nullptr; }
    SpectrumHelper(const SpectrumHelper&) = delete;
    SpectrumHelper& operator=(const SpectrumHelper&) = delete;
    Spectrum *q;
};

}
Q_GLOBAL_STATIC(SpectrumHelper, s_globalSpectrum)
Spectrum *Spectrum::self()
{
  if (!s_globalSpectrum()->q) {
    new Spectrum;
    s_globalSpectrum()->q->read();
  }

  return s_globalSpectrum()->q;
}

Spectrum::Spectrum( )
  : KConfigBaseEE( QStringLiteral( "easyeffects/db/easyeffectsrc" ) )
{
  Q_ASSERT(!s_globalSpectrum()->q);
  s_globalSpectrum()->q = this;
  KConfigCompilerSignallingItem::NotifyFunction notifyFunction = static_cast<KConfigCompilerSignallingItem::NotifyFunction>(&Spectrum::itemChanged);

  setCurrentGroup( QStringLiteral( "Spectrum" ) );

  KConfigCompilerSignallingItem  *itemState;
  KConfigBaseEE::ItemBool  *innerItemState;
  innerItemState = new KConfigBaseEE::ItemBool( currentGroup(), QStringLiteral( "state" ), mState, true );
  itemState = new KConfigCompilerSignallingItem(innerItemState, this, notifyFunction, signalStateChanged);
  itemState->setWriteFlags(KConfigBase::Notify);
  addItem( itemState, QStringLiteral( "state" ) );
  KConfigCompilerSignallingItem  *itemDynamicYScale;
  KConfigBaseEE::ItemBool  *innerItemDynamicYScale;
  innerItemDynamicYScale = new KConfigBaseEE::ItemBool( currentGroup(), QStringLiteral( "dynamicYScale" ), mDynamicYScale, true );
  itemDynamicYScale = new KConfigCompilerSignallingItem(innerItemDynamicYScale, this, notifyFunction, signalDynamicYScaleChanged);
  itemDynamicYScale->setWriteFlags(KConfigBase::Notify);
  addItem( itemDynamicYScale, QStringLiteral( "dynamicYScale" ) );
  KConfigCompilerSignallingItem  *itemLogarithimicHorizontalAxis;
  KConfigBaseEE::ItemBool  *innerItemLogarithimicHorizontalAxis;
  innerItemLogarithimicHorizontalAxis = new KConfigBaseEE::ItemBool( currentGroup(), QStringLiteral( "logarithimicHorizontalAxis" ), mLogarithimicHorizontalAxis, true );
  itemLogarithimicHorizontalAxis = new KConfigCompilerSignallingItem(innerItemLogarithimicHorizontalAxis, this, notifyFunction, signalLogarithimicHorizontalAxisChanged);
  itemLogarithimicHorizontalAxis->setWriteFlags(KConfigBase::Notify);
  addItem( itemLogarithimicHorizontalAxis, QStringLiteral( "logarithimicHorizontalAxis" ) );
  QList<KConfigBaseEE::ItemEnum::Choice> valuesspectrumShape;
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("bars");
    valuesspectrumShape.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("lines");
    valuesspectrumShape.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("dots");
    valuesspectrumShape.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("area");
    valuesspectrumShape.append( choice );
  }
  KConfigCompilerSignallingItem  *itemSpectrumShape;
  KConfigBaseEE::ItemEnum  *innerItemSpectrumShape;
  innerItemSpectrumShape = new KConfigBaseEE::ItemEnum( currentGroup(), QStringLiteral( "spectrumShape" ), mSpectrumShape, valuesspectrumShape, 0 );
  itemSpectrumShape = new KConfigCompilerSignallingItem(innerItemSpectrumShape, this, notifyFunction, signalSpectrumShapeChanged);
  itemSpectrumShape->setWriteFlags(KConfigBase::Notify);
  addItem( itemSpectrumShape, QStringLiteral( "spectrumShape" ) );
  QList<KConfigBaseEE::ItemEnum::Choice> valuesspectrumColorScheme;
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("automatic");
    valuesspectrumColorScheme.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("light");
    valuesspectrumColorScheme.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("dark");
    valuesspectrumColorScheme.append( choice );
  }
  KConfigCompilerSignallingItem  *itemSpectrumColorScheme;
  KConfigBaseEE::ItemEnum  *innerItemSpectrumColorScheme;
  innerItemSpectrumColorScheme = new KConfigBaseEE::ItemEnum( currentGroup(), QStringLiteral( "spectrumColorScheme" ), mSpectrumColorScheme, valuesspectrumColorScheme, 2 );
  itemSpectrumColorScheme = new KConfigCompilerSignallingItem(innerItemSpectrumColorScheme, this, notifyFunction, signalSpectrumColorSchemeChanged);
  itemSpectrumColorScheme->setWriteFlags(KConfigBase::Notify);
  addItem( itemSpectrumColorScheme, QStringLiteral( "spectrumColorScheme" ) );
  QList<KConfigBaseEE::ItemEnum::Choice> valuesspectrumColorTheme;
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("qtGreen");
    valuesspectrumColorTheme.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("qtGreenNeon");
    valuesspectrumColorTheme.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("mixSeries");
    valuesspectrumColorTheme.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("orangeSeries");
    valuesspectrumColorTheme.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("yellowSeries");
    valuesspectrumColorTheme.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("blueSeries");
    valuesspectrumColorTheme.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("purpleSeries");
    valuesspectrumColorTheme.append( choice );
  }
  {
    KConfigBaseEE::ItemEnum::Choice choice;
    choice.name = QStringLiteral("greySeries");
    valuesspectrumColorTheme.append( choice );
  }
  KConfigCompilerSignallingItem  *itemSpectrumColorTheme;
  KConfigBaseEE::ItemEnum  *innerItemSpectrumColorTheme;
  innerItemSpectrumColorTheme = new KConfigBaseEE::ItemEnum( currentGroup(), QStringLiteral( "spectrumColorTheme" ), mSpectrumColorTheme, valuesspectrumColorTheme, 1 );
  itemSpectrumColorTheme = new KConfigCompilerSignallingItem(innerItemSpectrumColorTheme, this, notifyFunction, signalSpectrumColorThemeChanged);
  itemSpectrumColorTheme->setWriteFlags(KConfigBase::Notify);
  addItem( itemSpectrumColorTheme, QStringLiteral( "spectrumColorTheme" ) );
  KConfigCompilerSignallingItem  *itemNPoints;
  KConfigBaseEE::ItemInt  *innerItemNPoints;
  innerItemNPoints = new KConfigBaseEE::ItemInt( currentGroup(), QStringLiteral( "nPoints" ), mNPoints, 100 );
  itemNPoints = new KConfigCompilerSignallingItem(innerItemNPoints, this, notifyFunction, signalNPointsChanged);
  innerItemNPoints->setMinValue(2);
  innerItemNPoints->setMaxValue(2048);
  itemNPoints->setWriteFlags(KConfigBase::Notify);
  addItem( itemNPoints, QStringLiteral( "nPoints" ) );
  KConfigCompilerSignallingItem  *itemHeight;
  KConfigBaseEE::ItemInt  *innerItemHeight;
  innerItemHeight = new KConfigBaseEE::ItemInt( currentGroup(), QStringLiteral( "height" ), mHeight, 140 );
  itemHeight = new KConfigCompilerSignallingItem(innerItemHeight, this, notifyFunction, signalHeightChanged);
  innerItemHeight->setMinValue(100);
  innerItemHeight->setMaxValue(1000);
  itemHeight->setWriteFlags(KConfigBase::Notify);
  addItem( itemHeight, QStringLiteral( "height" ) );
  KConfigCompilerSignallingItem  *itemMinimumFrequency;
  KConfigBaseEE::ItemInt  *innerItemMinimumFrequency;
  innerItemMinimumFrequency = new KConfigBaseEE::ItemInt( currentGroup(), QStringLiteral( "minimumFrequency" ), mMinimumFrequency, 20 );
  itemMinimumFrequency = new KConfigCompilerSignallingItem(innerItemMinimumFrequency, this, notifyFunction, signalMinimumFrequencyChanged);
  innerItemMinimumFrequency->setMinValue(20);
  innerItemMinimumFrequency->setMaxValue(21900);
  itemMinimumFrequency->setWriteFlags(KConfigBase::Notify);
  addItem( itemMinimumFrequency, QStringLiteral( "minimumFrequency" ) );
  KConfigCompilerSignallingItem  *itemMaximumFrequency;
  KConfigBaseEE::ItemInt  *innerItemMaximumFrequency;
  innerItemMaximumFrequency = new KConfigBaseEE::ItemInt( currentGroup(), QStringLiteral( "maximumFrequency" ), mMaximumFrequency, 20000 );
  itemMaximumFrequency = new KConfigCompilerSignallingItem(innerItemMaximumFrequency, this, notifyFunction, signalMaximumFrequencyChanged);
  innerItemMaximumFrequency->setMinValue(120);
  innerItemMaximumFrequency->setMaxValue(22000);
  itemMaximumFrequency->setWriteFlags(KConfigBase::Notify);
  addItem( itemMaximumFrequency, QStringLiteral( "maximumFrequency" ) );
  KConfigCompilerSignallingItem  *itemAvsyncDelay;
  KConfigBaseEE::ItemInt  *innerItemAvsyncDelay;
  innerItemAvsyncDelay = new KConfigBaseEE::ItemInt( currentGroup(), QStringLiteral( "avsyncDelay" ), mAvsyncDelay, 0 );
  itemAvsyncDelay = new KConfigCompilerSignallingItem(innerItemAvsyncDelay, this, notifyFunction, signalAvsyncDelayChanged);
  innerItemAvsyncDelay->setMinValue(0);
  innerItemAvsyncDelay->setMaxValue(1000);
  itemAvsyncDelay->setWriteFlags(KConfigBase::Notify);
  addItem( itemAvsyncDelay, QStringLiteral( "avsyncDelay" ) );
}

bool Spectrum::defaultStateValue_helper()
{

  return true;
}

bool Spectrum::defaultDynamicYScaleValue_helper()
{

  return true;
}

bool Spectrum::defaultLogarithimicHorizontalAxisValue_helper()
{

  return true;
}

int Spectrum::defaultSpectrumShapeValue_helper()
{

  return 0;
}

int Spectrum::defaultSpectrumColorSchemeValue_helper()
{

  return 2;
}

int Spectrum::defaultSpectrumColorThemeValue_helper()
{

  return 1;
}

int Spectrum::defaultNPointsValue_helper()
{

  return 100;
}

int Spectrum::defaultHeightValue_helper()
{

  return 140;
}

int Spectrum::defaultMinimumFrequencyValue_helper()
{

  return 20;
}

int Spectrum::defaultMaximumFrequencyValue_helper()
{

  return 20000;
}

int Spectrum::defaultAvsyncDelayValue_helper()
{

  return 0;
}

Spectrum::~Spectrum()
{
  if (s_globalSpectrum.exists() && !s_globalSpectrum.isDestroyed()) {
    s_globalSpectrum()->q = nullptr;
  }
}


void Spectrum::itemChanged(quint64 signalFlag) {

  switch (signalFlag) {
  case signalStateChanged:
    Q_EMIT stateChanged();
    break;
  case signalDynamicYScaleChanged:
    Q_EMIT dynamicYScaleChanged();
    break;
  case signalLogarithimicHorizontalAxisChanged:
    Q_EMIT logarithimicHorizontalAxisChanged();
    break;
  case signalSpectrumShapeChanged:
    Q_EMIT spectrumShapeChanged();
    break;
  case signalSpectrumColorSchemeChanged:
    Q_EMIT spectrumColorSchemeChanged();
    break;
  case signalSpectrumColorThemeChanged:
    Q_EMIT spectrumColorThemeChanged();
    break;
  case signalNPointsChanged:
    Q_EMIT nPointsChanged();
    break;
  case signalHeightChanged:
    Q_EMIT heightChanged();
    break;
  case signalMinimumFrequencyChanged:
    Q_EMIT minimumFrequencyChanged();
    break;
  case signalMaximumFrequencyChanged:
    Q_EMIT maximumFrequencyChanged();
    break;
  case signalAvsyncDelayChanged:
    Q_EMIT avsyncDelayChanged();
    break;
  }
}
