/* ofono-backend.c generated by valac 0.56.18, the Vala compiler
 * generated from ofono-backend.vala, do not modify */

/*
 * Copyright (C) 2012 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Jeremy Whiting <jeremy.whiting@collabora.co.uk>
 *
 * Based on kf-backend.vala by:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "ofono.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "folks/folks.h"
#include <gio/gio.h>
#include "folks-internal.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_BACKENDS_OFONO_BACKEND_0_PROPERTY,
	FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED_PROPERTY,
	FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT_PROPERTY,
	FOLKS_BACKENDS_OFONO_BACKEND_NAME_PROPERTY,
	FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES_PROPERTY,
	FOLKS_BACKENDS_OFONO_BACKEND_NUM_PROPERTIES
};
static GParamSpec* folks_backends_ofono_backend_properties[FOLKS_BACKENDS_OFONO_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_internal_profile_block_free0(var) ((var == NULL) ? NULL : (var = (folks_internal_profile_block_free (var), NULL)))
typedef struct _FolksBackendsOfonoBackendPrepareData FolksBackendsOfonoBackendPrepareData;
typedef struct _FolksBackendsOfonoBackendUnprepareData FolksBackendsOfonoBackendUnprepareData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _FolksBackendsOfonoBackendPrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
	orgofonoModemProperties* _modems;
	gint _modems_length1;
	gint __modems_size_;
};

struct _FolksBackendsOfonoBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsOfonoBackend* self;
	FolksInternalProfileBlock* profiling;
	FolksInternalProfileBlock* _tmp0_;
	gboolean _tmp1_;
	orgofonoManager* manager;
	orgofonoManager* _tmp2_;
	orgofonoManager* _tmp3_;
	orgofonoManager* _tmp4_;
	orgofonoManager* _tmp5_;
	orgofonoManager* _tmp6_;
	orgofonoModemProperties* _tmp7_;
	orgofonoManager* _tmp8_;
	gint _tmp9_;
	orgofonoModemProperties* _tmp10_;
	gint _tmp7__length1;
	gint __tmp7__size_;
	orgofonoModemProperties* _tmp11_;
	gint _tmp11__length1;
	GError* _tmp12_;
	orgofonoModemProperties* _tmp13_;
	gint _tmp13__length1;
	orgofonoModemProperties* modem_collection;
	gint modem_collection_length1;
	gint _modem_collection_size_;
	gint modem_it;
	orgofonoModemProperties _tmp14_;
	orgofonoModemProperties _tmp15_;
	orgofonoModemProperties modem;
	orgofonoModemProperties _tmp16_;
	const char* _tmp17_;
	orgofonoModemProperties _tmp18_;
	GHashTable* _tmp19_;
	GError* _inner_error1_;
	FolksInternalProfileBlock* _tmp20_;
	GError* _inner_error0_;
};

struct _FolksBackendsOfonoBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsOfonoBackend* self;
	gboolean _tmp0_;
	GeeIterator* _persona_store_it;
	GeeHashMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	FolksBackendsOfonoPersonaStore* persona_store;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	FolksBackendsOfonoPersonaStore* _tmp10_;
	GeeHashMap* _tmp11_;
	GError* _inner_error0_;
};

static gint FolksBackendsOfonoBackend_private_offset;
static gpointer folks_backends_ofono_backend_parent_class = NULL;

static void _vala_orgofonoModemProperties_array_free (orgofonoModemProperties * array,
                                               gssize array_length);
static void folks_backends_ofono_backend_real_disable_persona_store (FolksBackend* base,
                                                              FolksPersonaStore* store);
static void _folks_backends_ofono_backend_store_removed_cb (FolksBackendsOfonoBackend* self,
                                                     FolksPersonaStore* store);
static void folks_backends_ofono_backend_real_enable_persona_store (FolksBackend* base,
                                                             FolksPersonaStore* store);
static void _folks_backends_ofono_backend_add_store (FolksBackendsOfonoBackend* self,
                                              FolksBackendsOfonoPersonaStore* store,
                                              gboolean notify);
static void folks_backends_ofono_backend_real_set_persona_stores (FolksBackend* base,
                                                           GeeSet* storeids);
static gchar* _folks_backends_ofono_backend_modem_alias (FolksBackendsOfonoBackend* self,
                                                  GHashTable* properties);
static void _vala_array_add1 (FolksBackendsOfonoPersonaStore** * array,
                       gint* length,
                       gint* size,
                       FolksBackendsOfonoPersonaStore* value);
static void _folks_backends_ofono_backend_remove_store (FolksBackendsOfonoBackend* self,
                                                 FolksBackendsOfonoPersonaStore* store,
                                                 gboolean notify);
static void _folks_backends_ofono_backend_add_modem (FolksBackendsOfonoBackend* self,
                                              const char* path,
                                              const gchar* alias);
static void folks_backends_ofono_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_ofono_backend_real_prepare (FolksBackend* base,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean folks_backends_ofono_backend_real_prepare_co (FolksBackendsOfonoBackendPrepareData* _data_);
static void folks_backends_ofono_backend_prepare_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void _folks_backends_ofono_backend_modem_added (FolksBackendsOfonoBackend* self,
                                                const char* path,
                                                GHashTable* properties);
static void __folks_backends_ofono_backend_modem_added_org_ofono_manager_modem_added (orgofonoManager* _sender,
                                                                               const char* path,
                                                                               GHashTable* properties,
                                                                               gpointer self);
static void _folks_backends_ofono_backend_modem_removed (FolksBackendsOfonoBackend* self,
                                                  const char* path);
static void __folks_backends_ofono_backend_modem_removed_org_ofono_manager_modem_removed (orgofonoManager* _sender,
                                                                                   const char* path,
                                                                                   gpointer self);
static void folks_backends_ofono_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_ofono_backend_real_unprepare (FolksBackend* base,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean folks_backends_ofono_backend_real_unprepare_co (FolksBackendsOfonoBackendUnprepareData* _data_);
static void __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender,
                                                                                  gpointer self);
static GObject * folks_backends_ofono_backend_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void folks_backends_ofono_backend_finalize (GObject * obj);
static GType folks_backends_ofono_backend_get_type_once (void);
static void _vala_folks_backends_ofono_backend_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
folks_backends_ofono_backend_get_instance_private (FolksBackendsOfonoBackend* self)
{
	return G_STRUCT_MEMBER_P (self, FolksBackendsOfonoBackend_private_offset);
}

static void
_vala_orgofonoModemProperties_array_free (orgofonoModemProperties * array,
                                          gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			org_ofono_modem_properties_destroy (&array[i]);
		}
	}
	g_free (array);
}

/**
   * {@inheritDoc}
   */
static void
folks_backends_ofono_backend_real_disable_persona_store (FolksBackend* base,
                                                         FolksPersonaStore* store)
{
	FolksBackendsOfonoBackend * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (FolksBackendsOfonoBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = folks_persona_store_get_id (store);
	_tmp2_ = _tmp1_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_)) {
		_folks_backends_ofono_backend_store_removed_cb (self, store);
	}
}

/**
   * {@inheritDoc}
   */
static void
folks_backends_ofono_backend_real_enable_persona_store (FolksBackend* base,
                                                        FolksPersonaStore* store)
{
	FolksBackendsOfonoBackend * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (FolksBackendsOfonoBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = folks_persona_store_get_id (store);
	_tmp2_ = _tmp1_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_) == FALSE) {
		_folks_backends_ofono_backend_add_store (self, G_TYPE_CHECK_INSTANCE_CAST (store, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore), TRUE);
	}
}

/**
   * {@inheritDoc}
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add1 (FolksBackendsOfonoPersonaStore** * array,
                  gint* length,
                  gint* size,
                  FolksBackendsOfonoPersonaStore* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksBackendsOfonoPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
folks_backends_ofono_backend_real_set_persona_stores (FolksBackend* base,
                                                      GeeSet* storeids)
{
	FolksBackendsOfonoBackend * self;
	gboolean added_stores = FALSE;
	FolksBackendsOfonoPersonaStore** removed_stores = NULL;
	FolksBackendsOfonoPersonaStore** _tmp0_;
	gint removed_stores_length1;
	gint _removed_stores_size_;
	orgofonoModemProperties* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp37_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	added_stores = FALSE;
	_tmp0_ = g_new0 (FolksBackendsOfonoPersonaStore*, 0 + 1);
	removed_stores = _tmp0_;
	removed_stores_length1 = 0;
	_removed_stores_size_ = removed_stores_length1;
	_tmp1_ = self->priv->_modems;
	_tmp1__length1 = self->priv->_modems_length1;
	{
		orgofonoModemProperties* modem_collection = NULL;
		gint modem_collection_length1 = 0;
		gint _modem_collection_size_ = 0;
		gint modem_it = 0;
		modem_collection = _tmp1_;
		modem_collection_length1 = _tmp1__length1;
		for (modem_it = 0; modem_it < modem_collection_length1; modem_it = modem_it + 1) {
			orgofonoModemProperties _tmp2_;
			orgofonoModemProperties _tmp3_ = {0};
			orgofonoModemProperties modem = {0};
			_tmp2_ = modem_collection[modem_it];
			org_ofono_modem_properties_copy (&_tmp2_, &_tmp3_);
			modem = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				orgofonoModemProperties _tmp5_;
				const char* _tmp6_;
				_tmp5_ = modem;
				_tmp6_ = _tmp5_.path;
				if (gee_collection_contains ((GeeCollection*) storeids, (const gchar*) _tmp6_)) {
					GeeHashMap* _tmp7_;
					orgofonoModemProperties _tmp8_;
					const char* _tmp9_;
					_tmp7_ = self->priv->_persona_stores;
					_tmp8_ = modem;
					_tmp9_ = _tmp8_.path;
					_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, (const gchar*) _tmp9_) == FALSE;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gchar* alias = NULL;
					orgofonoModemProperties _tmp10_;
					GHashTable* _tmp11_;
					gchar* _tmp12_;
					FolksBackendsOfonoPersonaStore* store = NULL;
					orgofonoModemProperties _tmp13_;
					const char* _tmp14_;
					const gchar* _tmp15_;
					FolksBackendsOfonoPersonaStore* _tmp16_;
					FolksBackendsOfonoPersonaStore* _tmp17_;
					_tmp10_ = modem;
					_tmp11_ = _tmp10_.properties;
					_tmp12_ = _folks_backends_ofono_backend_modem_alias (self, _tmp11_);
					alias = _tmp12_;
					_tmp13_ = modem;
					_tmp14_ = _tmp13_.path;
					_tmp15_ = alias;
					_tmp16_ = folks_backends_ofono_persona_store_new (_tmp14_, _tmp15_);
					store = _tmp16_;
					_tmp17_ = store;
					_folks_backends_ofono_backend_add_store (self, _tmp17_, FALSE);
					added_stores = TRUE;
					_g_object_unref0 (store);
					_g_free0 (alias);
				}
				org_ofono_modem_properties_destroy (&modem);
			}
		}
	}
	{
		GeeIterator* _store_it = NULL;
		GeeHashMap* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		GeeCollection* _tmp21_;
		GeeIterator* _tmp22_;
		GeeIterator* _tmp23_;
		_tmp18_ = self->priv->_persona_stores;
		_tmp19_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp21_);
		_store_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_;
			FolksBackendsOfonoPersonaStore* store = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			FolksBackendsOfonoPersonaStore* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp24_ = _store_it;
			if (!gee_iterator_next (_tmp24_)) {
				break;
			}
			_tmp25_ = _store_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			store = (FolksBackendsOfonoPersonaStore*) _tmp26_;
			_tmp27_ = store;
			_tmp28_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp27_);
			_tmp29_ = _tmp28_;
			if (!gee_collection_contains ((GeeCollection*) storeids, _tmp29_)) {
				FolksBackendsOfonoPersonaStore* _tmp30_;
				FolksBackendsOfonoPersonaStore* _tmp31_;
				_tmp30_ = store;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				_vala_array_add1 (&removed_stores, &removed_stores_length1, &_removed_stores_size_, _tmp31_);
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				FolksBackendsOfonoPersonaStore** _tmp34_;
				gint _tmp34__length1;
				FolksBackendsOfonoPersonaStore** _tmp35_;
				gint _tmp35__length1;
				FolksBackendsOfonoPersonaStore* _tmp36_;
				if (!_tmp32_) {
					gint _tmp33_;
					i = i + 1;
					_tmp33_ = i;
				}
				_tmp32_ = FALSE;
				_tmp34_ = removed_stores;
				_tmp34__length1 = removed_stores_length1;
				if (!(i < _tmp34__length1)) {
					break;
				}
				_tmp35_ = removed_stores;
				_tmp35__length1 = removed_stores_length1;
				_tmp36_ = _tmp35_[i];
				_folks_backends_ofono_backend_remove_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore), FALSE);
			}
		}
	}
	if (added_stores) {
		_tmp37_ = TRUE;
	} else {
		FolksBackendsOfonoPersonaStore** _tmp38_;
		gint _tmp38__length1;
		_tmp38_ = removed_stores;
		_tmp38__length1 = removed_stores_length1;
		_tmp37_ = _tmp38__length1 > 0;
	}
	if (_tmp37_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
	removed_stores = (_vala_array_free (removed_stores, removed_stores_length1, (GDestroyNotify) g_object_unref), NULL);
}

/**
   * {@inheritDoc}
   */
FolksBackendsOfonoBackend*
folks_backends_ofono_backend_construct (GType object_type)
{
	FolksBackendsOfonoBackend * self = NULL;
	self = (FolksBackendsOfonoBackend*) g_object_new (object_type, NULL);
	return self;
}

FolksBackendsOfonoBackend*
folks_backends_ofono_backend_new (void)
{
	return folks_backends_ofono_backend_construct (FOLKS_BACKENDS_OFONO_TYPE_BACKEND);
}

static void
_folks_backends_ofono_backend_add_modem (FolksBackendsOfonoBackend* self,
                                         const char* path,
                                         const gchar* alias)
{
	FolksBackendsOfonoPersonaStore* store = NULL;
	FolksBackendsOfonoPersonaStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (alias != NULL);
	_tmp0_ = folks_backends_ofono_persona_store_new (path, alias);
	store = _tmp0_;
	_folks_backends_ofono_backend_add_store (self, store, TRUE);
	_g_object_unref0 (store);
}

static void
folks_backends_ofono_backend_real_prepare_data_free (gpointer _data)
{
	FolksBackendsOfonoBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoBackendPrepareData, _data_);
}

static void
folks_backends_ofono_backend_real_prepare (FolksBackend* base,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	FolksBackendsOfonoBackend * self;
	FolksBackendsOfonoBackendPrepareData* _data_;
	FolksBackendsOfonoBackend* _tmp0_;
	self = (FolksBackendsOfonoBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoBackendPrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_ofono_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_ofono_backend_real_prepare_co (_data_);
}

static void
folks_backends_ofono_backend_prepare_finish (FolksBackend* base,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	FolksBackendsOfonoBackendPrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * {@inheritDoc}
   */
static void
folks_backends_ofono_backend_prepare_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	FolksBackendsOfonoBackendPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_ofono_backend_real_prepare_co (_data_);
}

static void
__folks_backends_ofono_backend_modem_added_org_ofono_manager_modem_added (orgofonoManager* _sender,
                                                                          const char* path,
                                                                          GHashTable* properties,
                                                                          gpointer self)
{
	_folks_backends_ofono_backend_modem_added ((FolksBackendsOfonoBackend*) self, path, properties);
}

static void
__folks_backends_ofono_backend_modem_removed_org_ofono_manager_modem_removed (orgofonoManager* _sender,
                                                                              const char* path,
                                                                              gpointer self)
{
	_folks_backends_ofono_backend_modem_removed ((FolksBackendsOfonoBackend*) self, path);
}

static gboolean
folks_backends_ofono_backend_real_prepare_co (FolksBackendsOfonoBackendPrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_internal_profiling_start ("preparing Ofono.Backend", NULL);
	_data_->profiling = _data_->_tmp0_;
	if (_data_->self->priv->_is_prepared) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp1_ = _data_->self->priv->_prepare_pending;
	}
	if (_data_->_tmp1_) {
		_folks_internal_profile_block_free0 (_data_->profiling);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		{
			_data_->_state_ = 1;
			g_async_initable_new_async (ORG_OFONO_TYPE_MANAGER_PROXY, 0, NULL, folks_backends_ofono_backend_prepare_ready, _data_, "g-flags", 0, "g-name", "org.ofono", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/", "g-interface-name", "org.ofono.Manager", NULL);
			return FALSE;
			_state_1:
			_data_->_tmp3_ = (orgofonoManager*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp2_ = (orgofonoManager*) _data_->_tmp3_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp4_ = _data_->_tmp2_;
			_data_->_tmp2_ = NULL;
			_g_object_unref0 (_data_->manager);
			_data_->manager = _data_->_tmp4_;
			_data_->_tmp5_ = _data_->manager;
			g_signal_connect_object (_data_->_tmp5_, "modem-added", (GCallback) __folks_backends_ofono_backend_modem_added_org_ofono_manager_modem_added, _data_->self, 0);
			_data_->_tmp6_ = _data_->manager;
			g_signal_connect_object (_data_->_tmp6_, "modem-removed", (GCallback) __folks_backends_ofono_backend_modem_removed_org_ofono_manager_modem_removed, _data_->self, 0);
			_data_->_tmp8_ = _data_->manager;
			_data_->_tmp9_ = 0;
			_data_->_tmp10_ = org_ofono_manager_GetModems (_data_->_tmp8_, &_data_->_tmp9_, &_data_->_inner_error0_);
			_data_->_tmp7_ = _data_->_tmp10_;
			_data_->_tmp7__length1 = _data_->_tmp9_;
			_data_->__tmp7__size_ = _data_->_tmp7__length1;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_tmp2_);
				goto __catch1_g_error;
			}
			_data_->_tmp11_ = _data_->_tmp7_;
			_data_->_tmp11__length1 = _data_->_tmp7__length1;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7__length1 = 0;
			_data_->self->priv->_modems = (_vala_orgofonoModemProperties_array_free (_data_->self->priv->_modems, _data_->self->priv->_modems_length1), NULL);
			_data_->self->priv->_modems = _data_->_tmp11_;
			_data_->self->priv->_modems_length1 = _data_->_tmp11__length1;
			_data_->self->priv->__modems_size_ = _data_->self->priv->_modems_length1;
			_data_->_tmp7_ = (_vala_orgofonoModemProperties_array_free (_data_->_tmp7_, _data_->_tmp7__length1), NULL);
			_g_object_unref0 (_data_->_tmp2_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_data_->_tmp12_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_SERVICE_UNKNOWN, _ ("No oFono object manager running, so the oFono backend will be inactive" \
". Either oFono isn’t installed or the service can’t be started."));
			_data_->_inner_error0_ = _data_->_tmp12_;
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->manager);
			goto __finally0;
		}
		_data_->_tmp13_ = _data_->self->priv->_modems;
		_data_->_tmp13__length1 = _data_->self->priv->_modems_length1;
		{
			_data_->modem_collection_length1 = 0;
			_data_->_modem_collection_size_ = 0;
			_data_->modem_collection = _data_->_tmp13_;
			_data_->modem_collection_length1 = _data_->_tmp13__length1;
			for (_data_->modem_it = 0; _data_->modem_it < _data_->modem_collection_length1; _data_->modem_it = _data_->modem_it + 1) {
				_data_->_tmp14_ = _data_->modem_collection[_data_->modem_it];
				memset (&_data_->_tmp15_, 0, sizeof (orgofonoModemProperties));
				org_ofono_modem_properties_copy (&_data_->_tmp14_, &_data_->_tmp15_);
				_data_->modem = _data_->_tmp15_;
				{
					_data_->_tmp16_ = _data_->modem;
					_data_->_tmp17_ = _data_->_tmp16_.path;
					_data_->_tmp18_ = _data_->modem;
					_data_->_tmp19_ = _data_->_tmp18_.properties;
					_folks_backends_ofono_backend_modem_added (_data_->self, _data_->_tmp17_, _data_->_tmp19_);
					org_ofono_modem_properties_destroy (&_data_->modem);
				}
			}
		}
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_g_object_unref0 (_data_->manager);
	}
	__finally0:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_folks_internal_profile_block_free0 (_data_->profiling);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_folks_internal_profile_block_free0 (_data_->profiling);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp20_ = _data_->profiling;
	_data_->profiling = NULL;
	folks_internal_profiling_end (_data_->_tmp20_);
	_folks_internal_profile_block_free0 (_data_->profiling);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_backends_ofono_backend_real_unprepare_data_free (gpointer _data)
{
	FolksBackendsOfonoBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoBackendUnprepareData, _data_);
}

static void
folks_backends_ofono_backend_real_unprepare (FolksBackend* base,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	FolksBackendsOfonoBackend * self;
	FolksBackendsOfonoBackendUnprepareData* _data_;
	FolksBackendsOfonoBackend* _tmp0_;
	self = (FolksBackendsOfonoBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoBackendUnprepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_ofono_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_ofono_backend_real_unprepare_co (_data_);
}

static void
folks_backends_ofono_backend_unprepare_finish (FolksBackend* base,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	FolksBackendsOfonoBackendUnprepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * {@inheritDoc}
   */
static gboolean
folks_backends_ofono_backend_real_unprepare_co (FolksBackendsOfonoBackendUnprepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!_data_->self->priv->_is_prepared) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = _data_->self->priv->_prepare_pending == TRUE;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		{
			_data_->_tmp1_ = _data_->self->priv->_persona_stores;
			_data_->_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp1_);
			_data_->_tmp3_ = _data_->_tmp2_;
			_data_->_tmp4_ = _data_->_tmp3_;
			_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
			_data_->_tmp6_ = _data_->_tmp5_;
			_g_object_unref0 (_data_->_tmp4_);
			_data_->_persona_store_it = _data_->_tmp6_;
			while (TRUE) {
				_data_->_tmp7_ = _data_->_persona_store_it;
				if (!gee_iterator_next (_data_->_tmp7_)) {
					break;
				}
				_data_->_tmp8_ = _data_->_persona_store_it;
				_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
				_data_->persona_store = (FolksBackendsOfonoPersonaStore*) _data_->_tmp9_;
				_data_->_tmp10_ = _data_->persona_store;
				g_signal_emit_by_name ((FolksBackend*) _data_->self, "persona-store-removed", (FolksPersonaStore*) _data_->_tmp10_);
				_g_object_unref0 (_data_->persona_store);
			}
			_g_object_unref0 (_data_->_persona_store_it);
		}
		_data_->_tmp11_ = _data_->self->priv->_persona_stores;
		gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp11_);
		g_object_notify ((GObject*) _data_->self, "persona-stores");
		_data_->self->priv->_is_quiescent = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_is_prepared = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
	}
	__finally0:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Utility function to extract a modem's alias from its properties.
   *
   * @param properties, the properties of the modem.
   * @return the alias to use for this modem.
   */
static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gchar*
_folks_backends_ofono_backend_modem_alias (FolksBackendsOfonoBackend* self,
                                           GHashTable* properties)
{
	gchar* alias = NULL;
	gchar* _tmp0_;
	GVariant* name_variant = NULL;
	gconstpointer _tmp1_;
	GVariant* _tmp2_;
	GVariant* manufacturer_variant = NULL;
	gconstpointer _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (properties != NULL, NULL);
	_tmp0_ = g_strdup ("");
	alias = _tmp0_;
	_tmp1_ = g_hash_table_lookup (properties, "Name");
	_tmp2_ = _g_variant_ref0 ((GVariant*) _tmp1_);
	name_variant = _tmp2_;
	_tmp3_ = g_hash_table_lookup (properties, "Manufacturer");
	_tmp4_ = _g_variant_ref0 ((GVariant*) _tmp3_);
	manufacturer_variant = _tmp4_;
	_tmp5_ = name_variant;
	if (_tmp5_ != NULL) {
		GVariant* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = name_variant;
		_tmp7_ = g_variant_get_string (_tmp6_, NULL);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (alias);
		alias = _tmp8_;
	} else {
		GVariant* _tmp9_;
		_tmp9_ = manufacturer_variant;
		if (_tmp9_ != NULL) {
			GVariant* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = manufacturer_variant;
			_tmp11_ = g_variant_get_string (_tmp10_, NULL);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (alias);
			alias = _tmp12_;
		}
	}
	result = alias;
	_g_variant_unref0 (manufacturer_variant);
	_g_variant_unref0 (name_variant);
	return result;
}

static void
_folks_backends_ofono_backend_modem_added (FolksBackendsOfonoBackend* self,
                                           const char* path,
                                           GHashTable* properties)
{
	gboolean has_sim = FALSE;
	gboolean has_phonebook = FALSE;
	GVariant* features_variant = NULL;
	gconstpointer _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* interfaces_variant = NULL;
	gconstpointer _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	gchar* alias = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (properties != NULL);
	has_sim = FALSE;
	has_phonebook = FALSE;
	_tmp0_ = g_hash_table_lookup (properties, "Features");
	_tmp1_ = _g_variant_ref0 ((GVariant*) _tmp0_);
	features_variant = _tmp1_;
	_tmp2_ = features_variant;
	if (_tmp2_ != NULL) {
		const gchar** features = NULL;
		GVariant* _tmp3_;
		gsize _tmp4_ = 0;
		const gchar** _tmp5_;
		gint features_length1;
		gint _features_size_;
		const gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp3_ = features_variant;
		_tmp5_ = g_variant_get_strv (_tmp3_, &_tmp4_);
		features = _tmp5_;
		features_length1 = _tmp4_;
		_features_size_ = features_length1;
		_tmp6_ = features;
		_tmp6__length1 = features_length1;
		{
			const gchar** feature_collection = NULL;
			gint feature_collection_length1 = 0;
			gint _feature_collection_size_ = 0;
			gint feature_it = 0;
			feature_collection = _tmp6_;
			feature_collection_length1 = _tmp6__length1;
			for (feature_it = 0; feature_it < feature_collection_length1; feature_it = feature_it + 1) {
				const gchar* feature = NULL;
				feature = feature_collection[feature_it];
				{
					const gchar* _tmp7_;
					_tmp7_ = feature;
					if (g_strcmp0 (_tmp7_, "sim") == 0) {
						has_sim = TRUE;
						break;
					}
				}
			}
		}
		features = (g_free (features), NULL);
	}
	if (has_sim == FALSE) {
		_g_variant_unref0 (features_variant);
		return;
	}
	_tmp8_ = g_hash_table_lookup (properties, "Interfaces");
	_tmp9_ = _g_variant_ref0 ((GVariant*) _tmp8_);
	interfaces_variant = _tmp9_;
	_tmp10_ = interfaces_variant;
	if (_tmp10_ != NULL) {
		const gchar** interfaces = NULL;
		GVariant* _tmp11_;
		gsize _tmp12_ = 0;
		const gchar** _tmp13_;
		gint interfaces_length1;
		gint _interfaces_size_;
		const gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp11_ = interfaces_variant;
		_tmp13_ = g_variant_get_strv (_tmp11_, &_tmp12_);
		interfaces = _tmp13_;
		interfaces_length1 = _tmp12_;
		_interfaces_size_ = interfaces_length1;
		_tmp14_ = interfaces;
		_tmp14__length1 = interfaces_length1;
		{
			const gchar** interf_collection = NULL;
			gint interf_collection_length1 = 0;
			gint _interf_collection_size_ = 0;
			gint interf_it = 0;
			interf_collection = _tmp14_;
			interf_collection_length1 = _tmp14__length1;
			for (interf_it = 0; interf_it < interf_collection_length1; interf_it = interf_it + 1) {
				const gchar* interf = NULL;
				interf = interf_collection[interf_it];
				{
					const gchar* _tmp15_;
					_tmp15_ = interf;
					if (g_strcmp0 (_tmp15_, "org.ofono.Phonebook") == 0) {
						has_phonebook = TRUE;
						break;
					}
				}
			}
		}
		interfaces = (g_free (interfaces), NULL);
	}
	if (has_phonebook == FALSE) {
		_g_variant_unref0 (interfaces_variant);
		_g_variant_unref0 (features_variant);
		return;
	}
	_tmp16_ = _folks_backends_ofono_backend_modem_alias (self, properties);
	alias = _tmp16_;
	_tmp17_ = alias;
	_folks_backends_ofono_backend_add_modem (self, path, _tmp17_);
	_g_free0 (alias);
	_g_variant_unref0 (interfaces_variant);
	_g_variant_unref0 (features_variant);
}

/**
   * Utility function to add a persona store.
   *
   * @param store the store to add.
   * @param notify whether or not to emit notification signals.
   */
static void
__folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender,
                                                                             gpointer self)
{
	_folks_backends_ofono_backend_store_removed_cb ((FolksBackendsOfonoBackend*) self, _sender);
}

static void
_folks_backends_ofono_backend_add_store (FolksBackendsOfonoBackend* self,
                                         FolksBackendsOfonoPersonaStore* store,
                                         gboolean notify)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, store);
	g_signal_connect_object ((FolksPersonaStore*) store, "removed", (GCallback) __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) store);
	if (notify) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}

/**
   * Utility function to remove a persona store.
   *
   * @param store the store to remove.
   * @param notify whether or not to emit notification signals.
   */
static void
_folks_backends_ofono_backend_remove_store (FolksBackendsOfonoBackend* self,
                                            FolksBackendsOfonoPersonaStore* store,
                                            gboolean notify)
{
	guint _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FolksPersonaStore*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed, self);
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp3_ = _tmp2_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp3_, NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", (FolksPersonaStore*) store);
	if (notify) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}

static void
_folks_backends_ofono_backend_modem_removed (FolksBackendsOfonoBackend* self,
                                             const char* path)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_persona_stores;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (const gchar*) path)) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		FolksBackendsOfonoPersonaStore* _tmp3_;
		_tmp1_ = self->priv->_persona_stores;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (const gchar*) path);
		_tmp3_ = (FolksBackendsOfonoPersonaStore*) _tmp2_;
		_folks_backends_ofono_backend_store_removed_cb (self, (FolksPersonaStore*) _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
}

static void
_folks_backends_ofono_backend_store_removed_cb (FolksBackendsOfonoBackend* self,
                                                FolksPersonaStore* store)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_folks_backends_ofono_backend_remove_store (self, G_TYPE_CHECK_INSTANCE_CAST (store, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore), TRUE);
}

static gboolean
folks_backends_ofono_backend_real_get_is_prepared (FolksBackend* base)
{
	gboolean result;
	FolksBackendsOfonoBackend* self;
	self = (FolksBackendsOfonoBackend*) base;
	result = self->priv->_is_prepared;
	return result;
}

static gboolean
folks_backends_ofono_backend_real_get_is_quiescent (FolksBackend* base)
{
	gboolean result;
	FolksBackendsOfonoBackend* self;
	self = (FolksBackendsOfonoBackend*) base;
	result = self->priv->_is_quiescent;
	return result;
}

static const gchar*
folks_backends_ofono_backend_real_get_name (FolksBackend* base)
{
	const gchar* result;
	FolksBackendsOfonoBackend* self;
	self = (FolksBackendsOfonoBackend*) base;
	result = BACKEND_NAME;
	return result;
}

static GeeMap*
folks_backends_ofono_backend_real_get_persona_stores (FolksBackend* base)
{
	GeeMap* result;
	FolksBackendsOfonoBackend* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsOfonoBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}

static GObject *
folks_backends_ofono_backend_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsOfonoBackend * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (folks_backends_ofono_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	return obj;
}

static void
folks_backends_ofono_backend_class_init (FolksBackendsOfonoBackendClass * klass,
                                         gpointer klass_data)
{
	folks_backends_ofono_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksBackendsOfonoBackend_private_offset);
	((FolksBackendClass *) klass)->disable_persona_store = (void (*) (FolksBackend*, FolksPersonaStore*)) folks_backends_ofono_backend_real_disable_persona_store;
	((FolksBackendClass *) klass)->enable_persona_store = (void (*) (FolksBackend*, FolksPersonaStore*)) folks_backends_ofono_backend_real_enable_persona_store;
	((FolksBackendClass *) klass)->set_persona_stores = (void (*) (FolksBackend*, GeeSet*)) folks_backends_ofono_backend_real_set_persona_stores;
	((FolksBackendClass *) klass)->prepare = (void (*) (FolksBackend*, GAsyncReadyCallback, gpointer)) folks_backends_ofono_backend_real_prepare;
	((FolksBackendClass *) klass)->prepare_finish = (void (*) (FolksBackend*, GAsyncResult*, GError**)) folks_backends_ofono_backend_prepare_finish;
	((FolksBackendClass *) klass)->unprepare = (void (*) (FolksBackend*, GAsyncReadyCallback, gpointer)) folks_backends_ofono_backend_real_unprepare;
	((FolksBackendClass *) klass)->unprepare_finish = (void (*) (FolksBackend*, GAsyncResult*, GError**)) folks_backends_ofono_backend_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = (gboolean (*) (FolksBackend*)) folks_backends_ofono_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = (gboolean (*) (FolksBackend*)) folks_backends_ofono_backend_real_get_is_quiescent;
	FOLKS_BACKEND_CLASS (klass)->get_name = (const gchar* (*) (FolksBackend*)) folks_backends_ofono_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = (GeeMap* (*) (FolksBackend*)) folks_backends_ofono_backend_real_get_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_ofono_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_ofono_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_ofono_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED_PROPERTY, folks_backends_ofono_backend_properties[FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT_PROPERTY, folks_backends_ofono_backend_properties[FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_NAME_PROPERTY, folks_backends_ofono_backend_properties[FOLKS_BACKENDS_OFONO_BACKEND_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES_PROPERTY, folks_backends_ofono_backend_properties[FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES_PROPERTY] = g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
folks_backends_ofono_backend_instance_init (FolksBackendsOfonoBackend * self,
                                            gpointer klass)
{
	self->priv = folks_backends_ofono_backend_get_instance_private (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}

static void
folks_backends_ofono_backend_finalize (GObject * obj)
{
	FolksBackendsOfonoBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_modems = (_vala_orgofonoModemProperties_array_free (self->priv->_modems, self->priv->_modems_length1), NULL);
	G_OBJECT_CLASS (folks_backends_ofono_backend_parent_class)->finalize (obj);
}

/**
 * A backend which loads {@link Persona}s from Modem
 * devices using the Ofono Phonebook D-Bus API and presents them
 * using one {@link PersonaStore} per device.
 *
 * @since 0.9.0
 */
static GType
folks_backends_ofono_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsOfonoBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_ofono_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsOfonoBackend), 0, (GInstanceInitFunc) folks_backends_ofono_backend_instance_init, NULL };
	GType folks_backends_ofono_backend_type_id;
	folks_backends_ofono_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsOfonoBackend", &g_define_type_info, 0);
	FolksBackendsOfonoBackend_private_offset = g_type_add_instance_private (folks_backends_ofono_backend_type_id, sizeof (FolksBackendsOfonoBackendPrivate));
	return folks_backends_ofono_backend_type_id;
}

GType
folks_backends_ofono_backend_get_type (void)
{
	static volatile gsize folks_backends_ofono_backend_type_id__once = 0;
	if (g_once_init_enter (&folks_backends_ofono_backend_type_id__once)) {
		GType folks_backends_ofono_backend_type_id;
		folks_backends_ofono_backend_type_id = folks_backends_ofono_backend_get_type_once ();
		g_once_init_leave (&folks_backends_ofono_backend_type_id__once, folks_backends_ofono_backend_type_id);
	}
	return folks_backends_ofono_backend_type_id__once;
}

static void
_vala_folks_backends_ofono_backend_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	FolksBackendsOfonoBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend);
	switch (property_id) {
		case FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED_PROPERTY:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT_PROPERTY:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_OFONO_BACKEND_NAME_PROPERTY:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES_PROPERTY:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

