/* WindowIconActor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowIconActor.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <meta/window.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "gala.h"
#include <meta/prefs.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_ICON_ACTOR (gala_window_icon_actor_get_type ())
#define GALA_WINDOW_ICON_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor))
#define GALA_WINDOW_ICON_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActorClass))
#define GALA_IS_WINDOW_ICON_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_ICON_ACTOR))
#define GALA_IS_WINDOW_ICON_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_ICON_ACTOR))
#define GALA_WINDOW_ICON_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActorClass))

typedef struct _GalaWindowIconActor GalaWindowIconActor;
typedef struct _GalaWindowIconActorClass GalaWindowIconActorClass;
typedef struct _GalaWindowIconActorPrivate GalaWindowIconActorPrivate;
enum  {
	GALA_WINDOW_ICON_ACTOR_0_PROPERTY,
	GALA_WINDOW_ICON_ACTOR_WINDOW_PROPERTY,
	GALA_WINDOW_ICON_ACTOR_ICON_SIZE_PROPERTY,
	GALA_WINDOW_ICON_ACTOR_TEMPORARY_PROPERTY,
	GALA_WINDOW_ICON_ACTOR_NUM_PROPERTIES
};
static GParamSpec* gala_window_icon_actor_properties[GALA_WINDOW_ICON_ACTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaWindowIconActor {
	ClutterActor parent_instance;
	GalaWindowIconActorPrivate * priv;
};

struct _GalaWindowIconActorClass {
	ClutterActorClass parent_class;
};

struct _GalaWindowIconActorPrivate {
	MetaWindow* _window;
	gfloat cur_icon_scale;
	gfloat desired_icon_scale;
	gint _icon_size;
	gboolean _temporary;
	GalaWindowIcon* icon;
	GalaWindowIcon* old_icon;
};

static gint GalaWindowIconActor_private_offset;
static gpointer gala_window_icon_actor_parent_class = NULL;

VALA_EXTERN GType gala_window_icon_actor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowIconActor, g_object_unref)
VALA_EXTERN MetaWindow* gala_window_icon_actor_get_window (GalaWindowIconActor* self);
static void gala_window_icon_actor_on_all_workspaces_changed (GalaWindowIconActor* self);
static void _gala_window_icon_actor_on_all_workspaces_changed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
VALA_EXTERN GalaWindowIconActor* gala_window_icon_actor_new (MetaWindow* window);
VALA_EXTERN GalaWindowIconActor* gala_window_icon_actor_construct (GType object_type,
                                                       MetaWindow* window);
VALA_EXTERN void gala_window_icon_actor_place (GalaWindowIconActor* self,
                                   gfloat x,
                                   gfloat y,
                                   gint size,
                                   gfloat scale);
static void gala_window_icon_actor_set_icon_size (GalaWindowIconActor* self,
                                           gint value);
static void gala_window_icon_actor_fade_new_icon (GalaWindowIconActor* self);
VALA_EXTERN gint gala_window_icon_actor_get_icon_size (GalaWindowIconActor* self);
static void ____lambda66_ (GalaWindowIconActor* self);
static void _____lambda66__clutter_timeline_completed (ClutterTimeline* _sender,
                                                gpointer self);
static void gala_window_icon_actor_set_window (GalaWindowIconActor* self,
                                        MetaWindow* value);
VALA_EXTERN gboolean gala_window_icon_actor_get_temporary (GalaWindowIconActor* self);
VALA_EXTERN void gala_window_icon_actor_set_temporary (GalaWindowIconActor* self,
                                           gboolean value);
static GObject * gala_window_icon_actor_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void gala_window_icon_actor_finalize (GObject * obj);
static GType gala_window_icon_actor_get_type_once (void);
static void _vala_gala_window_icon_actor_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_window_icon_actor_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
gala_window_icon_actor_get_instance_private (GalaWindowIconActor* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowIconActor_private_offset);
}

static void
_gala_window_icon_actor_on_all_workspaces_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	gala_window_icon_actor_on_all_workspaces_changed ((GalaWindowIconActor*) self);
}

GalaWindowIconActor*
gala_window_icon_actor_construct (GType object_type,
                                  MetaWindow* window)
{
	GalaWindowIconActor * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaWindowIconActor*) g_object_new (object_type, "window", window, NULL);
	return self;
}

GalaWindowIconActor*
gala_window_icon_actor_new (MetaWindow* window)
{
	return gala_window_icon_actor_construct (GALA_TYPE_WINDOW_ICON_ACTOR, window);
}

static void
gala_window_icon_actor_on_all_workspaces_changed (GalaWindowIconActor* self)
{
	MetaWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	g_object_get (_tmp0_, "on-all-workspaces", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		clutter_actor_destroy ((ClutterActor*) self);
	}
}

/**
     * Shortcut to set both position and size of the icon
     *
     * @param x    The x coordinate to which to animate to
     * @param y    The y coordinate to which to animate to
     * @param size The size to which to animate to and display the icon in
     */
void
gala_window_icon_actor_place (GalaWindowIconActor* self,
                              gfloat x,
                              gfloat y,
                              gint size,
                              gfloat scale)
{
	g_return_if_fail (self != NULL);
	self->priv->desired_icon_scale = scale;
	clutter_actor_set_position ((ClutterActor*) self, x, y);
	gala_window_icon_actor_set_icon_size (self, size);
}

/**
     * Fades out the old icon and fades in the new icon
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
____lambda66_ (GalaWindowIconActor* self)
{
	GalaWindowIcon* _tmp0_;
	_tmp0_ = self->priv->old_icon;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
	_g_object_unref0 (self->priv->old_icon);
	self->priv->old_icon = NULL;
}

static void
_____lambda66__clutter_timeline_completed (ClutterTimeline* _sender,
                                           gpointer self)
{
	____lambda66_ ((GalaWindowIconActor*) self);
}

static void
gala_window_icon_actor_fade_new_icon (GalaWindowIconActor* self)
{
	GalaWindowIcon* new_icon = NULL;
	MetaWindow* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GalaWindowIcon* _tmp3_;
	GalaWindowIcon* _tmp4_;
	ClutterBindConstraint* _tmp5_;
	ClutterBindConstraint* _tmp6_;
	GalaWindowIcon* _tmp7_;
	GalaWindowIcon* _tmp8_;
	GalaWindowIcon* _tmp9_;
	GalaWindowIcon* _tmp10_;
	GalaWindowIcon* _tmp11_;
	GalaWindowIcon* _tmp12_;
	GalaWindowIcon* _tmp13_;
	GalaWindowIcon* _tmp18_;
	GalaWindowIcon* _tmp19_;
	GalaWindowIcon* _tmp27_;
	GalaWindowIcon* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = gala_window_icon_actor_get_icon_size (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gala_window_icon_new (_tmp0_, _tmp2_, (gint) round ((gdouble) self->priv->cur_icon_scale));
	g_object_ref_sink (_tmp3_);
	new_icon = _tmp3_;
	_tmp4_ = new_icon;
	_tmp5_ = (ClutterBindConstraint*) clutter_bind_constraint_new ((ClutterActor*) self, CLUTTER_BIND_SIZE, (gfloat) 0);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp4_, (ClutterConstraint*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = new_icon;
	clutter_actor_set_opacity ((ClutterActor*) _tmp7_, (guint) 0);
	_tmp8_ = new_icon;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp8_);
	_tmp9_ = new_icon;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp9_);
	_tmp10_ = new_icon;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp10_, CLUTTER_EASE_OUT_QUAD);
	_tmp11_ = new_icon;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp11_, gala_utils_get_animation_duration ((guint) 500));
	_tmp12_ = new_icon;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp12_);
	_tmp13_ = self->priv->icon;
	if (_tmp13_ == NULL) {
		GalaWindowIcon* _tmp14_;
		GalaWindowIcon* _tmp15_;
		_tmp14_ = new_icon;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (self->priv->icon);
		self->priv->icon = _tmp15_;
	} else {
		GalaWindowIcon* _tmp16_;
		GalaWindowIcon* _tmp17_;
		_tmp16_ = self->priv->icon;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_g_object_unref0 (self->priv->old_icon);
		self->priv->old_icon = _tmp17_;
	}
	_tmp18_ = new_icon;
	clutter_actor_set_opacity ((ClutterActor*) _tmp18_, (guint) 255);
	_tmp19_ = self->priv->old_icon;
	if (_tmp19_ != NULL) {
		GalaWindowIcon* _tmp20_;
		ClutterTransition* transition = NULL;
		GalaWindowIcon* _tmp21_;
		ClutterTransition* _tmp22_;
		ClutterTransition* _tmp23_;
		ClutterTransition* _tmp24_;
		_tmp20_ = self->priv->old_icon;
		clutter_actor_set_opacity ((ClutterActor*) _tmp20_, (guint) 0);
		_tmp21_ = self->priv->old_icon;
		_tmp22_ = clutter_actor_get_transition ((ClutterActor*) _tmp21_, "opacity");
		_tmp23_ = _g_object_ref0 (_tmp22_);
		transition = _tmp23_;
		_tmp24_ = transition;
		if (_tmp24_ != NULL) {
			ClutterTransition* _tmp25_;
			_tmp25_ = transition;
			g_signal_connect_object ((ClutterTimeline*) _tmp25_, "completed", (GCallback) _____lambda66__clutter_timeline_completed, self, 0);
		} else {
			GalaWindowIcon* _tmp26_;
			_tmp26_ = self->priv->old_icon;
			clutter_actor_destroy ((ClutterActor*) _tmp26_);
			_g_object_unref0 (self->priv->old_icon);
			self->priv->old_icon = NULL;
		}
		_g_object_unref0 (transition);
	}
	_tmp27_ = new_icon;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp28_;
	_g_object_unref0 (new_icon);
}

MetaWindow*
gala_window_icon_actor_get_window (GalaWindowIconActor* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
gala_window_icon_actor_set_window (GalaWindowIconActor* self,
                                   MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_icon_actor_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_icon_actor_properties[GALA_WINDOW_ICON_ACTOR_WINDOW_PROPERTY]);
	}
}

gint
gala_window_icon_actor_get_icon_size (GalaWindowIconActor* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_icon_size;
	return result;
}

static void
gala_window_icon_actor_set_icon_size (GalaWindowIconActor* self,
                                      gint value)
{
	gboolean _tmp0_ = FALSE;
	gint scaled_size = 0;
	g_return_if_fail (self != NULL);
	if (value == self->priv->_icon_size) {
		_tmp0_ = self->priv->cur_icon_scale == self->priv->desired_icon_scale;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->_icon_size = value;
	self->priv->cur_icon_scale = self->priv->desired_icon_scale;
	scaled_size = gala_utils_scale_to_int (self->priv->_icon_size, self->priv->cur_icon_scale);
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) scaled_size, (gfloat) scaled_size);
	gala_window_icon_actor_fade_new_icon (self);
	g_object_notify_by_pspec ((GObject *) self, gala_window_icon_actor_properties[GALA_WINDOW_ICON_ACTOR_ICON_SIZE_PROPERTY]);
}

gboolean
gala_window_icon_actor_get_temporary (GalaWindowIconActor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_temporary;
	return result;
}

void
gala_window_icon_actor_set_temporary (GalaWindowIconActor* self,
                                      gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_temporary) {
		_tmp0_ = !value;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		clutter_actor_remove_transition ((ClutterActor*) self, "pulse");
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (!self->priv->_temporary) {
			_tmp2_ = value;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = meta_prefs_get_gnome_animations ();
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ClutterTransitionGroup* transition = NULL;
			ClutterTransitionGroup* _tmp3_ = NULL;
			ClutterPropertyTransition* opacity_transition = NULL;
			ClutterPropertyTransition* _tmp4_;
			ClutterPropertyTransition* _tmp5_;
			GValue _tmp6_ = {0};
			ClutterPropertyTransition* _tmp7_;
			GValue _tmp8_ = {0};
			ClutterPropertyTransition* _tmp9_;
			ClutterPropertyTransition* scale_x_transition = NULL;
			ClutterPropertyTransition* _tmp10_;
			ClutterPropertyTransition* _tmp11_;
			GValue _tmp12_ = {0};
			ClutterPropertyTransition* _tmp13_;
			GValue _tmp14_ = {0};
			ClutterPropertyTransition* _tmp15_;
			ClutterPropertyTransition* scale_y_transition = NULL;
			ClutterPropertyTransition* _tmp16_;
			ClutterPropertyTransition* _tmp17_;
			GValue _tmp18_ = {0};
			ClutterPropertyTransition* _tmp19_;
			GValue _tmp20_ = {0};
			ClutterPropertyTransition* _tmp21_;
			ClutterTransitionGroup* _tmp22_;
			ClutterPropertyTransition* _tmp23_;
			ClutterTransitionGroup* _tmp24_;
			ClutterPropertyTransition* _tmp25_;
			ClutterTransitionGroup* _tmp26_;
			ClutterPropertyTransition* _tmp27_;
			ClutterTransitionGroup* _tmp28_;
			_tmp3_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
			clutter_timeline_set_duration ((ClutterTimeline*) _tmp3_, (guint) 800);
			clutter_timeline_set_auto_reverse ((ClutterTimeline*) _tmp3_, TRUE);
			clutter_timeline_set_repeat_count ((ClutterTimeline*) _tmp3_, -1);
			clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp3_, CLUTTER_LINEAR);
			transition = _tmp3_;
			_tmp4_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
			opacity_transition = _tmp4_;
			_tmp5_ = opacity_transition;
			g_value_init (&_tmp6_, G_TYPE_INT);
			g_value_set_int (&_tmp6_, 100);
			clutter_transition_set_from_value ((ClutterTransition*) _tmp5_, &_tmp6_);
			G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
			_tmp7_ = opacity_transition;
			g_value_init (&_tmp8_, G_TYPE_INT);
			g_value_set_int (&_tmp8_, 255);
			clutter_transition_set_to_value ((ClutterTransition*) _tmp7_, &_tmp8_);
			G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
			_tmp9_ = opacity_transition;
			clutter_timeline_set_auto_reverse ((ClutterTimeline*) _tmp9_, TRUE);
			_tmp10_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-x");
			scale_x_transition = _tmp10_;
			_tmp11_ = scale_x_transition;
			g_value_init (&_tmp12_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp12_, 0.8);
			clutter_transition_set_from_value ((ClutterTransition*) _tmp11_, &_tmp12_);
			G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
			_tmp13_ = scale_x_transition;
			g_value_init (&_tmp14_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp14_, 1.1);
			clutter_transition_set_to_value ((ClutterTransition*) _tmp13_, &_tmp14_);
			G_IS_VALUE (&_tmp14_) ? (g_value_unset (&_tmp14_), NULL) : NULL;
			_tmp15_ = scale_x_transition;
			clutter_timeline_set_auto_reverse ((ClutterTimeline*) _tmp15_, TRUE);
			_tmp16_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-y");
			scale_y_transition = _tmp16_;
			_tmp17_ = scale_y_transition;
			g_value_init (&_tmp18_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp18_, 0.8);
			clutter_transition_set_from_value ((ClutterTransition*) _tmp17_, &_tmp18_);
			G_IS_VALUE (&_tmp18_) ? (g_value_unset (&_tmp18_), NULL) : NULL;
			_tmp19_ = scale_y_transition;
			g_value_init (&_tmp20_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp20_, 1.1);
			clutter_transition_set_to_value ((ClutterTransition*) _tmp19_, &_tmp20_);
			G_IS_VALUE (&_tmp20_) ? (g_value_unset (&_tmp20_), NULL) : NULL;
			_tmp21_ = scale_y_transition;
			clutter_timeline_set_auto_reverse ((ClutterTimeline*) _tmp21_, TRUE);
			_tmp22_ = transition;
			_tmp23_ = opacity_transition;
			clutter_transition_group_add_transition (_tmp22_, (ClutterTransition*) _tmp23_);
			_tmp24_ = transition;
			_tmp25_ = scale_x_transition;
			clutter_transition_group_add_transition (_tmp24_, (ClutterTransition*) _tmp25_);
			_tmp26_ = transition;
			_tmp27_ = scale_y_transition;
			clutter_transition_group_add_transition (_tmp26_, (ClutterTransition*) _tmp27_);
			_tmp28_ = transition;
			clutter_actor_add_transition ((ClutterActor*) self, "pulse", (ClutterTransition*) _tmp28_);
			_g_object_unref0 (scale_y_transition);
			_g_object_unref0 (scale_x_transition);
			_g_object_unref0 (opacity_transition);
			_g_object_unref0 (transition);
		}
	}
	self->priv->_temporary = value;
	g_object_notify_by_pspec ((GObject *) self, gala_window_icon_actor_properties[GALA_WINDOW_ICON_ACTOR_TEMPORARY_PROPERTY]);
}

static GObject *
gala_window_icon_actor_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowIconActor * self;
	MetaWindow* _tmp0_;
	parent_class = G_OBJECT_CLASS (gala_window_icon_actor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	_tmp0_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::on-all-workspaces", (GCallback) _gala_window_icon_actor_on_all_workspaces_changed_g_object_notify, self, 0);
	return obj;
}

static void
gala_window_icon_actor_class_init (GalaWindowIconActorClass * klass,
                                   gpointer klass_data)
{
	gala_window_icon_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowIconActor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_icon_actor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_icon_actor_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_icon_actor_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_icon_actor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_ICON_ACTOR_WINDOW_PROPERTY, gala_window_icon_actor_properties[GALA_WINDOW_ICON_ACTOR_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The icon size of the WindowIcon. Once set the new icon will be
	     * faded over the old one and the actor animates to the new size.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_ICON_ACTOR_ICON_SIZE_PROPERTY, gala_window_icon_actor_properties[GALA_WINDOW_ICON_ACTOR_ICON_SIZE_PROPERTY] = g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Mark the WindowIcon as temporary. Only effect of this is that a pulse
	     * animation will be played on the actor. Used while DnDing window thumbs
	     * over the group.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_ICON_ACTOR_TEMPORARY_PROPERTY, gala_window_icon_actor_properties[GALA_WINDOW_ICON_ACTOR_TEMPORARY_PROPERTY] = g_param_spec_boolean ("temporary", "temporary", "temporary", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gala_window_icon_actor_instance_init (GalaWindowIconActor * self,
                                      gpointer klass)
{
	self->priv = gala_window_icon_actor_get_instance_private (self);
	self->priv->cur_icon_scale = 1.0f;
	self->priv->desired_icon_scale = 1.0f;
	self->priv->icon = NULL;
	self->priv->old_icon = NULL;
}

static void
gala_window_icon_actor_finalize (GObject * obj)
{
	GalaWindowIconActor * self;
	MetaWindow* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor);
	_tmp0_ = self->priv->_window;
	g_signal_parse_name ("notify::on-all-workspaces", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _gala_window_icon_actor_on_all_workspaces_changed_g_object_notify, self);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->old_icon);
	G_OBJECT_CLASS (gala_window_icon_actor_parent_class)->finalize (obj);
}

/**
 * Private class which is basically just a container for the actual
 * icon and takes care of blending the same icon in different sizes
 * over each other and various animations related to the icons
 */
 G_GNUC_NO_INLINE static GType
gala_window_icon_actor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowIconActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_icon_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowIconActor), 0, (GInstanceInitFunc) gala_window_icon_actor_instance_init, NULL };
	GType gala_window_icon_actor_type_id;
	gala_window_icon_actor_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowIconActor", &g_define_type_info, 0);
	GalaWindowIconActor_private_offset = g_type_add_instance_private (gala_window_icon_actor_type_id, sizeof (GalaWindowIconActorPrivate));
	return gala_window_icon_actor_type_id;
}

GType
gala_window_icon_actor_get_type (void)
{
	static gsize gala_window_icon_actor_type_id__once = 0;
	if (g_once_init_enter (&gala_window_icon_actor_type_id__once)) {
		GType gala_window_icon_actor_type_id;
		gala_window_icon_actor_type_id = gala_window_icon_actor_get_type_once ();
		g_once_init_leave (&gala_window_icon_actor_type_id__once, gala_window_icon_actor_type_id);
	}
	return gala_window_icon_actor_type_id__once;
}

static void
_vala_gala_window_icon_actor_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaWindowIconActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor);
	switch (property_id) {
		case GALA_WINDOW_ICON_ACTOR_WINDOW_PROPERTY:
		g_value_set_object (value, gala_window_icon_actor_get_window (self));
		break;
		case GALA_WINDOW_ICON_ACTOR_ICON_SIZE_PROPERTY:
		g_value_set_int (value, gala_window_icon_actor_get_icon_size (self));
		break;
		case GALA_WINDOW_ICON_ACTOR_TEMPORARY_PROPERTY:
		g_value_set_boolean (value, gala_window_icon_actor_get_temporary (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_icon_actor_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaWindowIconActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor);
	switch (property_id) {
		case GALA_WINDOW_ICON_ACTOR_WINDOW_PROPERTY:
		gala_window_icon_actor_set_window (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_ICON_ACTOR_ICON_SIZE_PROPERTY:
		gala_window_icon_actor_set_icon_size (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_ICON_ACTOR_TEMPORARY_PROPERTY:
		gala_window_icon_actor_set_temporary (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

