/* imap-parameter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-parameter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_PARAMETER_0_PROPERTY,
	GEARY_IMAP_PARAMETER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_parameter_properties[GEARY_IMAP_PARAMETER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer geary_imap_parameter_parent_class = NULL;

static void geary_imap_parameter_real_serialize (GearyImapParameter* self,
                                          GearyImapSerializer* ser,
                                          GCancellable* cancellable,
                                          GError** error);
static gchar* geary_imap_parameter_real_to_string (GearyImapParameter* self);
static GType geary_imap_parameter_get_type_once (void);

/**
     * Returns an appropriate {@link Parameter} for the string.
     *
     * get_for_string() goes from simple to complexity in terms of parameter encoding.  It uses
     * {@link StringParameter.get_best_for} first to attempt to produced an unquoted, then unquoted,
     * string.  (It will also produce a {@link NumberParameter} if appropriate.)  If the string
     * cannot be held in those forms, it returns a {@link LiteralParameter}, which is capable of
     * transmitting 8-bit data.
     */
GearyImapParameter*
geary_imap_parameter_get_for_string (const gchar* value)
{
	GError* _inner_error0_ = NULL;
	GearyImapParameter* result;
	g_return_val_if_fail (value != NULL, NULL);
	{
		GearyImapStringParameter* _tmp0_ = NULL;
		GearyImapStringParameter* _tmp1_;
		GearyImapStringParameter* _tmp2_;
		_tmp1_ = geary_imap_string_parameter_get_best_for (value, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				goto __catch0_geary_imap_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_geary_imap_error:
	{
		GearyMemoryStringBuffer* _tmp3_;
		GearyMemoryStringBuffer* _tmp4_;
		GearyImapLiteralParameter* _tmp5_;
		GearyImapParameter* _tmp6_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = geary_memory_string_buffer_new (value);
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_imap_literal_parameter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
		_g_object_unref0 (_tmp4_);
		result = _tmp6_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/**
     * Invoked when this parameter is to be serialized out to the network.
     *
     * This method is intended to be used for serialising IMAP command
     * lines, which are typically short, single lines. Hence this
     * method is not asynchronous since the serialiser will buffer
     * writes to it. Any parameters with large volumes of data to
     * serialise (typically {@link LiteralParameter}) are specially
     * handled by {@link Command} when serialising.
     */
static void
geary_imap_parameter_real_serialize (GearyImapParameter* self,
                                     GearyImapSerializer* ser,
                                     GCancellable* cancellable,
                                     GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_imap_parameter_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
geary_imap_parameter_serialize (GearyImapParameter* self,
                                GearyImapSerializer* ser,
                                GCancellable* cancellable,
                                GError** error)
{
	GearyImapParameterClass* _klass_;
	g_return_if_fail (GEARY_IMAP_IS_PARAMETER (self));
	_klass_ = GEARY_IMAP_PARAMETER_GET_CLASS (self);
	if (_klass_->serialize) {
		_klass_->serialize (self, ser, cancellable, error);
	}
}

/**
     * Returns a representation of the {@link Parameter} suitable for logging and debugging,
     * but should not be relied upon for wire or persistent representation.
     */
static gchar*
geary_imap_parameter_real_to_string (GearyImapParameter* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_imap_parameter_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
geary_imap_parameter_to_string (GearyImapParameter* self)
{
	GearyImapParameterClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_PARAMETER (self), NULL);
	_klass_ = GEARY_IMAP_PARAMETER_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

GearyImapParameter*
geary_imap_parameter_construct (GType object_type)
{
	GearyImapParameter * self = NULL;
	self = (GearyImapParameter*) geary_base_object_construct (object_type);
	return self;
}

static void
geary_imap_parameter_class_init (GearyImapParameterClass * klass,
                                 gpointer klass_data)
{
	geary_imap_parameter_parent_class = g_type_class_peek_parent (klass);
	((GearyImapParameterClass *) klass)->serialize = (void (*) (GearyImapParameter*, GearyImapSerializer*, GCancellable*, GError**)) geary_imap_parameter_real_serialize;
	((GearyImapParameterClass *) klass)->to_string = (gchar* (*) (GearyImapParameter*)) geary_imap_parameter_real_to_string;
}

static void
geary_imap_parameter_instance_init (GearyImapParameter * self,
                                    gpointer klass)
{
}

/**
 * The basic abstraction of a single IMAP parameter that may be serialized and deserialized to and
 * from the network.
 *
 * @see Serializer
 * @see Deserializer
 */
 G_GNUC_NO_INLINE static GType
geary_imap_parameter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapParameter), 0, (GInstanceInitFunc) geary_imap_parameter_instance_init, NULL };
	GType geary_imap_parameter_type_id;
	geary_imap_parameter_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapParameter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return geary_imap_parameter_type_id;
}

GType
geary_imap_parameter_get_type (void)
{
	static gsize geary_imap_parameter_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_parameter_type_id__once)) {
		GType geary_imap_parameter_type_id;
		geary_imap_parameter_type_id = geary_imap_parameter_get_type_once ();
		g_once_init_leave (&geary_imap_parameter_type_id__once, geary_imap_parameter_type_id);
	}
	return geary_imap_parameter_type_id__once;
}

