{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./
-- 
-- /Since: 4.20/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.ComponentTransferNode
    ( 

-- * Exported types
    ComponentTransferNode(..)               ,
    IsComponentTransferNode                 ,
    toComponentTransferNode                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.ComponentTransferNode#g:method:getChild"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getTransfer]("GI.Gsk.Objects.ComponentTransferNode#g:method:getTransfer").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveComponentTransferNodeMethod      ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ComponentTransferNodeGetChildMethodInfo ,
#endif
    componentTransferNodeGetChild           ,


-- ** getTransfer #method:getTransfer#

#if defined(ENABLE_OVERLOADING)
    ComponentTransferNodeGetTransferMethodInfo,
#endif
    componentTransferNodeGetTransfer        ,


-- ** new #method:new#

    componentTransferNodeNew                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer

#endif

-- | Memory-managed wrapper type.
newtype ComponentTransferNode = ComponentTransferNode (SP.ManagedPtr ComponentTransferNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype ComponentTransferNode where
    toManagedPtr (ComponentTransferNode p) = p

foreign import ccall "gsk_component_transfer_node_get_type"
    c_gsk_component_transfer_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject ComponentTransferNode where
    glibType = c_gsk_component_transfer_node_get_type

-- | Type class for types which can be safely cast to t'ComponentTransferNode', for instance with `toComponentTransferNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ComponentTransferNode o) => IsComponentTransferNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ComponentTransferNode o) => IsComponentTransferNode o

instance O.HasParentTypes ComponentTransferNode
type instance O.ParentTypes ComponentTransferNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'ComponentTransferNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toComponentTransferNode :: (MIO.MonadIO m, IsComponentTransferNode o) => o -> m ComponentTransferNode
toComponentTransferNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo ComponentTransferNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveComponentTransferNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveComponentTransferNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveComponentTransferNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveComponentTransferNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveComponentTransferNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveComponentTransferNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveComponentTransferNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveComponentTransferNodeMethod "getChild" o = ComponentTransferNodeGetChildMethodInfo
    ResolveComponentTransferNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveComponentTransferNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveComponentTransferNodeMethod "getTransfer" o = ComponentTransferNodeGetTransferMethodInfo
    ResolveComponentTransferNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveComponentTransferNodeMethod t ComponentTransferNode, O.OverloadedMethod info ComponentTransferNode p) => OL.IsLabel t (ComponentTransferNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveComponentTransferNodeMethod t ComponentTransferNode, O.OverloadedMethod info ComponentTransferNode p, R.HasField t ComponentTransferNode p) => R.HasField t ComponentTransferNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveComponentTransferNodeMethod t ComponentTransferNode, O.OverloadedMethodInfo info ComponentTransferNode) => OL.IsLabel t (O.MethodProxy info ComponentTransferNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ComponentTransferNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method ComponentTransferNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The child to apply component transfers to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ComponentTransfer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "transfer for the red component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "g"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ComponentTransfer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "transfer for the green component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ComponentTransfer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "transfer for the blue component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ComponentTransfer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "transfer for the alpha component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gsk" , name = "ComponentTransferNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_component_transfer_node_new" gsk_component_transfer_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- child : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Gsk.ComponentTransfer.ComponentTransfer -> -- r : TInterface (Name {namespace = "Gsk", name = "ComponentTransfer"})
    Ptr Gsk.ComponentTransfer.ComponentTransfer -> -- g : TInterface (Name {namespace = "Gsk", name = "ComponentTransfer"})
    Ptr Gsk.ComponentTransfer.ComponentTransfer -> -- b : TInterface (Name {namespace = "Gsk", name = "ComponentTransfer"})
    Ptr Gsk.ComponentTransfer.ComponentTransfer -> -- a : TInterface (Name {namespace = "Gsk", name = "ComponentTransfer"})
    IO (Ptr ComponentTransferNode)

-- | Creates a render node that will apply component
-- transfers to a child node.
-- 
-- /Since: 4.20/
componentTransferNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    a
    -- ^ /@child@/: The child to apply component transfers to
    -> Gsk.ComponentTransfer.ComponentTransfer
    -- ^ /@r@/: transfer for the red component
    -> Gsk.ComponentTransfer.ComponentTransfer
    -- ^ /@g@/: transfer for the green component
    -> Gsk.ComponentTransfer.ComponentTransfer
    -- ^ /@b@/: transfer for the blue component
    -> Gsk.ComponentTransfer.ComponentTransfer
    -- ^ /@a@/: transfer for the alpha component
    -> m ComponentTransferNode
    -- ^ __Returns:__ A new @GskRenderNode@
componentTransferNodeNew child r g b a = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    r' <- unsafeManagedPtrGetPtr r
    g' <- unsafeManagedPtrGetPtr g
    b' <- unsafeManagedPtrGetPtr b
    a' <- unsafeManagedPtrGetPtr a
    result <- gsk_component_transfer_node_new child' r' g' b' a'
    checkUnexpectedReturnNULL "componentTransferNodeNew" result
    result' <- (wrapPtr ComponentTransferNode) result
    touchManagedPtr child
    touchManagedPtr r
    touchManagedPtr g
    touchManagedPtr b
    touchManagedPtr a
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ComponentTransferNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface
--                 Name { namespace = "Gsk" , name = "ComponentTransferNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a debug `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_component_transfer_node_get_child" gsk_component_transfer_node_get_child :: 
    Ptr ComponentTransferNode ->            -- node : TInterface (Name {namespace = "Gsk", name = "ComponentTransferNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Gets the child node that is getting drawn by the given /@node@/.
-- 
-- /Since: 4.20/
componentTransferNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsComponentTransferNode a) =>
    a
    -- ^ /@node@/: a debug @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ the child @GskRenderNode@
componentTransferNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_component_transfer_node_get_child node'
    checkUnexpectedReturnNULL "componentTransferNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ComponentTransferNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsComponentTransferNode a) => O.OverloadedMethod ComponentTransferNodeGetChildMethodInfo a signature where
    overloadedMethod = componentTransferNodeGetChild

instance O.OverloadedMethodInfo ComponentTransferNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ComponentTransferNode.componentTransferNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ComponentTransferNode.html#v:componentTransferNodeGetChild"
        })


#endif

-- method ComponentTransferNode::get_transfer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface
--                 Name { namespace = "Gsk" , name = "ComponentTransferNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a debug `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "component"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a value between 0 and 3 to indicate the red, green, blue\n  or alpha component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gsk" , name = "ComponentTransfer" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_component_transfer_node_get_transfer" gsk_component_transfer_node_get_transfer :: 
    Ptr ComponentTransferNode ->            -- node : TInterface (Name {namespace = "Gsk", name = "ComponentTransferNode"})
    Word32 ->                               -- component : TBasicType TUInt
    IO (Ptr Gsk.ComponentTransfer.ComponentTransfer)

-- | Gets the component transfer for one of the components.
-- 
-- /Since: 4.20/
componentTransferNodeGetTransfer ::
    (B.CallStack.HasCallStack, MonadIO m, IsComponentTransferNode a) =>
    a
    -- ^ /@node@/: a debug @GskRenderNode@
    -> Word32
    -- ^ /@component@/: a value between 0 and 3 to indicate the red, green, blue
    --   or alpha component
    -> m Gsk.ComponentTransfer.ComponentTransfer
    -- ^ __Returns:__ the @GskComponentTransfer@
componentTransferNodeGetTransfer node component = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_component_transfer_node_get_transfer node' component
    checkUnexpectedReturnNULL "componentTransferNodeGetTransfer" result
    result' <- (newBoxed Gsk.ComponentTransfer.ComponentTransfer) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ComponentTransferNodeGetTransferMethodInfo
instance (signature ~ (Word32 -> m Gsk.ComponentTransfer.ComponentTransfer), MonadIO m, IsComponentTransferNode a) => O.OverloadedMethod ComponentTransferNodeGetTransferMethodInfo a signature where
    overloadedMethod = componentTransferNodeGetTransfer

instance O.OverloadedMethodInfo ComponentTransferNodeGetTransferMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ComponentTransferNode.componentTransferNodeGetTransfer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ComponentTransferNode.html#v:componentTransferNodeGetTransfer"
        })


#endif


