// Copyright 2019 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: security/v1beta1/authorization_policy.proto

// $schema: istio.security.v1beta1.AuthorizationPolicy
// $title: Authorization Policy
// $description: Configuration for access control on workloads.
// $location: https://istio.io/docs/reference/config/security/authorization-policy.html
// $weight: 20
// $aliases: [/docs/reference/config/authorization/authorization-policy]

// Istio Authorization Policy enables access control on workloads in the mesh.
//
// Authorization policy supports CUSTOM, DENY and ALLOW actions for access control. When CUSTOM, DENY and ALLOW actions
// are used for a workload at the same time, the CUSTOM action is evaluated first, then the DENY action, and finally the ALLOW action.
// The evaluation is determined by the following rules:
//
// 1. If there are any CUSTOM policies that match the request, evaluate and deny the request if the evaluation result is deny.
// 2. If there are any DENY policies that match the request, deny the request.
// 3. If there are no ALLOW policies for the workload, allow the request.
// 4. If any of the ALLOW policies match the request, allow the request.
// 5. Deny the request.
//
// Istio Authorization Policy also supports the AUDIT action to decide whether to log requests.
// AUDIT policies do not affect whether requests are allowed or denied to the workload.
// Requests will be allowed or denied based solely on CUSTOM, DENY and ALLOW actions.
//
// A request will be internally marked that it should be audited if there is an AUDIT policy on the workload that matches the request.
// A separate plugin must be configured and enabled to actually fulfill the audit decision and complete the audit behavior.
// The request will not be audited if there are no such supporting plugins enabled.
//
// Here is an example of Istio Authorization Policy:
//
// It sets the `action` to `ALLOW` to create an allow policy. The default action is `ALLOW`
// but it is useful to be explicit in the policy.
//
// It allows requests from:
//
// - service account `cluster.local/ns/default/sa/sleep` or
// - namespace `test`
//
// to access the workload with:
//
// - `GET` method at paths of prefix `/info` or,
// - `POST` method at path `/data`.
//
// when the request has a valid JWT token issued by `https://accounts.google.com`.
//
// Any other requests will be denied.
//
// ```yaml
// apiVersion: security.istio.io/v1
// kind: AuthorizationPolicy
// metadata:
//   name: httpbin
//   namespace: foo
// spec:
//   action: ALLOW
//   rules:
//   - from:
//     - source:
//         principals: ["cluster.local/ns/default/sa/sleep"]
//     - source:
//         namespaces: ["test"]
//     to:
//     - operation:
//         methods: ["GET"]
//         paths: ["/info*"]
//     - operation:
//         methods: ["POST"]
//         paths: ["/data"]
//     when:
//     - key: request.auth.claims[iss]
//       values: ["https://accounts.google.com"]
// ```
//
// The following is another example that sets `action` to `DENY` to create a deny policy.
// It denies requests from the `dev` namespace to the `POST` method on all workloads
// in the `foo` namespace.
//
// ```yaml
// apiVersion: security.istio.io/v1
// kind: AuthorizationPolicy
// metadata:
//   name: httpbin
//   namespace: foo
// spec:
//   action: DENY
//   rules:
//   - from:
//     - source:
//         namespaces: ["dev"]
//     to:
//     - operation:
//         methods: ["POST"]
// ```
//
// The following is another example that sets `action` to `DENY` to create a deny policy.
// It denies all the requests with `POST` method on port `8080` on all workloads
// in the `foo` namespace.
//
// ```yaml
// apiVersion: security.istio.io/v1
// kind: AuthorizationPolicy
// metadata:
//   name: httpbin
//   namespace: foo
// spec:
//   action: DENY
//   rules:
//   - to:
//     - operation:
//         methods: ["POST"]
//         ports: ["8080"]
// ```
//
// When this rule is applied to TCP traffic, the `method` field (as will all HTTP based attributes) cannot be processed.
// For a `DENY` rule, missing attributes are treated as matches. This means all TCP traffic on port `8080` would be denied in the example above.
// If we were to remove the `ports` match, all TCP traffic would be denied. As a result, it is recommended to always scope `DENY` policies to a specific port,
// especially when using HTTP attributes [Authorization Policy for TCP Ports](https://istio.io/latest/docs/tasks/security/authorization/authz-tcp/).
//
// The following authorization policy sets the `action` to `AUDIT`. It will audit any `GET` requests to the path with the
// prefix `/user/profile`.
//
// ```yaml
// apiVersion: security.istio.io/v1
// kind: AuthorizationPolicy
// metadata:
//   namespace: ns1
//   name: anyname
// spec:
//   selector:
//     matchLabels:
//       app: myapi
//   action: AUDIT
//   rules:
//   - to:
//     - operation:
//         methods: ["GET"]
//         paths: ["/user/profile/*"]
// ```
//
// Authorization Policy scope (target) is determined by "metadata/namespace" and
// an optional `selector`.
//
// - "metadata/namespace" tells which namespace the policy applies. If set to root
// namespace, the policy applies to all namespaces in a mesh.
// - workload `selector` can be used to further restrict where a policy applies.
//
// For example, the following authorization policy applies to all workloads in namespace `foo`. It allows nothing and effectively denies
// all requests to workloads in namespace `foo`.
//
// ```yaml
// apiVersion: security.istio.io/v1
// kind: AuthorizationPolicy
// metadata:
//  name: allow-nothing
//  namespace: foo
// spec:
//   {}
// ```
//
// The following authorization policy allows all requests to workloads in namespace `foo`.
//
// ```yaml
// apiVersion: security.istio.io/v1
// kind: AuthorizationPolicy
// metadata:
//  name: allow-all
//  namespace: foo
// spec:
//  rules:
//  - {}
// ```
//
// The following authorization policy applies to workloads containing label `app: httpbin` in namespace `bar`. It allows
// nothing and effectively denies all requests to the selected workloads.
//
// ```yaml
// apiVersion: security.istio.io/v1
// kind: AuthorizationPolicy
// metadata:
//   name: allow-nothing
//   namespace: bar
// spec:
//   selector:
//     matchLabels:
//       app: httpbin
// ```
//
// The following authorization policy applies to workloads containing label `version: v1` in all namespaces in the mesh.
// (Assuming the root namespace is configured to `istio-system`).
//
// ```yaml
// apiVersion: security.istio.io/v1
// kind: AuthorizationPolicy
// metadata:
//  name: allow-nothing
//  namespace: istio-system
// spec:
//  selector:
//    matchLabels:
//      version: v1
// ```
//
// The following example shows you how to set up an authorization policy using an [experimental annotation](https://istio.io/latest/docs/reference/config/annotations/)
// `istio.io/dry-run` to dry-run the policy without actually enforcing it.
//
// The dry-run annotation allows you to better understand the effect of an authorization policy before applying it to the production traffic.
// This helps to reduce the risk of breaking the production traffic caused by an incorrect authorization policy.
// For more information, see [dry-run tasks](https://istio.io/latest/docs/tasks/security/authorization/authz-dry-run/).
//
// ```yaml
// apiVersion: security.istio.io/v1
// kind: AuthorizationPolicy
// metadata:
//   name: dry-run-example
//   annotations:
//     "istio.io/dry-run": "true"
// spec:
//   selector:
//     matchLabels:
//       app: httpbin
//   action: DENY
//   rules:
//   - to:
//     - operation:
//         paths: ["/headers"]
// ```

package v1beta1

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1beta1 "istio.io/api/type/v1beta1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Action specifies the operation to take.
type AuthorizationPolicy_Action int32

const (
	// Allow a request only if it matches the rules. This is the default type.
	AuthorizationPolicy_ALLOW AuthorizationPolicy_Action = 0
	// Deny a request if it matches any of the rules.
	AuthorizationPolicy_DENY AuthorizationPolicy_Action = 1
	// Audit a request if it matches any of the rules.
	AuthorizationPolicy_AUDIT AuthorizationPolicy_Action = 2
	// The CUSTOM action allows an extension to handle the user request if the matching rules evaluate to true.
	// The extension is evaluated independently and before the native ALLOW and DENY actions. When used together, A request
	// is allowed if and only if all the actions return allow, in other words, the extension cannot bypass the
	// authorization decision made by ALLOW and DENY action.
	// Extension behavior is defined by the named providers declared in MeshConfig. The authorization policy refers to
	// the extension by specifying the name of the provider.
	// One example use case of the extension is to integrate with a custom external authorization system to delegate
	// the authorization decision to it.
	//
	// The following authorization policy applies to an ingress gateway and delegates the authorization check to a named extension
	// `my-custom-authz` if the request path has prefix `/admin/`.
	//
	// ```yaml
	// apiVersion: security.istio.io/v1
	// kind: AuthorizationPolicy
	// metadata:
	//
	//	name: ext-authz
	//	namespace: istio-system
	//
	// spec:
	//
	//	selector:
	//	  matchLabels:
	//	    app: istio-ingressgateway
	//	action: CUSTOM
	//	provider:
	//	  name: "my-custom-authz"
	//	rules:
	//	- to:
	//	  - operation:
	//	      paths: ["/admin/*"]
	//
	// ```
	AuthorizationPolicy_CUSTOM AuthorizationPolicy_Action = 3
)

// Enum value maps for AuthorizationPolicy_Action.
var (
	AuthorizationPolicy_Action_name = map[int32]string{
		0: "ALLOW",
		1: "DENY",
		2: "AUDIT",
		3: "CUSTOM",
	}
	AuthorizationPolicy_Action_value = map[string]int32{
		"ALLOW":  0,
		"DENY":   1,
		"AUDIT":  2,
		"CUSTOM": 3,
	}
)

func (x AuthorizationPolicy_Action) Enum() *AuthorizationPolicy_Action {
	p := new(AuthorizationPolicy_Action)
	*p = x
	return p
}

func (x AuthorizationPolicy_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthorizationPolicy_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_security_v1beta1_authorization_policy_proto_enumTypes[0].Descriptor()
}

func (AuthorizationPolicy_Action) Type() protoreflect.EnumType {
	return &file_security_v1beta1_authorization_policy_proto_enumTypes[0]
}

func (x AuthorizationPolicy_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthorizationPolicy_Action.Descriptor instead.
func (AuthorizationPolicy_Action) EnumDescriptor() ([]byte, []int) {
	return file_security_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{0, 0}
}

// AuthorizationPolicy enables access control on workloads.
//
// <!-- crd generation tags
// +cue-gen:AuthorizationPolicy:groupName:security.istio.io
// +cue-gen:AuthorizationPolicy:versions:v1,v1beta1
// +cue-gen:AuthorizationPolicy:storageVersion
// +cue-gen:AuthorizationPolicy:annotations:helm.sh/resource-policy=keep
// +cue-gen:AuthorizationPolicy:labels:app=istio-pilot,chart=istio,istio=security,heritage=Tiller,release=istio
// +cue-gen:AuthorizationPolicy:subresource:status
// +cue-gen:AuthorizationPolicy:scope:Namespaced
// +cue-gen:AuthorizationPolicy:resource:categories=istio-io,security-istio-io,shortNames=ap,plural=authorizationpolicies
// +cue-gen:AuthorizationPolicy:preserveUnknownFields:false
// +cue-gen:AuthorizationPolicy:printerColumn:name=Action,type=string,JSONPath=.spec.action,description="The operation to take."
// +cue-gen:AuthorizationPolicy:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=security.istio.io/v1beta1
// +genclient
// +k8s:deepcopy-gen=true
// -->
// +kubebuilder:validation:XValidation:message="only one of targetRefs or selector can be set",rule="oneof(self.selector, self.targetRef, self.targetRefs)"
type AuthorizationPolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional. The selector decides where to apply the authorization policy. The selector will match with workloads
	// in the same namespace as the authorization policy. If the authorization policy is in the root namespace, the selector
	// will additionally match with workloads in all namespaces.
	//
	// If the selector and the targetRef are not set, the selector will match all workloads.
	//
	// At most one of `selector` or `targetRefs` can be set for a given policy.
	Selector *v1beta1.WorkloadSelector `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// $hide_from_docs
	TargetRef *v1beta1.PolicyTargetReference `protobuf:"bytes,5,opt,name=targetRef,proto3" json:"targetRef,omitempty"`
	// Optional. The targetRefs specifies a list of resources the policy should be
	// applied to. The targeted resources specified will determine which workloads
	// the policy applies to.
	//
	// Currently, the following resource attachment types are supported:
	// * `kind: Gateway` with `group: gateway.networking.k8s.io` in the same namespace.
	// * `kind: GatewayClass` with `group: gateway.networking.k8s.io` in the root namespace.
	// * `kind: Service` with `group: ""` or `group: "core"` in the same namespace. This type is only supported for waypoints.
	// * `kind: ServiceEntry` with `group: networking.istio.io` in the same namespace.
	//
	// If not set, the policy is applied as defined by the selector.
	// At most one of the selector and targetRefs can be set.
	//
	// NOTE: If you are using the `targetRefs` field in a multi-revision environment with Istio versions prior to 1.22,
	// it is highly recommended that you pin the policy to a revision running 1.22+ via the `istio.io/rev` label.
	// This is to prevent proxies connected to older control planes (that don't know about the `targetRefs` field)
	// from misinterpreting the policy as namespace-wide during the upgrade process.
	//
	// NOTE: Waypoint proxies are required to use this field for policies to apply; `selector` policies will be ignored.
	// +kubebuilder:validation:MaxItems=16
	TargetRefs []*v1beta1.PolicyTargetReference `protobuf:"bytes,6,rep,name=targetRefs,proto3" json:"targetRefs,omitempty"`
	// Optional. A list of rules to match the request. A match occurs when at least one rule matches the request.
	//
	// If not set, the match will never occur. This is equivalent to setting a default of deny for the target workloads if
	// the action is ALLOW.
	// +kubebuilder:validation:MaxItems=512
	Rules []*Rule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
	// Optional. The action to take if the request is matched with the rules. Default is ALLOW if not specified.
	Action AuthorizationPolicy_Action `protobuf:"varint,3,opt,name=action,proto3,enum=istio.security.v1beta1.AuthorizationPolicy_Action" json:"action,omitempty"`
	// Types that are valid to be assigned to ActionDetail:
	//
	//	*AuthorizationPolicy_Provider
	ActionDetail  isAuthorizationPolicy_ActionDetail `protobuf_oneof:"action_detail"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AuthorizationPolicy) Reset() {
	*x = AuthorizationPolicy{}
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthorizationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationPolicy) ProtoMessage() {}

func (x *AuthorizationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationPolicy.ProtoReflect.Descriptor instead.
func (*AuthorizationPolicy) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{0}
}

func (x *AuthorizationPolicy) GetSelector() *v1beta1.WorkloadSelector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *AuthorizationPolicy) GetTargetRef() *v1beta1.PolicyTargetReference {
	if x != nil {
		return x.TargetRef
	}
	return nil
}

func (x *AuthorizationPolicy) GetTargetRefs() []*v1beta1.PolicyTargetReference {
	if x != nil {
		return x.TargetRefs
	}
	return nil
}

func (x *AuthorizationPolicy) GetRules() []*Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *AuthorizationPolicy) GetAction() AuthorizationPolicy_Action {
	if x != nil {
		return x.Action
	}
	return AuthorizationPolicy_ALLOW
}

func (x *AuthorizationPolicy) GetActionDetail() isAuthorizationPolicy_ActionDetail {
	if x != nil {
		return x.ActionDetail
	}
	return nil
}

func (x *AuthorizationPolicy) GetProvider() *AuthorizationPolicy_ExtensionProvider {
	if x != nil {
		if x, ok := x.ActionDetail.(*AuthorizationPolicy_Provider); ok {
			return x.Provider
		}
	}
	return nil
}

type isAuthorizationPolicy_ActionDetail interface {
	isAuthorizationPolicy_ActionDetail()
}

type AuthorizationPolicy_Provider struct {
	// Specifies detailed configuration of the CUSTOM action. Must be used only with CUSTOM action.
	Provider *AuthorizationPolicy_ExtensionProvider `protobuf:"bytes,4,opt,name=provider,proto3,oneof"`
}

func (*AuthorizationPolicy_Provider) isAuthorizationPolicy_ActionDetail() {}

// Rule matches requests from a list of sources that perform a list of operations subject to a
// list of conditions. A match occurs when at least one source, one operation and all conditions
// matches the request. An empty rule is always matched.
//
// Any string field in the rule supports Exact, Prefix, Suffix and Presence match:
//
// - Exact match: `abc` will match on value `abc`.
// - Prefix match: `abc*` will match on value `abc` and `abcd`.
// - Suffix match: `*abc` will match on value `abc` and `xabc`.
// - Presence match: `*` will match when value is not empty.
type Rule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional. `from` specifies the source of a request.
	//
	// If not set, any source is allowed.
	// +kubebuilder:validation:MaxItems=512
	From []*Rule_From `protobuf:"bytes,1,rep,name=from,proto3" json:"from,omitempty"`
	// Optional. `to` specifies the operation of a request.
	//
	// If not set, any operation is allowed.
	To []*Rule_To `protobuf:"bytes,2,rep,name=to,proto3" json:"to,omitempty"`
	// Optional. `when` specifies a list of additional conditions of a request.
	//
	// If not set, any condition is allowed.
	When          []*Condition `protobuf:"bytes,3,rep,name=when,proto3" json:"when,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Rule) Reset() {
	*x = Rule{}
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule.ProtoReflect.Descriptor instead.
func (*Rule) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{1}
}

func (x *Rule) GetFrom() []*Rule_From {
	if x != nil {
		return x.From
	}
	return nil
}

func (x *Rule) GetTo() []*Rule_To {
	if x != nil {
		return x.To
	}
	return nil
}

func (x *Rule) GetWhen() []*Condition {
	if x != nil {
		return x.When
	}
	return nil
}

// Source specifies the source identities of a request. Fields in the source are
// ANDed together.
//
// For example, the following source matches if the principal is `admin` or `dev`
// and the namespace is `prod` or `test` and the ip is not `203.0.113.4`.
//
// ```yaml
// principals: ["admin", "dev"]
// namespaces: ["prod", "test"]
// notIpBlocks: ["203.0.113.4"]
// ```
// +kubebuilder:validation:XValidation:message="Cannot set serviceAccounts with namespaces or principals",rule="(has(self.serviceAccounts) || has(self.notServiceAccounts)) ? (!has(self.principals) && !has(self.notPrincipals) && !has(self.namespaces) && !has(self.notNamespaces)) : true"
type Source struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional. A list of peer identities derived from the peer certificate. The peer identity is in the format of
	// `"<TRUST_DOMAIN>/ns/<NAMESPACE>/sa/<SERVICE_ACCOUNT>"`, for example, `"cluster.local/ns/default/sa/productpage"`.
	// This field requires mTLS enabled and is the same as the `source.principal` attribute.
	//
	// Usage of `serviceAccounts` is typically simpler and offers the same functionality.
	//
	// If not set, any principal is allowed.
	Principals []string `protobuf:"bytes,1,rep,name=principals,proto3" json:"principals,omitempty"`
	// Optional. A list of negative match of peer identities.
	NotPrincipals []string `protobuf:"bytes,5,rep,name=not_principals,json=notPrincipals,proto3" json:"not_principals,omitempty"`
	// Optional. A list of request identities derived from the JWT. The request identity is in the format of
	// `"<ISS>/<SUB>"`, for example, `"example.com/sub-1"`. This field requires request authentication enabled and is the
	// same as the `request.auth.principal` attribute.
	//
	// If not set, any request principal is allowed.
	RequestPrincipals []string `protobuf:"bytes,2,rep,name=request_principals,json=requestPrincipals,proto3" json:"request_principals,omitempty"`
	// Optional. A list of negative match of request identities.
	NotRequestPrincipals []string `protobuf:"bytes,6,rep,name=not_request_principals,json=notRequestPrincipals,proto3" json:"not_request_principals,omitempty"`
	// Optional. A list of namespaces derived from the peer certificate.
	// This field requires mTLS enabled and is the same as the `source.namespace` attribute.
	//
	// If not set, any namespace is allowed.
	Namespaces []string `protobuf:"bytes,3,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	// Optional. A list of negative match of namespaces.
	NotNamespaces []string `protobuf:"bytes,7,rep,name=not_namespaces,json=notNamespaces,proto3" json:"not_namespaces,omitempty"`
	// Optional. A list of Kubernetes service accounts derived from the peer certificate.
	// This field requires mTLS enabled and is the same as the `source.serviceaccount` attribute.
	//
	// This takes the format `<namespace>/<serviceaccount>`.
	// `<serviceaccount>` may also be used to use the same namespace as the `AuthorizationPolicy`.
	//
	// If not set, any service account is allowed.
	//
	// No form of wildcard (`*`) is allowed.
	// Cannot be set with `principals` or `namespaces`.
	//
	// +protoc-gen-crd:list-value-validation:MaxLength=320
	// +kubebuilder:validation:MaxItems=16
	ServiceAccounts []string `protobuf:"bytes,11,rep,name=service_accounts,json=serviceAccounts,proto3" json:"service_accounts,omitempty"`
	// Optional. A list of negative match of Kubernetes service accounts.
	//
	// This takes the format `<namespace>/<serviceaccount>`.
	// `<serviceaccount>` may also be used to use the same namespace as the `AuthorizationPolicy`.
	//
	// No form of wildcard (`*`) is allowed.
	// +protoc-gen-crd:list-value-validation:MaxLength=320
	// +kubebuilder:validation:MaxItems=16
	NotServiceAccounts []string `protobuf:"bytes,12,rep,name=not_service_accounts,json=notServiceAccounts,proto3" json:"not_service_accounts,omitempty"`
	// Optional. A list of IP blocks, populated from the source address of the IP packet. Single IP (e.g. `203.0.113.4`) and
	// CIDR (e.g. `203.0.113.0/24`) are supported. This is the same as the `source.ip` attribute.
	//
	// If not set, any IP is allowed.
	IpBlocks []string `protobuf:"bytes,4,rep,name=ip_blocks,json=ipBlocks,proto3" json:"ip_blocks,omitempty"`
	// Optional. A list of negative match of IP blocks.
	NotIpBlocks []string `protobuf:"bytes,8,rep,name=not_ip_blocks,json=notIpBlocks,proto3" json:"not_ip_blocks,omitempty"`
	// Optional. A list of IP blocks, populated from `X-Forwarded-For` header or proxy protocol.
	// To make use of this field, you must configure the `numTrustedProxies` field of the `gatewayTopology` under the `meshConfig`
	// when you install Istio or using an annotation on the ingress gateway.  See the documentation here:
	// [Configuring Gateway Network Topology](https://istio.io/latest/docs/ops/configuration/traffic-management/network-topologies/).
	// Single IP (e.g. `203.0.113.4`) and CIDR (e.g. `203.0.113.0/24`) are supported.
	// This is the same as the `remote.ip` attribute.
	//
	// If not set, any IP is allowed.
	RemoteIpBlocks []string `protobuf:"bytes,9,rep,name=remote_ip_blocks,json=remoteIpBlocks,proto3" json:"remote_ip_blocks,omitempty"`
	// Optional. A list of negative match of remote IP blocks.
	NotRemoteIpBlocks []string `protobuf:"bytes,10,rep,name=not_remote_ip_blocks,json=notRemoteIpBlocks,proto3" json:"not_remote_ip_blocks,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *Source) Reset() {
	*x = Source{}
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Source) ProtoMessage() {}

func (x *Source) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Source.ProtoReflect.Descriptor instead.
func (*Source) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{2}
}

func (x *Source) GetPrincipals() []string {
	if x != nil {
		return x.Principals
	}
	return nil
}

func (x *Source) GetNotPrincipals() []string {
	if x != nil {
		return x.NotPrincipals
	}
	return nil
}

func (x *Source) GetRequestPrincipals() []string {
	if x != nil {
		return x.RequestPrincipals
	}
	return nil
}

func (x *Source) GetNotRequestPrincipals() []string {
	if x != nil {
		return x.NotRequestPrincipals
	}
	return nil
}

func (x *Source) GetNamespaces() []string {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

func (x *Source) GetNotNamespaces() []string {
	if x != nil {
		return x.NotNamespaces
	}
	return nil
}

func (x *Source) GetServiceAccounts() []string {
	if x != nil {
		return x.ServiceAccounts
	}
	return nil
}

func (x *Source) GetNotServiceAccounts() []string {
	if x != nil {
		return x.NotServiceAccounts
	}
	return nil
}

func (x *Source) GetIpBlocks() []string {
	if x != nil {
		return x.IpBlocks
	}
	return nil
}

func (x *Source) GetNotIpBlocks() []string {
	if x != nil {
		return x.NotIpBlocks
	}
	return nil
}

func (x *Source) GetRemoteIpBlocks() []string {
	if x != nil {
		return x.RemoteIpBlocks
	}
	return nil
}

func (x *Source) GetNotRemoteIpBlocks() []string {
	if x != nil {
		return x.NotRemoteIpBlocks
	}
	return nil
}

// Operation specifies the operations of a request. Fields in the operation are
// ANDed together.
//
// For example, the following operation matches if the host has suffix `.example.com`
// and the method is `GET` or `HEAD` and the path doesn't have prefix `/admin`.
//
// ```yaml
// hosts: ["*.example.com"]
// methods: ["GET", "HEAD"]
// notPaths: ["/admin*"]
// ```
type Operation struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional. A list of hosts as specified in the HTTP request. The match is case-insensitive.
	// See the [security best practices](https://istio.io/latest/docs/ops/best-practices/security/#writing-host-match-policies) for
	// recommended usage of this field.
	//
	// If not set, any host is allowed. Must be used only with HTTP.
	Hosts []string `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// Optional. A list of negative match of hosts as specified in the HTTP request. The match is case-insensitive.
	NotHosts []string `protobuf:"bytes,5,rep,name=not_hosts,json=notHosts,proto3" json:"not_hosts,omitempty"`
	// Optional. A list of ports as specified in the connection.
	//
	// If not set, any port is allowed.
	Ports []string `protobuf:"bytes,2,rep,name=ports,proto3" json:"ports,omitempty"`
	// Optional. A list of negative match of ports as specified in the connection.
	NotPorts []string `protobuf:"bytes,6,rep,name=not_ports,json=notPorts,proto3" json:"not_ports,omitempty"`
	// Optional. A list of methods as specified in the HTTP request.
	// For gRPC service, this will always be `POST`.
	//
	// If not set, any method is allowed. Must be used only with HTTP.
	Methods []string `protobuf:"bytes,3,rep,name=methods,proto3" json:"methods,omitempty"`
	// Optional. A list of negative match of methods as specified in the HTTP request.
	NotMethods []string `protobuf:"bytes,7,rep,name=not_methods,json=notMethods,proto3" json:"not_methods,omitempty"`
	// Optional. A list of paths as specified in the HTTP request. See the [Authorization Policy Normalization](https://istio.io/latest/docs/reference/config/security/normalization/)
	// for details of the path normalization.
	// For gRPC service, this will be the fully-qualified name in the form of `/package.service/method`.
	//
	// If a path in the list contains the `{*}` or `{**}` path template operator, it will be interpreted as an [Envoy Uri Template](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/path/match/uri_template/v3/uri_template_match.proto).
	// To be a valid path template, the path must not contain `*`, `{`, or `}` outside of a supported operator. No other characters are allowed in the path segment with the path template operator.
	// - `{*}` matches a single glob that cannot extend beyond a path segment.
	// - `{**}` matches zero or more globs. If a path contains `{**}`, it must be the last operator.
	//
	// Examples:
	// - `/foo/{*}` matches `/foo/bar` but not `/foo/bar/baz`
	// - `/foo/{**}/` matches `/foo/bar/`, `/foo/bar/baz.txt`, and `/foo//` but not `/foo/bar`
	// - `/foo/{*}/bar/{**}` matches `/foo/buzz/bar/` and `/foo/buzz/bar/baz`
	// - `/*/baz/{*}` is not a valid path template since it includes `*` outside of a supported operator
	// - `/**/baz/{*}` is not a valid path template since it includes `**` outside of a supported operator
	// - `/{**}/foo/{*}` is not a valid path template since `{**}` is not the last operator
	// - `/foo/{*}.txt` is invalid since there are characters other than `{*}` in the path segment
	//
	// If not set, any path is allowed. Must be used only with HTTP.
	Paths []string `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
	// Optional. A list of negative match of paths.
	NotPaths      []string `protobuf:"bytes,8,rep,name=not_paths,json=notPaths,proto3" json:"not_paths,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Operation) Reset() {
	*x = Operation{}
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation) ProtoMessage() {}

func (x *Operation) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation.ProtoReflect.Descriptor instead.
func (*Operation) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{3}
}

func (x *Operation) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *Operation) GetNotHosts() []string {
	if x != nil {
		return x.NotHosts
	}
	return nil
}

func (x *Operation) GetPorts() []string {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *Operation) GetNotPorts() []string {
	if x != nil {
		return x.NotPorts
	}
	return nil
}

func (x *Operation) GetMethods() []string {
	if x != nil {
		return x.Methods
	}
	return nil
}

func (x *Operation) GetNotMethods() []string {
	if x != nil {
		return x.NotMethods
	}
	return nil
}

func (x *Operation) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

func (x *Operation) GetNotPaths() []string {
	if x != nil {
		return x.NotPaths
	}
	return nil
}

// Condition specifies additional required attributes.
type Condition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of an Istio attribute.
	// See the [full list of supported attributes](https://istio.io/docs/reference/config/security/conditions/).
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. A list of allowed values for the attribute.
	// Note: at least one of `values` or `notValues` must be set.
	Values []string `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	// Optional. A list of negative match of values for the attribute.
	// Note: at least one of `values` or `notValues` must be set.
	NotValues     []string `protobuf:"bytes,3,rep,name=not_values,json=notValues,proto3" json:"not_values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Condition) Reset() {
	*x = Condition{}
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition) ProtoMessage() {}

func (x *Condition) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition.ProtoReflect.Descriptor instead.
func (*Condition) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{4}
}

func (x *Condition) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Condition) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *Condition) GetNotValues() []string {
	if x != nil {
		return x.NotValues
	}
	return nil
}

type AuthorizationPolicy_ExtensionProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies the name of the extension provider. The list of available providers is defined in the MeshConfig.
	// Note, currently at most 1 extension provider is allowed per workload. Different workloads can use different extension provider.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AuthorizationPolicy_ExtensionProvider) Reset() {
	*x = AuthorizationPolicy_ExtensionProvider{}
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthorizationPolicy_ExtensionProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationPolicy_ExtensionProvider) ProtoMessage() {}

func (x *AuthorizationPolicy_ExtensionProvider) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationPolicy_ExtensionProvider.ProtoReflect.Descriptor instead.
func (*AuthorizationPolicy_ExtensionProvider) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AuthorizationPolicy_ExtensionProvider) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// From includes a list of sources.
type Rule_From struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Source specifies the source of a request.
	Source        *Source `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Rule_From) Reset() {
	*x = Rule_From{}
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Rule_From) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_From) ProtoMessage() {}

func (x *Rule_From) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_From.ProtoReflect.Descriptor instead.
func (*Rule_From) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Rule_From) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

// To includes a list of operations.
type Rule_To struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Operation specifies the operation of a request.
	Operation     *Operation `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Rule_To) Reset() {
	*x = Rule_To{}
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Rule_To) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule_To) ProtoMessage() {}

func (x *Rule_To) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_authorization_policy_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule_To.ProtoReflect.Descriptor instead.
func (*Rule_To) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{1, 1}
}

func (x *Rule_To) GetOperation() *Operation {
	if x != nil {
		return x.Operation
	}
	return nil
}

var File_security_v1beta1_authorization_policy_proto protoreflect.FileDescriptor

const file_security_v1beta1_authorization_policy_proto_rawDesc = "" +
	"\n" +
	"+security/v1beta1/authorization_policy.proto\x12\x16istio.security.v1beta1\x1a\x1fgoogle/api/field_behavior.proto\x1a\x1btype/v1beta1/selector.proto\"\xb8\x04\n" +
	"\x13AuthorizationPolicy\x12@\n" +
	"\bselector\x18\x01 \x01(\v2$.istio.type.v1beta1.WorkloadSelectorR\bselector\x12G\n" +
	"\ttargetRef\x18\x05 \x01(\v2).istio.type.v1beta1.PolicyTargetReferenceR\ttargetRef\x12I\n" +
	"\n" +
	"targetRefs\x18\x06 \x03(\v2).istio.type.v1beta1.PolicyTargetReferenceR\n" +
	"targetRefs\x122\n" +
	"\x05rules\x18\x02 \x03(\v2\x1c.istio.security.v1beta1.RuleR\x05rules\x12J\n" +
	"\x06action\x18\x03 \x01(\x0e22.istio.security.v1beta1.AuthorizationPolicy.ActionR\x06action\x12[\n" +
	"\bprovider\x18\x04 \x01(\v2=.istio.security.v1beta1.AuthorizationPolicy.ExtensionProviderH\x00R\bprovider\x1a'\n" +
	"\x11ExtensionProvider\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\"4\n" +
	"\x06Action\x12\t\n" +
	"\x05ALLOW\x10\x00\x12\b\n" +
	"\x04DENY\x10\x01\x12\t\n" +
	"\x05AUDIT\x10\x02\x12\n" +
	"\n" +
	"\x06CUSTOM\x10\x03B\x0f\n" +
	"\raction_detail\"\xac\x02\n" +
	"\x04Rule\x125\n" +
	"\x04from\x18\x01 \x03(\v2!.istio.security.v1beta1.Rule.FromR\x04from\x12/\n" +
	"\x02to\x18\x02 \x03(\v2\x1f.istio.security.v1beta1.Rule.ToR\x02to\x125\n" +
	"\x04when\x18\x03 \x03(\v2!.istio.security.v1beta1.ConditionR\x04when\x1a>\n" +
	"\x04From\x126\n" +
	"\x06source\x18\x01 \x01(\v2\x1e.istio.security.v1beta1.SourceR\x06source\x1aE\n" +
	"\x02To\x12?\n" +
	"\toperation\x18\x01 \x01(\v2!.istio.security.v1beta1.OperationR\toperation\"\xf4\x03\n" +
	"\x06Source\x12\x1e\n" +
	"\n" +
	"principals\x18\x01 \x03(\tR\n" +
	"principals\x12%\n" +
	"\x0enot_principals\x18\x05 \x03(\tR\rnotPrincipals\x12-\n" +
	"\x12request_principals\x18\x02 \x03(\tR\x11requestPrincipals\x124\n" +
	"\x16not_request_principals\x18\x06 \x03(\tR\x14notRequestPrincipals\x12\x1e\n" +
	"\n" +
	"namespaces\x18\x03 \x03(\tR\n" +
	"namespaces\x12%\n" +
	"\x0enot_namespaces\x18\a \x03(\tR\rnotNamespaces\x12)\n" +
	"\x10service_accounts\x18\v \x03(\tR\x0fserviceAccounts\x120\n" +
	"\x14not_service_accounts\x18\f \x03(\tR\x12notServiceAccounts\x12\x1b\n" +
	"\tip_blocks\x18\x04 \x03(\tR\bipBlocks\x12\"\n" +
	"\rnot_ip_blocks\x18\b \x03(\tR\vnotIpBlocks\x12(\n" +
	"\x10remote_ip_blocks\x18\t \x03(\tR\x0eremoteIpBlocks\x12/\n" +
	"\x14not_remote_ip_blocks\x18\n" +
	" \x03(\tR\x11notRemoteIpBlocks\"\xdf\x01\n" +
	"\tOperation\x12\x14\n" +
	"\x05hosts\x18\x01 \x03(\tR\x05hosts\x12\x1b\n" +
	"\tnot_hosts\x18\x05 \x03(\tR\bnotHosts\x12\x14\n" +
	"\x05ports\x18\x02 \x03(\tR\x05ports\x12\x1b\n" +
	"\tnot_ports\x18\x06 \x03(\tR\bnotPorts\x12\x18\n" +
	"\amethods\x18\x03 \x03(\tR\amethods\x12\x1f\n" +
	"\vnot_methods\x18\a \x03(\tR\n" +
	"notMethods\x12\x14\n" +
	"\x05paths\x18\x04 \x03(\tR\x05paths\x12\x1b\n" +
	"\tnot_paths\x18\b \x03(\tR\bnotPaths\"Z\n" +
	"\tCondition\x12\x16\n" +
	"\x03key\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x03key\x12\x16\n" +
	"\x06values\x18\x02 \x03(\tR\x06values\x12\x1d\n" +
	"\n" +
	"not_values\x18\x03 \x03(\tR\tnotValuesB\x1fZ\x1distio.io/api/security/v1beta1b\x06proto3"

var (
	file_security_v1beta1_authorization_policy_proto_rawDescOnce sync.Once
	file_security_v1beta1_authorization_policy_proto_rawDescData []byte
)

func file_security_v1beta1_authorization_policy_proto_rawDescGZIP() []byte {
	file_security_v1beta1_authorization_policy_proto_rawDescOnce.Do(func() {
		file_security_v1beta1_authorization_policy_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_security_v1beta1_authorization_policy_proto_rawDesc), len(file_security_v1beta1_authorization_policy_proto_rawDesc)))
	})
	return file_security_v1beta1_authorization_policy_proto_rawDescData
}

var file_security_v1beta1_authorization_policy_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_security_v1beta1_authorization_policy_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_security_v1beta1_authorization_policy_proto_goTypes = []any{
	(AuthorizationPolicy_Action)(0),               // 0: istio.security.v1beta1.AuthorizationPolicy.Action
	(*AuthorizationPolicy)(nil),                   // 1: istio.security.v1beta1.AuthorizationPolicy
	(*Rule)(nil),                                  // 2: istio.security.v1beta1.Rule
	(*Source)(nil),                                // 3: istio.security.v1beta1.Source
	(*Operation)(nil),                             // 4: istio.security.v1beta1.Operation
	(*Condition)(nil),                             // 5: istio.security.v1beta1.Condition
	(*AuthorizationPolicy_ExtensionProvider)(nil), // 6: istio.security.v1beta1.AuthorizationPolicy.ExtensionProvider
	(*Rule_From)(nil),                             // 7: istio.security.v1beta1.Rule.From
	(*Rule_To)(nil),                               // 8: istio.security.v1beta1.Rule.To
	(*v1beta1.WorkloadSelector)(nil),              // 9: istio.type.v1beta1.WorkloadSelector
	(*v1beta1.PolicyTargetReference)(nil),         // 10: istio.type.v1beta1.PolicyTargetReference
}
var file_security_v1beta1_authorization_policy_proto_depIdxs = []int32{
	9,  // 0: istio.security.v1beta1.AuthorizationPolicy.selector:type_name -> istio.type.v1beta1.WorkloadSelector
	10, // 1: istio.security.v1beta1.AuthorizationPolicy.targetRef:type_name -> istio.type.v1beta1.PolicyTargetReference
	10, // 2: istio.security.v1beta1.AuthorizationPolicy.targetRefs:type_name -> istio.type.v1beta1.PolicyTargetReference
	2,  // 3: istio.security.v1beta1.AuthorizationPolicy.rules:type_name -> istio.security.v1beta1.Rule
	0,  // 4: istio.security.v1beta1.AuthorizationPolicy.action:type_name -> istio.security.v1beta1.AuthorizationPolicy.Action
	6,  // 5: istio.security.v1beta1.AuthorizationPolicy.provider:type_name -> istio.security.v1beta1.AuthorizationPolicy.ExtensionProvider
	7,  // 6: istio.security.v1beta1.Rule.from:type_name -> istio.security.v1beta1.Rule.From
	8,  // 7: istio.security.v1beta1.Rule.to:type_name -> istio.security.v1beta1.Rule.To
	5,  // 8: istio.security.v1beta1.Rule.when:type_name -> istio.security.v1beta1.Condition
	3,  // 9: istio.security.v1beta1.Rule.From.source:type_name -> istio.security.v1beta1.Source
	4,  // 10: istio.security.v1beta1.Rule.To.operation:type_name -> istio.security.v1beta1.Operation
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_security_v1beta1_authorization_policy_proto_init() }
func file_security_v1beta1_authorization_policy_proto_init() {
	if File_security_v1beta1_authorization_policy_proto != nil {
		return
	}
	file_security_v1beta1_authorization_policy_proto_msgTypes[0].OneofWrappers = []any{
		(*AuthorizationPolicy_Provider)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_security_v1beta1_authorization_policy_proto_rawDesc), len(file_security_v1beta1_authorization_policy_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_security_v1beta1_authorization_policy_proto_goTypes,
		DependencyIndexes: file_security_v1beta1_authorization_policy_proto_depIdxs,
		EnumInfos:         file_security_v1beta1_authorization_policy_proto_enumTypes,
		MessageInfos:      file_security_v1beta1_authorization_policy_proto_msgTypes,
	}.Build()
	File_security_v1beta1_authorization_policy_proto = out.File
	file_security_v1beta1_authorization_policy_proto_goTypes = nil
	file_security_v1beta1_authorization_policy_proto_depIdxs = nil
}
