
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kxmlguibuilder_wrapper.h"

// Wrappers providing overrides
#include "kxmlguibuilder_wrapper.h"

// Argument includes
#include <QStringList>
#include <kxmlguiclient.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KXMLGUIBuilder_Type = nullptr;
static PyTypeObject *Sbk_KXMLGUIBuilder_TypeF(void)
{
    return _Sbk_KXMLGUIBuilder_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KXMLGUIBuilderWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KXMLGUIBuilderWrapper::KXMLGUIBuilderWrapper(::QWidget * widget) : KXMLGUIBuilder(widget)
{
}

::QStringList KXMLGUIBuilderWrapper::containerTags() const
{
    static const char *funcName = "containerTags";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIBuilder_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIBuilder::containerTags();
    }
    return sbk_o_containerTags("KXMLGUIBuilder", funcName, gil, pyOverride);
}

::QStringList KXMLGUIBuilderWrapper::sbk_o_containerTags(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QStringList();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QStringList KXMLGUIBuilderWrapper::customTags() const
{
    static const char *funcName = "customTags";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIBuilder_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIBuilder::customTags();
    }
    return KXMLGUIBuilderWrapper::sbk_o_containerTags("KXMLGUIBuilder", funcName, gil, pyOverride);
}

void KXMLGUIBuilderWrapper::finalizeGUI(::KXMLGUIClient * client)
{
    static const char *funcName = "finalizeGUI";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIBuilder_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIBuilder::finalizeGUI(client);
    }
    sbk_o_finalizeGUI("KXMLGUIBuilder", funcName, gil, pyOverride, client);
}

void KXMLGUIBuilderWrapper::sbk_o_finalizeGUI(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KXMLGUIClient * client)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), client)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), client)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

KXMLGUIBuilderWrapper::~KXMLGUIBuilderWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KXMLGUIBuilder_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KXMLGUIBuilder_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KXMLGUIBuilder >()))
        return -1;

    KXMLGUIBuilderWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KXMLGUIBuilder", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KXMLGUIBuilder::KXMLGUIBuilder(QWidget*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KXMLGUIBuilder(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KXMLGUIBuilder(QWidget*)
            cptr = new KXMLGUIBuilderWrapper(cppArg0);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KXMLGUIBuilder >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KXMLGUIBuilderFunc_builderClient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIBuilder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // builderClient()const
        KXMLGUIClient * cppResult = const_cast<const ::KXMLGUIBuilder *>(cppSelf)->builderClient();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIBuilderFunc_containerTags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIBuilder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // containerTags()const
        QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KXMLGUIBuilder *>(cppSelf)->::KXMLGUIBuilder::containerTags()
            : const_cast<const ::KXMLGUIBuilder *>(cppSelf)->containerTags();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIBuilderFunc_customTags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIBuilder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // customTags()const
        QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KXMLGUIBuilder *>(cppSelf)->::KXMLGUIBuilder::customTags()
            : const_cast<const ::KXMLGUIBuilder *>(cppSelf)->customTags();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIBuilderFunc_finalizeGUI(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIBuilder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIBuilder::finalizeGUI(KXMLGUIClient*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArg)))) {
        overloadId = 0; // finalizeGUI(KXMLGUIClient*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "finalizeGUI", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KXMLGUIClient *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // finalizeGUI(KXMLGUIClient*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KXMLGUIBuilder::finalizeGUI(cppArg0)
                : cppSelf->finalizeGUI(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIBuilderFunc_setBuilderClient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIBuilder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIBuilder::setBuilderClient(KXMLGUIClient*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArg)))) {
        overloadId = 0; // setBuilderClient(KXMLGUIClient*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBuilderClient", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KXMLGUIClient *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBuilderClient(KXMLGUIClient*)
            cppSelf->setBuilderClient(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIBuilderFunc_widget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIBuilder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // widget()
        QWidget * cppResult = cppSelf->widget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KXMLGUIBuilder_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KXMLGUIBuilder_methods[] = {
    {"builderClient", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIBuilderFunc_builderClient), METH_NOARGS, nullptr},
    {"containerTags", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIBuilderFunc_containerTags), METH_NOARGS, nullptr},
    {"customTags", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIBuilderFunc_customTags), METH_NOARGS, nullptr},
    {"finalizeGUI", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIBuilderFunc_finalizeGUI), METH_O, nullptr},
    {"setBuilderClient", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIBuilderFunc_setBuilderClient), METH_O, nullptr},
    {"widget", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIBuilderFunc_widget), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KXMLGUIBuilder_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KXMLGUIBuilder *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KXMLGUIBuilderWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KXMLGUIBuilder_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KXMLGUIBuilder_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KXMLGUIBuilder_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KXMLGUIBuilder_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KXMLGUIBuilder_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KXMLGUIBuilder_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KXMLGUIBuilder_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KXMLGUIBuilder_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KXMLGUIBuilder_spec = {
    "1:KXmlGui.KXMLGUIBuilder",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KXMLGUIBuilder_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KXMLGUIBuilder_PythonToCpp_KXMLGUIBuilder_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KXMLGUIBuilder_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KXMLGUIBuilder_PythonToCpp_KXMLGUIBuilder_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KXMLGUIBuilder_TypeF()))
        return KXMLGUIBuilder_PythonToCpp_KXMLGUIBuilder_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KXMLGUIBuilder_PTR_CppToPython_KXMLGUIBuilder(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KXMLGUIBuilder_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::KXMLGUIBuilder *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_KXMLGUIBuilder_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KXMLGUIBuilder_SignatureStrings[] = {
    "KXmlGui.KXMLGUIBuilder(self,widget:PySide6.QtWidgets.QWidget)",
    "KXmlGui.KXMLGUIBuilder.builderClient(self)->KXmlGui.KXMLGUIClient",
    "KXmlGui.KXMLGUIBuilder.containerTags(self)->QStringList",
    "KXmlGui.KXMLGUIBuilder.customTags(self)->QStringList",
    "KXmlGui.KXMLGUIBuilder.finalizeGUI(self,client:KXmlGui.KXMLGUIClient)",
    "KXmlGui.KXMLGUIBuilder.setBuilderClient(self,client:KXmlGui.KXMLGUIClient)",
    "KXmlGui.KXMLGUIBuilder.widget(self)->PySide6.QtWidgets.QWidget",
    nullptr}; // Sentinel
#else
static constexpr size_t KXMLGUIBuilder_SignatureByteSize = 160;
static constexpr uint8_t KXMLGUIBuilder_SignatureBytes[160] = {
    0x78, 0xda, 0xf3, 0x8e, 0xc8, 0xcd, 0x71, 0x2f, 0xcd, 0xd4, 0xf3, 0x8e, 0xf0, 0xf5, 0x71, 0x0f,
    0xf5, 0x74, 0x2a, 0xcd, 0xcc, 0x49, 0x49, 0x2d, 0xd2, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29, 0xcf,
    0x4c, 0x49, 0x4f, 0x2d, 0xb1, 0x0a, 0xa8, 0x0c, 0xce, 0x4c, 0x49, 0x35, 0xd3, 0x0b, 0x2c, 0x09,
    0x07, 0x0b, 0x14, 0xeb, 0x05, 0x42, 0x18, 0x9a, 0x5c, 0xde, 0x58, 0x75, 0xeb, 0x25, 0x41, 0x68,
    0xe7, 0x9c, 0xcc, 0xd4, 0xbc, 0x12, 0xb0, 0x59, 0x9a, 0xba, 0x76, 0x68, 0x6a, 0x21, 0x92, 0xb8,
    0x4c, 0x48, 0xce, 0xcf, 0x2b, 0x49, 0xcc, 0xcc, 0x4b, 0x2d, 0x0a, 0x49, 0x4c, 0x2f, 0x86, 0x99,
    0x10, 0x18, 0x5c, 0x52, 0x94, 0x99, 0x97, 0xee, 0x93, 0x59, 0x8c, 0x5b, 0x5f, 0x69, 0x71, 0x49,
    0x7e, 0x2e, 0x89, 0x9a, 0xd2, 0x32, 0xf3, 0x12, 0x73, 0x32, 0xab, 0x52, 0x81, 0x42, 0x10, 0x8f,
    0x27, 0x83, 0xdd, 0x66, 0x85, 0xd5, 0xc5, 0x38, 0x3d, 0x5d, 0x9c, 0x5a, 0xe2, 0x84, 0xe1, 0x6f,
    0xf2, 0x8c, 0x82, 0x04, 0x3c, 0xcc, 0x07, 0x38, 0xc3, 0x9f, 0x0b, 0x00, 0xa8, 0x3a, 0x9c, 0x9f
};
#endif

PyTypeObject *init_KXMLGUIBuilder(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX].type;

    Shiboken::AutoDecRef Sbk_KXMLGUIBuilder_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KXMLGUIBuilder_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KXMLGUIBuilder",
        "KXMLGUIBuilder*",
        &Sbk_KXMLGUIBuilder_spec,
        &Shiboken::callCppDestructor< KXMLGUIBuilder >,
        Sbk_KXMLGUIBuilder_Type_bases.object(),
        0);
    auto *pyType = Sbk_KXMLGUIBuilder_TypeF(); // references _Sbk_KXMLGUIBuilder_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KXMLGUIBuilder_SignatureStrings);
#else
    InitSignatureBytes(pyType, KXMLGUIBuilder_SignatureBytes, KXMLGUIBuilder_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KXMLGUIBuilder_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KXMLGUIBuilder_PythonToCpp_KXMLGUIBuilder_PTR,
        is_KXMLGUIBuilder_PythonToCpp_KXMLGUIBuilder_PTR_Convertible,
        KXMLGUIBuilder_PTR_CppToPython_KXMLGUIBuilder);

    Shiboken::Conversions::registerConverterName(converter, "KXMLGUIBuilder");
    Shiboken::Conversions::registerConverterName(converter, "KXMLGUIBuilder*");
    Shiboken::Conversions::registerConverterName(converter, "KXMLGUIBuilder&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KXMLGUIBuilder).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KXMLGUIBuilderWrapper).name());

    qRegisterMetaType< ::KXMLGUIBuilder *>();

    return pyType;
}
