/* FocusManager.c generated by valac 0.56.18, the Vala compiler
 * generated from FocusManager.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <glib-object.h>
#include <meta/display.h>
#include <meta/workspace.h>
#include <meta/window.h>
#include <glib.h>
#include <meta/meta-workspace-manager.h>
#include <meta/common.h>
#include <graphene-gobject.h>
#include <float.h>
#include <math.h>
#include <mtk/mtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_FOCUS_MANAGER (greeter_compositor_focus_manager_get_type ())
#define GREETER_COMPOSITOR_FOCUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_FOCUS_MANAGER, GreeterCompositorFocusManager))
#define GREETER_COMPOSITOR_FOCUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_FOCUS_MANAGER, GreeterCompositorFocusManagerClass))
#define GREETER_COMPOSITOR_IS_FOCUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_FOCUS_MANAGER))
#define GREETER_COMPOSITOR_IS_FOCUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_FOCUS_MANAGER))
#define GREETER_COMPOSITOR_FOCUS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_FOCUS_MANAGER, GreeterCompositorFocusManagerClass))

typedef struct _GreeterCompositorFocusManager GreeterCompositorFocusManager;
typedef struct _GreeterCompositorFocusManagerClass GreeterCompositorFocusManagerClass;
typedef struct _GreeterCompositorFocusManagerPrivate GreeterCompositorFocusManagerPrivate;
enum  {
	GREETER_COMPOSITOR_FOCUS_MANAGER_0_PROPERTY,
	GREETER_COMPOSITOR_FOCUS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_focus_manager_properties[GREETER_COMPOSITOR_FOCUS_MANAGER_NUM_PROPERTIES];
typedef struct _Block21Data Block21Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GreeterCompositorFocusManager {
	GObject parent_instance;
	GreeterCompositorFocusManagerPrivate * priv;
};

struct _GreeterCompositorFocusManagerClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorFocusManagerPrivate {
	MetaDisplay* display;
	MetaWorkspace* current_workspace;
	MetaWindow* last_focused_window;
	MetaWindow* last_focused_dialog_window;
};

struct _Block21Data {
	int _ref_count_;
	GreeterCompositorFocusManager* self;
	MetaWindow* window;
	gint x;
	gint y;
};

static gint GreeterCompositorFocusManager_private_offset;
static gpointer greeter_compositor_focus_manager_parent_class = NULL;

VALA_EXTERN GType greeter_compositor_focus_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorFocusManager, g_object_unref)
VALA_EXTERN GreeterCompositorFocusManager* greeter_compositor_focus_manager_new (MetaDisplay* _display);
VALA_EXTERN GreeterCompositorFocusManager* greeter_compositor_focus_manager_construct (GType object_type,
                                                                           MetaDisplay* _display);
static void __lambda45_ (GreeterCompositorFocusManager* self);
static void greeter_compositor_focus_manager_update_current_workspace (GreeterCompositorFocusManager* self);
static void ___lambda45__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                             gint object,
                                                             gint p0,
                                                             MetaMotionDirection p1,
                                                             gpointer self);
VALA_EXTERN void greeter_compositor_focus_manager_remember_focused_window (GreeterCompositorFocusManager* self);
static void greeter_compositor_focus_manager_window_created (GreeterCompositorFocusManager* self,
                                                      MetaWindow* window);
static void _greeter_compositor_focus_manager_window_created_meta_display_window_created (MetaDisplay* _sender,
                                                                                   MetaWindow* object,
                                                                                   gpointer self);
VALA_EXTERN void greeter_compositor_focus_manager_restore_focused_window (GreeterCompositorFocusManager* self);
static void ___lambda46_ (GreeterCompositorFocusManager* self);
static void ____lambda46__meta_window_unmanaged (MetaWindow* _sender,
                                          gpointer self);
static void greeter_compositor_focus_manager_window_focused (GreeterCompositorFocusManager* self,
                                                      MetaWindow* window);
static void _greeter_compositor_focus_manager_window_focused_meta_window_focus (MetaWindow* _sender,
                                                                         gpointer self);
static void greeter_compositor_focus_manager_window_unmanaged (GreeterCompositorFocusManager* self,
                                                        MetaWindow* window);
static void _greeter_compositor_focus_manager_window_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                                               gpointer self);
VALA_EXTERN gboolean greeter_compositor_focus_manager_begin_grab_focused_window (GreeterCompositorFocusManager* self,
                                                                     gint x,
                                                                     gint y,
                                                                     gint button,
                                                                     guint time,
                                                                     guint state);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gboolean greeter_compositor_focus_manager_get_can_grab_window (MetaWindow* window,
                                                               gint x,
                                                               gint y);
static void ___lambda47_ (Block21Data* _data21_,
                   MetaWindow* win);
static void ____lambda47__gfunc (gconstpointer data,
                          gpointer self);
static void greeter_compositor_focus_manager_finalize (GObject * obj);
static GType greeter_compositor_focus_manager_get_type_once (void);

static inline gpointer
greeter_compositor_focus_manager_get_instance_private (GreeterCompositorFocusManager* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorFocusManager_private_offset);
}

static void
__lambda45_ (GreeterCompositorFocusManager* self)
{
	greeter_compositor_focus_manager_update_current_workspace (self);
}

static void
___lambda45__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                        gint object,
                                                        gint p0,
                                                        MetaMotionDirection p1,
                                                        gpointer self)
{
	__lambda45_ ((GreeterCompositorFocusManager*) self);
}

GreeterCompositorFocusManager*
greeter_compositor_focus_manager_construct (GType object_type,
                                            MetaDisplay* _display)
{
	GreeterCompositorFocusManager * self = NULL;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	g_return_val_if_fail (_display != NULL, NULL);
	self = (GreeterCompositorFocusManager*) g_object_new (object_type, NULL);
	self->priv->display = _display;
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	g_signal_connect_object (manager, "workspace-switched", (GCallback) ___lambda45__meta_workspace_manager_workspace_switched, self, 0);
	greeter_compositor_focus_manager_update_current_workspace (self);
	return self;
}

GreeterCompositorFocusManager*
greeter_compositor_focus_manager_new (MetaDisplay* _display)
{
	return greeter_compositor_focus_manager_construct (GREETER_COMPOSITOR_TYPE_FOCUS_MANAGER, _display);
}

static void
_greeter_compositor_focus_manager_window_created_meta_display_window_created (MetaDisplay* _sender,
                                                                              MetaWindow* object,
                                                                              gpointer self)
{
	greeter_compositor_focus_manager_window_created ((GreeterCompositorFocusManager*) self, object);
}

void
greeter_compositor_focus_manager_remember_focused_window (GreeterCompositorFocusManager* self)
{
	GList* windows = NULL;
	MetaWorkspace* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	MetaDisplay* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_workspace;
	_tmp1_ = meta_workspace_list_windows (_tmp0_);
	windows = _tmp1_;
	_tmp2_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp3_;
				MetaWindow* _tmp4_;
				_tmp3_ = window;
				greeter_compositor_focus_manager_window_created (self, _tmp3_);
				_tmp4_ = window;
				if (meta_window_has_focus (_tmp4_)) {
					MetaWindow* _tmp5_;
					_tmp5_ = window;
					self->priv->last_focused_window = _tmp5_;
				}
			}
		}
	}
	_tmp6_ = self->priv->display;
	g_signal_connect_object (_tmp6_, "window-created", (GCallback) _greeter_compositor_focus_manager_window_created_meta_display_window_created, self, 0);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
}

static void
___lambda46_ (GreeterCompositorFocusManager* self)
{
	self->priv->last_focused_dialog_window = NULL;
	greeter_compositor_focus_manager_restore_focused_window (self);
}

static void
____lambda46__meta_window_unmanaged (MetaWindow* _sender,
                                     gpointer self)
{
	___lambda46_ ((GreeterCompositorFocusManager*) self);
}

static void
_greeter_compositor_focus_manager_window_focused_meta_window_focus (MetaWindow* _sender,
                                                                    gpointer self)
{
	greeter_compositor_focus_manager_window_focused ((GreeterCompositorFocusManager*) self, _sender);
}

static void
_greeter_compositor_focus_manager_window_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                                          gpointer self)
{
	greeter_compositor_focus_manager_window_unmanaged ((GreeterCompositorFocusManager*) self, _sender);
}

void
greeter_compositor_focus_manager_restore_focused_window (GreeterCompositorFocusManager* self)
{
	MetaWindow* _tmp0_;
	GList* windows = NULL;
	MetaWorkspace* _tmp7_;
	GList* _tmp8_;
	GList* _tmp9_;
	MetaDisplay* _tmp14_;
	guint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->last_focused_dialog_window;
	if (_tmp0_ != NULL) {
		MetaWindow* _tmp1_;
		MetaDisplay* _tmp2_;
		MetaWindow* _tmp3_;
		_tmp1_ = self->priv->last_focused_dialog_window;
		_tmp2_ = self->priv->display;
		meta_window_focus (_tmp1_, meta_display_get_current_time (_tmp2_));
		_tmp3_ = self->priv->last_focused_dialog_window;
		g_signal_connect_object (_tmp3_, "unmanaged", (GCallback) ____lambda46__meta_window_unmanaged, self, 0);
	} else {
		MetaWindow* _tmp4_;
		_tmp4_ = self->priv->last_focused_window;
		if (_tmp4_ != NULL) {
			MetaWindow* _tmp5_;
			MetaDisplay* _tmp6_;
			_tmp5_ = self->priv->last_focused_window;
			_tmp6_ = self->priv->display;
			meta_window_focus (_tmp5_, meta_display_get_current_time (_tmp6_));
		}
	}
	_tmp7_ = self->priv->current_workspace;
	_tmp8_ = meta_workspace_list_windows (_tmp7_);
	windows = _tmp8_;
	_tmp9_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp9_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp10_;
				guint _tmp11_;
				MetaWindow* _tmp12_;
				guint _tmp13_;
				_tmp10_ = window;
				g_signal_parse_name ("focus", meta_window_get_type (), &_tmp11_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _greeter_compositor_focus_manager_window_focused_meta_window_focus, self);
				_tmp12_ = window;
				g_signal_parse_name ("unmanaged", meta_window_get_type (), &_tmp13_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _greeter_compositor_focus_manager_window_unmanaged_meta_window_unmanaged, self);
			}
		}
	}
	_tmp14_ = self->priv->display;
	g_signal_parse_name ("window-created", meta_display_get_type (), &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _greeter_compositor_focus_manager_window_created_meta_display_window_created, self);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
}

static void
greeter_compositor_focus_manager_window_created (GreeterCompositorFocusManager* self,
                                                 MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_signal_connect_object (window, "focus", (GCallback) _greeter_compositor_focus_manager_window_focused_meta_window_focus, self, 0);
	g_signal_connect_object (window, "unmanaged", (GCallback) _greeter_compositor_focus_manager_window_unmanaged_meta_window_unmanaged, self, 0);
}

static void
greeter_compositor_focus_manager_window_focused (GreeterCompositorFocusManager* self,
                                                 MetaWindow* window)
{
	MetaWindowType _tmp0_;
	MetaWindowType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = meta_window_get_window_type (window);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == META_WINDOW_DIALOG) {
		self->priv->last_focused_dialog_window = window;
	} else {
		MetaWindowType _tmp2_;
		MetaWindowType _tmp3_;
		_tmp2_ = meta_window_get_window_type (window);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != META_WINDOW_DOCK) {
			self->priv->last_focused_window = window;
		}
	}
}

static void
greeter_compositor_focus_manager_window_unmanaged (GreeterCompositorFocusManager* self,
                                                   MetaWindow* window)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_signal_parse_name ("focus", meta_window_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _greeter_compositor_focus_manager_window_focused_meta_window_focus, self);
	g_signal_parse_name ("unmanaged", meta_window_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _greeter_compositor_focus_manager_window_unmanaged_meta_window_unmanaged, self);
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		GreeterCompositorFocusManager* self;
		self = _data21_->self;
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static void
___lambda47_ (Block21Data* _data21_,
              MetaWindow* win)
{
	GreeterCompositorFocusManager* self;
	MetaWindow* _tmp0_;
	self = _data21_->self;
	g_return_if_fail (win != NULL);
	_tmp0_ = _data21_->window;
	if (_tmp0_ != NULL) {
		return;
	}
	if (greeter_compositor_focus_manager_get_can_grab_window (win, _data21_->x, _data21_->y)) {
		_data21_->window = win;
	}
}

static void
____lambda47__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda47_ (self, (MetaWindow*) data);
}

gboolean
greeter_compositor_focus_manager_begin_grab_focused_window (GreeterCompositorFocusManager* self,
                                                            gint x,
                                                            gint y,
                                                            gint button,
                                                            guint time,
                                                            guint state)
{
	Block21Data* _data21_;
	MetaDisplay* _tmp0_;
	MetaWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_data21_->x = x;
	_data21_->y = y;
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_focus_window (_tmp0_);
	_data21_->window = _tmp1_;
	_tmp3_ = _data21_->window;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		MetaWindow* _tmp4_;
		_tmp4_ = _data21_->window;
		_tmp2_ = !greeter_compositor_focus_manager_get_can_grab_window (_tmp4_, _data21_->x, _data21_->y);
	}
	if (_tmp2_) {
		MetaWorkspace* workspace = NULL;
		MetaDisplay* _tmp5_;
		MetaWorkspaceManager* _tmp6_;
		MetaWorkspace* _tmp7_;
		GList* windows = NULL;
		MetaWorkspace* _tmp8_;
		GList* _tmp9_;
		GList* _tmp10_;
		GList* copy = NULL;
		GList* _tmp11_;
		GList* _tmp12_;
		GList* _tmp13_;
		_tmp5_ = self->priv->display;
		_tmp6_ = meta_display_get_workspace_manager (_tmp5_);
		_tmp7_ = meta_workspace_manager_get_active_workspace (_tmp6_);
		workspace = _tmp7_;
		_tmp8_ = workspace;
		_tmp9_ = meta_workspace_list_windows (_tmp8_);
		windows = _tmp9_;
		_tmp10_ = windows;
		if (_tmp10_ == NULL) {
			result = FALSE;
			(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
			block21_data_unref (_data21_);
			_data21_ = NULL;
			return result;
		}
		_data21_->window = NULL;
		_tmp11_ = windows;
		_tmp12_ = g_list_copy (_tmp11_);
		copy = _tmp12_;
		copy = g_list_reverse (copy);
		_tmp13_ = copy;
		g_list_foreach (_tmp13_, ____lambda47__gfunc, _data21_);
		(copy == NULL) ? NULL : (copy = (g_list_free (copy), NULL));
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	}
	_tmp14_ = _data21_->window;
	if (_tmp14_ != NULL) {
		graphene_point_t pos_hint = {0};
		graphene_point_t _tmp15_ = {0};
		MetaWindow* _tmp16_;
		graphene_point_t _tmp17_;
		_tmp15_.x = (gfloat) _data21_->x;
		_tmp15_.y = (gfloat) _data21_->y;
		pos_hint = _tmp15_;
		_tmp16_ = _data21_->window;
		_tmp17_ = pos_hint;
		meta_window_begin_grab_op (_tmp16_, META_GRAB_OP_MOVING, NULL, NULL, (guint32) time, &_tmp17_);
		result = TRUE;
		block21_data_unref (_data21_);
		_data21_ = NULL;
		return result;
	}
	result = FALSE;
	block21_data_unref (_data21_);
	_data21_ = NULL;
	return result;
}

static gboolean
greeter_compositor_focus_manager_get_can_grab_window (MetaWindow* window,
                                                      gint x,
                                                      gint y)
{
	MtkRectangle frame = {0};
	MtkRectangle _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (window != NULL, FALSE);
	meta_window_get_frame_rect (window, &_tmp0_);
	frame = _tmp0_;
	g_object_get (window, "minimized", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		g_object_get (window, "maximized-vertically", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		MtkRectangle _tmp8_;
		_tmp8_ = frame;
		_tmp2_ = x >= _tmp8_.x;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		MtkRectangle _tmp9_;
		MtkRectangle _tmp10_;
		_tmp9_ = frame;
		_tmp10_ = frame;
		_tmp1_ = x <= (_tmp9_.x + _tmp10_.width);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

static void
greeter_compositor_focus_manager_update_current_workspace (GreeterCompositorFocusManager* self)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspace* _tmp5_;
	MetaWorkspace* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = manager;
	_tmp3_ = manager;
	_tmp4_ = meta_workspace_manager_get_workspace_by_index (_tmp2_, meta_workspace_manager_get_active_workspace_index (_tmp3_));
	workspace = _tmp4_;
	_tmp5_ = workspace;
	if (_tmp5_ == NULL) {
		g_warning ("FocusManager.vala:124: Cannot get active workspace");
		return;
	}
	_tmp6_ = workspace;
	self->priv->current_workspace = _tmp6_;
}

static void
greeter_compositor_focus_manager_class_init (GreeterCompositorFocusManagerClass * klass,
                                             gpointer klass_data)
{
	greeter_compositor_focus_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorFocusManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_focus_manager_finalize;
}

static void
greeter_compositor_focus_manager_instance_init (GreeterCompositorFocusManager * self,
                                                gpointer klass)
{
	self->priv = greeter_compositor_focus_manager_get_instance_private (self);
	self->priv->current_workspace = NULL;
	self->priv->last_focused_window = NULL;
	self->priv->last_focused_dialog_window = NULL;
}

static void
greeter_compositor_focus_manager_finalize (GObject * obj)
{
	GreeterCompositorFocusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_FOCUS_MANAGER, GreeterCompositorFocusManager);
	G_OBJECT_CLASS (greeter_compositor_focus_manager_parent_class)->finalize (obj);
}

static GType
greeter_compositor_focus_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorFocusManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_focus_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorFocusManager), 0, (GInstanceInitFunc) greeter_compositor_focus_manager_instance_init, NULL };
	GType greeter_compositor_focus_manager_type_id;
	greeter_compositor_focus_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorFocusManager", &g_define_type_info, 0);
	GreeterCompositorFocusManager_private_offset = g_type_add_instance_private (greeter_compositor_focus_manager_type_id, sizeof (GreeterCompositorFocusManagerPrivate));
	return greeter_compositor_focus_manager_type_id;
}

GType
greeter_compositor_focus_manager_get_type (void)
{
	static volatile gsize greeter_compositor_focus_manager_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_focus_manager_type_id__once)) {
		GType greeter_compositor_focus_manager_type_id;
		greeter_compositor_focus_manager_type_id = greeter_compositor_focus_manager_get_type_once ();
		g_once_init_leave (&greeter_compositor_focus_manager_type_id__once, greeter_compositor_focus_manager_type_id);
	}
	return greeter_compositor_focus_manager_type_id__once;
}

