/* ManagedClient.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ManagedClient.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <meta/display.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <meta/meta-wayland-client.h>
#include <gio/gio.h>
#include <meta/meta-context.h>
#include <meta/window.h>
#include <meta/util.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT (greeter_compositor_managed_client_get_type ())
#define GREETER_COMPOSITOR_MANAGED_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClient))
#define GREETER_COMPOSITOR_MANAGED_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClientClass))
#define GREETER_COMPOSITOR_IS_MANAGED_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT))
#define GREETER_COMPOSITOR_IS_MANAGED_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT))
#define GREETER_COMPOSITOR_MANAGED_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClientClass))

typedef struct _GreeterCompositorManagedClient GreeterCompositorManagedClient;
typedef struct _GreeterCompositorManagedClientClass GreeterCompositorManagedClientClass;
typedef struct _GreeterCompositorManagedClientPrivate GreeterCompositorManagedClientPrivate;
enum  {
	GREETER_COMPOSITOR_MANAGED_CLIENT_0_PROPERTY,
	GREETER_COMPOSITOR_MANAGED_CLIENT_DISPLAY_PROPERTY,
	GREETER_COMPOSITOR_MANAGED_CLIENT_ARGS_PROPERTY,
	GREETER_COMPOSITOR_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY,
	GREETER_COMPOSITOR_MANAGED_CLIENT_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_managed_client_properties[GREETER_COMPOSITOR_MANAGED_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GreeterCompositorManagedClientStartWaylandData GreeterCompositorManagedClientStartWaylandData;
typedef struct _GreeterCompositorManagedClientStartXData GreeterCompositorManagedClientStartXData;
typedef struct _Block15Data Block15Data;
enum  {
	GREETER_COMPOSITOR_MANAGED_CLIENT_WINDOW_CREATED_SIGNAL,
	GREETER_COMPOSITOR_MANAGED_CLIENT_NUM_SIGNALS
};
static guint greeter_compositor_managed_client_signals[GREETER_COMPOSITOR_MANAGED_CLIENT_NUM_SIGNALS] = {0};

struct _GreeterCompositorManagedClient {
	GObject parent_instance;
	GreeterCompositorManagedClientPrivate * priv;
};

struct _GreeterCompositorManagedClientClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorManagedClientPrivate {
	MetaDisplay* _display;
	gchar** _args;
	gint _args_length1;
	gint __args_size_;
	MetaWaylandClient* _wayland_client;
	GSubprocess* subprocess;
};

struct _GreeterCompositorManagedClientStartWaylandData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterCompositorManagedClient* self;
	GSubprocessLauncher* subprocess_launcher;
	GSubprocessLauncher* _tmp0_;
	MetaWaylandClient* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaContext* _tmp3_;
	GSubprocessLauncher* _tmp4_;
	MetaWaylandClient* _tmp5_;
	GSubprocess* _tmp6_;
	MetaWaylandClient* _tmp7_;
	MetaDisplay* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GSubprocess* _tmp12_;
	GSubprocess* _tmp13_;
	GSubprocess* _tmp14_;
	GError* e;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _GreeterCompositorManagedClientStartXData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterCompositorManagedClient* self;
	GSubprocess* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSubprocess* _tmp4_;
	GSubprocess* _tmp5_;
	GSubprocess* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_;
};

struct _Block15Data {
	int _ref_count_;
	GreeterCompositorManagedClient* self;
	MetaWindow* window;
};

static gint GreeterCompositorManagedClient_private_offset;
static gpointer greeter_compositor_managed_client_parent_class = NULL;

VALA_EXTERN GType greeter_compositor_managed_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorManagedClient, g_object_unref)
VALA_EXTERN GreeterCompositorManagedClient* greeter_compositor_managed_client_new (MetaDisplay* display,
                                                                       gchar** args,
                                                                       gint args_length1);
VALA_EXTERN GreeterCompositorManagedClient* greeter_compositor_managed_client_construct (GType object_type,
                                                                             MetaDisplay* display,
                                                                             gchar** args,
                                                                             gint args_length1);
static void greeter_compositor_managed_client_start_wayland_data_free (gpointer _data);
static void greeter_compositor_managed_client_start_wayland (GreeterCompositorManagedClient* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void greeter_compositor_managed_client_start_wayland_finish (GreeterCompositorManagedClient* self,
                                                             GAsyncResult* _res_);
static gboolean greeter_compositor_managed_client_start_wayland_co (GreeterCompositorManagedClientStartWaylandData* _data_);
VALA_EXTERN MetaDisplay* greeter_compositor_managed_client_get_display (GreeterCompositorManagedClient* self);
static void greeter_compositor_managed_client_set_wayland_client (GreeterCompositorManagedClient* self,
                                                           MetaWaylandClient* value);
VALA_EXTERN MetaWaylandClient* greeter_compositor_managed_client_get_wayland_client (GreeterCompositorManagedClient* self);
VALA_EXTERN gchar** greeter_compositor_managed_client_get_args (GreeterCompositorManagedClient* self,
                                                    gint* result_length1);
static void greeter_compositor_managed_client_start_wayland_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static gboolean ___lambda81_ (GreeterCompositorManagedClient* self);
static gboolean ____lambda81__gsource_func (gpointer self);
static void greeter_compositor_managed_client_start_x_data_free (gpointer _data);
static void greeter_compositor_managed_client_start_x (GreeterCompositorManagedClient* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void greeter_compositor_managed_client_start_x_finish (GreeterCompositorManagedClient* self,
                                                       GAsyncResult* _res_);
static gboolean greeter_compositor_managed_client_start_x_co (GreeterCompositorManagedClientStartXData* _data_);
static void greeter_compositor_managed_client_start_x_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static gboolean ___lambda82_ (GreeterCompositorManagedClient* self);
static gboolean ____lambda82__gsource_func (gpointer self);
static void greeter_compositor_managed_client_set_display (GreeterCompositorManagedClient* self,
                                                    MetaDisplay* value);
static void greeter_compositor_managed_client_set_args (GreeterCompositorManagedClient* self,
                                                 gchar** value,
                                                 gint value_length1);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static GObject * greeter_compositor_managed_client_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void _greeter_compositor_managed_client____lambda83_ (GreeterCompositorManagedClient* self,
                                                      MetaWindow* window);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void ___lambda84_ (Block15Data* _data15_);
static void ____lambda84__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __greeter_compositor_managed_client____lambda83__meta_display_window_created (MetaDisplay* _sender,
                                                                                   MetaWindow* object,
                                                                                   gpointer self);
static void greeter_compositor_managed_client_finalize (GObject * obj);
static GType greeter_compositor_managed_client_get_type_once (void);
static void _vala_greeter_compositor_managed_client_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_greeter_compositor_managed_client_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
greeter_compositor_managed_client_get_instance_private (GreeterCompositorManagedClient* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorManagedClient_private_offset);
}

GreeterCompositorManagedClient*
greeter_compositor_managed_client_construct (GType object_type,
                                             MetaDisplay* display,
                                             gchar** args,
                                             gint args_length1)
{
	GreeterCompositorManagedClient * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GreeterCompositorManagedClient*) g_object_new (object_type, "display", display, "args", args, NULL);
	return self;
}

GreeterCompositorManagedClient*
greeter_compositor_managed_client_new (MetaDisplay* display,
                                       gchar** args,
                                       gint args_length1)
{
	return greeter_compositor_managed_client_construct (GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, display, args, args_length1);
}

static void
greeter_compositor_managed_client_start_wayland_data_free (gpointer _data)
{
	GreeterCompositorManagedClientStartWaylandData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GreeterCompositorManagedClientStartWaylandData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_compositor_managed_client_start_wayland (GreeterCompositorManagedClient* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	GreeterCompositorManagedClientStartWaylandData* _data_;
	GreeterCompositorManagedClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GreeterCompositorManagedClientStartWaylandData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_compositor_managed_client_start_wayland_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	greeter_compositor_managed_client_start_wayland_co (_data_);
}

static void
greeter_compositor_managed_client_start_wayland_finish (GreeterCompositorManagedClient* self,
                                                        GAsyncResult* _res_)
{
	GreeterCompositorManagedClientStartWaylandData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
greeter_compositor_managed_client_start_wayland_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	GreeterCompositorManagedClientStartWaylandData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	greeter_compositor_managed_client_start_wayland_co (_data_);
}

static gboolean
___lambda81_ (GreeterCompositorManagedClient* self)
{
	gboolean result;
	greeter_compositor_managed_client_start_wayland (self, NULL, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda81__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda81_ ((GreeterCompositorManagedClient*) self);
	return result;
}

static gboolean
greeter_compositor_managed_client_start_wayland_co (GreeterCompositorManagedClientStartWaylandData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_INHERIT_FDS);
	_data_->subprocess_launcher = _data_->_tmp0_;
	{
		_data_->_tmp2_ = _data_->self->priv->_display;
		_data_->_tmp3_ = meta_display_get_context (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->subprocess_launcher;
		_data_->_tmp5_ = meta_wayland_client_new (_data_->_tmp3_, _data_->_tmp4_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		greeter_compositor_managed_client_set_wayland_client (_data_->self, _data_->_tmp1_);
		_data_->_tmp7_ = _data_->self->priv->_wayland_client;
		_data_->_tmp8_ = _data_->self->priv->_display;
		_data_->_tmp10_ = 0;
		_data_->_tmp9_ = greeter_compositor_managed_client_get_args (_data_->self, &_data_->_tmp10_);
		_data_->_tmp9__length1 = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->_tmp9_;
		_data_->_tmp11__length1 = _data_->_tmp9__length1;
		_data_->_tmp12_ = meta_wayland_client_spawnv (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp11_, &_data_->_inner_error0_);
		_data_->_tmp6_ = _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp1_);
			goto __catch0_g_error;
		}
		_data_->_tmp13_ = _data_->_tmp6_;
		_data_->_tmp6_ = NULL;
		_g_object_unref0 (_data_->self->priv->subprocess);
		_data_->self->priv->subprocess = _data_->_tmp13_;
		_data_->_tmp14_ = _data_->self->priv->subprocess;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp14_, NULL, greeter_compositor_managed_client_start_wayland_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp6_);
			_g_object_unref0 (_data_->_tmp1_);
			goto __catch0_g_error;
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda81__gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_object_unref0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp15_ = _data_->e;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_warning ("ManagedClient.vala:64: Failed to create dock client: %s", _data_->_tmp16_);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->subprocess_launcher);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->subprocess_launcher);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->subprocess_launcher);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
greeter_compositor_managed_client_start_x_data_free (gpointer _data)
{
	GreeterCompositorManagedClientStartXData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GreeterCompositorManagedClientStartXData, _data_);
}

static void
greeter_compositor_managed_client_start_x (GreeterCompositorManagedClient* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GreeterCompositorManagedClientStartXData* _data_;
	GreeterCompositorManagedClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GreeterCompositorManagedClientStartXData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_compositor_managed_client_start_x_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	greeter_compositor_managed_client_start_x_co (_data_);
}

static void
greeter_compositor_managed_client_start_x_finish (GreeterCompositorManagedClient* self,
                                                  GAsyncResult* _res_)
{
	GreeterCompositorManagedClientStartXData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
greeter_compositor_managed_client_start_x_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	GreeterCompositorManagedClientStartXData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	greeter_compositor_managed_client_start_x_co (_data_);
}

static gboolean
___lambda82_ (GreeterCompositorManagedClient* self)
{
	gboolean result;
	greeter_compositor_managed_client_start_x (self, NULL, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda82__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda82_ ((GreeterCompositorManagedClient*) self);
	return result;
}

static gboolean
greeter_compositor_managed_client_start_x_co (GreeterCompositorManagedClientStartXData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp2_ = 0;
		_data_->_tmp1_ = greeter_compositor_managed_client_get_args (_data_->self, &_data_->_tmp2_);
		_data_->_tmp1__length1 = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_tmp1_;
		_data_->_tmp3__length1 = _data_->_tmp1__length1;
		_data_->_tmp4_ = g_subprocess_newv (_data_->_tmp3_, G_SUBPROCESS_FLAGS_NONE, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->subprocess);
		_data_->self->priv->subprocess = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->self->priv->subprocess;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp6_, NULL, greeter_compositor_managed_client_start_x_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda82__gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->e;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_warning ("ManagedClient.vala:80: Failed to create daemon subprocess with x: %s", _data_->_tmp8_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

MetaDisplay*
greeter_compositor_managed_client_get_display (GreeterCompositorManagedClient* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_managed_client_set_display (GreeterCompositorManagedClient* self,
                                               MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_managed_client_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_managed_client_properties[GREETER_COMPOSITOR_MANAGED_CLIENT_DISPLAY_PROPERTY]);
	}
}

gchar**
greeter_compositor_managed_client_get_args (GreeterCompositorManagedClient* self,
                                            gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_args;
	_tmp0__length1 = self->priv->_args_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
greeter_compositor_managed_client_set_args (GreeterCompositorManagedClient* self,
                                            gchar** value,
                                            gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_managed_client_get_args (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup3 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_args = (_vala_array_free (self->priv->_args, self->priv->_args_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_args = _tmp0_;
		self->priv->_args_length1 = _tmp0__length1;
		self->priv->__args_size_ = self->priv->_args_length1;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_managed_client_properties[GREETER_COMPOSITOR_MANAGED_CLIENT_ARGS_PROPERTY]);
	}
}

MetaWaylandClient*
greeter_compositor_managed_client_get_wayland_client (GreeterCompositorManagedClient* self)
{
	MetaWaylandClient* result;
	MetaWaylandClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wayland_client;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_managed_client_set_wayland_client (GreeterCompositorManagedClient* self,
                                                      MetaWaylandClient* value)
{
	MetaWaylandClient* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_managed_client_get_wayland_client (self);
	if (old_value != value) {
		MetaWaylandClient* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wayland_client);
		self->priv->_wayland_client = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_managed_client_properties[GREETER_COMPOSITOR_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY]);
	}
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		GreeterCompositorManagedClient* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->window);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
___lambda84_ (Block15Data* _data15_)
{
	GreeterCompositorManagedClient* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data15_->self;
	g_object_get (_data15_->window, "is-alive", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GSubprocess* _tmp3_;
		_tmp3_ = self->priv->subprocess;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSubprocess* _tmp4_;
		_tmp4_ = self->priv->subprocess;
		g_subprocess_force_exit (_tmp4_);
		g_warning ("ManagedClient.vala:40: WaylandClient window became unresponsive, killi" \
"ng the client.");
	}
}

static void
____lambda84__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda84_ (self);
}

static void
_greeter_compositor_managed_client____lambda83_ (GreeterCompositorManagedClient* self,
                                                 MetaWindow* window)
{
	Block15Data* _data15_;
	MetaWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MetaWaylandClient* _tmp2_;
	g_return_if_fail (window != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data15_->window);
	_data15_->window = _tmp0_;
	_tmp2_ = self->priv->_wayland_client;
	if (_tmp2_ != NULL) {
		MetaWaylandClient* _tmp3_;
		_tmp3_ = self->priv->_wayland_client;
		_tmp1_ = meta_wayland_client_owns_window (_tmp3_, _data15_->window);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		g_signal_emit (self, greeter_compositor_managed_client_signals[GREETER_COMPOSITOR_MANAGED_CLIENT_WINDOW_CREATED_SIGNAL], 0, _data15_->window);
		g_signal_connect_data ((GObject*) _data15_->window, "notify::is-alive", (GCallback) ____lambda84__g_object_notify, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	}
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

static void
__greeter_compositor_managed_client____lambda83__meta_display_window_created (MetaDisplay* _sender,
                                                                              MetaWindow* object,
                                                                              gpointer self)
{
	_greeter_compositor_managed_client____lambda83_ ((GreeterCompositorManagedClient*) self, object);
}

static GObject *
greeter_compositor_managed_client_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorManagedClient * self;
	parent_class = G_OBJECT_CLASS (greeter_compositor_managed_client_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClient);
	if (meta_is_wayland_compositor ()) {
		MetaDisplay* _tmp0_;
		greeter_compositor_managed_client_start_wayland (self, NULL, NULL);
		_tmp0_ = self->priv->_display;
		g_signal_connect_object (_tmp0_, "window-created", (GCallback) __greeter_compositor_managed_client____lambda83__meta_display_window_created, self, 0);
	} else {
		greeter_compositor_managed_client_start_x (self, NULL, NULL);
	}
	return obj;
}

static void
greeter_compositor_managed_client_class_init (GreeterCompositorManagedClientClass * klass,
                                              gpointer klass_data)
{
	greeter_compositor_managed_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorManagedClient_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_managed_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_managed_client_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_managed_client_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_managed_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_MANAGED_CLIENT_DISPLAY_PROPERTY, greeter_compositor_managed_client_properties[GREETER_COMPOSITOR_MANAGED_CLIENT_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_MANAGED_CLIENT_ARGS_PROPERTY, greeter_compositor_managed_client_properties[GREETER_COMPOSITOR_MANAGED_CLIENT_ARGS_PROPERTY] = g_param_spec_boxed ("args", "args", "args", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY, greeter_compositor_managed_client_properties[GREETER_COMPOSITOR_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY] = g_param_spec_object ("wayland-client", "wayland-client", "wayland-client", meta_wayland_client_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	greeter_compositor_managed_client_signals[GREETER_COMPOSITOR_MANAGED_CLIENT_WINDOW_CREATED_SIGNAL] = g_signal_new ("window-created", GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
}

static void
greeter_compositor_managed_client_instance_init (GreeterCompositorManagedClient * self,
                                                 gpointer klass)
{
	self->priv = greeter_compositor_managed_client_get_instance_private (self);
}

static void
greeter_compositor_managed_client_finalize (GObject * obj)
{
	GreeterCompositorManagedClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClient);
	_g_object_unref0 (self->priv->_display);
	self->priv->_args = (_vala_array_free (self->priv->_args, self->priv->_args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_wayland_client);
	_g_object_unref0 (self->priv->subprocess);
	G_OBJECT_CLASS (greeter_compositor_managed_client_parent_class)->finalize (obj);
}

/**
 * Utility class that takes care of launching and restarting a subprocess.
 * On wayland this uses a WaylandClient and emits window_created if a window for the client was created.
 * On X this just launches a normal subprocess and never emits window_created.
 */
static GType
greeter_compositor_managed_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorManagedClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_managed_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorManagedClient), 0, (GInstanceInitFunc) greeter_compositor_managed_client_instance_init, NULL };
	GType greeter_compositor_managed_client_type_id;
	greeter_compositor_managed_client_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorManagedClient", &g_define_type_info, 0);
	GreeterCompositorManagedClient_private_offset = g_type_add_instance_private (greeter_compositor_managed_client_type_id, sizeof (GreeterCompositorManagedClientPrivate));
	return greeter_compositor_managed_client_type_id;
}

GType
greeter_compositor_managed_client_get_type (void)
{
	static volatile gsize greeter_compositor_managed_client_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_managed_client_type_id__once)) {
		GType greeter_compositor_managed_client_type_id;
		greeter_compositor_managed_client_type_id = greeter_compositor_managed_client_get_type_once ();
		g_once_init_leave (&greeter_compositor_managed_client_type_id__once, greeter_compositor_managed_client_type_id);
	}
	return greeter_compositor_managed_client_type_id__once;
}

static void
_vala_greeter_compositor_managed_client_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	GreeterCompositorManagedClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClient);
	switch (property_id) {
		case GREETER_COMPOSITOR_MANAGED_CLIENT_DISPLAY_PROPERTY:
		g_value_set_object (value, greeter_compositor_managed_client_get_display (self));
		break;
		case GREETER_COMPOSITOR_MANAGED_CLIENT_ARGS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, greeter_compositor_managed_client_get_args (self, &length));
		}
		break;
		case GREETER_COMPOSITOR_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY:
		g_value_set_object (value, greeter_compositor_managed_client_get_wayland_client (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_managed_client_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	GreeterCompositorManagedClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClient);
	switch (property_id) {
		case GREETER_COMPOSITOR_MANAGED_CLIENT_DISPLAY_PROPERTY:
		greeter_compositor_managed_client_set_display (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_MANAGED_CLIENT_ARGS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			greeter_compositor_managed_client_set_args (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case GREETER_COMPOSITOR_MANAGED_CLIENT_WAYLAND_CLIENT_PROPERTY:
		greeter_compositor_managed_client_set_wayland_client (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

