/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the X86 target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 142;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(X86InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(X86InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static X86InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static X86InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s8,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s80,
  GILLT_s128,
  GILLT_v2s1,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v32s1,
  GILLT_v32s8,
  GILLT_v32s16,
  GILLT_v64s1,
  GILLT_v64s8,
};
const static size_t NumTypeObjects = 25;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(8),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(80),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(32), 1),
  LLT::vector(ElementCount::getFixed(32), 8),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(64), 1),
  LLT::vector(ElementCount::getFixed(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_TruePredicateBit = 60,
  Feature_HasEGPRBit = 5,
  Feature_NoEGPRBit = 4,
  Feature_HasNDDBit = 6,
  Feature_NoNDDBit = 26,
  Feature_HasCFBit = 29,
  Feature_HasCMOVBit = 28,
  Feature_NoCMOVBit = 128,
  Feature_HasMMXBit = 104,
  Feature_HasSSE1Bit = 46,
  Feature_UseSSE1Bit = 53,
  Feature_HasSSE2Bit = 45,
  Feature_UseSSE2Bit = 54,
  Feature_HasSSE3Bit = 37,
  Feature_UseSSE3Bit = 63,
  Feature_HasSSSE3Bit = 105,
  Feature_UseSSSE3Bit = 64,
  Feature_UseSSE41Bit = 61,
  Feature_UseSSE42Bit = 67,
  Feature_HasSSE4ABit = 77,
  Feature_NoAVXBit = 73,
  Feature_HasAVXBit = 55,
  Feature_HasAVX2Bit = 49,
  Feature_HasAVX1OnlyBit = 47,
  Feature_HasEVEX512Bit = 135,
  Feature_HasAVX512Bit = 90,
  Feature_UseAVXBit = 51,
  Feature_NoAVX512Bit = 42,
  Feature_HasCDIBit = 94,
  Feature_HasVPOPCNTDQBit = 98,
  Feature_HasDQIBit = 92,
  Feature_NoDQIBit = 65,
  Feature_HasBWIBit = 93,
  Feature_NoBWIBit = 62,
  Feature_HasVLXBit = 91,
  Feature_NoVLXBit = 41,
  Feature_NoVLX_Or_NoBWIBit = 59,
  Feature_HasVNNIBit = 100,
  Feature_HasVP2INTERSECTBit = 102,
  Feature_HasBF16Bit = 103,
  Feature_HasFP16Bit = 96,
  Feature_HasAVXVNNIINT16Bit = 89,
  Feature_HasAVXVNNIINT8Bit = 84,
  Feature_HasAVXVNNIBit = 78,
  Feature_NoVLX_Or_NoVNNIBit = 79,
  Feature_HasBITALGBit = 101,
  Feature_HasPOPCNTBit = 66,
  Feature_HasAESBit = 70,
  Feature_HasVAESBit = 72,
  Feature_NoVLX_Or_NoVAESBit = 71,
  Feature_HasFXSRBit = 38,
  Feature_HasX87Bit = 36,
  Feature_HasXSAVEBit = 117,
  Feature_HasXSAVEOPTBit = 118,
  Feature_HasXSAVECBit = 119,
  Feature_HasXSAVESBit = 120,
  Feature_HasPCLMULBit = 74,
  Feature_NoVLX_Or_NoVPCLMULQDQBit = 75,
  Feature_HasVPCLMULQDQBit = 76,
  Feature_HasGFNIBit = 81,
  Feature_HasFMABit = 39,
  Feature_HasFMA4Bit = 43,
  Feature_NoFMA4Bit = 40,
  Feature_HasXOPBit = 44,
  Feature_HasTBMBit = 25,
  Feature_NoTBMBit = 133,
  Feature_HasLWPBit = 12,
  Feature_HasMOVBEBit = 3,
  Feature_NoNDD_Or_NoMOVBEBit = 2,
  Feature_HasRDRANDBit = 7,
  Feature_HasF16CBit = 80,
  Feature_HasFSGSBaseBit = 121,
  Feature_HasLZCNTBit = 9,
  Feature_HasBMIBit = 10,
  Feature_HasBMI2Bit = 11,
  Feature_NoBMI2Bit = 132,
  Feature_HasVBMIBit = 95,
  Feature_HasVBMI2Bit = 99,
  Feature_HasIFMABit = 97,
  Feature_HasAVXIFMABit = 82,
  Feature_NoVLX_Or_NoIFMABit = 83,
  Feature_HasRTMBit = 107,
  Feature_HasSHABit = 69,
  Feature_HasSHA512Bit = 86,
  Feature_HasSM3Bit = 87,
  Feature_HasRDSEEDBit = 8,
  Feature_HasSSEPrefetchBit = 56,
  Feature_HasPREFETCHIBit = 20,
  Feature_HasPrefetchWBit = 106,
  Feature_HasMWAITXBit = 131,
  Feature_HasCLDEMOTEBit = 24,
  Feature_HasMOVDIRIBit = 14,
  Feature_HasMOVDIR64BBit = 15,
  Feature_HasPTWRITEBit = 124,
  Feature_FPStackf32Bit = 34,
  Feature_FPStackf64Bit = 35,
  Feature_HasSM4Bit = 88,
  Feature_HasCLFLUSHBit = 57,
  Feature_HasCLFLUSHOPTBit = 22,
  Feature_HasCLWBBit = 23,
  Feature_HasWBNOINVDBit = 116,
  Feature_HasRDPIDBit = 123,
  Feature_HasWAITPKGBit = 13,
  Feature_HasINVPCIDBit = 122,
  Feature_HasCX8Bit = 129,
  Feature_HasCX16Bit = 130,
  Feature_HasENQCMDBit = 16,
  Feature_HasAMXFP16Bit = 112,
  Feature_HasCMPCCXADDBit = 21,
  Feature_HasAVXNECONVERTBit = 85,
  Feature_HasKLBit = 108,
  Feature_HasRAOINTBit = 114,
  Feature_HasSERIALIZEBit = 17,
  Feature_HasTSXLDTRKBit = 18,
  Feature_HasAMXTILEBit = 109,
  Feature_HasAMXBF16Bit = 111,
  Feature_HasAMXINT8Bit = 110,
  Feature_HasAMXCOMPLEXBit = 113,
  Feature_HasUINTRBit = 19,
  Feature_HasUSERMSRBit = 115,
  Feature_HasCRC32Bit = 68,
  Feature_Not64BitModeBit = 0,
  Feature_In64BitModeBit = 1,
  Feature_IsLP64Bit = 126,
  Feature_NotLP64Bit = 125,
  Feature_NotWin64WithoutFPBit = 127,
  Feature_IsPSBit = 137,
  Feature_NotPSBit = 136,
  Feature_KernelCodeBit = 138,
  Feature_NearDataBit = 140,
  Feature_IsNotPICBit = 139,
  Feature_OptForSizeBit = 50,
  Feature_OptForMinSizeBit = 48,
  Feature_OptForSpeedBit = 134,
  Feature_UseIncDecBit = 27,
  Feature_NoSSE41_Or_OptForSizeBit = 52,
  Feature_CallImmAddrBit = 141,
  Feature_FavorMemIndirectCallBit = 30,
  Feature_HasFastSHLDRotateBit = 33,
  Feature_HasMFenceBit = 58,
  Feature_UseIndirectThunkCallsBit = 32,
  Feature_NotUseIndirectThunkCallsBit = 31,
};

PredicateBitset X86InstructionSelector::
computeAvailableModuleFeatures(const X86Subtarget *Subtarget) const {
  PredicateBitset Features{};
  if (true)
    Features.set(Feature_TruePredicateBit);
  if (Subtarget->hasEGPR())
    Features.set(Feature_HasEGPRBit);
  if (!Subtarget->hasEGPR())
    Features.set(Feature_NoEGPRBit);
  if (Subtarget->hasNDD())
    Features.set(Feature_HasNDDBit);
  if (!Subtarget->hasNDD())
    Features.set(Feature_NoNDDBit);
  if (Subtarget->hasCF())
    Features.set(Feature_HasCFBit);
  if (Subtarget->canUseCMOV())
    Features.set(Feature_HasCMOVBit);
  if (!Subtarget->canUseCMOV())
    Features.set(Feature_NoCMOVBit);
  if (Subtarget->hasMMX())
    Features.set(Feature_HasMMXBit);
  if (Subtarget->hasSSE1())
    Features.set(Feature_HasSSE1Bit);
  if (Subtarget->hasSSE1() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE1Bit);
  if (Subtarget->hasSSE2())
    Features.set(Feature_HasSSE2Bit);
  if (Subtarget->hasSSE2() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE2Bit);
  if (Subtarget->hasSSE3())
    Features.set(Feature_HasSSE3Bit);
  if (Subtarget->hasSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE3Bit);
  if (Subtarget->hasSSSE3())
    Features.set(Feature_HasSSSE3Bit);
  if (Subtarget->hasSSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSSE3Bit);
  if (Subtarget->hasSSE41() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE41Bit);
  if (Subtarget->hasSSE42() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE42Bit);
  if (Subtarget->hasSSE4A())
    Features.set(Feature_HasSSE4ABit);
  if (!Subtarget->hasAVX())
    Features.set(Feature_NoAVXBit);
  if (Subtarget->hasAVX())
    Features.set(Feature_HasAVXBit);
  if (Subtarget->hasAVX2())
    Features.set(Feature_HasAVX2Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX2())
    Features.set(Feature_HasAVX1OnlyBit);
  if (Subtarget->hasEVEX512())
    Features.set(Feature_HasEVEX512Bit);
  if (Subtarget->hasAVX512())
    Features.set(Feature_HasAVX512Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX512())
    Features.set(Feature_UseAVXBit);
  if (!Subtarget->hasAVX512())
    Features.set(Feature_NoAVX512Bit);
  if (Subtarget->hasCDI())
    Features.set(Feature_HasCDIBit);
  if (Subtarget->hasVPOPCNTDQ())
    Features.set(Feature_HasVPOPCNTDQBit);
  if (Subtarget->hasDQI())
    Features.set(Feature_HasDQIBit);
  if (!Subtarget->hasDQI())
    Features.set(Feature_NoDQIBit);
  if (Subtarget->hasBWI())
    Features.set(Feature_HasBWIBit);
  if (!Subtarget->hasBWI())
    Features.set(Feature_NoBWIBit);
  if (Subtarget->hasVLX())
    Features.set(Feature_HasVLXBit);
  if (!Subtarget->hasVLX())
    Features.set(Feature_NoVLXBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasBWI())
    Features.set(Feature_NoVLX_Or_NoBWIBit);
  if (Subtarget->hasVNNI())
    Features.set(Feature_HasVNNIBit);
  if (Subtarget->hasVP2INTERSECT())
    Features.set(Feature_HasVP2INTERSECTBit);
  if (Subtarget->hasBF16())
    Features.set(Feature_HasBF16Bit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasAVXVNNIINT16())
    Features.set(Feature_HasAVXVNNIINT16Bit);
  if (Subtarget->hasAVXVNNIINT8())
    Features.set(Feature_HasAVXVNNIINT8Bit);
  if (Subtarget->hasAVXVNNI())
    Features.set(Feature_HasAVXVNNIBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVNNI())
    Features.set(Feature_NoVLX_Or_NoVNNIBit);
  if (Subtarget->hasBITALG())
    Features.set(Feature_HasBITALGBit);
  if (Subtarget->hasPOPCNT())
    Features.set(Feature_HasPOPCNTBit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasVAES())
    Features.set(Feature_HasVAESBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVAES())
    Features.set(Feature_NoVLX_Or_NoVAESBit);
  if (Subtarget->hasFXSR())
    Features.set(Feature_HasFXSRBit);
  if (Subtarget->hasX87())
    Features.set(Feature_HasX87Bit);
  if (Subtarget->hasXSAVE())
    Features.set(Feature_HasXSAVEBit);
  if (Subtarget->hasXSAVEOPT())
    Features.set(Feature_HasXSAVEOPTBit);
  if (Subtarget->hasXSAVEC())
    Features.set(Feature_HasXSAVECBit);
  if (Subtarget->hasXSAVES())
    Features.set(Feature_HasXSAVESBit);
  if (Subtarget->hasPCLMUL())
    Features.set(Feature_HasPCLMULBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_NoVLX_Or_NoVPCLMULQDQBit);
  if (Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_HasVPCLMULQDQBit);
  if (Subtarget->hasGFNI())
    Features.set(Feature_HasGFNIBit);
  if (Subtarget->hasFMA())
    Features.set(Feature_HasFMABit);
  if (Subtarget->hasFMA4())
    Features.set(Feature_HasFMA4Bit);
  if (!Subtarget->hasFMA4())
    Features.set(Feature_NoFMA4Bit);
  if (Subtarget->hasXOP())
    Features.set(Feature_HasXOPBit);
  if (Subtarget->hasTBM())
    Features.set(Feature_HasTBMBit);
  if (!Subtarget->hasTBM())
    Features.set(Feature_NoTBMBit);
  if (Subtarget->hasLWP())
    Features.set(Feature_HasLWPBit);
  if (Subtarget->hasMOVBE())
    Features.set(Feature_HasMOVBEBit);
  if (!Subtarget->hasNDD() || !Subtarget->hasMOVBE())
    Features.set(Feature_NoNDD_Or_NoMOVBEBit);
  if (Subtarget->hasRDRAND())
    Features.set(Feature_HasRDRANDBit);
  if (Subtarget->hasF16C())
    Features.set(Feature_HasF16CBit);
  if (Subtarget->hasFSGSBase())
    Features.set(Feature_HasFSGSBaseBit);
  if (Subtarget->hasLZCNT())
    Features.set(Feature_HasLZCNTBit);
  if (Subtarget->hasBMI())
    Features.set(Feature_HasBMIBit);
  if (Subtarget->hasBMI2())
    Features.set(Feature_HasBMI2Bit);
  if (!Subtarget->hasBMI2())
    Features.set(Feature_NoBMI2Bit);
  if (Subtarget->hasVBMI())
    Features.set(Feature_HasVBMIBit);
  if (Subtarget->hasVBMI2())
    Features.set(Feature_HasVBMI2Bit);
  if (Subtarget->hasIFMA())
    Features.set(Feature_HasIFMABit);
  if (Subtarget->hasAVXIFMA())
    Features.set(Feature_HasAVXIFMABit);
  if (!Subtarget->hasVLX() || !Subtarget->hasIFMA())
    Features.set(Feature_NoVLX_Or_NoIFMABit);
  if (Subtarget->hasRTM())
    Features.set(Feature_HasRTMBit);
  if (Subtarget->hasSHA())
    Features.set(Feature_HasSHABit);
  if (Subtarget->hasSHA512())
    Features.set(Feature_HasSHA512Bit);
  if (Subtarget->hasSM3())
    Features.set(Feature_HasSM3Bit);
  if (Subtarget->hasRDSEED())
    Features.set(Feature_HasRDSEEDBit);
  if (Subtarget->hasSSEPrefetch())
    Features.set(Feature_HasSSEPrefetchBit);
  if (Subtarget->hasPREFETCHI())
    Features.set(Feature_HasPREFETCHIBit);
  if (Subtarget->hasPrefetchW())
    Features.set(Feature_HasPrefetchWBit);
  if (Subtarget->hasMWAITX())
    Features.set(Feature_HasMWAITXBit);
  if (Subtarget->hasCLDEMOTE())
    Features.set(Feature_HasCLDEMOTEBit);
  if (Subtarget->hasMOVDIRI())
    Features.set(Feature_HasMOVDIRIBit);
  if (Subtarget->hasMOVDIR64B())
    Features.set(Feature_HasMOVDIR64BBit);
  if (Subtarget->hasPTWRITE())
    Features.set(Feature_HasPTWRITEBit);
  if (!Subtarget->hasSSE1())
    Features.set(Feature_FPStackf32Bit);
  if (!Subtarget->hasSSE2())
    Features.set(Feature_FPStackf64Bit);
  if (Subtarget->hasSM4())
    Features.set(Feature_HasSM4Bit);
  if (Subtarget->hasCLFLUSH())
    Features.set(Feature_HasCLFLUSHBit);
  if (Subtarget->hasCLFLUSHOPT())
    Features.set(Feature_HasCLFLUSHOPTBit);
  if (Subtarget->hasCLWB())
    Features.set(Feature_HasCLWBBit);
  if (Subtarget->hasWBNOINVD())
    Features.set(Feature_HasWBNOINVDBit);
  if (Subtarget->hasRDPID())
    Features.set(Feature_HasRDPIDBit);
  if (Subtarget->hasWAITPKG())
    Features.set(Feature_HasWAITPKGBit);
  if (Subtarget->hasINVPCID())
    Features.set(Feature_HasINVPCIDBit);
  if (Subtarget->hasCX8())
    Features.set(Feature_HasCX8Bit);
  if (Subtarget->hasCX16())
    Features.set(Feature_HasCX16Bit);
  if (Subtarget->hasENQCMD())
    Features.set(Feature_HasENQCMDBit);
  if (Subtarget->hasAMXFP16())
    Features.set(Feature_HasAMXFP16Bit);
  if (Subtarget->hasCMPCCXADD())
    Features.set(Feature_HasCMPCCXADDBit);
  if (Subtarget->hasAVXNECONVERT())
    Features.set(Feature_HasAVXNECONVERTBit);
  if (Subtarget->hasKL())
    Features.set(Feature_HasKLBit);
  if (Subtarget->hasRAOINT())
    Features.set(Feature_HasRAOINTBit);
  if (Subtarget->hasSERIALIZE())
    Features.set(Feature_HasSERIALIZEBit);
  if (Subtarget->hasTSXLDTRK())
    Features.set(Feature_HasTSXLDTRKBit);
  if (Subtarget->hasAMXTILE())
    Features.set(Feature_HasAMXTILEBit);
  if (Subtarget->hasAMXBF16())
    Features.set(Feature_HasAMXBF16Bit);
  if (Subtarget->hasAMXINT8())
    Features.set(Feature_HasAMXINT8Bit);
  if (Subtarget->hasAMXCOMPLEX())
    Features.set(Feature_HasAMXCOMPLEXBit);
  if (Subtarget->hasUINTR())
    Features.set(Feature_HasUINTRBit);
  if (Subtarget->hasUSERMSR())
    Features.set(Feature_HasUSERMSRBit);
  if (Subtarget->hasCRC32())
    Features.set(Feature_HasCRC32Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_Not64BitModeBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->isTarget64BitLP64())
    Features.set(Feature_IsLP64Bit);
  if (!Subtarget->isTarget64BitLP64())
    Features.set(Feature_NotLP64Bit);
  if (Subtarget->isTargetPS())
    Features.set(Feature_IsPSBit);
  if (!Subtarget->isTargetPS())
    Features.set(Feature_NotPSBit);
  if (TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_KernelCodeBit);
  if (TM.getCodeModel() == CodeModel::Small ||TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_NearDataBit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_IsNotPICBit);
  if (Subtarget->isLegalToCallImmediateAddr())
    Features.set(Feature_CallImmAddrBit);
  if (!Subtarget->slowTwoMemOps())
    Features.set(Feature_FavorMemIndirectCallBit);
  if (Subtarget->hasFastSHLDRotate())
    Features.set(Feature_HasFastSHLDRotateBit);
  if (Subtarget->hasMFence())
    Features.set(Feature_HasMFenceBit);
  if (Subtarget->useIndirectThunkCalls())
    Features.set(Feature_UseIndirectThunkCallsBit);
  if (!Subtarget->useIndirectThunkCalls())
    Features.set(Feature_NotUseIndirectThunkCallsBit);
  return Features;
}

void X86InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const X86Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset X86InstructionSelector::
computeAvailableFunctionFeatures(const X86Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (!Subtarget->isTargetWin64() ||Subtarget->getFrameLowering()->hasFP(*MF))
    Features.set(Feature_NotWin64WithoutFPBit);
  if (shouldOptForSize(MF))
    Features.set(Feature_OptForSizeBit);
  if (MF->getFunction().hasMinSize())
    Features.set(Feature_OptForMinSizeBit);
  if (!shouldOptForSize(MF))
    Features.set(Feature_OptForSpeedBit);
  if (!Subtarget->slowIncDec() || shouldOptForSize(MF))
    Features.set(Feature_UseIncDecBit);
  if (shouldOptForSize(MF) || !Subtarget->hasSSE41())
    Features.set(Feature_NoSSE41_Or_OptForSizeBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_FPStackf32,
  GIFBS_FPStackf64,
  GIFBS_HasAVX,
  GIFBS_HasAVX1Only,
  GIFBS_HasAVX2,
  GIFBS_HasAVX512,
  GIFBS_HasAVXNECONVERT,
  GIFBS_HasAVXVNNIINT16,
  GIFBS_HasBITALG,
  GIFBS_HasBWI,
  GIFBS_HasCDI,
  GIFBS_HasDQI,
  GIFBS_HasFP16,
  GIFBS_HasFastSHLDRotate,
  GIFBS_HasKL,
  GIFBS_HasLWP,
  GIFBS_HasMFence,
  GIFBS_HasMMX,
  GIFBS_HasMOVBE,
  GIFBS_HasMWAITX,
  GIFBS_HasNDD,
  GIFBS_HasPTWRITE,
  GIFBS_HasRTM,
  GIFBS_HasSERIALIZE,
  GIFBS_HasSHA,
  GIFBS_HasSHA512,
  GIFBS_HasSM3,
  GIFBS_HasSM4,
  GIFBS_HasSSE1,
  GIFBS_HasSSE2,
  GIFBS_HasSSE3,
  GIFBS_HasSSE4A,
  GIFBS_HasTBM,
  GIFBS_HasTSXLDTRK,
  GIFBS_HasVLX,
  GIFBS_HasVPOPCNTDQ,
  GIFBS_HasWAITPKG,
  GIFBS_HasWBNOINVD,
  GIFBS_HasX87,
  GIFBS_HasXOP,
  GIFBS_In64BitMode,
  GIFBS_IsPS,
  GIFBS_NoDQI,
  GIFBS_NoNDD,
  GIFBS_NoNDD_Or_NoMOVBE,
  GIFBS_Not64BitMode,
  GIFBS_NotPS,
  GIFBS_UseAVX,
  GIFBS_UseSSE1,
  GIFBS_UseSSE2,
  GIFBS_UseSSE41,
  GIFBS_UseSSSE3,
  GIFBS_HasAES_HasAVX,
  GIFBS_HasAES_NoAVX,
  GIFBS_HasAMXBF16_In64BitMode,
  GIFBS_HasAMXCOMPLEX_In64BitMode,
  GIFBS_HasAMXFP16_In64BitMode,
  GIFBS_HasAMXINT8_In64BitMode,
  GIFBS_HasAMXTILE_In64BitMode,
  GIFBS_HasAVX_In64BitMode,
  GIFBS_HasAVX_NoBWI,
  GIFBS_HasAVX_NoVLX,
  GIFBS_HasAVX_NoVLX_Or_NoBWI,
  GIFBS_HasAVX2_NoVLX,
  GIFBS_HasAVX2_NoVLX_Or_NoBWI,
  GIFBS_HasAVX512_HasVAES,
  GIFBS_HasAVX512_HasVLX,
  GIFBS_HasAVX512_HasVPCLMULQDQ,
  GIFBS_HasAVX512_NoBWI,
  GIFBS_HasAVX512_NoDQI,
  GIFBS_HasBF16_HasVLX,
  GIFBS_HasBITALG_HasVLX,
  GIFBS_HasBMI_HasEGPR,
  GIFBS_HasBMI_NoEGPR,
  GIFBS_HasBMI2_HasEGPR,
  GIFBS_HasBMI2_NoEGPR,
  GIFBS_HasBWI_HasVLX,
  GIFBS_HasCDI_HasVLX,
  GIFBS_HasCRC32_NoEGPR,
  GIFBS_HasDQI_HasVLX,
  GIFBS_HasDQI_NoBWI,
  GIFBS_HasFMA4_NoAVX512,
  GIFBS_HasFMA4_NoVLX,
  GIFBS_HasFP16_HasVLX,
  GIFBS_HasFSGSBase_In64BitMode,
  GIFBS_HasNDD_In64BitMode,
  GIFBS_HasNDD_UseIncDec,
  GIFBS_HasPCLMUL_NoAVX,
  GIFBS_HasPTWRITE_In64BitMode,
  GIFBS_HasRDPID_In64BitMode,
  GIFBS_HasRDPID_Not64BitMode,
  GIFBS_HasUINTR_In64BitMode,
  GIFBS_HasUSERMSR_NoEGPR,
  GIFBS_HasVAES_HasVLX,
  GIFBS_HasVAES_NoVLX,
  GIFBS_HasVLX_HasVPCLMULQDQ,
  GIFBS_HasVLX_HasVPOPCNTDQ,
  GIFBS_HasVPCLMULQDQ_NoVLX,
  GIFBS_HasWAITPKG_In64BitMode,
  GIFBS_HasWAITPKG_Not64BitMode,
  GIFBS_In64BitMode_UseSSE2,
  GIFBS_NoNDD_UseIncDec,
  GIFBS_Not64BitMode_OptForSize,
  GIFBS_NotWin64WithoutFP_OptForMinSize,
  GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES,
  GIFBS_HasAVX_HasPCLMUL_NoVLX_Or_NoVPCLMULQDQ,
  GIFBS_HasAVX512_HasEVEX512_NoVLX,
  GIFBS_HasBITALG_HasEVEX512_NoVLX,
  GIFBS_HasBWI_HasEVEX512_NoVLX,
  GIFBS_HasCDI_HasEVEX512_NoVLX,
  GIFBS_HasCRC32_HasEGPR_In64BitMode,
  GIFBS_HasDQI_HasEVEX512_NoVLX,
  GIFBS_HasDQI_HasVLX_NoBWI,
  GIFBS_HasEGPR_HasUSERMSR_In64BitMode,
  GIFBS_HasEVEX512_HasVPOPCNTDQ_NoVLX,
  GIFBS_HasFMA_NoAVX512_NoFMA4,
  GIFBS_HasFMA_NoFMA4_NoVLX,
  GIFBS_HasMOVBE_HasNDD_In64BitMode,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_FPStackf32Bit, },
  {Feature_FPStackf64Bit, },
  {Feature_HasAVXBit, },
  {Feature_HasAVX1OnlyBit, },
  {Feature_HasAVX2Bit, },
  {Feature_HasAVX512Bit, },
  {Feature_HasAVXNECONVERTBit, },
  {Feature_HasAVXVNNIINT16Bit, },
  {Feature_HasBITALGBit, },
  {Feature_HasBWIBit, },
  {Feature_HasCDIBit, },
  {Feature_HasDQIBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFastSHLDRotateBit, },
  {Feature_HasKLBit, },
  {Feature_HasLWPBit, },
  {Feature_HasMFenceBit, },
  {Feature_HasMMXBit, },
  {Feature_HasMOVBEBit, },
  {Feature_HasMWAITXBit, },
  {Feature_HasNDDBit, },
  {Feature_HasPTWRITEBit, },
  {Feature_HasRTMBit, },
  {Feature_HasSERIALIZEBit, },
  {Feature_HasSHABit, },
  {Feature_HasSHA512Bit, },
  {Feature_HasSM3Bit, },
  {Feature_HasSM4Bit, },
  {Feature_HasSSE1Bit, },
  {Feature_HasSSE2Bit, },
  {Feature_HasSSE3Bit, },
  {Feature_HasSSE4ABit, },
  {Feature_HasTBMBit, },
  {Feature_HasTSXLDTRKBit, },
  {Feature_HasVLXBit, },
  {Feature_HasVPOPCNTDQBit, },
  {Feature_HasWAITPKGBit, },
  {Feature_HasWBNOINVDBit, },
  {Feature_HasX87Bit, },
  {Feature_HasXOPBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsPSBit, },
  {Feature_NoDQIBit, },
  {Feature_NoNDDBit, },
  {Feature_NoNDD_Or_NoMOVBEBit, },
  {Feature_Not64BitModeBit, },
  {Feature_NotPSBit, },
  {Feature_UseAVXBit, },
  {Feature_UseSSE1Bit, },
  {Feature_UseSSE2Bit, },
  {Feature_UseSSE41Bit, },
  {Feature_UseSSSE3Bit, },
  {Feature_HasAESBit, Feature_HasAVXBit, },
  {Feature_HasAESBit, Feature_NoAVXBit, },
  {Feature_HasAMXBF16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXCOMPLEXBit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXINT8Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXTILEBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_NoBWIBit, },
  {Feature_HasAVXBit, Feature_NoVLXBit, },
  {Feature_HasAVXBit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX2Bit, Feature_NoVLXBit, },
  {Feature_HasAVX2Bit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_HasVAESBit, },
  {Feature_HasAVX512Bit, Feature_HasVLXBit, },
  {Feature_HasAVX512Bit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasAVX512Bit, Feature_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_NoDQIBit, },
  {Feature_HasBF16Bit, Feature_HasVLXBit, },
  {Feature_HasBITALGBit, Feature_HasVLXBit, },
  {Feature_HasBMIBit, Feature_HasEGPRBit, },
  {Feature_HasBMIBit, Feature_NoEGPRBit, },
  {Feature_HasBMI2Bit, Feature_HasEGPRBit, },
  {Feature_HasBMI2Bit, Feature_NoEGPRBit, },
  {Feature_HasBWIBit, Feature_HasVLXBit, },
  {Feature_HasCDIBit, Feature_HasVLXBit, },
  {Feature_HasCRC32Bit, Feature_NoEGPRBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, },
  {Feature_HasDQIBit, Feature_NoBWIBit, },
  {Feature_HasFMA4Bit, Feature_NoAVX512Bit, },
  {Feature_HasFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasFP16Bit, Feature_HasVLXBit, },
  {Feature_HasFSGSBaseBit, Feature_In64BitModeBit, },
  {Feature_HasNDDBit, Feature_In64BitModeBit, },
  {Feature_HasNDDBit, Feature_UseIncDecBit, },
  {Feature_HasPCLMULBit, Feature_NoAVXBit, },
  {Feature_HasPTWRITEBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_Not64BitModeBit, },
  {Feature_HasUINTRBit, Feature_In64BitModeBit, },
  {Feature_HasUSERMSRBit, Feature_NoEGPRBit, },
  {Feature_HasVAESBit, Feature_HasVLXBit, },
  {Feature_HasVAESBit, Feature_NoVLXBit, },
  {Feature_HasVLXBit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasVLXBit, Feature_HasVPOPCNTDQBit, },
  {Feature_HasVPCLMULQDQBit, Feature_NoVLXBit, },
  {Feature_HasWAITPKGBit, Feature_In64BitModeBit, },
  {Feature_HasWAITPKGBit, Feature_Not64BitModeBit, },
  {Feature_In64BitModeBit, Feature_UseSSE2Bit, },
  {Feature_NoNDDBit, Feature_UseIncDecBit, },
  {Feature_Not64BitModeBit, Feature_OptForSizeBit, },
  {Feature_NotWin64WithoutFPBit, Feature_OptForMinSizeBit, },
  {Feature_HasAESBit, Feature_HasAVXBit, Feature_NoVLX_Or_NoVAESBit, },
  {Feature_HasAVXBit, Feature_HasPCLMULBit, Feature_NoVLX_Or_NoVPCLMULQDQBit, },
  {Feature_HasAVX512Bit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasBITALGBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasBWIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasCDIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasCRC32Bit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasDQIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, Feature_NoBWIBit, },
  {Feature_HasEGPRBit, Feature_HasUSERMSRBit, Feature_In64BitModeBit, },
  {Feature_HasEVEX512Bit, Feature_HasVPOPCNTDQBit, Feature_NoVLXBit, },
  {Feature_HasFMABit, Feature_NoAVX512Bit, Feature_NoFMA4Bit, },
  {Feature_HasFMABit, Feature_NoFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasMOVBEBit, Feature_HasNDDBit, Feature_In64BitModeBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

X86InstructionSelector::ComplexMatcherMemFn
X86InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool X86InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_AndMask64 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BTCBTSMask64,
  GICXXPred_I64_Predicate_BTRMask64,
  GICXXPred_I64_Predicate_i16immSExt8,
  GICXXPred_I64_Predicate_i32immSExt8,
  GICXXPred_I64_Predicate_i64immSExt8,
  GICXXPred_I64_Predicate_i64immSExt32,
  GICXXPred_I64_Predicate_i64immZExt32,
  GICXXPred_I64_Predicate_i64immZExt32SExt8,
  GICXXPred_I64_Predicate_i64timmSExt32,
  GICXXPred_I64_Predicate_immff00_ffff,
};
bool X86InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_AndMask64: {
    
      return isMask_64(Imm) && !isUInt<32>(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTCBTSMask64: {
    
      return !isInt<32>(Imm) && isPowerOf2_64(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTRMask64: {
    
      return !isUInt<32>(Imm) && !isInt<32>(Imm) && isPowerOf2_64(~Imm);
    
  }
  case GICXXPred_I64_Predicate_i16immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32: {
     return isUInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32SExt8: {
    
      return isUInt<32>(Imm) && isInt<8>(static_cast<int32_t>(Imm));
    
  }
  case GICXXPred_I64_Predicate_i64timmSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_immff00_ffff: {
    
      return Imm >= 0xff00 && Imm <= 0xffff;
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_fpimm0 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_fpimm1,
  GICXXPred_APFloat_Predicate_fpimmneg0,
  GICXXPred_APFloat_Predicate_fpimmneg1,
};
bool X86InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_fpimm0: {
    
      return Imm.isExactlyValue(+0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm1: {
    
      return Imm.isExactlyValue(+1.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg0: {
    
      return Imm.isExactlyValue(-0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg1: {
    
      return Imm.isExactlyValue(-1.0);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool X86InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool X86InstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("X86InstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
X86InstructionSelector::CustomRendererFn
X86InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool X86InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool X86InstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("X86InstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *X86InstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(51), GIMT_Encode2(276), /*)*//*default:*//*Label 66*/ GIMT_Encode4(84904),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(910),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(3268),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(4860), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(6097),
    /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(11893),
    /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(16261), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 6*/ GIMT_Encode4(24600), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 7*/ GIMT_Encode4(24767), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 8*/ GIMT_Encode4(26506),
    /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 9*/ GIMT_Encode4(27368), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 10*/ GIMT_Encode4(27762),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 11*/ GIMT_Encode4(34032), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 12*/ GIMT_Encode4(36792),
    /*TargetOpcode::G_TRUNC*//*Label 13*/ GIMT_Encode4(37227),
    /*TargetOpcode::G_CONSTANT*//*Label 14*/ GIMT_Encode4(38231),
    /*TargetOpcode::G_FCONSTANT*//*Label 15*/ GIMT_Encode4(38841), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 16*/ GIMT_Encode4(39294), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 17*/ GIMT_Encode4(40317),
    /*TargetOpcode::G_SHL*//*Label 18*/ GIMT_Encode4(41235),
    /*TargetOpcode::G_LSHR*//*Label 19*/ GIMT_Encode4(42423),
    /*TargetOpcode::G_ASHR*//*Label 20*/ GIMT_Encode4(43403),
    /*TargetOpcode::G_FSHL*//*Label 21*/ GIMT_Encode4(44383),
    /*TargetOpcode::G_FSHR*//*Label 22*/ GIMT_Encode4(44759),
    /*TargetOpcode::G_ROTR*//*Label 23*/ GIMT_Encode4(45135),
    /*TargetOpcode::G_ROTL*//*Label 24*/ GIMT_Encode4(47141),
    /*TargetOpcode::G_ICMP*//*Label 25*/ GIMT_Encode4(49149), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 26*/ GIMT_Encode4(50806), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 27*/ GIMT_Encode4(58706),
    /*TargetOpcode::G_SMULH*//*Label 28*/ GIMT_Encode4(58953),
    /*TargetOpcode::G_UADDSAT*//*Label 29*/ GIMT_Encode4(59200),
    /*TargetOpcode::G_SADDSAT*//*Label 30*/ GIMT_Encode4(59650),
    /*TargetOpcode::G_USUBSAT*//*Label 31*/ GIMT_Encode4(60100),
    /*TargetOpcode::G_SSUBSAT*//*Label 32*/ GIMT_Encode4(60550), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 33*/ GIMT_Encode4(61000),
    /*TargetOpcode::G_FSUB*//*Label 34*/ GIMT_Encode4(62016),
    /*TargetOpcode::G_FMUL*//*Label 35*/ GIMT_Encode4(63032),
    /*TargetOpcode::G_FMA*//*Label 36*/ GIMT_Encode4(64048), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 37*/ GIMT_Encode4(65176), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 38*/ GIMT_Encode4(66192),
    /*TargetOpcode::G_FPEXT*//*Label 39*/ GIMT_Encode4(66315),
    /*TargetOpcode::G_FPTRUNC*//*Label 40*/ GIMT_Encode4(66885),
    /*TargetOpcode::G_FPTOSI*//*Label 41*/ GIMT_Encode4(67212),
    /*TargetOpcode::G_FPTOUI*//*Label 42*/ GIMT_Encode4(67709),
    /*TargetOpcode::G_SITOFP*//*Label 43*/ GIMT_Encode4(67911),
    /*TargetOpcode::G_UITOFP*//*Label 44*/ GIMT_Encode4(69173),
    /*TargetOpcode::G_FABS*//*Label 45*/ GIMT_Encode4(70023), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 46*/ GIMT_Encode4(70146),
    /*TargetOpcode::G_SMAX*//*Label 47*/ GIMT_Encode4(71255),
    /*TargetOpcode::G_UMIN*//*Label 48*/ GIMT_Encode4(72364),
    /*TargetOpcode::G_UMAX*//*Label 49*/ GIMT_Encode4(73473),
    /*TargetOpcode::G_ABS*//*Label 50*/ GIMT_Encode4(74582), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 51*/ GIMT_Encode4(75455), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 52*/ GIMT_Encode4(75471),
    /*TargetOpcode::G_CTLZ*//*Label 53*/ GIMT_Encode4(75585), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 54*/ GIMT_Encode4(76259),
    /*TargetOpcode::G_BSWAP*//*Label 55*/ GIMT_Encode4(77567), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 56*/ GIMT_Encode4(77743), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 57*/ GIMT_Encode4(78695),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 58*/ GIMT_Encode4(79711),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 59*/ GIMT_Encode4(80727),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 60*/ GIMT_Encode4(81743), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 61*/ GIMT_Encode4(82759),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 62*/ GIMT_Encode4(83887), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 63*/ GIMT_Encode4(84839),
    /*TargetOpcode::G_DEBUGTRAP*//*Label 64*/ GIMT_Encode4(84852),
    /*TargetOpcode::G_UBSANTRAP*//*Label 65*/ GIMT_Encode4(84888),
    // Label 0: @910
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 83*/ GIMT_Encode4(3267),
    /*GILLT_s8*//*Label 67*/ GIMT_Encode4(1017),
    /*GILLT_s16*//*Label 68*/ GIMT_Encode4(1250),
    /*GILLT_s32*//*Label 69*/ GIMT_Encode4(1551),
    /*GILLT_s64*//*Label 70*/ GIMT_Encode4(1852), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 71*/ GIMT_Encode4(2243), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 72*/ GIMT_Encode4(2337),
    /*GILLT_v4s64*//*Label 73*/ GIMT_Encode4(2553), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 74*/ GIMT_Encode4(2620),
    /*GILLT_v8s32*//*Label 75*/ GIMT_Encode4(2836),
    /*GILLT_v8s64*//*Label 76*/ GIMT_Encode4(2903), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 77*/ GIMT_Encode4(2937),
    /*GILLT_v16s16*//*Label 78*/ GIMT_Encode4(3031),
    /*GILLT_v16s32*//*Label 79*/ GIMT_Encode4(3098), GIMT_Encode4(0),
    /*GILLT_v32s8*//*Label 80*/ GIMT_Encode4(3132),
    /*GILLT_v32s16*//*Label 81*/ GIMT_Encode4(3199), GIMT_Encode4(0),
    /*GILLT_v64s8*//*Label 82*/ GIMT_Encode4(3233),
    // Label 67: @1017
    GIM_Try, /*On fail goto*//*Label 84*/ GIMT_Encode4(1249),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 85*/ GIMT_Encode4(1060), // Rule ID 21273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21273,
        GIR_EraseRootFromParent_Done,
      // Label 85: @1060
      GIM_Try, /*On fail goto*//*Label 86*/ GIMT_Encode4(1084), // Rule ID 21277 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21277,
        GIR_EraseRootFromParent_Done,
      // Label 86: @1084
      GIM_Try, /*On fail goto*//*Label 87*/ GIMT_Encode4(1108), // Rule ID 21363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21363,
        GIR_EraseRootFromParent_Done,
      // Label 87: @1108
      GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1132), // Rule ID 21367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21367,
        GIR_EraseRootFromParent_Done,
      // Label 88: @1132
      GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1165), // Rule ID 21211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21211,
        GIR_EraseRootFromParent_Done,
      // Label 89: @1165
      GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1198), // Rule ID 21301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21301,
        GIR_EraseRootFromParent_Done,
      // Label 90: @1198
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1223), // Rule ID 21203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21203,
        GIR_Done,
      // Label 91: @1223
      GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1248), // Rule ID 21293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21293,
        GIR_Done,
      // Label 92: @1248
      GIM_Reject,
    // Label 84: @1249
    GIM_Reject,
    // Label 68: @1250
    GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1550),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1303), // Rule ID 21013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21013,
        GIR_EraseRootFromParent_Done,
      // Label 94: @1303
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1337), // Rule ID 21019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21019,
        GIR_EraseRootFromParent_Done,
      // Label 95: @1337
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1361), // Rule ID 21274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21274,
        GIR_EraseRootFromParent_Done,
      // Label 96: @1361
      GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1385), // Rule ID 21278 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21278,
        GIR_EraseRootFromParent_Done,
      // Label 97: @1385
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1409), // Rule ID 21364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21364,
        GIR_EraseRootFromParent_Done,
      // Label 98: @1409
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1433), // Rule ID 21368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21368,
        GIR_EraseRootFromParent_Done,
      // Label 99: @1433
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1466), // Rule ID 21212 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21212,
        GIR_EraseRootFromParent_Done,
      // Label 100: @1466
      GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1499), // Rule ID 21302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21302,
        GIR_EraseRootFromParent_Done,
      // Label 101: @1499
      GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1524), // Rule ID 21204 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21204,
        GIR_Done,
      // Label 102: @1524
      GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1549), // Rule ID 21294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21294,
        GIR_Done,
      // Label 103: @1549
      GIM_Reject,
    // Label 93: @1550
    GIM_Reject,
    // Label 69: @1551
    GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1851),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1604), // Rule ID 21014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21014,
        GIR_EraseRootFromParent_Done,
      // Label 105: @1604
      GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1638), // Rule ID 21020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21020,
        GIR_EraseRootFromParent_Done,
      // Label 106: @1638
      GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1662), // Rule ID 21275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21275,
        GIR_EraseRootFromParent_Done,
      // Label 107: @1662
      GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1686), // Rule ID 21279 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21279,
        GIR_EraseRootFromParent_Done,
      // Label 108: @1686
      GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1710), // Rule ID 21365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21365,
        GIR_EraseRootFromParent_Done,
      // Label 109: @1710
      GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1734), // Rule ID 21369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21369,
        GIR_EraseRootFromParent_Done,
      // Label 110: @1734
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1767), // Rule ID 21213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21213,
        GIR_EraseRootFromParent_Done,
      // Label 111: @1767
      GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1800), // Rule ID 21303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21303,
        GIR_EraseRootFromParent_Done,
      // Label 112: @1800
      GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1825), // Rule ID 21205 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21205,
        GIR_Done,
      // Label 113: @1825
      GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1850), // Rule ID 21295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21295,
        GIR_Done,
      // Label 114: @1850
      GIM_Reject,
    // Label 104: @1851
    GIM_Reject,
    // Label 70: @1852
    GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(2242),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1905), // Rule ID 21015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21015,
        GIR_EraseRootFromParent_Done,
      // Label 116: @1905
      GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1939), // Rule ID 21021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21021,
        GIR_EraseRootFromParent_Done,
      // Label 117: @1939
      GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1980), // Rule ID 21031 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21031,
        GIR_EraseRootFromParent_Done,
      // Label 118: @1980
      GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2021), // Rule ID 21033 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21033,
        GIR_EraseRootFromParent_Done,
      // Label 119: @2021
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(2045), // Rule ID 21276 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21276,
        GIR_EraseRootFromParent_Done,
      // Label 120: @2045
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(2069), // Rule ID 21280 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21280,
        GIR_EraseRootFromParent_Done,
      // Label 121: @2069
      GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(2093), // Rule ID 21366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21366,
        GIR_EraseRootFromParent_Done,
      // Label 122: @2093
      GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(2117), // Rule ID 21370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21370,
        GIR_EraseRootFromParent_Done,
      // Label 123: @2117
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(2154), // Rule ID 21214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21214,
        GIR_EraseRootFromParent_Done,
      // Label 124: @2154
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(2191), // Rule ID 21304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21304,
        GIR_EraseRootFromParent_Done,
      // Label 125: @2191
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(2216), // Rule ID 21206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21206,
        GIR_Done,
      // Label 126: @2216
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(2241), // Rule ID 21296 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21296,
        GIR_Done,
      // Label 127: @2241
      GIM_Reject,
    // Label 115: @2242
    GIM_Reject,
    // Label 71: @2243
    GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(2336),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(2281), // Rule ID 2488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2488,
        GIR_Done,
      // Label 129: @2281
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(2308), // Rule ID 2490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2490,
        GIR_Done,
      // Label 130: @2308
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(2335), // Rule ID 4603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPADDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4603,
        GIR_Done,
      // Label 131: @2335
      GIM_Reject,
    // Label 128: @2336
    GIM_Reject,
    // Label 72: @2337
    GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(2552),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(2409), // Rule ID 16369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2), VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/2, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16369,
        GIR_EraseRootFromParent_Done,
      // Label 133: @2409
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(2470), // Rule ID 23610 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src3, (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2))  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23610,
        GIR_EraseRootFromParent_Done,
      // Label 134: @2470
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2497), // Rule ID 2482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2482,
        GIR_Done,
      // Label 135: @2497
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2524), // Rule ID 2484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2484,
        GIR_Done,
      // Label 136: @2524
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2551), // Rule ID 4630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPADDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4630,
        GIR_Done,
      // Label 137: @2551
      GIM_Reject,
    // Label 132: @2552
    GIM_Reject,
    // Label 73: @2553
    GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2619),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2591), // Rule ID 2492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPADDQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2492,
        GIR_Done,
      // Label 139: @2591
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2618), // Rule ID 4594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPADDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4594,
        GIR_Done,
      // Label 140: @2618
      GIM_Reject,
    // Label 138: @2619
    GIM_Reject,
    // Label 74: @2620
    GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2835),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2692), // Rule ID 16368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2), VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/2, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16368,
        GIR_EraseRootFromParent_Done,
      // Label 142: @2692
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2753), // Rule ID 23609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src3, (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2))  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23609,
        GIR_EraseRootFromParent_Done,
      // Label 143: @2753
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2780), // Rule ID 2476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2476,
        GIR_Done,
      // Label 144: @2780
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2807), // Rule ID 2478 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2478,
        GIR_Done,
      // Label 145: @2807
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2834), // Rule ID 4651 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPADDWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4651,
        GIR_Done,
      // Label 146: @2834
      GIM_Reject,
    // Label 141: @2835
    GIM_Reject,
    // Label 75: @2836
    GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2902),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2874), // Rule ID 2486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPADDDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2486,
        GIR_Done,
      // Label 148: @2874
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2901), // Rule ID 4621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPADDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4621,
        GIR_Done,
      // Label 149: @2901
      GIM_Reject,
    // Label 147: @2902
    GIM_Reject,
    // Label 76: @2903
    GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2936), // Rule ID 4585 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPADDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4585,
      GIR_Done,
    // Label 150: @2936
    GIM_Reject,
    // Label 77: @2937
    GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(3030),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2975), // Rule ID 2470 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2470,
        GIR_Done,
      // Label 152: @2975
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(3002), // Rule ID 2472 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2472,
        GIR_Done,
      // Label 153: @3002
      GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(3029), // Rule ID 4669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPADDBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4669,
        GIR_Done,
      // Label 154: @3029
      GIM_Reject,
    // Label 151: @3030
    GIM_Reject,
    // Label 78: @3031
    GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(3097),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(3069), // Rule ID 2480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPADDWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2480,
        GIR_Done,
      // Label 156: @3069
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(3096), // Rule ID 4645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPADDWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4645,
        GIR_Done,
      // Label 157: @3096
      GIM_Reject,
    // Label 155: @3097
    GIM_Reject,
    // Label 79: @3098
    GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(3131), // Rule ID 4612 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPADDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4612,
      GIR_Done,
    // Label 158: @3131
    GIM_Reject,
    // Label 80: @3132
    GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(3198),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(3170), // Rule ID 2474 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPADDBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2474,
        GIR_Done,
      // Label 160: @3170
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3197), // Rule ID 4663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPADDBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4663,
        GIR_Done,
      // Label 161: @3197
      GIM_Reject,
    // Label 159: @3198
    GIM_Reject,
    // Label 81: @3199
    GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3232), // Rule ID 4639 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPADDWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4639,
      GIR_Done,
    // Label 162: @3232
    GIM_Reject,
    // Label 82: @3233
    GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(3266), // Rule ID 4657 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPADDBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4657,
      GIR_Done,
    // Label 163: @3266
    GIM_Reject,
    // Label 83: @3267
    GIM_Reject,
    // Label 1: @3268
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 180*/ GIMT_Encode4(4859),
    /*GILLT_s8*//*Label 164*/ GIMT_Encode4(3375),
    /*GILLT_s16*//*Label 165*/ GIMT_Encode4(3549),
    /*GILLT_s32*//*Label 166*/ GIMT_Encode4(3723),
    /*GILLT_s64*//*Label 167*/ GIMT_Encode4(3897), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 168*/ GIMT_Encode4(4079), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 169*/ GIMT_Encode4(4173),
    /*GILLT_v4s64*//*Label 170*/ GIMT_Encode4(4267), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 171*/ GIMT_Encode4(4334),
    /*GILLT_v8s32*//*Label 172*/ GIMT_Encode4(4428),
    /*GILLT_v8s64*//*Label 173*/ GIMT_Encode4(4495), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 174*/ GIMT_Encode4(4529),
    /*GILLT_v16s16*//*Label 175*/ GIMT_Encode4(4623),
    /*GILLT_v16s32*//*Label 176*/ GIMT_Encode4(4690), GIMT_Encode4(0),
    /*GILLT_v32s8*//*Label 177*/ GIMT_Encode4(4724),
    /*GILLT_v32s16*//*Label 178*/ GIMT_Encode4(4791), GIMT_Encode4(0),
    /*GILLT_v64s8*//*Label 179*/ GIMT_Encode4(4825),
    // Label 164: @3375
    GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(3548),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(3415), // Rule ID 246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r_NF_ND:{ *:[i8] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 246,
        GIR_EraseRootFromParent_Done,
      // Label 182: @3415
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(3452), // Rule ID 21223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21223,
        GIR_EraseRootFromParent_Done,
      // Label 183: @3452
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(3489), // Rule ID 21313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21313,
        GIR_EraseRootFromParent_Done,
      // Label 184: @3489
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(3518), // Rule ID 21215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21215,
        GIR_Done,
      // Label 185: @3518
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(3547), // Rule ID 21305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21305,
        GIR_Done,
      // Label 186: @3547
      GIM_Reject,
    // Label 181: @3548
    GIM_Reject,
    // Label 165: @3549
    GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(3722),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(3589), // Rule ID 247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r_NF_ND:{ *:[i16] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 247,
        GIR_EraseRootFromParent_Done,
      // Label 188: @3589
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(3626), // Rule ID 21224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21224,
        GIR_EraseRootFromParent_Done,
      // Label 189: @3626
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(3663), // Rule ID 21314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21314,
        GIR_EraseRootFromParent_Done,
      // Label 190: @3663
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(3692), // Rule ID 21216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21216,
        GIR_Done,
      // Label 191: @3692
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(3721), // Rule ID 21306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21306,
        GIR_Done,
      // Label 192: @3721
      GIM_Reject,
    // Label 187: @3722
    GIM_Reject,
    // Label 166: @3723
    GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(3896),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(3763), // Rule ID 248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r_NF_ND:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 248,
        GIR_EraseRootFromParent_Done,
      // Label 194: @3763
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(3800), // Rule ID 21225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21225,
        GIR_EraseRootFromParent_Done,
      // Label 195: @3800
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(3837), // Rule ID 21315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21315,
        GIR_EraseRootFromParent_Done,
      // Label 196: @3837
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(3866), // Rule ID 21217 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21217,
        GIR_Done,
      // Label 197: @3866
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(3895), // Rule ID 21307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21307,
        GIR_Done,
      // Label 198: @3895
      GIM_Reject,
    // Label 193: @3896
    GIM_Reject,
    // Label 167: @3897
    GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(4078),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3937), // Rule ID 249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r_NF_ND:{ *:[i64] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 249,
        GIR_EraseRootFromParent_Done,
      // Label 200: @3937
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(3978), // Rule ID 21226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21226,
        GIR_EraseRootFromParent_Done,
      // Label 201: @3978
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(4019), // Rule ID 21316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21316,
        GIR_EraseRootFromParent_Done,
      // Label 202: @4019
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(4048), // Rule ID 21218 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21218,
        GIR_Done,
      // Label 203: @4048
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(4077), // Rule ID 21308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21308,
        GIR_Done,
      // Label 204: @4077
      GIM_Reject,
    // Label 199: @4078
    GIM_Reject,
    // Label 168: @4079
    GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(4172),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(4117), // Rule ID 2554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2554,
        GIR_Done,
      // Label 206: @4117
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(4144), // Rule ID 2556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2556,
        GIR_Done,
      // Label 207: @4144
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(4171), // Rule ID 4693 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPSUBQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4693,
        GIR_Done,
      // Label 208: @4171
      GIM_Reject,
    // Label 205: @4172
    GIM_Reject,
    // Label 169: @4173
    GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(4266),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(4211), // Rule ID 2548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2548,
        GIR_Done,
      // Label 210: @4211
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(4238), // Rule ID 2550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2550,
        GIR_Done,
      // Label 211: @4238
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(4265), // Rule ID 4720 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPSUBDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4720,
        GIR_Done,
      // Label 212: @4265
      GIM_Reject,
    // Label 209: @4266
    GIM_Reject,
    // Label 170: @4267
    GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(4333),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(4305), // Rule ID 2558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPSUBQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2558,
        GIR_Done,
      // Label 214: @4305
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(4332), // Rule ID 4684 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPSUBQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4684,
        GIR_Done,
      // Label 215: @4332
      GIM_Reject,
    // Label 213: @4333
    GIM_Reject,
    // Label 171: @4334
    GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(4427),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(4372), // Rule ID 2542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2542,
        GIR_Done,
      // Label 217: @4372
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(4399), // Rule ID 2544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2544,
        GIR_Done,
      // Label 218: @4399
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(4426), // Rule ID 4741 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPSUBWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4741,
        GIR_Done,
      // Label 219: @4426
      GIM_Reject,
    // Label 216: @4427
    GIM_Reject,
    // Label 172: @4428
    GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(4494),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(4466), // Rule ID 2552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPSUBDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2552,
        GIR_Done,
      // Label 221: @4466
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(4493), // Rule ID 4711 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPSUBDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4711,
        GIR_Done,
      // Label 222: @4493
      GIM_Reject,
    // Label 220: @4494
    GIM_Reject,
    // Label 173: @4495
    GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(4528), // Rule ID 4675 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPSUBQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4675,
      GIR_Done,
    // Label 223: @4528
    GIM_Reject,
    // Label 174: @4529
    GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(4622),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(4567), // Rule ID 2536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2536,
        GIR_Done,
      // Label 225: @4567
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(4594), // Rule ID 2538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2538,
        GIR_Done,
      // Label 226: @4594
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(4621), // Rule ID 4759 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPSUBBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4759,
        GIR_Done,
      // Label 227: @4621
      GIM_Reject,
    // Label 224: @4622
    GIM_Reject,
    // Label 175: @4623
    GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(4689),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(4661), // Rule ID 2546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPSUBWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2546,
        GIR_Done,
      // Label 229: @4661
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(4688), // Rule ID 4735 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPSUBWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4735,
        GIR_Done,
      // Label 230: @4688
      GIM_Reject,
    // Label 228: @4689
    GIM_Reject,
    // Label 176: @4690
    GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(4723), // Rule ID 4702 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPSUBDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4702,
      GIR_Done,
    // Label 231: @4723
    GIM_Reject,
    // Label 177: @4724
    GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(4790),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(4762), // Rule ID 2540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPSUBBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2540,
        GIR_Done,
      // Label 233: @4762
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(4789), // Rule ID 4753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPSUBBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4753,
        GIR_Done,
      // Label 234: @4789
      GIM_Reject,
    // Label 232: @4790
    GIM_Reject,
    // Label 178: @4791
    GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(4824), // Rule ID 4729 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPSUBWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4729,
      GIR_Done,
    // Label 235: @4824
    GIM_Reject,
    // Label 179: @4825
    GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(4858), // Rule ID 4747 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPSUBBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4747,
      GIR_Done,
    // Label 236: @4858
    GIM_Reject,
    // Label 180: @4859
    GIM_Reject,
    // Label 2: @4860
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(23), /*)*//*default:*//*Label 249*/ GIMT_Encode4(6096),
    /*GILLT_s16*//*Label 237*/ GIMT_Encode4(4955),
    /*GILLT_s32*//*Label 238*/ GIMT_Encode4(5056),
    /*GILLT_s64*//*Label 239*/ GIMT_Encode4(5157), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 240*/ GIMT_Encode4(5262), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 241*/ GIMT_Encode4(5467),
    /*GILLT_v4s64*//*Label 242*/ GIMT_Encode4(5561), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 243*/ GIMT_Encode4(5766),
    /*GILLT_v8s32*//*Label 244*/ GIMT_Encode4(5860),
    /*GILLT_v8s64*//*Label 245*/ GIMT_Encode4(5927), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s16*//*Label 246*/ GIMT_Encode4(5961),
    /*GILLT_v16s32*//*Label 247*/ GIMT_Encode4(6028), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v32s16*//*Label 248*/ GIMT_Encode4(6062),
    // Label 237: @4955
    GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(5055),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(5004), // Rule ID 21383 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (IMUL16rri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21383,
        GIR_EraseRootFromParent_Done,
      // Label 251: @5004
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(5029), // Rule ID 21231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21231,
        GIR_Done,
      // Label 252: @5029
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(5054), // Rule ID 21321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21321,
        GIR_Done,
      // Label 253: @5054
      GIM_Reject,
    // Label 250: @5055
    GIM_Reject,
    // Label 238: @5056
    GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(5156),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(5105), // Rule ID 21384 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (IMUL32rri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21384,
        GIR_EraseRootFromParent_Done,
      // Label 255: @5105
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(5130), // Rule ID 21232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21232,
        GIR_Done,
      // Label 256: @5130
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(5155), // Rule ID 21322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21322,
        GIR_Done,
      // Label 257: @5155
      GIM_Reject,
    // Label 254: @5156
    GIM_Reject,
    // Label 239: @5157
    GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(5261),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(5210), // Rule ID 21385 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (IMUL64rri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21385,
        GIR_EraseRootFromParent_Done,
      // Label 259: @5210
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(5235), // Rule ID 21233 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21233,
        GIR_Done,
      // Label 260: @5235
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(5260), // Rule ID 21323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21323,
        GIR_Done,
      // Label 261: @5260
      GIM_Reject,
    // Label 258: @5261
    GIM_Reject,
    // Label 240: @5262
    GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(5466),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(5300), // Rule ID 4972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPMULLQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4972,
        GIR_Done,
      // Label 263: @5300
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(5465), // Rule ID 18578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v2i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src1, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src2, sub_xmm:{ *:[i32] })), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 18578,
        GIR_EraseRootFromParent_Done,
      // Label 264: @5465
      GIM_Reject,
    // Label 262: @5466
    GIM_Reject,
    // Label 241: @5467
    GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(5560),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(5505), // Rule ID 3187 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3187,
        GIR_Done,
      // Label 266: @5505
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(5532), // Rule ID 3195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3195,
        GIR_Done,
      // Label 267: @5532
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(5559), // Rule ID 4927 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPMULLDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4927,
        GIR_Done,
      // Label 268: @5559
      GIM_Reject,
    // Label 265: @5560
    GIM_Reject,
    // Label 242: @5561
    GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(5765),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(5599), // Rule ID 4963 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPMULLQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4963,
        GIR_Done,
      // Label 270: @5599
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(5764), // Rule ID 18576 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v4i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src1, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src2, sub_ymm:{ *:[i32] })), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 18576,
        GIR_EraseRootFromParent_Done,
      // Label 271: @5764
      GIM_Reject,
    // Label 269: @5765
    GIM_Reject,
    // Label 243: @5766
    GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(5859),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(5804), // Rule ID 2518 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2518,
        GIR_Done,
      // Label 273: @5804
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(5831), // Rule ID 2520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2520,
        GIR_Done,
      // Label 274: @5831
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(5858), // Rule ID 4948 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPMULLWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4948,
        GIR_Done,
      // Label 275: @5858
      GIM_Reject,
    // Label 272: @5859
    GIM_Reject,
    // Label 244: @5860
    GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(5926),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(5898), // Rule ID 3191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (mul:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPMULLDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3191,
        GIR_Done,
      // Label 277: @5898
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(5925), // Rule ID 4918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPMULLDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4918,
        GIR_Done,
      // Label 278: @5925
      GIM_Reject,
    // Label 276: @5926
    GIM_Reject,
    // Label 245: @5927
    GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(5960), // Rule ID 4954 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (mul:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPMULLQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4954,
      GIR_Done,
    // Label 279: @5960
    GIM_Reject,
    // Label 246: @5961
    GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(6027),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(5999), // Rule ID 2522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (mul:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPMULLWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2522,
        GIR_Done,
      // Label 281: @5999
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(6026), // Rule ID 4942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPMULLWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4942,
        GIR_Done,
      // Label 282: @6026
      GIM_Reject,
    // Label 280: @6027
    GIM_Reject,
    // Label 247: @6028
    GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(6061), // Rule ID 4909 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (mul:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPMULLDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4909,
      GIR_Done,
    // Label 283: @6061
    GIM_Reject,
    // Label 248: @6062
    GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(6095), // Rule ID 4936 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (mul:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPMULLWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4936,
      GIR_Done,
    // Label 284: @6095
    GIM_Reject,
    // Label 249: @6096
    GIM_Reject,
    // Label 3: @6097
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 308*/ GIMT_Encode4(11892),
    /*GILLT_s1*//*Label 285*/ GIMT_Encode4(6208),
    /*GILLT_s8*//*Label 286*/ GIMT_Encode4(6536),
    /*GILLT_s16*//*Label 287*/ GIMT_Encode4(6673),
    /*GILLT_s32*//*Label 288*/ GIMT_Encode4(7138),
    /*GILLT_s64*//*Label 289*/ GIMT_Encode4(8324), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s1*//*Label 290*/ GIMT_Encode4(9388),
    /*GILLT_v2s64*//*Label 291*/ GIMT_Encode4(9716),
    /*GILLT_v4s1*//*Label 292*/ GIMT_Encode4(9810),
    /*GILLT_v4s32*//*Label 293*/ GIMT_Encode4(10138),
    /*GILLT_v4s64*//*Label 294*/ GIMT_Encode4(10232),
    /*GILLT_v8s1*//*Label 295*/ GIMT_Encode4(10326),
    /*GILLT_v8s16*//*Label 296*/ GIMT_Encode4(10806),
    /*GILLT_v8s32*//*Label 297*/ GIMT_Encode4(10900),
    /*GILLT_v8s64*//*Label 298*/ GIMT_Encode4(10994),
    /*GILLT_v16s1*//*Label 299*/ GIMT_Encode4(11028),
    /*GILLT_v16s8*//*Label 300*/ GIMT_Encode4(11188),
    /*GILLT_v16s16*//*Label 301*/ GIMT_Encode4(11282),
    /*GILLT_v16s32*//*Label 302*/ GIMT_Encode4(11376),
    /*GILLT_v32s1*//*Label 303*/ GIMT_Encode4(11410),
    /*GILLT_v32s8*//*Label 304*/ GIMT_Encode4(11570),
    /*GILLT_v32s16*//*Label 305*/ GIMT_Encode4(11664),
    /*GILLT_v64s1*//*Label 306*/ GIMT_Encode4(11698),
    /*GILLT_v64s8*//*Label 307*/ GIMT_Encode4(11858),
    // Label 285: @6208
    GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(6535),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(6337), // Rule ID 18022 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }), VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 18022,
        GIR_EraseRootFromParent_Done,
      // Label 310: @6337
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(6451), // Rule ID 23787 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src2, (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 23787,
        GIR_EraseRootFromParent_Done,
      // Label 311: @6451
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(6534), // Rule ID 18018 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 18018,
        GIR_EraseRootFromParent_Done,
      // Label 312: @6534
      GIM_Reject,
    // Label 309: @6535
    GIM_Reject,
    // Label 286: @6536
    GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(6672),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(6588), // Rule ID 21269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21269,
        GIR_EraseRootFromParent_Done,
      // Label 314: @6588
      GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(6621), // Rule ID 21359 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21359,
        GIR_EraseRootFromParent_Done,
      // Label 315: @6621
      GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(6646), // Rule ID 21261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21261,
        GIR_Done,
      // Label 316: @6646
      GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(6671), // Rule ID 21351 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21351,
        GIR_Done,
      // Label 317: @6671
      GIM_Reject,
    // Label 313: @6672
    GIM_Reject,
    // Label 287: @6673
    GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(7137),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(6790), // Rule ID 24456 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24456,
        GIR_EraseRootFromParent_Done,
      // Label 319: @6790
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(6896), // Rule ID 21185 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21185,
        GIR_EraseRootFromParent_Done,
      // Label 320: @6896
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(6988), // Rule ID 21045 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, 255:{ *:[i16] })  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR16:{ *:[i16] }:$src1, sub_8bit:{ *:[i32] })), sub_16bit:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s8,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
        // GIR_Coverage, 21045,
        GIR_EraseRootFromParent_Done,
      // Label 321: @6988
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(7029), // Rule ID 21270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21270,
        GIR_EraseRootFromParent_Done,
      // Label 322: @7029
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(7070), // Rule ID 21360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21360,
        GIR_EraseRootFromParent_Done,
      // Label 323: @7070
      GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(7103), // Rule ID 21262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21262,
        GIR_Done,
      // Label 324: @7103
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(7136), // Rule ID 21352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21352,
        GIR_Done,
      // Label 325: @7136
      GIM_Reject,
    // Label 318: @7137
    GIM_Reject,
    // Label 288: @7138
    GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(8323),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(7223), // Rule ID 23415 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23415,
        GIR_EraseRootFromParent_Done,
      // Label 327: @7223
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(7300), // Rule ID 23427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23427,
        GIR_EraseRootFromParent_Done,
      // Label 328: @7300
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(7377), // Rule ID 15858 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15858,
        GIR_EraseRootFromParent_Done,
      // Label 329: @7377
      GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(7454), // Rule ID 15870 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15870,
        GIR_EraseRootFromParent_Done,
      // Label 330: @7454
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(7512), // Rule ID 23409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23409,
        GIR_EraseRootFromParent_Done,
      // Label 331: @7512
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(7621), // Rule ID 24462 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24462,
        GIR_EraseRootFromParent_Done,
      // Label 332: @7621
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(7675), // Rule ID 15852 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15852,
        GIR_EraseRootFromParent_Done,
      // Label 333: @7675
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(7784), // Rule ID 21191 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21191,
        GIR_EraseRootFromParent_Done,
      // Label 334: @7784
      GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(7849), // Rule ID 21043 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 65535:{ *:[i32] })  =>  (MOVZX32rr16:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i16] } GR32:{ *:[i32] }:$src1, sub_16bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(4), // src1
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21043,
        GIR_EraseRootFromParent_Done,
      // Label 335: @7849
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(7914), // Rule ID 21044 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 255:{ *:[i32] })  =>  (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR32:{ *:[i32] }:$src1, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21044,
        GIR_EraseRootFromParent_Done,
      // Label 336: @7914
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(7958), // Rule ID 21271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21271,
        GIR_EraseRootFromParent_Done,
      // Label 337: @7958
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(8002), // Rule ID 21361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21361,
        GIR_EraseRootFromParent_Done,
      // Label 338: @8002
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(8064), // Rule ID 16046 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16046,
        GIR_EraseRootFromParent_Done,
      // Label 339: @8064
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(8126), // Rule ID 16050 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16050,
        GIR_EraseRootFromParent_Done,
      // Label 340: @8126
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(8188), // Rule ID 23521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23521,
        GIR_EraseRootFromParent_Done,
      // Label 341: @8188
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(8250), // Rule ID 23525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23525,
        GIR_EraseRootFromParent_Done,
      // Label 342: @8250
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(8286), // Rule ID 21263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21263,
        GIR_Done,
      // Label 343: @8286
      GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(8322), // Rule ID 21353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21353,
        GIR_Done,
      // Label 344: @8322
      GIM_Reject,
    // Label 326: @8323
    GIM_Reject,
    // Label 289: @8324
    GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(9387),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(8409), // Rule ID 23416 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23416,
        GIR_EraseRootFromParent_Done,
      // Label 346: @8409
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(8486), // Rule ID 23428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23428,
        GIR_EraseRootFromParent_Done,
      // Label 347: @8486
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(8563), // Rule ID 15859 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15859,
        GIR_EraseRootFromParent_Done,
      // Label 348: @8563
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(8640), // Rule ID 15871 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15871,
        GIR_EraseRootFromParent_Done,
      // Label 349: @8640
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(8698), // Rule ID 23410 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23410,
        GIR_EraseRootFromParent_Done,
      // Label 350: @8698
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(8807), // Rule ID 24468 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24468,
        GIR_EraseRootFromParent_Done,
      // Label 351: @8807
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(8861), // Rule ID 15853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15853,
        GIR_EraseRootFromParent_Done,
      // Label 352: @8861
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(8970), // Rule ID 21197 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21197,
        GIR_EraseRootFromParent_Done,
      // Label 353: @8970
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(9018), // Rule ID 21272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21272,
        GIR_EraseRootFromParent_Done,
      // Label 354: @9018
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(9066), // Rule ID 21362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21362,
        GIR_EraseRootFromParent_Done,
      // Label 355: @9066
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(9128), // Rule ID 16047 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16047,
        GIR_EraseRootFromParent_Done,
      // Label 356: @9128
      GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(9190), // Rule ID 16051 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16051,
        GIR_EraseRootFromParent_Done,
      // Label 357: @9190
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(9252), // Rule ID 23522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23522,
        GIR_EraseRootFromParent_Done,
      // Label 358: @9252
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(9314), // Rule ID 23526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23526,
        GIR_EraseRootFromParent_Done,
      // Label 359: @9314
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(9350), // Rule ID 21264 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21264,
        GIR_Done,
      // Label 360: @9350
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(9386), // Rule ID 21354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21354,
        GIR_Done,
      // Label 361: @9386
      GIM_Reject,
    // Label 345: @9387
    GIM_Reject,
    // Label 290: @9388
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(9715),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(9517), // Rule ID 18023 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }), VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18023,
        GIR_EraseRootFromParent_Done,
      // Label 363: @9517
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(9631), // Rule ID 23788 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src2, (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 23788,
        GIR_EraseRootFromParent_Done,
      // Label 364: @9631
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(9714), // Rule ID 18019 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18019,
        GIR_EraseRootFromParent_Done,
      // Label 365: @9714
      GIM_Reject,
    // Label 362: @9715
    GIM_Reject,
    // Label 291: @9716
    GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(9809),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(9754), // Rule ID 2098 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2098,
        GIR_Done,
      // Label 367: @9754
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(9781), // Rule ID 2100 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2100,
        GIR_Done,
      // Label 368: @9781
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(9808), // Rule ID 5656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPANDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5656,
        GIR_Done,
      // Label 369: @9808
      GIM_Reject,
    // Label 366: @9809
    GIM_Reject,
    // Label 292: @9810
    GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(10137),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(9939), // Rule ID 18024 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }), VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18024,
        GIR_EraseRootFromParent_Done,
      // Label 371: @9939
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(10053), // Rule ID 23789 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src2, (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 23789,
        GIR_EraseRootFromParent_Done,
      // Label 372: @10053
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(10136), // Rule ID 18020 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18020,
        GIR_EraseRootFromParent_Done,
      // Label 373: @10136
      GIM_Reject,
    // Label 370: @10137
    GIM_Reject,
    // Label 293: @10138
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(10231),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(10176), // Rule ID 5683 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPANDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5683,
        GIR_Done,
      // Label 375: @10176
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(10203), // Rule ID 16658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16658,
        GIR_Done,
      // Label 376: @10203
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(10230), // Rule ID 16682 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16682,
        GIR_Done,
      // Label 377: @10230
      GIM_Reject,
    // Label 374: @10231
    GIM_Reject,
    // Label 294: @10232
    GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(10325),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(10270), // Rule ID 2102 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPANDYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2102,
        GIR_Done,
      // Label 379: @10270
      GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(10297), // Rule ID 5647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPANDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5647,
        GIR_Done,
      // Label 380: @10297
      GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(10324), // Rule ID 16627 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VANDPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16627,
        GIR_Done,
      // Label 381: @10324
      GIM_Reject,
    // Label 378: @10325
    GIM_Reject,
    // Label 295: @10326
    GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(10805),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(10401), // Rule ID 4383 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (KANDNBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4383,
        GIR_EraseRootFromParent_Done,
      // Label 383: @10401
      GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(10518), // Rule ID 18021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18021,
        GIR_EraseRootFromParent_Done,
      // Label 384: @10518
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(10578), // Rule ID 22112 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (KANDNBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22112,
        GIR_EraseRootFromParent_Done,
      // Label 385: @10578
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(10695), // Rule ID 23786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 23786,
        GIR_EraseRootFromParent_Done,
      // Label 386: @10695
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(10718), // Rule ID 4367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KANDBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4367,
        GIR_Done,
      // Label 387: @10718
      GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(10804), // Rule ID 18017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18017,
        GIR_EraseRootFromParent_Done,
      // Label 388: @10804
      GIM_Reject,
    // Label 382: @10805
    GIM_Reject,
    // Label 296: @10806
    GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(10899),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(10844), // Rule ID 16657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16657,
        GIR_Done,
      // Label 390: @10844
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(10871), // Rule ID 16681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16681,
        GIR_Done,
      // Label 391: @10871
      GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(10898), // Rule ID 18597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPANDQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18597,
        GIR_Done,
      // Label 392: @10898
      GIM_Reject,
    // Label 389: @10899
    GIM_Reject,
    // Label 297: @10900
    GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(10993),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(10938), // Rule ID 5674 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPANDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5674,
        GIR_Done,
      // Label 394: @10938
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(10965), // Rule ID 16602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPANDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16602,
        GIR_Done,
      // Label 395: @10965
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(10992), // Rule ID 16626 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VANDPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16626,
        GIR_Done,
      // Label 396: @10992
      GIM_Reject,
    // Label 393: @10993
    GIM_Reject,
    // Label 298: @10994
    GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(11027), // Rule ID 5638 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPANDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5638,
      GIR_Done,
    // Label 397: @11027
    GIM_Reject,
    // Label 299: @11028
    GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(11187),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(11103), // Rule ID 4384 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }), VK16:{ *:[v16i1] }:$src2)  =>  (KANDNWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4384,
        GIR_EraseRootFromParent_Done,
      // Label 399: @11103
      GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(11163), // Rule ID 22113 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src2, (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }))  =>  (KANDNWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22113,
        GIR_EraseRootFromParent_Done,
      // Label 400: @11163
      GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(11186), // Rule ID 4368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KANDWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4368,
        GIR_Done,
      // Label 401: @11186
      GIM_Reject,
    // Label 398: @11187
    GIM_Reject,
    // Label 300: @11188
    GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(11281),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(11226), // Rule ID 16656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16656,
        GIR_Done,
      // Label 403: @11226
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(11253), // Rule ID 16680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16680,
        GIR_Done,
      // Label 404: @11253
      GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(11280), // Rule ID 18596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPANDQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18596,
        GIR_Done,
      // Label 405: @11280
      GIM_Reject,
    // Label 402: @11281
    GIM_Reject,
    // Label 301: @11282
    GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(11375),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(11320), // Rule ID 16601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPANDYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16601,
        GIR_Done,
      // Label 407: @11320
      GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(11347), // Rule ID 16625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VANDPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16625,
        GIR_Done,
      // Label 408: @11347
      GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(11374), // Rule ID 18613 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPANDQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18613,
        GIR_Done,
      // Label 409: @11374
      GIM_Reject,
    // Label 406: @11375
    GIM_Reject,
    // Label 302: @11376
    GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(11409), // Rule ID 5665 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPANDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5665,
      GIR_Done,
    // Label 410: @11409
    GIM_Reject,
    // Label 303: @11410
    GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(11569),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(11485), // Rule ID 4385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }), VK32:{ *:[v32i1] }:$src2)  =>  (KANDNDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4385,
        GIR_EraseRootFromParent_Done,
      // Label 412: @11485
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(11545), // Rule ID 22114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src2, (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }))  =>  (KANDNDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22114,
        GIR_EraseRootFromParent_Done,
      // Label 413: @11545
      GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(11568), // Rule ID 4369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KANDDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4369,
        GIR_Done,
      // Label 414: @11568
      GIM_Reject,
    // Label 411: @11569
    GIM_Reject,
    // Label 304: @11570
    GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(11663),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(11608), // Rule ID 16600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPANDYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16600,
        GIR_Done,
      // Label 416: @11608
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(11635), // Rule ID 16624 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VANDPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16624,
        GIR_Done,
      // Label 417: @11635
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(11662), // Rule ID 18612 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPANDQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18612,
        GIR_Done,
      // Label 418: @11662
      GIM_Reject,
    // Label 415: @11663
    GIM_Reject,
    // Label 305: @11664
    GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(11697), // Rule ID 18629 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPANDQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18629,
      GIR_Done,
    // Label 419: @11697
    GIM_Reject,
    // Label 306: @11698
    GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(11857),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(11773), // Rule ID 4386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }), VK64:{ *:[v64i1] }:$src2)  =>  (KANDNQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4386,
        GIR_EraseRootFromParent_Done,
      // Label 421: @11773
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(11833), // Rule ID 22115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src2, (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }))  =>  (KANDNQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22115,
        GIR_EraseRootFromParent_Done,
      // Label 422: @11833
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(11856), // Rule ID 4370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KANDQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4370,
        GIR_Done,
      // Label 423: @11856
      GIM_Reject,
    // Label 420: @11857
    GIM_Reject,
    // Label 307: @11858
    GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(11891), // Rule ID 18628 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPANDQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18628,
      GIR_Done,
    // Label 424: @11891
    GIM_Reject,
    // Label 308: @11892
    GIM_Reject,
    // Label 4: @11893
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 448*/ GIMT_Encode4(16260),
    /*GILLT_s1*//*Label 425*/ GIMT_Encode4(12004),
    /*GILLT_s8*//*Label 426*/ GIMT_Encode4(12098),
    /*GILLT_s16*//*Label 427*/ GIMT_Encode4(12235),
    /*GILLT_s32*//*Label 428*/ GIMT_Encode4(12588),
    /*GILLT_s64*//*Label 429*/ GIMT_Encode4(13772), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s1*//*Label 430*/ GIMT_Encode4(14964),
    /*GILLT_v2s64*//*Label 431*/ GIMT_Encode4(15058),
    /*GILLT_v4s1*//*Label 432*/ GIMT_Encode4(15152),
    /*GILLT_v4s32*//*Label 433*/ GIMT_Encode4(15246),
    /*GILLT_v4s64*//*Label 434*/ GIMT_Encode4(15340),
    /*GILLT_v8s1*//*Label 435*/ GIMT_Encode4(15434),
    /*GILLT_v8s16*//*Label 436*/ GIMT_Encode4(15552),
    /*GILLT_v8s32*//*Label 437*/ GIMT_Encode4(15646),
    /*GILLT_v8s64*//*Label 438*/ GIMT_Encode4(15740),
    /*GILLT_v16s1*//*Label 439*/ GIMT_Encode4(15774),
    /*GILLT_v16s8*//*Label 440*/ GIMT_Encode4(15808),
    /*GILLT_v16s16*//*Label 441*/ GIMT_Encode4(15902),
    /*GILLT_v16s32*//*Label 442*/ GIMT_Encode4(15996),
    /*GILLT_v32s1*//*Label 443*/ GIMT_Encode4(16030),
    /*GILLT_v32s8*//*Label 444*/ GIMT_Encode4(16064),
    /*GILLT_v32s16*//*Label 445*/ GIMT_Encode4(16158),
    /*GILLT_v64s1*//*Label 446*/ GIMT_Encode4(16192),
    /*GILLT_v64s8*//*Label 447*/ GIMT_Encode4(16226),
    // Label 425: @12004
    GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(12097), // Rule ID 18026 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      // (or:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
      // GIR_Coverage, 18026,
      GIR_EraseRootFromParent_Done,
    // Label 449: @12097
    GIM_Reject,
    // Label 426: @12098
    GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(12234),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(12150), // Rule ID 21245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21245,
        GIR_EraseRootFromParent_Done,
      // Label 451: @12150
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(12183), // Rule ID 21335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21335,
        GIR_EraseRootFromParent_Done,
      // Label 452: @12183
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(12208), // Rule ID 21237 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21237,
        GIR_Done,
      // Label 453: @12208
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(12233), // Rule ID 21327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21327,
        GIR_Done,
      // Label 454: @12233
      GIM_Reject,
    // Label 450: @12234
    GIM_Reject,
    // Label 427: @12235
    GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(12587),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(12352), // Rule ID 24457 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24457,
        GIR_EraseRootFromParent_Done,
      // Label 456: @12352
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(12454), // Rule ID 21186 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21186,
        GIR_EraseRootFromParent_Done,
      // Label 457: @12454
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(12491), // Rule ID 21246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21246,
        GIR_EraseRootFromParent_Done,
      // Label 458: @12491
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(12528), // Rule ID 21336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21336,
        GIR_EraseRootFromParent_Done,
      // Label 459: @12528
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(12557), // Rule ID 21238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21238,
        GIR_Done,
      // Label 460: @12557
      GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(12586), // Rule ID 21328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21328,
        GIR_Done,
      // Label 461: @12586
      GIM_Reject,
    // Label 455: @12587
    GIM_Reject,
    // Label 428: @12588
    GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(13771),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(12673), // Rule ID 23423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23423,
        GIR_EraseRootFromParent_Done,
      // Label 463: @12673
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(12750), // Rule ID 23425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23425,
        GIR_EraseRootFromParent_Done,
      // Label 464: @12750
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(12828), // Rule ID 23411 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23411,
        GIR_EraseRootFromParent_Done,
      // Label 465: @12828
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(12905), // Rule ID 15866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15866,
        GIR_EraseRootFromParent_Done,
      // Label 466: @12905
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(12982), // Rule ID 15868 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15868,
        GIR_EraseRootFromParent_Done,
      // Label 467: @12982
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(13056), // Rule ID 15854 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15854,
        GIR_EraseRootFromParent_Done,
      // Label 468: @13056
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(13114), // Rule ID 23419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23419,
        GIR_EraseRootFromParent_Done,
      // Label 469: @13114
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(13172), // Rule ID 23421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23421,
        GIR_EraseRootFromParent_Done,
      // Label 470: @13172
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(13281), // Rule ID 24463 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24463,
        GIR_EraseRootFromParent_Done,
      // Label 471: @13281
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(13339), // Rule ID 23413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23413,
        GIR_EraseRootFromParent_Done,
      // Label 472: @13339
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(13393), // Rule ID 15862 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15862,
        GIR_EraseRootFromParent_Done,
      // Label 473: @13393
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(13447), // Rule ID 15864 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15864,
        GIR_EraseRootFromParent_Done,
      // Label 474: @13447
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(13556), // Rule ID 21192 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21192,
        GIR_EraseRootFromParent_Done,
      // Label 475: @13556
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(13610), // Rule ID 15856 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15856,
        GIR_EraseRootFromParent_Done,
      // Label 476: @13610
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(13654), // Rule ID 21247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21247,
        GIR_EraseRootFromParent_Done,
      // Label 477: @13654
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(13698), // Rule ID 21337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21337,
        GIR_EraseRootFromParent_Done,
      // Label 478: @13698
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(13734), // Rule ID 21239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21239,
        GIR_Done,
      // Label 479: @13734
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(13770), // Rule ID 21329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21329,
        GIR_Done,
      // Label 480: @13770
      GIM_Reject,
    // Label 462: @13771
    GIM_Reject,
    // Label 429: @13772
    GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(14963),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(13857), // Rule ID 23424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23424,
        GIR_EraseRootFromParent_Done,
      // Label 482: @13857
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(13934), // Rule ID 23426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23426,
        GIR_EraseRootFromParent_Done,
      // Label 483: @13934
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(14012), // Rule ID 23412 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23412,
        GIR_EraseRootFromParent_Done,
      // Label 484: @14012
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(14089), // Rule ID 15867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15867,
        GIR_EraseRootFromParent_Done,
      // Label 485: @14089
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(14166), // Rule ID 15869 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15869,
        GIR_EraseRootFromParent_Done,
      // Label 486: @14166
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(14240), // Rule ID 15855 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15855,
        GIR_EraseRootFromParent_Done,
      // Label 487: @14240
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(14298), // Rule ID 23420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23420,
        GIR_EraseRootFromParent_Done,
      // Label 488: @14298
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(14356), // Rule ID 23422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23422,
        GIR_EraseRootFromParent_Done,
      // Label 489: @14356
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(14465), // Rule ID 24469 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24469,
        GIR_EraseRootFromParent_Done,
      // Label 490: @14465
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(14523), // Rule ID 23414 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23414,
        GIR_EraseRootFromParent_Done,
      // Label 491: @14523
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(14577), // Rule ID 15863 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15863,
        GIR_EraseRootFromParent_Done,
      // Label 492: @14577
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(14631), // Rule ID 15865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15865,
        GIR_EraseRootFromParent_Done,
      // Label 493: @14631
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(14740), // Rule ID 21198 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21198,
        GIR_EraseRootFromParent_Done,
      // Label 494: @14740
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(14794), // Rule ID 15857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15857,
        GIR_EraseRootFromParent_Done,
      // Label 495: @14794
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(14842), // Rule ID 21248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21248,
        GIR_EraseRootFromParent_Done,
      // Label 496: @14842
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(14890), // Rule ID 21338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21338,
        GIR_EraseRootFromParent_Done,
      // Label 497: @14890
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(14926), // Rule ID 21240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21240,
        GIR_Done,
      // Label 498: @14926
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(14962), // Rule ID 21330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21330,
        GIR_Done,
      // Label 499: @14962
      GIM_Reject,
    // Label 481: @14963
    GIM_Reject,
    // Label 430: @14964
    GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(15057), // Rule ID 18027 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      // (or:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
      // GIR_Coverage, 18027,
      GIR_EraseRootFromParent_Done,
    // Label 500: @15057
    GIM_Reject,
    // Label 431: @15058
    GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(15151),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(15096), // Rule ID 2104 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2104,
        GIR_Done,
      // Label 502: @15096
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(15123), // Rule ID 2106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2106,
        GIR_Done,
      // Label 503: @15123
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(15150), // Rule ID 5710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPORQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5710,
        GIR_Done,
      // Label 504: @15150
      GIM_Reject,
    // Label 501: @15151
    GIM_Reject,
    // Label 432: @15152
    GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(15245), // Rule ID 18028 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      // (or:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
      // GIR_Coverage, 18028,
      GIR_EraseRootFromParent_Done,
    // Label 505: @15245
    GIM_Reject,
    // Label 433: @15246
    GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(15339),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(15284), // Rule ID 5737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPORDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5737,
        GIR_Done,
      // Label 507: @15284
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(15311), // Rule ID 16661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16661,
        GIR_Done,
      // Label 508: @15311
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(15338), // Rule ID 16685 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16685,
        GIR_Done,
      // Label 509: @15338
      GIM_Reject,
    // Label 506: @15339
    GIM_Reject,
    // Label 434: @15340
    GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(15433),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(15378), // Rule ID 2108 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPORYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2108,
        GIR_Done,
      // Label 511: @15378
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(15405), // Rule ID 5701 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPORQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5701,
        GIR_Done,
      // Label 512: @15405
      GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(15432), // Rule ID 16631 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VORPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16631,
        GIR_Done,
      // Label 513: @15432
      GIM_Reject,
    // Label 510: @15433
    GIM_Reject,
    // Label 435: @15434
    GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(15551),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(15472), // Rule ID 4371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4371,
        GIR_Done,
      // Label 515: @15472
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(15550), // Rule ID 18025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18025,
        GIR_EraseRootFromParent_Done,
      // Label 516: @15550
      GIM_Reject,
    // Label 514: @15551
    GIM_Reject,
    // Label 436: @15552
    GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(15645),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(15590), // Rule ID 16660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16660,
        GIR_Done,
      // Label 518: @15590
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(15617), // Rule ID 16684 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16684,
        GIR_Done,
      // Label 519: @15617
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(15644), // Rule ID 18599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPORQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18599,
        GIR_Done,
      // Label 520: @15644
      GIM_Reject,
    // Label 517: @15645
    GIM_Reject,
    // Label 437: @15646
    GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(15739),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(15684), // Rule ID 5728 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPORDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5728,
        GIR_Done,
      // Label 522: @15684
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(15711), // Rule ID 16605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPORYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16605,
        GIR_Done,
      // Label 523: @15711
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(15738), // Rule ID 16630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VORPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16630,
        GIR_Done,
      // Label 524: @15738
      GIM_Reject,
    // Label 521: @15739
    GIM_Reject,
    // Label 438: @15740
    GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(15773), // Rule ID 5692 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPORQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5692,
      GIR_Done,
    // Label 525: @15773
    GIM_Reject,
    // Label 439: @15774
    GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(15807), // Rule ID 4372 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      // (or:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORWrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4372,
      GIR_Done,
    // Label 526: @15807
    GIM_Reject,
    // Label 440: @15808
    GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(15901),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(15846), // Rule ID 16659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16659,
        GIR_Done,
      // Label 528: @15846
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(15873), // Rule ID 16683 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16683,
        GIR_Done,
      // Label 529: @15873
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(15900), // Rule ID 18598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPORQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18598,
        GIR_Done,
      // Label 530: @15900
      GIM_Reject,
    // Label 527: @15901
    GIM_Reject,
    // Label 441: @15902
    GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(15995),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(15940), // Rule ID 16604 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPORYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16604,
        GIR_Done,
      // Label 532: @15940
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(15967), // Rule ID 16629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VORPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16629,
        GIR_Done,
      // Label 533: @15967
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(15994), // Rule ID 18615 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPORQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18615,
        GIR_Done,
      // Label 534: @15994
      GIM_Reject,
    // Label 531: @15995
    GIM_Reject,
    // Label 442: @15996
    GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(16029), // Rule ID 5719 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPORDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5719,
      GIR_Done,
    // Label 535: @16029
    GIM_Reject,
    // Label 443: @16030
    GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(16063), // Rule ID 4373 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      // (or:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORDrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4373,
      GIR_Done,
    // Label 536: @16063
    GIM_Reject,
    // Label 444: @16064
    GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(16157),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(16102), // Rule ID 16603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPORYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16603,
        GIR_Done,
      // Label 538: @16102
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(16129), // Rule ID 16628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VORPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16628,
        GIR_Done,
      // Label 539: @16129
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(16156), // Rule ID 18614 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPORQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18614,
        GIR_Done,
      // Label 540: @16156
      GIM_Reject,
    // Label 537: @16157
    GIM_Reject,
    // Label 445: @16158
    GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(16191), // Rule ID 18631 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPORQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18631,
      GIR_Done,
    // Label 541: @16191
    GIM_Reject,
    // Label 446: @16192
    GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(16225), // Rule ID 4374 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      // (or:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORQrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4374,
      GIR_Done,
    // Label 542: @16225
    GIM_Reject,
    // Label 447: @16226
    GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(16259), // Rule ID 18630 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPORQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18630,
      GIR_Done,
    // Label 543: @16259
    GIM_Reject,
    // Label 448: @16260
    GIM_Reject,
    // Label 5: @16261
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 567*/ GIMT_Encode4(24599),
    /*GILLT_s1*//*Label 544*/ GIMT_Encode4(16372),
    /*GILLT_s8*//*Label 545*/ GIMT_Encode4(16903),
    /*GILLT_s16*//*Label 546*/ GIMT_Encode4(17106),
    /*GILLT_s32*//*Label 547*/ GIMT_Encode4(17551),
    /*GILLT_s64*//*Label 548*/ GIMT_Encode4(18164), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s1*//*Label 549*/ GIMT_Encode4(18736),
    /*GILLT_v2s64*//*Label 550*/ GIMT_Encode4(19251),
    /*GILLT_v4s1*//*Label 551*/ GIMT_Encode4(19623),
    /*GILLT_v4s32*//*Label 552*/ GIMT_Encode4(20138),
    /*GILLT_v4s64*//*Label 553*/ GIMT_Encode4(20510),
    /*GILLT_v8s1*//*Label 554*/ GIMT_Encode4(20882),
    /*GILLT_v8s16*//*Label 555*/ GIMT_Encode4(21653),
    /*GILLT_v8s32*//*Label 556*/ GIMT_Encode4(22025),
    /*GILLT_v8s64*//*Label 557*/ GIMT_Encode4(22397),
    /*GILLT_v16s1*//*Label 558*/ GIMT_Encode4(22475),
    /*GILLT_v16s8*//*Label 559*/ GIMT_Encode4(22733),
    /*GILLT_v16s16*//*Label 560*/ GIMT_Encode4(23105),
    /*GILLT_v16s32*//*Label 561*/ GIMT_Encode4(23477),
    /*GILLT_v32s1*//*Label 562*/ GIMT_Encode4(23555),
    /*GILLT_v32s8*//*Label 563*/ GIMT_Encode4(23813),
    /*GILLT_v32s16*//*Label 564*/ GIMT_Encode4(24185),
    /*GILLT_v64s1*//*Label 565*/ GIMT_Encode4(24263),
    /*GILLT_v64s8*//*Label 566*/ GIMT_Encode4(24521),
    // Label 544: @16372
    GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(16902),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(16501), // Rule ID 23792 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }), VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 23792,
        GIR_EraseRootFromParent_Done,
      // Label 569: @16501
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(16620), // Rule ID 18030 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2), immAllOnesV:{ *:[v1i1] })  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 18030,
        GIR_EraseRootFromParent_Done,
      // Label 570: @16620
      GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(16738), // Rule ID 23793 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src2, (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 23793,
        GIR_EraseRootFromParent_Done,
      // Label 571: @16738
      GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(16814), // Rule ID 18016 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src, immAllOnesV:{ *:[v1i1] })  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KNOTWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18016,
        GIR_EraseRootFromParent_Done,
      // Label 572: @16814
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(16901), // Rule ID 18034 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        // (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 18034,
        GIR_EraseRootFromParent_Done,
      // Label 573: @16901
      GIM_Reject,
    // Label 568: @16902
    GIM_Reject,
    // Label 545: @16903
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(17105),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(16946), // Rule ID 21010 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-128),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, -128:{ *:[i8] })  =>  (ADD8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, -128:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21010,
        GIR_EraseRootFromParent_Done,
      // Label 575: @16946
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(16967), // Rule ID 234 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, -1:{ *:[i8] })  =>  (NOT8r:{ *:[i8] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 234,
        GIR_EraseRootFromParent_Done,
      // Label 576: @16967
      GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(16988), // Rule ID 242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, -1:{ *:[i8] })  =>  (NOT8r_ND:{ *:[i8] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 242,
        GIR_EraseRootFromParent_Done,
      // Label 577: @16988
      GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(17021), // Rule ID 21257 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (XOR8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21257,
        GIR_EraseRootFromParent_Done,
      // Label 578: @17021
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(17054), // Rule ID 21347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (XOR8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21347,
        GIR_EraseRootFromParent_Done,
      // Label 579: @17054
      GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(17079), // Rule ID 21249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (XOR8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21249,
        GIR_Done,
      // Label 580: @17079
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(17104), // Rule ID 21339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (XOR8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21339,
        GIR_Done,
      // Label 581: @17104
      GIM_Reject,
    // Label 574: @17105
    GIM_Reject,
    // Label 546: @17106
    GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(17550),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(17163), // Rule ID 21011 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(-32768),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, -32768:{ *:[i16] })  =>  (ADD16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -32768:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-32768),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21011,
        GIR_EraseRootFromParent_Done,
      // Label 583: @17163
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(17265), // Rule ID 24458 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTC16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24458,
        GIR_EraseRootFromParent_Done,
      // Label 584: @17265
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(17367), // Rule ID 21187 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTC16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21187,
        GIR_EraseRootFromParent_Done,
      // Label 585: @17367
      GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(17392), // Rule ID 235 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, -1:{ *:[i16] })  =>  (NOT16r:{ *:[i16] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 235,
        GIR_EraseRootFromParent_Done,
      // Label 586: @17392
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(17417), // Rule ID 243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, -1:{ *:[i16] })  =>  (NOT16r_ND:{ *:[i16] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 243,
        GIR_EraseRootFromParent_Done,
      // Label 587: @17417
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(17454), // Rule ID 21258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (XOR16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21258,
        GIR_EraseRootFromParent_Done,
      // Label 588: @17454
      GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(17491), // Rule ID 21348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (XOR16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21348,
        GIR_EraseRootFromParent_Done,
      // Label 589: @17491
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(17520), // Rule ID 21250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (XOR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21250,
        GIR_Done,
      // Label 590: @17520
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(17549), // Rule ID 21340 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (XOR16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21340,
        GIR_Done,
      // Label 591: @17549
      GIM_Reject,
    // Label 582: @17550
    GIM_Reject,
    // Label 547: @17551
    GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(18163),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(17608), // Rule ID 21012 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(-2147483648),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -2147483648:{ *:[i32] })  =>  (ADD32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -2147483648:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21012,
        GIR_EraseRootFromParent_Done,
      // Label 593: @17608
      GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(17666), // Rule ID 23417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23417,
        GIR_EraseRootFromParent_Done,
      // Label 594: @17666
      GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(17775), // Rule ID 24464 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24464,
        GIR_EraseRootFromParent_Done,
      // Label 595: @17775
      GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(17829), // Rule ID 15860 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15860,
        GIR_EraseRootFromParent_Done,
      // Label 596: @17829
      GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(17938), // Rule ID 21193 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21193,
        GIR_EraseRootFromParent_Done,
      // Label 597: @17938
      GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(17970), // Rule ID 236 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] })  =>  (NOT32r:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 236,
        GIR_EraseRootFromParent_Done,
      // Label 598: @17970
      GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(18002), // Rule ID 244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] })  =>  (NOT32r_ND:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 244,
        GIR_EraseRootFromParent_Done,
      // Label 599: @18002
      GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(18046), // Rule ID 21259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (XOR32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21259,
        GIR_EraseRootFromParent_Done,
      // Label 600: @18046
      GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(18090), // Rule ID 21349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (XOR32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21349,
        GIR_EraseRootFromParent_Done,
      // Label 601: @18090
      GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(18126), // Rule ID 21251 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (XOR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21251,
        GIR_Done,
      // Label 602: @18126
      GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(18162), // Rule ID 21341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (XOR32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21341,
        GIR_Done,
      // Label 603: @18162
      GIM_Reject,
    // Label 592: @18163
    GIM_Reject,
    // Label 548: @18164
    GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(18735),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(18230), // Rule ID 23418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23418,
        GIR_EraseRootFromParent_Done,
      // Label 605: @18230
      GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(18339), // Rule ID 24470 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24470,
        GIR_EraseRootFromParent_Done,
      // Label 606: @18339
      GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(18393), // Rule ID 15861 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15861,
        GIR_EraseRootFromParent_Done,
      // Label 607: @18393
      GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(18502), // Rule ID 21199 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21199,
        GIR_EraseRootFromParent_Done,
      // Label 608: @18502
      GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(18534), // Rule ID 237 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] })  =>  (NOT64r:{ *:[i64] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 237,
        GIR_EraseRootFromParent_Done,
      // Label 609: @18534
      GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(18566), // Rule ID 245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] })  =>  (NOT64r_ND:{ *:[i64] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 245,
        GIR_EraseRootFromParent_Done,
      // Label 610: @18566
      GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(18614), // Rule ID 21260 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (XOR64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21260,
        GIR_EraseRootFromParent_Done,
      // Label 611: @18614
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(18662), // Rule ID 21350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (XOR64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21350,
        GIR_EraseRootFromParent_Done,
      // Label 612: @18662
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(18698), // Rule ID 21252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (XOR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21252,
        GIR_Done,
      // Label 613: @18698
      GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(18734), // Rule ID 21342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (XOR64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21342,
        GIR_Done,
      // Label 614: @18734
      GIM_Reject,
    // Label 604: @18735
    GIM_Reject,
    // Label 549: @18736
    GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(19250),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(18865), // Rule ID 23794 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }), VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 23794,
        GIR_EraseRootFromParent_Done,
      // Label 616: @18865
      GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(18980), // Rule ID 18031 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2), immAllOnesV:{ *:[v2i1] })  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18031,
        GIR_EraseRootFromParent_Done,
      // Label 617: @18980
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(19094), // Rule ID 23795 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src2, (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 23795,
        GIR_EraseRootFromParent_Done,
      // Label 618: @19094
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(19166), // Rule ID 18015 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src, immAllOnesV:{ *:[v2i1] })  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KNOTWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18015,
        GIR_EraseRootFromParent_Done,
      // Label 619: @19166
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(19249), // Rule ID 18035 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        // (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18035,
        GIR_EraseRootFromParent_Done,
      // Label 620: @19249
      GIM_Reject,
    // Label 615: @19250
    GIM_Reject,
    // Label 550: @19251
    GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(19622),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(19494), // Rule ID 20490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src, immAllOnesV:{ *:[v2i64] })  =>  (EXTRACT_SUBREG:{ *:[v2i64] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20490,
        GIR_EraseRootFromParent_Done,
      // Label 622: @19494
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(19540), // Rule ID 20498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src, immAllOnesV:{ *:[v2i64] })  =>  (VPTERNLOGQZ128rri:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src, VR128X:{ *:[v2i64] }:$src, VR128X:{ *:[v2i64] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20498,
        GIR_EraseRootFromParent_Done,
      // Label 623: @19540
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(19567), // Rule ID 2110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPXORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2110,
        GIR_Done,
      // Label 624: @19567
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(19594), // Rule ID 2112 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PXORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2112,
        GIR_Done,
      // Label 625: @19594
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(19621), // Rule ID 5764 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPXORQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5764,
        GIR_Done,
      // Label 626: @19621
      GIM_Reject,
    // Label 621: @19622
    GIM_Reject,
    // Label 551: @19623
    GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(20137),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(19752), // Rule ID 23796 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }), VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 23796,
        GIR_EraseRootFromParent_Done,
      // Label 628: @19752
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(19867), // Rule ID 18032 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2), immAllOnesV:{ *:[v4i1] })  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18032,
        GIR_EraseRootFromParent_Done,
      // Label 629: @19867
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(19981), // Rule ID 23797 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src2, (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 23797,
        GIR_EraseRootFromParent_Done,
      // Label 630: @19981
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(20053), // Rule ID 18014 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src, immAllOnesV:{ *:[v4i1] })  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KNOTWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18014,
        GIR_EraseRootFromParent_Done,
      // Label 631: @20053
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(20136), // Rule ID 18036 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        // (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18036,
        GIR_EraseRootFromParent_Done,
      // Label 632: @20136
      GIM_Reject,
    // Label 627: @20137
    GIM_Reject,
    // Label 552: @20138
    GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(20509),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(20381), // Rule ID 20489 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src, immAllOnesV:{ *:[v4i32] })  =>  (EXTRACT_SUBREG:{ *:[v4i32] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v4i32] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v4i32] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v4i32] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20489,
        GIR_EraseRootFromParent_Done,
      // Label 634: @20381
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(20427), // Rule ID 20497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src, immAllOnesV:{ *:[v4i32] })  =>  (VPTERNLOGQZ128rri:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src, VR128X:{ *:[v4i32] }:$src, VR128X:{ *:[v4i32] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20497,
        GIR_EraseRootFromParent_Done,
      // Label 635: @20427
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(20454), // Rule ID 5791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPXORDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5791,
        GIR_Done,
      // Label 636: @20454
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(20481), // Rule ID 16664 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPXORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16664,
        GIR_Done,
      // Label 637: @20481
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(20508), // Rule ID 16688 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PXORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16688,
        GIR_Done,
      // Label 638: @20508
      GIM_Reject,
    // Label 633: @20509
    GIM_Reject,
    // Label 553: @20510
    GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(20881),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(20753), // Rule ID 20494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src, immAllOnesV:{ *:[v4i64] })  =>  (EXTRACT_SUBREG:{ *:[v4i64] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20494,
        GIR_EraseRootFromParent_Done,
      // Label 640: @20753
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(20799), // Rule ID 20502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src, immAllOnesV:{ *:[v4i64] })  =>  (VPTERNLOGQZ256rri:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src, VR256X:{ *:[v4i64] }:$src, VR256X:{ *:[v4i64] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20502,
        GIR_EraseRootFromParent_Done,
      // Label 641: @20799
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(20826), // Rule ID 2114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPXORYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2114,
        GIR_Done,
      // Label 642: @20826
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(20853), // Rule ID 5755 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPXORQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5755,
        GIR_Done,
      // Label 643: @20853
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(20880), // Rule ID 16635 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VXORPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16635,
        GIR_Done,
      // Label 644: @20880
      GIM_Reject,
    // Label 639: @20881
    GIM_Reject,
    // Label 554: @20882
    GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(21652),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(20957), // Rule ID 22104 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (KXNORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22104,
        GIR_EraseRootFromParent_Done,
      // Label 646: @20957
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(21074), // Rule ID 23790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 23790,
        GIR_EraseRootFromParent_Done,
      // Label 647: @21074
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(21137), // Rule ID 4375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2), immAllOnesV:{ *:[v8i1] })  =>  (KXNORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4375,
        GIR_EraseRootFromParent_Done,
      // Label 648: @21137
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(21255), // Rule ID 18029 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2), immAllOnesV:{ *:[v8i1] })  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18029,
        GIR_EraseRootFromParent_Done,
      // Label 649: @21255
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(21315), // Rule ID 22105 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (KXNORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22105,
        GIR_EraseRootFromParent_Done,
      // Label 650: @21315
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(21432), // Rule ID 23791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 23791,
        GIR_EraseRootFromParent_Done,
      // Label 651: @21432
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(21467), // Rule ID 4363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src, immAllOnesV:{ *:[v8i1] })  =>  (KNOTBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4363,
        GIR_EraseRootFromParent_Done,
      // Label 652: @21467
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(21542), // Rule ID 18013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src, immAllOnesV:{ *:[v8i1] })  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KNOTWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18013,
        GIR_EraseRootFromParent_Done,
      // Label 653: @21542
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(21565), // Rule ID 4379 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KXORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4379,
        GIR_Done,
      // Label 654: @21565
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(21651), // Rule ID 18033 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18033,
        GIR_EraseRootFromParent_Done,
      // Label 655: @21651
      GIM_Reject,
    // Label 645: @21652
    GIM_Reject,
    // Label 555: @21653
    GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(22024),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(21896), // Rule ID 20488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src, immAllOnesV:{ *:[v8i16] })  =>  (EXTRACT_SUBREG:{ *:[v8i16] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v8i16] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v8i16] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v8i16] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20488,
        GIR_EraseRootFromParent_Done,
      // Label 657: @21896
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(21942), // Rule ID 20496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src, immAllOnesV:{ *:[v8i16] })  =>  (VPTERNLOGQZ128rri:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src, VR128X:{ *:[v8i16] }:$src, VR128X:{ *:[v8i16] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20496,
        GIR_EraseRootFromParent_Done,
      // Label 658: @21942
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(21969), // Rule ID 16663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPXORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16663,
        GIR_Done,
      // Label 659: @21969
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(21996), // Rule ID 16687 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PXORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16687,
        GIR_Done,
      // Label 660: @21996
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(22023), // Rule ID 18601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPXORQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18601,
        GIR_Done,
      // Label 661: @22023
      GIM_Reject,
    // Label 656: @22024
    GIM_Reject,
    // Label 556: @22025
    GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(22396),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(22268), // Rule ID 20493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src, immAllOnesV:{ *:[v8i32] })  =>  (EXTRACT_SUBREG:{ *:[v8i32] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20493,
        GIR_EraseRootFromParent_Done,
      // Label 663: @22268
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(22314), // Rule ID 20501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src, immAllOnesV:{ *:[v8i32] })  =>  (VPTERNLOGQZ256rri:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src, VR256X:{ *:[v8i32] }:$src, VR256X:{ *:[v8i32] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20501,
        GIR_EraseRootFromParent_Done,
      // Label 664: @22314
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(22341), // Rule ID 5782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPXORDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5782,
        GIR_Done,
      // Label 665: @22341
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(22368), // Rule ID 16608 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPXORYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16608,
        GIR_Done,
      // Label 666: @22368
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(22395), // Rule ID 16634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VXORPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16634,
        GIR_Done,
      // Label 667: @22395
      GIM_Reject,
    // Label 662: @22396
    GIM_Reject,
    // Label 557: @22397
    GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(22474),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(22454), // Rule ID 20486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src, immAllOnesV:{ *:[v8i64] })  =>  (VPTERNLOGQZrri:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src, VR512:{ *:[v8i64] }:$src, VR512:{ *:[v8i64] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20486,
        GIR_EraseRootFromParent_Done,
      // Label 669: @22454
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(22473), // Rule ID 5746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPXORQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5746,
        GIR_Done,
      // Label 670: @22473
      GIM_Reject,
    // Label 668: @22474
    GIM_Reject,
    // Label 558: @22475
    GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(22732),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(22550), // Rule ID 22106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }), VK16:{ *:[v16i1] }:$src2)  =>  (KXNORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22106,
        GIR_EraseRootFromParent_Done,
      // Label 672: @22550
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(22613), // Rule ID 4376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2), immAllOnesV:{ *:[v16i1] })  =>  (KXNORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4376,
        GIR_EraseRootFromParent_Done,
      // Label 673: @22613
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(22673), // Rule ID 22107 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src2, (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }))  =>  (KXNORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22107,
        GIR_EraseRootFromParent_Done,
      // Label 674: @22673
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(22708), // Rule ID 4364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src, immAllOnesV:{ *:[v16i1] })  =>  (KNOTWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4364,
        GIR_EraseRootFromParent_Done,
      // Label 675: @22708
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(22731), // Rule ID 4380 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        // (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KXORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4380,
        GIR_Done,
      // Label 676: @22731
      GIM_Reject,
    // Label 671: @22732
    GIM_Reject,
    // Label 559: @22733
    GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(23104),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(22976), // Rule ID 20487 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src, immAllOnesV:{ *:[v16i8] })  =>  (EXTRACT_SUBREG:{ *:[v16i8] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v16i8] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v16i8] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v16i8] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20487,
        GIR_EraseRootFromParent_Done,
      // Label 678: @22976
      GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(23022), // Rule ID 20495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src, immAllOnesV:{ *:[v16i8] })  =>  (VPTERNLOGQZ128rri:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src, VR128X:{ *:[v16i8] }:$src, VR128X:{ *:[v16i8] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20495,
        GIR_EraseRootFromParent_Done,
      // Label 679: @23022
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(23049), // Rule ID 16662 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPXORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16662,
        GIR_Done,
      // Label 680: @23049
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(23076), // Rule ID 16686 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PXORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16686,
        GIR_Done,
      // Label 681: @23076
      GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(23103), // Rule ID 18600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPXORQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18600,
        GIR_Done,
      // Label 682: @23103
      GIM_Reject,
    // Label 677: @23104
    GIM_Reject,
    // Label 560: @23105
    GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(23476),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(23348), // Rule ID 20492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src, immAllOnesV:{ *:[v16i16] })  =>  (EXTRACT_SUBREG:{ *:[v16i16] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20492,
        GIR_EraseRootFromParent_Done,
      // Label 684: @23348
      GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(23394), // Rule ID 20500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src, immAllOnesV:{ *:[v16i16] })  =>  (VPTERNLOGQZ256rri:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src, VR256X:{ *:[v16i16] }:$src, VR256X:{ *:[v16i16] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20500,
        GIR_EraseRootFromParent_Done,
      // Label 685: @23394
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(23421), // Rule ID 16607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPXORYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16607,
        GIR_Done,
      // Label 686: @23421
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(23448), // Rule ID 16633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VXORPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16633,
        GIR_Done,
      // Label 687: @23448
      GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(23475), // Rule ID 18617 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPXORQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18617,
        GIR_Done,
      // Label 688: @23475
      GIM_Reject,
    // Label 683: @23476
    GIM_Reject,
    // Label 561: @23477
    GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(23554),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(23534), // Rule ID 20485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src, immAllOnesV:{ *:[v16i32] })  =>  (VPTERNLOGQZrri:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src, VR512:{ *:[v16i32] }:$src, VR512:{ *:[v16i32] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20485,
        GIR_EraseRootFromParent_Done,
      // Label 690: @23534
      GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(23553), // Rule ID 5773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPXORDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORDZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5773,
        GIR_Done,
      // Label 691: @23553
      GIM_Reject,
    // Label 689: @23554
    GIM_Reject,
    // Label 562: @23555
    GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(23812),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(23630), // Rule ID 22108 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }), VK32:{ *:[v32i1] }:$src2)  =>  (KXNORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22108,
        GIR_EraseRootFromParent_Done,
      // Label 693: @23630
      GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(23693), // Rule ID 4377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2), immAllOnesV:{ *:[v32i1] })  =>  (KXNORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4377,
        GIR_EraseRootFromParent_Done,
      // Label 694: @23693
      GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(23753), // Rule ID 22109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src2, (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }))  =>  (KXNORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22109,
        GIR_EraseRootFromParent_Done,
      // Label 695: @23753
      GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(23788), // Rule ID 4365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src, immAllOnesV:{ *:[v32i1] })  =>  (KNOTDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4365,
        GIR_EraseRootFromParent_Done,
      // Label 696: @23788
      GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(23811), // Rule ID 4381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        // (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KXORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4381,
        GIR_Done,
      // Label 697: @23811
      GIM_Reject,
    // Label 692: @23812
    GIM_Reject,
    // Label 563: @23813
    GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(24184),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(24056), // Rule ID 20491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src, immAllOnesV:{ *:[v32i8] })  =>  (EXTRACT_SUBREG:{ *:[v32i8] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v32i8] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v32i8] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v32i8] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20491,
        GIR_EraseRootFromParent_Done,
      // Label 699: @24056
      GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(24102), // Rule ID 20499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src, immAllOnesV:{ *:[v32i8] })  =>  (VPTERNLOGQZ256rri:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src, VR256X:{ *:[v32i8] }:$src, VR256X:{ *:[v32i8] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20499,
        GIR_EraseRootFromParent_Done,
      // Label 700: @24102
      GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(24129), // Rule ID 16606 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPXORYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16606,
        GIR_Done,
      // Label 701: @24129
      GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(24156), // Rule ID 16632 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VXORPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16632,
        GIR_Done,
      // Label 702: @24156
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(24183), // Rule ID 18616 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPXORQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18616,
        GIR_Done,
      // Label 703: @24183
      GIM_Reject,
    // Label 698: @24184
    GIM_Reject,
    // Label 564: @24185
    GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(24262),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(24242), // Rule ID 20484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src, immAllOnesV:{ *:[v32i16] })  =>  (VPTERNLOGQZrri:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src, VR512:{ *:[v32i16] }:$src, VR512:{ *:[v32i16] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20484,
        GIR_EraseRootFromParent_Done,
      // Label 705: @24242
      GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(24261), // Rule ID 18633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPXORQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18633,
        GIR_Done,
      // Label 706: @24261
      GIM_Reject,
    // Label 704: @24262
    GIM_Reject,
    // Label 565: @24263
    GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(24520),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(24338), // Rule ID 22110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }), VK64:{ *:[v64i1] }:$src2)  =>  (KXNORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22110,
        GIR_EraseRootFromParent_Done,
      // Label 708: @24338
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(24401), // Rule ID 4378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2), immAllOnesV:{ *:[v64i1] })  =>  (KXNORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4378,
        GIR_EraseRootFromParent_Done,
      // Label 709: @24401
      GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(24461), // Rule ID 22111 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src2, (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }))  =>  (KXNORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22111,
        GIR_EraseRootFromParent_Done,
      // Label 710: @24461
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(24496), // Rule ID 4366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src, immAllOnesV:{ *:[v64i1] })  =>  (KNOTQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4366,
        GIR_EraseRootFromParent_Done,
      // Label 711: @24496
      GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(24519), // Rule ID 4382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        // (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KXORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4382,
        GIR_Done,
      // Label 712: @24519
      GIM_Reject,
    // Label 707: @24520
    GIM_Reject,
    // Label 566: @24521
    GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(24598),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(24578), // Rule ID 20483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src, immAllOnesV:{ *:[v64i8] })  =>  (VPTERNLOGQZrri:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src, VR512:{ *:[v64i8] }:$src, VR512:{ *:[v64i8] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20483,
        GIR_EraseRootFromParent_Done,
      // Label 714: @24578
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(24597), // Rule ID 18632 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPXORQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18632,
        GIR_Done,
      // Label 715: @24597
      GIM_Reject,
    // Label 713: @24598
    GIM_Reject,
    // Label 567: @24599
    GIM_Reject,
    // Label 6: @24600
    GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(24766),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(16), GIMT_Encode2(24), /*)*//*default:*//*Label 720*/ GIMT_Encode4(24765),
      /*GILLT_v16s1*//*Label 717*/ GIMT_Encode4(24651), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v32s1*//*Label 718*/ GIMT_Encode4(24689), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v64s1*//*Label 719*/ GIMT_Encode4(24727),
      // Label 717: @24651
      GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(24688), // Rule ID 18037 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (concat_vectors:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KUNPCKBWrr:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK8:{ *:[v8i1] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KUNPCKBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18037,
        GIR_EraseRootFromParent_Done,
      // Label 721: @24688
      GIM_Reject,
      // Label 718: @24689
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(24726), // Rule ID 18038 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        // (concat_vectors:{ *:[v32i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KUNPCKWDrr:{ *:[v32i1] } VK16:{ *:[v16i1] }:$src2, VK16:{ *:[v16i1] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KUNPCKWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18038,
        GIR_EraseRootFromParent_Done,
      // Label 722: @24726
      GIM_Reject,
      // Label 719: @24727
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(24764), // Rule ID 18039 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        // (concat_vectors:{ *:[v64i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KUNPCKDQrr:{ *:[v64i1] } VK32:{ *:[v32i1] }:$src2, VK32:{ *:[v32i1] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KUNPCKDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18039,
        GIR_EraseRootFromParent_Done,
      // Label 723: @24764
      GIM_Reject,
      // Label 720: @24765
      GIM_Reject,
    // Label 716: @24766
    GIM_Reject,
    // Label 7: @24767
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(24), /*)*//*default:*//*Label 732*/ GIMT_Encode4(26505),
    /*GILLT_s8*//*Label 724*/ GIMT_Encode4(24870),
    /*GILLT_s16*//*Label 725*/ GIMT_Encode4(24928),
    /*GILLT_s32*//*Label 726*/ GIMT_Encode4(25743),
    /*GILLT_s64*//*Label 727*/ GIMT_Encode4(25971), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 728*/ GIMT_Encode4(26199), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 729*/ GIMT_Encode4(26281), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v32s1*//*Label 730*/ GIMT_Encode4(26363), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v64s1*//*Label 731*/ GIMT_Encode4(26434),
    // Label 724: @24870
    GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(24927), // Rule ID 17968 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      // (bitconvert:{ *:[i8] } VK8:{ *:[v8i1] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i32] } VK8:{ *:[v8i1] }:$src, GR32:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17968,
      GIR_EraseRootFromParent_Done,
    // Label 733: @24927
    GIM_Reject,
    // Label 725: @24928
    GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(24985), // Rule ID 17965 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      // (bitconvert:{ *:[i16] } VK16:{ *:[v16i1] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i32] } VK16:{ *:[v16i1] }:$src, GR32:{ *:[i32] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17965,
      GIR_EraseRootFromParent_Done,
    // Label 734: @24985
    GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(25086), // Rule ID 20689 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (bitconvert:{ *:[f16] } GR16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (VMOVW2SHrr:{ *:[f128] } (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] })), FR16X:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/2, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVW2SHrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      // GIR_Coverage, 20689,
      GIR_EraseRootFromParent_Done,
    // Label 735: @25086
    GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(25163), // Rule ID 20702 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      // (bitconvert:{ *:[i16] } FR16X:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (VMOVSH2Wrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[f128] } FR16X:{ *:[f16] }:$src, VR128X:{ *:[i32] })), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVSH2Wrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20702,
      GIR_EraseRootFromParent_Done,
    // Label 736: @25163
    GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(25239), // Rule ID 16850 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[i16] } f16:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (VPEXTRWrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v8i16] } FR16:{ *:[f16] }:$src, VR128:{ *:[i32] }), 0:{ *:[i8] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPEXTRWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 16850,
      GIR_EraseRootFromParent_Done,
    // Label 737: @25239
    GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(25356), // Rule ID 16851 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16RegClassID),
      // (bitconvert:{ *:[f16] } i16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (VPINSRWrr:{ *:[f128] } (IMPLICIT_DEF:{ *:[v8i16] }), (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), 0:{ *:[i8] }), FR16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/3, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPINSRWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16RegClassID),
      // GIR_Coverage, 16851,
      GIR_EraseRootFromParent_Done,
    // Label 738: @25356
    GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(25432), // Rule ID 16847 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[i16] } f16:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (PEXTRWrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v8i16] } FR16:{ *:[f16] }:$src, VR128:{ *:[i32] }), 0:{ *:[i8] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::PEXTRWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 16847,
      GIR_EraseRootFromParent_Done,
    // Label 739: @25432
    GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(25549), // Rule ID 16848 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16RegClassID),
      // (bitconvert:{ *:[f16] } i16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (PINSRWrr:{ *:[f128] } (IMPLICIT_DEF:{ *:[v8i16] }), (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), 0:{ *:[i8] }), FR16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/3, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::PINSRWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16RegClassID),
      // GIR_Coverage, 16848,
      GIR_EraseRootFromParent_Done,
    // Label 740: @25549
    GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(25625), // Rule ID 20385 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[i16] } f16:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (VPEXTRWZrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v8i16] } FR16X:{ *:[f16] }:$src, VR128X:{ *:[i32] }), 0:{ *:[i8] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPEXTRWZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20385,
      GIR_EraseRootFromParent_Done,
    // Label 741: @25625
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(25742), // Rule ID 20386 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      // (bitconvert:{ *:[f16] } i16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (VPINSRWZrr:{ *:[f128] } (IMPLICIT_DEF:{ *:[v8i16] }), (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), 0:{ *:[i8] }), FR16X:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/3, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPINSRWZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      // GIR_Coverage, 20386,
      GIR_EraseRootFromParent_Done,
    // Label 742: @25742
    GIM_Reject,
    // Label 726: @25743
    GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(25769), // Rule ID 2863 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[f32] } GR32:{ *:[i32] }:$src)  =>  (VMOVDI2SSrr:{ *:[f32] } GR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVDI2SSrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2863,
      GIR_Done,
    // Label 743: @25769
    GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(25795), // Rule ID 2864 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[f32] } GR32:{ *:[i32] }:$src)  =>  (MOVDI2SSrr:{ *:[f32] } GR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVDI2SSrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2864,
      GIR_Done,
    // Label 744: @25795
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(25821), // Rule ID 2873 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (bitconvert:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (VMOVSS2DIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSS2DIrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2873,
      GIR_Done,
    // Label 745: @25821
    GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(25847), // Rule ID 2874 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (bitconvert:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (MOVSS2DIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVSS2DIrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2874,
      GIR_Done,
    // Label 746: @25847
    GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(25873), // Rule ID 4550 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[f32] } GR32:{ *:[i32] }:$src)  =>  (VMOVDI2SSZrr:{ *:[f32] } GR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVDI2SSZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4550,
      GIR_Done,
    // Label 747: @25873
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(25899), // Rule ID 4555 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      // (bitconvert:{ *:[i32] } FR32X:{ *:[f32] }:$src)  =>  (VMOVSS2DIZrr:{ *:[i32] } FR32X:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSS2DIZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4555,
      GIR_Done,
    // Label 748: @25899
    GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(25926), // Rule ID 17976 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      // (bitconvert:{ *:[i32] } VK32:{ *:[v32i1] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } VK32:{ *:[v32i1] }:$src, GR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17976,
      GIR_Done,
    // Label 749: @25926
    GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(25970), // Rule ID 18456 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      // (bitconvert:{ *:[f32] } VK32:{ *:[v32i1] }:$src)  =>  (VMOVDI2SSZrr:{ *:[f32] } (KMOVDrk:{ *:[i32] } VK32:{ *:[v32i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KMOVDrk),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMOVDI2SSZrr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18456,
      GIR_EraseRootFromParent_Done,
    // Label 750: @25970
    GIM_Reject,
    // Label 727: @25971
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(25997), // Rule ID 2858 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // (bitconvert:{ *:[f64] } GR64:{ *:[i64] }:$src)  =>  (VMOV64toSDrr:{ *:[f64] } GR64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOV64toSDrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2858,
      GIR_Done,
    // Label 751: @25997
    GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(26023), // Rule ID 2862 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // (bitconvert:{ *:[f64] } GR64:{ *:[i64] }:$src)  =>  (MOV64toSDrr:{ *:[f64] } GR64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOV64toSDrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2862,
      GIR_Done,
    // Label 752: @26023
    GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(26049), // Rule ID 2871 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (bitconvert:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VMOVSDto64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSDto64rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2871,
      GIR_Done,
    // Label 753: @26049
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(26075), // Rule ID 2872 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (bitconvert:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (MOVSDto64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVSDto64rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2872,
      GIR_Done,
    // Label 754: @26075
    GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(26101), // Rule ID 4548 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // (bitconvert:{ *:[f64] } GR64:{ *:[i64] }:$src)  =>  (VMOV64toSDZrr:{ *:[f64] } GR64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOV64toSDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4548,
      GIR_Done,
    // Label 755: @26101
    GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(26127), // Rule ID 4549 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      // (bitconvert:{ *:[i64] } FR64X:{ *:[f64] }:$src)  =>  (VMOVSDto64Zrr:{ *:[i64] } FR64X:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSDto64Zrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4549,
      GIR_Done,
    // Label 756: @26127
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(26154), // Rule ID 17978 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      // (bitconvert:{ *:[i64] } VK64:{ *:[v64i1] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i64] } VK64:{ *:[v64i1] }:$src, GR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      // GIR_Coverage, 17978,
      GIR_Done,
    // Label 757: @26154
    GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(26198), // Rule ID 18458 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      // (bitconvert:{ *:[f64] } VK64:{ *:[v64i1] }:$src)  =>  (VMOV64toSDZrr:{ *:[f64] } (KMOVQrk:{ *:[i64] } VK64:{ *:[v64i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KMOVQrk),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMOV64toSDZrr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18458,
      GIR_EraseRootFromParent_Done,
    // Label 758: @26198
    GIM_Reject,
    // Label 728: @26199
    GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(26280), // Rule ID 17967 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (bitconvert:{ *:[v8i1] } GR8:{ *:[i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src, sub_8bit:{ *:[i32] }), VK8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
      // GIR_Coverage, 17967,
      GIR_EraseRootFromParent_Done,
    // Label 759: @26280
    GIM_Reject,
    // Label 729: @26281
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(26362), // Rule ID 17964 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (bitconvert:{ *:[v16i1] } GR16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), VK16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/1, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
      // GIR_Coverage, 17964,
      GIR_EraseRootFromParent_Done,
    // Label 760: @26362
    GIM_Reject,
    // Label 730: @26363
    GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(26433),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(26395), // Rule ID 17975 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (bitconvert:{ *:[v32i1] } GR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v32i1] } GR32:{ *:[i32] }:$src, VK32:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK32RegClassID),
        // GIR_Coverage, 17975,
        GIR_Done,
      // Label 762: @26395
      GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(26432), // Rule ID 18455 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
        // (bitconvert:{ *:[v32i1] } FR32X:{ *:[f32] }:$src)  =>  (KMOVDkr:{ *:[v32i1] } (VMOVSS2DIZrr:{ *:[i32] } FR32X:{ *:[f32] }:$src))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVSS2DIZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KMOVDkr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18455,
        GIR_EraseRootFromParent_Done,
      // Label 763: @26432
      GIM_Reject,
    // Label 761: @26433
    GIM_Reject,
    // Label 731: @26434
    GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(26504),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(26466), // Rule ID 17977 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (bitconvert:{ *:[v64i1] } GR64:{ *:[i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v64i1] } GR64:{ *:[i64] }:$src, VK64:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK64RegClassID),
        // GIR_Coverage, 17977,
        GIR_Done,
      // Label 765: @26466
      GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(26503), // Rule ID 18457 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
        // (bitconvert:{ *:[v64i1] } FR64X:{ *:[f64] }:$src)  =>  (KMOVQkr:{ *:[v64i1] } (VMOVSDto64Zrr:{ *:[i64] } FR64X:{ *:[f64] }:$src))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVSDto64Zrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KMOVQkr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18457,
        GIR_EraseRootFromParent_Done,
      // Label 766: @26503
      GIM_Reject,
    // Label 764: @26504
    GIM_Reject,
    // Label 732: @26505
    GIM_Reject,
    // Label 8: @26506
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(20), /*)*//*default:*//*Label 775*/ GIMT_Encode4(27367),
    /*GILLT_s32*//*Label 767*/ GIMT_Encode4(26585),
    /*GILLT_s64*//*Label 768*/ GIMT_Encode4(26766), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 769*/ GIMT_Encode4(26947), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 770*/ GIMT_Encode4(26978),
    /*GILLT_v4s64*//*Label 771*/ GIMT_Encode4(27129), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s32*//*Label 772*/ GIMT_Encode4(27190),
    /*GILLT_v8s64*//*Label 773*/ GIMT_Encode4(27278), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s32*//*Label 774*/ GIMT_Encode4(27339),
    // Label 767: @26585
    GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(26615), // Rule ID 1743 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1743,
      GIR_Done,
    // Label 776: @26615
    GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(26645), // Rule ID 1747 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i32] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SIrr:{ *:[i32] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1747,
      GIR_Done,
    // Label 777: @26645
    GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(26675), // Rule ID 1767 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (CVTSS2SIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSS2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1767,
      GIR_Done,
    // Label 778: @26675
    GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(26705), // Rule ID 1771 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i32] } FR64:{ *:[f64] }:$src)  =>  (CVTSD2SIrr:{ *:[i32] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSD2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1771,
      GIR_Done,
    // Label 779: @26705
    GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(26735), // Rule ID 10238 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      // (lrint:{ *:[i32] } FR32X:{ *:[f32] }:$src)  =>  (VCVTSS2SIZrr:{ *:[i32] } FR32X:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SIZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10238,
      GIR_Done,
    // Label 780: @26735
    GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(26765), // Rule ID 10242 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      // (lrint:{ *:[i32] } FR64X:{ *:[f64] }:$src)  =>  (VCVTSD2SIZrr:{ *:[i32] } FR64X:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SIZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10242,
      GIR_Done,
    // Label 781: @26765
    GIM_Reject,
    // Label 768: @26766
    GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(26796), // Rule ID 16499 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16499,
      GIR_Done,
    // Label 782: @26796
    GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(26826), // Rule ID 16501 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16501,
      GIR_Done,
    // Label 783: @26826
    GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(26856), // Rule ID 16503 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (CVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16503,
      GIR_Done,
    // Label 784: @26856
    GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(26886), // Rule ID 16505 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (CVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16505,
      GIR_Done,
    // Label 785: @26886
    GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(26916), // Rule ID 19739 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SI64Zrr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19739,
      GIR_Done,
    // Label 786: @26916
    GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(26946), // Rule ID 19741 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SI64Zrr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19741,
      GIR_Done,
    // Label 787: @26946
    GIM_Reject,
    // Label 769: @26947
    GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(26977), // Rule ID 19964 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (lrint:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)  =>  (VCVTPD2QQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ128rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19964,
      GIR_Done,
    // Label 788: @26977
    GIM_Reject,
    // Label 770: @26978
    GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(27008), // Rule ID 16553 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      // (lrint:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)  =>  (VCVTPS2DQrr:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16553,
      GIR_Done,
    // Label 789: @27008
    GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(27038), // Rule ID 16557 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
      // (lrint:{ *:[v4i32] } VR256:{ *:[v4f64] }:$src)  =>  (VCVTPD2DQYrr:{ *:[v4i32] } VR256:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2DQYrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16557,
      GIR_Done,
    // Label 790: @27038
    GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(27068), // Rule ID 16559 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      // (lrint:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)  =>  (CVTPS2DQrr:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTPS2DQrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16559,
      GIR_Done,
    // Label 791: @27068
    GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(27098), // Rule ID 19936 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (lrint:{ *:[v4i32] } VR128X:{ *:[v4f32] }:$src)  =>  (VCVTPS2DQZ128rr:{ *:[v4i32] } VR128X:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQZ128rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19936,
      GIR_Done,
    // Label 792: @27098
    GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(27128), // Rule ID 19940 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v4i32] } VR256X:{ *:[v4f64] }:$src)  =>  (VCVTPD2DQZ256rr:{ *:[v4i32] } VR256X:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2DQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19940,
      GIR_Done,
    // Label 793: @27128
    GIM_Reject,
    // Label 771: @27129
    GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(27159), // Rule ID 19960 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (lrint:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)  =>  (VCVTPS2QQZ256rr:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19960,
      GIR_Done,
    // Label 794: @27159
    GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(27189), // Rule ID 19966 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)  =>  (VCVTPD2QQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19966,
      GIR_Done,
    // Label 795: @27189
    GIM_Reject,
    // Label 772: @27190
    GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(27220), // Rule ID 16555 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
      // (lrint:{ *:[v8i32] } VR256:{ *:[v8f32] }:$src)  =>  (VCVTPS2DQYrr:{ *:[v8i32] } VR256:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQYrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16555,
      GIR_Done,
    // Label 796: @27220
    GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(27250), // Rule ID 19938 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v8i32] } VR256X:{ *:[v8f32] }:$src)  =>  (VCVTPS2DQZ256rr:{ *:[v8i32] } VR256X:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19938,
      GIR_Done,
    // Label 797: @27250
    GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(27277), // Rule ID 19944 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (lrint:{ *:[v8i32] } VR512:{ *:[v8f64] }:$src)  =>  (VCVTPD2DQZrr:{ *:[v8i32] } VR512:{ *:[v8f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2DQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19944,
      GIR_Done,
    // Label 798: @27277
    GIM_Reject,
    // Label 773: @27278
    GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(27308), // Rule ID 19972 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)  =>  (VCVTPS2QQZrr:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19972,
      GIR_Done,
    // Label 799: @27308
    GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(27338), // Rule ID 19976 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (lrint:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)  =>  (VCVTPD2QQZrr:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19976,
      GIR_Done,
    // Label 800: @27338
    GIM_Reject,
    // Label 774: @27339
    GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(27366), // Rule ID 19942 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (lrint:{ *:[v16i32] } VR512:{ *:[v16f32] }:$src)  =>  (VCVTPS2DQZrr:{ *:[v16i32] } VR512:{ *:[v16f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19942,
      GIR_Done,
    // Label 801: @27366
    GIM_Reject,
    // Label 775: @27367
    GIM_Reject,
    // Label 9: @27368
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(4), GIMT_Encode2(16), /*)*//*default:*//*Label 806*/ GIMT_Encode4(27761),
    /*GILLT_s64*//*Label 802*/ GIMT_Encode4(27427), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 803*/ GIMT_Encode4(27608), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s64*//*Label 804*/ GIMT_Encode4(27639), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s64*//*Label 805*/ GIMT_Encode4(27700),
    // Label 802: @27427
    GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(27457), // Rule ID 1745 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (llrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1745,
      GIR_Done,
    // Label 807: @27457
    GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(27487), // Rule ID 1749 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (llrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1749,
      GIR_Done,
    // Label 808: @27487
    GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(27517), // Rule ID 1769 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (llrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (CVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1769,
      GIR_Done,
    // Label 809: @27517
    GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(27547), // Rule ID 1773 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (llrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (CVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1773,
      GIR_Done,
    // Label 810: @27547
    GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(27577), // Rule ID 10240 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      // (llrint:{ *:[i64] } FR32X:{ *:[f32] }:$src)  =>  (VCVTSS2SI64Zrr:{ *:[i64] } FR32X:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10240,
      GIR_Done,
    // Label 811: @27577
    GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(27607), // Rule ID 10244 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      // (llrint:{ *:[i64] } FR64X:{ *:[f64] }:$src)  =>  (VCVTSD2SI64Zrr:{ *:[i64] } FR64X:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10244,
      GIR_Done,
    // Label 812: @27607
    GIM_Reject,
    // Label 803: @27608
    GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(27638), // Rule ID 19968 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (llrint:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)  =>  (VCVTPD2QQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ128rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19968,
      GIR_Done,
    // Label 813: @27638
    GIM_Reject,
    // Label 804: @27639
    GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(27669), // Rule ID 19962 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (llrint:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)  =>  (VCVTPS2QQZ256rr:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19962,
      GIR_Done,
    // Label 814: @27669
    GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(27699), // Rule ID 19970 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (llrint:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)  =>  (VCVTPD2QQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19970,
      GIR_Done,
    // Label 815: @27699
    GIM_Reject,
    // Label 805: @27700
    GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(27730), // Rule ID 19974 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (llrint:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)  =>  (VCVTPS2QQZrr:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19974,
      GIR_Done,
    // Label 816: @27730
    GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(27760), // Rule ID 19978 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (llrint:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)  =>  (VCVTPD2QQZrr:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19978,
      GIR_Done,
    // Label 817: @27760
    GIM_Reject,
    // Label 806: @27761
    GIM_Reject,
    // Label 10: @27762
    GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(28895),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(27806), // Rule ID 1517 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphsubwd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13847:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHSUBWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1517,
        GIR_EraseRootFromParent_Done,
      // Label 819: @27806
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(27842), // Rule ID 1519 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphsubdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13846:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src)  =>  (VPHSUBDQrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1519,
        GIR_EraseRootFromParent_Done,
      // Label 820: @27842
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(27878), // Rule ID 1521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphsubbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13845:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHSUBBWrr:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1521,
        GIR_EraseRootFromParent_Done,
      // Label 821: @27878
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(27914), // Rule ID 1523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddwq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13844:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDWQrr:{ *:[v2i64] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDWQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1523,
        GIR_EraseRootFromParent_Done,
      // Label 822: @27914
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(27950), // Rule ID 1525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddwd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13843:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1525,
        GIR_EraseRootFromParent_Done,
      // Label 823: @27950
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(27986), // Rule ID 1527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphadduwq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13842:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDUWQrr:{ *:[v2i64] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUWQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1527,
        GIR_EraseRootFromParent_Done,
      // Label 824: @27986
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(28022), // Rule ID 1529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphadduwd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13841:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDUWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1529,
        GIR_EraseRootFromParent_Done,
      // Label 825: @28022
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(28058), // Rule ID 1531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddudq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13840:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src)  =>  (VPHADDUDQrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1531,
        GIR_EraseRootFromParent_Done,
      // Label 826: @28058
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(28094), // Rule ID 1533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddubw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13839:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDUBWrr:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1533,
        GIR_EraseRootFromParent_Done,
      // Label 827: @28094
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(28130), // Rule ID 1535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddubq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13838:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDUBQrr:{ *:[v2i64] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUBQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1535,
        GIR_EraseRootFromParent_Done,
      // Label 828: @28130
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(28166), // Rule ID 1537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddubd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13837:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDUBDrr:{ *:[v4i32] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUBDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1537,
        GIR_EraseRootFromParent_Done,
      // Label 829: @28166
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(28202), // Rule ID 1539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphadddq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13836:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src)  =>  (VPHADDDQrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1539,
        GIR_EraseRootFromParent_Done,
      // Label 830: @28202
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(28238), // Rule ID 1541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13835:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDBWrr:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1541,
        GIR_EraseRootFromParent_Done,
      // Label 831: @28238
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(28274), // Rule ID 1543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddbq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13834:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDBQrr:{ *:[v2i64] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDBQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1543,
        GIR_EraseRootFromParent_Done,
      // Label 832: @28274
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(28310), // Rule ID 1545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddbd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13833:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDBDrr:{ *:[v4i32] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDBDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1545,
        GIR_EraseRootFromParent_Done,
      // Label 833: @28310
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(28346), // Rule ID 1547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13828:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VFRCZSSrr:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZSSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1547,
        GIR_EraseRootFromParent_Done,
      // Label 834: @28346
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(28382), // Rule ID 1551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_ps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13825:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VFRCZPSrr:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1551,
        GIR_EraseRootFromParent_Done,
      // Label 835: @28382
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(28418), // Rule ID 1553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_ps_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8f32] } 13826:{ *:[iPTR] }, VR256:{ *:[v8f32] }:$src)  =>  (VFRCZPSYrr:{ *:[v8f32] } VR256:{ *:[v8f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPSYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1553,
        GIR_EraseRootFromParent_Done,
      // Label 836: @28418
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(28454), // Rule ID 1555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_sd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 13827:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src)  =>  (VFRCZSDrr:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZSDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1555,
        GIR_EraseRootFromParent_Done,
      // Label 837: @28454
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(28490), // Rule ID 1559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_pd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 13823:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src)  =>  (VFRCZPDrr:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1559,
        GIR_EraseRootFromParent_Done,
      // Label 838: @28490
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(28526), // Rule ID 1561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_pd_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f64] } 13824:{ *:[iPTR] }, VR256:{ *:[v4f64] }:$src)  =>  (VFRCZPDYrr:{ *:[v4f64] } VR256:{ *:[v4f64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1561,
        GIR_EraseRootFromParent_Done,
      // Label 839: @28526
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(28562), // Rule ID 3311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesimc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12508:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1)  =>  (VAESIMCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESIMCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3311,
        GIR_EraseRootFromParent_Done,
      // Label 840: @28562
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(28598), // Rule ID 3313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesimc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12508:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1)  =>  (AESIMCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESIMCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3313,
        GIR_EraseRootFromParent_Done,
      // Label 841: @28598
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(28634), // Rule ID 3503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXNECONVERT),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vcvtneps2bf16128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8bf16] } 13785:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VCVTNEPS2BF16rr:{ *:[v8bf16] } VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VCVTNEPS2BF16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3503,
        GIR_EraseRootFromParent_Done,
      // Label 842: @28634
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(28670), // Rule ID 3505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXNECONVERT),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vcvtneps2bf16256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8bf16] } 13786:{ *:[iPTR] }, VR256:{ *:[v8f32] }:$src)  =>  (VCVTNEPS2BF16Yrr:{ *:[v8bf16] } VR256:{ *:[v8f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VCVTNEPS2BF16Yrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3505,
        GIR_EraseRootFromParent_Done,
      // Label 843: @28670
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(28708), // Rule ID 16776 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rsqrt_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13593:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (RSQRTSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RSQRTSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16776,
        GIR_EraseRootFromParent_Done,
      // Label 844: @28708
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(28746), // Rule ID 16780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rsqrt_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13593:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VRSQRTSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VRSQRTSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16780,
        GIR_EraseRootFromParent_Done,
      // Label 845: @28746
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(28784), // Rule ID 16796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rcp_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13591:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (RCPSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RCPSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16796,
        GIR_EraseRootFromParent_Done,
      // Label 846: @28784
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(28822), // Rule ID 16800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rcp_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13591:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VRCPSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VRCPSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16800,
        GIR_EraseRootFromParent_Done,
      // Label 847: @28822
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(28858), // Rule ID 20675 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBF16_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vcvtneps2bf16128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v8bf16] } 13785:{ *:[iPTR] }, VR128X:{ *:[v4f32] }:$src)  =>  (VCVTNEPS2BF16Z128rr:{ *:[v8bf16] } VR128X:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VCVTNEPS2BF16Z128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20675,
        GIR_EraseRootFromParent_Done,
      // Label 848: @28858
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(28894), // Rule ID 20677 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBF16_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vcvtneps2bf16256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v8bf16] } 13786:{ *:[iPTR] }, VR256X:{ *:[v8f32] }:$src)  =>  (VCVTNEPS2BF16Z256rr:{ *:[v8bf16] } VR256X:{ *:[v8f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VCVTNEPS2BF16Z256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20677,
        GIR_EraseRootFromParent_Done,
      // Label 849: @28894
      GIM_Reject,
    // Label 818: @28895
    GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(31686),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(28944), // Rule ID 3315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aeskeygenassist),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 12509:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)  =>  (VAESKEYGENASSIST128rr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESKEYGENASSIST128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3315,
        GIR_EraseRootFromParent_Done,
      // Label 851: @28944
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(28985), // Rule ID 3317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aeskeygenassist),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 12509:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)  =>  (AESKEYGENASSIST128rr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESKEYGENASSIST128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3317,
        GIR_EraseRootFromParent_Done,
      // Label 852: @28985
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(29030), // Rule ID 2970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_b_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 13731:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPSIGNBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2970,
        GIR_EraseRootFromParent_Done,
      // Label 853: @29030
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(29075), // Rule ID 2972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_w_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13735:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPSIGNWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2972,
        GIR_EraseRootFromParent_Done,
      // Label 854: @29075
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(29120), // Rule ID 2974 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_d_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13733:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPSIGNDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2974,
        GIR_EraseRootFromParent_Done,
      // Label 855: @29120
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(29165), // Rule ID 2976 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phadd_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13715:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPHADDSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2976,
        GIR_EraseRootFromParent_Done,
      // Label 856: @29165
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(29210), // Rule ID 2978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phsub_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13721:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPHSUBSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2978,
        GIR_EraseRootFromParent_Done,
      // Label 857: @29210
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(29255), // Rule ID 2994 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_psign_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v32s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v32s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v32i8] } 12627:{ *:[iPTR] }, VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPSIGNBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNBYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2994,
        GIR_EraseRootFromParent_Done,
      // Label 858: @29255
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(29300), // Rule ID 2996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_psign_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i16] } 12629:{ *:[iPTR] }, VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPSIGNWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNWYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2996,
        GIR_EraseRootFromParent_Done,
      // Label 859: @29300
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(29345), // Rule ID 2998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_psign_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12628:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPSIGNDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2998,
        GIR_EraseRootFromParent_Done,
      // Label 860: @29345
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(29390), // Rule ID 3000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_phadd_sw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i16] } 12614:{ *:[iPTR] }, VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPHADDSWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDSWYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3000,
        GIR_EraseRootFromParent_Done,
      // Label 861: @29390
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(29435), // Rule ID 3002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_phsub_sw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i16] } 12617:{ *:[iPTR] }, VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPHSUBSWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBSWYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3002,
        GIR_EraseRootFromParent_Done,
      // Label 862: @29435
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(29480), // Rule ID 3012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_b_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 13731:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PSIGNBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PSIGNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3012,
        GIR_EraseRootFromParent_Done,
      // Label 863: @29480
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(29525), // Rule ID 3014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_w_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13735:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PSIGNWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PSIGNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3014,
        GIR_EraseRootFromParent_Done,
      // Label 864: @29525
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(29570), // Rule ID 3016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_d_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13733:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PSIGNDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PSIGNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3016,
        GIR_EraseRootFromParent_Done,
      // Label 865: @29570
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(29615), // Rule ID 3020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phadd_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13715:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PHADDSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PHADDSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3020,
        GIR_EraseRootFromParent_Done,
      // Label 866: @29615
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(29660), // Rule ID 3022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phsub_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13721:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PHSUBSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PHSUBSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3022,
        GIR_EraseRootFromParent_Done,
      // Label 867: @29660
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(29705), // Rule ID 3257 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13689:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (CRC32r32r8:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3257,
        GIR_EraseRootFromParent_Done,
      // Label 868: @29705
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(29750), // Rule ID 3259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13687:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (CRC32r32r16:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3259,
        GIR_EraseRootFromParent_Done,
      // Label 869: @29750
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(29795), // Rule ID 3261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13688:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (CRC32r32r32:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3261,
        GIR_EraseRootFromParent_Done,
      // Label 870: @29795
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(29840), // Rule ID 3263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_64_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 13690:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (CRC32r64r64:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r64r64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3263,
        GIR_EraseRootFromParent_Done,
      // Label 871: @29840
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(29885), // Rule ID 3265 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13689:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (CRC32r32r8_EVEX:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r8_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3265,
        GIR_EraseRootFromParent_Done,
      // Label 872: @29885
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(29930), // Rule ID 3267 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13687:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (CRC32r32r16_EVEX:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r16_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3267,
        GIR_EraseRootFromParent_Done,
      // Label 873: @29930
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(29975), // Rule ID 3269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13688:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (CRC32r32r32_EVEX:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r32_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3269,
        GIR_EraseRootFromParent_Done,
      // Label 874: @29975
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(30020), // Rule ID 3271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_64_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 13690:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (CRC32r64r64_EVEX:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r64r64_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3271,
        GIR_EraseRootFromParent_Done,
      // Label 875: @30020
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(30065), // Rule ID 3275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1nexte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13559:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA1NEXTErr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1NEXTErr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3275,
        GIR_EraseRootFromParent_Done,
      // Label 876: @30065
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(30110), // Rule ID 3277 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13557:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA1MSG1rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3277,
        GIR_EraseRootFromParent_Done,
      // Label 877: @30110
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(30155), // Rule ID 3279 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13558:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA1MSG2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3279,
        GIR_EraseRootFromParent_Done,
      // Label 878: @30155
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(30200), // Rule ID 3283 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha256msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13561:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA256MSG1rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA256MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3283,
        GIR_EraseRootFromParent_Done,
      // Label 879: @30200
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(30245), // Rule ID 3285 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha256msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13562:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA256MSG2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA256MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3285,
        GIR_EraseRootFromParent_Done,
      // Label 880: @30245
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(30290), // Rule ID 3287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12502:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESENCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3287,
        GIR_EraseRootFromParent_Done,
      // Label 881: @30290
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(30335), // Rule ID 3289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12505:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESENCLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3289,
        GIR_EraseRootFromParent_Done,
      // Label 882: @30335
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(30380), // Rule ID 3291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12496:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESDECrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3291,
        GIR_EraseRootFromParent_Done,
      // Label 883: @30380
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(30425), // Rule ID 3293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12499:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESDECLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3293,
        GIR_EraseRootFromParent_Done,
      // Label 884: @30425
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(30470), // Rule ID 3295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12503:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESENCYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3295,
        GIR_EraseRootFromParent_Done,
      // Label 885: @30470
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(30515), // Rule ID 3297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12506:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESENCLASTYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3297,
        GIR_EraseRootFromParent_Done,
      // Label 886: @30515
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(30560), // Rule ID 3299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12497:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESDECYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3299,
        GIR_EraseRootFromParent_Done,
      // Label 887: @30560
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(30605), // Rule ID 3301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12500:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESDECLASTYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3301,
        GIR_EraseRootFromParent_Done,
      // Label 888: @30605
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(30650), // Rule ID 3303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12502:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESENCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESENCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3303,
        GIR_EraseRootFromParent_Done,
      // Label 889: @30650
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(30695), // Rule ID 3305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12505:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESENCLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESENCLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3305,
        GIR_EraseRootFromParent_Done,
      // Label 890: @30695
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(30740), // Rule ID 3307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12496:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESDECrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESDECrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3307,
        GIR_EraseRootFromParent_Done,
      // Label 891: @30740
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(30785), // Rule ID 3309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12499:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESDECLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESDECLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3309,
        GIR_EraseRootFromParent_Done,
      // Label 892: @30785
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(30830), // Rule ID 3326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE4A),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse4a_extrq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13705:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src, VR128:{ *:[v16i8] }:$mask)  =>  (EXTRQ:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::EXTRQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3326,
        GIR_EraseRootFromParent_Done,
      // Label 893: @30830
      GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(30875), // Rule ID 3328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE4A),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse4a_insertq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13707:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src, VR128:{ *:[v2i64] }:$mask)  =>  (INSERTQ:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src, VR128:{ *:[v2i64] }:$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INSERTQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3328,
        GIR_EraseRootFromParent_Done,
      // Label 894: @30875
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(30920), // Rule ID 3507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA512),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsha512msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 13798:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VSHA512MSG1rr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSHA512MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3507,
        GIR_EraseRootFromParent_Done,
      // Label 895: @30920
      GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(30965), // Rule ID 3508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA512),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsha512msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 13799:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VSHA512MSG2rr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSHA512MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3508,
        GIR_EraseRootFromParent_Done,
      // Label 896: @30965
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(31010), // Rule ID 3516 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4key4128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13804:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VSM4KEY4rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4KEY4rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3516,
        GIR_EraseRootFromParent_Done,
      // Label 897: @31010
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(31055), // Rule ID 3518 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4key4256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 13805:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VSM4KEY4Yrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4KEY4Yrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3518,
        GIR_EraseRootFromParent_Done,
      // Label 898: @31055
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(31100), // Rule ID 3520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4rnds4128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13806:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VSM4RNDS4rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4RNDS4rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3520,
        GIR_EraseRootFromParent_Done,
      // Label 899: @31100
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(31145), // Rule ID 3522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4rnds4256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 13807:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VSM4RNDS4Yrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4RNDS4Yrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3522,
        GIR_EraseRootFromParent_Done,
      // Label 900: @31145
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(31190), // Rule ID 13946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12502:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESENCZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13946,
        GIR_EraseRootFromParent_Done,
      // Label 901: @31190
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(31235), // Rule ID 13948 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12503:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESENCZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13948,
        GIR_EraseRootFromParent_Done,
      // Label 902: @31235
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(31280), // Rule ID 13950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12504:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESENCZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13950,
        GIR_EraseRootFromParent_Done,
      // Label 903: @31280
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(31325), // Rule ID 13952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12505:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESENCLASTZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13952,
        GIR_EraseRootFromParent_Done,
      // Label 904: @31325
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(31370), // Rule ID 13954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12506:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESENCLASTZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13954,
        GIR_EraseRootFromParent_Done,
      // Label 905: @31370
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(31415), // Rule ID 13956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12507:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESENCLASTZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13956,
        GIR_EraseRootFromParent_Done,
      // Label 906: @31415
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(31460), // Rule ID 13958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12496:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESDECZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13958,
        GIR_EraseRootFromParent_Done,
      // Label 907: @31460
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(31505), // Rule ID 13960 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12497:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESDECZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13960,
        GIR_EraseRootFromParent_Done,
      // Label 908: @31505
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(31550), // Rule ID 13962 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12498:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESDECZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13962,
        GIR_EraseRootFromParent_Done,
      // Label 909: @31550
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(31595), // Rule ID 13964 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12499:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESDECLASTZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13964,
        GIR_EraseRootFromParent_Done,
      // Label 910: @31595
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(31640), // Rule ID 13966 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12500:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESDECLASTZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13966,
        GIR_EraseRootFromParent_Done,
      // Label 911: @31640
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(31685), // Rule ID 13968 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12501:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESDECLASTZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13968,
        GIR_EraseRootFromParent_Done,
      // Label 912: @31685
      GIM_Reject,
    // Label 850: @31686
    GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(33969),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(31744), // Rule ID 3199 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_mpsadbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8i16] } 13676:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VMPSADBWrri:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMPSADBWrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3199,
        GIR_EraseRootFromParent_Done,
      // Label 914: @31744
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(31794), // Rule ID 3201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dpps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4f32] } 13674:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VDPPSrri:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VDPPSrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3201,
        GIR_EraseRootFromParent_Done,
      // Label 915: @31794
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(31844), // Rule ID 3203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dppd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2f64] } 13673:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VDPPDrri:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VDPPDrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3203,
        GIR_EraseRootFromParent_Done,
      // Label 916: @31844
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(31894), // Rule ID 3205 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx_dp_ps_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8f32] } 12534:{ *:[iPTR] }, VR256:{ *:[v8f32] }:$src1, VR256:{ *:[v8f32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VDPPSYrri:{ *:[v8f32] } VR256:{ *:[v8f32] }:$src1, VR256:{ *:[v8f32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VDPPSYrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3205,
        GIR_EraseRootFromParent_Done,
      // Label 917: @31894
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(31944), // Rule ID 3207 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_mpsadbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v32s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i16] } 12603:{ *:[iPTR] }, VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VMPSADBWYrri:{ *:[v16i16] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMPSADBWYrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3207,
        GIR_EraseRootFromParent_Done,
      // Label 918: @31944
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(31994), // Rule ID 3209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_mpsadbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8i16] } 13676:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (MPSADBWrri:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MPSADBWrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3209,
        GIR_EraseRootFromParent_Done,
      // Label 919: @31994
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(32044), // Rule ID 3211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dpps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4f32] } 13674:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (DPPSrri:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DPPSrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3211,
        GIR_EraseRootFromParent_Done,
      // Label 920: @32044
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(32094), // Rule ID 3213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dppd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2f64] } 13673:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (DPPDrri:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DPPDrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3213,
        GIR_EraseRootFromParent_Done,
      // Label 921: @32094
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(32144), // Rule ID 3273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1rnds4),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 13560:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (SHA1RNDS4rri:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1RNDS4rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3273,
        GIR_EraseRootFromParent_Done,
      // Label 922: @32144
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(32194), // Rule ID 3319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasPCLMUL_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 13526:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (PCLMULQDQrri:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PCLMULQDQrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3319,
        GIR_EraseRootFromParent_Done,
      // Label 923: @32194
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(32244), // Rule ID 3321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_HasPCLMUL_NoVLX_Or_NoVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 13526:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQrri:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3321,
        GIR_EraseRootFromParent_Done,
      // Label 924: @32244
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(32294), // Rule ID 3323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVPCLMULQDQ_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i64] } 13527:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQYrri:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQYrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3323,
        GIR_EraseRootFromParent_Done,
      // Label 925: @32294
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(32344), // Rule ID 13970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8i64] } 13528:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQZrri:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13970,
        GIR_EraseRootFromParent_Done,
      // Label 926: @32344
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(32394), // Rule ID 13972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX_HasVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 13526:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQZ128rri:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13972,
        GIR_EraseRootFromParent_Done,
      // Label 927: @32394
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(32444), // Rule ID 13974 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX_HasVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i64] } 13527:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQZ256rri:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13974,
        GIR_EraseRootFromParent_Done,
      // Label 928: @32444
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(32498), // Rule ID 1607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmadcswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13859:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMADCSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMADCSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1607,
        GIR_EraseRootFromParent_Done,
      // Label 929: @32498
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(32552), // Rule ID 1609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmadcsswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13858:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMADCSSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMADCSSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1609,
        GIR_EraseRootFromParent_Done,
      // Label 930: @32552
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(32606), // Rule ID 1611 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsww),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13857:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1611,
        GIR_EraseRootFromParent_Done,
      // Label 931: @32606
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(32660), // Rule ID 1613 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13856:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1613,
        GIR_EraseRootFromParent_Done,
      // Label 932: @32660
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(32714), // Rule ID 1615 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssww),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13855:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1615,
        GIR_EraseRootFromParent_Done,
      // Label 933: @32714
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(32768), // Rule ID 1617 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13854:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1617,
        GIR_EraseRootFromParent_Done,
      // Label 934: @32768
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(32822), // Rule ID 1619 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssdql),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13853:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSSDQLrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSDQLrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1619,
        GIR_EraseRootFromParent_Done,
      // Label 935: @32822
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(32876), // Rule ID 1621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssdqh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13852:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSSDQHrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSDQHrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1621,
        GIR_EraseRootFromParent_Done,
      // Label 936: @32876
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(32930), // Rule ID 1623 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssdd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13851:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1623,
        GIR_EraseRootFromParent_Done,
      // Label 937: @32930
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(32984), // Rule ID 1625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsdql),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13850:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSDQLrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDQLrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1625,
        GIR_EraseRootFromParent_Done,
      // Label 938: @32984
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(33038), // Rule ID 1627 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsdqh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13849:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSDQHrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDQHrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1627,
        GIR_EraseRootFromParent_Done,
      // Label 939: @33038
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(33092), // Rule ID 1629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsdd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13848:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1629,
        GIR_EraseRootFromParent_Done,
      // Label 940: @33092
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(33158), // Rule ID 3281 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha256rnds2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13563:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, XMM0:{ *:[v4i32] })  =>  (SHA256RNDS2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::XMM0), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XMM0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA256RNDS2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3281,
        GIR_EraseRootFromParent_Done,
      // Label 941: @33158
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(33212), // Rule ID 3509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA512),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsha512rnds2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 13800:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VSHA512RNDS2rr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSHA512RNDS2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3509,
        GIR_EraseRootFromParent_Done,
      // Label 942: @33212
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(33266), // Rule ID 3510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm3msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13801:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VSM3MSG1rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM3MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3510,
        GIR_EraseRootFromParent_Done,
      // Label 943: @33266
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(33320), // Rule ID 3512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm3msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13802:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VSM3MSG2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM3MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3512,
        GIR_EraseRootFromParent_Done,
      // Label 944: @33320
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(33374), // Rule ID 3524 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwsud_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12668:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWSUDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWSUDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3524,
        GIR_EraseRootFromParent_Done,
      // Label 945: @33374
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(33428), // Rule ID 3526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwsud_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12669:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWSUDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWSUDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3526,
        GIR_EraseRootFromParent_Done,
      // Label 946: @33428
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(33482), // Rule ID 3528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwsuds_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12670:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWSUDSrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWSUDSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3528,
        GIR_EraseRootFromParent_Done,
      // Label 947: @33482
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(33536), // Rule ID 3530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwsuds_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12671:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWSUDSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWSUDSYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3530,
        GIR_EraseRootFromParent_Done,
      // Label 948: @33536
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(33590), // Rule ID 3532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwusd_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12672:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWUSDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUSDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3532,
        GIR_EraseRootFromParent_Done,
      // Label 949: @33590
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(33644), // Rule ID 3534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwusd_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12673:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWUSDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUSDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3534,
        GIR_EraseRootFromParent_Done,
      // Label 950: @33644
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(33698), // Rule ID 3536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwusds_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12674:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWUSDSrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUSDSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3536,
        GIR_EraseRootFromParent_Done,
      // Label 951: @33698
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(33752), // Rule ID 3538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwusds_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12675:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWUSDSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUSDSYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3538,
        GIR_EraseRootFromParent_Done,
      // Label 952: @33752
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(33806), // Rule ID 3540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwuud_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12676:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWUUDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUUDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3540,
        GIR_EraseRootFromParent_Done,
      // Label 953: @33806
      GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(33860), // Rule ID 3542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwuud_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12677:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWUUDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUUDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3542,
        GIR_EraseRootFromParent_Done,
      // Label 954: @33860
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(33914), // Rule ID 3544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwuuds_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12678:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWUUDSrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUUDSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3544,
        GIR_EraseRootFromParent_Done,
      // Label 955: @33914
      GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(33968), // Rule ID 3546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwuuds_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12679:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWUUDSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUUDSYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3546,
        GIR_EraseRootFromParent_Done,
      // Label 956: @33968
      GIM_Reject,
    // Label 913: @33969
    GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(34031), // Rule ID 3514 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM3),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/6,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm3rnds2),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      // MIs[0] src4
      GIM_CheckIsImm, /*MI*/0, /*Op*/5,
      // (intrinsic_wo_chain:{ *:[v4i32] } 13803:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3, (timm:{ *:[i32] }):$src4)  =>  (VSM3RNDS2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3, (timm:{ *:[i32] }):$src4)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM3RNDS2rr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_RootToRootCopy, /*OpIdx*/2, // src1
      GIR_RootToRootCopy, /*OpIdx*/3, // src2
      GIR_RootToRootCopy, /*OpIdx*/4, // src3
      GIR_RootToRootCopy, /*OpIdx*/5, // src4
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3514,
      GIR_EraseRootFromParent_Done,
    // Label 957: @34031
    GIM_Reject,
    // Label 11: @34032
    GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(34585),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/1,
      GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(34062), // Rule ID 149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSERIALIZE),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_serialize),
        // (intrinsic_void 13555:{ *:[iPTR] })  =>  (SERIALIZE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SERIALIZE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 149,
        GIR_EraseRootFromParent_Done,
      // Label 959: @34062
      GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(34084), // Rule ID 150 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTSXLDTRK),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xsusldtrk),
        // (intrinsic_void 13883:{ *:[iPTR] })  =>  (XSUSLDTRK)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XSUSLDTRK),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 150,
        GIR_EraseRootFromParent_Done,
      // Label 960: @34084
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(34106), // Rule ID 151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTSXLDTRK),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xresldtrk),
        // (intrinsic_void 13869:{ *:[iPTR] })  =>  (XRESLDTRK)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XRESLDTRK),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 151,
        GIR_EraseRootFromParent_Done,
      // Label 961: @34106
      GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(34128), // Rule ID 152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUINTR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_clui),
        // (intrinsic_void 13418:{ *:[iPTR] })  =>  (CLUI)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CLUI),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 152,
        GIR_EraseRootFromParent_Done,
      // Label 962: @34128
      GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(34150), // Rule ID 153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUINTR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_stui),
        // (intrinsic_void 13737:{ *:[iPTR] })  =>  (STUI)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::STUI),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 153,
        GIR_EraseRootFromParent_Done,
      // Label 963: @34150
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(34169), // Rule ID 2458 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_pause),
        // (intrinsic_void 13632:{ *:[iPTR] })  =>  (PAUSE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PAUSE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2458,
        GIR_EraseRootFromParent_Done,
      // Label 964: @34169
      GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(34191), // Rule ID 2459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse_sfence),
        // (intrinsic_void 13594:{ *:[iPTR] })  =>  (SFENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SFENCE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2459,
        GIR_EraseRootFromParent_Done,
      // Label 965: @34191
      GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(34213), // Rule ID 2460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_lfence),
        // (intrinsic_void 13621:{ *:[iPTR] })  =>  (LFENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LFENCE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2460,
        GIR_EraseRootFromParent_Done,
      // Label 966: @34213
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(34235), // Rule ID 2461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMFence),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_mfence),
        // (intrinsic_void 13625:{ *:[iPTR] })  =>  (MFENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MFENCE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2461,
        GIR_EraseRootFromParent_Done,
      // Label 967: @34235
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(34301), // Rule ID 3375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_avx_vzeroall),
        // (intrinsic_void 12577:{ *:[iPTR] })  =>  (VZEROALL)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VZEROALL),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM7*/7,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM8*/8,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM9*/9,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM10*/10,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM11*/11,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM12*/12,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM13*/13,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM14*/14,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM15*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3375,
        GIR_EraseRootFromParent_Done,
      // Label 968: @34301
      GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(34367), // Rule ID 3376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_avx_vzeroupper),
        // (intrinsic_void 12578:{ *:[iPTR] })  =>  (VZEROUPPER)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VZEROUPPER),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM7*/7,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM8*/8,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM9*/9,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM10*/10,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM11*/11,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM12*/12,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM13*/13,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM14*/14,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM15*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3376,
        GIR_EraseRootFromParent_Done,
      // Label 969: @34367
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(34437), // Rule ID 15346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMMX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_mmx_emms),
        // (intrinsic_void 13453:{ *:[iPTR] })  =>  (MMX_EMMS:{ *:[x86mmx] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MMX_EMMS),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM7*/7,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST0*/8,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST1*/9,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST2*/10,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST3*/11,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST4*/12,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST5*/13,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST6*/14,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST7*/15,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15346,
        GIR_EraseRootFromParent_Done,
      // Label 970: @34437
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(34459), // Rule ID 15529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xend),
        // (intrinsic_void 13821:{ *:[iPTR] })  =>  (XEND)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XEND),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15529,
        GIR_EraseRootFromParent_Done,
      // Label 971: @34459
      GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(34505), // Rule ID 15541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXTILE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tilerelease),
        // (intrinsic_void 13763:{ *:[iPTR] })  =>  (TILERELEASE:{ *:[x86amx] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TILERELEASE),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM7*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15541,
        GIR_EraseRootFromParent_Done,
      // Label 972: @34505
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(34524), // Rule ID 15588 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wbinvd),
        // (intrinsic_void 13808:{ *:[iPTR] })  =>  (WBINVD)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WBINVD),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15588,
        GIR_EraseRootFromParent_Done,
      // Label 973: @34524
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(34546), // Rule ID 15589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWBNOINVD),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wbnoinvd),
        // (intrinsic_void 13809:{ *:[iPTR] })  =>  (WBNOINVD)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WBNOINVD),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15589,
        GIR_EraseRootFromParent_Done,
      // Label 974: @34546
      GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(34565), // Rule ID 15594 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_saveprevssp),
        // (intrinsic_void 13550:{ *:[iPTR] })  =>  (SAVEPREVSSP)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SAVEPREVSSP),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15594,
        GIR_EraseRootFromParent_Done,
      // Label 975: @34565
      GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(34584), // Rule ID 15604 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_setssbsy),
        // (intrinsic_void 13556:{ *:[iPTR] })  =>  (SETSSBSY)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SETSSBSY),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15604,
        GIR_EraseRootFromParent_Done,
      // Label 976: @34584
      GIM_Reject,
    // Label 958: @34585
    GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(35579),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(34623), // Rule ID 15577 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_int),
        // MIs[0] Operand 1
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(3),
        // (intrinsic_void 13443:{ *:[iPTR] }, 3:{ *:[i8] })  =>  (INT3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INT3),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15577,
        GIR_EraseRootFromParent_Done,
      // Label 978: @34623
      GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(34650), // Rule ID 15531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xabort),
        // MIs[0] imm
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 13819:{ *:[iPTR] }, (timm:{ *:[i8] }):$imm)  =>  (XABORT (timm:{ *:[i8] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XABORT),
        GIR_RootToRootCopy, /*OpIdx*/1, // imm
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15531,
        GIR_EraseRootFromParent_Done,
      // Label 979: @34650
      GIM_Try, /*On fail goto*//*Label 980*/ GIMT_Encode4(34677), // Rule ID 15543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXTILE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tilezero),
        // MIs[0] src
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 13766:{ *:[iPTR] }, (timm:{ *:[i8] }):$src)  =>  (PTILEZERO (timm:{ *:[i8] }):$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTILEZERO),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15543,
        GIR_EraseRootFromParent_Done,
      // Label 980: @34677
      GIM_Try, /*On fail goto*//*Label 981*/ GIMT_Encode4(34701), // Rule ID 15579 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_int),
        // MIs[0] trap
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 13443:{ *:[iPTR] }, (timm:{ *:[i8] }):$trap)  =>  (INT (timm:{ *:[i8] }):$trap)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INT),
        GIR_RootToRootCopy, /*OpIdx*/1, // trap
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15579,
        GIR_EraseRootFromParent_Done,
      // Label 981: @34701
      GIM_Try, /*On fail goto*//*Label 982*/ GIMT_Encode4(34732), // Rule ID 1 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_flags_read_u32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13429:{ *:[iPTR] })  =>  (RDFLAGS32:{ *:[i32] }:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFLAGS32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1,
        GIR_EraseRootFromParent_Done,
      // Label 982: @34732
      GIM_Try, /*On fail goto*//*Label 983*/ GIMT_Encode4(34766), // Rule ID 2 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_flags_read_u64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13430:{ *:[iPTR] })  =>  (RDFLAGS64:{ *:[i64] }:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFLAGS64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ESP*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2,
        GIR_EraseRootFromParent_Done,
      // Label 983: @34766
      GIM_Try, /*On fail goto*//*Label 984*/ GIMT_Encode4(34797), // Rule ID 115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_slwpcb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13564:{ *:[iPTR] })  =>  (SLWPCB:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SLWPCB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 115,
        GIR_EraseRootFromParent_Done,
      // Label 984: @34797
      GIM_Try, /*On fail goto*//*Label 985*/ GIMT_Encode4(34828), // Rule ID 117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_slwpcb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13564:{ *:[iPTR] })  =>  (SLWPCB64:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SLWPCB64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 117,
        GIR_EraseRootFromParent_Done,
      // Label 985: @34828
      GIM_Try, /*On fail goto*//*Label 986*/ GIMT_Encode4(34859), // Rule ID 15528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xbegin),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13820:{ *:[iPTR] })  =>  (XBEGIN:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XBEGIN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15528,
        GIR_EraseRootFromParent_Done,
      // Label 986: @34859
      GIM_Try, /*On fail goto*//*Label 987*/ GIMT_Encode4(34890), // Rule ID 15621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdfsbase_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13531:{ *:[iPTR] })  =>  (RDFSBASE:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFSBASE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15621,
        GIR_EraseRootFromParent_Done,
      // Label 987: @34890
      GIM_Try, /*On fail goto*//*Label 988*/ GIMT_Encode4(34921), // Rule ID 15622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdfsbase_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13532:{ *:[iPTR] })  =>  (RDFSBASE64:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15622,
        GIR_EraseRootFromParent_Done,
      // Label 988: @34921
      GIM_Try, /*On fail goto*//*Label 989*/ GIMT_Encode4(34952), // Rule ID 15623 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdgsbase_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13533:{ *:[iPTR] })  =>  (RDGSBASE:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDGSBASE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15623,
        GIR_EraseRootFromParent_Done,
      // Label 989: @34952
      GIM_Try, /*On fail goto*//*Label 990*/ GIMT_Encode4(34983), // Rule ID 15624 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdgsbase_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13534:{ *:[iPTR] })  =>  (RDGSBASE64:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDGSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15624,
        GIR_EraseRootFromParent_Done,
      // Label 990: @34983
      GIM_Try, /*On fail goto*//*Label 991*/ GIMT_Encode4(35014), // Rule ID 15630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRDPID_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdpid),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13535:{ *:[iPTR] })  =>  (RDPID32:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDPID32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15630,
        GIR_EraseRootFromParent_Done,
      // Label 991: @35014
      GIM_Try, /*On fail goto*//*Label 992*/ GIMT_Encode4(35071), // Rule ID 20794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRDPID_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdpid),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13535:{ *:[iPTR] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (RDPID64:{ *:[i64] }), sub_32bit:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::RDPID64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_32bit),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        // GIR_Coverage, 20794,
        GIR_EraseRootFromParent_Done,
      // Label 992: @35071
      GIM_Try, /*On fail goto*//*Label 993*/ GIMT_Encode4(35108), // Rule ID 3 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_flags_write_u32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13431:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (WRFLAGS32:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFLAGS32),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::DF*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3,
        GIR_EraseRootFromParent_Done,
      // Label 993: @35108
      GIM_Try, /*On fail goto*//*Label 994*/ GIMT_Encode4(35145), // Rule ID 4 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_flags_write_u64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13432:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (WRFLAGS64:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFLAGS64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::DF*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4,
        GIR_EraseRootFromParent_Done,
      // Label 994: @35145
      GIM_Try, /*On fail goto*//*Label 995*/ GIMT_Encode4(35176), // Rule ID 154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUINTR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_senduipi),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13554:{ *:[iPTR] }, GR64:{ *:[i64] }:$arg)  =>  (SENDUIPI GR64:{ *:[i64] }:$arg)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SENDUIPI),
        GIR_RootToRootCopy, /*OpIdx*/1, // arg
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 154,
        GIR_EraseRootFromParent_Done,
      // Label 995: @35176
      GIM_Try, /*On fail goto*//*Label 996*/ GIMT_Encode4(35204), // Rule ID 15590 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_incsspd),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13441:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (INCSSPD GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INCSSPD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15590,
        GIR_EraseRootFromParent_Done,
      // Label 996: @35204
      GIM_Try, /*On fail goto*//*Label 997*/ GIMT_Encode4(35232), // Rule ID 15591 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_incsspq),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13442:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (INCSSPQ GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INCSSPQ),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15591,
        GIR_EraseRootFromParent_Done,
      // Label 997: @35232
      GIM_Try, /*On fail goto*//*Label 998*/ GIMT_Encode4(35263), // Rule ID 15625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrfsbase_32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13810:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (WRFSBASE GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFSBASE),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15625,
        GIR_EraseRootFromParent_Done,
      // Label 998: @35263
      GIM_Try, /*On fail goto*//*Label 999*/ GIMT_Encode4(35294), // Rule ID 15626 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrfsbase_64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13811:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (WRFSBASE64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15626,
        GIR_EraseRootFromParent_Done,
      // Label 999: @35294
      GIM_Try, /*On fail goto*//*Label 1000*/ GIMT_Encode4(35325), // Rule ID 15627 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrgsbase_32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13812:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (WRGSBASE GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRGSBASE),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15627,
        GIR_EraseRootFromParent_Done,
      // Label 1000: @35325
      GIM_Try, /*On fail goto*//*Label 1001*/ GIMT_Encode4(35356), // Rule ID 15628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrgsbase_64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13813:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (WRGSBASE64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRGSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15628,
        GIR_EraseRootFromParent_Done,
      // Label 1001: @35356
      GIM_Try, /*On fail goto*//*Label 1002*/ GIMT_Encode4(35387), // Rule ID 15633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasPTWRITE),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ptwrite32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13529:{ *:[iPTR] }, GR32:{ *:[i32] }:$dst)  =>  (PTWRITEr GR32:{ *:[i32] }:$dst)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTWRITEr),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15633,
        GIR_EraseRootFromParent_Done,
      // Label 1002: @35387
      GIM_Try, /*On fail goto*//*Label 1003*/ GIMT_Encode4(35418), // Rule ID 15634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasPTWRITE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ptwrite64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13530:{ *:[iPTR] }, GR64:{ *:[i64] }:$dst)  =>  (PTWRITE64r GR64:{ *:[i64] }:$dst)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTWRITE64r),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15634,
        GIR_EraseRootFromParent_Done,
      // Label 1003: @35418
      GIM_Try, /*On fail goto*//*Label 1004*/ GIMT_Encode4(35450), // Rule ID 114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_llwpcb),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13447:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (LLWPCB GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LLWPCB),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 114,
        GIR_EraseRootFromParent_Done,
      // Label 1004: @35450
      GIM_Try, /*On fail goto*//*Label 1005*/ GIMT_Encode4(35482), // Rule ID 116 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_llwpcb),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13447:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (LLWPCB64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LLWPCB64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 116,
        GIR_EraseRootFromParent_Done,
      // Label 1005: @35482
      GIM_Try, /*On fail goto*//*Label 1006*/ GIMT_Encode4(35514), // Rule ID 126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWAITPKG_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_umonitor),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (intrinsic_void 13769:{ *:[iPTR] }, GR16:{ *:[i16] }:$src)  =>  (UMONITOR16 GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UMONITOR16),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 126,
        GIR_EraseRootFromParent_Done,
      // Label 1006: @35514
      GIM_Try, /*On fail goto*//*Label 1007*/ GIMT_Encode4(35546), // Rule ID 127 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWAITPKG),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_umonitor),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13769:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (UMONITOR32 GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UMONITOR32),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 127,
        GIR_EraseRootFromParent_Done,
      // Label 1007: @35546
      GIM_Try, /*On fail goto*//*Label 1008*/ GIMT_Encode4(35578), // Rule ID 128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWAITPKG_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_umonitor),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13769:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (UMONITOR64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UMONITOR64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 128,
        GIR_EraseRootFromParent_Done,
      // Label 1008: @35578
      GIM_Reject,
    // Label 977: @35579
    GIM_Try, /*On fail goto*//*Label 1009*/ GIMT_Encode4(35929),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 1010*/ GIMT_Encode4(35630), // Rule ID 15654 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::asan_check_memaccess),
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64PLTSafeRegClassID),
        // MIs[0] accessinfo
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 9:{ *:[iPTR] }, GR64PLTSafe:{ *:[i64] }:$addr, (timm:{ *:[i32] }):$accessinfo)  =>  (ASAN_CHECK_MEMACCESS:{ *:[i64] } GR64PLTSafe:{ *:[i64] }:$addr, (timm:{ *:[i32] }):$accessinfo)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ASAN_CHECK_MEMACCESS),
        GIR_RootToRootCopy, /*OpIdx*/1, // addr
        GIR_RootToRootCopy, /*OpIdx*/2, // accessinfo
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::R10*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::R11*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15654,
        GIR_EraseRootFromParent_Done,
      // Label 1010: @35630
      GIM_Try, /*On fail goto*//*Label 1011*/ GIMT_Encode4(35670), // Rule ID 15580 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUSERMSR_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_urdmsr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13771:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (URDMSRrr:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::URDMSRrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15580,
        GIR_EraseRootFromParent_Done,
      // Label 1011: @35670
      GIM_Try, /*On fail goto*//*Label 1012*/ GIMT_Encode4(35710), // Rule ID 15584 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasEGPR_HasUSERMSR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_urdmsr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13771:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (URDMSRrr_EVEX:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::URDMSRrr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15584,
        GIR_EraseRootFromParent_Done,
      // Label 1012: @35710
      GIM_Try, /*On fail goto*//*Label 1013*/ GIMT_Encode4(35747), // Rule ID 15592 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdsspd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13545:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (RDSSPD:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDSSPD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15592,
        GIR_EraseRootFromParent_Done,
      // Label 1013: @35747
      GIM_Try, /*On fail goto*//*Label 1014*/ GIMT_Encode4(35784), // Rule ID 15593 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdsspq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13546:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (RDSSPQ:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDSSPQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15593,
        GIR_EraseRootFromParent_Done,
      // Label 1014: @35784
      GIM_Try, /*On fail goto*//*Label 1015*/ GIMT_Encode4(35848), // Rule ID 3034 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse3_mwait),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32_ArgRef_and_GR32_CBRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32_ADRegClassID),
        // (intrinsic_void 13670:{ *:[iPTR] }, ECX:{ *:[i32] }, EAX:{ *:[i32] })  =>  (MWAITrr)
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/2, GIMT_Encode2(X86::EAX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // EAX
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::ECX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // ECX
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MWAITrr),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3034,
        GIR_EraseRootFromParent_Done,
      // Label 1015: @35848
      GIM_Try, /*On fail goto*//*Label 1016*/ GIMT_Encode4(35888), // Rule ID 15582 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUSERMSR_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_uwrmsr),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13772:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (UWRMSRrr GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UWRMSRrr),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15582,
        GIR_EraseRootFromParent_Done,
      // Label 1016: @35888
      GIM_Try, /*On fail goto*//*Label 1017*/ GIMT_Encode4(35928), // Rule ID 15586 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasEGPR_HasUSERMSR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_uwrmsr),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13772:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (UWRMSRrr_EVEX GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UWRMSRrr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15586,
        GIR_EraseRootFromParent_Done,
      // Label 1017: @35928
      GIM_Reject,
    // Label 1009: @35929
    GIM_Try, /*On fail goto*//*Label 1018*/ GIMT_Encode4(36703),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 1019*/ GIMT_Encode4(35974), // Rule ID 15548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbssd),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13748:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBSSD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBSSD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15548,
        GIR_EraseRootFromParent_Done,
      // Label 1019: @35974
      GIM_Try, /*On fail goto*//*Label 1020*/ GIMT_Encode4(36011), // Rule ID 15549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbsud),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13750:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBSUD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBSUD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15549,
        GIR_EraseRootFromParent_Done,
      // Label 1020: @36011
      GIM_Try, /*On fail goto*//*Label 1021*/ GIMT_Encode4(36048), // Rule ID 15550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbusd),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13752:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBUSD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBUSD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15550,
        GIR_EraseRootFromParent_Done,
      // Label 1021: @36048
      GIM_Try, /*On fail goto*//*Label 1022*/ GIMT_Encode4(36085), // Rule ID 15551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbuud),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13754:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBUUD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBUUD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15551,
        GIR_EraseRootFromParent_Done,
      // Label 1022: @36085
      GIM_Try, /*On fail goto*//*Label 1023*/ GIMT_Encode4(36122), // Rule ID 15553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXBF16_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbf16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13746:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBF16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBF16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15553,
        GIR_EraseRootFromParent_Done,
      // Label 1023: @36122
      GIM_Try, /*On fail goto*//*Label 1024*/ GIMT_Encode4(36159), // Rule ID 15555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXFP16_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13756:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15555,
        GIR_EraseRootFromParent_Done,
      // Label 1024: @36159
      GIM_Try, /*On fail goto*//*Label 1025*/ GIMT_Encode4(36196), // Rule ID 15558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tcmmimfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13742:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTCMMIMFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCMMIMFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15558,
        GIR_EraseRootFromParent_Done,
      // Label 1025: @36196
      GIM_Try, /*On fail goto*//*Label 1026*/ GIMT_Encode4(36233), // Rule ID 15559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tcmmrlfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13744:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTCMMRLFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCMMRLFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15559,
        GIR_EraseRootFromParent_Done,
      // Label 1026: @36233
      GIM_Try, /*On fail goto*//*Label 1027*/ GIMT_Encode4(36278), // Rule ID 122 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_lwpval32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // MIs[0] cntl
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13451:{ *:[iPTR] }, GR32:{ *:[i32] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)  =>  (LWPVAL32rri GR32:{ *:[i32] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LWPVAL32rri),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // cntl
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 122,
        GIR_EraseRootFromParent_Done,
      // Label 1027: @36278
      GIM_Try, /*On fail goto*//*Label 1028*/ GIMT_Encode4(36323), // Rule ID 124 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_lwpval64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // MIs[0] cntl
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13452:{ *:[iPTR] }, GR64:{ *:[i64] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)  =>  (LWPVAL64rri GR64:{ *:[i64] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LWPVAL64rri),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // cntl
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 124,
        GIR_EraseRootFromParent_Done,
      // Label 1028: @36323
      GIM_Try, /*On fail goto*//*Label 1029*/ GIMT_Encode4(36405), // Rule ID 15606 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xsetbv),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32_ArgRef_and_GR32_CBRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32_AD_and_GR32_ArgRefRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32_ADRegClassID),
        // (intrinsic_void 13882:{ *:[iPTR] }, ECX:{ *:[i32] }, EDX:{ *:[i32] }, EAX:{ *:[i32] })  =>  (XSETBV)
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/3, GIMT_Encode2(X86::EAX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // EAX
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/2, GIMT_Encode2(X86::EDX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // EDX
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::ECX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // ECX
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XSETBV),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15606,
        GIR_EraseRootFromParent_Done,
      // Label 1029: @36405
      GIM_Try, /*On fail goto*//*Label 1030*/ GIMT_Encode4(36454), // Rule ID 15795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMWAITX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_mwaitx),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13525:{ *:[iPTR] }, GR32:{ *:[i32] }:$ecx, GR32:{ *:[i32] }:$eax, GR32:{ *:[i32] }:$ebx)  =>  (MWAITX GR32:{ *:[i32] }:$ecx, GR32:{ *:[i32] }:$eax, GR32:{ *:[i32] }:$ebx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MWAITX),
        GIR_RootToRootCopy, /*OpIdx*/1, // ecx
        GIR_RootToRootCopy, /*OpIdx*/2, // eax
        GIR_RootToRootCopy, /*OpIdx*/3, // ebx
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15795,
        GIR_EraseRootFromParent_Done,
      // Label 1030: @36454
      GIM_Try, /*On fail goto*//*Label 1031*/ GIMT_Encode4(36516), // Rule ID 2851 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64_with_sub_32bit_in_GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 13622:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, RDI:{ *:[i64] })  =>  (VMASKMOVDQU64 VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::RDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // RDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMASKMOVDQU64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2851,
        GIR_EraseRootFromParent_Done,
      // Label 1031: @36516
      GIM_Try, /*On fail goto*//*Label 1032*/ GIMT_Encode4(36578), // Rule ID 2852 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 13622:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, EDI:{ *:[i32] })  =>  (VMASKMOVDQU VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::EDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // EDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMASKMOVDQU),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2852,
        GIR_EraseRootFromParent_Done,
      // Label 1032: @36578
      GIM_Try, /*On fail goto*//*Label 1033*/ GIMT_Encode4(36640), // Rule ID 2853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_UseSSE2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64_with_sub_32bit_in_GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 13622:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, RDI:{ *:[i64] })  =>  (MASKMOVDQU64 VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::RDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // RDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MASKMOVDQU64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2853,
        GIR_EraseRootFromParent_Done,
      // Label 1033: @36640
      GIM_Try, /*On fail goto*//*Label 1034*/ GIMT_Encode4(36702), // Rule ID 2854 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 13622:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, EDI:{ *:[i32] })  =>  (MASKMOVDQU VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::EDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // EDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MASKMOVDQU),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2854,
        GIR_EraseRootFromParent_Done,
      // Label 1034: @36702
      GIM_Reject,
    // Label 1018: @36703
    GIM_Try, /*On fail goto*//*Label 1035*/ GIMT_Encode4(36791), // Rule ID 15532 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasKL),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_loadiwkey),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::GR32_ADRegClassID),
      // (intrinsic_void 13448:{ *:[iPTR] }, XMM0:{ *:[v2i64] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, EAX:{ *:[i32] })  =>  (LOADIWKEY:{ *:[i32] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddRegister, /*InsnID*/2, GIMT_Encode2(X86::EAX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // EAX
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::XMM0), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // XMM0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LOADIWKEY),
      GIR_RootToRootCopy, /*OpIdx*/2, // src1
      GIR_RootToRootCopy, /*OpIdx*/3, // src2
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15532,
      GIR_EraseRootFromParent_Done,
    // Label 1035: @36791
    GIM_Reject,
    // Label 12: @36792
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(5), /*)*//*default:*//*Label 1039*/ GIMT_Encode4(37226),
    /*GILLT_s16*//*Label 1036*/ GIMT_Encode4(36815),
    /*GILLT_s32*//*Label 1037*/ GIMT_Encode4(36873),
    /*GILLT_s64*//*Label 1038*/ GIMT_Encode4(37048),
    // Label 1036: @36815
    GIM_Try, /*On fail goto*//*Label 1040*/ GIMT_Encode4(36872), // Rule ID 21001 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (anyext:{ *:[i16] } GR8:{ *:[i8] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOVZX32rr8:{ *:[i32] } GR8:{ *:[i8] }:$src), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21001,
      GIR_EraseRootFromParent_Done,
    // Label 1040: @36872
    GIM_Reject,
    // Label 1037: @36873
    GIM_Try, /*On fail goto*//*Label 1041*/ GIMT_Encode4(36919), // Rule ID 17971 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (anyext:{ *:[i32] } (bitconvert:{ *:[i16] } VK16:{ *:[v16i1] }:$src))  =>  (COPY_TO_REGCLASS:{ *:[i32] } VK16:{ *:[v16i1] }:$src, GR32:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17971,
      GIR_EraseRootFromParent_Done,
    // Label 1041: @36919
    GIM_Try, /*On fail goto*//*Label 1042*/ GIMT_Encode4(36965), // Rule ID 17974 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (anyext:{ *:[i32] } (bitconvert:{ *:[i8] } VK8:{ *:[v8i1] }:$src))  =>  (COPY_TO_REGCLASS:{ *:[i32] } VK8:{ *:[v8i1] }:$src, GR32:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17974,
      GIR_EraseRootFromParent_Done,
    // Label 1042: @36965
    GIM_Try, /*On fail goto*//*Label 1043*/ GIMT_Encode4(36988), // Rule ID 21002 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (anyext:{ *:[i32] } GR8:{ *:[i8] }:$src)  =>  (MOVZX32rr8:{ *:[i32] } GR8:{ *:[i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21002,
      GIR_Done,
    // Label 1043: @36988
    GIM_Try, /*On fail goto*//*Label 1044*/ GIMT_Encode4(37047), // Rule ID 21003 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (anyext:{ *:[i32] } GR16:{ *:[i16] }:$src)  =>  (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      // GIR_Coverage, 21003,
      GIR_EraseRootFromParent_Done,
    // Label 1044: @37047
    GIM_Reject,
    // Label 1038: @37048
    GIM_Try, /*On fail goto*//*Label 1045*/ GIMT_Encode4(37107), // Rule ID 21004 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (anyext:{ *:[i64] } GR8:{ *:[i8] }:$src)  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (MOVZX32rr8:{ *:[i32] } GR8:{ *:[i8] }:$src), sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21004,
      GIR_EraseRootFromParent_Done,
    // Label 1045: @37107
    GIM_Try, /*On fail goto*//*Label 1046*/ GIMT_Encode4(37166), // Rule ID 21005 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (anyext:{ *:[i64] } GR16:{ *:[i16] }:$src)  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (MOVZX32rr16:{ *:[i32] } GR16:{ *:[i16] }:$src), sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr16),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21005,
      GIR_EraseRootFromParent_Done,
    // Label 1046: @37166
    GIM_Try, /*On fail goto*//*Label 1047*/ GIMT_Encode4(37225), // Rule ID 21006 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (anyext:{ *:[i64] } GR32:{ *:[i32] }:$src)  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR32:{ *:[i32] }:$src, sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21006,
      GIR_EraseRootFromParent_Done,
    // Label 1047: @37225
    GIM_Reject,
    // Label 1039: @37226
    GIM_Reject,
    // Label 13: @37227
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(22), /*)*//*default:*//*Label 1056*/ GIMT_Encode4(38230),
    /*GILLT_s8*//*Label 1048*/ GIMT_Encode4(37322),
    /*GILLT_s16*//*Label 1049*/ GIMT_Encode4(37597), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 1050*/ GIMT_Encode4(37636), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 1051*/ GIMT_Encode4(37776),
    /*GILLT_v8s32*//*Label 1052*/ GIMT_Encode4(37939), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 1053*/ GIMT_Encode4(37966),
    /*GILLT_v16s16*//*Label 1054*/ GIMT_Encode4(38176), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v32s8*//*Label 1055*/ GIMT_Encode4(38203),
    // Label 1048: @37322
    GIM_Try, /*On fail goto*//*Label 1057*/ GIMT_Encode4(37394), // Rule ID 17966 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (trunc:{ *:[i8] } (bitconvert:{ *:[i16] } VK16:{ *:[v16i1] }:$src))  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i32] } VK16:{ *:[v16i1] }:$src, GR32:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17966,
      GIR_EraseRootFromParent_Done,
    // Label 1057: @37394
    GIM_Try, /*On fail goto*//*Label 1058*/ GIMT_Encode4(37454), // Rule ID 21063 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32_ABCDRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (trunc:{ *:[i8] } GR32:{ *:[i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i32] } GR32:{ *:[i32] }:$src, GR32_ABCD:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8_ABCD_LRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32_ABCDRegClassID),
      // GIR_Coverage, 21063,
      GIR_EraseRootFromParent_Done,
    // Label 1058: @37454
    GIM_Try, /*On fail goto*//*Label 1059*/ GIMT_Encode4(37514), // Rule ID 21064 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16_ABCDRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (trunc:{ *:[i8] } GR16:{ *:[i16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i16] } GR16:{ *:[i16] }:$src, GR16_ABCD:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8_ABCD_LRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR16_ABCDRegClassID),
      // GIR_Coverage, 21064,
      GIR_EraseRootFromParent_Done,
    // Label 1059: @37514
    GIM_Try, /*On fail goto*//*Label 1060*/ GIMT_Encode4(37555), // Rule ID 21068 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (trunc:{ *:[i8] } GR32:{ *:[i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } GR32:{ *:[i32] }:$src, sub_8bit:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21068,
      GIR_EraseRootFromParent_Done,
    // Label 1060: @37555
    GIM_Try, /*On fail goto*//*Label 1061*/ GIMT_Encode4(37596), // Rule ID 21069 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (trunc:{ *:[i8] } GR16:{ *:[i16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } GR16:{ *:[i16] }:$src, sub_8bit:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
      // GIR_Coverage, 21069,
      GIR_EraseRootFromParent_Done,
    // Label 1061: @37596
    GIM_Reject,
    // Label 1049: @37597
    GIM_Try, /*On fail goto*//*Label 1062*/ GIMT_Encode4(37635), // Rule ID 21062 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (trunc:{ *:[i16] } GR32:{ *:[i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } GR32:{ *:[i32] }:$src, sub_16bit:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(4), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21062,
      GIR_EraseRootFromParent_Done,
    // Label 1062: @37635
    GIM_Reject,
    // Label 1050: @37636
    GIM_Try, /*On fail goto*//*Label 1063*/ GIMT_Encode4(37775),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 1064*/ GIMT_Encode4(37667), // Rule ID 12148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (trunc:{ *:[v4i32] } VR256X:{ *:[v4i64] }:$src)  =>  (VPMOVQDZ256rr:{ *:[v4i32] } VR256X:{ *:[v4i64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVQDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12148,
        GIR_Done,
      // Label 1064: @37667
      GIM_Try, /*On fail goto*//*Label 1065*/ GIMT_Encode4(37774), // Rule ID 20137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (trunc:{ *:[v4i32] } VR256X:{ *:[v4i64] }:$src)  =>  (EXTRACT_SUBREG:{ *:[v4i32] } (VPMOVQDZrr:{ *:[v8i32] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] })), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVQDZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR256XRegClassID),
        // GIR_Coverage, 20137,
        GIR_EraseRootFromParent_Done,
      // Label 1065: @37774
      GIM_Reject,
    // Label 1063: @37775
    GIM_Reject,
    // Label 1051: @37776
    GIM_Try, /*On fail goto*//*Label 1066*/ GIMT_Encode4(37802), // Rule ID 12124 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v8i16] } VR512:{ *:[v8i64] }:$src)  =>  (VPMOVQWZrr:{ *:[v8i16] } VR512:{ *:[v8i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVQWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12124,
      GIR_Done,
    // Label 1066: @37802
    GIM_Try, /*On fail goto*//*Label 1067*/ GIMT_Encode4(37828), // Rule ID 12202 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v8i16] } VR256X:{ *:[v8i32] }:$src)  =>  (VPMOVDWZ256rr:{ *:[v8i16] } VR256X:{ *:[v8i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVDWZ256rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12202,
      GIR_Done,
    // Label 1067: @37828
    GIM_Try, /*On fail goto*//*Label 1068*/ GIMT_Encode4(37938), // Rule ID 20136 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v8i16] } VR256X:{ *:[v8i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[v8i16] } (VPMOVDWZrr:{ *:[v16i16] } (INSERT_SUBREG:{ *:[v16i32] } (IMPLICIT_DEF:{ *:[v16i32] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] })), sub_xmm:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVDWZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR256XRegClassID),
      // GIR_Coverage, 20136,
      GIR_EraseRootFromParent_Done,
    // Label 1068: @37938
    GIM_Reject,
    // Label 1052: @37939
    GIM_Try, /*On fail goto*//*Label 1069*/ GIMT_Encode4(37965), // Rule ID 12151 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v8i32] } VR512:{ *:[v8i64] }:$src)  =>  (VPMOVQDZrr:{ *:[v8i32] } VR512:{ *:[v8i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVQDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12151,
      GIR_Done,
    // Label 1069: @37965
    GIM_Reject,
    // Label 1053: @37966
    GIM_Try, /*On fail goto*//*Label 1070*/ GIMT_Encode4(37992), // Rule ID 12178 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v16i8] } VR512:{ *:[v16i32] }:$src)  =>  (VPMOVDBZrr:{ *:[v16i8] } VR512:{ *:[v16i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVDBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12178,
      GIR_Done,
    // Label 1070: @37992
    GIM_Try, /*On fail goto*//*Label 1071*/ GIMT_Encode4(38018), // Rule ID 12229 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)  =>  (VPMOVWBZ256rr:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVWBZ256rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12229,
      GIR_Done,
    // Label 1071: @38018
    GIM_Try, /*On fail goto*//*Label 1072*/ GIMT_Encode4(38128), // Rule ID 20138 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasEVEX512_NoVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[v16i8] } (VPMOVWBZrr:{ *:[v32i8] } (INSERT_SUBREG:{ *:[v32i16] } (IMPLICIT_DEF:{ *:[v32i16] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] })), sub_xmm:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v32s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v32s16,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v32s16,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVWBZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR256XRegClassID),
      // GIR_Coverage, 20138,
      GIR_EraseRootFromParent_Done,
    // Label 1072: @38128
    GIM_Try, /*On fail goto*//*Label 1073*/ GIMT_Encode4(38175), // Rule ID 20229 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_NoBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)  =>  (VPMOVDBZrr:{ *:[v16i8] } (VPMOVZXWDZrr:{ *:[v16i32] } VR256X:{ *:[v16i16] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVZXWDZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMOVDBZrr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20229,
      GIR_EraseRootFromParent_Done,
    // Label 1073: @38175
    GIM_Reject,
    // Label 1054: @38176
    GIM_Try, /*On fail goto*//*Label 1074*/ GIMT_Encode4(38202), // Rule ID 12205 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v16i16] } VR512:{ *:[v16i32] }:$src)  =>  (VPMOVDWZrr:{ *:[v16i16] } VR512:{ *:[v16i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVDWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12205,
      GIR_Done,
    // Label 1074: @38202
    GIM_Reject,
    // Label 1055: @38203
    GIM_Try, /*On fail goto*//*Label 1075*/ GIMT_Encode4(38229), // Rule ID 12232 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v32i8] } VR512:{ *:[v32i16] }:$src)  =>  (VPMOVWBZrr:{ *:[v32i8] } VR512:{ *:[v32i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVWBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12232,
      GIR_Done,
    // Label 1075: @38229
    GIM_Reject,
    // Label 1056: @38230
    GIM_Reject,
    // Label 14: @38231
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(5), /*)*//*default:*//*Label 1080*/ GIMT_Encode4(38840),
    /*GILLT_s8*//*Label 1076*/ GIMT_Encode4(38258),
    /*GILLT_s16*//*Label 1077*/ GIMT_Encode4(38338),
    /*GILLT_s32*//*Label 1078*/ GIMT_Encode4(38544),
    /*GILLT_s64*//*Label 1079*/ GIMT_Encode4(38686),
    // Label 1076: @38258
    GIM_Try, /*On fail goto*//*Label 1081*/ GIMT_Encode4(38318), // Rule ID 20797 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(0),
      // 0:{ *:[i8] }  =>  (EXTRACT_SUBREG:{ *:[i8] } (MOV32r0:{ *:[i32] }:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r0),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20797,
      GIR_EraseRootFromParent_Done,
    // Label 1081: @38318
    GIM_Try, /*On fail goto*//*Label 1082*/ GIMT_Encode4(38337), // Rule ID 19 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i8] }):$src  =>  (MOV8ri:{ *:[i8] } (imm:{ *:[i8] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV8ri),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19,
      GIR_EraseRootFromParent_Done,
    // Label 1082: @38337
    GIM_Reject,
    // Label 1077: @38338
    GIM_Try, /*On fail goto*//*Label 1083*/ GIMT_Encode4(38398), // Rule ID 20798 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(0),
      // 0:{ *:[i16] }  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOV32r0:{ *:[i32] }:{ *:[i32] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r0),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20798,
      GIR_EraseRootFromParent_Done,
    // Label 1083: @38398
    GIM_Try, /*On fail goto*//*Label 1084*/ GIMT_Encode4(38461), // Rule ID 20800 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode_OptForSize),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(1),
      // 1:{ *:[i16] }  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOV32r1:{ *:[i32] }:{ *:[i32] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r1),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20800,
      GIR_EraseRootFromParent_Done,
    // Label 1084: @38461
    GIM_Try, /*On fail goto*//*Label 1085*/ GIMT_Encode4(38524), // Rule ID 20801 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode_OptForSize),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(-1),
      // -1:{ *:[i16] }  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOV32r_1:{ *:[i32] }:{ *:[i32] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r_1),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20801,
      GIR_EraseRootFromParent_Done,
    // Label 1085: @38524
    GIM_Try, /*On fail goto*//*Label 1086*/ GIMT_Encode4(38543), // Rule ID 20 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i16] }):$src  =>  (MOV16ri:{ *:[i16] } (imm:{ *:[i16] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV16ri),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20,
      GIR_EraseRootFromParent_Done,
    // Label 1086: @38543
    GIM_Reject,
    // Label 1078: @38544
    GIM_Try, /*On fail goto*//*Label 1087*/ GIMT_Encode4(38574), // Rule ID 15655 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(0),
      // 0:{ *:[i32] }  =>  (MOV32r0:{ *:[i32] }:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32r0),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15655,
      GIR_EraseRootFromParent_Done,
    // Label 1087: @38574
    GIM_Try, /*On fail goto*//*Label 1088*/ GIMT_Encode4(38607), // Rule ID 15656 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode_OptForSize),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(1),
      // 1:{ *:[i32] }  =>  (MOV32r1:{ *:[i32] }:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32r1),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15656,
      GIR_EraseRootFromParent_Done,
    // Label 1088: @38607
    GIM_Try, /*On fail goto*//*Label 1089*/ GIMT_Encode4(38640), // Rule ID 15657 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode_OptForSize),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(-1),
      // -1:{ *:[i32] }  =>  (MOV32r_1:{ *:[i32] }:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32r_1),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15657,
      GIR_EraseRootFromParent_Done,
    // Label 1089: @38640
    GIM_Try, /*On fail goto*//*Label 1090*/ GIMT_Encode4(38666), // Rule ID 15658 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotWin64WithoutFP_OptForMinSize),
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i32immSExt8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i32] })<<P:Predicate_i32immSExt8>>:$src  =>  (MOV32ImmSExti8:{ *:[i32] } (imm:{ *:[i32] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32ImmSExti8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15658,
      GIR_EraseRootFromParent_Done,
    // Label 1090: @38666
    GIM_Try, /*On fail goto*//*Label 1091*/ GIMT_Encode4(38685), // Rule ID 21 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i32] }):$src  =>  (MOV32ri:{ *:[i32] } (imm:{ *:[i32] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32ri),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21,
      GIR_EraseRootFromParent_Done,
    // Label 1091: @38685
    GIM_Reject,
    // Label 1079: @38686
    GIM_Try, /*On fail goto*//*Label 1092*/ GIMT_Encode4(38748), // Rule ID 20799 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(0),
      // 0:{ *:[i64] }  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (MOV32r0:{ *:[i32] }:{ *:[i32] }), sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r0),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20799,
      GIR_EraseRootFromParent_Done,
    // Label 1092: @38748
    GIM_Try, /*On fail goto*//*Label 1093*/ GIMT_Encode4(38774), // Rule ID 15659 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotWin64WithoutFP_OptForMinSize),
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] })<<P:Predicate_i64immSExt8>>:$src  =>  (MOV64ImmSExti8:{ *:[i64] } (imm:{ *:[i64] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV64ImmSExti8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15659,
      GIR_EraseRootFromParent_Done,
    // Label 1093: @38774
    GIM_Try, /*On fail goto*//*Label 1094*/ GIMT_Encode4(38797), // Rule ID 15660 //
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immZExt32),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] })<<P:Predicate_i64immZExt32>>:$src  =>  (MOV32ri64:{ *:[i64] } (imm:{ *:[i64] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32ri64),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15660,
      GIR_EraseRootFromParent_Done,
    // Label 1094: @38797
    GIM_Try, /*On fail goto*//*Label 1095*/ GIMT_Encode4(38820), // Rule ID 22 //
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src  =>  (MOV64ri32:{ *:[i64] } (imm:{ *:[i64] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV64ri32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 22,
      GIR_EraseRootFromParent_Done,
    // Label 1095: @38820
    GIM_Try, /*On fail goto*//*Label 1096*/ GIMT_Encode4(38839), // Rule ID 23 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] }):$src  =>  (MOV64ri:{ *:[i64] } (imm:{ *:[i64] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV64ri),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 23,
      GIR_EraseRootFromParent_Done,
    // Label 1096: @38839
    GIM_Reject,
    // Label 1080: @38840
    GIM_Reject,
    // Label 15: @38841
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(6), /*)*//*default:*//*Label 1100*/ GIMT_Encode4(39293),
    /*GILLT_s32*//*Label 1097*/ GIMT_Encode4(38864),
    /*G