/* LinkTypeStraight.c generated by valac 0.56.18, the Vala compiler
 * generated from LinkTypeStraight.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_LINK_TYPE (link_type_get_type ())
#define LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_TYPE, LinkType))
#define IS_LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_TYPE))
#define LINK_TYPE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LINK_TYPE, LinkTypeIface))

typedef struct _LinkType LinkType;
typedef struct _LinkTypeIface LinkTypeIface;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_LINK_TYPE_STRAIGHT (link_type_straight_get_type ())
#define LINK_TYPE_STRAIGHT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_TYPE_STRAIGHT, LinkTypeStraight))
#define LINK_TYPE_STRAIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINK_TYPE_STRAIGHT, LinkTypeStraightClass))
#define IS_LINK_TYPE_STRAIGHT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_TYPE_STRAIGHT))
#define IS_LINK_TYPE_STRAIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINK_TYPE_STRAIGHT))
#define LINK_TYPE_STRAIGHT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINK_TYPE_STRAIGHT, LinkTypeStraightClass))

typedef struct _LinkTypeStraight LinkTypeStraight;
typedef struct _LinkTypeStraightClass LinkTypeStraightClass;
typedef struct _LinkTypeStraightPrivate LinkTypeStraightPrivate;
enum  {
	LINK_TYPE_STRAIGHT_0_PROPERTY,
	LINK_TYPE_STRAIGHT_NUM_PROPERTIES
};
static GParamSpec* link_type_straight_properties[LINK_TYPE_STRAIGHT_NUM_PROPERTIES];
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
#define _style_unref0(var) ((var == NULL) ? NULL : (var = (style_unref (var), NULL)))

struct _LinkTypeIface {
	GTypeInterface parent_iface;
	gchar* (*name) (LinkType* self);
	gchar* (*display_name) (LinkType* self);
	gchar* (*icon_name) (LinkType* self);
	void (*draw) (LinkType* self, cairo_t* ctx, Node* from_node, Node* to_node, gdouble from_x, gdouble from_y, gdouble to_x, gdouble to_y, gdouble* fx, gdouble* fy, gdouble* tx, gdouble* ty);
};

struct _LinkTypeStraight {
	GObject parent_instance;
	LinkTypeStraightPrivate * priv;
};

struct _LinkTypeStraightClass {
	GObjectClass parent_class;
};

static gpointer link_type_straight_parent_class = NULL;
static LinkTypeIface * link_type_straight_link_type_parent_iface = NULL;

VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType link_type_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkType, g_object_unref)
VALA_EXTERN GType link_type_straight_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkTypeStraight, g_object_unref)
VALA_EXTERN LinkTypeStraight* link_type_straight_new (void);
VALA_EXTERN LinkTypeStraight* link_type_straight_construct (GType object_type);
static gchar* link_type_straight_real_name (LinkType* base);
static gchar* link_type_straight_real_display_name (LinkType* base);
static gchar* link_type_straight_real_icon_name (LinkType* base);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
static gdouble link_type_straight_adjust_b (LinkTypeStraight* self,
                                     NodeSide side,
                                     gdouble adjust,
                                     gdouble x,
                                     gdouble y);
static gdouble link_type_straight_calc_to_x (LinkTypeStraight* self,
                                      Node* to_node,
                                      gboolean from_lt_to,
                                      gdouble adjusted,
                                      gdouble adjustA,
                                      gboolean* force);
VALA_EXTERN gdouble node_get_posx (Node* self);
VALA_EXTERN gdouble node_get_width (Node* self);
static gdouble link_type_straight_calc_to_y (LinkTypeStraight* self,
                                      Node* to_node,
                                      gboolean from_lt_to,
                                      gdouble adjusted,
                                      gdouble adjustA,
                                      gboolean* force);
VALA_EXTERN gdouble node_get_posy (Node* self);
VALA_EXTERN gdouble node_get_height (Node* self);
static void link_type_straight_real_draw (LinkType* base,
                                   cairo_t* ctx,
                                   Node* from_node,
                                   Node* to_node,
                                   gdouble from_x,
                                   gdouble from_y,
                                   gdouble to_x,
                                   gdouble to_y,
                                   gdouble* tailx,
                                   gdouble* taily,
                                   gdouble* tipx,
                                   gdouble* tipy);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN gdouble link_type_adjust_a (LinkType* self,
                            Style* style);
VALA_EXTERN gboolean* style_get_link_arrow (Style* self);
VALA_EXTERN gdouble link_type_adjust_tip (LinkType* self,
                              Style* style);
VALA_EXTERN gchar* link_type_name (LinkType* self);
VALA_EXTERN gchar* link_type_display_name (LinkType* self);
VALA_EXTERN gchar* link_type_icon_name (LinkType* self);
VALA_EXTERN void link_type_draw (LinkType* self,
                     cairo_t* ctx,
                     Node* from_node,
                     Node* to_node,
                     gdouble from_x,
                     gdouble from_y,
                     gdouble to_x,
                     gdouble to_y,
                     gdouble* fx,
                     gdouble* fy,
                     gdouble* tx,
                     gdouble* ty);
static GType link_type_straight_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

LinkTypeStraight*
link_type_straight_construct (GType object_type)
{
	LinkTypeStraight * self = NULL;
	self = (LinkTypeStraight*) g_object_new (object_type, NULL);
	return self;
}

LinkTypeStraight*
link_type_straight_new (void)
{
	return link_type_straight_construct (TYPE_LINK_TYPE_STRAIGHT);
}

static gchar*
link_type_straight_real_name (LinkType* base)
{
	LinkTypeStraight * self;
	gchar* _tmp0_;
	gchar* result;
	self = (LinkTypeStraight*) base;
	_tmp0_ = g_strdup ("straight");
	result = _tmp0_;
	return result;
}

static gchar*
link_type_straight_real_display_name (LinkType* base)
{
	LinkTypeStraight * self;
	gchar* _tmp0_;
	gchar* result;
	self = (LinkTypeStraight*) base;
	_tmp0_ = g_strdup (_ ("Straight"));
	result = _tmp0_;
	return result;
}

static gchar*
link_type_straight_real_icon_name (LinkType* base)
{
	LinkTypeStraight * self;
	gchar* _tmp0_;
	gchar* result;
	self = (LinkTypeStraight*) base;
	_tmp0_ = g_strdup ("minder-link-straight-symbolic");
	result = _tmp0_;
	return result;
}

static gdouble
link_type_straight_adjust_b (LinkTypeStraight* self,
                             NodeSide side,
                             gdouble adjust,
                             gdouble x,
                             gdouble y)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	switch (side) {
		case NODE_SIDE_LEFT:
		{
			result = (adjust * y) / x;
			return result;
		}
		case NODE_SIDE_RIGHT:
		{
			result = (adjust * y) / x;
			return result;
		}
		case NODE_SIDE_TOP:
		{
			result = (adjust * x) / y;
			return result;
		}
		case NODE_SIDE_BOTTOM:
		{
			result = (adjust * x) / y;
			return result;
		}
		default:
		break;
	}
	result = (gdouble) 0;
	return result;
}

static gdouble
link_type_straight_calc_to_x (LinkTypeStraight* self,
                              Node* to_node,
                              gboolean from_lt_to,
                              gdouble adjusted,
                              gdouble adjustA,
                              gboolean* force)
{
	gdouble left = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble right = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (to_node != NULL, 0.0);
	_tmp0_ = node_get_posx (to_node);
	_tmp1_ = _tmp0_;
	left = _tmp1_ - adjustA;
	_tmp2_ = node_get_posx (to_node);
	_tmp3_ = _tmp2_;
	_tmp4_ = node_get_width (to_node);
	_tmp5_ = _tmp4_;
	right = (_tmp3_ + _tmp5_) + adjustA;
	if (adjusted < left) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = adjusted > right;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = *force;
	}
	if (_tmp6_) {
		gdouble _tmp8_ = 0.0;
		*force = TRUE;
		if (from_lt_to) {
			_tmp8_ = left;
		} else {
			_tmp8_ = right;
		}
		result = _tmp8_;
		return result;
	}
	result = adjusted;
	return result;
}

static gdouble
link_type_straight_calc_to_y (LinkTypeStraight* self,
                              Node* to_node,
                              gboolean from_lt_to,
                              gdouble adjusted,
                              gdouble adjustA,
                              gboolean* force)
{
	gdouble top = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble bottom = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (to_node != NULL, 0.0);
	_tmp0_ = node_get_posy (to_node);
	_tmp1_ = _tmp0_;
	top = _tmp1_ - adjustA;
	_tmp2_ = node_get_posy (to_node);
	_tmp3_ = _tmp2_;
	_tmp4_ = node_get_height (to_node);
	_tmp5_ = _tmp4_;
	bottom = (_tmp3_ + _tmp5_) + adjustA;
	if (adjusted < top) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = adjusted > bottom;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = *force;
	}
	if (_tmp6_) {
		gdouble _tmp8_ = 0.0;
		*force = TRUE;
		if (from_lt_to) {
			_tmp8_ = top;
		} else {
			_tmp8_ = bottom;
		}
		result = _tmp8_;
		return result;
	}
	result = adjusted;
	return result;
}

static gpointer
_style_ref0 (gpointer self)
{
	return self ? style_ref (self) : NULL;
}

static void
link_type_straight_real_draw (LinkType* base,
                              cairo_t* ctx,
                              Node* from_node,
                              Node* to_node,
                              gdouble from_x,
                              gdouble from_y,
                              gdouble to_x,
                              gdouble to_y,
                              gdouble* tailx,
                              gdouble* taily,
                              gdouble* tipx,
                              gdouble* tipy)
{
	LinkTypeStraight * self;
	gdouble _vala_tailx = 0.0;
	gdouble _vala_taily = 0.0;
	gdouble _vala_tipx = 0.0;
	gdouble _vala_tipy = 0.0;
	Style* style = NULL;
	Style* _tmp0_;
	Style* _tmp1_;
	Style* _tmp2_;
	NodeSide side = 0;
	NodeSide _tmp3_;
	NodeSide _tmp4_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble adjustA = 0.0;
	Style* _tmp5_;
	gdouble _tmp6_ = 0.0;
	Style* _tmp7_;
	gboolean* _tmp8_;
	gboolean* _tmp9_;
	gdouble adjustB = 0.0;
	gdouble adjustT = 0.0;
	Style* _tmp10_;
	gboolean force = FALSE;
	self = (LinkTypeStraight*) base;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (from_node != NULL);
	g_return_if_fail (to_node != NULL);
	_tmp0_ = node_get_style (to_node);
	_tmp1_ = _tmp0_;
	_tmp2_ = _style_ref0 (_tmp1_);
	style = _tmp2_;
	_tmp3_ = node_get_side (to_node);
	_tmp4_ = _tmp3_;
	side = _tmp4_;
	x = to_x - from_x;
	y = to_y - from_y;
	_tmp5_ = style;
	adjustA = link_type_adjust_a ((LinkType*) self, _tmp5_);
	_tmp7_ = style;
	_tmp8_ = style_get_link_arrow (_tmp7_);
	_tmp9_ = _tmp8_;
	if (*_tmp9_) {
		_tmp6_ = link_type_straight_adjust_b (self, side, adjustA, x, y);
	} else {
		_tmp6_ = (gdouble) 0;
	}
	adjustB = _tmp6_;
	_tmp10_ = style;
	adjustT = link_type_adjust_tip ((LinkType*) self, _tmp10_);
	force = FALSE;
	_vala_tipy = (gdouble) 0;
	_vala_tipx = _vala_tipy;
	_vala_tailx = from_x;
	_vala_taily = from_y;
	switch (side) {
		case NODE_SIDE_LEFT:
		{
			gdouble _tmp11_;
			gdouble _tmp12_;
			to_x = to_x + adjustA;
			_tmp11_ = link_type_straight_calc_to_y (self, to_node, from_y < to_y, to_y + adjustB, adjustA, &force);
			to_y = _tmp11_;
			_vala_tipx = to_x - adjustT;
			_tmp12_ = link_type_straight_calc_to_y (self, to_node, from_y < to_y, to_y - link_type_straight_adjust_b (self, side, adjustT, x, y), adjustT, &force);
			_vala_tipy = _tmp12_;
			break;
		}
		case NODE_SIDE_RIGHT:
		{
			gdouble _tmp13_;
			gdouble _tmp14_;
			to_x = to_x - adjustA;
			_tmp13_ = link_type_straight_calc_to_y (self, to_node, from_y < to_y, to_y - adjustB, adjustA, &force);
			to_y = _tmp13_;
			_vala_tipx = to_x + adjustT;
			_tmp14_ = link_type_straight_calc_to_y (self, to_node, from_y < to_y, to_y + link_type_straight_adjust_b (self, side, adjustT, x, y), adjustT, &force);
			_vala_tipy = _tmp14_;
			break;
		}
		case NODE_SIDE_TOP:
		{
			gdouble _tmp15_;
			gdouble _tmp16_;
			to_y = to_y + adjustA;
			_tmp15_ = link_type_straight_calc_to_x (self, to_node, from_x < to_x, to_x + adjustB, adjustA, &force);
			to_x = _tmp15_;
			_vala_tipy = to_y - adjustT;
			_tmp16_ = link_type_straight_calc_to_x (self, to_node, from_x < to_x, to_x - link_type_straight_adjust_b (self, side, adjustT, x, y), adjustT, &force);
			_vala_tipx = _tmp16_;
			break;
		}
		case NODE_SIDE_BOTTOM:
		{
			gdouble _tmp17_;
			gdouble _tmp18_;
			to_y = to_y - adjustA;
			_tmp17_ = link_type_straight_calc_to_x (self, to_node, from_x < to_x, to_x - adjustB, adjustA, &force);
			to_x = _tmp17_;
			_vala_tipy = to_y + adjustT;
			_tmp18_ = link_type_straight_calc_to_x (self, to_node, from_x < to_x, to_x + link_type_straight_adjust_b (self, side, adjustT, x, y), adjustT, &force);
			_vala_tipx = _tmp18_;
			break;
		}
		default:
		break;
	}
	cairo_move_to (ctx, from_x, from_y);
	cairo_line_to (ctx, to_x, to_y);
	cairo_stroke (ctx);
	_style_unref0 (style);
	if (tailx) {
		*tailx = _vala_tailx;
	}
	if (taily) {
		*taily = _vala_taily;
	}
	if (tipx) {
		*tipx = _vala_tipx;
	}
	if (tipy) {
		*tipy = _vala_tipy;
	}
}

static void
link_type_straight_class_init (LinkTypeStraightClass * klass,
                               gpointer klass_data)
{
	link_type_straight_parent_class = g_type_class_peek_parent (klass);
}

static void
link_type_straight_link_type_interface_init (LinkTypeIface * iface,
                                             gpointer iface_data)
{
	link_type_straight_link_type_parent_iface = g_type_interface_peek_parent (iface);
	iface->name = (gchar* (*) (LinkType*)) link_type_straight_real_name;
	iface->display_name = (gchar* (*) (LinkType*)) link_type_straight_real_display_name;
	iface->icon_name = (gchar* (*) (LinkType*)) link_type_straight_real_icon_name;
	iface->draw = (void (*) (LinkType*, cairo_t*, Node*, Node*, gdouble, gdouble, gdouble, gdouble, gdouble*, gdouble*, gdouble*, gdouble*)) link_type_straight_real_draw;
}

static void
link_type_straight_instance_init (LinkTypeStraight * self,
                                  gpointer klass)
{
}

static GType
link_type_straight_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LinkTypeStraightClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) link_type_straight_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LinkTypeStraight), 0, (GInstanceInitFunc) link_type_straight_instance_init, NULL };
	static const GInterfaceInfo link_type_info = { (GInterfaceInitFunc) link_type_straight_link_type_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType link_type_straight_type_id;
	link_type_straight_type_id = g_type_register_static (G_TYPE_OBJECT, "LinkTypeStraight", &g_define_type_info, 0);
	g_type_add_interface_static (link_type_straight_type_id, TYPE_LINK_TYPE, &link_type_info);
	return link_type_straight_type_id;
}

GType
link_type_straight_get_type (void)
{
	static volatile gsize link_type_straight_type_id__once = 0;
	if (g_once_init_enter (&link_type_straight_type_id__once)) {
		GType link_type_straight_type_id;
		link_type_straight_type_id = link_type_straight_get_type_once ();
		g_once_init_leave (&link_type_straight_type_id__once, link_type_straight_type_id);
	}
	return link_type_straight_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

