/*
 SPDX-License-Identifier: GPL-3.0-or-later
 myMPD (c) 2018-2025 Juergen Mang <mail@jcgames.de>
 https://github.com/jcorporation/mympd
*/

/*! \file
 * \brief MPD error handling
 */

#ifndef MYMPD_MPD_CLIENT_ERRORHANDLER_H
#define MYMPD_MPD_CLIENT_ERRORHANDLER_H

#include "dist/sds/sds.h"
#include "src/lib/api.h"
#include "src/lib/mympd_state.h"

void mympd_set_mpd_failure(struct t_partition_state *partition_state, const char *errormessage);
bool mympd_check_error_and_recover(struct t_partition_state *partition_state, sds *error, const char *command);
bool mympd_check_error_and_recover_respond(struct t_partition_state *partition_state, sds *buffer,
        enum mympd_cmd_ids cmd_id, unsigned request_id, const char *command);
bool mympd_check_error_and_recover_notify(struct t_partition_state *partition_state, sds *buffer, const char *command);
bool mympd_check_error_and_recover_plain(struct t_partition_state *partition_state, sds *buffer, const char *command);
sds mympd_respond_with_error_or_ok(struct t_partition_state *partition_state, sds buffer, enum mympd_cmd_ids cmd_id,
        unsigned request_id, const char *command, bool *result);
bool mympd_clear_finish(struct t_partition_state *partition_state);

#endif
