// Copyright (c) Microsoft Corporation. All rights reserved.
// Copyright (c) 2023 NVIDIA Corporation.
// Licensed under the MIT License.

#pragma once

#include "core/providers/rocm/nn/conv_transpose.h"

namespace onnxruntime {
namespace contrib {
namespace rocm {

template <typename T>
class ConvTransposeWithDynamicPads : public ::onnxruntime::rocm::ConvTranspose<T, false> {
 public:
  ConvTransposeWithDynamicPads(const OpKernelInfo& info) : ::onnxruntime::rocm::ConvTranspose<T, false>(info) {}

  Status ComputeInternal(OpKernelContext* context) const override {
    return ::onnxruntime::rocm::ConvTranspose<T, false>::DoConvTranspose(context, true);
  }
};
}  // namespace rocm
}  // namespace contrib
}  // namespace onnxruntime
