/* GridView.c generated by valac 0.56.18, the Vala compiler
 * generated from GridView.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *           2011-2012 Giulio Collura
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <handy.h>
#include <gdk/gdk.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SLINGSHOT_WIDGETS_GRID_TYPE_PAGE (slingshot_widgets_grid_page_get_type ())
typedef struct _SlingshotWidgetsGridPage SlingshotWidgetsGridPage;
enum  {
	SLINGSHOT_WIDGETS_GRID_0_PROPERTY,
	SLINGSHOT_WIDGETS_GRID_FOCUSED_COLUMN_PROPERTY,
	SLINGSHOT_WIDGETS_GRID_FOCUSED_ROW_PROPERTY,
	SLINGSHOT_WIDGETS_GRID_CURRENT_GRID_KEY_PROPERTY,
	SLINGSHOT_WIDGETS_GRID_NUM_PROPERTIES
};
static GParamSpec* slingshot_widgets_grid_properties[SLINGSHOT_WIDGETS_GRID_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SLINGSHOT_WIDGETS_GRID_APP_LAUNCHED_SIGNAL,
	SLINGSHOT_WIDGETS_GRID_NUM_SIGNALS
};
static guint slingshot_widgets_grid_signals[SLINGSHOT_WIDGETS_GRID_NUM_SIGNALS] = {0};

struct _SlingshotWidgetsGridPage {
	guint rows;
	guint columns;
};

struct _SlingshotWidgetsGridPrivate {
	GtkGrid* current_grid;
	GeeHashMap* grids;
	HdyCarousel* paginator;
	SlingshotWidgetsGridPage page;
	guint _focused_column;
	guint _focused_row;
	guint _current_grid_key;
};

static gint SlingshotWidgetsGrid_private_offset;
static gpointer slingshot_widgets_grid_parent_class = NULL;

static GType slingshot_widgets_grid_page_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SlingshotWidgetsGridPage* slingshot_widgets_grid_page_dup (const SlingshotWidgetsGridPage* self);
static void slingshot_widgets_grid_page_free (SlingshotWidgetsGridPage* self);
static void slingshot_widgets_grid_add_new_grid (SlingshotWidgetsGrid* self);
static void ____lambda45_ (SlingshotWidgetsGrid* self);
static void _____lambda45__slingshot_widgets_app_button_app_launched (SlingshotWidgetsAppButton* _sender,
                                                               gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static GtkWidget* slingshot_widgets_grid_get_widget_at (SlingshotWidgetsGrid* self,
                                                 guint col,
                                                 guint row);
static void slingshot_widgets_grid_refocus (SlingshotWidgetsGrid* self);
static gboolean slingshot_widgets_grid_real_key_press_event (GtkWidget* base,
                                                      GdkEventKey* event);
static void slingshot_widgets_grid_move_left (SlingshotWidgetsGrid* self,
                                       GdkEventKey* event);
static void slingshot_widgets_grid_move_right (SlingshotWidgetsGrid* self,
                                        GdkEventKey* event);
static GObject * slingshot_widgets_grid_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static gboolean _slingshot_widgets_grid___lambda50_ (SlingshotWidgetsGrid* self);
static gboolean __slingshot_widgets_grid___lambda50__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                         GdkEventFocus* event,
                                                                         gpointer self);
static void slingshot_widgets_grid_finalize (GObject * obj);
static GType slingshot_widgets_grid_get_type_once (void);
static void _vala_slingshot_widgets_grid_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_slingshot_widgets_grid_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
slingshot_widgets_grid_get_instance_private (SlingshotWidgetsGrid* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotWidgetsGrid_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
____lambda45_ (SlingshotWidgetsGrid* self)
{
	g_signal_emit (self, slingshot_widgets_grid_signals[SLINGSHOT_WIDGETS_GRID_APP_LAUNCHED_SIGNAL], 0);
}

static void
_____lambda45__slingshot_widgets_app_button_app_launched (SlingshotWidgetsAppButton* _sender,
                                                          gpointer self)
{
	____lambda45_ ((SlingshotWidgetsGrid*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
slingshot_widgets_grid_populate (SlingshotWidgetsGrid* self,
                                 SlingshotBackendAppSystem* app_system)
{
	GeeHashMap* _tmp10_;
	gint next_row_index = 0;
	gint next_col_index = 0;
	GSList* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_system != NULL);
	{
		GeeIterator* _grid_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->grids;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_grid_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GtkGrid* grid = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GtkGrid* _tmp9_;
			_tmp6_ = _grid_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _grid_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			grid = (GtkGrid*) _tmp8_;
			_tmp9_ = grid;
			gtk_widget_destroy ((GtkWidget*) _tmp9_);
			_g_object_unref0 (grid);
		}
		_g_object_unref0 (_grid_it);
	}
	_tmp10_ = self->priv->grids;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp10_);
	self->priv->_current_grid_key = (guint) 0;
	slingshot_widgets_grid_add_new_grid (self);
	next_row_index = 0;
	next_col_index = 0;
	_tmp11_ = slingshot_backend_app_system_get_apps_by_name (app_system);
	{
		GSList* app_collection = NULL;
		GSList* app_it = NULL;
		app_collection = _tmp11_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			SlingshotBackendApp* _tmp12_;
			SlingshotBackendApp* app = NULL;
			_tmp12_ = _g_object_ref0 ((SlingshotBackendApp*) app_it->data);
			app = _tmp12_;
			{
				SlingshotWidgetsAppButton* app_button = NULL;
				SlingshotBackendApp* _tmp13_;
				SlingshotWidgetsAppButton* _tmp14_;
				SlingshotWidgetsAppButton* _tmp15_;
				SlingshotWidgetsGridPage _tmp16_;
				SlingshotWidgetsGridPage _tmp18_;
				GtkGrid* _tmp19_;
				SlingshotWidgetsAppButton* _tmp20_;
				gint _tmp21_;
				_tmp13_ = app;
				_tmp14_ = slingshot_widgets_app_button_new (_tmp13_);
				g_object_ref_sink (_tmp14_);
				app_button = _tmp14_;
				_tmp15_ = app_button;
				g_signal_connect_object (_tmp15_, "app-launched", (GCallback) _____lambda45__slingshot_widgets_app_button_app_launched, self, 0);
				_tmp16_ = self->priv->page;
				if (((guint) next_col_index) == _tmp16_.columns) {
					gint _tmp17_;
					next_col_index = 0;
					_tmp17_ = next_row_index;
					next_row_index = _tmp17_ + 1;
				}
				_tmp18_ = self->priv->page;
				if (((guint) next_row_index) == _tmp18_.rows) {
					slingshot_widgets_grid_add_new_grid (self);
					next_row_index = 0;
					next_col_index = 0;
				}
				_tmp19_ = self->priv->current_grid;
				_tmp20_ = app_button;
				gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp20_, (gint) next_col_index, (gint) next_row_index, 1, 1);
				_tmp21_ = next_col_index;
				next_col_index = _tmp21_ + 1;
				_g_object_unref0 (app_button);
				_g_object_unref0 (app);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_slist_free__g_object_unref0_ (app_collection), NULL));
	}
	gtk_widget_show_all ((GtkWidget*) self);
	slingshot_widgets_grid_set_current_grid_key (self, (guint) 1);
}

static void
slingshot_widgets_grid_add_new_grid (SlingshotWidgetsGrid* self)
{
	GtkGrid* _tmp0_ = NULL;
	HdyCarousel* _tmp10_;
	GtkGrid* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	GeeHashMap* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	GtkGrid* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_set ((GtkWidget*) _tmp0_, "expand", TRUE, NULL);
	gtk_grid_set_row_homogeneous (_tmp0_, TRUE);
	gtk_grid_set_column_homogeneous (_tmp0_, TRUE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp0_, 12);
	gtk_grid_set_row_spacing (_tmp0_, 24);
	gtk_grid_set_column_spacing (_tmp0_, 0);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->current_grid);
	self->priv->current_grid = _tmp0_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				SlingshotWidgetsGridPage _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = row;
					row = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->page;
				if (!(((guint) row) < _tmp3_.rows)) {
					break;
				}
				{
					gint column = 0;
					column = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							SlingshotWidgetsGridPage _tmp6_;
							GtkGrid* _tmp7_;
							GtkGrid* _tmp8_;
							GtkGrid* _tmp9_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = column;
								column = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = self->priv->page;
							if (!(((guint) column) < _tmp6_.columns)) {
								break;
							}
							_tmp7_ = self->priv->current_grid;
							_tmp8_ = (GtkGrid*) gtk_grid_new ();
							g_object_ref_sink (_tmp8_);
							_tmp9_ = _tmp8_;
							gtk_grid_attach (_tmp7_, (GtkWidget*) _tmp9_, column, row, 1, 1);
							_g_object_unref0 (_tmp9_);
						}
					}
				}
			}
		}
	}
	_tmp10_ = self->priv->paginator;
	_tmp11_ = self->priv->current_grid;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = slingshot_widgets_grid_get_current_grid_key (self);
	_tmp13_ = _tmp12_;
	slingshot_widgets_grid_set_current_grid_key (self, _tmp13_ + 1);
	_tmp14_ = self->priv->grids;
	_tmp15_ = slingshot_widgets_grid_get_current_grid_key (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->current_grid;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, (gpointer) ((guintptr) _tmp16_), _tmp17_);
}

static GtkWidget*
slingshot_widgets_grid_get_widget_at (SlingshotWidgetsGrid* self,
                                      guint col,
                                      guint row)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (col < ((guint) 1)) {
		_tmp2_ = TRUE;
	} else {
		SlingshotWidgetsGridPage _tmp3_;
		_tmp3_ = self->priv->page;
		_tmp2_ = col > _tmp3_.columns;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = row < ((guint) 1);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		SlingshotWidgetsGridPage _tmp4_;
		_tmp4_ = self->priv->page;
		_tmp0_ = row > _tmp4_.rows;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	} else {
		GtkGrid* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp5_ = self->priv->current_grid;
		_tmp6_ = gtk_grid_get_child_at (_tmp5_, ((gint) col) - 1, ((gint) row) - 1);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		result = _tmp7_;
		return result;
	}
}

static void
slingshot_widgets_grid_refocus (SlingshotWidgetsGrid* self)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = slingshot_widgets_grid_get_focused_row (self);
	_tmp1_ = _tmp0_;
	slingshot_widgets_grid_set_focused_row (self, _tmp1_);
	_tmp2_ = slingshot_widgets_grid_get_focused_column (self);
	_tmp3_ = _tmp2_;
	slingshot_widgets_grid_set_focused_column (self, _tmp3_);
}

void
slingshot_widgets_grid_go_to_next (SlingshotWidgetsGrid* self)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = slingshot_widgets_grid_get_current_grid_key (self);
	_tmp1_ = _tmp0_;
	slingshot_widgets_grid_set_current_grid_key (self, _tmp1_ + 1);
}

void
slingshot_widgets_grid_go_to_previous (SlingshotWidgetsGrid* self)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = slingshot_widgets_grid_get_current_grid_key (self);
	_tmp1_ = _tmp0_;
	slingshot_widgets_grid_set_current_grid_key (self, _tmp1_ - 1);
}

void
slingshot_widgets_grid_go_to_last (SlingshotWidgetsGrid* self)
{
	HdyCarousel* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->paginator;
	_tmp1_ = hdy_carousel_get_n_pages (_tmp0_);
	_tmp2_ = _tmp1_;
	slingshot_widgets_grid_set_current_grid_key (self, _tmp2_);
}

void
slingshot_widgets_grid_go_to_number (SlingshotWidgetsGrid* self,
                                     gint number)
{
	g_return_if_fail (self != NULL);
	slingshot_widgets_grid_set_current_grid_key (self, (guint) number);
}

static gboolean
slingshot_widgets_grid_real_key_press_event (GtkWidget* base,
                                             GdkEventKey* event)
{
	SlingshotWidgetsGrid * self;
	gboolean result;
	self = (SlingshotWidgetsGrid*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->keyval) {
		case GDK_KEY_Home:
		case GDK_KEY_KP_Home:
		{
			slingshot_widgets_grid_set_current_grid_key (self, (guint) 1);
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Left:
		case GDK_KEY_KP_Left:
		{
			GtkStyleContext* _tmp0_;
			GtkTextDirection _tmp1_;
			GtkTextDirection _tmp2_;
			_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
			_tmp1_ = gtk_style_context_get_direction (_tmp0_);
			_tmp2_ = _tmp1_;
			if (_tmp2_ == GTK_TEXT_DIR_LTR) {
				slingshot_widgets_grid_move_left (self, event);
			} else {
				slingshot_widgets_grid_move_right (self, event);
			}
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Right:
		case GDK_KEY_KP_Right:
		{
			GtkStyleContext* _tmp3_;
			GtkTextDirection _tmp4_;
			GtkTextDirection _tmp5_;
			_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
			_tmp4_ = gtk_style_context_get_direction (_tmp3_);
			_tmp5_ = _tmp4_;
			if (_tmp5_ == GTK_TEXT_DIR_LTR) {
				slingshot_widgets_grid_move_right (self, event);
			} else {
				slingshot_widgets_grid_move_left (self, event);
			}
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Up:
		case GDK_KEY_KP_Up:
		{
			if (self->priv->_focused_row == ((guint) 1)) {
				break;
			} else {
				guint _tmp6_;
				guint _tmp7_;
				_tmp6_ = slingshot_widgets_grid_get_focused_row (self);
				_tmp7_ = _tmp6_;
				slingshot_widgets_grid_set_focused_row (self, _tmp7_ - 1);
				result = GDK_EVENT_STOP;
				return result;
			}
		}
		case GDK_KEY_Down:
		case GDK_KEY_KP_Down:
		{
			guint _tmp8_;
			guint _tmp9_;
			_tmp8_ = slingshot_widgets_grid_get_focused_row (self);
			_tmp9_ = _tmp8_;
			slingshot_widgets_grid_set_focused_row (self, _tmp9_ + 1);
			result = GDK_EVENT_STOP;
			return result;
		}
		default:
		break;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
slingshot_widgets_grid_move_left (SlingshotWidgetsGrid* self,
                                  GdkEventKey* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	if ((event->state & GDK_SHIFT_MASK) > 0) {
		guint _tmp0_;
		guint _tmp1_;
		_tmp0_ = slingshot_widgets_grid_get_current_grid_key (self);
		_tmp1_ = _tmp0_;
		slingshot_widgets_grid_set_current_grid_key (self, _tmp1_ - 1);
	} else {
		gboolean _tmp2_ = FALSE;
		guint _tmp3_;
		guint _tmp4_;
		_tmp3_ = slingshot_widgets_grid_get_focused_column (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == ((guint) 1)) {
			guint _tmp5_;
			guint _tmp6_;
			_tmp5_ = slingshot_widgets_grid_get_current_grid_key (self);
			_tmp6_ = _tmp5_;
			_tmp2_ = _tmp6_ > ((guint) 1);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			guint _tmp7_;
			guint _tmp8_;
			SlingshotWidgetsGridPage _tmp9_;
			_tmp7_ = slingshot_widgets_grid_get_current_grid_key (self);
			_tmp8_ = _tmp7_;
			slingshot_widgets_grid_set_current_grid_key (self, _tmp8_ - 1);
			_tmp9_ = self->priv->page;
			slingshot_widgets_grid_set_focused_column (self, _tmp9_.columns);
		} else {
			guint _tmp10_;
			guint _tmp11_;
			_tmp10_ = slingshot_widgets_grid_get_focused_column (self);
			_tmp11_ = _tmp10_;
			slingshot_widgets_grid_set_focused_column (self, _tmp11_ - 1);
		}
	}
}

static void
slingshot_widgets_grid_move_right (SlingshotWidgetsGrid* self,
                                   GdkEventKey* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	if ((event->state & GDK_SHIFT_MASK) > 0) {
		guint _tmp0_;
		guint _tmp1_;
		_tmp0_ = slingshot_widgets_grid_get_current_grid_key (self);
		_tmp1_ = _tmp0_;
		slingshot_widgets_grid_set_current_grid_key (self, _tmp1_ + 1);
	} else {
		gboolean _tmp2_ = FALSE;
		guint _tmp3_;
		guint _tmp4_;
		SlingshotWidgetsGridPage _tmp5_;
		_tmp3_ = slingshot_widgets_grid_get_focused_column (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->page;
		if (_tmp4_ == _tmp5_.columns) {
			guint _tmp6_;
			guint _tmp7_;
			HdyCarousel* _tmp8_;
			guint _tmp9_;
			guint _tmp10_;
			_tmp6_ = slingshot_widgets_grid_get_current_grid_key (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->paginator;
			_tmp9_ = hdy_carousel_get_n_pages (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp2_ = _tmp7_ < _tmp10_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			guint _tmp11_;
			guint _tmp12_;
			_tmp11_ = slingshot_widgets_grid_get_current_grid_key (self);
			_tmp12_ = _tmp11_;
			slingshot_widgets_grid_set_current_grid_key (self, _tmp12_ + 1);
			slingshot_widgets_grid_set_focused_column (self, (guint) 1);
		} else {
			guint _tmp13_;
			guint _tmp14_;
			_tmp13_ = slingshot_widgets_grid_get_focused_column (self);
			_tmp14_ = _tmp13_;
			slingshot_widgets_grid_set_focused_column (self, _tmp14_ + 1);
		}
	}
}

SlingshotWidgetsGrid*
slingshot_widgets_grid_construct (GType object_type)
{
	SlingshotWidgetsGrid * self = NULL;
	self = (SlingshotWidgetsGrid*) g_object_new (object_type, NULL);
	return self;
}

SlingshotWidgetsGrid*
slingshot_widgets_grid_new (void)
{
	return slingshot_widgets_grid_construct (SLINGSHOT_WIDGETS_TYPE_GRID);
}

guint
slingshot_widgets_grid_get_focused_column (SlingshotWidgetsGrid* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_focused_column;
	return result;
}

void
slingshot_widgets_grid_set_focused_column (SlingshotWidgetsGrid* self,
                                           guint value)
{
	guint target_column = 0U;
	SlingshotWidgetsGridPage _tmp0_;
	GtkWidget* target = NULL;
	GtkWidget* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page;
	target_column = CLAMP (value, (guint) 1, _tmp0_.columns);
	_tmp1_ = slingshot_widgets_grid_get_widget_at (self, target_column, self->priv->_focused_row);
	target = _tmp1_;
	_tmp3_ = target;
	if (_tmp3_ != NULL) {
		GtkWidget* _tmp4_;
		_tmp4_ = target;
		_tmp2_ = SLINGSHOT_WIDGETS_IS_APP_BUTTON (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkWidget* _tmp5_;
		self->priv->_focused_column = target_column;
		_tmp5_ = target;
		gtk_widget_grab_focus (_tmp5_);
	}
	_g_object_unref0 (target);
	g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_grid_properties[SLINGSHOT_WIDGETS_GRID_FOCUSED_COLUMN_PROPERTY]);
}

guint
slingshot_widgets_grid_get_focused_row (SlingshotWidgetsGrid* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_focused_row;
	return result;
}

void
slingshot_widgets_grid_set_focused_row (SlingshotWidgetsGrid* self,
                                        guint value)
{
	guint target_row = 0U;
	SlingshotWidgetsGridPage _tmp0_;
	GtkWidget* target = NULL;
	GtkWidget* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page;
	target_row = CLAMP (value, (guint) 1, _tmp0_.rows);
	_tmp1_ = slingshot_widgets_grid_get_widget_at (self, self->priv->_focused_column, target_row);
	target = _tmp1_;
	_tmp3_ = target;
	if (_tmp3_ != NULL) {
		GtkWidget* _tmp4_;
		_tmp4_ = target;
		_tmp2_ = SLINGSHOT_WIDGETS_IS_APP_BUTTON (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkWidget* _tmp5_;
		self->priv->_focused_row = target_row;
		_tmp5_ = target;
		gtk_widget_grab_focus (_tmp5_);
	}
	_g_object_unref0 (target);
	g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_grid_properties[SLINGSHOT_WIDGETS_GRID_FOCUSED_ROW_PROPERTY]);
}

guint
slingshot_widgets_grid_get_current_grid_key (SlingshotWidgetsGrid* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_current_grid_key;
	return result;
}

void
slingshot_widgets_grid_set_current_grid_key (SlingshotWidgetsGrid* self,
                                             guint value)
{
	HdyCarousel* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GtkGrid* grid = NULL;
	GeeHashMap* _tmp3_;
	gpointer _tmp4_;
	GtkGrid* _tmp5_;
	HdyCarousel* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->paginator;
	_tmp1_ = hdy_carousel_get_n_pages (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->_current_grid_key = CLAMP (value, (guint) 1, _tmp2_);
	_tmp3_ = self->priv->grids;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, (gpointer) ((guintptr) self->priv->_current_grid_key));
	grid = (GtkGrid*) _tmp4_;
	_tmp5_ = grid;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (grid);
		return;
	}
	_tmp6_ = self->priv->paginator;
	_tmp7_ = grid;
	hdy_carousel_scroll_to (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = grid;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->current_grid);
	self->priv->current_grid = _tmp9_;
	slingshot_widgets_grid_refocus (self);
	_g_object_unref0 (grid);
	g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_grid_properties[SLINGSHOT_WIDGETS_GRID_CURRENT_GRID_KEY_PROPERTY]);
}

static SlingshotWidgetsGridPage*
slingshot_widgets_grid_page_dup (const SlingshotWidgetsGridPage* self)
{
	SlingshotWidgetsGridPage* dup;
	dup = g_new0 (SlingshotWidgetsGridPage, 1);
	memcpy (dup, self, sizeof (SlingshotWidgetsGridPage));
	return dup;
}

static void
slingshot_widgets_grid_page_free (SlingshotWidgetsGridPage* self)
{
	g_free (self);
}

static GType
slingshot_widgets_grid_page_get_type_once (void)
{
	GType slingshot_widgets_grid_page_type_id;
	slingshot_widgets_grid_page_type_id = g_boxed_type_register_static ("SlingshotWidgetsGridPage", (GBoxedCopyFunc) slingshot_widgets_grid_page_dup, (GBoxedFreeFunc) slingshot_widgets_grid_page_free);
	return slingshot_widgets_grid_page_type_id;
}

static GType
slingshot_widgets_grid_page_get_type (void)
{
	static volatile gsize slingshot_widgets_grid_page_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_grid_page_type_id__once)) {
		GType slingshot_widgets_grid_page_type_id;
		slingshot_widgets_grid_page_type_id = slingshot_widgets_grid_page_get_type_once ();
		g_once_init_leave (&slingshot_widgets_grid_page_type_id__once, slingshot_widgets_grid_page_type_id);
	}
	return slingshot_widgets_grid_page_type_id__once;
}

static gboolean
_slingshot_widgets_grid___lambda50_ (SlingshotWidgetsGrid* self)
{
	gboolean result;
	slingshot_widgets_grid_refocus (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__slingshot_widgets_grid___lambda50__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                GdkEventFocus* event,
                                                                gpointer self)
{
	gboolean result;
	result = _slingshot_widgets_grid___lambda50_ ((SlingshotWidgetsGrid*) self);
	return result;
}

static GObject *
slingshot_widgets_grid_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotWidgetsGrid * self;
	HdyCarousel* _tmp0_;
	HdyCarousel* _tmp1_;
	SlingshotWidgetsSwitcher* page_switcher = NULL;
	SlingshotWidgetsSwitcher* _tmp2_;
	SlingshotWidgetsSwitcher* _tmp3_;
	HdyCarousel* _tmp4_;
	HdyCarousel* _tmp5_;
	SlingshotWidgetsSwitcher* _tmp6_;
	GeeHashMap* _tmp7_;
	parent_class = G_OBJECT_CLASS (slingshot_widgets_grid_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_GRID, SlingshotWidgetsGrid);
	self->priv->page.rows = (guint) 3;
	self->priv->page.columns = (guint) 5;
	_tmp0_ = (HdyCarousel*) hdy_carousel_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->paginator);
	self->priv->paginator = _tmp0_;
	_tmp1_ = self->priv->paginator;
	g_object_set ((GtkWidget*) _tmp1_, "expand", TRUE, NULL);
	_tmp2_ = slingshot_widgets_switcher_new ();
	g_object_ref_sink (_tmp2_);
	page_switcher = _tmp2_;
	_tmp3_ = page_switcher;
	_tmp4_ = self->priv->paginator;
	slingshot_widgets_switcher_set_paginator (_tmp3_, _tmp4_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	_tmp5_ = self->priv->paginator;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = page_switcher;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, gtk_grid_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->grids);
	self->priv->grids = _tmp7_;
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) __slingshot_widgets_grid___lambda50__gtk_widget_focus_in_event, self, G_CONNECT_AFTER);
	_g_object_unref0 (page_switcher);
	return obj;
}

static void
slingshot_widgets_grid_class_init (SlingshotWidgetsGridClass * klass,
                                   gpointer klass_data)
{
	slingshot_widgets_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotWidgetsGrid_private_offset);
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) slingshot_widgets_grid_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_widgets_grid_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_widgets_grid_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_widgets_grid_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_widgets_grid_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_GRID_FOCUSED_COLUMN_PROPERTY, slingshot_widgets_grid_properties[SLINGSHOT_WIDGETS_GRID_FOCUSED_COLUMN_PROPERTY] = g_param_spec_uint ("focused-column", "focused-column", "focused-column", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_GRID_FOCUSED_ROW_PROPERTY, slingshot_widgets_grid_properties[SLINGSHOT_WIDGETS_GRID_FOCUSED_ROW_PROPERTY] = g_param_spec_uint ("focused-row", "focused-row", "focused-row", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_GRID_CURRENT_GRID_KEY_PROPERTY, slingshot_widgets_grid_properties[SLINGSHOT_WIDGETS_GRID_CURRENT_GRID_KEY_PROPERTY] = g_param_spec_uint ("current-grid-key", "current-grid-key", "current-grid-key", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	slingshot_widgets_grid_signals[SLINGSHOT_WIDGETS_GRID_APP_LAUNCHED_SIGNAL] = g_signal_new ("app-launched", SLINGSHOT_WIDGETS_TYPE_GRID, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_widgets_grid_instance_init (SlingshotWidgetsGrid * self,
                                      gpointer klass)
{
	self->priv = slingshot_widgets_grid_get_instance_private (self);
	self->priv->_focused_column = (guint) 1;
	self->priv->_focused_row = (guint) 1;
	self->priv->_current_grid_key = (guint) 0;
}

static void
slingshot_widgets_grid_finalize (GObject * obj)
{
	SlingshotWidgetsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_GRID, SlingshotWidgetsGrid);
	_g_object_unref0 (self->priv->current_grid);
	_g_object_unref0 (self->priv->grids);
	_g_object_unref0 (self->priv->paginator);
	G_OBJECT_CLASS (slingshot_widgets_grid_parent_class)->finalize (obj);
}

static GType
slingshot_widgets_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotWidgetsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_widgets_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotWidgetsGrid), 0, (GInstanceInitFunc) slingshot_widgets_grid_instance_init, NULL };
	GType slingshot_widgets_grid_type_id;
	slingshot_widgets_grid_type_id = g_type_register_static (gtk_grid_get_type (), "SlingshotWidgetsGrid", &g_define_type_info, 0);
	SlingshotWidgetsGrid_private_offset = g_type_add_instance_private (slingshot_widgets_grid_type_id, sizeof (SlingshotWidgetsGridPrivate));
	return slingshot_widgets_grid_type_id;
}

GType
slingshot_widgets_grid_get_type (void)
{
	static volatile gsize slingshot_widgets_grid_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_grid_type_id__once)) {
		GType slingshot_widgets_grid_type_id;
		slingshot_widgets_grid_type_id = slingshot_widgets_grid_get_type_once ();
		g_once_init_leave (&slingshot_widgets_grid_type_id__once, slingshot_widgets_grid_type_id);
	}
	return slingshot_widgets_grid_type_id__once;
}

static void
_vala_slingshot_widgets_grid_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotWidgetsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_GRID, SlingshotWidgetsGrid);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_GRID_FOCUSED_COLUMN_PROPERTY:
		g_value_set_uint (value, slingshot_widgets_grid_get_focused_column (self));
		break;
		case SLINGSHOT_WIDGETS_GRID_FOCUSED_ROW_PROPERTY:
		g_value_set_uint (value, slingshot_widgets_grid_get_focused_row (self));
		break;
		case SLINGSHOT_WIDGETS_GRID_CURRENT_GRID_KEY_PROPERTY:
		g_value_set_uint (value, slingshot_widgets_grid_get_current_grid_key (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_widgets_grid_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotWidgetsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_GRID, SlingshotWidgetsGrid);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_GRID_FOCUSED_COLUMN_PROPERTY:
		slingshot_widgets_grid_set_focused_column (self, g_value_get_uint (value));
		break;
		case SLINGSHOT_WIDGETS_GRID_FOCUSED_ROW_PROPERTY:
		slingshot_widgets_grid_set_focused_row (self, g_value_get_uint (value));
		break;
		case SLINGSHOT_WIDGETS_GRID_CURRENT_GRID_KEY_PROPERTY:
		slingshot_widgets_grid_set_current_grid_key (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

