/* GitManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GitManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2020 elementary LLC. (https://elementary.io),
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jeremy Wootten <jeremy@elementaryos.org>
 */

#include "codecore.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_SERVICES_GIT_MANAGER_0_PROPERTY,
	SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY,
	SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY,
	SCRATCH_SERVICES_GIT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block34Data Block34Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define __vala_GgitFetchOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitFetchOptions_free (var), NULL)))
typedef struct _ScratchServicesGitManagerCloneRepositoryData ScratchServicesGitManagerCloneRepositoryData;

struct _ScratchServicesGitManagerPrivate {
	GListStore* _project_liststore;
	gchar* _active_project_path;
};

struct _Block34Data {
	int _ref_count_;
	ScratchServicesGitManager* self;
	GgitCloneOptions* clone_options;
	gchar* e_message;
	GFile* folder_file;
	GgitRepository* new_repo;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gchar* uri;
	gpointer _async_data_;
};

struct _ScratchServicesGitManagerCloneRepositoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesGitManager* self;
	gchar* uri;
	gchar* local_folder;
	GFile* repo_workdir;
	gchar* _error_;
	gboolean result;
	Block34Data* _data34_;
	GgitFetchOptions* fetch_options;
	GgitFetchOptions* _tmp0_;
	GgitFetchOptions* _tmp1_;
	GgitFetchOptions* _tmp2_;
	GgitCloneOptions* _tmp3_;
	GgitCloneOptions* _tmp4_;
	GgitCloneOptions* _tmp5_;
	GgitCloneOptions* _tmp6_;
	GgitFetchOptions* _tmp7_;
	gchar* _tmp8_;
	GFile* _tmp9_;
	GThread* _tmp10_;
	GThread* _tmp11_;
	GgitRepository* _tmp12_;
	GgitRepository* _tmp13_;
	GFile* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GgitRepository* _tmp17_;
};

static gint ScratchServicesGitManager_private_offset;
static gpointer scratch_services_git_manager_parent_class = NULL;
static GeeHashMap* scratch_services_git_manager_project_gitrepo_map;
static GeeHashMap* scratch_services_git_manager_project_gitrepo_map = NULL;
static ScratchServicesGitManager* scratch_services_git_manager_instance;
static ScratchServicesGitManager* scratch_services_git_manager_instance = NULL;

static gint scratch_services_git_manager_project_sort_func (ScratchFolderManagerProjectFolderItem* a,
                                                     ScratchFolderManagerProjectFolderItem* b,
                                                     ScratchServicesGitManager* self);
static void scratch_services_git_manager_clone_repository_data_free (gpointer _data);
static gboolean scratch_services_git_manager_clone_repository_co (ScratchServicesGitManagerCloneRepositoryData* _data_);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static gboolean _scratch_services_git_manager_clone_repository_co_gsource_func (gpointer self);
static void __lambda15_ (Block34Data* _data34_);
static gpointer ___lambda15__gthread_func (gpointer self);
static void _vala_GgitFetchOptions_free (GgitFetchOptions* self);
static void scratch_services_git_manager_set_project_liststore (ScratchServicesGitManager* self,
                                                         GListStore* value);
static GObject * scratch_services_git_manager_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void scratch_services_git_manager_finalize (GObject * obj);
static GType scratch_services_git_manager_get_type_once (void);
static void _vala_scratch_services_git_manager_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_scratch_services_git_manager_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
scratch_services_git_manager_get_instance_private (ScratchServicesGitManager* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchServicesGitManager_private_offset);
}

ScratchServicesMonitoredRepository*
scratch_services_git_manager_get_monitored_repository (const gchar* root_path)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ScratchServicesMonitoredRepository* result;
	g_return_val_if_fail (root_path != NULL, NULL);
	_tmp0_ = scratch_services_git_manager_project_gitrepo_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, root_path);
	result = (ScratchServicesMonitoredRepository*) _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ScratchServicesGitManager*
scratch_services_git_manager_get_instance (void)
{
	ScratchServicesGitManager* _tmp0_;
	ScratchServicesGitManager* _tmp2_;
	ScratchServicesGitManager* _tmp3_;
	ScratchServicesGitManager* result;
	_tmp0_ = scratch_services_git_manager_instance;
	if (_tmp0_ == NULL) {
		ScratchServicesGitManager* _tmp1_;
		_tmp1_ = scratch_services_git_manager_new ();
		_g_object_unref0 (scratch_services_git_manager_instance);
		scratch_services_git_manager_instance = _tmp1_;
	}
	_tmp2_ = scratch_services_git_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

ScratchServicesMonitoredRepository*
scratch_services_git_manager_add_project (ScratchServicesGitManager* self,
                                          ScratchFolderManagerProjectFolderItem* root_folder)
{
	gchar* root_path = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	ScratchServicesMonitoredRepository* monitored_repo = NULL;
	GeeHashMap* _tmp25_;
	const gchar* _tmp26_;
	gpointer _tmp27_;
	GError* _inner_error0_ = NULL;
	ScratchServicesMonitoredRepository* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (root_folder != NULL, NULL);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) root_folder);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_path (_tmp3_);
	root_path = _tmp4_;
	monitored_repo = NULL;
	{
		GgitRepository* git_repo = NULL;
		ScratchFolderManagerFile* _tmp5_;
		ScratchFolderManagerFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GgitRepository* _tmp9_;
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		_tmp5_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) root_folder);
		_tmp6_ = _tmp5_;
		_tmp7_ = scratch_folder_manager_file_get_file (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ggit_repository_open (_tmp8_, &_inner_error0_);
		git_repo = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = scratch_services_git_manager_project_gitrepo_map;
		_tmp11_ = root_path;
		if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, _tmp11_)) {
			GgitRepository* _tmp12_;
			ScratchServicesMonitoredRepository* _tmp13_;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			ScratchServicesMonitoredRepository* _tmp16_;
			GeeHashMap* _tmp17_;
			const gchar* _tmp18_;
			gpointer _tmp19_;
			_tmp12_ = git_repo;
			_tmp13_ = scratch_services_monitored_repository_new (_tmp12_);
			_g_object_unref0 (monitored_repo);
			monitored_repo = _tmp13_;
			_tmp14_ = scratch_services_git_manager_project_gitrepo_map;
			_tmp15_ = root_path;
			_tmp16_ = monitored_repo;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp15_, _tmp16_);
			_tmp17_ = scratch_services_git_manager_project_gitrepo_map;
			_tmp18_ = root_path;
			_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
			result = (ScratchServicesMonitoredRepository*) _tmp19_;
			_g_object_unref0 (git_repo);
			{
				GError* _inner_error0_ = NULL;
				GListStore* _tmp20_;
				_tmp20_ = self->priv->_project_liststore;
				g_list_store_insert_sorted (_tmp20_, (GObject*) root_folder, (GCompareDataFunc) scratch_services_git_manager_project_sort_func, self);
			}
			_g_object_unref0 (monitored_repo);
			_g_free0 (root_path);
			return result;
		}
		_g_object_unref0 (git_repo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = root_path;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_debug ("GitManager.vala:64: Error opening git repo for %s, means this probably" \
" isn't one: %s", _tmp21_, _tmp23_);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		GListStore* _tmp24_;
		_tmp24_ = self->priv->_project_liststore;
		g_list_store_insert_sorted (_tmp24_, (GObject*) root_folder, (GCompareDataFunc) scratch_services_git_manager_project_sort_func, self);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (monitored_repo);
		_g_free0 (root_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp25_ = scratch_services_git_manager_project_gitrepo_map;
	_tmp26_ = root_path;
	_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, _tmp26_);
	result = (ScratchServicesMonitoredRepository*) _tmp27_;
	_g_object_unref0 (monitored_repo);
	_g_free0 (root_path);
	return result;
}

static gint
scratch_services_git_manager_project_sort_func (ScratchFolderManagerProjectFolderItem* a,
                                                ScratchFolderManagerProjectFolderItem* b,
                                                ScratchServicesGitManager* self)
{
	GFile* file_a = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* file_b = NULL;
	ScratchFolderManagerFile* _tmp5_;
	ScratchFolderManagerFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) a);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	file_a = _tmp4_;
	_tmp5_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) b);
	_tmp6_ = _tmp5_;
	_tmp7_ = scratch_folder_manager_file_get_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	file_b = _tmp9_;
	_tmp10_ = g_file_get_path (file_a);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_path_get_basename (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_get_path (file_b);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_path_get_basename (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_utf8_collate (_tmp13_, _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	result = _tmp18_;
	_g_object_unref0 (file_b);
	_g_object_unref0 (file_a);
	return result;
}

void
scratch_services_git_manager_remove_project (ScratchServicesGitManager* self,
                                             ScratchFolderManagerProjectFolderItem* root_folder)
{
	gchar* root_path = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	guint position = 0U;
	GListStore* _tmp5_;
	guint _tmp6_ = 0U;
	gboolean _tmp7_;
	GeeHashMap* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_folder != NULL);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) root_folder);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_path (_tmp3_);
	root_path = _tmp4_;
	_tmp5_ = self->priv->_project_liststore;
	_tmp7_ = g_list_store_find (_tmp5_, (GObject*) root_folder, &_tmp6_);
	position = _tmp6_;
	if (_tmp7_) {
		GListStore* _tmp8_;
		_tmp8_ = self->priv->_project_liststore;
		g_list_store_remove (_tmp8_, position);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = root_path;
		g_critical ("GitManager.vala:94: Can't remove: %s", _tmp9_);
	}
	_tmp10_ = scratch_services_git_manager_project_gitrepo_map;
	_tmp11_ = root_path;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, _tmp11_)) {
		GeeHashMap* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = scratch_services_git_manager_project_gitrepo_map;
		_tmp13_ = root_path;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp12_, _tmp13_, NULL);
	}
	_g_free0 (root_path);
}

gchar*
scratch_services_git_manager_get_default_build_dir (ScratchServicesGitManager* self,
                                                    const gchar* project_path)
{
	const gchar* _tmp0_ = NULL;
	gchar* build_path = NULL;
	gchar* _tmp2_;
	gchar* default_build_dir = NULL;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	GFile* build_file = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (project_path != NULL) {
		_tmp0_ = project_path;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_active_project_path;
		_tmp0_ = _tmp1_;
	}
	_tmp2_ = g_strdup (_tmp0_);
	build_path = _tmp2_;
	_tmp3_ = scratch_settings;
	_tmp4_ = g_settings_get_string (_tmp3_, "default-build-directory");
	default_build_dir = _tmp4_;
	_tmp5_ = build_path;
	_tmp6_ = default_build_dir;
	_tmp7_ = g_build_filename (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_file_new_for_path (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	build_file = _tmp10_;
	_tmp11_ = build_file;
	if (g_file_query_exists (_tmp11_, NULL)) {
		GFile* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = build_file;
		_tmp13_ = g_file_get_path (_tmp12_);
		_g_free0 (build_path);
		build_path = _tmp13_;
	} else {
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = build_file;
		_tmp15_ = g_file_get_path (_tmp14_);
		_tmp16_ = _tmp15_;
		g_warning ("GitManager.vala:110: build path not found %s", _tmp16_);
		_g_free0 (_tmp16_);
	}
	result = build_path;
	_g_object_unref0 (build_file);
	_g_free0 (default_build_dir);
	return result;
}

static void
scratch_services_git_manager_clone_repository_data_free (gpointer _data)
{
	ScratchServicesGitManagerCloneRepositoryData* _data_;
	_data_ = _data;
	_g_free0 (_data_->local_folder);
	_g_object_unref0 (_data_->self);
	g_slice_free (ScratchServicesGitManagerCloneRepositoryData, _data_);
}

void
scratch_services_git_manager_clone_repository (ScratchServicesGitManager* self,
                                               const gchar* uri,
                                               const gchar* local_folder,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	ScratchServicesGitManagerCloneRepositoryData* _data_;
	ScratchServicesGitManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (local_folder != NULL);
	_data_ = g_slice_new0 (ScratchServicesGitManagerCloneRepositoryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_git_manager_clone_repository_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = g_strdup (local_folder);
	_g_free0 (_data_->local_folder);
	_data_->local_folder = _tmp2_;
	scratch_services_git_manager_clone_repository_co (_data_);
}

gboolean
scratch_services_git_manager_clone_repository_finish (ScratchServicesGitManager* self,
                                                      GAsyncResult* _res_,
                                                      GFile** repo_workdir,
                                                      gchar** _error_)
{
	gboolean result;
	ScratchServicesGitManagerCloneRepositoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (repo_workdir) {
		*repo_workdir = _data_->repo_workdir;
	} else {
		_g_object_unref0 (_data_->repo_workdir);
	}
	_data_->repo_workdir = NULL;
	if (_error_) {
		*_error_ = _data_->_error_;
	} else {
		_g_free0 (_data_->_error_);
	}
	_data_->_error_ = NULL;
	result = _data_->result;
	return result;
}

static Block34Data*
block34_data_ref (Block34Data* _data34_)
{
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}

static void
block34_data_unref (void * _userdata_)
{
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		ScratchServicesGitManager* self;
		self = _data34_->self;
		(_data34_->callback_target_destroy_notify == NULL) ? NULL : (_data34_->callback_target_destroy_notify (_data34_->callback_target), NULL);
		_data34_->callback = NULL;
		_data34_->callback_target = NULL;
		_data34_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (_data34_->new_repo);
		_g_object_unref0 (_data34_->folder_file);
		_g_free0 (_data34_->e_message);
		_g_object_unref0 (_data34_->clone_options);
		_g_free0 (_data34_->uri);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}

static gboolean
_scratch_services_git_manager_clone_repository_co_gsource_func (gpointer self)
{
	gboolean result;
	result = scratch_services_git_manager_clone_repository_co (self);
	return result;
}

static void
__lambda15_ (Block34Data* _data34_)
{
	ScratchServicesGitManager* self;
	GSourceFunc _tmp8_;
	gpointer _tmp8__target;
	GDestroyNotify _tmp8__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	self = _data34_->self;
	{
		GgitRepository* _tmp0_ = NULL;
		GFile* _tmp1_;
		GgitCloneOptions* _tmp2_;
		GgitRepository* _tmp3_;
		GgitRepository* _tmp4_;
		_tmp1_ = _data34_->folder_file;
		_tmp2_ = _data34_->clone_options;
		_tmp3_ = ggit_repository_clone (_data34_->uri, _tmp1_, _tmp2_, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_data34_->new_repo);
		_data34_->new_repo = _tmp4_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (_data34_->e_message);
		_data34_->e_message = _tmp7_;
		_g_object_unref0 (_data34_->new_repo);
		_data34_->new_repo = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = _data34_->callback;
	_tmp8__target = _data34_->callback_target;
	_tmp8__target_destroy_notify = _data34_->callback_target_destroy_notify;
	_data34_->callback = NULL;
	_data34_->callback_target = NULL;
	_data34_->callback_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp8_, _tmp8__target, _tmp8__target_destroy_notify);
}

static gpointer
___lambda15__gthread_func (gpointer self)
{
	gpointer result;
	__lambda15_ (self);
	result = NULL;
	block34_data_unref (self);
	return result;
}

static void
_vala_GgitFetchOptions_free (GgitFetchOptions* self)
{
	g_boxed_free (ggit_fetch_options_get_type (), self);
}

static gboolean
scratch_services_git_manager_clone_repository_co (ScratchServicesGitManagerCloneRepositoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data34_ = g_slice_new0 (Block34Data);
	_data_->_data34_->_ref_count_ = 1;
	_data_->_data34_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data34_->uri);
	_data_->_data34_->uri = _data_->uri;
	_data_->_data34_->_async_data_ = _data_;
	_g_object_unref0 (_data_->repo_workdir);
	_data_->repo_workdir = NULL;
	_g_free0 (_data_->_error_);
	_data_->_error_ = NULL;
	_data_->_tmp0_ = ggit_fetch_options_new ();
	_data_->fetch_options = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->fetch_options;
	ggit_fetch_options_set_download_tags (_data_->_tmp1_, GGIT_REMOTE_DOWNLOAD_TAGS_UNSPECIFIED);
	_data_->_tmp2_ = _data_->fetch_options;
	ggit_fetch_options_set_remote_callbacks (_data_->_tmp2_, NULL);
	_data_->_tmp3_ = ggit_clone_options_new ();
	_data_->_data34_->clone_options = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->_data34_->clone_options;
	ggit_clone_options_set_local (_data_->_tmp4_, GGIT_CLONE_LOCAL_AUTO);
	_data_->_tmp5_ = _data_->_data34_->clone_options;
	ggit_clone_options_set_is_bare (_data_->_tmp5_, FALSE);
	_data_->_tmp6_ = _data_->_data34_->clone_options;
	_data_->_tmp7_ = _data_->fetch_options;
	ggit_clone_options_set_fetch_options (_data_->_tmp6_, _data_->_tmp7_);
	_data_->_tmp8_ = g_strdup ("");
	_data_->_data34_->e_message = _data_->_tmp8_;
	_data_->_tmp9_ = g_file_new_for_path (_data_->local_folder);
	_data_->_data34_->folder_file = _data_->_tmp9_;
	_data_->_data34_->new_repo = NULL;
	_data_->_data34_->callback = _scratch_services_git_manager_clone_repository_co_gsource_func;
	_data_->_data34_->callback_target = _data_;
	_data_->_data34_->callback_target_destroy_notify = NULL;
	_data_->_tmp10_ = g_thread_new ("cloning", ___lambda15__gthread_func, block34_data_ref (_data_->_data34_));
	_data_->_tmp11_ = _data_->_tmp10_;
	_g_thread_unref0 (_data_->_tmp11_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp12_ = _data_->_data34_->new_repo;
	if (_data_->_tmp12_ != NULL) {
		_data_->_tmp13_ = _data_->_data34_->new_repo;
		_data_->_tmp14_ = ggit_repository_get_workdir (_data_->_tmp13_);
		_g_object_unref0 (_data_->repo_workdir);
		_data_->repo_workdir = _data_->_tmp14_;
	} else {
		_data_->_tmp15_ = _data_->_data34_->e_message;
		_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
		_g_free0 (_data_->_error_);
		_data_->_error_ = _data_->_tmp16_;
	}
	_data_->_tmp17_ = _data_->_data34_->new_repo;
	_data_->result = _data_->_tmp17_ != NULL;
	__vala_GgitFetchOptions_free0 (_data_->fetch_options);
	block34_data_unref (_data_->_data34_);
	_data_->_data34_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ScratchServicesGitManager*
scratch_services_git_manager_construct (GType object_type)
{
	ScratchServicesGitManager * self = NULL;
	self = (ScratchServicesGitManager*) g_object_new (object_type, NULL);
	return self;
}

ScratchServicesGitManager*
scratch_services_git_manager_new (void)
{
	return scratch_services_git_manager_construct (SCRATCH_SERVICES_TYPE_GIT_MANAGER);
}

GListStore*
scratch_services_git_manager_get_project_liststore (ScratchServicesGitManager* self)
{
	GListStore* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_liststore;
	result = _tmp0_;
	return result;
}

static void
scratch_services_git_manager_set_project_liststore (ScratchServicesGitManager* self,
                                                    GListStore* value)
{
	GListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_git_manager_get_project_liststore (self);
	if (old_value != value) {
		GListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_project_liststore);
		self->priv->_project_liststore = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY]);
	}
}

const gchar*
scratch_services_git_manager_get_active_project_path (ScratchServicesGitManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_project_path;
	result = _tmp0_;
	return result;
}

void
scratch_services_git_manager_set_active_project_path (ScratchServicesGitManager* self,
                                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_git_manager_get_active_project_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_active_project_path);
		self->priv->_active_project_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY]);
	}
}

static GObject *
scratch_services_git_manager_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchServicesGitManager * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	GSettings* _tmp2_;
	parent_class = G_OBJECT_CLASS (scratch_services_git_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManager);
	_tmp0_ = g_list_store_new (SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM);
	_tmp1_ = _tmp0_;
	scratch_services_git_manager_set_project_liststore (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = scratch_settings;
	g_settings_bind (_tmp2_, "active-project-path", (GObject*) self, "active-project-path", G_SETTINGS_BIND_DEFAULT);
	return obj;
}

static void
scratch_services_git_manager_class_init (ScratchServicesGitManagerClass * klass,
                                         gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	scratch_services_git_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchServicesGitManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_services_git_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_services_git_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_services_git_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_services_git_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY, scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY] = g_param_spec_object ("project-liststore", "project-liststore", "project-liststore", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY, scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY] = g_param_spec_string ("active-project-path", "active-project-path", "active-project-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ggit_init ();
	_g_object_unref0 (scratch_services_git_manager_instance);
	scratch_services_git_manager_instance = NULL;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (scratch_services_git_manager_project_gitrepo_map);
	scratch_services_git_manager_project_gitrepo_map = _tmp0_;
}

static void
scratch_services_git_manager_instance_init (ScratchServicesGitManager * self,
                                            gpointer klass)
{
	gchar* _tmp0_;
	self->priv = scratch_services_git_manager_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_active_project_path = _tmp0_;
}

static void
scratch_services_git_manager_finalize (GObject * obj)
{
	ScratchServicesGitManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManager);
	_g_object_unref0 (self->priv->_project_liststore);
	_g_free0 (self->priv->_active_project_path);
	G_OBJECT_CLASS (scratch_services_git_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_services_git_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesGitManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_git_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchServicesGitManager), 0, (GInstanceInitFunc) scratch_services_git_manager_instance_init, NULL };
	GType scratch_services_git_manager_type_id;
	scratch_services_git_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchServicesGitManager", &g_define_type_info, 0);
	ScratchServicesGitManager_private_offset = g_type_add_instance_private (scratch_services_git_manager_type_id, sizeof (ScratchServicesGitManagerPrivate));
	return scratch_services_git_manager_type_id;
}

GType
scratch_services_git_manager_get_type (void)
{
	static gsize scratch_services_git_manager_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_git_manager_type_id__once)) {
		GType scratch_services_git_manager_type_id;
		scratch_services_git_manager_type_id = scratch_services_git_manager_get_type_once ();
		g_once_init_leave (&scratch_services_git_manager_type_id__once, scratch_services_git_manager_type_id);
	}
	return scratch_services_git_manager_type_id__once;
}

static void
_vala_scratch_services_git_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchServicesGitManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManager);
	switch (property_id) {
		case SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY:
		g_value_set_object (value, scratch_services_git_manager_get_project_liststore (self));
		break;
		case SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY:
		g_value_set_string (value, scratch_services_git_manager_get_active_project_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_services_git_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchServicesGitManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManager);
	switch (property_id) {
		case SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY:
		scratch_services_git_manager_set_project_liststore (self, g_value_get_object (value));
		break;
		case SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY:
		scratch_services_git_manager_set_active_project_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

