/* CommonJob.c generated by valac 0.56.18, the Vala compiler
 * generated from CommonJob.vala, do not modify */

/* Copyright 2020 elementary LLC (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "pantheon-files-core.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdarg.h>
#include <granite.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _files_undo_action_data_unref0(var) ((var == NULL) ? NULL : (var = (files_undo_action_data_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _marlin_file_operations_common_job_source_info_free0(var) ((var == NULL) ? NULL : (var = (marlin_file_operations_common_job_source_info_free (var), NULL)))
typedef struct _Block35Data Block35Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _marlin_file_operations_common_job_unref0(var) ((var == NULL) ? NULL : (var = (marlin_file_operations_common_job_unref (var), NULL)))
typedef struct _Block36Data Block36Data;
typedef struct _Block37Data Block37Data;
typedef struct _Block38Data Block38Data;
typedef struct _FilesFileOperationsParamSpecCommonJob FilesFileOperationsParamSpecCommonJob;

struct _FilesFileOperationsCommonJobPrivate {
	GHashTable* skip_readdir_error_set;
};

struct _Block35Data {
	int _ref_count_;
	FilesFileOperationsCommonJob* self;
	gint _result_;
	const gchar* image_name;
	GMainLoop* main_loop;
	GList* buttons;
	gchar* primary_text;
	gchar* secondary_text;
	gchar* details_text;
};

struct _Block36Data {
	int _ref_count_;
	Block35Data * _data35_;
	GraniteMessageDialog* dialog;
};

struct _Block37Data {
	int _ref_count_;
	FilesFileOperationsCommonJob* self;
	gint _result_;
	gchar* _new_name;
	gboolean _apply_to_all;
	GMainLoop* main_loop;
	GFile* src;
	GFile* dest;
	GFile* dest_dir;
};

struct _Block38Data {
	int _ref_count_;
	Block37Data * _data37_;
	FilesFileConflictDialog* dialog;
};

struct _FilesFileOperationsParamSpecCommonJob {
	GParamSpec parent_instance;
};

static gint FilesFileOperationsCommonJob_private_offset;
static gpointer marlin_file_operations_common_job_parent_class = NULL;

static void marlin_file_operations_common_job_uninhibit_power_manager (FilesFileOperationsCommonJob* self);
static const gchar* marlin_file_operations_common_job_real_get_scan_primary (FilesFileOperationsCommonJob* self);
static void marlin_file_operations_common_job_real_report_count_progress (FilesFileOperationsCommonJob* self,
                                                                   SourceInfo* source_info);
static guint _g_file_hash_ghash_func (gconstpointer key);
static gboolean _g_file_equal_gequal_func (gconstpointer a,
                                    gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static void marlin_file_operations_common_job_count_file (FilesFileOperationsCommonJob* self,
                                                   GFileInfo* info,
                                                   SourceInfo* source_info);
static void marlin_file_operations_common_job_scan_dir (FilesFileOperationsCommonJob* self,
                                                 GFile* dir,
                                                 SourceInfo* source_info,
                                                 GQueue* dirs);
static void marlin_file_operations_common_job_scan_file (FilesFileOperationsCommonJob* self,
                                                  GFile* file,
                                                  SourceInfo* source_info,
                                                  GQueue* dirs);
static inline void _g_queue_free__g_object_unref0_ (GQueue* self);
static gint marlin_file_operations_common_job_run_simple_dialog_va (FilesFileOperationsCommonJob* self,
                                                             GtkMessageType message_type,
                                                             gchar* primary_text,
                                                             gchar* secondary_text,
                                                             const gchar* details_text,
                                                             gboolean show_all,
                                                             va_list varargs);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void block35_data_unref (void * _userdata_);
static gboolean __lambda61_ (Block35Data* _data35_);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static void __lambda62_ (Block36Data* _data36_,
                  gint response_id);
static void ___lambda62__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static gboolean ___lambda61__gsource_func (gpointer self);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static gboolean __lambda63_ (Block37Data* _data37_);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void __lambda64_ (Block38Data* _data38_,
                  gint response_id);
static void ___lambda64__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static gboolean ___lambda63__gsource_func (gpointer self);
static void marlin_file_operations_common_job_source_info_instance_init (SourceInfo * self);
static void marlin_file_operations_common_job_transfer_info_instance_init (TransferInfo * self);
static void marlin_file_operations_common_job_finalize (FilesFileOperationsCommonJob * obj);
static GType marlin_file_operations_common_job_get_type_once (void);

static inline gpointer
marlin_file_operations_common_job_get_instance_private (FilesFileOperationsCommonJob* self)
{
	return G_STRUCT_MEMBER_P (self, FilesFileOperationsCommonJob_private_offset);
}

FilesFileOperationsCommonJob*
marlin_file_operations_common_job_construct (GType object_type,
                                             GtkWindow* parent_window)
{
	FilesFileOperationsCommonJob* self = NULL;
	PFProgressInfo* _tmp0_;
	PFProgressInfo* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GTimer* _tmp4_;
	self = (FilesFileOperationsCommonJob*) g_type_create_instance (object_type);
	self->parent_window = parent_window;
	self->inhibit_cookie = (guint) 0;
	_tmp0_ = pf_progress_info_new ();
	_g_object_unref0 (self->progress);
	self->progress = _tmp0_;
	_tmp1_ = self->progress;
	_tmp2_ = pf_progress_info_get_cancellable (_tmp1_);
	_tmp3_ = _tmp2_;
	self->cancellable = _tmp3_;
	_files_undo_action_data_unref0 (self->undo_redo_data);
	self->undo_redo_data = NULL;
	_tmp4_ = g_timer_new ();
	_g_timer_destroy0 (self->time);
	self->time = _tmp4_;
	return self;
}

FilesFileOperationsCommonJob*
marlin_file_operations_common_job_new (GtkWindow* parent_window)
{
	return marlin_file_operations_common_job_construct (MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, parent_window);
}

static const gchar*
marlin_file_operations_common_job_real_get_scan_primary (FilesFileOperationsCommonJob* self)
{
	const gchar* result;
	g_warn_if_reached ();
	result = _ ("Error while copying.");
	return result;
}

const gchar*
marlin_file_operations_common_job_get_scan_primary (FilesFileOperationsCommonJob* self)
{
	FilesFileOperationsCommonJobClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MARLIN_FILE_OPERATIONS_COMMON_JOB_GET_CLASS (self);
	if (_klass_->get_scan_primary) {
		return _klass_->get_scan_primary (self);
	}
	return NULL;
}

static void
marlin_file_operations_common_job_real_report_count_progress (FilesFileOperationsCommonJob* self,
                                                              SourceInfo* source_info)
{
	g_return_if_fail (source_info != NULL);
	g_warn_if_reached ();
}

void
marlin_file_operations_common_job_report_count_progress (FilesFileOperationsCommonJob* self,
                                                         SourceInfo* source_info)
{
	FilesFileOperationsCommonJobClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = MARLIN_FILE_OPERATIONS_COMMON_JOB_GET_CLASS (self);
	if (_klass_->report_count_progress) {
		_klass_->report_count_progress (self, source_info);
	}
}

void
marlin_file_operations_common_job_inhibit_power_manager (FilesFileOperationsCommonJob* self,
                                                         const gchar* message)
{
	GtkApplication* app = NULL;
	GApplication* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = g_application_get_default ();
	app = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication);
	_tmp1_ = self->parent_window;
	self->inhibit_cookie = gtk_application_inhibit (app, _tmp1_, GTK_APPLICATION_INHIBIT_LOGOUT | GTK_APPLICATION_INHIBIT_SUSPEND, message);
}

static void
marlin_file_operations_common_job_uninhibit_power_manager (FilesFileOperationsCommonJob* self)
{
	GApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->inhibit_cookie == ((guint) 0)) {
		return;
	}
	_tmp0_ = g_application_get_default ();
	gtk_application_uninhibit (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication), self->inhibit_cookie);
	self->inhibit_cookie = (guint) 0;
}

gboolean
marlin_file_operations_common_job_aborted (FilesFileOperationsCommonJob* self)
{
	GCancellable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->cancellable;
	result = g_cancellable_is_cancelled (_tmp0_);
	return result;
}

void
marlin_file_operations_common_job_abort_job (FilesFileOperationsCommonJob* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->cancellable;
	g_cancellable_cancel (_tmp0_);
}

static guint
_g_file_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = g_file_hash (key);
	return result;
}

static gboolean
_g_file_equal_gequal_func (gconstpointer a,
                           gconstpointer b)
{
	gboolean result;
	result = g_file_equal (a, (GFile*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
marlin_file_operations_common_job_skip_file (FilesFileOperationsCommonJob* self,
                                             GFile* file)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp2_;
	GFile* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->skip_files;
	if (_tmp0_ == NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, NULL, _g_object_unref0_);
		_g_hash_table_unref0 (self->skip_files);
		self->skip_files = _tmp1_;
	}
	_tmp2_ = self->skip_files;
	_tmp3_ = _g_object_ref0 (file);
	g_hash_table_add (_tmp2_, _tmp3_);
}

void
marlin_file_operations_common_job_skip_readdir_error (FilesFileOperationsCommonJob* self,
                                                      GFile* dir)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp2_;
	GFile* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = self->priv->skip_readdir_error_set;
	if (_tmp0_ == NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, NULL, _g_object_unref0_);
		_g_hash_table_unref0 (self->priv->skip_readdir_error_set);
		self->priv->skip_readdir_error_set = _tmp1_;
	}
	_tmp2_ = self->priv->skip_readdir_error_set;
	_tmp3_ = _g_object_ref0 (dir);
	g_hash_table_add (_tmp2_, _tmp3_);
}

gboolean
marlin_file_operations_common_job_should_skip_file (FilesFileOperationsCommonJob* self,
                                                    GFile* file)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->skip_files;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = self->skip_files;
		result = g_hash_table_contains (_tmp1_, file);
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
marlin_file_operations_common_job_should_skip_readdir_error (FilesFileOperationsCommonJob* self,
                                                             GFile* dir)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	_tmp0_ = self->priv->skip_readdir_error_set;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = self->priv->skip_readdir_error_set;
		result = g_hash_table_contains (_tmp1_, dir);
		return result;
	}
	result = FALSE;
	return result;
}

void
marlin_file_operations_common_job_verify_destination (FilesFileOperationsCommonJob* self,
                                                      GFile* dest,
                                                      gchar** dest_fs_id,
                                                      gint64 required_size)
{
	gchar* _vala_dest_fs_id = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest != NULL);
	_g_free0 (_vala_dest_fs_id);
	_vala_dest_fs_id = NULL;
	{
		GFileInfo* info = NULL;
		GCancellable* _tmp0_;
		GFileInfo* _tmp1_;
		GFileType file_type = 0;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = self->cancellable;
		_tmp1_ = g_file_query_info (dest, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ID_FILESYSTEM, G_FILE_QUERY_INFO_NONE, _tmp0_, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = info;
		file_type = g_file_info_get_file_type (_tmp2_);
		_tmp3_ = info;
		_tmp4_ = g_file_info_get_attribute_string (_tmp3_, G_FILE_ATTRIBUTE_ID_FILESYSTEM);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_dest_fs_id);
		_vala_dest_fs_id = _tmp5_;
		if (file_type != G_FILE_TYPE_DIRECTORY) {
			gchar* dest_name = NULL;
			gchar* _tmp6_;
			gchar* primary = NULL;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* secondary = NULL;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp6_ = g_file_get_parse_name (dest);
			dest_name = _tmp6_;
			_tmp7_ = dest_name;
			_tmp8_ = g_strdup_printf (_ ("Error while copying to \"%s\"."), _tmp7_);
			primary = _tmp8_;
			secondary = _ ("The destination is not a folder.");
			_tmp9_ = primary;
			_tmp10_ = g_strdup (_tmp9_);
			_tmp11_ = secondary;
			_tmp12_ = g_strdup (_tmp11_);
			marlin_file_operations_common_job_run_error (self, _tmp10_, _tmp12_, NULL, FALSE, CANCEL, NULL, NULL);
			marlin_file_operations_common_job_abort_job (self);
			_g_free0 (primary);
			_g_free0 (dest_name);
			_g_object_unref0 (info);
			if (dest_fs_id) {
				*dest_fs_id = _vala_dest_fs_id;
			} else {
				_g_free0 (_vala_dest_fs_id);
			}
			return;
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		gchar* dest_basename = NULL;
		gchar* _tmp14_;
		gchar* primary = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* secondary = NULL;
		const gchar* details = NULL;
		GError* _tmp17_;
		gint response = 0;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		if (g_error_matches (_tmp13_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_g_error_free0 (e);
			if (dest_fs_id) {
				*dest_fs_id = _vala_dest_fs_id;
			} else {
				_g_free0 (_vala_dest_fs_id);
			}
			return;
		}
		_tmp14_ = files_file_utils_custom_basename_from_file (dest);
		dest_basename = _tmp14_;
		_tmp15_ = dest_basename;
		_tmp16_ = g_strdup_printf (_ ("Error while copying to \"%s\"."), _tmp15_);
		primary = _tmp16_;
		details = NULL;
		_tmp17_ = e;
		if (g_error_matches (_tmp17_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
			secondary = _ ("You do not have permissions to access the destination folder.");
		} else {
			GError* _tmp18_;
			const gchar* _tmp19_;
			secondary = _ ("There was an error getting information about the destination.");
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			details = _tmp19_;
		}
		_tmp20_ = primary;
		_tmp21_ = g_strdup (_tmp20_);
		_tmp22_ = secondary;
		_tmp23_ = g_strdup (_tmp22_);
		_tmp24_ = details;
		response = marlin_file_operations_common_job_run_error (self, _tmp21_, _tmp23_, _tmp24_, FALSE, CANCEL, RETRY, NULL, NULL);
		if (response == 0) {
			_tmp25_ = TRUE;
		} else {
			_tmp25_ = response == ((gint) GTK_RESPONSE_DELETE_EVENT);
		}
		if (_tmp25_) {
			marlin_file_operations_common_job_abort_job (self);
		} else {
			if (response == 1) {
				gchar* _tmp26_ = NULL;
				marlin_file_operations_common_job_verify_destination (self, dest, &_tmp26_, required_size);
				_g_free0 (_vala_dest_fs_id);
				_vala_dest_fs_id = _tmp26_;
				_g_free0 (primary);
				_g_free0 (dest_basename);
				_g_error_free0 (e);
				if (dest_fs_id) {
					*dest_fs_id = _vala_dest_fs_id;
				} else {
					_g_free0 (_vala_dest_fs_id);
				}
				return;
			} else {
				g_assert_not_reached ();
			}
		}
		_g_free0 (primary);
		_g_free0 (dest_basename);
		_g_error_free0 (e);
		if (dest_fs_id) {
			*dest_fs_id = _vala_dest_fs_id;
		} else {
			_g_free0 (_vala_dest_fs_id);
		}
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_vala_dest_fs_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GFileInfo* fsinfo = NULL;
		GCancellable* _tmp27_;
		GFileInfo* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp47_ = FALSE;
		_tmp27_ = self->cancellable;
		_tmp28_ = g_file_query_filesystem_info (dest, G_FILE_ATTRIBUTE_FILESYSTEM_FREE "," G_FILE_ATTRIBUTE_FILESYSTEM_READONLY, _tmp27_, &_inner_error0_);
		fsinfo = _tmp28_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		if (required_size > ((gint64) 0)) {
			GFileInfo* _tmp30_;
			_tmp30_ = fsinfo;
			_tmp29_ = g_file_info_has_attribute (_tmp30_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			guint64 free_size = 0ULL;
			GFileInfo* _tmp31_;
			_tmp31_ = fsinfo;
			free_size = g_file_info_get_attribute_uint64 (_tmp31_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
			if (free_size < ((guint64) required_size)) {
				gchar* dest_name = NULL;
				gchar* _tmp32_;
				gchar* primary = NULL;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* secondary = NULL;
				gchar* free_size_format = NULL;
				gchar* _tmp35_;
				gchar* required_size_format = NULL;
				gchar* _tmp36_;
				gchar* details = NULL;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gint response = 0;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				const gchar* _tmp44_;
				gboolean _tmp45_ = FALSE;
				_tmp32_ = g_file_get_parse_name (dest);
				dest_name = _tmp32_;
				_tmp33_ = dest_name;
				_tmp34_ = g_strdup_printf (_ ("Error while copying to \"%s\"."), _tmp33_);
				primary = _tmp34_;
				secondary = _ ("There is not enough space on the destination. Try to remove files to m" \
"ake space.");
				_tmp35_ = g_format_size_full (free_size, G_FORMAT_SIZE_DEFAULT);
				free_size_format = _tmp35_;
				_tmp36_ = g_format_size_full ((guint64) required_size, G_FORMAT_SIZE_DEFAULT);
				required_size_format = _tmp36_;
				_tmp37_ = free_size_format;
				_tmp38_ = required_size_format;
				_tmp39_ = g_strdup_printf (_ ("There is %s available, but %s is required."), _tmp37_, _tmp38_);
				details = _tmp39_;
				_tmp40_ = primary;
				_tmp41_ = g_strdup (_tmp40_);
				_tmp42_ = secondary;
				_tmp43_ = g_strdup (_tmp42_);
				_tmp44_ = details;
				response = marlin_file_operations_common_job_run_warning (self, _tmp41_, _tmp43_, _tmp44_, FALSE, CANCEL, COPY_FORCE, RETRY, NULL, NULL);
				if (response == 0) {
					_tmp45_ = TRUE;
				} else {
					_tmp45_ = response == ((gint) GTK_RESPONSE_DELETE_EVENT);
				}
				if (_tmp45_) {
					marlin_file_operations_common_job_abort_job (self);
				} else {
					if (response == 2) {
						gchar* _tmp46_ = NULL;
						marlin_file_operations_common_job_verify_destination (self, dest, &_tmp46_, required_size);
						_g_free0 (_vala_dest_fs_id);
						_vala_dest_fs_id = _tmp46_;
					} else {
						if (response == 1) {
						} else {
							g_assert_not_reached ();
						}
					}
				}
				_g_free0 (details);
				_g_free0 (required_size_format);
				_g_free0 (free_size_format);
				_g_free0 (primary);
				_g_free0 (dest_name);
			}
		}
		if (!marlin_file_operations_common_job_aborted (self)) {
			GFileInfo* _tmp48_;
			_tmp48_ = fsinfo;
			_tmp47_ = g_file_info_get_attribute_boolean (_tmp48_, G_FILE_ATTRIBUTE_FILESYSTEM_READONLY);
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			gchar* dest_name = NULL;
			gchar* _tmp49_;
			gchar* primary = NULL;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			const gchar* secondary = NULL;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp49_ = g_file_get_parse_name (dest);
			dest_name = _tmp49_;
			_tmp50_ = dest_name;
			_tmp51_ = g_strdup_printf (_ ("Error while copying to \"%s\"."), _tmp50_);
			primary = _tmp51_;
			secondary = _ ("The destination is read-only.");
			_tmp52_ = primary;
			_tmp53_ = g_strdup (_tmp52_);
			_tmp54_ = secondary;
			_tmp55_ = g_strdup (_tmp54_);
			marlin_file_operations_common_job_run_error (self, _tmp53_, _tmp55_, NULL, FALSE, CANCEL, NULL, NULL);
			marlin_file_operations_common_job_abort_job (self);
			_g_free0 (primary);
			_g_free0 (dest_name);
		}
		_g_object_unref0 (fsinfo);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
		if (dest_fs_id) {
			*dest_fs_id = _vala_dest_fs_id;
		} else {
			_g_free0 (_vala_dest_fs_id);
		}
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_vala_dest_fs_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (dest_fs_id) {
		*dest_fs_id = _vala_dest_fs_id;
	} else {
		_g_free0 (_vala_dest_fs_id);
	}
}

static void
marlin_file_operations_common_job_count_file (FilesFileOperationsCommonJob* self,
                                              GFileInfo* info,
                                              SourceInfo* source_info)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (source_info != NULL);
	source_info->num_files = source_info->num_files + 1;
	source_info->num_bytes = source_info->num_bytes + g_file_info_get_size (info);
	_tmp0_ = source_info->num_files_since_progress;
	source_info->num_files_since_progress = _tmp0_ + 1;
	if (_tmp0_ > 100) {
		marlin_file_operations_common_job_report_count_progress (self, source_info);
		source_info->num_files_since_progress = 0;
	}
}

static void
marlin_file_operations_common_job_scan_dir (FilesFileOperationsCommonJob* self,
                                            GFile* dir,
                                            SourceInfo* source_info,
                                            GQueue* dirs)
{
	SourceInfo* saved_source_info = NULL;
	SourceInfo* _tmp0_;
	GFileEnumerator* enumerator = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	g_return_if_fail (source_info != NULL);
	g_return_if_fail (dirs != NULL);
	_tmp0_ = marlin_file_operations_common_job_source_info_copy (source_info);
	saved_source_info = _tmp0_;
	enumerator = NULL;
	{
		GFileEnumerator* _tmp1_ = NULL;
		GCancellable* _tmp2_;
		GFileEnumerator* _tmp3_;
		GFileEnumerator* _tmp4_;
		_tmp2_ = self->cancellable;
		_tmp3_ = g_file_enumerate_children (dir, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		if (g_error_matches (_tmp5_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
		} else {
			gchar* dir_basename = NULL;
			gchar* _tmp6_;
			const gchar* primary = NULL;
			const gchar* _tmp7_;
			gchar* secondary = NULL;
			gchar* details = NULL;
			GError* _tmp8_;
			gint response = 0;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp6_ = files_file_utils_custom_basename_from_file (dir);
			dir_basename = _tmp6_;
			_tmp7_ = marlin_file_operations_common_job_get_scan_primary (self);
			primary = _tmp7_;
			details = NULL;
			_tmp8_ = e;
			if (g_error_matches (_tmp8_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = dir_basename;
				_tmp10_ = g_strdup_printf (_ ("The folder \"%s\" cannot be handled because you do not have permission" \
"s to read it."), _tmp9_);
				_g_free0 (secondary);
				secondary = _tmp10_;
			} else {
				const gchar* _tmp11_;
				gchar* _tmp12_;
				GError* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = dir_basename;
				_tmp12_ = g_strdup_printf (_ ("There was an error reading the folder \"%s\"."), _tmp11_);
				_g_free0 (secondary);
				secondary = _tmp12_;
				_tmp13_ = e;
				_tmp14_ = _tmp13_->message;
				_tmp15_ = g_strdup (_tmp14_);
				_g_free0 (details);
				details = _tmp15_;
			}
			_tmp16_ = primary;
			_tmp17_ = g_strdup (_tmp16_);
			_tmp18_ = secondary;
			_tmp19_ = g_strdup (_tmp18_);
			_tmp20_ = details;
			response = marlin_file_operations_common_job_run_warning (self, _tmp17_, _tmp19_, _tmp20_, FALSE, CANCEL, RETRY, SKIP, NULL);
			if (response == 0) {
				_tmp21_ = TRUE;
			} else {
				_tmp21_ = response == ((gint) GTK_RESPONSE_DELETE_EVENT);
			}
			if (_tmp21_) {
				marlin_file_operations_common_job_abort_job (self);
			} else {
				if (response == 1) {
					SourceInfo* _tmp22_;
					SourceInfo* _tmp23_;
					SourceInfo* _tmp24_;
					_tmp22_ = saved_source_info;
					source_info->num_files = _tmp22_->num_files;
					_tmp23_ = saved_source_info;
					source_info->num_bytes = _tmp23_->num_bytes;
					_tmp24_ = saved_source_info;
					source_info->num_files_since_progress = _tmp24_->num_files_since_progress;
					marlin_file_operations_common_job_scan_dir (self, dir, source_info, dirs);
				} else {
					if (response == 2) {
						marlin_file_operations_common_job_skip_readdir_error (self, dir);
					} else {
						g_assert_not_reached ();
					}
				}
			}
			_g_free0 (details);
			_g_free0 (secondary);
			_g_free0 (dir_basename);
		}
		_g_error_free0 (e);
		_g_object_unref0 (enumerator);
		_marlin_file_operations_common_job_source_info_free0 (saved_source_info);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (enumerator);
		_marlin_file_operations_common_job_source_info_free0 (saved_source_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GFileInfo* info = NULL;
		info = NULL;
		while (TRUE) {
			GFileInfo* _tmp25_ = NULL;
			GFileEnumerator* _tmp26_;
			GCancellable* _tmp27_;
			GFileInfo* _tmp28_;
			GFileInfo* _tmp29_;
			GFileInfo* _tmp30_;
			GFileInfo* _tmp31_;
			_tmp26_ = enumerator;
			_tmp27_ = self->cancellable;
			_tmp28_ = g_file_enumerator_next_file (_tmp26_, _tmp27_, &_inner_error0_);
			_tmp25_ = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			info = _tmp25_;
			_tmp29_ = info;
			if (!(_tmp29_ != NULL)) {
				_g_object_unref0 (_tmp25_);
				break;
			}
			_tmp30_ = info;
			marlin_file_operations_common_job_count_file (self, _tmp30_, source_info);
			_tmp31_ = info;
			if (g_file_info_get_file_type (_tmp31_) == G_FILE_TYPE_DIRECTORY) {
				GFile* subdir = NULL;
				GFileInfo* _tmp32_;
				const gchar* _tmp33_;
				GFile* _tmp34_;
				GFile* _tmp35_;
				GFile* _tmp36_;
				_tmp32_ = info;
				_tmp33_ = g_file_info_get_name (_tmp32_);
				_tmp34_ = g_file_get_child (dir, _tmp33_);
				subdir = _tmp34_;
				_tmp35_ = subdir;
				_tmp36_ = _g_object_ref0 (_tmp35_);
				g_queue_push_head (dirs, _tmp36_);
				_g_object_unref0 (subdir);
			}
			_g_object_unref0 (_tmp25_);
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp37_ = e;
		if (g_error_matches (_tmp37_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
		} else {
			gchar* dir_basename = NULL;
			gchar* _tmp38_;
			const gchar* primary = NULL;
			const gchar* _tmp39_;
			gchar* secondary = NULL;
			gchar* details = NULL;
			GError* _tmp40_;
			gint response = 0;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			const gchar* _tmp52_;
			gboolean _tmp53_ = FALSE;
			_tmp38_ = files_file_utils_custom_basename_from_file (dir);
			dir_basename = _tmp38_;
			_tmp39_ = marlin_file_operations_common_job_get_scan_primary (self);
			primary = _tmp39_;
			details = NULL;
			_tmp40_ = e;
			if (g_error_matches (_tmp40_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
				const gchar* _tmp41_;
				gchar* _tmp42_;
				_tmp41_ = dir_basename;
				_tmp42_ = g_strdup_printf (_ ("Files in the folder \"%s\" cannot be handled because you do not have p" \
"ermissions to see them."), _tmp41_);
				_g_free0 (secondary);
				secondary = _tmp42_;
			} else {
				const gchar* _tmp43_;
				gchar* _tmp44_;
				GError* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				_tmp43_ = dir_basename;
				_tmp44_ = g_strdup_printf (_ ("There was an error getting information about the files in the folder \"" \
"%s\"."), _tmp43_);
				_g_free0 (secondary);
				secondary = _tmp44_;
				_tmp45_ = e;
				_tmp46_ = _tmp45_->message;
				_tmp47_ = g_strdup (_tmp46_);
				_g_free0 (details);
				details = _tmp47_;
			}
			_tmp48_ = primary;
			_tmp49_ = g_strdup (_tmp48_);
			_tmp50_ = secondary;
			_tmp51_ = g_strdup (_tmp50_);
			_tmp52_ = details;
			response = marlin_file_operations_common_job_run_warning (self, _tmp49_, _tmp51_, _tmp52_, FALSE, CANCEL, SKIP_ALL, SKIP, RETRY, NULL);
			if (response == 0) {
				_tmp53_ = TRUE;
			} else {
				_tmp53_ = response == ((gint) GTK_RESPONSE_DELETE_EVENT);
			}
			if (_tmp53_) {
				marlin_file_operations_common_job_abort_job (self);
			} else {
				if (response == 1) {
					SourceInfo* _tmp54_;
					_tmp54_ = saved_source_info;
					source_info = _tmp54_;
					marlin_file_operations_common_job_scan_dir (self, dir, source_info, dirs);
				} else {
					if (response == 2) {
						marlin_file_operations_common_job_skip_readdir_error (self, dir);
					} else {
						g_assert_not_reached ();
					}
				}
			}
			_g_free0 (details);
			_g_free0 (secondary);
			_g_free0 (dir_basename);
		}
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (enumerator);
		_marlin_file_operations_common_job_source_info_free0 (saved_source_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (enumerator);
	_marlin_file_operations_common_job_source_info_free0 (saved_source_info);
}

static void
marlin_file_operations_common_job_scan_file (FilesFileOperationsCommonJob* self,
                                             GFile* file,
                                             SourceInfo* source_info,
                                             GQueue* dirs)
{
	GFile* dir = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (source_info != NULL);
	g_return_if_fail (dirs != NULL);
	{
		GFileInfo* info = NULL;
		GCancellable* _tmp0_;
		GFileInfo* _tmp1_;
		_tmp0_ = self->cancellable;
		_tmp1_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _tmp0_, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		marlin_file_operations_common_job_count_file (self, info, source_info);
		if (g_file_info_get_file_type (info) == G_FILE_TYPE_DIRECTORY) {
			GFile* _tmp2_;
			_tmp2_ = _g_object_ref0 (file);
			g_queue_push_head (dirs, _tmp2_);
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (self->skip_all_error) {
			marlin_file_operations_common_job_skip_file (self, file);
		} else {
			GError* _tmp3_;
			_tmp3_ = e;
			if (g_error_matches (_tmp3_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			} else {
				gchar* file_basename = NULL;
				gchar* _tmp4_;
				const gchar* primary = NULL;
				const gchar* _tmp5_;
				gchar* secondary = NULL;
				gchar* details = NULL;
				GError* _tmp6_;
				gint response = 0;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				gboolean _tmp19_ = FALSE;
				_tmp4_ = files_file_utils_custom_basename_from_file (file);
				file_basename = _tmp4_;
				_tmp5_ = marlin_file_operations_common_job_get_scan_primary (self);
				primary = _tmp5_;
				details = NULL;
				_tmp6_ = e;
				if (g_error_matches (_tmp6_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = file_basename;
					_tmp8_ = g_strdup_printf (_ ("The file \"%s\" cannot be handled because you do not have permissions " \
"to read it."), _tmp7_);
					_g_free0 (secondary);
					secondary = _tmp8_;
				} else {
					const gchar* _tmp9_;
					gchar* _tmp10_;
					GError* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp9_ = file_basename;
					_tmp10_ = g_strdup_printf (_ ("There was an error getting information about \"%s\"."), _tmp9_);
					_g_free0 (secondary);
					secondary = _tmp10_;
					_tmp11_ = e;
					_tmp12_ = _tmp11_->message;
					_tmp13_ = g_strdup (_tmp12_);
					_g_free0 (details);
					details = _tmp13_;
				}
				_tmp14_ = primary;
				_tmp15_ = g_strdup (_tmp14_);
				_tmp16_ = secondary;
				_tmp17_ = g_strdup (_tmp16_);
				_tmp18_ = details;
				response = marlin_file_operations_common_job_run_warning (self, _tmp15_, _tmp17_, _tmp18_, TRUE, CANCEL, SKIP_ALL, SKIP, RETRY, NULL);
				if (response == 0) {
					_tmp19_ = TRUE;
				} else {
					_tmp19_ = response == ((gint) GTK_RESPONSE_DELETE_EVENT);
				}
				if (_tmp19_) {
					marlin_file_operations_common_job_abort_job (self);
				} else {
					gboolean _tmp20_ = FALSE;
					if (response == 1) {
						_tmp20_ = TRUE;
					} else {
						_tmp20_ = response == 2;
					}
					if (_tmp20_) {
						if (response == 1) {
							self->skip_all_error = TRUE;
						}
						marlin_file_operations_common_job_skip_file (self, file);
					} else {
						if (response == 3) {
							marlin_file_operations_common_job_scan_file (self, file, source_info, dirs);
						} else {
							g_assert_not_reached ();
						}
					}
				}
				_g_free0 (details);
				_g_free0 (secondary);
				_g_free0 (file_basename);
			}
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	dir = NULL;
	while (TRUE) {
		gboolean _tmp21_ = FALSE;
		GFile* _tmp24_;
		if (!marlin_file_operations_common_job_aborted (self)) {
			gpointer _tmp22_;
			GFile* _tmp23_;
			_tmp22_ = g_queue_pop_head (dirs);
			_g_object_unref0 (dir);
			dir = (GFile*) _tmp22_;
			_tmp23_ = dir;
			_tmp21_ = _tmp23_ != NULL;
		} else {
			_tmp21_ = FALSE;
		}
		if (!_tmp21_) {
			break;
		}
		_tmp24_ = dir;
		marlin_file_operations_common_job_scan_dir (self, _tmp24_, source_info, dirs);
	}
	_g_object_unref0 (dir);
}

static inline void
_g_queue_free__g_object_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

SourceInfo*
marlin_file_operations_common_job_scan_sources (FilesFileOperationsCommonJob* self,
                                                GList* files)
{
	SourceInfo* source_info = NULL;
	SourceInfo* _tmp0_;
	SourceInfo* _tmp1_;
	SourceInfo* _tmp7_;
	SourceInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = marlin_file_operations_common_job_source_info_new ();
	source_info = _tmp0_;
	_tmp1_ = source_info;
	marlin_file_operations_common_job_report_count_progress (self, _tmp1_);
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = files;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* _tmp2_;
			GFile* file = NULL;
			_tmp2_ = _g_object_ref0 ((GFile*) file_it->data);
			file = _tmp2_;
			{
				GFile* _tmp3_;
				SourceInfo* _tmp4_;
				GQueue* _tmp5_;
				GQueue* _tmp6_;
				if (marlin_file_operations_common_job_aborted (self)) {
					result = source_info;
					_g_object_unref0 (file);
					return result;
				}
				_tmp3_ = file;
				_tmp4_ = source_info;
				_tmp5_ = g_queue_new ();
				_tmp6_ = _tmp5_;
				marlin_file_operations_common_job_scan_file (self, _tmp3_, _tmp4_, _tmp6_);
				(_tmp6_ == NULL) ? NULL : (_tmp6_ = (_g_queue_free__g_object_unref0_ (_tmp6_), NULL));
				_g_object_unref0 (file);
			}
		}
	}
	_tmp7_ = source_info;
	marlin_file_operations_common_job_report_count_progress (self, _tmp7_);
	result = source_info;
	return result;
}

static Block35Data*
block35_data_ref (Block35Data* _data35_)
{
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
block35_data_unref (void * _userdata_)
{
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		FilesFileOperationsCommonJob* self;
		self = _data35_->self;
		(_data35_->buttons == NULL) ? NULL : (_data35_->buttons = (_g_list_free__g_free0_ (_data35_->buttons), NULL));
		_g_main_loop_unref0 (_data35_->main_loop);
		_g_free0 (_data35_->primary_text);
		_g_free0 (_data35_->secondary_text);
		_g_free0 (_data35_->details_text);
		_marlin_file_operations_common_job_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		FilesFileOperationsCommonJob* self;
		self = _data36_->_data35_->self;
		_g_object_unref0 (_data36_->dialog);
		block35_data_unref (_data36_->_data35_);
		_data36_->_data35_ = NULL;
		g_slice_free (Block36Data, _data36_);
	}
}

static void
__lambda62_ (Block36Data* _data36_,
             gint response_id)
{
	Block35Data* _data35_;
	FilesFileOperationsCommonJob* self;
	GMainLoop* _tmp0_;
	GraniteMessageDialog* _tmp1_;
	_data35_ = _data36_->_data35_;
	self = _data35_->self;
	_data35_->_result_ = response_id;
	_tmp0_ = _data35_->main_loop;
	g_main_loop_quit (_tmp0_);
	_tmp1_ = _data36_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
}

static void
___lambda62__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda62_ (self, response_id);
}

static gboolean
__lambda61_ (Block35Data* _data35_)
{
	FilesFileOperationsCommonJob* self;
	Block36Data* _data36_;
	const gchar* _tmp0_;
	GraniteMessageDialog* _tmp1_;
	GraniteMessageDialog* _tmp2_;
	GtkWindow* _tmp3_;
	gint response_id = 0;
	GList* _tmp4_;
	GraniteMessageDialog* _tmp18_;
	GraniteMessageDialog* _tmp19_;
	gboolean result;
	self = _data35_->self;
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->_data35_ = block35_data_ref (_data35_);
	_tmp0_ = _data35_->image_name;
	_tmp1_ = granite_message_dialog_new_with_image_from_icon_name (_data35_->primary_text, _data35_->secondary_text, _tmp0_, GTK_BUTTONS_NONE);
	g_object_ref_sink (_tmp1_);
	_data36_->dialog = _tmp1_;
	_tmp2_ = _data36_->dialog;
	_tmp3_ = self->parent_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp2_, _tmp3_);
	response_id = 0;
	_tmp4_ = _data35_->buttons;
	{
		GList* title_collection = NULL;
		GList* title_it = NULL;
		title_collection = _tmp4_;
		for (title_it = title_collection; title_it != NULL; title_it = title_it->next) {
			const gchar* title = NULL;
			title = (const gchar*) title_it->data;
			{
				GtkWidget* button = NULL;
				GraniteMessageDialog* _tmp5_;
				const gchar* _tmp6_;
				GtkWidget* _tmp7_;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_;
				gint _tmp15_;
				_tmp5_ = _data36_->dialog;
				_tmp6_ = title;
				_tmp7_ = gtk_dialog_add_button ((GtkDialog*) _tmp5_, _tmp6_, response_id);
				button = _tmp7_;
				_tmp10_ = title;
				if (g_strcmp0 (_tmp10_, DELETE) == 0) {
					_tmp9_ = TRUE;
				} else {
					const gchar* _tmp11_;
					_tmp11_ = title;
					_tmp9_ = g_strcmp0 (_tmp11_, DELETE_ALL) == 0;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					const gchar* _tmp12_;
					_tmp12_ = title;
					_tmp8_ = g_strcmp0 (_tmp12_, EMPTY_TRASH) == 0;
				}
				if (_tmp8_) {
					GtkWidget* _tmp13_;
					GtkStyleContext* _tmp14_;
					_tmp13_ = button;
					_tmp14_ = gtk_widget_get_style_context (_tmp13_);
					gtk_style_context_add_class (_tmp14_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
				}
				_tmp15_ = response_id;
				response_id = _tmp15_ + 1;
			}
		}
	}
	if (response_id == 0) {
		GraniteMessageDialog* _tmp16_;
		_tmp16_ = _data36_->dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp16_, _ ("Close"), 0);
	}
	if (_data35_->details_text != NULL) {
		GraniteMessageDialog* _tmp17_;
		_tmp17_ = _data36_->dialog;
		granite_message_dialog_show_error_details (_tmp17_, _data35_->details_text);
	}
	_tmp18_ = _data36_->dialog;
	g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ___lambda62__gtk_dialog_response, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp19_ = _data36_->dialog;
	gtk_widget_show ((GtkWidget*) _tmp19_);
	result = G_SOURCE_REMOVE;
	block36_data_unref (_data36_);
	_data36_ = NULL;
	return result;
}

static gboolean
___lambda61__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda61_ (self);
	return result;
}

static gint
marlin_file_operations_common_job_run_simple_dialog_va (FilesFileOperationsCommonJob* self,
                                                        GtkMessageType message_type,
                                                        gchar* primary_text,
                                                        gchar* secondary_text,
                                                        const gchar* details_text,
                                                        gboolean show_all,
                                                        va_list varargs)
{
	Block35Data* _data35_;
	gchar* _tmp0_;
	GTimer* _tmp1_;
	PFProgressInfo* _tmp2_;
	GMainLoop* _tmp3_;
	GMainLoop* _tmp10_;
	PFProgressInfo* _tmp11_;
	GTimer* _tmp12_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (primary_text != NULL, 0);
	g_return_val_if_fail (secondary_text != NULL, 0);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = marlin_file_operations_common_job_ref (self);
	_g_free0 (_data35_->primary_text);
	_data35_->primary_text = primary_text;
	_g_free0 (_data35_->secondary_text);
	_data35_->secondary_text = secondary_text;
	_tmp0_ = g_strdup (details_text);
	_g_free0 (_data35_->details_text);
	_data35_->details_text = _tmp0_;
	_data35_->_result_ = 0;
	_tmp1_ = self->time;
	g_timer_stop (_tmp1_);
	_tmp2_ = self->progress;
	pf_progress_info_pause (_tmp2_);
	switch (message_type) {
		case GTK_MESSAGE_ERROR:
		{
			_data35_->image_name = "dialog-error";
			break;
		}
		case GTK_MESSAGE_WARNING:
		{
			_data35_->image_name = "dialog-warning";
			break;
		}
		case GTK_MESSAGE_QUESTION:
		{
			_data35_->image_name = "dialog-question";
			break;
		}
		default:
		{
			_data35_->image_name = "dialog-information";
			break;
		}
	}
	_tmp3_ = g_main_loop_new (NULL, FALSE);
	_data35_->main_loop = _tmp3_;
	_data35_->buttons = NULL;
	{
		const gchar* title = NULL;
		const gchar* _tmp4_;
		_tmp4_ = va_arg (varargs, gchar*);
		title = _tmp4_;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				if (!_tmp5_) {
					const gchar* _tmp6_;
					_tmp6_ = va_arg (varargs, gchar*);
					title = _tmp6_;
				}
				_tmp5_ = FALSE;
				_tmp7_ = title;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = title;
				_tmp9_ = g_strdup (_tmp8_);
				_data35_->buttons = g_list_append (_data35_->buttons, _tmp9_);
			}
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda61__gsource_func, block35_data_ref (_data35_), block35_data_unref);
	_tmp10_ = _data35_->main_loop;
	g_main_loop_run (_tmp10_);
	_tmp11_ = self->progress;
	pf_progress_info_resume (_tmp11_);
	_tmp12_ = self->time;
	g_timer_continue (_tmp12_);
	result = _data35_->_result_;
	block35_data_unref (_data35_);
	_data35_ = NULL;
	return result;
}

gint
marlin_file_operations_common_job_run_error (FilesFileOperationsCommonJob* self,
                                             gchar* primary_text,
                                             gchar* secondary_text,
                                             const gchar* details_text,
                                             gboolean show_all,
                                             ...)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	va_list _tmp2_ = {0};
	gint _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (primary_text != NULL, 0);
	g_return_val_if_fail (secondary_text != NULL, 0);
	_tmp0_ = primary_text;
	primary_text = NULL;
	_tmp1_ = secondary_text;
	secondary_text = NULL;
	va_start (_tmp2_, show_all);
	_tmp3_ = marlin_file_operations_common_job_run_simple_dialog_va (self, GTK_MESSAGE_ERROR, _tmp0_, _tmp1_, details_text, show_all, _tmp2_);
	va_end (_tmp2_);
	result = _tmp3_;
	_g_free0 (primary_text);
	_g_free0 (secondary_text);
	return result;
}

gint
marlin_file_operations_common_job_run_warning (FilesFileOperationsCommonJob* self,
                                               gchar* primary_text,
                                               gchar* secondary_text,
                                               const gchar* details_text,
                                               gboolean show_all,
                                               ...)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	va_list _tmp2_ = {0};
	gint _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (primary_text != NULL, 0);
	g_return_val_if_fail (secondary_text != NULL, 0);
	_tmp0_ = primary_text;
	primary_text = NULL;
	_tmp1_ = secondary_text;
	secondary_text = NULL;
	va_start (_tmp2_, show_all);
	_tmp3_ = marlin_file_operations_common_job_run_simple_dialog_va (self, GTK_MESSAGE_WARNING, _tmp0_, _tmp1_, details_text, show_all, _tmp2_);
	va_end (_tmp2_);
	result = _tmp3_;
	_g_free0 (primary_text);
	_g_free0 (secondary_text);
	return result;
}

gint
marlin_file_operations_common_job_run_question (FilesFileOperationsCommonJob* self,
                                                gchar* primary_text,
                                                gchar* secondary_text,
                                                const gchar* details_text,
                                                gboolean show_all,
                                                ...)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	va_list _tmp2_ = {0};
	gint _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (primary_text != NULL, 0);
	g_return_val_if_fail (secondary_text != NULL, 0);
	_tmp0_ = primary_text;
	primary_text = NULL;
	_tmp1_ = secondary_text;
	secondary_text = NULL;
	va_start (_tmp2_, show_all);
	_tmp3_ = marlin_file_operations_common_job_run_simple_dialog_va (self, GTK_MESSAGE_QUESTION, _tmp0_, _tmp1_, details_text, show_all, _tmp2_);
	va_end (_tmp2_);
	result = _tmp3_;
	_g_free0 (primary_text);
	_g_free0 (secondary_text);
	return result;
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		FilesFileOperationsCommonJob* self;
		self = _data37_->self;
		_g_main_loop_unref0 (_data37_->main_loop);
		_g_free0 (_data37_->_new_name);
		_g_object_unref0 (_data37_->src);
		_g_object_unref0 (_data37_->dest);
		_g_object_unref0 (_data37_->dest_dir);
		_marlin_file_operations_common_job_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		FilesFileOperationsCommonJob* self;
		self = _data38_->_data37_->self;
		_g_object_unref0 (_data38_->dialog);
		block37_data_unref (_data38_->_data37_);
		_data38_->_data37_ = NULL;
		g_slice_free (Block38Data, _data38_);
	}
}

static void
__lambda64_ (Block38Data* _data38_,
             gint response_id)
{
	Block37Data* _data37_;
	FilesFileOperationsCommonJob* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	_data37_ = _data38_->_data37_;
	self = _data37_->self;
	_data37_->_result_ = response_id;
	_tmp0_ = files_file_conflict_dialog_get_apply_to_all (_data38_->dialog);
	_tmp1_ = _tmp0_;
	_data37_->_apply_to_all = _tmp1_;
	if (response_id == ((gint) FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_RENAME)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = files_file_conflict_dialog_get_new_name (_data38_->dialog);
		_tmp3_ = _tmp2_;
		_g_free0 (_data37_->_new_name);
		_data37_->_new_name = _tmp3_;
	}
	g_main_loop_quit (_data37_->main_loop);
	gtk_widget_destroy ((GtkWidget*) _data38_->dialog);
}

static void
___lambda64__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda64_ (self, response_id);
}

static gboolean
__lambda63_ (Block37Data* _data37_)
{
	FilesFileOperationsCommonJob* self;
	Block38Data* _data38_;
	GtkWindow* _tmp0_;
	FilesFileConflictDialog* _tmp1_;
	gboolean result;
	self = _data37_->self;
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->_data37_ = block37_data_ref (_data37_);
	_tmp0_ = self->parent_window;
	_tmp1_ = files_file_conflict_dialog_new (_tmp0_, _data37_->src, _data37_->dest, _data37_->dest_dir);
	g_object_ref_sink (_tmp1_);
	_data38_->dialog = _tmp1_;
	g_signal_connect_data ((GtkDialog*) _data38_->dialog, "response", (GCallback) ___lambda64__gtk_dialog_response, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data38_->dialog);
	result = G_SOURCE_REMOVE;
	block38_data_unref (_data38_);
	_data38_ = NULL;
	return result;
}

static gboolean
___lambda63__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda63_ (self);
	return result;
}

gint
marlin_file_operations_common_job_run_conflict_dialog (FilesFileOperationsCommonJob* self,
                                                       GFile* src,
                                                       GFile* dest,
                                                       GFile* dest_dir,
                                                       gchar** new_name,
                                                       gboolean* apply_to_all)
{
	gchar* _vala_new_name = NULL;
	gboolean _vala_apply_to_all = FALSE;
	Block37Data* _data37_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GTimer* _tmp3_;
	PFProgressInfo* _tmp4_;
	GMainContext* _tmp5_;
	GMainLoop* _tmp6_;
	gchar* _tmp7_;
	PFProgressInfo* _tmp8_;
	GTimer* _tmp9_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (src != NULL, 0);
	g_return_val_if_fail (dest != NULL, 0);
	g_return_val_if_fail (dest_dir != NULL, 0);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_data37_->self = marlin_file_operations_common_job_ref (self);
	_tmp0_ = _g_object_ref0 (src);
	_g_object_unref0 (_data37_->src);
	_data37_->src = _tmp0_;
	_tmp1_ = _g_object_ref0 (dest);
	_g_object_unref0 (_data37_->dest);
	_data37_->dest = _tmp1_;
	_tmp2_ = _g_object_ref0 (dest_dir);
	_g_object_unref0 (_data37_->dest_dir);
	_data37_->dest_dir = _tmp2_;
	_data37_->_result_ = 0;
	_data37_->_new_name = NULL;
	_data37_->_apply_to_all = FALSE;
	_tmp3_ = self->time;
	g_timer_stop (_tmp3_);
	_tmp4_ = self->progress;
	pf_progress_info_pause (_tmp4_);
	_tmp5_ = g_main_context_get_thread_default ();
	_tmp6_ = g_main_loop_new (_tmp5_, FALSE);
	_data37_->main_loop = _tmp6_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda63__gsource_func, block37_data_ref (_data37_), block37_data_unref);
	g_main_loop_run (_data37_->main_loop);
	_tmp7_ = g_strdup (_data37_->_new_name);
	_g_free0 (_vala_new_name);
	_vala_new_name = _tmp7_;
	_vala_apply_to_all = _data37_->_apply_to_all;
	_tmp8_ = self->progress;
	pf_progress_info_resume (_tmp8_);
	_tmp9_ = self->time;
	g_timer_continue (_tmp9_);
	result = _data37_->_result_;
	block37_data_unref (_data37_);
	_data37_ = NULL;
	if (new_name) {
		*new_name = _vala_new_name;
	} else {
		_g_free0 (_vala_new_name);
	}
	if (apply_to_all) {
		*apply_to_all = _vala_apply_to_all;
	}
	return result;
}

SourceInfo*
marlin_file_operations_common_job_source_info_copy (SourceInfo* self)
{
	SourceInfo* _tmp0_ = NULL;
	SourceInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = marlin_file_operations_common_job_source_info_new ();
	_tmp0_->num_files = self->num_files;
	_tmp0_->num_bytes = self->num_bytes;
	_tmp0_->num_files_since_progress = self->num_files_since_progress;
	result = _tmp0_;
	return result;
}

SourceInfo*
marlin_file_operations_common_job_source_info_new (void)
{
	SourceInfo* self;
	self = g_slice_new0 (SourceInfo);
	marlin_file_operations_common_job_source_info_instance_init (self);
	return self;
}

static void
marlin_file_operations_common_job_source_info_instance_init (SourceInfo * self)
{
}

void
marlin_file_operations_common_job_source_info_free (SourceInfo * self)
{
	g_slice_free (SourceInfo, self);
}

TransferInfo*
marlin_file_operations_common_job_transfer_info_new (void)
{
	TransferInfo* self;
	self = g_slice_new0 (TransferInfo);
	marlin_file_operations_common_job_transfer_info_instance_init (self);
	return self;
}

static void
marlin_file_operations_common_job_transfer_info_instance_init (TransferInfo * self)
{
}

void
marlin_file_operations_common_job_transfer_info_free (TransferInfo * self)
{
	g_slice_free (TransferInfo, self);
}

static void
marlin_file_operations_value_common_job_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
marlin_file_operations_value_common_job_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		marlin_file_operations_common_job_unref (value->data[0].v_pointer);
	}
}

static void
marlin_file_operations_value_common_job_copy_value (const GValue* src_value,
                                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = marlin_file_operations_common_job_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
marlin_file_operations_value_common_job_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
marlin_file_operations_value_common_job_collect_value (GValue* value,
                                                       guint n_collect_values,
                                                       GTypeCValue* collect_values,
                                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FilesFileOperationsCommonJob * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = marlin_file_operations_common_job_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
marlin_file_operations_value_common_job_lcopy_value (const GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	FilesFileOperationsCommonJob ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = marlin_file_operations_common_job_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
marlin_file_operations_param_spec_common_job (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags)
{
	FilesFileOperationsParamSpecCommonJob* spec;
	g_return_val_if_fail (g_type_is_a (object_type, MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
marlin_file_operations_value_get_common_job (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB), NULL);
	return value->data[0].v_pointer;
}

void
marlin_file_operations_value_set_common_job (GValue* value,
                                             gpointer v_object)
{
	FilesFileOperationsCommonJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		marlin_file_operations_common_job_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		marlin_file_operations_common_job_unref (old);
	}
}

void
marlin_file_operations_value_take_common_job (GValue* value,
                                              gpointer v_object)
{
	FilesFileOperationsCommonJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		marlin_file_operations_common_job_unref (old);
	}
}

static void
marlin_file_operations_common_job_class_init (FilesFileOperationsCommonJobClass * klass,
                                              gpointer klass_data)
{
	marlin_file_operations_common_job_parent_class = g_type_class_peek_parent (klass);
	((FilesFileOperationsCommonJobClass *) klass)->finalize = marlin_file_operations_common_job_finalize;
	g_type_class_adjust_private_offset (klass, &FilesFileOperationsCommonJob_private_offset);
	((FilesFileOperationsCommonJobClass *) klass)->get_scan_primary = (const gchar* (*) (FilesFileOperationsCommonJob*)) marlin_file_operations_common_job_real_get_scan_primary;
	((FilesFileOperationsCommonJobClass *) klass)->report_count_progress = (void (*) (FilesFileOperationsCommonJob*, SourceInfo*)) marlin_file_operations_common_job_real_report_count_progress;
}

static void
marlin_file_operations_common_job_instance_init (FilesFileOperationsCommonJob * self,
                                                 gpointer klass)
{
	self->priv = marlin_file_operations_common_job_get_instance_private (self);
	self->ref_count = 1;
}

static void
marlin_file_operations_common_job_finalize (FilesFileOperationsCommonJob * obj)
{
	FilesFileOperationsCommonJob * self;
	PFProgressInfo* _tmp0_;
	FilesUndoActionData* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, FilesFileOperationsCommonJob);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->progress;
	pf_progress_info_finish (_tmp0_);
	marlin_file_operations_common_job_uninhibit_power_manager (self);
	_tmp1_ = self->undo_redo_data;
	if (_tmp1_ != NULL) {
		FilesUndoManager* _tmp2_;
		FilesUndoActionData* _tmp3_;
		_tmp2_ = files_undo_manager_instance ();
		_tmp3_ = self->undo_redo_data;
		self->undo_redo_data = NULL;
		files_undo_manager_add_action (_tmp2_, _tmp3_);
	}
	_g_object_unref0 (self->progress);
	_files_undo_action_data_unref0 (self->undo_redo_data);
	_g_timer_destroy0 (self->time);
	_g_hash_table_unref0 (self->priv->skip_readdir_error_set);
	_g_hash_table_unref0 (self->skip_files);
}

 G_GNUC_NO_INLINE static GType
marlin_file_operations_common_job_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { marlin_file_operations_value_common_job_init, marlin_file_operations_value_common_job_free_value, marlin_file_operations_value_common_job_copy_value, marlin_file_operations_value_common_job_peek_pointer, "p", marlin_file_operations_value_common_job_collect_value, "p", marlin_file_operations_value_common_job_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FilesFileOperationsCommonJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) marlin_file_operations_common_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesFileOperationsCommonJob), 0, (GInstanceInitFunc) marlin_file_operations_common_job_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType marlin_file_operations_common_job_type_id;
	marlin_file_operations_common_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FilesFileOperationsCommonJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FilesFileOperationsCommonJob_private_offset = g_type_add_instance_private (marlin_file_operations_common_job_type_id, sizeof (FilesFileOperationsCommonJobPrivate));
	return marlin_file_operations_common_job_type_id;
}

GType
marlin_file_operations_common_job_get_type (void)
{
	static volatile gsize marlin_file_operations_common_job_type_id__once = 0;
	if (g_once_init_enter (&marlin_file_operations_common_job_type_id__once)) {
		GType marlin_file_operations_common_job_type_id;
		marlin_file_operations_common_job_type_id = marlin_file_operations_common_job_get_type_once ();
		g_once_init_leave (&marlin_file_operations_common_job_type_id__once, marlin_file_operations_common_job_type_id);
	}
	return marlin_file_operations_common_job_type_id__once;
}

gpointer
marlin_file_operations_common_job_ref (gpointer instance)
{
	FilesFileOperationsCommonJob * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
marlin_file_operations_common_job_unref (gpointer instance)
{
	FilesFileOperationsCommonJob * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MARLIN_FILE_OPERATIONS_COMMON_JOB_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

