/* FileUtils.c generated by valac 0.56.18, the Vala compiler
 * generated from FileUtils.vala, do not modify */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "pantheon-files-core.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include "marlin-file-operations.h"
#include <gdk/gdk.h>
#include <gee.h>
#include <glib-object.h>
#include <errno.h>
#include <glib/gstdio.h>
#include <unistd.h>

#define FILES_FILE_UTILS_RESERVED_CHARS G_URI_RESERVED_CHARS_GENERIC_DELIMITERS G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS " "
#define FILES_FILE_UTILS_COMPRESSION_EXTENSIONS "bz2 F gz tz lz lzma lzo rz sfark sz xz z Z "
#define FILES_FILE_UTILS_ARCHIVE_EXTENSIONS "a cpio shar LBR iso lbr mar sbx tar"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block14Data Block14Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _FilesFileUtilsSetFileDisplayNameData FilesFileUtilsSetFileDisplayNameData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block14Data {
	int _ref_count_;
	GtkWidget* widget;
};

struct _FilesFileUtilsSetFileDisplayNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* old_location;
	gchar* new_name;
	GCancellable* cancellable;
	GFile* result;
	gchar* original_name;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* new_location;
	FilesDirectory* dir;
	FilesDirectory* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	FilesDirectory* _tmp6_;
	GList* added_files;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GList* removed_files;
	GFile* _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	FilesUndoManager* _tmp12_;
	GFile* _tmp13_;
	const gchar* _tmp14_;
	GError* e;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GraniteMessageDialog* _tmp19_;
	GraniteMessageDialog* _tmp20_;
	FilesDirectory* _tmp21_;
	FilesDirectory* _tmp22_;
	GError* _tmp23_;
	GError* _tmp24_;
	GError* _inner_error0_;
};

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN gchar* files_file_utils_construct_parent_path (const gchar* path,
                                               gboolean include_file_protocol);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
VALA_EXTERN GHashTable* files_file_utils_get_trashed_files_original_directories (GList* files,
                                                                     GList** unhandled_files);
static void __lambda47_ (Block14Data* _data14_,
                  GFile* original_dir,
                  GList* dir_files);
static void ___lambda47__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static guint _g_file_hash_ghash_func (gconstpointer key);
static gboolean _g_file_equal_gequal_func (gconstpointer a,
                                    gconstpointer b);
static void __g_list_free__g_object_unref0_0_ (gpointer var);
VALA_EXTERN GFile* files_file_utils_get_trashed_file_original_folder (FilesFile* file);
VALA_EXTERN gboolean files_file_utils_ensure_exists (GFile* file);
VALA_EXTERN gboolean files_file_utils_can_browse_scheme (const gchar* scheme);
VALA_EXTERN gchar* files_file_utils_strip_extension (const gchar* filename);
static void files_file_utils_set_file_display_name_data_free (gpointer _data);
static gboolean files_file_utils_set_file_display_name_co (FilesFileUtilsSetFileDisplayNameData* _data_);
static void files_file_utils_set_file_display_name_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
VALA_EXTERN gchar* files_file_utils_get_informal_date_time (GDateTime* dt);
VALA_EXTERN gboolean files_file_utils_same_file_system (GFile* a,
                                            GFile* b);
VALA_EXTERN gboolean files_file_utils_get_afp_user_server_and_filename (const gchar* uri,
                                                            gchar** filename,
                                                            gchar** user_server);
VALA_EXTERN void files_file_utils_parse_previous_duplicate_name (const gchar* name,
                                                     gboolean is_link,
                                                     gchar** name_base,
                                                     gchar** suffix,
                                                     gint* count);
VALA_EXTERN gchar* files_file_utils_get_link_or_copy_name (const gchar* target_name,
                                               gboolean is_link,
                                               gint count,
                                               gint max_length);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GList*
files_file_utils_files_from_uris (const gchar* uris)
{
	GList* _result_ = NULL;
	gchar** uri_list = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint uri_list_length1;
	gint _uri_list_size_;
	gchar* unquoted_uri = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (uris != NULL, NULL);
	_result_ = NULL;
	_tmp1_ = _tmp0_ = g_uri_list_extract_uris (uris);
	uri_list = _tmp1_;
	uri_list_length1 = _vala_array_length (_tmp0_);
	_uri_list_size_ = uri_list_length1;
	_tmp2_ = uri_list;
	_tmp2__length1 = uri_list_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp2_;
		uri_collection_length1 = _tmp2__length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			const gchar* uri = NULL;
			uri = uri_collection[uri_it];
			{
				{
					gchar* _tmp3_ = NULL;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					const gchar* _tmp7_;
					GFile* _tmp8_;
					_tmp4_ = uri;
					_tmp5_ = g_shell_unquote (_tmp4_, &_inner_error0_);
					_tmp3_ = _tmp5_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp6_ = _tmp3_;
					_tmp3_ = NULL;
					_g_free0 (unquoted_uri);
					unquoted_uri = _tmp6_;
					_tmp7_ = unquoted_uri;
					_tmp8_ = g_file_new_for_uri (_tmp7_);
					_result_ = g_list_append (_result_, _tmp8_);
					_g_free0 (_tmp3_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp9_;
					GError* _tmp10_;
					const gchar* _tmp11_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp9_ = uri;
					_tmp10_ = e;
					_tmp11_ = _tmp10_->message;
					g_warning ("FileUtils.vala:33: Error when unquoting %s. %s", _tmp9_, _tmp11_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (unquoted_uri);
					uri_list = (_vala_array_free (uri_list, uri_list_length1, (GDestroyNotify) g_free), NULL);
					(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_object_unref0_ (_result_), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	result = _result_;
	_g_free0 (unquoted_uri);
	uri_list = (_vala_array_free (uri_list, uri_list_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

GKeyFile*
files_file_utils_key_file_from_file (GFile* file,
                                     GCancellable* cancellable,
                                     GError** error)
{
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	GKeyFile* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		gchar* etag_out = NULL;
		guint8* _tmp1_ = NULL;
		gsize _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
		GKeyFile* _tmp4_;
		guint8* _tmp5_;
		gint _tmp5__length1;
		g_file_load_contents (file, cancellable, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error0_);
		contents = (g_free (contents), NULL);
		contents = _tmp1_;
		contents_length1 = _tmp2_;
		_contents_size_ = contents_length1;
		_g_free0 (etag_out);
		etag_out = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (etag_out);
			contents = (g_free (contents), NULL);
			goto __catch0_g_error;
		}
		_tmp4_ = keyfile;
		_tmp5_ = contents;
		_tmp5__length1 = contents_length1;
		g_key_file_load_from_data (_tmp4_, (const gchar*) _tmp5_, (gsize) -1, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (etag_out);
			contents = (g_free (contents), NULL);
			goto __catch0_g_error;
		}
		_g_free0 (etag_out);
		contents = (g_free (contents), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		GError* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _g_error_copy0 (_tmp6_);
		_inner_error0_ = _tmp7_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	result = keyfile;
	return result;
}

GFile*
files_file_utils_get_file_for_path (const gchar* path)
{
	gchar* new_path = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GFile* result;
	_tmp0_ = files_file_utils_sanitize_path (path, NULL, TRUE);
	new_path = _tmp0_;
	_tmp2_ = new_path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = new_path;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = new_path;
		_tmp7_ = g_file_new_for_commandline_arg (_tmp6_);
		result = _tmp7_;
		_g_free0 (new_path);
		return result;
	} else {
		result = NULL;
		_g_free0 (new_path);
		return result;
	}
}

gchar*
files_file_utils_get_parent_path_from_path (const gchar* path,
                                            gboolean include_file_protocol)
{
	gchar* parent_path = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = files_file_utils_construct_parent_path (path, include_file_protocol);
	parent_path = _tmp0_;
	_tmp2_ = parent_path;
	if (g_strcmp0 (_tmp2_, FILES_FTP_URI) == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = parent_path;
		_tmp1_ = g_strcmp0 (_tmp3_, FILES_SFTP_URI) == 0;
	}
	if (_tmp1_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (path);
		_g_free0 (parent_path);
		parent_path = _tmp4_;
	}
	_tmp5_ = parent_path;
	if (g_strcmp0 (_tmp5_, FILES_SMB_URI) == 0) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = parent_path;
		_tmp7_ = g_strconcat (_tmp6_, G_DIR_SEPARATOR_S, NULL);
		_g_free0 (parent_path);
		parent_path = _tmp7_;
	}
	result = parent_path;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_object_unref0 (_data14_->widget);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
__lambda47_ (Block14Data* _data14_,
             GFile* original_dir,
             GList* dir_files)
{
	g_return_if_fail (original_dir != NULL);
	marlin_file_operations_copy_move_link (dir_files, original_dir, GDK_ACTION_MOVE, _data14_->widget, NULL, NULL, NULL);
}

static void
___lambda47__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda47_ (self, (GFile*) key, (GList*) value);
}

void
files_file_utils_restore_files_from_trash (GList* files,
                                           GtkWidget* widget)
{
	Block14Data* _data14_;
	GtkWidget* _tmp0_;
	GList* unhandled_files = NULL;
	GHashTable* original_dirs_hash = NULL;
	GList* _tmp1_ = NULL;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	GHashTable* _tmp12_;
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data14_->widget);
	_data14_->widget = _tmp0_;
	unhandled_files = NULL;
	_tmp2_ = files_file_utils_get_trashed_files_original_directories (files, &_tmp1_);
	(unhandled_files == NULL) ? NULL : (unhandled_files = (_g_list_free__g_object_unref0_ (unhandled_files), NULL));
	unhandled_files = _tmp1_;
	original_dirs_hash = _tmp2_;
	_tmp3_ = unhandled_files;
	{
		GList* goffile_collection = NULL;
		GList* goffile_it = NULL;
		goffile_collection = _tmp3_;
		for (goffile_it = goffile_collection; goffile_it != NULL; goffile_it = goffile_it->next) {
			FilesFile* _tmp4_;
			FilesFile* goffile = NULL;
			_tmp4_ = _g_object_ref0 ((FilesFile*) goffile_it->data);
			goffile = _tmp4_;
			{
				gchar* message = NULL;
				FilesFile* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GtkWindow* _tmp8_ = NULL;
				const gchar* _tmp9_;
				GraniteMessageDialog* _tmp10_;
				GraniteMessageDialog* _tmp11_;
				_tmp5_ = goffile;
				_tmp6_ = files_file_get_display_name (_tmp5_);
				_tmp7_ = g_strdup_printf (_ ("Could not determine original location of \"%s\""), _tmp6_);
				message = _tmp7_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_data14_->widget, gtk_window_get_type ())) {
					_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_data14_->widget, gtk_window_get_type ()) ? ((GtkWindow*) _data14_->widget) : NULL;
				} else {
					_tmp8_ = NULL;
				}
				_tmp9_ = message;
				_tmp10_ = pf_dialogs_show_warning_dialog (_tmp9_, _ ("The item cannot be restored from trash"), _tmp8_);
				_tmp11_ = _tmp10_;
				_g_object_unref0 (_tmp11_);
				_g_free0 (message);
				_g_object_unref0 (goffile);
			}
		}
	}
	_tmp12_ = original_dirs_hash;
	g_hash_table_foreach (_tmp12_, ___lambda47__gh_func, _data14_);
	_g_hash_table_unref0 (original_dirs_hash);
	(unhandled_files == NULL) ? NULL : (unhandled_files = (_g_list_free__g_object_unref0_ (unhandled_files), NULL));
	block14_data_unref (_data14_);
	_data14_ = NULL;
}

static guint
_g_file_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = g_file_hash (key);
	return result;
}

static gboolean
_g_file_equal_gequal_func (gconstpointer a,
                           gconstpointer b)
{
	gboolean result;
	result = g_file_equal (a, (GFile*) b);
	return result;
}

static void
__g_list_free__g_object_unref0_0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL));
}

static gpointer
_vala_g_hash_table_take (GHashTable* self,
                         gconstpointer key,
                         gboolean* exists)
{
	gboolean _vala_exists = FALSE;
	GHashTable* ht = NULL;
	void** htp = NULL;
	gconstpointer _tmp0_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	ht = NULL;
	htp = &ht;
	_tmp0_ = g_hash_table_lookup (self, key);
	*htp = _tmp0_;
	_vala_exists = g_hash_table_steal (self, key);
	result = ht;
	if (exists) {
		*exists = _vala_exists;
	}
	return result;
}

GHashTable*
files_file_utils_get_trashed_files_original_directories (GList* files,
                                                         GList** unhandled_files)
{
	GList* _vala_unhandled_files = NULL;
	GHashTable* directories = NULL;
	GHashTable* _tmp0_;
	GeeHashMap* exists_map = NULL;
	GeeHashMap* _tmp1_;
	GHashTable* result;
	_tmp0_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, _g_object_unref0_, __g_list_free__g_object_unref0_0_);
	directories = _tmp0_;
	(_vala_unhandled_files == NULL) ? NULL : (_vala_unhandled_files = (_g_list_free__g_object_unref0_ (_vala_unhandled_files), NULL));
	_vala_unhandled_files = NULL;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	exists_map = _tmp1_;
	{
		GList* goffile_collection = NULL;
		GList* goffile_it = NULL;
		goffile_collection = files;
		for (goffile_it = goffile_collection; goffile_it != NULL; goffile_it = goffile_it->next) {
			FilesFile* goffile = NULL;
			goffile = (FilesFile*) goffile_it->data;
			{
				gboolean _tmp2_ = FALSE;
				FilesFile* _tmp3_;
				FilesFile* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_;
				_tmp3_ = goffile;
				if (_tmp3_ == NULL) {
					_tmp2_ = TRUE;
				} else {
					FilesFile* _tmp4_;
					GFile* _tmp5_;
					GFile* _tmp6_;
					_tmp4_ = goffile;
					_tmp5_ = files_file_get_location (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp2_ = _tmp6_ == NULL;
				}
				if (_tmp2_) {
					continue;
				}
				_tmp7_ = goffile;
				_tmp8_ = files_file_get_uri (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_path_get_dirname (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strcmp0 (_tmp11_, "trash:") == 0;
				_g_free0 (_tmp11_);
				if (_tmp12_) {
					GFile* original_dir = NULL;
					FilesFile* _tmp13_;
					GFile* _tmp14_;
					GFile* _tmp15_;
					_tmp13_ = goffile;
					_tmp14_ = files_file_utils_get_trashed_file_original_folder (_tmp13_);
					original_dir = _tmp14_;
					_tmp15_ = original_dir;
					if (_tmp15_ != NULL) {
						gint exists = 0;
						GeeHashMap* _tmp16_;
						GFile* _tmp17_;
						gchar* _tmp18_;
						gchar* _tmp19_;
						gboolean _tmp20_;
						gboolean _tmp26_ = FALSE;
						exists = -1;
						_tmp16_ = exists_map;
						_tmp17_ = original_dir;
						_tmp18_ = g_file_get_path (_tmp17_);
						_tmp19_ = _tmp18_;
						_tmp20_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp16_, _tmp19_);
						_g_free0 (_tmp19_);
						if (_tmp20_) {
							GeeHashMap* _tmp21_;
							GFile* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							gpointer _tmp25_;
							_tmp21_ = exists_map;
							_tmp22_ = original_dir;
							_tmp23_ = g_file_get_path (_tmp22_);
							_tmp24_ = _tmp23_;
							_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, _tmp24_);
							exists = (gint) ((gintptr) _tmp25_);
							_g_free0 (_tmp24_);
						}
						if (exists == 1) {
							_tmp26_ = TRUE;
						} else {
							gboolean _tmp27_ = FALSE;
							if (exists < 0) {
								GFile* _tmp28_;
								_tmp28_ = original_dir;
								_tmp27_ = files_file_utils_ensure_exists (_tmp28_);
							} else {
								_tmp27_ = FALSE;
							}
							_tmp26_ = _tmp27_;
						}
						if (_tmp26_) {
							GList* dir_files = NULL;
							GHashTable* _tmp33_;
							GFile* _tmp34_;
							gpointer _tmp35_;
							FilesFile* _tmp36_;
							GFile* _tmp37_;
							GFile* _tmp38_;
							GFile* _tmp39_;
							GHashTable* _tmp40_;
							GFile* _tmp41_;
							GFile* _tmp42_;
							GList* _tmp43_;
							if (exists < 0) {
								GeeHashMap* _tmp29_;
								GFile* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_;
								_tmp29_ = exists_map;
								_tmp30_ = original_dir;
								_tmp31_ = g_file_get_path (_tmp30_);
								_tmp32_ = _tmp31_;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp32_, (gpointer) ((gintptr) 1));
								_g_free0 (_tmp32_);
							}
							_tmp33_ = directories;
							_tmp34_ = original_dir;
							_tmp35_ = _vala_g_hash_table_take (_tmp33_, _tmp34_, NULL);
							dir_files = (GList*) _tmp35_;
							_tmp36_ = goffile;
							_tmp37_ = files_file_get_location (_tmp36_);
							_tmp38_ = _tmp37_;
							_tmp39_ = _g_object_ref0 (_tmp38_);
							dir_files = g_list_prepend (dir_files, _tmp39_);
							_tmp40_ = directories;
							_tmp41_ = original_dir;
							_tmp42_ = _g_object_ref0 (_tmp41_);
							_tmp43_ = dir_files;
							dir_files = NULL;
							g_hash_table_insert (_tmp40_, _tmp42_, _tmp43_);
							(dir_files == NULL) ? NULL : (dir_files = (_g_list_free__g_object_unref0_ (dir_files), NULL));
						} else {
							if (exists < 0) {
								GeeHashMap* _tmp44_;
								GFile* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								_tmp44_ = exists_map;
								_tmp45_ = original_dir;
								_tmp46_ = g_file_get_path (_tmp45_);
								_tmp47_ = _tmp46_;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp44_, _tmp47_, (gpointer) ((gintptr) 0));
								_g_free0 (_tmp47_);
							}
						}
					} else {
						FilesFile* _tmp48_;
						FilesFile* _tmp49_;
						_tmp48_ = goffile;
						_tmp49_ = _g_object_ref0 (_tmp48_);
						_vala_unhandled_files = g_list_prepend (_vala_unhandled_files, _tmp49_);
					}
					_g_object_unref0 (original_dir);
				}
			}
		}
	}
	result = directories;
	_g_object_unref0 (exists_map);
	if (unhandled_files) {
		*unhandled_files = _vala_unhandled_files;
	} else {
		(_vala_unhandled_files == NULL) ? NULL : (_vala_unhandled_files = (_g_list_free__g_object_unref0_ (_vala_unhandled_files), NULL));
	}
	return result;
}

GFile*
files_file_utils_get_trashed_file_original_folder (FilesFile* file)
{
	GFileInfo* info = NULL;
	gchar* original_path = NULL;
	GFileInfo* _tmp0_;
	gboolean _tmp14_ = FALSE;
	GFileInfo* _tmp15_;
	const gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (file != NULL, NULL);
	info = NULL;
	original_path = NULL;
	_tmp0_ = file->info;
	if (_tmp0_ == NULL) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		_tmp1_ = files_file_get_location (file);
		_tmp2_ = _tmp1_;
		if (_tmp2_ != NULL) {
			{
				GFileInfo* _tmp3_ = NULL;
				GFile* _tmp4_;
				GFile* _tmp5_;
				GFileInfo* _tmp6_;
				GFileInfo* _tmp7_;
				_tmp4_ = files_file_get_location (file);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_file_query_info (_tmp5_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
				_tmp3_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp7_ = _tmp3_;
				_tmp3_ = NULL;
				_g_object_unref0 (info);
				info = _tmp7_;
				_g_object_unref0 (_tmp3_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GError* _tmp10_;
				const gchar* _tmp11_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp8_ = files_file_get_uri (file);
				_tmp9_ = _tmp8_;
				_tmp10_ = e;
				_tmp11_ = _tmp10_->message;
				g_debug ("FileUtils.vala:156: Error querying info of trashed file %s: %s", _tmp9_, _tmp11_);
				result = NULL;
				_g_error_free0 (e);
				_g_free0 (original_path);
				_g_object_unref0 (info);
				return result;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (original_path);
				_g_object_unref0 (info);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		GFileInfo* _tmp12_;
		GFileInfo* _tmp13_;
		_tmp12_ = file->info;
		_tmp13_ = g_file_info_dup (_tmp12_);
		_g_object_unref0 (info);
		info = _tmp13_;
	}
	_tmp15_ = info;
	if (_tmp15_ != NULL) {
		GFileInfo* _tmp16_;
		_tmp16_ = info;
		_tmp14_ = g_file_info_has_attribute (_tmp16_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GFileInfo* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = file->info;
		_tmp18_ = g_file_info_get_attribute_byte_string (_tmp17_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH);
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (original_path);
		original_path = _tmp19_;
	}
	_tmp20_ = original_path;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		_tmp21_ = files_file_get_uri (file);
		_tmp22_ = _tmp21_;
		_tmp23_ = original_path;
		g_debug ("FileUtils.vala:169: Original path of trashed file %s was %s", _tmp22_, _tmp23_);
		_tmp24_ = original_path;
		_tmp25_ = files_file_utils_get_parent_path_from_path (_tmp24_, TRUE);
		_tmp26_ = _tmp25_;
		_tmp27_ = files_file_utils_get_file_for_path (_tmp26_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		result = _tmp28_;
		_g_free0 (original_path);
		_g_object_unref0 (info);
		return result;
	} else {
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = files_file_get_uri (file);
		_tmp30_ = _tmp29_;
		g_debug ("FileUtils.vala:172: Could not get original path for trashed file %s", _tmp30_);
		result = NULL;
		_g_free0 (original_path);
		_g_object_unref0 (info);
		return result;
	}
}

gboolean
files_file_utils_ensure_exists (GFile* file)
{
	GraniteMessageDialog* dialog = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GraniteMessageDialog* _tmp4_;
	GraniteMessageDialog* _tmp5_;
	GtkWidget* ignore_button = NULL;
	GraniteMessageDialog* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* recreate_button = NULL;
	GraniteMessageDialog* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GraniteMessageDialog* _tmp14_;
	gint response = 0;
	GraniteMessageDialog* _tmp15_;
	GraniteMessageDialog* _tmp16_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	if (g_file_query_exists (file, NULL)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("The original folder %s no longer exists"), _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = granite_message_dialog_new_with_image_from_icon_name (_tmp3_, _ ("Would you like to recreate it?"), "dialog-question", GTK_BUTTONS_NONE);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	dialog = _tmp5_;
	_tmp6_ = dialog;
	_tmp7_ = gtk_dialog_add_button ((GtkDialog*) _tmp6_, _ ("Ignore"), (gint) GTK_RESPONSE_CANCEL);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	ignore_button = _tmp8_;
	_tmp9_ = ignore_button;
	gtk_widget_set_tooltip_text (_tmp9_, _ ("No files that were in this folder will be restored"));
	_tmp10_ = dialog;
	_tmp11_ = gtk_dialog_add_button ((GtkDialog*) _tmp10_, _ ("Recreate"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	recreate_button = _tmp12_;
	_tmp13_ = recreate_button;
	gtk_widget_set_tooltip_text (_tmp13_, _ ("The folder will be recreated and selected files that were originally t" \
"here will be restored to it"));
	_tmp14_ = dialog;
	gtk_dialog_set_default_response ((GtkDialog*) _tmp14_, (gint) GTK_RESPONSE_ACCEPT);
	_tmp15_ = dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp15_);
	_tmp16_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp16_);
	switch (response) {
		case GTK_RESPONSE_ACCEPT:
		{
			{
				g_file_make_directory_with_parents (file, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				result = TRUE;
				_g_object_unref0 (recreate_button);
				_g_object_unref0 (ignore_button);
				_g_object_unref0 (dialog);
				return result;
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GraniteMessageDialog* error_dialog = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				GError* _tmp21_;
				const gchar* _tmp22_;
				GraniteMessageDialog* _tmp23_;
				GraniteMessageDialog* _tmp24_;
				GraniteMessageDialog* _tmp25_;
				GraniteMessageDialog* _tmp26_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp17_ = g_file_get_path (file);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strdup_printf (_ ("Could not recreate folder %s. Will ignore all files in this folder"), _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = e;
				_tmp22_ = _tmp21_->message;
				_tmp23_ = granite_message_dialog_new_with_image_from_icon_name (_tmp20_, _tmp22_, "dialog-error", GTK_BUTTONS_CLOSE);
				g_object_ref_sink (_tmp23_);
				_tmp24_ = _tmp23_;
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				error_dialog = _tmp24_;
				_tmp25_ = error_dialog;
				gtk_dialog_run ((GtkDialog*) _tmp25_);
				_tmp26_ = error_dialog;
				gtk_widget_destroy ((GtkWidget*) _tmp26_);
				_g_object_unref0 (error_dialog);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp27_ = FALSE;
				_g_object_unref0 (recreate_button);
				_g_object_unref0 (ignore_button);
				_g_object_unref0 (dialog);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp27_;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	_g_object_unref0 (recreate_button);
	_g_object_unref0 (ignore_button);
	_g_object_unref0 (dialog);
	return result;
}

gchar*
files_file_utils_get_path_for_symlink (GFile* file)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_uri_parse_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "file") != 0;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (_tmp4_) {
		_g_free0 (_result_);
		_result_ = NULL;
	} else {
		if (g_file_is_native (file)) {
			gchar* _tmp5_;
			_tmp5_ = g_file_get_path (file);
			_g_free0 (_result_);
			_result_ = _tmp5_;
		} else {
			GFile* root = NULL;
			GFile* _tmp6_;
			GFile* parent = NULL;
			GFile* _tmp7_;
			GFile* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp6_ = _g_object_ref0 (file);
			root = _tmp6_;
			_tmp7_ = g_file_get_parent (file);
			parent = _tmp7_;
			while (TRUE) {
				GFile* _tmp8_;
				GFile* _tmp9_;
				GFile* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				_tmp8_ = parent;
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp9_ = parent;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				_g_object_unref0 (root);
				root = _tmp10_;
				_tmp11_ = root;
				_tmp12_ = g_file_get_parent (_tmp11_);
				_g_object_unref0 (parent);
				parent = _tmp12_;
			}
			_tmp13_ = root;
			_tmp14_ = g_file_get_relative_path (_tmp13_, file);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (G_DIR_SEPARATOR_S, _tmp15_, NULL);
			_g_free0 (_result_);
			_result_ = _tmp16_;
			_g_free0 (_tmp15_);
			_g_object_unref0 (parent);
			_g_object_unref0 (root);
		}
	}
	result = _result_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
files_file_utils_construct_parent_path (const gchar* path,
                                        gboolean include_file_protocol)
{
	gint _tmp0_;
	gint _tmp1_;
	GString* sb = NULL;
	GString* _tmp3_;
	gint last_separator = 0;
	GString* _tmp9_;
	const gchar* _tmp10_;
	GString* _tmp11_;
	gchar* parent_path = NULL;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = strlen (path);
	_tmp1_ = _tmp0_;
	if (_tmp1_ < 2) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (G_DIR_SEPARATOR_S);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_string_new (path);
	sb = _tmp3_;
	if (g_str_has_suffix (path, G_DIR_SEPARATOR_S)) {
		GString* _tmp4_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp4_ = sb;
		_tmp5_ = sb;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		g_string_erase (_tmp4_, (gssize) (_tmp8_ - 1), (gssize) -1);
	}
	_tmp9_ = sb;
	_tmp10_ = _tmp9_->str;
	last_separator = string_last_index_of (_tmp10_, G_DIR_SEPARATOR_S, 0);
	if (last_separator < 0) {
		last_separator = 0;
	}
	_tmp11_ = sb;
	g_string_erase (_tmp11_, (gssize) last_separator, (gssize) -1);
	_tmp12_ = sb;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strconcat (_tmp13_, G_DIR_SEPARATOR_S, NULL);
	parent_path = _tmp14_;
	_tmp15_ = parent_path;
	_tmp16_ = files_file_utils_sanitize_path (_tmp15_, NULL, include_file_protocol);
	result = _tmp16_;
	_g_free0 (parent_path);
	_g_string_free0 (sb);
	return result;
}

gboolean
files_file_utils_path_has_parent (const gchar* new_path)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (new_path != NULL, FALSE);
	_tmp0_ = g_file_new_for_commandline_arg (new_path);
	file = _tmp0_;
	_tmp1_ = g_file_get_parent (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	_g_object_unref0 (file);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
files_file_utils_escape_uri (const gchar* uri,
                             gboolean allow_utf8,
                             gboolean allow_single_quote)
{
	gchar* rc = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* scheme = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* escaped_uri = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = string_replace (FILES_FILE_UTILS_RESERVED_CHARS, "#", "");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "*", "");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	rc = _tmp3_;
	if (!allow_single_quote) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = rc;
		_tmp5_ = string_replace (_tmp4_, "'", "");
		_g_free0 (rc);
		rc = _tmp5_;
	}
	_tmp6_ = g_uri_parse_scheme (uri);
	scheme = _tmp6_;
	_tmp8_ = g_uri_unescape_string (uri, NULL);
	_tmp7_ = _tmp8_;
	if (_tmp7_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (uri);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp9_;
	}
	_tmp10_ = rc;
	_tmp11_ = g_uri_escape_string (_tmp7_, _tmp10_, allow_utf8);
	escaped_uri = _tmp11_;
	_tmp13_ = scheme;
	if (g_strcmp0 (_tmp13_, "mtp") == 0) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp14_;
		_tmp14_ = scheme;
		_tmp12_ = g_strcmp0 (_tmp14_, "gphoto2") == 0;
	}
	if (_tmp12_) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = escaped_uri;
		_tmp16_ = string_replace (_tmp15_, ":", "%3A");
		_g_free0 (escaped_uri);
		escaped_uri = _tmp16_;
		_tmp17_ = escaped_uri;
		_tmp18_ = string_replace (_tmp17_, "%3A//", "://");
		_g_free0 (escaped_uri);
		escaped_uri = _tmp18_;
	}
	result = escaped_uri;
	_g_free0 (_tmp7_);
	_g_free0 (scheme);
	_g_free0 (rc);
	return result;
}

/** Produce a valid unescaped path.  A current path can be provided and is used to get the scheme and
      * to interpret relative paths where necessary.
      **/
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

gchar*
files_file_utils_sanitize_path (const gchar* input_uri,
                                const gchar* input_current_uri,
                                gboolean include_file_protocol)
{
	gchar* unsanitized_uri = NULL;
	gchar* unsanitized_current_uri = NULL;
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* scheme = NULL;
	gchar* _tmp1_;
	gchar* current_path = NULL;
	gchar* current_scheme = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gchar* unescaped_uri = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GString* sb = NULL;
	const gchar* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	GString* _tmp98_;
	const gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* new_path = NULL;
	const gchar* _tmp105_;
	const gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	const gchar* _tmp111_;
	gint _tmp112_;
	gint _tmp113_;
	gboolean _tmp129_ = FALSE;
	const gchar* _tmp138_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	path = _tmp0_;
	_tmp1_ = g_strdup ("");
	scheme = _tmp1_;
	current_path = NULL;
	current_scheme = NULL;
	if (input_uri == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (input_uri, "") == 0;
	}
	if (_tmp2_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_strdup (input_current_uri);
		_g_free0 (unsanitized_uri);
		unsanitized_uri = _tmp3_;
		_tmp4_ = g_strdup ("");
		_g_free0 (unsanitized_current_uri);
		unsanitized_current_uri = _tmp4_;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup (input_uri);
		_g_free0 (unsanitized_uri);
		unsanitized_uri = _tmp5_;
		_tmp6_ = g_strdup (input_current_uri);
		_g_free0 (unsanitized_current_uri);
		unsanitized_current_uri = _tmp6_;
	}
	_tmp8_ = unsanitized_uri;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = unsanitized_uri;
		_tmp7_ = g_strcmp0 (_tmp9_, "") == 0;
	}
	if (_tmp7_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		result = _tmp10_;
		_g_free0 (current_scheme);
		_g_free0 (current_path);
		_g_free0 (scheme);
		_g_free0 (path);
		_g_free0 (unsanitized_current_uri);
		_g_free0 (unsanitized_uri);
		return result;
	}
	_tmp11_ = unsanitized_uri;
	_tmp12_ = g_uri_unescape_string (_tmp11_, NULL);
	unescaped_uri = _tmp12_;
	_tmp13_ = unescaped_uri;
	if (_tmp13_ == NULL) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = unsanitized_uri;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (unescaped_uri);
		unescaped_uri = _tmp15_;
	}
	_tmp16_ = unescaped_uri;
	files_file_utils_split_protocol_from_path (_tmp16_, &_tmp17_, &_tmp18_);
	_g_free0 (scheme);
	scheme = _tmp17_;
	_g_free0 (path);
	path = _tmp18_;
	_tmp19_ = path;
	_tmp20_ = string_strip (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_replace (_tmp21_, "//", "/");
	_g_free0 (path);
	path = _tmp22_;
	_g_free0 (_tmp21_);
	_tmp23_ = path;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ == 0) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup ("/");
		_g_free0 (path);
		path = _tmp26_;
	}
	_tmp27_ = path;
	_tmp28_ = g_string_new (_tmp27_);
	sb = _tmp28_;
	_tmp29_ = unsanitized_current_uri;
	if (_tmp29_ != NULL) {
		const gchar* _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		const gchar* _tmp35_;
		_tmp30_ = unsanitized_current_uri;
		files_file_utils_split_protocol_from_path (_tmp30_, &_tmp31_, &_tmp32_);
		_g_free0 (current_scheme);
		current_scheme = _tmp31_;
		_g_free0 (current_path);
		current_path = _tmp32_;
		_tmp35_ = scheme;
		if (g_strcmp0 (_tmp35_, "") == 0) {
			_tmp34_ = TRUE;
		} else {
			const gchar* _tmp36_;
			_tmp36_ = scheme;
			_tmp34_ = g_strcmp0 (_tmp36_, FILES_ROOT_FS_URI) == 0;
		}
		if (_tmp34_) {
			const gchar* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			_tmp37_ = path;
			_tmp38_ = strlen (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp33_ = _tmp39_ > 0;
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			gchar** paths = NULL;
			const gchar* _tmp40_;
			gchar** _tmp41_;
			gchar** _tmp42_;
			gint paths_length1;
			gint _paths_size_;
			gchar** _tmp43_;
			gint _tmp43__length1;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			GQuark _tmp47_ = 0U;
			static GQuark _tmp46_label0 = 0;
			static GQuark _tmp46_label1 = 0;
			static GQuark _tmp46_label2 = 0;
			static GQuark _tmp46_label3 = 0;
			_tmp40_ = path;
			_tmp42_ = _tmp41_ = g_strsplit (_tmp40_, "/", 2);
			paths = _tmp42_;
			paths_length1 = _vala_array_length (_tmp41_);
			_paths_size_ = paths_length1;
			_tmp43_ = paths;
			_tmp43__length1 = paths_length1;
			_tmp44_ = _tmp43_[0];
			_tmp45_ = _tmp44_;
			_tmp47_ = (NULL == _tmp45_) ? 0 : g_quark_from_string (_tmp45_);
			if ((_tmp47_ == ((0 != _tmp46_label0) ? _tmp46_label0 : (_tmp46_label0 = g_quark_from_static_string ("~")))) || (_tmp47_ == ((0 != _tmp46_label1) ? _tmp46_label1 : (_tmp46_label1 = g_quark_from_static_string (""))))) {
				switch (0) {
					default:
					{
						break;
					}
				}
			} else if (_tmp47_ == ((0 != _tmp46_label2) ? _tmp46_label2 : (_tmp46_label2 = g_quark_from_static_string ("..")))) {
				switch (0) {
					default:
					{
						gboolean _tmp48_ = FALSE;
						const gchar* _tmp49_;
						GString* _tmp53_;
						const gchar* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						gchar** _tmp57_;
						gint _tmp57__length1;
						_tmp49_ = current_scheme;
						if (g_strcmp0 (_tmp49_, "") != 0) {
							const gchar* _tmp50_;
							_tmp50_ = current_scheme;
							_tmp48_ = g_strcmp0 (_tmp50_, FILES_ROOT_FS_URI) != 0;
						} else {
							_tmp48_ = FALSE;
						}
						if (_tmp48_) {
							const gchar* _tmp51_;
							gchar* _tmp52_;
							_tmp51_ = current_scheme;
							_tmp52_ = g_strdup (_tmp51_);
							_g_free0 (scheme);
							scheme = _tmp52_;
						}
						_tmp53_ = sb;
						_tmp54_ = current_path;
						_tmp55_ = files_file_utils_get_parent_path_from_path (_tmp54_, FALSE);
						_tmp56_ = _tmp55_;
						g_string_assign (_tmp53_, _tmp56_);
						_g_free0 (_tmp56_);
						_tmp57_ = paths;
						_tmp57__length1 = paths_length1;
						if (_tmp57__length1 > 1) {
							GString* _tmp58_;
							GString* _tmp59_;
							gchar** _tmp60_;
							gint _tmp60__length1;
							const gchar* _tmp61_;
							_tmp58_ = sb;
							g_string_append (_tmp58_, G_DIR_SEPARATOR_S);
							_tmp59_ = sb;
							_tmp60_ = paths;
							_tmp60__length1 = paths_length1;
							_tmp61_ = _tmp60_[1];
							g_string_append (_tmp59_, _tmp61_);
						}
						break;
					}
				}
			} else if (_tmp47_ == ((0 != _tmp46_label3) ? _tmp46_label3 : (_tmp46_label3 = g_quark_from_static_string (".")))) {
				switch (0) {
					default:
					{
						GString* _tmp62_;
						const gchar* _tmp63_;
						gchar** _tmp64_;
						gint _tmp64__length1;
						_tmp62_ = sb;
						_tmp63_ = current_path;
						g_string_assign (_tmp62_, _tmp63_);
						_tmp64_ = paths;
						_tmp64__length1 = paths_length1;
						if (_tmp64__length1 > 1) {
							GString* _tmp65_;
							GString* _tmp66_;
							gchar** _tmp67_;
							gint _tmp67__length1;
							const gchar* _tmp68_;
							_tmp65_ = sb;
							g_string_append (_tmp65_, G_DIR_SEPARATOR_S);
							_tmp66_ = sb;
							_tmp67_ = paths;
							_tmp67__length1 = paths_length1;
							_tmp68_ = _tmp67_[1];
							g_string_append (_tmp66_, _tmp68_);
						}
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						GString* _tmp69_;
						const gchar* _tmp70_;
						GString* _tmp71_;
						GString* _tmp72_;
						gchar** _tmp73_;
						gint _tmp73__length1;
						const gchar* _tmp74_;
						gchar** _tmp75_;
						gint _tmp75__length1;
						_tmp69_ = sb;
						_tmp70_ = current_path;
						g_string_assign (_tmp69_, _tmp70_);
						_tmp71_ = sb;
						g_string_append (_tmp71_, G_DIR_SEPARATOR_S);
						_tmp72_ = sb;
						_tmp73_ = paths;
						_tmp73__length1 = paths_length1;
						_tmp74_ = _tmp73_[0];
						g_string_append (_tmp72_, _tmp74_);
						_tmp75_ = paths;
						_tmp75__length1 = paths_length1;
						if (_tmp75__length1 > 1) {
							GString* _tmp76_;
							GString* _tmp77_;
							gchar** _tmp78_;
							gint _tmp78__length1;
							const gchar* _tmp79_;
							_tmp76_ = sb;
							g_string_append (_tmp76_, G_DIR_SEPARATOR_S);
							_tmp77_ = sb;
							_tmp78_ = paths;
							_tmp78__length1 = paths_length1;
							_tmp79_ = _tmp78_[1];
							g_string_append (_tmp77_, _tmp79_);
						}
						break;
					}
				}
			}
			paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	_tmp80_ = path;
	_tmp81_ = strlen (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ > 0) {
		gboolean _tmp83_ = FALSE;
		gboolean _tmp84_ = FALSE;
		const gchar* _tmp85_;
		_tmp85_ = scheme;
		if (g_strcmp0 (_tmp85_, "") == 0) {
			_tmp84_ = TRUE;
		} else {
			const gchar* _tmp86_;
			_tmp86_ = scheme;
			_tmp84_ = g_strcmp0 (_tmp86_, FILES_ROOT_FS_URI) == 0;
		}
		if (_tmp84_) {
			gboolean _tmp87_ = FALSE;
			gboolean _tmp88_ = FALSE;
			const gchar* _tmp89_;
			_tmp89_ = path;
			if (g_str_has_prefix (_tmp89_, "~/")) {
				_tmp88_ = TRUE;
			} else {
				const gchar* _tmp90_;
				_tmp90_ = path;
				_tmp88_ = g_str_has_prefix (_tmp90_, "/~");
			}
			if (_tmp88_) {
				_tmp87_ = TRUE;
			} else {
				const gchar* _tmp91_;
				_tmp91_ = path;
				_tmp87_ = g_strcmp0 (_tmp91_, "~") == 0;
			}
			_tmp83_ = _tmp87_;
		} else {
			_tmp83_ = FALSE;
		}
		if (_tmp83_) {
			const gchar* _tmp92_;
			GString* _tmp94_;
			GString* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			_tmp92_ = path;
			if (g_str_has_prefix (_tmp92_, "/")) {
				GString* _tmp93_;
				_tmp93_ = sb;
				g_string_erase (_tmp93_, (gssize) 0, (gssize) 1);
			}
			_tmp94_ = sb;
			g_string_erase (_tmp94_, (gssize) 0, (gssize) 1);
			_tmp95_ = sb;
			_tmp96_ = pf_user_utils_get_real_user_home ();
			_tmp97_ = _tmp96_;
			g_string_prepend (_tmp95_, _tmp97_);
			_g_free0 (_tmp97_);
		}
	}
	_tmp98_ = sb;
	_tmp99_ = _tmp98_->str;
	_tmp100_ = g_strdup (_tmp99_);
	_g_free0 (path);
	path = _tmp100_;
	{
		gboolean _tmp101_ = FALSE;
		_tmp101_ = TRUE;
		while (TRUE) {
			const gchar* _tmp103_;
			gchar* _tmp104_;
			if (!_tmp101_) {
				const gchar* _tmp102_;
				_tmp102_ = path;
				if (!string_contains (_tmp102_, "//")) {
					break;
				}
			}
			_tmp101_ = FALSE;
			_tmp103_ = path;
			_tmp104_ = string_replace (_tmp103_, "//", "/");
			_g_free0 (path);
			path = _tmp104_;
		}
	}
	_tmp105_ = scheme;
	_tmp106_ = path;
	_tmp107_ = g_strconcat (_tmp105_, _tmp106_, NULL);
	_tmp108_ = _tmp107_;
	_tmp109_ = string_replace (_tmp108_, "////", "///");
	_tmp110_ = _tmp109_;
	_g_free0 (_tmp108_);
	new_path = _tmp110_;
	_tmp111_ = new_path;
	_tmp112_ = strlen (_tmp111_);
	_tmp113_ = _tmp112_;
	if (_tmp113_ > 0) {
		gboolean _tmp114_ = FALSE;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		const gchar* _tmp117_;
		const gchar* _tmp123_;
		gchar* _tmp124_;
		gboolean _tmp125_ = FALSE;
		const gchar* _tmp126_;
		_tmp117_ = scheme;
		if (!g_str_has_prefix (_tmp117_, FILES_ROOT_FS_URI)) {
			const gchar* _tmp118_;
			_tmp118_ = scheme;
			_tmp116_ = !g_str_has_prefix (_tmp118_, FILES_TRASH_URI);
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			const gchar* _tmp119_;
			_tmp119_ = scheme;
			_tmp115_ = !g_str_has_prefix (_tmp119_, FILES_RECENT_URI);
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			const gchar* _tmp120_;
			_tmp120_ = scheme;
			_tmp114_ = !g_str_has_prefix (_tmp120_, FILES_ADMIN_URI);
		} else {
			_tmp114_ = FALSE;
		}
		if (_tmp114_) {
			const gchar* _tmp121_;
			gchar* _tmp122_;
			_tmp121_ = new_path;
			_tmp122_ = string_replace (_tmp121_, "///", "//");
			_g_free0 (new_path);
			new_path = _tmp122_;
		}
		_tmp123_ = new_path;
		_tmp124_ = string_replace (_tmp123_, "ssh:", "sftp:");
		_g_free0 (new_path);
		new_path = _tmp124_;
		_tmp126_ = path;
		if (g_strcmp0 (_tmp126_, "/") == 0) {
			const gchar* _tmp127_;
			_tmp127_ = scheme;
			_tmp125_ = !files_file_utils_can_browse_scheme (_tmp127_);
		} else {
			_tmp125_ = FALSE;
		}
		if (_tmp125_) {
			gchar* _tmp128_;
			_tmp128_ = g_strdup ("");
			_g_free0 (new_path);
			new_path = _tmp128_;
		}
	}
	if (!include_file_protocol) {
		const gchar* _tmp130_;
		_tmp130_ = new_path;
		_tmp129_ = g_str_has_prefix (_tmp130_, FILES_ROOT_FS_URI);
	} else {
		_tmp129_ = FALSE;
	}
	if (_tmp129_) {
		const gchar* _tmp131_;
		gint _tmp132_;
		gint _tmp133_;
		const gchar* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gchar* _tmp137_;
		_tmp131_ = new_path;
		_tmp132_ = strlen (FILES_ROOT_FS_URI);
		_tmp133_ = _tmp132_;
		_tmp134_ = new_path;
		_tmp135_ = strlen (_tmp134_);
		_tmp136_ = _tmp135_;
		_tmp137_ = string_slice (_tmp131_, (glong) _tmp133_, (glong) _tmp136_);
		_g_free0 (new_path);
		new_path = _tmp137_;
	}
	_tmp138_ = scheme;
	if (g_str_has_prefix (_tmp138_, "afc")) {
		gchar** colon_parts = NULL;
		const gchar* _tmp139_;
		gchar** _tmp140_;
		gchar** _tmp141_;
		gint colon_parts_length1;
		gint _colon_parts_size_;
		gchar** _tmp142_;
		gint _tmp142__length1;
		_tmp139_ = new_path;
		_tmp141_ = _tmp140_ = g_strsplit (_tmp139_, ":", 3);
		colon_parts = _tmp141_;
		colon_parts_length1 = _vala_array_length (_tmp140_);
		_colon_parts_size_ = colon_parts_length1;
		_tmp142_ = colon_parts;
		_tmp142__length1 = colon_parts_length1;
		if (_tmp142__length1 > 2) {
			gchar** separator_parts = NULL;
			gchar** _tmp143_;
			gint _tmp143__length1;
			const gchar* _tmp144_;
			gchar** _tmp145_;
			gchar** _tmp146_;
			gint separator_parts_length1;
			gint _separator_parts_size_;
			gchar* device_name_end = NULL;
			gchar** _tmp147_;
			gint _tmp147__length1;
			const gchar* _tmp148_;
			gchar* _tmp149_;
			const gchar* _tmp150_;
			_tmp143_ = colon_parts;
			_tmp143__length1 = colon_parts_length1;
			_tmp144_ = _tmp143_[2];
			_tmp146_ = _tmp145_ = g_strsplit (_tmp144_, G_DIR_SEPARATOR_S, 2);
			separator_parts = _tmp146_;
			separator_parts_length1 = _vala_array_length (_tmp145_);
			_separator_parts_size_ = separator_parts_length1;
			_tmp147_ = separator_parts;
			_tmp147__length1 = separator_parts_length1;
			_tmp148_ = _tmp147_[0];
			_tmp149_ = g_strdup (_tmp148_);
			device_name_end = _tmp149_;
			_tmp150_ = device_name_end;
			if (uint64_try_parse (_tmp150_, NULL, NULL, (guint) 0)) {
				gchar** _tmp151_;
				gint _tmp151__length1;
				const gchar* _tmp152_;
				gchar** _tmp153_;
				gint _tmp153__length1;
				const gchar* _tmp154_;
				gchar* _tmp155_;
				gchar** _tmp156_;
				gint _tmp156__length1;
				_tmp151_ = colon_parts;
				_tmp151__length1 = colon_parts_length1;
				_tmp152_ = _tmp151_[0];
				_tmp153_ = colon_parts;
				_tmp153__length1 = colon_parts_length1;
				_tmp154_ = _tmp153_[1];
				_tmp155_ = g_strjoin (":", _tmp152_, _tmp154_, NULL);
				_g_free0 (new_path);
				new_path = _tmp155_;
				_tmp156_ = separator_parts;
				_tmp156__length1 = separator_parts_length1;
				if (_tmp156__length1 > 1) {
					const gchar* _tmp157_;
					gchar** _tmp158_;
					gint _tmp158__length1;
					const gchar* _tmp159_;
					gchar* _tmp160_;
					_tmp157_ = new_path;
					_tmp158_ = separator_parts;
					_tmp158__length1 = separator_parts_length1;
					_tmp159_ = _tmp158_[1];
					_tmp160_ = g_strjoin (G_DIR_SEPARATOR_S, _tmp157_, _tmp159_, NULL);
					_g_free0 (new_path);
					new_path = _tmp160_;
				}
			}
			_g_free0 (device_name_end);
			separator_parts = (_vala_array_free (separator_parts, separator_parts_length1, (GDestroyNotify) g_free), NULL);
		}
		colon_parts = (_vala_array_free (colon_parts, colon_parts_length1, (GDestroyNotify) g_free), NULL);
	}
	result = new_path;
	_g_string_free0 (sb);
	_g_free0 (unescaped_uri);
	_g_free0 (current_scheme);
	_g_free0 (current_path);
	_g_free0 (scheme);
	_g_free0 (path);
	_g_free0 (unsanitized_current_uri);
	_g_free0 (unsanitized_uri);
	return result;
}

/** Splits the path into a protocol ending in '://"  and a path beginning "/". **/
void
files_file_utils_split_protocol_from_path (const gchar* path,
                                           gchar** protocol,
                                           gchar** new_path)
{
	gchar* _vala_protocol = NULL;
	gchar* _vala_new_path = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** explode_protocol = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint explode_protocol_length1;
	gint _explode_protocol_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp52_;
	gboolean _tmp54_ = FALSE;
	const gchar* _tmp55_;
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_protocol);
	_vala_protocol = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_vala_new_path);
	_vala_new_path = _tmp1_;
	_tmp2_ = _vala_new_path;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "://", 0);
	explode_protocol = _tmp4_;
	explode_protocol_length1 = _vala_array_length (_tmp3_);
	_explode_protocol_size_ = explode_protocol_length1;
	_tmp5_ = explode_protocol;
	_tmp5__length1 = explode_protocol_length1;
	if (_tmp5__length1 > 2) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		_g_free0 (_vala_new_path);
		_vala_new_path = _tmp6_;
		explode_protocol = (_vala_array_free (explode_protocol, explode_protocol_length1, (GDestroyNotify) g_free), NULL);
		if (protocol) {
			*protocol = _vala_protocol;
		} else {
			_g_free0 (_vala_protocol);
		}
		if (new_path) {
			*new_path = _vala_new_path;
		} else {
			_g_free0 (_vala_new_path);
		}
		return;
	}
	_tmp7_ = explode_protocol;
	_tmp7__length1 = explode_protocol_length1;
	if (_tmp7__length1 > 1) {
		gboolean _tmp8_ = FALSE;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp9_ = explode_protocol;
		_tmp9__length1 = explode_protocol_length1;
		_tmp10_ = _tmp9_[0];
		if (g_strcmp0 (_tmp10_, "mtp") == 0) {
			_tmp8_ = TRUE;
		} else {
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			_tmp11_ = explode_protocol;
			_tmp11__length1 = explode_protocol_length1;
			_tmp12_ = _tmp11_[0];
			_tmp8_ = g_strcmp0 (_tmp12_, "gphoto2") == 0;
		}
		if (_tmp8_) {
			gchar** explode_path = NULL;
			gchar** _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_;
			gchar** _tmp15_;
			gchar** _tmp16_;
			gint explode_path_length1;
			gint _explode_path_size_;
			gboolean _tmp17_ = FALSE;
			gchar** _tmp18_;
			gint _tmp18__length1;
			const gchar* _tmp19_;
			_tmp13_ = explode_protocol;
			_tmp13__length1 = explode_protocol_length1;
			_tmp14_ = _tmp13_[1];
			_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "]", 2);
			explode_path = _tmp16_;
			explode_path_length1 = _vala_array_length (_tmp15_);
			_explode_path_size_ = explode_path_length1;
			_tmp18_ = explode_path;
			_tmp18__length1 = explode_path_length1;
			_tmp19_ = _tmp18_[0];
			if (_tmp19_ != NULL) {
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				_tmp20_ = explode_path;
				_tmp20__length1 = explode_path_length1;
				_tmp21_ = _tmp20_[0];
				_tmp17_ = g_str_has_prefix (_tmp21_, "[");
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_ = NULL;
				gchar** _tmp34_;
				gint _tmp34__length1;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp22_ = explode_protocol;
				_tmp22__length1 = explode_protocol_length1;
				_tmp23_ = _tmp22_[0];
				_tmp24_ = g_strconcat (_tmp23_, "://", NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = explode_path;
				_tmp26__length1 = explode_path_length1;
				_tmp27_ = _tmp26_[0];
				_tmp28_ = g_strconcat (_tmp25_, _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strconcat (_tmp29_, "]", NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = string_replace (_tmp31_, "///", "//");
				_g_free0 (_vala_protocol);
				_vala_protocol = _tmp32_;
				_g_free0 (_tmp31_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp25_);
				_tmp34_ = explode_path;
				_tmp34__length1 = explode_path_length1;
				_tmp35_ = _tmp34_[1];
				_tmp33_ = _tmp35_;
				if (_tmp33_ == NULL) {
					_tmp33_ = "";
				}
				_tmp36_ = g_strdup (_tmp33_);
				_g_free0 (_vala_new_path);
				_vala_new_path = _tmp36_;
			} else {
				gchar** _tmp37_;
				gint _tmp37__length1;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				const gchar* _tmp40_ = NULL;
				gchar** _tmp41_;
				gint _tmp41__length1;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp37_ = explode_protocol;
				_tmp37__length1 = explode_protocol_length1;
				_tmp38_ = _tmp37_[0];
				_tmp39_ = g_strconcat (_tmp38_, "://", NULL);
				_g_free0 (_vala_protocol);
				_vala_protocol = _tmp39_;
				_tmp41_ = explode_protocol;
				_tmp41__length1 = explode_protocol_length1;
				_tmp42_ = _tmp41_[1];
				_tmp40_ = _tmp42_;
				if (_tmp40_ == NULL) {
					_tmp40_ = "";
				}
				_tmp43_ = g_strdup (_tmp40_);
				_g_free0 (_vala_new_path);
				_vala_new_path = _tmp43_;
			}
			explode_path = (_vala_array_free (explode_path, explode_path_length1, (GDestroyNotify) g_free), NULL);
		} else {
			gchar** _tmp44_;
			gint _tmp44__length1;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			const gchar* _tmp47_ = NULL;
			gchar** _tmp48_;
			gint _tmp48__length1;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp44_ = explode_protocol;
			_tmp44__length1 = explode_protocol_length1;
			_tmp45_ = _tmp44_[0];
			_tmp46_ = g_strconcat (_tmp45_, "://", NULL);
			_g_free0 (_vala_protocol);
			_vala_protocol = _tmp46_;
			_tmp48_ = explode_protocol;
			_tmp48__length1 = explode_protocol_length1;
			_tmp49_ = _tmp48_[1];
			_tmp47_ = _tmp49_;
			if (_tmp47_ == NULL) {
				_tmp47_ = "";
			}
			_tmp50_ = g_strdup (_tmp47_);
			_g_free0 (_vala_new_path);
			_vala_new_path = _tmp50_;
		}
	} else {
		gchar* _tmp51_;
		_tmp51_ = g_strdup (FILES_ROOT_FS_URI);
		_g_free0 (_vala_protocol);
		_vala_protocol = _tmp51_;
	}
	_tmp52_ = _vala_protocol;
	if (g_str_has_prefix (FILES_ROOT_FS_URI, _tmp52_)) {
		gchar* _tmp53_;
		_tmp53_ = g_strdup (FILES_ROOT_FS_URI);
		_g_free0 (_vala_protocol);
		_vala_protocol = _tmp53_;
	}
	_tmp55_ = _vala_new_path;
	if (g_str_has_suffix (_tmp55_, G_DIR_SEPARATOR_S)) {
		_tmp54_ = g_strcmp0 (path, G_DIR_SEPARATOR_S) != 0;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gchar* _tmp60_;
		_tmp56_ = _vala_new_path;
		_tmp57_ = _vala_new_path;
		_tmp58_ = strlen (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = string_slice (_tmp56_, (glong) 0, (glong) (_tmp59_ - 1));
		_g_free0 (_vala_new_path);
		_vala_new_path = _tmp60_;
	}
	explode_protocol = (_vala_array_free (explode_protocol, explode_protocol_length1, (GDestroyNotify) g_free), NULL);
	if (protocol) {
		*protocol = _vala_protocol;
	} else {
		_g_free0 (_vala_protocol);
	}
	if (new_path) {
		*new_path = _vala_new_path;
	} else {
		_g_free0 (_vala_new_path);
	}
}

gchar*
files_file_utils_get_smb_share_from_uri (const gchar* uri)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar** uri_parts = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint uri_parts_length1;
	gint _uri_parts_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_uri_parse_scheme (uri);
	_tmp1_ = _tmp0_;
	_tmp2_ = !(g_strcmp0 (_tmp1_, "smb") == 0);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (uri);
		result = _tmp3_;
		return result;
	}
	_tmp5_ = _tmp4_ = g_strsplit (uri, G_DIR_SEPARATOR_S, 0);
	uri_parts = _tmp5_;
	uri_parts_length1 = _vala_array_length (_tmp4_);
	_uri_parts_size_ = uri_parts_length1;
	_tmp6_ = uri_parts;
	_tmp6__length1 = uri_parts_length1;
	if (_tmp6__length1 < 4) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (uri);
		result = _tmp7_;
		uri_parts = (_vala_array_free (uri_parts, uri_parts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		GString* sb = NULL;
		GString* _tmp8_;
		GString* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp8_ = g_string_new ("");
		sb = _tmp8_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					GString* _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp9_ = FALSE;
					if (!(i < 4)) {
						break;
					}
					_tmp11_ = sb;
					_tmp12_ = uri_parts;
					_tmp12__length1 = uri_parts_length1;
					_tmp13_ = _tmp12_[i];
					_tmp14_ = g_strconcat (_tmp13_, G_DIR_SEPARATOR_S, NULL);
					_tmp15_ = _tmp14_;
					g_string_append (_tmp11_, _tmp15_);
					_g_free0 (_tmp15_);
				}
			}
		}
		_tmp16_ = sb;
		_tmp17_ = _tmp16_->str;
		_tmp18_ = g_strdup (_tmp17_);
		result = _tmp18_;
		_g_string_free0 (sb);
		uri_parts = (_vala_array_free (uri_parts, uri_parts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
}

gchar*
files_file_utils_strip_extension (const gchar* filename)
{
	gchar** parts = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint parts_length1;
	gint _parts_size_;
	gint n_parts = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp30_;
	gchar* result;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = g_utf8_strreverse (filename, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 3);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	parts = _tmp4_;
	parts_length1 = _tmp4__length1;
	_parts_size_ = parts_length1;
	_tmp5_ = parts;
	_tmp5__length1 = parts_length1;
	n_parts = _tmp5__length1;
	switch (n_parts) {
		case 1:
		{
			break;
		}
		case 2:
		{
			gchar** _tmp6_;
			gint _tmp6__length1;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = parts;
			_tmp6__length1 = parts_length1;
			_tmp7_ = _tmp6_[1];
			_tmp8_ = g_utf8_strreverse (_tmp7_, (gssize) -1);
			result = _tmp8_;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		case 3:
		{
			gboolean _tmp9_ = FALSE;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gboolean _tmp14_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp10_ = g_utf8_strreverse (FILES_FILE_UTILS_COMPRESSION_EXTENSIONS, (gssize) -1);
			_tmp11_ = _tmp10_;
			_tmp12_ = parts;
			_tmp12__length1 = parts_length1;
			_tmp13_ = _tmp12_[0];
			_tmp14_ = string_contains (_tmp11_, _tmp13_);
			_g_free0 (_tmp11_);
			if (_tmp14_) {
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				_tmp15_ = g_utf8_strreverse (FILES_FILE_UTILS_ARCHIVE_EXTENSIONS, (gssize) -1);
				_tmp16_ = _tmp15_;
				_tmp17_ = parts;
				_tmp17__length1 = parts_length1;
				_tmp18_ = _tmp17_[1];
				_tmp9_ = string_contains (_tmp16_, _tmp18_);
				_g_free0 (_tmp16_);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp19_ = parts;
				_tmp19__length1 = parts_length1;
				_tmp20_ = _tmp19_[2];
				_tmp21_ = g_utf8_strreverse (_tmp20_, (gssize) -1);
				result = _tmp21_;
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
			_tmp22_ = parts;
			_tmp22__length1 = parts_length1;
			_tmp23_ = _tmp22_[1];
			_tmp24_ = parts;
			_tmp24__length1 = parts_length1;
			_tmp25_ = _tmp24_[2];
			_tmp26_ = g_strjoin (".", _tmp23_, _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_utf8_strreverse (_tmp27_, (gssize) -1);
			_tmp29_ = _tmp28_;
			_g_free0 (_tmp27_);
			result = _tmp29_;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp30_ = g_strdup (filename);
	result = _tmp30_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
files_file_utils_get_rename_region (const gchar* filename,
                                    gint* start_offset,
                                    gint* end_offset,
                                    gboolean select_all)
{
	gint _vala_start_offset = 0;
	gint _vala_end_offset = 0;
	g_return_if_fail (filename != NULL);
	_vala_start_offset = 0;
	if (select_all) {
		_vala_end_offset = -1;
	} else {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = files_file_utils_strip_extension (filename);
		_tmp1_ = _tmp0_;
		_vala_end_offset = g_utf8_strlen (_tmp1_, (gssize) -1);
		_g_free0 (_tmp1_);
	}
	if (start_offset) {
		*start_offset = _vala_start_offset;
	}
	if (end_offset) {
		*end_offset = _vala_end_offset;
	}
}

gchar*
files_file_utils_custom_basename_from_file (GFile* location)
{
	FilesFile* gof = NULL;
	FilesFile* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = files_file_get (location);
	gof = _tmp0_;
	_tmp1_ = files_file_get_display_name (gof);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	_g_object_unref0 (gof);
	return result;
}

static void
files_file_utils_set_file_display_name_data_free (gpointer _data)
{
	FilesFileUtilsSetFileDisplayNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->old_location);
	_g_free0 (_data_->new_name);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (FilesFileUtilsSetFileDisplayNameData, _data_);
}

void
files_file_utils_set_file_display_name (GFile* old_location,
                                        const gchar* new_name,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	FilesFileUtilsSetFileDisplayNameData* _data_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (old_location != NULL);
	g_return_if_fail (new_name != NULL);
	_data_ = g_slice_new0 (FilesFileUtilsSetFileDisplayNameData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_file_utils_set_file_display_name_data_free);
	_tmp0_ = _g_object_ref0 (old_location);
	_g_object_unref0 (_data_->old_location);
	_data_->old_location = _tmp0_;
	_tmp1_ = g_strdup (new_name);
	_g_free0 (_data_->new_name);
	_data_->new_name = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	files_file_utils_set_file_display_name_co (_data_);
}

GFile*
files_file_utils_set_file_display_name_finish (GAsyncResult* _res_,
                                               GError** error)
{
	GFile* result;
	FilesFileUtilsSetFileDisplayNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
files_file_utils_set_file_display_name_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	FilesFileUtilsSetFileDisplayNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_file_utils_set_file_display_name_co (_data_);
}

static gboolean
files_file_utils_set_file_display_name_co (FilesFileUtilsSetFileDisplayNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_get_basename (_data_->old_location);
	_data_->original_name = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->original_name;
	if (g_strcmp0 (_data_->_tmp1_, _data_->new_name) == 0) {
		_data_->result = NULL;
		_g_free0 (_data_->original_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->new_location = NULL;
	_data_->_tmp2_ = files_directory_cache_lookup_parent (_data_->old_location);
	_data_->dir = _data_->_tmp2_;
	{
		_data_->_state_ = 1;
		g_file_set_display_name_async (_data_->old_location, _data_->new_name, G_PRIORITY_DEFAULT, _data_->cancellable, files_file_utils_set_file_display_name_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = g_file_set_display_name_finish (_data_->old_location, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_g_object_unref0 (_data_->new_location);
		_data_->new_location = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->dir;
		if (_data_->_tmp6_ != NULL) {
			_data_->added_files = NULL;
			_data_->_tmp7_ = _data_->new_location;
			_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
			_data_->added_files = g_list_append (_data_->added_files, _data_->_tmp8_);
			_data_->removed_files = NULL;
			_data_->_tmp9_ = _g_object_ref0 (_data_->old_location);
			_data_->removed_files = g_list_append (_data_->removed_files, _data_->_tmp9_);
			_data_->_tmp10_ = _data_->removed_files;
			files_directory_notify_files_removed (_data_->_tmp10_);
			_data_->_tmp11_ = _data_->added_files;
			files_directory_notify_files_added_internally (_data_->_tmp11_);
			(_data_->removed_files == NULL) ? NULL : (_data_->removed_files = (_g_list_free__g_object_unref0_ (_data_->removed_files), NULL));
			(_data_->added_files == NULL) ? NULL : (_data_->added_files = (_g_list_free__g_object_unref0_ (_data_->added_files), NULL));
		} else {
			g_warning ("FileUtils.vala:567: Renamed file has no Files.Directory.Async");
		}
		_data_->_tmp12_ = files_undo_manager_instance ();
		_data_->_tmp13_ = _data_->new_location;
		_data_->_tmp14_ = _data_->original_name;
		files_undo_manager_add_rename_action (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp14_);
		_g_object_unref0 (_data_->_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_warning ("FileUtils.vala:572: Rename error");
		_data_->_tmp15_ = g_strdup_printf (_ ("Could not rename to '%s'"), _data_->new_name);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		_data_->_tmp19_ = pf_dialogs_show_error_dialog (_data_->_tmp16_, _data_->_tmp18_, NULL);
		_data_->_tmp20_ = _data_->_tmp19_;
		_g_object_unref0 (_data_->_tmp20_);
		_g_free0 (_data_->_tmp16_);
		_data_->_tmp21_ = _data_->dir;
		if (_data_->_tmp21_ != NULL) {
			_data_->_tmp22_ = _data_->dir;
			g_signal_emit_by_name (_data_->_tmp22_, "file-added", NULL, TRUE);
		}
		_data_->_tmp23_ = _data_->e;
		_data_->_tmp24_ = _g_error_copy0 (_data_->_tmp23_);
		_data_->_inner_error0_ = _data_->_tmp24_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->dir);
		_g_object_unref0 (_data_->new_location);
		_g_free0 (_data_->original_name);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->new_location;
	_g_object_unref0 (_data_->dir);
	_g_free0 (_data_->original_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
files_file_utils_get_formatted_time_attribute_from_info (GFileInfo* info,
                                                         const gchar* attr)
{
	GDateTime* dt = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	GDateTime* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	dt = NULL;
	_tmp0_ = attr;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (G_FILE_ATTRIBUTE_TIME_MODIFIED)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (G_FILE_ATTRIBUTE_TIME_CREATED))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (G_FILE_ATTRIBUTE_TIME_ACCESS))))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string (G_FILE_ATTRIBUTE_TIME_CHANGED))))) {
		switch (0) {
			default:
			{
				guint64 t = 0ULL;
				t = g_file_info_get_attribute_uint64 (info, attr);
				if (t > ((guint64) 0)) {
					GDateTime* _tmp3_;
					_tmp3_ = g_date_time_new_from_unix_local ((gint64) t);
					_g_date_time_unref0 (dt);
					dt = _tmp3_;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string (G_FILE_ATTRIBUTE_TRASH_DELETION_DATE)))) {
		switch (0) {
			default:
			{
				gchar* deletion_date = NULL;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp4_ = g_file_info_get_attribute_string (info, attr);
				_tmp5_ = g_strdup (_tmp4_);
				deletion_date = _tmp5_;
				_tmp6_ = deletion_date;
				if (_tmp6_ != NULL) {
					const gchar* _tmp7_;
					GTimeZone* _tmp8_;
					GTimeZone* _tmp9_;
					GDateTime* _tmp10_;
					GDateTime* _tmp11_;
					_tmp7_ = deletion_date;
					_tmp8_ = g_time_zone_new_local ();
					_tmp9_ = _tmp8_;
					_tmp10_ = g_date_time_new_from_iso8601 (_tmp7_, _tmp9_);
					_g_date_time_unref0 (dt);
					dt = _tmp10_;
					_g_time_zone_unref0 (_tmp9_);
					_tmp11_ = dt;
					if (_tmp11_ == NULL) {
						const gchar* _tmp12_;
						_tmp12_ = deletion_date;
						g_critical ("FileUtils.vala:608: TRASH_DELETION_DATE: %s is not a valid ISO8601 dat" \
"etime", _tmp12_);
					}
				}
				_g_free0 (deletion_date);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp13_ = dt;
	_tmp14_ = files_file_utils_get_formatted_date_time (_tmp13_);
	result = _tmp14_;
	_g_date_time_unref0 (dt);
	return result;
}

gchar*
files_file_utils_get_formatted_date_time (GDateTime* dt)
{
	FilesPreferences* _tmp1_;
	FilesPreferences* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GQuark _tmp9_ = 0U;
	static GQuark _tmp8_label0 = 0;
	static GQuark _tmp8_label1 = 0;
	gchar* result;
	if (dt == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = files_preferences_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = files_preferences_get_date_format (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	_tmp7_ = _tmp6_;
	_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
	g_free (_tmp7_);
	if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("locale")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_date_time_format (dt, "%c");
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("iso")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				_tmp11_ = g_date_time_format (dt, "%Y-%m-%d %H:%M:%S");
				result = _tmp11_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp12_;
				_tmp12_ = files_file_utils_get_informal_date_time (dt);
				result = _tmp12_;
				return result;
			}
		}
	}
}

gchar*
files_file_utils_get_informal_date_time (GDateTime* dt)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gint now_year = 0;
	GDateTime* _tmp1_;
	gint disp_year = 0;
	gchar* default_date_format = NULL;
	gchar* _tmp2_;
	gint now_day = 0;
	GDateTime* _tmp5_;
	gint disp_day = 0;
	gint now_weekday = 0;
	GDateTime* _tmp8_;
	gint disp_weekday = 0;
	gboolean clock_is_24h = FALSE;
	FilesPreferences* _tmp9_;
	FilesPreferences* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	gchar* format_string = NULL;
	gchar* _tmp14_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* result;
	g_return_val_if_fail (dt != NULL, NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = now;
	now_year = g_date_time_get_year (_tmp1_);
	disp_year = g_date_time_get_year (dt);
	_tmp2_ = granite_date_time_get_default_date_format (FALSE, TRUE, TRUE);
	default_date_format = _tmp2_;
	if (disp_year < now_year) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = default_date_format;
		_tmp4_ = g_date_time_format (dt, _tmp3_);
		result = _tmp4_;
		_g_free0 (default_date_format);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp5_ = now;
	now_day = g_date_time_get_day_of_year (_tmp5_);
	disp_day = g_date_time_get_day_of_year (dt);
	if (disp_day < (now_day - 6)) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = default_date_format;
		_tmp7_ = g_date_time_format (dt, _tmp6_);
		result = _tmp7_;
		_g_free0 (default_date_format);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp8_ = now;
	now_weekday = g_date_time_get_day_of_week (_tmp8_);
	disp_weekday = g_date_time_get_day_of_week (dt);
	_tmp9_ = files_preferences_get_default ();
	_tmp10_ = _tmp9_;
	_tmp11_ = files_preferences_get_clock_format (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_str_has_prefix (_tmp12_, "24");
	_g_object_unref0 (_tmp10_);
	clock_is_24h = _tmp13_;
	_tmp14_ = g_strdup ("");
	format_string = _tmp14_;
	switch (now_weekday - disp_weekday) {
		case 0:
		{
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = granite_date_time_get_default_time_format (!clock_is_24h, FALSE);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf (_ ("Today at %s"), _tmp16_);
			_g_free0 (format_string);
			format_string = _tmp17_;
			_g_free0 (_tmp16_);
			break;
		}
		case 1:
		case -6:
		{
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp18_ = granite_date_time_get_default_time_format (!clock_is_24h, FALSE);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup_printf (_ ("Yesterday at %s"), _tmp19_);
			_g_free0 (format_string);
			format_string = _tmp20_;
			_g_free0 (_tmp19_);
			break;
		}
		default:
		{
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp21_ = granite_date_time_get_default_time_format (!clock_is_24h, FALSE);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup_printf (_ ("%%A at %s"), _tmp22_);
			_g_free0 (format_string);
			format_string = _tmp23_;
			_g_free0 (_tmp22_);
			break;
		}
	}
	_tmp24_ = format_string;
	_tmp25_ = g_date_time_format (dt, _tmp24_);
	result = _tmp25_;
	_g_free0 (format_string);
	_g_free0 (default_date_format);
	_g_date_time_unref0 (now);
	return result;
}

gboolean
files_file_utils_can_browse_scheme (const gchar* scheme)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	gboolean result;
	g_return_val_if_fail (scheme != NULL, FALSE);
	_tmp0_ = scheme;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((((((((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (FILES_AFP_URI)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (FILES_DAV_URI))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (FILES_DAVS_URI))))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string (FILES_SFTP_URI))))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string (FILES_FTP_URI))))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string (FILES_MTP_URI))))) || (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string (FILES_AFC_URI))))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string (FILES_PTP_URI))))) {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = TRUE;
				return result;
			}
		}
	}
}

guint16
files_file_utils_get_default_port_for_protocol (const gchar* protocol)
{
	gchar* ptcl = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	guint16 result;
	g_return_val_if_fail (protocol != NULL, 0U);
	_tmp0_ = g_utf8_strdown (protocol, (gssize) -1);
	ptcl = _tmp0_;
	_tmp1_ = ptcl;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("sftp")))) {
		switch (0) {
			default:
			{
				result = (guint16) 22;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("ftp")))) {
		switch (0) {
			default:
			{
				result = (guint16) 21;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("afp")))) {
		switch (0) {
			default:
			{
				result = (guint16) 548;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("dav")))) {
		switch (0) {
			default:
			{
				result = (guint16) 80;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("davs")))) {
		switch (0) {
			default:
			{
				result = (guint16) 443;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = (guint16) 0;
				_g_free0 (ptcl);
				return result;
			}
		}
	}
}

gboolean
files_file_utils_get_is_tls_for_protocol (const gchar* protocol)
{
	gchar* ptcl = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	static GQuark _tmp3_label6 = 0;
	gboolean result;
	g_return_val_if_fail (protocol != NULL, FALSE);
	_tmp0_ = g_utf8_strdown (protocol, (gssize) -1);
	ptcl = _tmp0_;
	_tmp1_ = ptcl;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("sftp")))) {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("ssh")))) {
		switch (0) {
			default:
			{
				result = TRUE;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("ftp")))) {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("afp")))) {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("afc")))) {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("dav")))) {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("davs")))) {
		switch (0) {
			default:
			{
				result = TRUE;
				_g_free0 (ptcl);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (ptcl);
				return result;
			}
		}
	}
}

gboolean
files_file_utils_location_is_in_trash (GFile* location)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	gchar* scheme = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = g_file_get_uri (location);
	uri = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_uri_parse_scheme (_tmp1_);
	scheme = _tmp2_;
	_tmp6_ = scheme;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = scheme;
		_tmp5_ = g_str_has_prefix (_tmp7_, "trash");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = uri;
		_tmp4_ = string_contains (_tmp8_, G_DIR_SEPARATOR_S ".Trash-");
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp10_ = uri;
		if (string_contains (_tmp10_, G_DIR_SEPARATOR_S ".local")) {
			const gchar* _tmp11_;
			_tmp11_ = uri;
			_tmp9_ = string_contains (_tmp11_, G_DIR_SEPARATOR_S "Trash" G_DIR_SEPARATOR_S);
		} else {
			_tmp9_ = FALSE;
		}
		_tmp3_ = _tmp9_;
	}
	result = _tmp3_;
	_g_free0 (scheme);
	_g_free0 (uri);
	return result;
}

gboolean
files_file_utils_same_file_system (GFile* a,
                                   GFile* b)
{
	GFileInfo* info_a = NULL;
	GFileInfo* info_b = NULL;
	gchar* filesystem_a = NULL;
	GFileInfo* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* filesystem_b = NULL;
	GFileInfo* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	{
		GFileInfo* _tmp0_ = NULL;
		GFileInfo* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		_tmp1_ = g_file_query_info (a, G_FILE_ATTRIBUTE_ID_FILESYSTEM, 0, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (info_a);
		info_a = _tmp2_;
		_tmp4_ = g_file_query_info (b, G_FILE_ATTRIBUTE_ID_FILESYSTEM, 0, NULL, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (info_b);
		info_b = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_object_unref0 (info_b);
		_g_object_unref0 (info_a);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		_g_object_unref0 (info_b);
		_g_object_unref0 (info_a);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	_tmp7_ = info_a;
	_tmp8_ = g_file_info_get_attribute_string (_tmp7_, G_FILE_ATTRIBUTE_ID_FILESYSTEM);
	_tmp9_ = g_strdup (_tmp8_);
	filesystem_a = _tmp9_;
	_tmp10_ = info_b;
	_tmp11_ = g_file_info_get_attribute_string (_tmp10_, G_FILE_ATTRIBUTE_ID_FILESYSTEM);
	_tmp12_ = g_strdup (_tmp11_);
	filesystem_b = _tmp12_;
	_tmp15_ = filesystem_a;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		_tmp16_ = filesystem_b;
		_tmp14_ = _tmp16_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = filesystem_a;
		_tmp18_ = filesystem_b;
		_tmp13_ = g_strcmp0 (_tmp17_, _tmp18_) == 0;
	} else {
		_tmp13_ = FALSE;
	}
	result = _tmp13_;
	_g_free0 (filesystem_b);
	_g_free0 (filesystem_a);
	_g_object_unref0 (info_b);
	_g_object_unref0 (info_a);
	return result;
}

gint
files_file_utils_compare_modification_dates (GFile* a,
                                             GFile* b)
{
	GFileInfo* info_a = NULL;
	GFileInfo* info_b = NULL;
	guint64 mod_a = 0ULL;
	GFileInfo* _tmp7_;
	guint64 mod_b = 0ULL;
	GFileInfo* _tmp8_;
	gint _tmp9_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	{
		GFileInfo* _tmp0_ = NULL;
		GFileInfo* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		_tmp1_ = g_file_query_info (a, G_FILE_ATTRIBUTE_TIME_MODIFIED, 0, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (info_a);
		info_a = _tmp2_;
		_tmp4_ = g_file_query_info (b, G_FILE_ATTRIBUTE_TIME_MODIFIED, 0, NULL, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (info_b);
		info_b = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = 0;
		_g_object_unref0 (info_b);
		_g_object_unref0 (info_a);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp6_ = -1;
		_g_object_unref0 (info_b);
		_g_object_unref0 (info_a);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	_tmp7_ = info_a;
	mod_a = g_file_info_get_attribute_uint64 (_tmp7_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	_tmp8_ = info_b;
	mod_b = g_file_info_get_attribute_uint64 (_tmp8_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	if (mod_a == mod_b) {
		_tmp9_ = 0;
	} else {
		gint _tmp10_ = 0;
		if (mod_a > mod_b) {
			_tmp10_ = 1;
		} else {
			_tmp10_ = -1;
		}
		_tmp9_ = _tmp10_;
	}
	result = _tmp9_;
	_g_object_unref0 (info_b);
	_g_object_unref0 (info_a);
	return result;
}

void
files_file_utils_remove_thumbnail_paths_for_uri (const gchar* uri)
{
	gchar* hash = NULL;
	gchar* _tmp0_;
	gchar* base_name = NULL;
	gchar* _tmp1_;
	gchar* cache_dir = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, uri, (gsize) -1);
	hash = _tmp0_;
	_tmp1_ = g_strdup_printf ("%s.png", hash);
	base_name = _tmp1_;
	_tmp2_ = g_get_user_cache_dir ();
	_tmp3_ = g_strdup (_tmp2_);
	cache_dir = _tmp3_;
	_tmp4_ = g_build_filename (cache_dir, "thumbnails", "normal", base_name, NULL);
	_tmp5_ = _tmp4_;
	g_unlink (_tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = g_build_filename (cache_dir, "thumbnails", "large", base_name, NULL);
	_tmp7_ = _tmp6_;
	g_unlink (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (cache_dir);
	_g_free0 (base_name);
	_g_free0 (hash);
}

gboolean
files_file_utils_same_location (const gchar* uri_a,
                                const gchar* uri_b)
{
	gchar* protocol_a = NULL;
	gchar* protocol_b = NULL;
	gchar* path_a = NULL;
	gchar* path_b = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean result;
	g_return_val_if_fail (uri_a != NULL, FALSE);
	g_return_val_if_fail (uri_b != NULL, FALSE);
	_tmp0_ = g_uri_unescape_string (uri_a, NULL);
	_tmp1_ = _tmp0_;
	files_file_utils_split_protocol_from_path (_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (protocol_a);
	protocol_a = _tmp2_;
	_g_free0 (path_a);
	path_a = _tmp3_;
	_g_free0 (_tmp1_);
	_tmp4_ = g_uri_unescape_string (uri_b, NULL);
	_tmp5_ = _tmp4_;
	files_file_utils_split_protocol_from_path (_tmp5_, &_tmp6_, &_tmp7_);
	_g_free0 (protocol_b);
	protocol_b = _tmp6_;
	_g_free0 (path_b);
	path_b = _tmp7_;
	_g_free0 (_tmp5_);
	_tmp9_ = protocol_a;
	_tmp10_ = protocol_b;
	if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = path_a;
		_tmp12_ = path_b;
		_tmp8_ = g_strcmp0 (_tmp11_, _tmp12_) == 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		result = TRUE;
		_g_free0 (path_b);
		_g_free0 (path_a);
		_g_free0 (protocol_b);
		_g_free0 (protocol_a);
		return result;
	}
	result = FALSE;
	_g_free0 (path_b);
	_g_free0 (path_a);
	_g_free0 (protocol_b);
	_g_free0 (protocol_a);
	return result;
}

guint64
files_file_utils_get_file_modification_time (GFile* file)
{
	guint64 _tmp3_ = 0ULL;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (file != NULL, 0ULL);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
		_g_object_unref0 (info);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("FileUtils.vala:819: %s", _tmp2_);
		result = (guint64) -1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp3_;
}

gchar*
files_file_utils_get_afp_target_uri (const gchar* standard_target_uri,
                                     const gchar* uri)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp24_;
	gchar* result;
	g_return_val_if_fail (standard_target_uri != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_uri_parse_scheme (uri);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "afp") == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* origin_host = NULL;
		gchar* origin_filename = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp5_ = files_file_utils_get_afp_user_server_and_filename (uri, &_tmp3_, &_tmp4_);
		_g_free0 (origin_filename);
		origin_filename = _tmp3_;
		_g_free0 (origin_host);
		origin_host = _tmp4_;
		if (_tmp5_) {
			gchar* target_host = NULL;
			gchar* target_filename = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gboolean _tmp8_;
			_tmp8_ = files_file_utils_get_afp_user_server_and_filename (standard_target_uri, &_tmp6_, &_tmp7_);
			_g_free0 (target_filename);
			target_filename = _tmp6_;
			_g_free0 (target_host);
			target_host = _tmp7_;
			if (_tmp8_) {
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp9_ = origin_host;
				_tmp10_ = target_filename;
				_tmp11_ = g_build_path (G_DIR_SEPARATOR_S, _tmp9_, _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat ("afp://", _tmp12_, NULL);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				result = _tmp14_;
				_g_free0 (target_filename);
				_g_free0 (target_host);
				_g_free0 (origin_filename);
				_g_free0 (origin_host);
				return result;
			}
			_g_free0 (target_filename);
			_g_free0 (target_host);
		}
		_g_free0 (origin_filename);
		_g_free0 (origin_host);
	} else {
		gchar* target_host = NULL;
		gchar* target_filename = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gboolean _tmp17_;
		_tmp17_ = files_file_utils_get_afp_user_server_and_filename (standard_target_uri, &_tmp15_, &_tmp16_);
		_g_free0 (target_filename);
		target_filename = _tmp15_;
		_g_free0 (target_host);
		target_host = _tmp16_;
		if (_tmp17_) {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp18_ = target_host;
			_tmp19_ = target_filename;
			_tmp20_ = g_build_path (G_DIR_SEPARATOR_S, _tmp18_, _tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strconcat ("afp://", _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp21_);
			result = _tmp23_;
			_g_free0 (target_filename);
			_g_free0 (target_host);
			return result;
		}
		_g_free0 (target_filename);
		_g_free0 (target_host);
	}
	_tmp24_ = g_strdup (standard_target_uri);
	result = _tmp24_;
	return result;
}

gboolean
files_file_utils_get_afp_user_server_and_filename (const gchar* uri,
                                                   gchar** filename,
                                                   gchar** user_server)
{
	gchar* _vala_filename = NULL;
	gchar* _vala_user_server = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** parts1 = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint parts1_length1;
	gint _parts1_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = g_strdup (uri);
	_g_free0 (_vala_filename);
	_vala_filename = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (_vala_user_server);
	_vala_user_server = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (uri, "://", 2);
	parts1 = _tmp3_;
	parts1_length1 = _vala_array_length (_tmp2_);
	_parts1_size_ = parts1_length1;
	_tmp4_ = parts1;
	_tmp4__length1 = parts1_length1;
	if (_tmp4__length1 == 2) {
		gchar** parts2 = NULL;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint parts2_length1;
		gint _parts2_size_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp5_ = parts1;
		_tmp5__length1 = parts1_length1;
		_tmp6_ = _tmp5_[1];
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, G_DIR_SEPARATOR_S, 2);
		parts2 = _tmp8_;
		parts2_length1 = _vala_array_length (_tmp7_);
		_parts2_size_ = parts2_length1;
		_tmp9_ = parts2;
		_tmp9__length1 = parts2_length1;
		if (_tmp9__length1 >= 1) {
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			_tmp10_ = parts2;
			_tmp10__length1 = parts2_length1;
			_tmp11_ = _tmp10_[0];
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (_vala_user_server);
			_vala_user_server = _tmp12_;
			_tmp13_ = parts2;
			_tmp13__length1 = parts2_length1;
			if (_tmp13__length1 == 2) {
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = parts2;
				_tmp14__length1 = parts2_length1;
				_tmp15_ = _tmp14_[1];
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_vala_filename);
				_vala_filename = _tmp16_;
			}
			result = TRUE;
			parts2 = (_vala_array_free (parts2, parts2_length1, (GDestroyNotify) g_free), NULL);
			parts1 = (_vala_array_free (parts1, parts1_length1, (GDestroyNotify) g_free), NULL);
			if (filename) {
				*filename = _vala_filename;
			} else {
				_g_free0 (_vala_filename);
			}
			if (user_server) {
				*user_server = _vala_user_server;
			} else {
				_g_free0 (_vala_user_server);
			}
			return result;
		}
		parts2 = (_vala_array_free (parts2, parts2_length1, (GDestroyNotify) g_free), NULL);
	}
	g_warning ("FileUtils.vala:864: Error getting afp user and server from %s: Invalid" \
" uri format", uri);
	result = FALSE;
	parts1 = (_vala_array_free (parts1, parts1_length1, (GDestroyNotify) g_free), NULL);
	if (filename) {
		*filename = _vala_filename;
	} else {
		_g_free0 (_vala_filename);
	}
	if (user_server) {
		*user_server = _vala_user_server;
	} else {
		_g_free0 (_vala_user_server);
	}
	return result;
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

gboolean
files_file_utils_make_file_name_valid_for_dest_fs (gchar** filename,
                                                   const gchar* dest_fs_type)
{
	gboolean _result_ = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	gboolean result;
	g_return_val_if_fail (*filename != NULL, FALSE);
	_result_ = FALSE;
	if (dest_fs_type == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = dest_fs_type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("fat")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("vfat"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("msdos"))))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("msdosfs"))))) {
		switch (0) {
			default:
			{
				static const char CHARS_TO_REPLACE[] = "/:;*?\\<> ";
				gchar replacement = '\0';
				gchar* original = NULL;
				gchar* _tmp3_;
				gchar* _tmp4_;
				const gchar* _tmp5_;
				replacement = '_';
				_tmp3_ = g_strdup (*filename);
				original = _tmp3_;
				_tmp4_ = string_delimit (*filename, CHARS_TO_REPLACE, replacement);
				_g_free0 (*filename);
				*filename = _tmp4_;
				_tmp5_ = original;
				_result_ = g_strcmp0 (_tmp5_, *filename) != 0;
				_g_free0 (original);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	result = _result_;
	return result;
}

gchar*
files_file_utils_format_time (gint seconds,
                              gint* time_unit)
{
	gint _vala_time_unit = 0;
	gint minutes = 0;
	gint hours = 0;
	gchar* _result_ = NULL;
	gchar* result;
	if (seconds < 0) {
		seconds = 0;
	}
	if (seconds < 60) {
		gchar* _tmp0_;
		_vala_time_unit = seconds;
		_tmp0_ = g_strdup_printf (ngettext ("%'d second", "%'d seconds", (gulong) seconds), seconds);
		_g_free0 (_result_);
		_result_ = _tmp0_;
	} else {
		if (seconds < 3600) {
			gchar* _tmp1_;
			minutes = seconds / 60;
			_vala_time_unit = minutes;
			_tmp1_ = g_strdup_printf (ngettext ("%'d minute", "%'d minutes", (gulong) minutes), minutes);
			_g_free0 (_result_);
			_result_ = _tmp1_;
		} else {
			hours = seconds / 3600;
			if (hours < 4) {
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				minutes = (seconds - (hours * 3600)) / 60;
				_vala_time_unit = minutes + hours;
				_tmp2_ = g_strdup_printf (ngettext ("%'d hour", "%'d hours", (gulong) hours), hours);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strdup_printf (ngettext ("%'d minute", "%'d minutes", (gulong) minutes), minutes);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strdup_printf (_ ("%s, %s"), _tmp3_, _tmp5_);
				_g_free0 (_result_);
				_result_ = _tmp6_;
				_g_free0 (_tmp5_);
				_g_free0 (_tmp3_);
			} else {
				gchar* _tmp7_;
				_vala_time_unit = hours;
				_tmp7_ = g_strdup_printf (ngettext ("approximately %'d hour", "approximately %'d hours", (gulong) hours), hours);
				_g_free0 (_result_);
				_result_ = _tmp7_;
			}
		}
	}
	result = _result_;
	if (time_unit) {
		*time_unit = _vala_time_unit;
	}
	return result;
}

gchar*
files_file_utils_get_duplicate_name (const gchar* name,
                                     gint count_increment,
                                     gint max_length,
                                     gboolean is_link)
{
	gchar* name_base = NULL;
	gchar* suffix = NULL;
	gchar* _result_ = NULL;
	gint count = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_vala_return_val_if_fail ((count_increment > 0) && (g_strcmp0 (name, "") != 0), "count_increment > 0 && name != \"\"", NULL);
	files_file_utils_parse_previous_duplicate_name (name, is_link, &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (name_base);
	name_base = _tmp0_;
	_g_free0 (suffix);
	suffix = _tmp1_;
	count = _tmp2_;
	if (is_link) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = name_base;
		_tmp4_ = files_file_utils_get_link_name (_tmp3_, count + count_increment, max_length);
		_g_free0 (_result_);
		_result_ = _tmp4_;
	} else {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = name_base;
		_tmp6_ = suffix;
		_tmp7_ = files_file_utils_get_copy_name (_tmp5_, _tmp6_, count + count_increment, max_length);
		_g_free0 (_result_);
		_result_ = _tmp7_;
	}
	result = _result_;
	_g_free0 (suffix);
	_g_free0 (name_base);
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

void
files_file_utils_parse_previous_duplicate_name (const gchar* name,
                                                gboolean is_link,
                                                gchar** name_base,
                                                gchar** suffix,
                                                gint* count)
{
	gchar* _vala_name_base = NULL;
	gchar* _vala_suffix = NULL;
	gint _vala_count = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* name_without_suffix = NULL;
	gchar* _tmp2_;
	gint last_index = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint index_of_suffix = 0;
	gint _tmp5_;
	gint _tmp6_;
	gint max_extension_length = 0;
	gboolean _tmp7_ = FALSE;
	gint index_of_opening = 0;
	const gchar* _tmp14_;
	gchar* reverse_base = NULL;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gint limit = 0;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gunichar chr = 0U;
	const gchar* _tmp26_;
	gint index = 0;
	gint multiplier = 0;
	gint n_digits = 0;
	gint expected_index = 0;
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (_vala_name_base);
	_vala_name_base = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (_vala_suffix);
	_vala_suffix = _tmp1_;
	_vala_count = 0;
	_tmp2_ = g_strdup (name);
	name_without_suffix = _tmp2_;
	_tmp3_ = strlen (name);
	_tmp4_ = _tmp3_;
	last_index = _tmp4_ - 1;
	_tmp5_ = strlen (name);
	_tmp6_ = _tmp5_;
	index_of_suffix = _tmp6_;
	if (is_link) {
		index_of_suffix = -1;
	} else {
		if (string_contains (name, ".")) {
			index_of_suffix = string_last_index_of (name, ".", 0);
		}
	}
	max_extension_length = 4;
	if (index_of_suffix >= (last_index - max_extension_length)) {
		_tmp7_ = index_of_suffix < last_index;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = strlen (name);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_slice (name, (glong) index_of_suffix, (glong) _tmp9_);
		_g_free0 (_vala_suffix);
		_vala_suffix = _tmp10_;
		_tmp11_ = string_slice (name, (glong) 0, (glong) index_of_suffix);
		_g_free0 (name_without_suffix);
		name_without_suffix = _tmp11_;
	} else {
		gint _tmp12_;
		gint _tmp13_;
		_tmp12_ = strlen (name);
		_tmp13_ = _tmp12_;
		index_of_suffix = _tmp13_;
	}
	_tmp14_ = name_without_suffix;
	index_of_opening = string_last_index_of (_tmp14_, _ (FILES_FILE_UTILS_OPENING_COPY_LINK_TAG), 0);
	if (index_of_opening < 0) {
		if (index_of_suffix > 0) {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = name_without_suffix;
			_tmp16_ = string_slice (_tmp15_, (glong) 0, (glong) index_of_suffix);
			_g_free0 (_vala_name_base);
			_vala_name_base = _tmp16_;
			_g_free0 (name_without_suffix);
			if (name_base) {
				*name_base = _vala_name_base;
			} else {
				_g_free0 (_vala_name_base);
			}
			if (suffix) {
				*suffix = _vala_suffix;
			} else {
				_g_free0 (_vala_suffix);
			}
			if (count) {
				*count = _vala_count;
			}
			return;
		}
	} else {
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp17_ = string_slice (name, (glong) 0, (glong) index_of_opening);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strchomp (_tmp18_);
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (_vala_name_base);
		_vala_name_base = _tmp20_;
		_g_free0 (_tmp18_);
	}
	_tmp21_ = name_without_suffix;
	_tmp22_ = g_utf8_strreverse (_tmp21_, (gssize) -1);
	reverse_base = _tmp22_;
	_tmp23_ = name_without_suffix;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	limit = (_tmp25_ - 1) - index_of_opening;
	_tmp26_ = name_without_suffix;
	chr = string_get_char (_tmp26_, (glong) 0);
	index = 0;
	while (TRUE) {
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_;
		gunichar _tmp29_ = 0U;
		if (index < limit) {
			_tmp27_ = !g_unichar_isdigit (chr);
		} else {
			_tmp27_ = FALSE;
		}
		if (!_tmp27_) {
			break;
		}
		_tmp28_ = reverse_base;
		string_get_next_char (_tmp28_, &index, &_tmp29_);
		chr = _tmp29_;
	}
	multiplier = 1;
	n_digits = 0;
	while (TRUE) {
		gboolean _tmp30_ = FALSE;
		gint _tmp31_;
		const gchar* _tmp32_;
		gunichar _tmp33_ = 0U;
		if (index < limit) {
			_tmp30_ = g_unichar_isdigit (chr);
		} else {
			_tmp30_ = FALSE;
		}
		if (!_tmp30_) {
			break;
		}
		_tmp31_ = n_digits;
		n_digits = _tmp31_ + 1;
		_vala_count = _vala_count + (g_unichar_digit_value (chr) * multiplier);
		multiplier *= 10;
		_tmp32_ = reverse_base;
		string_get_next_char (_tmp32_, &index, &_tmp33_);
		chr = _tmp33_;
	}
	if (_vala_count == 0) {
		_vala_count = 1;
	}
	if (n_digits > 0) {
		gint _tmp34_;
		gint _tmp35_;
		_tmp34_ = strlen (_ (FILES_FILE_UTILS_CLOSING_COPY_LINK_TAG));
		_tmp35_ = _tmp34_;
		expected_index = (_tmp35_ + n_digits) + 1;
	} else {
		if (is_link) {
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			_tmp36_ = strlen (_ (FILES_FILE_UTILS_CLOSING_COPY_LINK_TAG));
			_tmp37_ = _tmp36_;
			_tmp38_ = strlen (_ (FILES_FILE_UTILS_LINK_TAG));
			_tmp39_ = _tmp38_;
			expected_index = _tmp37_ + _tmp39_;
		} else {
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			_tmp40_ = strlen (_ (FILES_FILE_UTILS_CLOSING_COPY_LINK_TAG));
			_tmp41_ = _tmp40_;
			_tmp42_ = strlen (_ (FILES_FILE_UTILS_COPY_TAG));
			_tmp43_ = _tmp42_;
			expected_index = _tmp41_ + _tmp43_;
		}
	}
	if (index > expected_index) {
		const gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp44_ = name_without_suffix;
		_tmp45_ = g_strdup (_tmp44_);
		_g_free0 (_vala_name_base);
		_vala_name_base = _tmp45_;
		_vala_count = 0;
	}
	_g_free0 (reverse_base);
	_g_free0 (name_without_suffix);
	if (name_base) {
		*name_base = _vala_name_base;
	} else {
		_g_free0 (_vala_name_base);
	}
	if (suffix) {
		*suffix = _vala_suffix;
	} else {
		_g_free0 (_vala_suffix);
	}
	if (count) {
		*count = _vala_count;
	}
}

gchar*
files_file_utils_shorten_utf8_string (const gchar* base_string,
                                      gint reduce_by_num_bytes)
{
	gint target_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	GString* sb = NULL;
	GString* _tmp3_;
	GString* _tmp4_;
	gchar* valid_string = NULL;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gchar* result;
	g_return_val_if_fail (base_string != NULL, NULL);
	_tmp0_ = strlen (base_string);
	_tmp1_ = _tmp0_;
	target_length = _tmp1_ - reduce_by_num_bytes;
	if (target_length <= 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_string_sized_new ((gsize) target_length);
	sb = _tmp3_;
	_tmp4_ = sb;
	g_string_insert_len (_tmp4_, (gssize) 0, base_string, (gssize) target_length);
	_tmp5_ = sb;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = g_utf8_make_valid (_tmp6_, (gssize) -1);
	valid_string = _tmp7_;
	_tmp8_ = valid_string;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ <= target_length) {
		result = valid_string;
		_g_string_free0 (sb);
		return result;
	} else {
		gchar* _tmp11_;
		_tmp11_ = files_file_utils_shorten_utf8_string (base_string, reduce_by_num_bytes + 1);
		result = _tmp11_;
		_g_free0 (valid_string);
		_g_string_free0 (sb);
		return result;
	}
}

gchar*
files_file_utils_get_link_name (const gchar* target_name,
                                gint count,
                                gint max_length)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (target_name != NULL, NULL);
	_vala_return_val_if_fail (count >= 0, "count >= 0", NULL);
	_tmp0_ = files_file_utils_get_link_or_copy_name (target_name, TRUE, count, max_length);
	result = _tmp0_;
	return result;
}

gchar*
files_file_utils_get_copy_name (const gchar* base_name,
                                const gchar* suffix,
                                gint count,
                                gint max_length)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (base_name != NULL, NULL);
	g_return_val_if_fail (suffix != NULL, NULL);
	_vala_return_val_if_fail (count >= 0, "count >= 0", NULL);
	_tmp0_ = files_file_utils_get_link_or_copy_name (base_name, FALSE, count, max_length);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, suffix, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
files_file_utils_get_link_or_copy_name (const gchar* target_name,
                                        gboolean is_link,
                                        gint count,
                                        gint max_length)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* tag = NULL;
	gchar* _tmp2_;
	gboolean _tmp8_ = FALSE;
	gchar* result;
	g_return_val_if_fail (target_name != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	if (is_link) {
		_tmp1_ = _ (FILES_FILE_UTILS_LINK_TAG);
	} else {
		_tmp1_ = _ (FILES_FILE_UTILS_COPY_TAG);
	}
	_tmp2_ = g_strdup (_tmp1_);
	tag = _tmp2_;
	switch (count) {
		case 0:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (target_name);
			_g_free0 (_result_);
			_result_ = _tmp3_;
			break;
		}
		case 1:
		{
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = tag;
			_tmp5_ = g_strdup_printf ("%s %s%s%s", target_name, _ (FILES_FILE_UTILS_OPENING_COPY_LINK_TAG), _tmp4_, _ (FILES_FILE_UTILS_CLOSING_COPY_LINK_TAG));
			_g_free0 (_result_);
			_result_ = _tmp5_;
			break;
		}
		default:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = tag;
			_tmp7_ = g_strdup_printf ("%s %s%s %i%s", target_name, _ (FILES_FILE_UTILS_OPENING_COPY_LINK_TAG), _tmp6_, count, _ (FILES_FILE_UTILS_CLOSING_COPY_LINK_TAG));
			_g_free0 (_result_);
			_result_ = _tmp7_;
			break;
		}
	}
	if (max_length >= 0) {
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = _result_;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp8_ = _tmp11_ > max_length;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = _result_;
		_tmp13_ = _result_;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = files_file_utils_shorten_utf8_string (_tmp12_, _tmp15_ - max_length);
		_g_free0 (_result_);
		_result_ = _tmp16_;
	}
	result = _result_;
	_g_free0 (tag);
	return result;
}

gint
files_file_utils_get_max_name_length (GFile* file_dir)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	glong max_path = 0L;
	const gchar* _tmp1_;
	glong max_name = 0L;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint result;
	g_return_val_if_fail (file_dir != NULL, 0);
	if (!g_file_has_uri_scheme (file_dir, "file")) {
		result = -1;
		return result;
	}
	_tmp0_ = g_file_get_path (file_dir);
	dir = _tmp0_;
	_tmp1_ = dir;
	max_path = pathconf (_tmp1_, _PC_PATH_MAX);
	_tmp2_ = dir;
	max_name = pathconf (_tmp2_, _PC_NAME_MAX);
	if (max_name == ((glong) -1)) {
		_tmp3_ = max_path == ((glong) -1);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = -1;
		_g_free0 (dir);
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		if (max_name == ((glong) -1)) {
			_tmp4_ = max_path != ((glong) -1);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp5_ = dir;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			result = (gint) (max_path - (_tmp7_ + 1));
			_g_free0 (dir);
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			if (max_name != ((glong) -1)) {
				_tmp8_ = max_path == ((glong) -1);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = (gint) max_name;
				_g_free0 (dir);
				return result;
			} else {
				const gchar* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp9_ = dir;
				_tmp10_ = strlen (_tmp9_);
				_tmp11_ = _tmp10_;
				result = (gint) MIN (max_path - (_tmp11_ + 1), max_name);
				_g_free0 (dir);
				return result;
			}
		}
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
files_file_utils_protocol_is_supported (const gchar* protocol)
{
	GVfs* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gboolean result;
	g_return_val_if_fail (protocol != NULL, FALSE);
	_tmp0_ = g_vfs_get_default ();
	_tmp2_ = _tmp1_ = g_vfs_get_supported_uri_schemes (_tmp0_);
	result = _vala_string_array_contains (_tmp2_, _vala_array_length (_tmp1_), protocol);
	return result;
}

gboolean
files_file_utils_file_is_dir (GFile* file)
{
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = g_file_info_get_file_type (info) == G_FILE_TYPE_DIRECTORY;
		_g_object_unref0 (info);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp1_;
}

gchar*
files_file_utils_disambiguate_uri (const gchar* uri,
                                   const gchar* conflict_uri)
{
	gchar* uri_scheme = NULL;
	gchar* uri_userinfo = NULL;
	gchar* uri_host = NULL;
	gchar* uri_path = NULL;
	gchar* uri_query = NULL;
	gchar* uri_fragment = NULL;
	gchar* conflict_scheme = NULL;
	gchar* conflict_userinfo = NULL;
	gchar* conflict_host = NULL;
	gchar* conflict_path = NULL;
	gchar* conflict_query = NULL;
	gchar* conflict_fragment = NULL;
	gint uri_port = 0;
	gint conflict_port = 0;
	gchar* prefix = NULL;
	gchar* _tmp15_;
	gchar* conflict_prefix = NULL;
	gchar* _tmp16_;
	gchar* temp_path = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* temp_conflict_path = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* temp_basename = NULL;
	gchar* _tmp21_;
	gchar* temp_conflict_basename = NULL;
	gchar* _tmp22_;
	gchar* basename = NULL;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	guint count = 0U;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (conflict_uri != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		g_uri_split (uri, G_URI_FLAGS_NONE, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_inner_error0_);
		_g_free0 (uri_scheme);
		uri_scheme = _tmp0_;
		_g_free0 (uri_userinfo);
		uri_userinfo = _tmp1_;
		_g_free0 (uri_host);
		uri_host = _tmp2_;
		uri_port = _tmp3_;
		_g_free0 (uri_path);
		uri_path = _tmp4_;
		_g_free0 (uri_query);
		uri_query = _tmp5_;
		_g_free0 (uri_fragment);
		uri_fragment = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_uri_split (conflict_uri, G_URI_FLAGS_NONE, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_inner_error0_);
		_g_free0 (conflict_scheme);
		conflict_scheme = _tmp7_;
		_g_free0 (conflict_userinfo);
		conflict_userinfo = _tmp8_;
		_g_free0 (conflict_host);
		conflict_host = _tmp9_;
		conflict_port = _tmp10_;
		_g_free0 (conflict_path);
		conflict_path = _tmp11_;
		_g_free0 (conflict_query);
		conflict_query = _tmp12_;
		_g_free0 (conflict_fragment);
		conflict_fragment = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp14_;
		g_clear_error (&_inner_error0_);
		_tmp14_ = g_path_get_basename (uri);
		result = _tmp14_;
		_g_free0 (conflict_fragment);
		_g_free0 (conflict_query);
		_g_free0 (conflict_path);
		_g_free0 (conflict_host);
		_g_free0 (conflict_userinfo);
		_g_free0 (conflict_scheme);
		_g_free0 (uri_fragment);
		_g_free0 (uri_query);
		_g_free0 (uri_path);
		_g_free0 (uri_host);
		_g_free0 (uri_userinfo);
		_g_free0 (uri_scheme);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (conflict_fragment);
		_g_free0 (conflict_query);
		_g_free0 (conflict_path);
		_g_free0 (conflict_host);
		_g_free0 (conflict_userinfo);
		_g_free0 (conflict_scheme);
		_g_free0 (uri_fragment);
		_g_free0 (uri_query);
		_g_free0 (uri_path);
		_g_free0 (uri_host);
		_g_free0 (uri_userinfo);
		_g_free0 (uri_scheme);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp15_ = g_strdup ("");
	prefix = _tmp15_;
	_tmp16_ = g_strdup ("");
	conflict_prefix = _tmp16_;
	_tmp17_ = uri_path;
	_tmp18_ = g_strdup (_tmp17_);
	temp_path = _tmp18_;
	_tmp19_ = conflict_path;
	_tmp20_ = g_strdup (_tmp19_);
	temp_conflict_path = _tmp20_;
	_tmp21_ = g_strdup ("");
	temp_basename = _tmp21_;
	_tmp22_ = g_strdup ("");
	temp_conflict_basename = _tmp22_;
	_tmp23_ = temp_path;
	_tmp24_ = g_path_get_basename (_tmp23_);
	basename = _tmp24_;
	_tmp25_ = basename;
	if (g_strcmp0 (_tmp25_, "") == 0) {
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp27_ = uri_scheme;
		_tmp26_ = _tmp27_;
		if (_tmp26_ == NULL) {
			_tmp26_ = "file";
		}
		_tmp28_ = g_strconcat (_tmp26_, "://", NULL);
		result = _tmp28_;
		_g_free0 (basename);
		_g_free0 (temp_conflict_basename);
		_g_free0 (temp_basename);
		_g_free0 (temp_conflict_path);
		_g_free0 (temp_path);
		_g_free0 (conflict_prefix);
		_g_free0 (prefix);
		_g_free0 (conflict_fragment);
		_g_free0 (conflict_query);
		_g_free0 (conflict_path);
		_g_free0 (conflict_host);
		_g_free0 (conflict_userinfo);
		_g_free0 (conflict_scheme);
		_g_free0 (uri_fragment);
		_g_free0 (uri_query);
		_g_free0 (uri_path);
		_g_free0 (uri_host);
		_g_free0 (uri_userinfo);
		_g_free0 (uri_scheme);
		return result;
	}
	_tmp29_ = basename;
	_tmp30_ = conflict_path;
	_tmp31_ = g_path_get_basename (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strcmp0 (_tmp29_, _tmp32_) != 0;
	_g_free0 (_tmp32_);
	if (_tmp33_) {
		result = basename;
		_g_free0 (temp_conflict_basename);
		_g_free0 (temp_basename);
		_g_free0 (temp_conflict_path);
		_g_free0 (temp_path);
		_g_free0 (conflict_prefix);
		_g_free0 (prefix);
		_g_free0 (conflict_fragment);
		_g_free0 (conflict_query);
		_g_free0 (conflict_path);
		_g_free0 (conflict_host);
		_g_free0 (conflict_userinfo);
		_g_free0 (conflict_scheme);
		_g_free0 (uri_fragment);
		_g_free0 (uri_query);
		_g_free0 (uri_path);
		_g_free0 (uri_host);
		_g_free0 (uri_userinfo);
		_g_free0 (uri_scheme);
		return result;
	}
	_tmp34_ = temp_path;
	_tmp35_ = temp_conflict_path;
	if (g_strcmp0 (_tmp34_, _tmp35_) == 0) {
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_;
		const gchar* _tmp38_ = NULL;
		const gchar* _tmp39_;
		_tmp37_ = uri_scheme;
		_tmp36_ = _tmp37_;
		if (_tmp36_ == NULL) {
			_tmp36_ = "file";
		}
		_tmp39_ = conflict_scheme;
		_tmp38_ = _tmp39_;
		if (_tmp38_ == NULL) {
			_tmp38_ = "file";
		}
		if (g_strcmp0 (_tmp36_, _tmp38_) == 0) {
			result = basename;
			_g_free0 (temp_conflict_basename);
			_g_free0 (temp_basename);
			_g_free0 (temp_conflict_path);
			_g_free0 (temp_path);
			_g_free0 (conflict_prefix);
			_g_free0 (prefix);
			_g_free0 (conflict_fragment);
			_g_free0 (conflict_query);
			_g_free0 (conflict_path);
			_g_free0 (conflict_host);
			_g_free0 (conflict_userinfo);
			_g_free0 (conflict_scheme);
			_g_free0 (uri_fragment);
			_g_free0 (uri_query);
			_g_free0 (uri_path);
			_g_free0 (uri_host);
			_g_free0 (uri_userinfo);
			_g_free0 (uri_scheme);
			return result;
		} else {
			gchar* _tmp40_;
			_tmp40_ = g_strdup (uri);
			result = _tmp40_;
			_g_free0 (basename);
			_g_free0 (temp_conflict_basename);
			_g_free0 (temp_basename);
			_g_free0 (temp_conflict_path);
			_g_free0 (temp_path);
			_g_free0 (conflict_prefix);
			_g_free0 (prefix);
			_g_free0 (conflict_fragment);
			_g_free0 (conflict_query);
			_g_free0 (conflict_path);
			_g_free0 (conflict_host);
			_g_free0 (conflict_userinfo);
			_g_free0 (conflict_scheme);
			_g_free0 (uri_fragment);
			_g_free0 (uri_query);
			_g_free0 (uri_path);
			_g_free0 (uri_host);
			_g_free0 (uri_userinfo);
			_g_free0 (uri_scheme);
			return result;
		}
	}
	count = (guint) 0;
	while (TRUE) {
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* parent_temp_path = NULL;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* parent_temp_confict_path = NULL;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp67_;
		guint _tmp76_;
		_tmp43_ = prefix;
		_tmp44_ = conflict_prefix;
		if (g_strcmp0 (_tmp43_, _tmp44_) == 0) {
			const gchar* _tmp45_;
			_tmp45_ = temp_basename;
			_tmp42_ = g_strcmp0 (_tmp45_, G_DIR_SEPARATOR_S) != 0;
		} else {
			_tmp42_ = FALSE;
		}
		if (_tmp42_) {
			_tmp41_ = count < ((guint) 10);
		} else {
			_tmp41_ = FALSE;
		}
		if (!_tmp41_) {
			break;
		}
		_tmp46_ = temp_path;
		_tmp47_ = files_file_utils_get_parent_path_from_path (_tmp46_, FALSE);
		parent_temp_path = _tmp47_;
		_tmp48_ = temp_conflict_path;
		_tmp49_ = files_file_utils_get_parent_path_from_path (_tmp48_, FALSE);
		parent_temp_confict_path = _tmp49_;
		_tmp50_ = parent_temp_path;
		_tmp51_ = g_strdup (_tmp50_);
		_g_free0 (temp_path);
		temp_path = _tmp51_;
		_tmp52_ = parent_temp_confict_path;
		_tmp53_ = g_strdup (_tmp52_);
		_g_free0 (temp_conflict_path);
		temp_conflict_path = _tmp53_;
		_tmp54_ = parent_temp_path;
		_tmp55_ = g_path_get_basename (_tmp54_);
		_g_free0 (temp_basename);
		temp_basename = _tmp55_;
		_tmp56_ = parent_temp_confict_path;
		_tmp57_ = g_path_get_basename (_tmp56_);
		_g_free0 (temp_conflict_basename);
		temp_conflict_basename = _tmp57_;
		_tmp58_ = temp_basename;
		if (g_strcmp0 (_tmp58_, G_DIR_SEPARATOR_S) != 0) {
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			const gchar* _tmp62_;
			gchar* _tmp63_;
			_tmp59_ = temp_basename;
			_tmp60_ = g_strconcat (_tmp59_, G_DIR_SEPARATOR_S, NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = prefix;
			_tmp63_ = g_strconcat (_tmp61_, _tmp62_, NULL);
			_g_free0 (prefix);
			prefix = _tmp63_;
			_g_free0 (_tmp61_);
		} else {
			const gchar* _tmp64_;
			const gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp64_ = temp_basename;
			_tmp65_ = prefix;
			_tmp66_ = g_strconcat (_tmp64_, _tmp65_, NULL);
			_g_free0 (prefix);
			prefix = _tmp66_;
		}
		_tmp67_ = temp_conflict_basename;
		if (g_strcmp0 (_tmp67_, G_DIR_SEPARATOR_S) != 0) {
			const gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			const gchar* _tmp71_;
			gchar* _tmp72_;
			_tmp68_ = temp_conflict_basename;
			_tmp69_ = g_strconcat (_tmp68_, G_DIR_SEPARATOR_S, NULL);
			_tmp70_ = _tmp69_;
			_tmp71_ = conflict_prefix;
			_tmp72_ = g_strconcat (_tmp70_, _tmp71_, NULL);
			_g_free0 (conflict_prefix);
			conflict_prefix = _tmp72_;
			_g_free0 (_tmp70_);
		} else {
			const gchar* _tmp73_;
			const gchar* _tmp74_;
			gchar* _tmp75_;
			_tmp73_ = temp_conflict_basename;
			_tmp74_ = conflict_prefix;
			_tmp75_ = g_strconcat (_tmp73_, _tmp74_, NULL);
			_g_free0 (conflict_prefix);
			conflict_prefix = _tmp75_;
		}
		_tmp76_ = count;
		count = _tmp76_ + 1;
		_g_free0 (parent_temp_confict_path);
		_g_free0 (parent_temp_path);
	}
	if (count > ((guint) 5)) {
		g_warning ("FileUtils.vala:1196: disambiguate_oath: too many loops");
		result = basename;
		_g_free0 (temp_conflict_basename);
		_g_free0 (temp_basename);
		_g_free0 (temp_conflict_path);
		_g_free0 (temp_path);
		_g_free0 (conflict_prefix);
		_g_free0 (prefix);
		_g_free0 (conflict_fragment);
		_g_free0 (conflict_query);
		_g_free0 (conflict_path);
		_g_free0 (conflict_host);
		_g_free0 (conflict_userinfo);
		_g_free0 (conflict_scheme);
		_g_free0 (uri_fragment);
		_g_free0 (uri_query);
		_g_free0 (uri_path);
		_g_free0 (uri_host);
		_g_free0 (uri_userinfo);
		_g_free0 (uri_scheme);
		return result;
	}
	_tmp77_ = prefix;
	_tmp78_ = basename;
	_tmp79_ = g_strconcat (_tmp77_, _tmp78_, NULL);
	result = _tmp79_;
	_g_free0 (basename);
	_g_free0 (temp_conflict_basename);
	_g_free0 (temp_basename);
	_g_free0 (temp_conflict_path);
	_g_free0 (temp_path);
	_g_free0 (conflict_prefix);
	_g_free0 (prefix);
	_g_free0 (conflict_fragment);
	_g_free0 (conflict_query);
	_g_free0 (conflict_path);
	_g_free0 (conflict_host);
	_g_free0 (conflict_userinfo);
	_g_free0 (conflict_scheme);
	_g_free0 (uri_fragment);
	_g_free0 (uri_query);
	_g_free0 (uri_path);
	_g_free0 (uri_host);
	_g_free0 (uri_userinfo);
	_g_free0 (uri_scheme);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

