/* RenamerListRow.c generated by valac 0.56.18, the Vala compiler
 * generated from RenamerListRow.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0
 * SPDX-FileCopyrightText: 2019-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Vartan Belavejian <https://github.com/VartanBelavejian>
 *              Jeremy Wootten <jeremywootten@gmail.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "pantheon-files-core.h"
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_RENAMER_LIST_ROW (files_renamer_list_row_get_type ())
#define FILES_RENAMER_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow))
#define FILES_RENAMER_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRowClass))
#define FILES_IS_RENAMER_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_RENAMER_LIST_ROW))
#define FILES_IS_RENAMER_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_RENAMER_LIST_ROW))
#define FILES_RENAMER_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRowClass))

typedef struct _FilesRenamerListRow FilesRenamerListRow;
typedef struct _FilesRenamerListRowClass FilesRenamerListRowClass;
typedef struct _FilesRenamerListRowPrivate FilesRenamerListRowPrivate;
enum  {
	FILES_RENAMER_LIST_ROW_0_PROPERTY,
	FILES_RENAMER_LIST_ROW_OLD_NAME_PROPERTY,
	FILES_RENAMER_LIST_ROW_FILE_PROPERTY,
	FILES_RENAMER_LIST_ROW_NEW_NAME_PROPERTY,
	FILES_RENAMER_LIST_ROW_EXTENSION_PROPERTY,
	FILES_RENAMER_LIST_ROW_STATUS_PROPERTY,
	FILES_RENAMER_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block15Data Block15Data;

struct _FilesRenamerListRow {
	GtkListBoxRow parent_instance;
	FilesRenamerListRowPrivate * priv;
};

struct _FilesRenamerListRowClass {
	GtkListBoxRowClass parent_class;
};

struct _FilesRenamerListRowPrivate {
	gchar* _old_name;
	FilesFile* _file;
	gchar* _new_name;
	gchar* _extension;
	FilesRenameStatus _status;
};

struct _Block15Data {
	int _ref_count_;
	FilesRenamerListRow* self;
	GtkImage* status_image;
};

static gint FilesRenamerListRow_private_offset;
static gpointer files_renamer_list_row_parent_class = NULL;
static GtkSizeGroup* files_renamer_list_row_size_group;
static GtkSizeGroup* files_renamer_list_row_size_group = NULL;

VALA_EXTERN GType files_renamer_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesRenamerListRow, g_object_unref)
VALA_EXTERN FilesRenamerListRow* files_renamer_list_row_new (FilesFile* file);
VALA_EXTERN FilesRenamerListRow* files_renamer_list_row_construct (GType object_type,
                                                       FilesFile* file);
VALA_EXTERN const gchar* files_renamer_list_row_get_old_name (FilesRenamerListRow* self);
static void files_renamer_list_row_set_old_name (FilesRenamerListRow* self,
                                          const gchar* value);
VALA_EXTERN FilesFile* files_renamer_list_row_get_file (FilesRenamerListRow* self);
static void files_renamer_list_row_set_file (FilesRenamerListRow* self,
                                      FilesFile* value);
VALA_EXTERN const gchar* files_renamer_list_row_get_new_name (FilesRenamerListRow* self);
VALA_EXTERN void files_renamer_list_row_set_new_name (FilesRenamerListRow* self,
                                          const gchar* value);
VALA_EXTERN const gchar* files_renamer_list_row_get_extension (FilesRenamerListRow* self);
VALA_EXTERN void files_renamer_list_row_set_extension (FilesRenamerListRow* self,
                                           const gchar* value);
VALA_EXTERN FilesRenameStatus files_renamer_list_row_get_status (FilesRenamerListRow* self);
VALA_EXTERN void files_renamer_list_row_set_status (FilesRenamerListRow* self,
                                        FilesRenameStatus value);
static GObject * files_renamer_list_row_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void _files_renamer_list_row___lambda89_ (Block15Data* _data15_);
static void __files_renamer_list_row___lambda89__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void files_renamer_list_row_finalize (GObject * obj);
static GType files_renamer_list_row_get_type_once (void);
static void _vala_files_renamer_list_row_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_files_renamer_list_row_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
files_renamer_list_row_get_instance_private (FilesRenamerListRow* self)
{
	return G_STRUCT_MEMBER_P (self, FilesRenamerListRow_private_offset);
}

FilesRenamerListRow*
files_renamer_list_row_construct (GType object_type,
                                  FilesFile* file)
{
	FilesRenamerListRow * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = files_file_get_basename (file);
	_tmp1_ = _tmp0_;
	self = (FilesRenamerListRow*) g_object_new (object_type, "file", file, "old-name", _tmp1_, NULL);
	return self;
}

FilesRenamerListRow*
files_renamer_list_row_new (FilesFile* file)
{
	return files_renamer_list_row_construct (FILES_TYPE_RENAMER_LIST_ROW, file);
}

const gchar*
files_renamer_list_row_get_old_name (FilesRenamerListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_old_name;
	result = _tmp0_;
	return result;
}

static void
files_renamer_list_row_set_old_name (FilesRenamerListRow* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_list_row_get_old_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_old_name);
		self->priv->_old_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_OLD_NAME_PROPERTY]);
	}
}

FilesFile*
files_renamer_list_row_get_file (FilesRenamerListRow* self)
{
	FilesFile* result;
	FilesFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
files_renamer_list_row_set_file (FilesRenamerListRow* self,
                                 FilesFile* value)
{
	FilesFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_list_row_get_file (self);
	if (old_value != value) {
		FilesFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_FILE_PROPERTY]);
	}
}

const gchar*
files_renamer_list_row_get_new_name (FilesRenamerListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_new_name;
	result = _tmp0_;
	return result;
}

void
files_renamer_list_row_set_new_name (FilesRenamerListRow* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_list_row_get_new_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_new_name);
		self->priv->_new_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_NEW_NAME_PROPERTY]);
	}
}

const gchar*
files_renamer_list_row_get_extension (FilesRenamerListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}

void
files_renamer_list_row_set_extension (FilesRenamerListRow* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_list_row_get_extension (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_extension);
		self->priv->_extension = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_EXTENSION_PROPERTY]);
	}
}

FilesRenameStatus
files_renamer_list_row_get_status (FilesRenamerListRow* self)
{
	FilesRenameStatus result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_status;
	return result;
}

void
files_renamer_list_row_set_status (FilesRenamerListRow* self,
                                   FilesRenameStatus value)
{
	FilesRenameStatus old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_list_row_get_status (self);
	if (old_value != value) {
		self->priv->_status = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_STATUS_PROPERTY]);
	}
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		FilesRenamerListRow* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->status_image);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
_files_renamer_list_row___lambda89_ (Block15Data* _data15_)
{
	FilesRenamerListRow* self;
	FilesRenameStatus _tmp0_;
	self = _data15_->self;
	_tmp0_ = self->priv->_status;
	switch (_tmp0_) {
		case FILES_RENAME_STATUS_IGNORED:
		{
			GtkImage* _tmp1_;
			GtkImage* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = _data15_->status_image;
			g_object_set (_tmp1_, "icon-name", "radio-mixed-symbolic", NULL);
			_tmp2_ = _data15_->status_image;
			_tmp3_ = g_strconcat (_ ("Ignored"), "\n", NULL);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _ ("Name is not changed"));
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strconcat (_tmp4_, _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp2_, _tmp8_);
			_g_free0 (_tmp8_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp4_);
			break;
		}
		case FILES_RENAME_STATUS_INVALID:
		{
			GtkImage* _tmp9_;
			GtkImage* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp9_ = _data15_->status_image;
			g_object_set (_tmp9_, "icon-name", "process-error-symbolic", NULL);
			_tmp10_ = _data15_->status_image;
			_tmp11_ = g_strconcat (_ ("Cannot rename"), "\n", NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _ ("Name is invalid or already exists"));
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp10_, _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			break;
		}
		case FILES_RENAME_STATUS_VALID:
		{
			GtkImage* _tmp17_;
			GtkImage* _tmp18_;
			_tmp17_ = _data15_->status_image;
			g_object_set (_tmp17_, "icon-name", "process-completed-symbolic", NULL);
			_tmp18_ = _data15_->status_image;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _ ("Will be renamed"));
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
__files_renamer_list_row___lambda89__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_files_renamer_list_row___lambda89_ (self);
}

static GObject *
files_renamer_list_row_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesRenamerListRow * self;
	Block15Data* _data15_;
	GtkLabel* oldname_label = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* newname_label = NULL;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkSizeGroup* _tmp4_;
	GtkLabel* _tmp5_;
	GtkSizeGroup* _tmp6_;
	GtkLabel* _tmp7_;
	GtkImage* arrow_image = NULL;
	GtkImage* _tmp8_ = NULL;
	GtkImage* _tmp9_;
	GtkBox* box = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkBox* _tmp13_;
	GtkImage* _tmp14_;
	GtkBox* _tmp15_;
	GtkLabel* _tmp16_;
	GtkBox* _tmp17_;
	GtkImage* _tmp18_;
	GtkBox* _tmp19_;
	GtkLabel* _tmp20_;
	parent_class = G_OBJECT_CLASS (files_renamer_list_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = self->priv->_old_name;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_set (_tmp1_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	g_object_ref_sink (_tmp1_);
	oldname_label = _tmp1_;
	_tmp2_ = self->priv->_new_name;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_set (_tmp3_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp3_, (gfloat) 0);
	g_object_ref_sink (_tmp3_);
	newname_label = _tmp3_;
	_tmp4_ = files_renamer_list_row_size_group;
	_tmp5_ = newname_label;
	gtk_size_group_add_widget (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = files_renamer_list_row_size_group;
	_tmp7_ = oldname_label;
	gtk_size_group_add_widget (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	g_object_ref_sink (_tmp8_);
	arrow_image = _tmp8_;
	_tmp9_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp9_);
	_data15_->status_image = _tmp9_;
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp10_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp10_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp10_, 6);
	g_object_ref_sink (_tmp10_);
	box = _tmp10_;
	_tmp11_ = box;
	_tmp12_ = oldname_label;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = box;
	_tmp14_ = arrow_image;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = box;
	_tmp16_ = newname_label;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = box;
	_tmp18_ = _data15_->status_image;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp19_, NULL);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp20_ = newname_label;
	g_object_bind_property_with_closures ((GObject*) self, "new-name", (GObject*) _tmp20_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GObject*) self, "notify::status", (GCallback) __files_renamer_list_row___lambda89__g_object_notify, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (arrow_image);
	_g_object_unref0 (newname_label);
	_g_object_unref0 (oldname_label);
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return obj;
}

static void
files_renamer_list_row_class_init (FilesRenamerListRowClass * klass,
                                   gpointer klass_data)
{
	GtkSizeGroup* _tmp0_;
	files_renamer_list_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesRenamerListRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_renamer_list_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_renamer_list_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_renamer_list_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_renamer_list_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_LIST_ROW_OLD_NAME_PROPERTY, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_OLD_NAME_PROPERTY] = g_param_spec_string ("old-name", "old-name", "old-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_LIST_ROW_FILE_PROPERTY, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", FILES_TYPE_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_LIST_ROW_NEW_NAME_PROPERTY, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_NEW_NAME_PROPERTY] = g_param_spec_string ("new-name", "new-name", "new-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_LIST_ROW_EXTENSION_PROPERTY, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_EXTENSION_PROPERTY] = g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_LIST_ROW_STATUS_PROPERTY, files_renamer_list_row_properties[FILES_RENAMER_LIST_ROW_STATUS_PROPERTY] = g_param_spec_enum ("status", "status", "status", FILES_TYPE_RENAME_STATUS, FILES_RENAME_STATUS_VALID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (files_renamer_list_row_size_group);
	files_renamer_list_row_size_group = _tmp0_;
}

static void
files_renamer_list_row_instance_init (FilesRenamerListRow * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	self->priv = files_renamer_list_row_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_extension = _tmp0_;
	self->priv->_status = FILES_RENAME_STATUS_VALID;
}

static void
files_renamer_list_row_finalize (GObject * obj)
{
	FilesRenamerListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow);
	_g_free0 (self->priv->_old_name);
	_g_object_unref0 (self->priv->_file);
	_g_free0 (self->priv->_new_name);
	_g_free0 (self->priv->_extension);
	G_OBJECT_CLASS (files_renamer_list_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_renamer_list_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesRenamerListRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_renamer_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesRenamerListRow), 0, (GInstanceInitFunc) files_renamer_list_row_instance_init, NULL };
	GType files_renamer_list_row_type_id;
	files_renamer_list_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "FilesRenamerListRow", &g_define_type_info, 0);
	FilesRenamerListRow_private_offset = g_type_add_instance_private (files_renamer_list_row_type_id, sizeof (FilesRenamerListRowPrivate));
	return files_renamer_list_row_type_id;
}

GType
files_renamer_list_row_get_type (void)
{
	static volatile gsize files_renamer_list_row_type_id__once = 0;
	if (g_once_init_enter (&files_renamer_list_row_type_id__once)) {
		GType files_renamer_list_row_type_id;
		files_renamer_list_row_type_id = files_renamer_list_row_get_type_once ();
		g_once_init_leave (&files_renamer_list_row_type_id__once, files_renamer_list_row_type_id);
	}
	return files_renamer_list_row_type_id__once;
}

static void
_vala_files_renamer_list_row_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	FilesRenamerListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow);
	switch (property_id) {
		case FILES_RENAMER_LIST_ROW_OLD_NAME_PROPERTY:
		g_value_set_string (value, files_renamer_list_row_get_old_name (self));
		break;
		case FILES_RENAMER_LIST_ROW_FILE_PROPERTY:
		g_value_set_object (value, files_renamer_list_row_get_file (self));
		break;
		case FILES_RENAMER_LIST_ROW_NEW_NAME_PROPERTY:
		g_value_set_string (value, files_renamer_list_row_get_new_name (self));
		break;
		case FILES_RENAMER_LIST_ROW_EXTENSION_PROPERTY:
		g_value_set_string (value, files_renamer_list_row_get_extension (self));
		break;
		case FILES_RENAMER_LIST_ROW_STATUS_PROPERTY:
		g_value_set_enum (value, files_renamer_list_row_get_status (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_renamer_list_row_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	FilesRenamerListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow);
	switch (property_id) {
		case FILES_RENAMER_LIST_ROW_OLD_NAME_PROPERTY:
		files_renamer_list_row_set_old_name (self, g_value_get_string (value));
		break;
		case FILES_RENAMER_LIST_ROW_FILE_PROPERTY:
		files_renamer_list_row_set_file (self, g_value_get_object (value));
		break;
		case FILES_RENAMER_LIST_ROW_NEW_NAME_PROPERTY:
		files_renamer_list_row_set_new_name (self, g_value_get_string (value));
		break;
		case FILES_RENAMER_LIST_ROW_EXTENSION_PROPERTY:
		files_renamer_list_row_set_extension (self, g_value_get_string (value));
		break;
		case FILES_RENAMER_LIST_ROW_STATUS_PROPERTY:
		files_renamer_list_row_set_status (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

