/* Client.c generated by valac 0.56.17, the Vala compiler
 * generated from Client.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#define PLANK_DBUS_DOCK_INTERFACE_NAME "net.launchpad.plank"
#define PLANK_DBUS_PING_NAME "Ping"
#define PLANK_DBUS_CLIENT_INTERFACE_NAME "net.launchpad.plank.Client"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PLANK_TYPE_DBUS_ITEMS_IFACE (plank_dbus_items_iface_get_type ())
#define PLANK_DBUS_ITEMS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLANK_TYPE_DBUS_ITEMS_IFACE, PlankDBusItemsIface))
#define PLANK_IS_DBUS_ITEMS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLANK_TYPE_DBUS_ITEMS_IFACE))
#define PLANK_DBUS_ITEMS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PLANK_TYPE_DBUS_ITEMS_IFACE, PlankDBusItemsIfaceIface))

typedef struct _PlankDBusItemsIface PlankDBusItemsIface;
typedef struct _PlankDBusItemsIfaceIface PlankDBusItemsIfaceIface;

#define PLANK_TYPE_DBUS_ITEMS_IFACE_PROXY (plank_dbus_items_iface_proxy_get_type ())
enum  {
	PLANK_DBUS_CLIENT_0_PROPERTY,
	PLANK_DBUS_CLIENT_IS_CONNECTED_PROPERTY,
	PLANK_DBUS_CLIENT_NUM_PROPERTIES
};
static GParamSpec* plank_dbus_client_properties[PLANK_DBUS_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	PLANK_DBUS_CLIENT_PROXY_CHANGED_SIGNAL,
	PLANK_DBUS_CLIENT_NUM_SIGNALS
};
static guint plank_dbus_client_signals[PLANK_DBUS_CLIENT_NUM_SIGNALS] = {0};

struct _PlankDBusItemsIfaceIface {
	GTypeInterface parent_iface;
	gboolean (*add) (PlankDBusItemsIface* self, const gchar* uri, GError** error);
	gboolean (*remove) (PlankDBusItemsIface* self, const gchar* uri, GError** error);
	gint (*get_count) (PlankDBusItemsIface* self, GError** error);
	gchar** (*get_persistent_applications) (PlankDBusItemsIface* self, gint* result_length1, GError** error);
	gchar** (*get_transient_applications) (PlankDBusItemsIface* self, gint* result_length1, GError** error);
	gboolean (*get_hover_position) (PlankDBusItemsIface* self, const gchar* uri, gint* x, gint* y, GtkPositionType* dock_position, GError** error);
};

struct _PlankDBusClientPrivate {
	GDBusConnection* connection;
	gchar* client_object_path;
	gchar* dock_bus_owner;
	gchar* dock_bus_name;
	gchar* dock_object_path;
	guint dbus_dock_ping_id;
	guint dbus_name_owner_changed_signal_id;
	PlankDBusItemsIface* items_proxy;
	gint items_count;
	gchar** persistent_apps_list;
	gint persistent_apps_list_length1;
	gint _persistent_apps_list_size_;
	gchar** transient_apps_list;
	gint transient_apps_list_length1;
	gint _transient_apps_list_size_;
};

static gint PlankDBusClient_private_offset;
static gpointer plank_dbus_client_parent_class = NULL;
static PlankDBusClient* plank_dbus_client_instance;
static PlankDBusClient* plank_dbus_client_instance = NULL;

VALA_EXTERN GType plank_dbus_items_iface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint plank_dbus_items_iface_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN GType plank_dbus_items_iface_get_type (void) G_GNUC_CONST ;
static PlankDBusClient* plank_dbus_client_new (void);
static PlankDBusClient* plank_dbus_client_construct (GType object_type);
static void plank_dbus_client_handle_dock_ping (GDBusConnection* connection,
                                         const gchar* sender_name,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* signal_name,
                                         GVariant* parameters,
                                         PlankDBusClient* self);
static void plank_dbus_client_connect_proxies (PlankDBusClient* self,
                                        GDBusConnection* connection,
                                        const gchar* sender_name,
                                        const gchar* object_path);
static void plank_dbus_client_handle_name_owner_changed (GDBusConnection* connection,
                                                  const gchar* sender_name,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* signal_name,
                                                  GVariant* parameters,
                                                  PlankDBusClient* self);
static void plank_dbus_client_disconnect_proxies (PlankDBusClient* self);
static void plank_dbus_client_invalidate_items_cache (PlankDBusClient* self);
static void _plank_dbus_client_invalidate_items_cache_plank_dbus_items_iface_changed (PlankDBusItemsIface* _sender,
                                                                               gpointer self);
VALA_EXTERN gboolean plank_dbus_items_iface_add (PlankDBusItemsIface* self,
                                     const gchar* uri,
                                     GError** error);
VALA_EXTERN gboolean plank_dbus_items_iface_remove (PlankDBusItemsIface* self,
                                        const gchar* uri,
                                        GError** error);
VALA_EXTERN gint plank_dbus_items_iface_get_count (PlankDBusItemsIface* self,
                                       GError** error);
VALA_EXTERN gchar** plank_dbus_items_iface_get_persistent_applications (PlankDBusItemsIface* self,
                                                            gint* result_length1,
                                                            GError** error);
VALA_EXTERN gchar** plank_dbus_items_iface_get_transient_applications (PlankDBusItemsIface* self,
                                                           gint* result_length1,
                                                           GError** error);
VALA_EXTERN gboolean plank_dbus_items_iface_get_hover_position (PlankDBusItemsIface* self,
                                                    const gchar* uri,
                                                    gint* x,
                                                    gint* y,
                                                    GtkPositionType* dock_position,
                                                    GError** error);
static GObject * plank_dbus_client_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void plank_dbus_client_finalize (GObject * obj);
static GType plank_dbus_client_get_type_once (void);
static void _vala_plank_dbus_client_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
plank_dbus_client_get_instance_private (PlankDBusClient* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDBusClient_private_offset);
}

/**
 * Get the singleton instance of {@link Plank.DBusClient}
 */
PlankDBusClient*
plank_dbus_client_get_instance (void)
{
	PlankDBusClient* _tmp0_;
	PlankDBusClient* _tmp2_;
	PlankDBusClient* result;
	_tmp0_ = plank_dbus_client_instance;
	if (_tmp0_ == NULL) {
		PlankDBusClient* _tmp1_;
		_tmp1_ = plank_dbus_client_new ();
		_g_object_unref0 (plank_dbus_client_instance);
		plank_dbus_client_instance = _tmp1_;
	}
	_tmp2_ = plank_dbus_client_instance;
	result = _tmp2_;
	return result;
}

static PlankDBusClient*
plank_dbus_client_construct (GType object_type)
{
	PlankDBusClient * self = NULL;
	self = (PlankDBusClient*) g_object_new (object_type, NULL);
	return self;
}

static PlankDBusClient*
plank_dbus_client_new (void)
{
	return plank_dbus_client_construct (PLANK_TYPE_DBUS_CLIENT);
}

static void
plank_dbus_client_handle_dock_ping (GDBusConnection* connection,
                                    const gchar* sender_name,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* signal_name,
                                    GVariant* parameters,
                                    PlankDBusClient* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp1_ = self->priv->dock_bus_name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->dock_bus_name;
		_tmp0_ = g_strcmp0 (_tmp2_, sender_name) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		plank_dbus_client_connect_proxies (self, connection, sender_name, object_path);
	}
}

static void
plank_dbus_client_handle_name_owner_changed (GDBusConnection* connection,
                                             const gchar* sender_name,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* signal_name,
                                             GVariant* parameters,
                                             PlankDBusClient* self)
{
	gchar* name = NULL;
	gchar* before = NULL;
	gchar* after = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	g_variant_get (parameters, "(sss)", &_tmp0_, &_tmp1_, &_tmp2_, NULL);
	_g_free0 (name);
	name = _tmp0_;
	_g_free0 (before);
	before = _tmp1_;
	_g_free0 (after);
	after = _tmp2_;
	_tmp4_ = self->priv->dock_bus_owner;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->priv->dock_bus_owner;
		_tmp6_ = after;
		_tmp3_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_g_free0 (after);
		_g_free0 (before);
		_g_free0 (name);
		return;
	}
	_tmp9_ = name;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		_tmp10_ = name;
		_tmp8_ = g_strcmp0 (_tmp10_, "") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = name;
		_tmp12_ = self->priv->dock_bus_name;
		_tmp7_ = g_strcmp0 (_tmp11_, _tmp12_) != 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_g_free0 (after);
		_g_free0 (before);
		_g_free0 (name);
		return;
	}
	_tmp14_ = after;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = after;
		_tmp13_ = g_strcmp0 (_tmp15_, "") == 0;
	}
	if (_tmp13_) {
		plank_dbus_client_disconnect_proxies (self);
		_g_free0 (after);
		_g_free0 (before);
		_g_free0 (name);
		return;
	}
	_tmp16_ = name;
	plank_dbus_client_connect_proxies (self, connection, _tmp16_, object_path);
	_g_free0 (after);
	_g_free0 (before);
	_g_free0 (name);
}

static void
_plank_dbus_client_invalidate_items_cache_plank_dbus_items_iface_changed (PlankDBusItemsIface* _sender,
                                                                          gpointer self)
{
	plank_dbus_client_invalidate_items_cache ((PlankDBusClient*) self);
}

static void
plank_dbus_client_connect_proxies (PlankDBusClient* self,
                                   GDBusConnection* connection,
                                   const gchar* sender_name,
                                   const gchar* object_path)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_debug ("Client.vala:154: Connecting and create proxies for '%s' (%s)", sender_name, object_path);
	{
		PlankDBusItemsIface* _tmp0_ = NULL;
		PlankDBusItemsIface* _tmp1_;
		PlankDBusItemsIface* _tmp2_;
		PlankDBusItemsIface* _tmp3_;
		PlankDBusItemsIface* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = (PlankDBusItemsIface*) g_initable_new (PLANK_TYPE_DBUS_ITEMS_IFACE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", sender_name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "net.launchpad.plank.Items", NULL);
		_tmp0_ = (PlankDBusItemsIface*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->items_proxy);
		self->priv->items_proxy = _tmp2_;
		_tmp3_ = self->priv->items_proxy;
		g_signal_connect_object (_tmp3_, "changed", (GCallback) _plank_dbus_client_invalidate_items_cache_plank_dbus_items_iface_changed, self, 0);
		_tmp4_ = self->priv->items_proxy;
		_tmp5_ = g_dbus_proxy_get_name_owner (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_dbus_proxy_get_type (), GDBusProxy));
		_g_free0 (self->priv->dock_bus_owner);
		self->priv->dock_bus_owner = _tmp5_;
		_tmp6_ = g_strdup (sender_name);
		_g_free0 (self->priv->dock_bus_name);
		self->priv->dock_bus_name = _tmp6_;
		_tmp7_ = g_strdup (object_path);
		_g_free0 (self->priv->dock_object_path);
		self->priv->dock_object_path = _tmp7_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_free0 (self->priv->dock_bus_owner);
		self->priv->dock_bus_owner = NULL;
		_g_free0 (self->priv->dock_bus_name);
		self->priv->dock_bus_name = NULL;
		_g_free0 (self->priv->dock_object_path);
		self->priv->dock_object_path = NULL;
		_g_object_unref0 (self->priv->items_proxy);
		self->priv->items_proxy = NULL;
		g_critical ("Client.vala:168: Failed to create items proxy for '%s' (%s)", sender_name, object_path);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_emit (self, plank_dbus_client_signals[PLANK_DBUS_CLIENT_PROXY_CHANGED_SIGNAL], 0);
}

static void
plank_dbus_client_disconnect_proxies (PlankDBusClient* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	PlankDBusItemsIface* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dock_bus_name;
	_tmp1_ = self->priv->dock_object_path;
	g_debug ("Client.vala:176: Disconnecting from '%s' (%s)", _tmp0_, _tmp1_);
	_g_free0 (self->priv->dock_bus_owner);
	self->priv->dock_bus_owner = NULL;
	_g_free0 (self->priv->dock_bus_name);
	self->priv->dock_bus_name = NULL;
	_g_free0 (self->priv->dock_object_path);
	self->priv->dock_object_path = NULL;
	_tmp2_ = self->priv->items_proxy;
	g_signal_parse_name ("changed", PLANK_TYPE_DBUS_ITEMS_IFACE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _plank_dbus_client_invalidate_items_cache_plank_dbus_items_iface_changed, self);
	_g_object_unref0 (self->priv->items_proxy);
	self->priv->items_proxy = NULL;
}

static void
plank_dbus_client_invalidate_items_cache (PlankDBusClient* self)
{
	g_return_if_fail (self != NULL);
	self->priv->items_count = G_MININT;
	self->priv->persistent_apps_list = (_vala_array_free (self->priv->persistent_apps_list, self->priv->persistent_apps_list_length1, (GDestroyNotify) g_free), NULL);
	self->priv->persistent_apps_list = NULL;
	self->priv->persistent_apps_list_length1 = 0;
	self->priv->_persistent_apps_list_size_ = self->priv->persistent_apps_list_length1;
	self->priv->transient_apps_list = (_vala_array_free (self->priv->transient_apps_list, self->priv->transient_apps_list_length1, (GDestroyNotify) g_free), NULL);
	self->priv->transient_apps_list = NULL;
	self->priv->transient_apps_list_length1 = 0;
	self->priv->_transient_apps_list_size_ = self->priv->transient_apps_list_length1;
}

/**
 * Add a new item for the given uri to the dock
 *
 * @param uri an URI
 * @return whether it was successfully added
 */
gboolean
plank_dbus_client_add_item (PlankDBusClient* self,
                            const gchar* uri)
{
	PlankDBusItemsIface* _tmp0_;
	gboolean _tmp5_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->items_proxy;
	if (_tmp0_ == NULL) {
		g_warning ("Client.vala:203: No proxy connected");
		result = FALSE;
		return result;
	}
	{
		gboolean _tmp1_ = FALSE;
		PlankDBusItemsIface* _tmp2_;
		_tmp2_ = self->priv->items_proxy;
		_tmp1_ = plank_dbus_items_iface_add (_tmp2_, uri, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp1_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Client.vala:210: %s", _tmp4_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp5_;
}

/**
 * Remove an existing item for the given uri from the dock
 *
 * @param uri an URI
 * @return whether it was successfully removed
 */
gboolean
plank_dbus_client_remove_item (PlankDBusClient* self,
                               const gchar* uri)
{
	PlankDBusItemsIface* _tmp0_;
	gboolean _tmp5_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->items_proxy;
	if (_tmp0_ == NULL) {
		g_warning ("Client.vala:224: No proxy connected");
		result = FALSE;
		return result;
	}
	{
		gboolean _tmp1_ = FALSE;
		PlankDBusItemsIface* _tmp2_;
		_tmp2_ = self->priv->items_proxy;
		_tmp1_ = plank_dbus_items_iface_remove (_tmp2_, uri, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp1_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Client.vala:231: %s", _tmp4_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp5_;
}

/**
 * Returns the number of currently visible items on the dock
 *
 * @return the item-count
 */
gint
plank_dbus_client_get_items_count (PlankDBusClient* self)
{
	PlankDBusItemsIface* _tmp0_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->items_proxy;
	if (_tmp0_ == NULL) {
		g_warning ("Client.vala:244: No proxy connected");
		result = -1;
		return result;
	}
	{
		if (self->priv->items_count == G_MININT) {
			gint _tmp1_ = 0;
			PlankDBusItemsIface* _tmp2_;
			_tmp2_ = self->priv->items_proxy;
			_tmp1_ = plank_dbus_items_iface_get_count (_tmp2_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			self->priv->items_count = _tmp1_;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Client.vala:252: %s", _tmp4_);
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp5_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = self->priv->items_count;
	return result;
}

/**
 * Returns an array of uris of the persistent applications on the dock
 *
 * @return the array of uris
 */
gchar**
plank_dbus_client_get_persistent_applications (PlankDBusClient* self,
                                               gint* result_length1)
{
	PlankDBusItemsIface* _tmp0_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->items_proxy;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gint _tmp1__length1;
		g_warning ("Client.vala:267: No proxy connected");
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->persistent_apps_list;
	_tmp2__length1 = self->priv->persistent_apps_list_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = self->priv->persistent_apps_list;
		_tmp3__length1 = self->priv->persistent_apps_list_length1;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _tmp3__length1;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	{
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp5_ = self->priv->persistent_apps_list;
		_tmp5__length1 = self->priv->persistent_apps_list_length1;
		if (_tmp5_ == NULL) {
			gchar** _tmp6_ = NULL;
			PlankDBusItemsIface* _tmp7_;
			gint _tmp8_ = 0;
			gchar** _tmp9_;
			gint _tmp6__length1;
			gint __tmp6__size_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			_tmp7_ = self->priv->items_proxy;
			_tmp9_ = plank_dbus_items_iface_get_persistent_applications (_tmp7_, &_tmp8_, &_inner_error0_);
			_tmp6_ = _tmp9_;
			_tmp6__length1 = _tmp8_;
			__tmp6__size_ = _tmp6__length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp6_;
			_tmp10__length1 = _tmp6__length1;
			_tmp6_ = NULL;
			_tmp6__length1 = 0;
			self->priv->persistent_apps_list = (_vala_array_free (self->priv->persistent_apps_list, self->priv->persistent_apps_list_length1, (GDestroyNotify) g_free), NULL);
			self->priv->persistent_apps_list = _tmp10_;
			self->priv->persistent_apps_list_length1 = _tmp10__length1;
			self->priv->_persistent_apps_list_size_ = self->priv->persistent_apps_list_length1;
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp11_ = self->priv->persistent_apps_list;
		_tmp11__length1 = self->priv->persistent_apps_list_length1;
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _tmp11__length1;
		if (result_length1) {
			*result_length1 = _tmp12__length1;
		}
		result = _tmp12_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("Client.vala:279: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp15_ = NULL;
	_tmp15__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}

/**
 * Returns an array of uris of the transient applications on the dock
 *
 * @return the array of uris
 */
gchar**
plank_dbus_client_get_transient_applications (PlankDBusClient* self,
                                              gint* result_length1)
{
	PlankDBusItemsIface* _tmp0_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->items_proxy;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gint _tmp1__length1;
		g_warning ("Client.vala:293: No proxy connected");
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->transient_apps_list;
	_tmp2__length1 = self->priv->transient_apps_list_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = self->priv->transient_apps_list;
		_tmp3__length1 = self->priv->transient_apps_list_length1;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _tmp3__length1;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	{
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp5_ = self->priv->transient_apps_list;
		_tmp5__length1 = self->priv->transient_apps_list_length1;
		if (_tmp5_ == NULL) {
			gchar** _tmp6_ = NULL;
			PlankDBusItemsIface* _tmp7_;
			gint _tmp8_ = 0;
			gchar** _tmp9_;
			gint _tmp6__length1;
			gint __tmp6__size_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			_tmp7_ = self->priv->items_proxy;
			_tmp9_ = plank_dbus_items_iface_get_transient_applications (_tmp7_, &_tmp8_, &_inner_error0_);
			_tmp6_ = _tmp9_;
			_tmp6__length1 = _tmp8_;
			__tmp6__size_ = _tmp6__length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp6_;
			_tmp10__length1 = _tmp6__length1;
			_tmp6_ = NULL;
			_tmp6__length1 = 0;
			self->priv->transient_apps_list = (_vala_array_free (self->priv->transient_apps_list, self->priv->transient_apps_list_length1, (GDestroyNotify) g_free), NULL);
			self->priv->transient_apps_list = _tmp10_;
			self->priv->transient_apps_list_length1 = _tmp10__length1;
			self->priv->_transient_apps_list_size_ = self->priv->transient_apps_list_length1;
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp11_ = self->priv->transient_apps_list;
		_tmp11__length1 = self->priv->transient_apps_list_length1;
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _tmp11__length1;
		if (result_length1) {
			*result_length1 = _tmp12__length1;
		}
		result = _tmp12_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("Client.vala:305: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp15_ = NULL;
	_tmp15__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}

/**
 * Gets the x,y coords with the dock's position to display a hover window for an item.
 *
 * @param uri an URI
 * @param x the resulting x position
 * @param y the resulting y position
 * @param dock_position the position of the dock
 * @return whether it was successfully retrieved
 */
gboolean
plank_dbus_client_get_hover_position (PlankDBusClient* self,
                                      const gchar* uri,
                                      gint* x,
                                      gint* y,
                                      GtkPositionType* dock_position)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	GtkPositionType _vala_dock_position = 0;
	PlankDBusItemsIface* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->items_proxy;
	if (_tmp0_ == NULL) {
		g_warning ("Client.vala:323: No proxy connected");
		_vala_y = -1;
		_vala_x = _vala_y;
		_vala_dock_position = 0;
		result = FALSE;
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		if (dock_position) {
			*dock_position = _vala_dock_position;
		}
		return result;
	}
	{
		gboolean _tmp1_ = FALSE;
		PlankDBusItemsIface* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GtkPositionType _tmp5_ = 0;
		gboolean _tmp6_;
		_tmp2_ = self->priv->items_proxy;
		_tmp6_ = plank_dbus_items_iface_get_hover_position (_tmp2_, uri, &_tmp3_, &_tmp4_, &_tmp5_, &_inner_error0_);
		_vala_x = _tmp3_;
		_vala_y = _tmp4_;
		_vala_dock_position = _tmp5_;
		_tmp1_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp1_;
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		if (dock_position) {
			*dock_position = _vala_dock_position;
		}
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("Client.vala:332: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = FALSE;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (dock_position) {
		*dock_position = _vala_dock_position;
	}
	return result;
}

gboolean
plank_dbus_client_get_is_connected (PlankDBusClient* self)
{
	gboolean result;
	PlankDBusItemsIface* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->items_proxy;
	result = _tmp0_ != NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
plank_dbus_client_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankDBusClient * self;
	GApplication* application = NULL;
	GApplication* _tmp0_;
	gchar* object_path = NULL;
	GApplication* _tmp1_;
	gboolean _tmp8_ = FALSE;
	GDBusConnection* _tmp9_;
	GDBusConnection* _tmp14_;
	gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (plank_dbus_client_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DBUS_CLIENT, PlankDBusClient);
	_tmp0_ = g_application_get_default ();
	application = _tmp0_;
	object_path = NULL;
	_tmp1_ = application;
	if (_tmp1_ != NULL) {
		GApplication* _tmp2_;
		GDBusConnection* _tmp3_;
		GDBusConnection* _tmp4_;
		GApplication* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = application;
		_tmp3_ = g_application_get_dbus_connection (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = _tmp4_;
		_tmp5_ = application;
		_tmp6_ = g_application_get_dbus_object_path (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (object_path);
		object_path = _tmp7_;
	}
	_tmp9_ = self->priv->connection;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = object_path;
		_tmp8_ = _tmp10_ == NULL;
	}
	if (_tmp8_) {
		g_critical ("Client.vala:88: Initializing client failed");
		_g_free0 (object_path);
		return obj;
	}
	{
		GDBusConnection* _tmp11_;
		_tmp11_ = self->priv->connection;
		self->priv->dbus_dock_ping_id = g_dbus_connection_signal_subscribe (_tmp11_, NULL, PLANK_DBUS_DOCK_INTERFACE_NAME, PLANK_DBUS_PING_NAME, NULL, NULL, G_DBUS_SIGNAL_FLAGS_NONE, (GDBusSignalCallback) plank_dbus_client_handle_dock_ping, g_object_ref (self), g_object_unref);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("Client.vala:97: Could not subscribe for dock signal (%s)", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (object_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp14_ = self->priv->connection;
	self->priv->dbus_name_owner_changed_signal_id = g_dbus_connection_signal_subscribe (_tmp14_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, G_DBUS_SIGNAL_FLAGS_NONE, (GDBusSignalCallback) plank_dbus_client_handle_name_owner_changed, g_object_ref (self), g_object_unref);
	_tmp15_ = object_path;
	object_path = NULL;
	_g_free0 (self->priv->client_object_path);
	self->priv->client_object_path = _tmp15_;
	{
		GDBusConnection* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = self->priv->connection;
		_tmp17_ = self->priv->client_object_path;
		g_dbus_connection_emit_signal (_tmp16_, NULL, _tmp17_, PLANK_DBUS_CLIENT_INTERFACE_NAME, PLANK_DBUS_PING_NAME, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("Client.vala:109: Could not ping running docks (%s)", _tmp19_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (object_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_free0 (object_path);
	return obj;
}

static void
plank_dbus_client_class_init (PlankDBusClientClass * klass,
                              gpointer klass_data)
{
	plank_dbus_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDBusClient_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dbus_client_get_property;
	G_OBJECT_CLASS (klass)->constructor = plank_dbus_client_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_dbus_client_finalize;
	/**
	 * Whether the client is in an operatable state and connected to
	 * a running dock
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DBUS_CLIENT_IS_CONNECTED_PROPERTY, plank_dbus_client_properties[PLANK_DBUS_CLIENT_IS_CONNECTED_PROPERTY] = g_param_spec_boolean ("is-connected", "is-connected", "is-connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * If the proxy interfaces for the dock are ready to be used
	 * or were changed on runtime this signal will be emitted.
	 */
	plank_dbus_client_signals[PLANK_DBUS_CLIENT_PROXY_CHANGED_SIGNAL] = g_signal_new ("proxy-changed", PLANK_TYPE_DBUS_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
plank_dbus_client_instance_init (PlankDBusClient * self,
                                 gpointer klass)
{
	self->priv = plank_dbus_client_get_instance_private (self);
	self->priv->connection = NULL;
	self->priv->dbus_dock_ping_id = (guint) 0;
	self->priv->dbus_name_owner_changed_signal_id = (guint) 0;
	self->priv->items_proxy = NULL;
	self->priv->items_count = G_MININT;
	self->priv->persistent_apps_list = NULL;
	self->priv->persistent_apps_list_length1 = 0;
	self->priv->_persistent_apps_list_size_ = self->priv->persistent_apps_list_length1;
	self->priv->transient_apps_list = NULL;
	self->priv->transient_apps_list_length1 = 0;
	self->priv->_transient_apps_list_size_ = self->priv->transient_apps_list_length1;
}

static void
plank_dbus_client_finalize (GObject * obj)
{
	PlankDBusClient * self;
	GDBusConnection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DBUS_CLIENT, PlankDBusClient);
	_tmp0_ = self->priv->connection;
	if (_tmp0_ != NULL) {
		if (self->priv->dbus_dock_ping_id > ((guint) 0)) {
			GDBusConnection* _tmp1_;
			_tmp1_ = self->priv->connection;
			g_dbus_connection_signal_unsubscribe (_tmp1_, self->priv->dbus_dock_ping_id);
		}
		if (self->priv->dbus_name_owner_changed_signal_id > ((guint) 0)) {
			GDBusConnection* _tmp2_;
			_tmp2_ = self->priv->connection;
			g_dbus_connection_signal_unsubscribe (_tmp2_, self->priv->dbus_name_owner_changed_signal_id);
		}
	}
	_g_object_unref0 (self->priv->connection);
	_g_free0 (self->priv->client_object_path);
	_g_free0 (self->priv->dock_bus_owner);
	_g_free0 (self->priv->dock_bus_name);
	_g_free0 (self->priv->dock_object_path);
	_g_object_unref0 (self->priv->items_proxy);
	self->priv->persistent_apps_list = (_vala_array_free (self->priv->persistent_apps_list, self->priv->persistent_apps_list_length1, (GDestroyNotify) g_free), NULL);
	self->priv->transient_apps_list = (_vala_array_free (self->priv->transient_apps_list, self->priv->transient_apps_list_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (plank_dbus_client_parent_class)->finalize (obj);
}

/**
 * Connects to a running instance of plank via DBus and
 * provides remote interface to a currently runnning dock.
 */
static GType
plank_dbus_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDBusClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dbus_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDBusClient), 0, (GInstanceInitFunc) plank_dbus_client_instance_init, NULL };
	GType plank_dbus_client_type_id;
	plank_dbus_client_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankDBusClient", &g_define_type_info, 0);
	PlankDBusClient_private_offset = g_type_add_instance_private (plank_dbus_client_type_id, sizeof (PlankDBusClientPrivate));
	return plank_dbus_client_type_id;
}

GType
plank_dbus_client_get_type (void)
{
	static volatile gsize plank_dbus_client_type_id__once = 0;
	if (g_once_init_enter (&plank_dbus_client_type_id__once)) {
		GType plank_dbus_client_type_id;
		plank_dbus_client_type_id = plank_dbus_client_get_type_once ();
		g_once_init_leave (&plank_dbus_client_type_id__once, plank_dbus_client_type_id);
	}
	return plank_dbus_client_type_id__once;
}

static void
_vala_plank_dbus_client_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	PlankDBusClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DBUS_CLIENT, PlankDBusClient);
	switch (property_id) {
		case PLANK_DBUS_CLIENT_IS_CONNECTED_PROPERTY:
		g_value_set_boolean (value, plank_dbus_client_get_is_connected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

