/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.13.1
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qbitarray.sip"
#include <qbitarray.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQBitArray.cpp"

#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qsysinfo.sip"
#include <qsysinfo.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQBitArray.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qbitarray.sip"
// This is needed by __hash__().
#include <qhash.h>
#line 37 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQBitArray.cpp"


PyDoc_STRVAR(doc_QBitArray_size, "size(self) -> int");

extern "C" {static PyObject *meth_QBitArray_size(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBitArray, &sipCpp))
        {
            ::qsizetype sipRes;

            sipRes = sipCpp->size();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_size, doc_QBitArray_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_count, "count(self) -> int\n"
"count(self, on: bool) -> int");

extern "C" {static PyObject *meth_QBitArray_count(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_count(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBitArray, &sipCpp))
        {
            ::qsizetype sipRes;

            sipRes = sipCpp->count();

            return PyLong_FromLongLong(sipRes);
        }
    }

    {
        bool a0;
        const ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QBitArray, &sipCpp, &a0))
        {
            ::qsizetype sipRes;

            sipRes = sipCpp->count(a0);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_count, doc_QBitArray_count);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_isEmpty, "isEmpty(self) -> bool");

extern "C" {static PyObject *meth_QBitArray_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBitArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isEmpty();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_isEmpty, doc_QBitArray_isEmpty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QBitArray_isNull(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBitArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_isNull, doc_QBitArray_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_resize, "resize(self, size: int)");

extern "C" {static PyObject *meth_QBitArray_resize(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_resize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QBitArray, &sipCpp, &a0))
        {
            sipCpp->resize(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_resize, doc_QBitArray_resize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_detach, "detach(self)");

extern "C" {static PyObject *meth_QBitArray_detach(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_detach(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBitArray, &sipCpp))
        {
            sipCpp->detach();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_detach, doc_QBitArray_detach);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_isDetached, "isDetached(self) -> bool");

extern "C" {static PyObject *meth_QBitArray_isDetached(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_isDetached(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBitArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isDetached();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_isDetached, doc_QBitArray_isDetached);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_clear, "clear(self)");

extern "C" {static PyObject *meth_QBitArray_clear(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBitArray, &sipCpp))
        {
            sipCpp->clear();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_clear, doc_QBitArray_clear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_fill, "fill(self, val: bool, first: int, last: int)\n"
"fill(self, val: bool, size: int = -1) -> bool");

extern "C" {static PyObject *meth_QBitArray_fill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QBitArray_fill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::qsizetype a1;
        ::qsizetype a2;
        ::QBitArray *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "Bbnn", &sipSelf, sipType_QBitArray, &sipCpp, &a0, &a1, &a2))
        {
            sipCpp->fill(a0, a1, a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        bool a0;
        ::qsizetype a1 = -1;
        ::QBitArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb|n", &sipSelf, sipType_QBitArray, &sipCpp, &a0, &a1))
        {
            bool sipRes;

            sipRes = sipCpp->fill(a0, a1);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_fill, doc_QBitArray_fill);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_truncate, "truncate(self, pos: int)");

extern "C" {static PyObject *meth_QBitArray_truncate(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_truncate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QBitArray, &sipCpp, &a0))
        {
            sipCpp->truncate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_truncate, doc_QBitArray_truncate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_testBit, "testBit(self, i: int) -> bool");

extern "C" {static PyObject *meth_QBitArray_testBit(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_testBit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        const ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QBitArray, &sipCpp, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->testBit(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_testBit, doc_QBitArray_testBit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_setBit, "setBit(self, i: int)\n"
"setBit(self, i: int, val: bool)");

extern "C" {static PyObject *meth_QBitArray_setBit(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_setBit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QBitArray, &sipCpp, &a0))
        {
            sipCpp->setBit(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::qsizetype a0;
        bool a1;
        ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bnb", &sipSelf, sipType_QBitArray, &sipCpp, &a0, &a1))
        {
            sipCpp->setBit(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_setBit, doc_QBitArray_setBit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_clearBit, "clearBit(self, i: int)");

extern "C" {static PyObject *meth_QBitArray_clearBit(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_clearBit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QBitArray, &sipCpp, &a0))
        {
            sipCpp->clearBit(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_clearBit, doc_QBitArray_clearBit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_toggleBit, "toggleBit(self, i: int) -> bool");

extern "C" {static PyObject *meth_QBitArray_toggleBit(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_toggleBit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QBitArray, &sipCpp, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->toggleBit(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_toggleBit, doc_QBitArray_toggleBit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_at, "at(self, i: int) -> bool");

extern "C" {static PyObject *meth_QBitArray_at(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_at(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;
        const ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QBitArray, &sipCpp, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->at(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_at, doc_QBitArray_at);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_swap, "swap(self, other: QBitArray)");

extern "C" {static PyObject *meth_QBitArray_swap(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBitArray* a0;
        ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QBitArray, &sipCpp, sipType_QBitArray, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_swap, doc_QBitArray_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_bits, "bits(self) -> bytes");

extern "C" {static PyObject *meth_QBitArray_bits(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_bits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBitArray, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 78 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qbitarray.sip"
        return PyBytes_FromStringAndSize(sipCpp->bits(), (sipCpp->size() + 7) / 8);
#line 526 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQBitArray.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_bits, doc_QBitArray_bits);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_fromBits, "fromBits(data: Optional[bytes], len: int) -> QBitArray");

extern "C" {static PyObject *meth_QBitArray_fromBits(PyObject *, PyObject *);}
static PyObject *meth_QBitArray_fromBits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        Py_ssize_t a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "Cs", &sipSelf, &a0, &a1))
        {
            ::QBitArray*sipRes;

            sipRes = new ::QBitArray(::QBitArray::fromBits(a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QBitArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_fromBits, doc_QBitArray_fromBits);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBitArray_toUInt32, "toUInt32(self, endianness: QSysInfo.Endian) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QBitArray_toUInt32(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QBitArray_toUInt32(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSysInfo::Endian a0;
        bool a1;
        const ::QBitArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_QBitArray, &sipCpp, sipType_QSysInfo_Endian, &a0))
        {
            ::quint32 sipRes;

            sipRes = sipCpp->toUInt32(a0, &a1);

            return sipBuildResult(0, "(ub)", sipRes, a1);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName_toUInt32, doc_QBitArray_toUInt32);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QBitArray___or__(PyObject *, PyObject *);}
static PyObject *slot_QBitArray___or__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray* a0;
        const ::QBitArray* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QBitArray, &a0, sipType_QBitArray, &a1))
        {
            ::QBitArray*sipRes;

            sipRes = new ::QBitArray((*a0 | *a1));

            return sipConvertFromNewType(sipRes, sipType_QBitArray, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, or_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QBitArray___eq__(PyObject *, PyObject *);}
static PyObject *slot_QBitArray___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBitArray *sipCpp = reinterpret_cast< ::QBitArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBitArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBitArray, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QBitArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QBitArray___ne__(PyObject *, PyObject *);}
static PyObject *slot_QBitArray___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBitArray *sipCpp = reinterpret_cast< ::QBitArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBitArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBitArray, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QBitArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QBitArray___and__(PyObject *, PyObject *);}
static PyObject *slot_QBitArray___and__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray* a0;
        const ::QBitArray* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QBitArray, &a0, sipType_QBitArray, &a1))
        {
            ::QBitArray*sipRes;

            sipRes = new ::QBitArray((*a0 & *a1));

            return sipConvertFromNewType(sipRes, sipType_QBitArray, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, and_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QBitArray___xor__(PyObject *, PyObject *);}
static PyObject *slot_QBitArray___xor__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray* a0;
        const ::QBitArray* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QBitArray, &a0, sipType_QBitArray, &a1))
        {
            ::QBitArray*sipRes;

            sipRes = new ::QBitArray((*a0 ^ *a1));

            return sipConvertFromNewType(sipRes, sipType_QBitArray, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, xor_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static Py_hash_t slot_QBitArray___hash__(PyObject *);}
static Py_hash_t slot_QBitArray___hash__(PyObject *sipSelf)
{
    ::QBitArray *sipCpp = reinterpret_cast< ::QBitArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBitArray));

    if (!sipCpp)
        return 0;


    {
        {
            Py_hash_t sipRes = 0;

#line 72 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qbitarray.sip"
        sipRes = qHash(*sipCpp);
#line 754 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQBitArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QBitArray___getitem__(PyObject *, PyObject *);}
static PyObject *slot_QBitArray___getitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBitArray *sipCpp = reinterpret_cast< ::QBitArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBitArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qsizetype a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1n", &a0))
        {
            bool sipRes;

            if (a0 < 0 || a0 >= sipCpp->count())
            {
                PyErr_SetNone(PyExc_IndexError);
                return SIP_NULLPTR;
            }

            sipRes = (*sipCpp)[a0];

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBitArray, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QBitArray___ixor__(PyObject *, PyObject *);}
static PyObject *slot_QBitArray___ixor__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QBitArray)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QBitArray *sipCpp = reinterpret_cast< ::QBitArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBitArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBitArray, &a0))
        {
            sipCpp->::QBitArray::operator^=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QBitArray___ior__(PyObject *, PyObject *);}
static PyObject *slot_QBitArray___ior__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QBitArray)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QBitArray *sipCpp = reinterpret_cast< ::QBitArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBitArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBitArray, &a0))
        {
            sipCpp->::QBitArray::operator|=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QBitArray___iand__(PyObject *, PyObject *);}
static PyObject *slot_QBitArray___iand__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QBitArray)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QBitArray *sipCpp = reinterpret_cast< ::QBitArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBitArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBitArray* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBitArray, &a0))
        {
            sipCpp->::QBitArray::operator&=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static Py_ssize_t slot_QBitArray___len__(PyObject *);}
static Py_ssize_t slot_QBitArray___len__(PyObject *sipSelf)
{
    ::QBitArray *sipCpp = reinterpret_cast< ::QBitArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBitArray));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->count();
#line 934 "/build/pyqt6/src/pyqt6-6.10.0/build/QtCore/sipQtCoreQBitArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QBitArray(void *, int);}
static void release_QBitArray(void *sipCppV, int)
{
    delete reinterpret_cast< ::QBitArray *>(sipCppV);
}


extern "C" {static void *array_QBitArray(Py_ssize_t);}
static void *array_QBitArray(Py_ssize_t sipNrElem)
{
    return new ::QBitArray[sipNrElem];
}


extern "C" {static void array_delete_QBitArray(void *);}
static void array_delete_QBitArray(void *sipCpp)
{
    delete[] reinterpret_cast< ::QBitArray *>(sipCpp);
}


extern "C" {static void assign_QBitArray(void *, Py_ssize_t, void *);}
static void assign_QBitArray(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QBitArray *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QBitArray *>(sipSrc);
}


extern "C" {static void *copy_QBitArray(const void *, Py_ssize_t);}
static void *copy_QBitArray(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QBitArray(reinterpret_cast<const ::QBitArray *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QBitArray(sipSimpleWrapper *);}
static void dealloc_QBitArray(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QBitArray(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QBitArray(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QBitArray(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QBitArray *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QBitArray();

            return sipCpp;
        }
    }

    {
        ::qsizetype a0;
        bool a1 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_value,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "n|b", &a0, &a1))
        {
            sipCpp = new ::QBitArray(a0, a1);

            return sipCpp;
        }
    }

    {
        const ::QBitArray* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QBitArray, &a0))
        {
            sipCpp = new ::QBitArray(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QBitArray[] = {
    {(void *)slot_QBitArray___or__, or_slot},
    {(void *)slot_QBitArray___eq__, eq_slot},
    {(void *)slot_QBitArray___ne__, ne_slot},
    {(void *)slot_QBitArray___and__, and_slot},
    {(void *)slot_QBitArray___xor__, xor_slot},
    {(void *)slot_QBitArray___hash__, hash_slot},
    {(void *)slot_QBitArray___getitem__, getitem_slot},
    {(void *)slot_QBitArray___ixor__, ixor_slot},
    {(void *)slot_QBitArray___ior__, ior_slot},
    {(void *)slot_QBitArray___iand__, iand_slot},
    {(void *)slot_QBitArray___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QBitArray[] = {
    {sipName_at, meth_QBitArray_at, METH_VARARGS, doc_QBitArray_at},
    {sipName_bits, meth_QBitArray_bits, METH_VARARGS, doc_QBitArray_bits},
    {sipName_clear, meth_QBitArray_clear, METH_VARARGS, doc_QBitArray_clear},
    {sipName_clearBit, meth_QBitArray_clearBit, METH_VARARGS, doc_QBitArray_clearBit},
    {sipName_count, meth_QBitArray_count, METH_VARARGS, doc_QBitArray_count},
    {sipName_detach, meth_QBitArray_detach, METH_VARARGS, doc_QBitArray_detach},
    {sipName_fill, SIP_MLMETH_CAST(meth_QBitArray_fill), METH_VARARGS|METH_KEYWORDS, doc_QBitArray_fill},
    {sipName_fromBits, meth_QBitArray_fromBits, METH_VARARGS, doc_QBitArray_fromBits},
    {sipName_isDetached, meth_QBitArray_isDetached, METH_VARARGS, doc_QBitArray_isDetached},
    {sipName_isEmpty, meth_QBitArray_isEmpty, METH_VARARGS, doc_QBitArray_isEmpty},
    {sipName_isNull, meth_QBitArray_isNull, METH_VARARGS, doc_QBitArray_isNull},
    {sipName_resize, meth_QBitArray_resize, METH_VARARGS, doc_QBitArray_resize},
    {sipName_setBit, meth_QBitArray_setBit, METH_VARARGS, doc_QBitArray_setBit},
    {sipName_size, meth_QBitArray_size, METH_VARARGS, doc_QBitArray_size},
    {sipName_swap, meth_QBitArray_swap, METH_VARARGS, doc_QBitArray_swap},
    {sipName_testBit, meth_QBitArray_testBit, METH_VARARGS, doc_QBitArray_testBit},
    {sipName_toUInt32, SIP_MLMETH_CAST(meth_QBitArray_toUInt32), METH_VARARGS|METH_KEYWORDS, doc_QBitArray_toUInt32},
    {sipName_toggleBit, meth_QBitArray_toggleBit, METH_VARARGS, doc_QBitArray_toggleBit},
    {sipName_truncate, meth_QBitArray_truncate, METH_VARARGS, doc_QBitArray_truncate}
};

PyDoc_STRVAR(doc_QBitArray, "\1QBitArray()\n"
"QBitArray(size: int, value: bool = False)\n"
"QBitArray(other: QBitArray)");


sipClassTypeDef sipTypeDef_QtCore_QBitArray = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QBitArray,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QBitArray,
        {0, 0, 1},
        19, methods_QBitArray,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QBitArray,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QBitArray,
    init_type_QBitArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QBitArray,
    assign_QBitArray,
    array_QBitArray,
    copy_QBitArray,
    release_QBitArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QBitArray,
    sizeof (::QBitArray),
};
