/* DLNAPage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DLNAPage.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2016-2023 elementary, Inc. (https://elementary.io)
 */

#include "io.elementary.settings.sharing.h"
#include <glib-object.h>
#include <glib.h>
#include <switchboard.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SHARING_WIDGETS_DLNA_PAGE_0_PROPERTY,
	SHARING_WIDGETS_DLNA_PAGE_NUM_PROPERTIES
};
static GParamSpec* sharing_widgets_dlna_page_properties[SHARING_WIDGETS_DLNA_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY (sharing_widgets_dlna_page_media_entry_get_type ())
#define SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY, SharingWidgetsDLNAPageMediaEntry))
#define SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY, SharingWidgetsDLNAPageMediaEntryClass))
#define SHARING_WIDGETS_DLNA_PAGE_IS_MEDIA_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY))
#define SHARING_WIDGETS_DLNA_PAGE_IS_MEDIA_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY))
#define SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY, SharingWidgetsDLNAPageMediaEntryClass))

typedef struct _SharingWidgetsDLNAPageMediaEntry SharingWidgetsDLNAPageMediaEntry;
typedef struct _SharingWidgetsDLNAPageMediaEntryClass SharingWidgetsDLNAPageMediaEntryClass;
typedef struct _SharingWidgetsDLNAPageMediaEntryPrivate SharingWidgetsDLNAPageMediaEntryPrivate;
enum  {
	SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_0_PROPERTY,
	SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_LABEL_PROPERTY,
	SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_MEDIA_TYPE_PROPERTY,
	SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_CONFIG_FILE_PROPERTY,
	SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_NUM_PROPERTIES
};
static GParamSpec* sharing_widgets_dlna_page_media_entry_properties[SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SharingWidgetsDLNAPagePrivate {
	SharingBackendRygelStartupManager* rygel_startup_manager;
	SharingBackendRygelConfigFile* rygel_config_file;
};

struct _SharingWidgetsDLNAPageMediaEntry {
	GtkGrid parent_instance;
	SharingWidgetsDLNAPageMediaEntryPrivate * priv;
};

struct _SharingWidgetsDLNAPageMediaEntryClass {
	GtkGridClass parent_class;
};

struct _SharingWidgetsDLNAPageMediaEntryPrivate {
	gchar* _label;
	gchar* _media_type;
	SharingBackendRygelConfigFile* _config_file;
	GtkLabel* folder_name;
};

struct _Block1Data {
	int _ref_count_;
	SharingWidgetsDLNAPageMediaEntry* self;
	GtkCheckButton* check;
	GtkFileDialog* location_dialog;
};

static gint SharingWidgetsDLNAPage_private_offset;
static gpointer sharing_widgets_dlna_page_parent_class = NULL;
static gint SharingWidgetsDLNAPageMediaEntry_private_offset;
static gpointer sharing_widgets_dlna_page_media_entry_parent_class = NULL;

static void sharing_widgets_dlna_page_set_service_state (SharingWidgetsDLNAPage* self);
static GType sharing_widgets_dlna_page_media_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SharingWidgetsDLNAPageMediaEntry* sharing_widgets_dlna_page_media_entry_new (const gchar* media_type,
                                                                             const gchar* label,
                                                                             SharingBackendRygelConfigFile* config_file);
static SharingWidgetsDLNAPageMediaEntry* sharing_widgets_dlna_page_media_entry_construct (GType object_type,
                                                                                   const gchar* media_type,
                                                                                   const gchar* label,
                                                                                   SharingBackendRygelConfigFile* config_file);
static gchar* sharing_widgets_dlna_page_media_entry_replace_xdg_folders (SharingWidgetsDLNAPageMediaEntry* self,
                                                                  const gchar* folder_path);
static const gchar* sharing_widgets_dlna_page_media_entry_get_label (SharingWidgetsDLNAPageMediaEntry* self);
static void sharing_widgets_dlna_page_media_entry_set_label (SharingWidgetsDLNAPageMediaEntry* self,
                                                      const gchar* value);
static const gchar* sharing_widgets_dlna_page_media_entry_get_media_type (SharingWidgetsDLNAPageMediaEntry* self);
static void sharing_widgets_dlna_page_media_entry_set_media_type (SharingWidgetsDLNAPageMediaEntry* self,
                                                           const gchar* value);
static SharingBackendRygelConfigFile* sharing_widgets_dlna_page_media_entry_get_config_file (SharingWidgetsDLNAPageMediaEntry* self);
static void sharing_widgets_dlna_page_media_entry_set_config_file (SharingWidgetsDLNAPageMediaEntry* self,
                                                            SharingBackendRygelConfigFile* value);
static GObject * sharing_widgets_dlna_page_media_entry_constructor (GType type,
                                                             guint n_construct_properties,
                                                             GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _sharing_widgets_dlna_page_media_entry___lambda4_ (Block1Data* _data1_);
static void __sharing_widgets_dlna_page_media_entry___lambda4__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                                  gpointer self);
static void _sharing_widgets_dlna_page_media_entry___lambda5_ (Block1Data* _data1_);
static void __lambda6_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void __sharing_widgets_dlna_page_media_entry___lambda5__gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void sharing_widgets_dlna_page_media_entry_finalize (GObject * obj);
static GType sharing_widgets_dlna_page_media_entry_get_type_once (void);
static void _vala_sharing_widgets_dlna_page_media_entry_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_sharing_widgets_dlna_page_media_entry_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static GObject * sharing_widgets_dlna_page_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _sharing_widgets_dlna_page___lambda7_ (SharingWidgetsDLNAPage* self);
static void __sharing_widgets_dlna_page___lambda7__g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void sharing_widgets_dlna_page_finalize (GObject * obj);
static GType sharing_widgets_dlna_page_get_type_once (void);

static inline gpointer
sharing_widgets_dlna_page_get_instance_private (SharingWidgetsDLNAPage* self)
{
	return G_STRUCT_MEMBER_P (self, SharingWidgetsDLNAPage_private_offset);
}

SharingWidgetsDLNAPage*
sharing_widgets_dlna_page_construct (GType object_type)
{
	SharingWidgetsDLNAPage * self = NULL;
	self = (SharingWidgetsDLNAPage*) g_object_new (object_type, "activatable", TRUE, NULL);
	return self;
}

SharingWidgetsDLNAPage*
sharing_widgets_dlna_page_new (void)
{
	return sharing_widgets_dlna_page_construct (SHARING_WIDGETS_TYPE_DLNA_PAGE);
}

static void
sharing_widgets_dlna_page_set_service_state (SharingWidgetsDLNAPage* self)
{
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		switchboard_settings_page_set_description ((SwitchboardSettingsPage*) self, _ ("The selected libraries are available to stream on compatible DLNA-enab" \
"led devices on your local network such as TVs and game consoles."));
		switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _ ("Enabled"));
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS);
	} else {
		switchboard_settings_page_set_description ((SwitchboardSettingsPage*) self, _ ("Media libraries are currently unshared and can't be streamed to other " \
"devices."));
		switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _ ("Disabled"));
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE);
	}
}

static inline gpointer
sharing_widgets_dlna_page_media_entry_get_instance_private (SharingWidgetsDLNAPageMediaEntry* self)
{
	return G_STRUCT_MEMBER_P (self, SharingWidgetsDLNAPageMediaEntry_private_offset);
}

static SharingWidgetsDLNAPageMediaEntry*
sharing_widgets_dlna_page_media_entry_construct (GType object_type,
                                                 const gchar* media_type,
                                                 const gchar* label,
                                                 SharingBackendRygelConfigFile* config_file)
{
	SharingWidgetsDLNAPageMediaEntry * self = NULL;
	g_return_val_if_fail (media_type != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (config_file != NULL, NULL);
	self = (SharingWidgetsDLNAPageMediaEntry*) g_object_new (object_type, "config-file", config_file, "media-type", media_type, "label", label, NULL);
	return self;
}

static SharingWidgetsDLNAPageMediaEntry*
sharing_widgets_dlna_page_media_entry_new (const gchar* media_type,
                                           const gchar* label,
                                           SharingBackendRygelConfigFile* config_file)
{
	return sharing_widgets_dlna_page_media_entry_construct (SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY, media_type, label, config_file);
}

static gchar*
sharing_widgets_dlna_page_media_entry_replace_xdg_folders (SharingWidgetsDLNAPageMediaEntry* self,
                                                           const gchar* folder_path)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (folder_path != NULL, NULL);
	_tmp0_ = folder_path;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("@MUSIC@")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
				_tmp4_ = g_strdup (_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("@VIDEOS@")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
				_tmp6_ = g_strdup (_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("@PICTURES@")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
				_tmp8_ = g_strdup (_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup (folder_path);
				result = _tmp9_;
				return result;
			}
		}
	}
}

static const gchar*
sharing_widgets_dlna_page_media_entry_get_label (SharingWidgetsDLNAPageMediaEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
sharing_widgets_dlna_page_media_entry_set_label (SharingWidgetsDLNAPageMediaEntry* self,
                                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sharing_widgets_dlna_page_media_entry_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sharing_widgets_dlna_page_media_entry_properties[SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_LABEL_PROPERTY]);
	}
}

static const gchar*
sharing_widgets_dlna_page_media_entry_get_media_type (SharingWidgetsDLNAPageMediaEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_media_type;
	result = _tmp0_;
	return result;
}

static void
sharing_widgets_dlna_page_media_entry_set_media_type (SharingWidgetsDLNAPageMediaEntry* self,
                                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sharing_widgets_dlna_page_media_entry_get_media_type (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_media_type);
		self->priv->_media_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sharing_widgets_dlna_page_media_entry_properties[SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_MEDIA_TYPE_PROPERTY]);
	}
}

static SharingBackendRygelConfigFile*
sharing_widgets_dlna_page_media_entry_get_config_file (SharingWidgetsDLNAPageMediaEntry* self)
{
	SharingBackendRygelConfigFile* result;
	SharingBackendRygelConfigFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_config_file;
	result = _tmp0_;
	return result;
}

static void
sharing_widgets_dlna_page_media_entry_set_config_file (SharingWidgetsDLNAPageMediaEntry* self,
                                                       SharingBackendRygelConfigFile* value)
{
	SharingBackendRygelConfigFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = sharing_widgets_dlna_page_media_entry_get_config_file (self);
	if (old_value != value) {
		self->priv->_config_file = value;
		g_object_notify_by_pspec ((GObject *) self, sharing_widgets_dlna_page_media_entry_properties[SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_CONFIG_FILE_PROPERTY]);
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SharingWidgetsDLNAPageMediaEntry* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->location_dialog);
		_g_object_unref0 (_data1_->check);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_sharing_widgets_dlna_page_media_entry___lambda4_ (Block1Data* _data1_)
{
	SharingWidgetsDLNAPageMediaEntry* self;
	SharingBackendRygelConfigFile* _tmp0_;
	const gchar* _tmp1_;
	GtkCheckButton* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	SharingBackendRygelConfigFile* _tmp5_;
	self = _data1_->self;
	_tmp0_ = self->priv->_config_file;
	_tmp1_ = self->priv->_media_type;
	_tmp2_ = _data1_->check;
	_tmp3_ = gtk_check_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	sharing_backend_rygel_config_file_set_media_type_enabled (_tmp0_, _tmp1_, _tmp4_);
	_tmp5_ = self->priv->_config_file;
	sharing_backend_rygel_config_file_save (_tmp5_);
}

static void
__sharing_widgets_dlna_page_media_entry___lambda4__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                             gpointer self)
{
	_sharing_widgets_dlna_page_media_entry___lambda4_ (self);
}

static void
__lambda6_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* res)
{
	SharingWidgetsDLNAPageMediaEntry* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		GFile* _tmp0_ = NULL;
		GtkFileDialog* _tmp1_;
		GFile* _tmp2_;
		gchar* file_path = NULL;
		gchar* _tmp3_;
		GtkLabel* _tmp4_;
		const gchar* _tmp5_;
		SharingBackendRygelConfigFile* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		SharingBackendRygelConfigFile* _tmp9_;
		_tmp1_ = _data1_->location_dialog;
		_tmp2_ = gtk_file_dialog_select_folder_finish (_tmp1_, res, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = g_file_get_path (_tmp0_);
		file_path = _tmp3_;
		_tmp4_ = self->priv->folder_name;
		_tmp5_ = file_path;
		gtk_label_set_label (_tmp4_, _tmp5_);
		_tmp6_ = self->priv->_config_file;
		_tmp7_ = self->priv->_media_type;
		_tmp8_ = file_path;
		sharing_backend_rygel_config_file_set_media_type_folder (_tmp6_, _tmp7_, _tmp8_);
		_tmp9_ = self->priv->_config_file;
		sharing_backend_rygel_config_file_save (_tmp9_);
		_g_free0 (file_path);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		if (g_error_matches (_tmp10_, gtk_dialog_error_quark (), GTK_DIALOG_ERROR_DISMISSED)) {
			_g_error_free0 (e);
			return;
		}
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("DLNAPage.vala:147: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ (self, source_object, res);
	block1_data_unref (self);
}

static void
_sharing_widgets_dlna_page_media_entry___lambda5_ (Block1Data* _data1_)
{
	SharingWidgetsDLNAPageMediaEntry* self;
	GtkFileDialog* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->location_dialog;
	gtk_file_dialog_select_folder (_tmp0_, NULL, NULL, ___lambda6__gasync_ready_callback, block1_data_ref (_data1_));
}

static void
__sharing_widgets_dlna_page_media_entry___lambda5__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	_sharing_widgets_dlna_page_media_entry___lambda5_ (self);
}

static GObject *
sharing_widgets_dlna_page_media_entry_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SharingWidgetsDLNAPageMediaEntry * self;
	Block1Data* _data1_;
	gchar* folder_dir = NULL;
	SharingBackendRygelConfigFile* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SharingBackendRygelConfigFile* _tmp6_;
	const gchar* _tmp7_;
	GtkCheckButton* _tmp8_ = NULL;
	gchar* icon_name = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GQuark _tmp13_ = 0U;
	static GQuark _tmp12_label0 = 0;
	static GQuark _tmp12_label1 = 0;
	static GQuark _tmp12_label2 = 0;
	GtkImage* image = NULL;
	const gchar* _tmp17_;
	GtkImage* _tmp18_ = NULL;
	GtkImage* _tmp19_;
	GtkCheckButton* _tmp20_;
	GraniteHeaderLabel* header = NULL;
	const gchar* _tmp21_;
	GraniteHeaderLabel* _tmp22_;
	GtkLabel* _tmp23_ = NULL;
	GtkImage* arrow = NULL;
	GtkImage* _tmp24_;
	GtkBox* location_button_box = NULL;
	GtkBox* _tmp25_;
	GtkBox* _tmp26_;
	GtkLabel* _tmp27_;
	GtkBox* _tmp28_;
	GtkImage* _tmp29_;
	GtkButton* location_button = NULL;
	GtkBox* _tmp30_;
	GtkWidget* _tmp31_;
	GtkButton* _tmp32_ = NULL;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	GtkFileDialog* _tmp36_ = NULL;
	GtkCheckButton* _tmp37_;
	GraniteHeaderLabel* _tmp38_;
	GtkButton* _tmp39_;
	GtkCheckButton* _tmp40_;
	GtkImage* _tmp41_;
	GtkCheckButton* _tmp42_;
	GtkButton* _tmp43_;
	GtkLabel* _tmp44_;
	const gchar* _tmp45_;
	parent_class = G_OBJECT_CLASS (sharing_widgets_dlna_page_media_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY, SharingWidgetsDLNAPageMediaEntry);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->_config_file;
	_tmp1_ = self->priv->_media_type;
	_tmp2_ = sharing_backend_rygel_config_file_get_media_type_folder (_tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sharing_widgets_dlna_page_media_entry_replace_xdg_folders (self, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	folder_dir = _tmp5_;
	_tmp6_ = self->priv->_config_file;
	_tmp7_ = self->priv->_media_type;
	_tmp8_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_active (_tmp8_, sharing_backend_rygel_config_file_get_media_type_enabled (_tmp6_, _tmp7_));
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp8_);
	_data1_->check = _tmp8_;
	_tmp9_ = g_strdup ("");
	icon_name = _tmp9_;
	_tmp10_ = self->priv->_media_type;
	_tmp11_ = _tmp10_;
	_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
	if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("music")))) {
		switch (0) {
			default:
			{
				gchar* _tmp14_;
				_tmp14_ = g_strdup ("audio-x-generic");
				_g_free0 (icon_name);
				icon_name = _tmp14_;
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("pictures")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				_tmp15_ = g_strdup ("image-x-generic");
				_g_free0 (icon_name);
				icon_name = _tmp15_;
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label2) ? _tmp12_label2 : (_tmp12_label2 = g_quark_from_static_string ("videos")))) {
		switch (0) {
			default:
			{
				gchar* _tmp16_;
				_tmp16_ = g_strdup ("video-x-generic");
				_g_free0 (icon_name);
				icon_name = _tmp16_;
				break;
			}
		}
	}
	_tmp17_ = icon_name;
	_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp17_);
	gtk_image_set_pixel_size (_tmp18_, 32);
	g_object_ref_sink (_tmp18_);
	image = _tmp18_;
	_tmp19_ = image;
	_tmp20_ = _data1_->check;
	gtk_widget_set_parent ((GtkWidget*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->_label;
	_tmp22_ = granite_header_label_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	header = _tmp22_;
	_tmp23_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->folder_name);
	self->priv->folder_name = _tmp23_;
	_tmp24_ = (GtkImage*) gtk_image_new_from_icon_name ("view-more-horizontal-symbolic");
	g_object_ref_sink (_tmp24_);
	arrow = _tmp24_;
	_tmp25_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp25_);
	location_button_box = _tmp25_;
	_tmp26_ = location_button_box;
	_tmp27_ = self->priv->folder_name;
	gtk_box_append (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = location_button_box;
	_tmp29_ = arrow;
	gtk_box_append (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = location_button_box;
	_tmp31_ = _g_object_ref0 ((GtkWidget*) _tmp30_);
	_tmp32_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp32_, _tmp31_);
	_g_object_unref0 (_tmp31_);
	g_object_ref_sink (_tmp32_);
	location_button = _tmp32_;
	_tmp33_ = g_strdup (_ ("Select"));
	_tmp34_ = self->priv->_label;
	_tmp35_ = g_strdup_printf ("Select %s…", _tmp34_);
	_tmp36_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_accept_label (_tmp36_, _tmp33_);
	_g_free0 (_tmp33_);
	gtk_file_dialog_set_modal (_tmp36_, TRUE);
	gtk_file_dialog_set_title (_tmp36_, _tmp35_);
	_g_free0 (_tmp35_);
	_data1_->location_dialog = _tmp36_;
	gtk_grid_set_column_spacing ((GtkGrid*) self, 6);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 3);
	_tmp37_ = _data1_->check;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp37_, 0, 0, 1, 2);
	_tmp38_ = header;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp38_, 1, 0, 1, 1);
	_tmp39_ = location_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp39_, 1, 1, 1, 1);
	_tmp40_ = _data1_->check;
	_tmp41_ = image;
	g_object_bind_property_with_closures ((GObject*) _tmp40_, "active", (GObject*) _tmp41_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp42_ = _data1_->check;
	g_signal_connect_data (_tmp42_, "toggled", (GCallback) __sharing_widgets_dlna_page_media_entry___lambda4__gtk_check_button_toggled, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp43_ = location_button;
	g_signal_connect_data (_tmp43_, "clicked", (GCallback) __sharing_widgets_dlna_page_media_entry___lambda5__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp44_ = self->priv->folder_name;
	_tmp45_ = folder_dir;
	gtk_label_set_label (_tmp44_, _tmp45_);
	_g_object_unref0 (location_button);
	_g_object_unref0 (location_button_box);
	_g_object_unref0 (arrow);
	_g_object_unref0 (header);
	_g_object_unref0 (image);
	_g_free0 (icon_name);
	_g_free0 (folder_dir);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
sharing_widgets_dlna_page_media_entry_class_init (SharingWidgetsDLNAPageMediaEntryClass * klass,
                                                  gpointer klass_data)
{
	sharing_widgets_dlna_page_media_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SharingWidgetsDLNAPageMediaEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sharing_widgets_dlna_page_media_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sharing_widgets_dlna_page_media_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = sharing_widgets_dlna_page_media_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = sharing_widgets_dlna_page_media_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_LABEL_PROPERTY, sharing_widgets_dlna_page_media_entry_properties[SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_MEDIA_TYPE_PROPERTY, sharing_widgets_dlna_page_media_entry_properties[SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_MEDIA_TYPE_PROPERTY] = g_param_spec_string ("media-type", "media-type", "media-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_CONFIG_FILE_PROPERTY, sharing_widgets_dlna_page_media_entry_properties[SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_CONFIG_FILE_PROPERTY] = g_param_spec_object ("config-file", "config-file", "config-file", SHARING_BACKEND_TYPE_RYGEL_CONFIG_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
sharing_widgets_dlna_page_media_entry_instance_init (SharingWidgetsDLNAPageMediaEntry * self,
                                                     gpointer klass)
{
	self->priv = sharing_widgets_dlna_page_media_entry_get_instance_private (self);
}

static void
sharing_widgets_dlna_page_media_entry_finalize (GObject * obj)
{
	SharingWidgetsDLNAPageMediaEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY, SharingWidgetsDLNAPageMediaEntry);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_media_type);
	_g_object_unref0 (self->priv->folder_name);
	G_OBJECT_CLASS (sharing_widgets_dlna_page_media_entry_parent_class)->finalize (obj);
}

static GType
sharing_widgets_dlna_page_media_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SharingWidgetsDLNAPageMediaEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sharing_widgets_dlna_page_media_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SharingWidgetsDLNAPageMediaEntry), 0, (GInstanceInitFunc) sharing_widgets_dlna_page_media_entry_instance_init, NULL };
	GType sharing_widgets_dlna_page_media_entry_type_id;
	sharing_widgets_dlna_page_media_entry_type_id = g_type_register_static (gtk_grid_get_type (), "SharingWidgetsDLNAPageMediaEntry", &g_define_type_info, 0);
	SharingWidgetsDLNAPageMediaEntry_private_offset = g_type_add_instance_private (sharing_widgets_dlna_page_media_entry_type_id, sizeof (SharingWidgetsDLNAPageMediaEntryPrivate));
	return sharing_widgets_dlna_page_media_entry_type_id;
}

static GType
sharing_widgets_dlna_page_media_entry_get_type (void)
{
	static volatile gsize sharing_widgets_dlna_page_media_entry_type_id__once = 0;
	if (g_once_init_enter (&sharing_widgets_dlna_page_media_entry_type_id__once)) {
		GType sharing_widgets_dlna_page_media_entry_type_id;
		sharing_widgets_dlna_page_media_entry_type_id = sharing_widgets_dlna_page_media_entry_get_type_once ();
		g_once_init_leave (&sharing_widgets_dlna_page_media_entry_type_id__once, sharing_widgets_dlna_page_media_entry_type_id);
	}
	return sharing_widgets_dlna_page_media_entry_type_id__once;
}

static void
_vala_sharing_widgets_dlna_page_media_entry_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	SharingWidgetsDLNAPageMediaEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY, SharingWidgetsDLNAPageMediaEntry);
	switch (property_id) {
		case SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_LABEL_PROPERTY:
		g_value_set_string (value, sharing_widgets_dlna_page_media_entry_get_label (self));
		break;
		case SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_MEDIA_TYPE_PROPERTY:
		g_value_set_string (value, sharing_widgets_dlna_page_media_entry_get_media_type (self));
		break;
		case SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_CONFIG_FILE_PROPERTY:
		g_value_set_object (value, sharing_widgets_dlna_page_media_entry_get_config_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sharing_widgets_dlna_page_media_entry_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	SharingWidgetsDLNAPageMediaEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SHARING_WIDGETS_DLNA_PAGE_TYPE_MEDIA_ENTRY, SharingWidgetsDLNAPageMediaEntry);
	switch (property_id) {
		case SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_LABEL_PROPERTY:
		sharing_widgets_dlna_page_media_entry_set_label (self, g_value_get_string (value));
		break;
		case SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_MEDIA_TYPE_PROPERTY:
		sharing_widgets_dlna_page_media_entry_set_media_type (self, g_value_get_string (value));
		break;
		case SHARING_WIDGETS_DLNA_PAGE_MEDIA_ENTRY_CONFIG_FILE_PROPERTY:
		sharing_widgets_dlna_page_media_entry_set_config_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_sharing_widgets_dlna_page___lambda7_ (SharingWidgetsDLNAPage* self)
{
	SharingBackendRygelConfigFile* _tmp0_;
	_tmp0_ = self->priv->rygel_config_file;
	if (sharing_backend_rygel_config_file_save (_tmp0_)) {
		SharingBackendRygelStartupManager* _tmp1_;
		GtkSwitch* _tmp2_;
		GtkSwitch* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = self->priv->rygel_startup_manager;
		_tmp2_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_switch_get_active (_tmp3_);
		_tmp5_ = _tmp4_;
		sharing_backend_rygel_startup_manager_set_service_enabled (_tmp1_, _tmp5_, NULL, NULL);
	}
	sharing_widgets_dlna_page_set_service_state (self);
}

static void
__sharing_widgets_dlna_page___lambda7__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	_sharing_widgets_dlna_page___lambda7_ ((SharingWidgetsDLNAPage*) self);
}

static GObject *
sharing_widgets_dlna_page_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SharingWidgetsDLNAPage * self;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	SharingBackendRygelStartupManager* _tmp2_;
	SharingBackendRygelConfigFile* _tmp3_;
	SharingWidgetsDLNAPageMediaEntry* music_entry = NULL;
	SharingBackendRygelConfigFile* _tmp4_;
	SharingWidgetsDLNAPageMediaEntry* _tmp5_;
	SharingWidgetsDLNAPageMediaEntry* videos_entry = NULL;
	SharingBackendRygelConfigFile* _tmp6_;
	SharingWidgetsDLNAPageMediaEntry* _tmp7_;
	SharingWidgetsDLNAPageMediaEntry* pictures_entry = NULL;
	SharingBackendRygelConfigFile* _tmp8_;
	SharingWidgetsDLNAPageMediaEntry* _tmp9_;
	GtkBox* box = NULL;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	SharingWidgetsDLNAPageMediaEntry* _tmp12_;
	GtkBox* _tmp13_;
	SharingWidgetsDLNAPageMediaEntry* _tmp14_;
	GtkBox* _tmp15_;
	SharingWidgetsDLNAPageMediaEntry* _tmp16_;
	GtkBox* _tmp17_;
	GtkSwitch* _tmp18_;
	GtkSwitch* _tmp19_;
	SharingBackendRygelStartupManager* _tmp20_;
	GtkSwitch* _tmp21_;
	GtkSwitch* _tmp22_;
	parent_class = G_OBJECT_CLASS (sharing_widgets_dlna_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SHARING_WIDGETS_TYPE_DLNA_PAGE, SharingWidgetsDLNAPage);
	switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _ ("Media Streaming"));
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("applications-multimedia");
	_tmp1_ = _tmp0_;
	switchboard_settings_page_set_icon ((SwitchboardSettingsPage*) self, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	_tmp2_ = sharing_backend_rygel_startup_manager_new ();
	_g_object_unref0 (self->priv->rygel_startup_manager);
	self->priv->rygel_startup_manager = _tmp2_;
	_tmp3_ = sharing_backend_rygel_config_file_new ();
	_g_object_unref0 (self->priv->rygel_config_file);
	self->priv->rygel_config_file = _tmp3_;
	_tmp4_ = self->priv->rygel_config_file;
	_tmp5_ = sharing_widgets_dlna_page_media_entry_new ("music", _ ("Music Folder"), _tmp4_);
	g_object_ref_sink (_tmp5_);
	music_entry = _tmp5_;
	_tmp6_ = self->priv->rygel_config_file;
	_tmp7_ = sharing_widgets_dlna_page_media_entry_new ("videos", _ ("Videos Folder"), _tmp6_);
	g_object_ref_sink (_tmp7_);
	videos_entry = _tmp7_;
	_tmp8_ = self->priv->rygel_config_file;
	_tmp9_ = sharing_widgets_dlna_page_media_entry_new ("pictures", _ ("Pictures Folder"), _tmp8_);
	g_object_ref_sink (_tmp9_);
	pictures_entry = _tmp9_;
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	g_object_ref_sink (_tmp10_);
	box = _tmp10_;
	_tmp11_ = box;
	_tmp12_ = music_entry;
	gtk_box_append (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = box;
	_tmp14_ = videos_entry;
	gtk_box_append (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = box;
	_tmp16_ = pictures_entry;
	gtk_box_append (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp17_);
	_tmp18_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->rygel_startup_manager;
	gtk_switch_set_active (_tmp19_, sharing_backend_rygel_startup_manager_get_service_enabled (_tmp20_));
	sharing_widgets_dlna_page_set_service_state (self);
	_tmp21_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp22_ = _tmp21_;
	g_signal_connect_object ((GObject*) _tmp22_, "notify::active", (GCallback) __sharing_widgets_dlna_page___lambda7__g_object_notify, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (pictures_entry);
	_g_object_unref0 (videos_entry);
	_g_object_unref0 (music_entry);
	return obj;
}

static void
sharing_widgets_dlna_page_class_init (SharingWidgetsDLNAPageClass * klass,
                                      gpointer klass_data)
{
	sharing_widgets_dlna_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SharingWidgetsDLNAPage_private_offset);
	G_OBJECT_CLASS (klass)->constructor = sharing_widgets_dlna_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = sharing_widgets_dlna_page_finalize;
}

static void
sharing_widgets_dlna_page_instance_init (SharingWidgetsDLNAPage * self,
                                         gpointer klass)
{
	self->priv = sharing_widgets_dlna_page_get_instance_private (self);
}

static void
sharing_widgets_dlna_page_finalize (GObject * obj)
{
	SharingWidgetsDLNAPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SHARING_WIDGETS_TYPE_DLNA_PAGE, SharingWidgetsDLNAPage);
	_g_object_unref0 (self->priv->rygel_startup_manager);
	_g_object_unref0 (self->priv->rygel_config_file);
	G_OBJECT_CLASS (sharing_widgets_dlna_page_parent_class)->finalize (obj);
}

static GType
sharing_widgets_dlna_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SharingWidgetsDLNAPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sharing_widgets_dlna_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SharingWidgetsDLNAPage), 0, (GInstanceInitFunc) sharing_widgets_dlna_page_instance_init, NULL };
	GType sharing_widgets_dlna_page_type_id;
	sharing_widgets_dlna_page_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "SharingWidgetsDLNAPage", &g_define_type_info, 0);
	SharingWidgetsDLNAPage_private_offset = g_type_add_instance_private (sharing_widgets_dlna_page_type_id, sizeof (SharingWidgetsDLNAPagePrivate));
	return sharing_widgets_dlna_page_type_id;
}

GType
sharing_widgets_dlna_page_get_type (void)
{
	static volatile gsize sharing_widgets_dlna_page_type_id__once = 0;
	if (g_once_init_enter (&sharing_widgets_dlna_page_type_id__once)) {
		GType sharing_widgets_dlna_page_type_id;
		sharing_widgets_dlna_page_type_id = sharing_widgets_dlna_page_get_type_once ();
		g_once_init_leave (&sharing_widgets_dlna_page_type_id__once, sharing_widgets_dlna_page_type_id);
	}
	return sharing_widgets_dlna_page_type_id__once;
}

