//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/materialConnectionSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdMaterialConnectionSchemaTokens,
    HD_MATERIAL_CONNECTION_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTokenDataSourceHandle
HdMaterialConnectionSchema::GetUpstreamNodePath() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdMaterialConnectionSchemaTokens->upstreamNodePath);
}

HdTokenDataSourceHandle
HdMaterialConnectionSchema::GetUpstreamNodeOutputName() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdMaterialConnectionSchemaTokens->upstreamNodeOutputName);
}

/*static*/
HdContainerDataSourceHandle
HdMaterialConnectionSchema::BuildRetained(
        const HdTokenDataSourceHandle &upstreamNodePath,
        const HdTokenDataSourceHandle &upstreamNodeOutputName
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (upstreamNodePath) {
        _names[_count] = HdMaterialConnectionSchemaTokens->upstreamNodePath;
        _values[_count++] = upstreamNodePath;
    }

    if (upstreamNodeOutputName) {
        _names[_count] = HdMaterialConnectionSchemaTokens->upstreamNodeOutputName;
        _values[_count++] = upstreamNodeOutputName;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdMaterialConnectionSchema::Builder &
HdMaterialConnectionSchema::Builder::SetUpstreamNodePath(
    const HdTokenDataSourceHandle &upstreamNodePath)
{
    _upstreamNodePath = upstreamNodePath;
    return *this;
}

HdMaterialConnectionSchema::Builder &
HdMaterialConnectionSchema::Builder::SetUpstreamNodeOutputName(
    const HdTokenDataSourceHandle &upstreamNodeOutputName)
{
    _upstreamNodeOutputName = upstreamNodeOutputName;
    return *this;
}

HdContainerDataSourceHandle
HdMaterialConnectionSchema::Builder::Build()
{
    return HdMaterialConnectionSchema::BuildRetained(
        _upstreamNodePath,
        _upstreamNodeOutputName
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE