/* Device.c generated by valac 0.56.17, the Vala compiler
 * generated from Device.vala, do not modify */

/*
 * Copyright (c) 2011-2015 elementary LLC. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "power.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gio/gio.h>

#define POWER_SERVICES_DEVICE_DEVICE_INTERFACE "org.freedesktop.UPower"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POWER_SERVICES_DEVICE_0_PROPERTY,
	POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY,
	POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY,
	POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY,
	POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY,
	POWER_SERVICES_DEVICE_ONLINE_PROPERTY,
	POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY,
	POWER_SERVICES_DEVICE_CAPACITY_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY,
	POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY,
	POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY,
	POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY,
	POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY,
	POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY,
	POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY,
	POWER_SERVICES_DEVICE_MODEL_PROPERTY,
	POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY,
	POWER_SERVICES_DEVICE_SERIAL_PROPERTY,
	POWER_SERVICES_DEVICE_VENDOR_PROPERTY,
	POWER_SERVICES_DEVICE_STATE_PROPERTY,
	POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY,
	POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY,
	POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY,
	POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY,
	POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY,
	POWER_SERVICES_DEVICE_NUM_PROPERTIES
};
static GParamSpec* power_services_device_properties[POWER_SERVICES_DEVICE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	POWER_SERVICES_DEVICE_PROPERTIES_UPDATED_SIGNAL,
	POWER_SERVICES_DEVICE_NUM_SIGNALS
};
static guint power_services_device_signals[POWER_SERVICES_DEVICE_NUM_SIGNALS] = {0};

struct _PowerServicesDevicePrivate {
	gchar* device_path;
	PowerServicesDBusInterfacesDevice* device;
	gboolean _has_history;
	gboolean _has_statistics;
	gboolean _is_present;
	gboolean _is_rechargeable;
	gboolean _online;
	gboolean _power_supply;
	gdouble _capacity;
	gdouble _energy;
	gdouble _energy_empty;
	gdouble _energy_full;
	gdouble _energy_full_design;
	gdouble _energy_rate;
	gdouble _luminosity;
	gdouble _percentage;
	gdouble _temperature;
	gdouble _voltage;
	gint64 _time_to_empty;
	gint64 _time_to_full;
	gchar* _model;
	gchar* _native_path;
	gchar* _serial;
	gchar* _vendor;
	PowerServicesDeviceState _state;
	PowerServicesDeviceTechnology _technology;
	PowerServicesDeviceType _device_type;
	guint64 _update_time;
	gboolean _is_charging;
	gboolean _is_a_battery;
};

static gint PowerServicesDevice_private_offset;
static gpointer power_services_device_parent_class = NULL;

static gboolean power_services_device_connect_to_bus (PowerServicesDevice* self);
static void power_services_device_update_properties (PowerServicesDevice* self);
static void power_services_device_connect_signals (PowerServicesDevice* self);
static void _power_services_device_update_properties_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                 GVariant* changed_properties,
                                                                                 gchar** invalidated_properties,
                                                                                 gpointer self);
static void power_services_device_set_has_history (PowerServicesDevice* self,
                                            gboolean value);
static void power_services_device_set_has_statistics (PowerServicesDevice* self,
                                               gboolean value);
static void power_services_device_set_is_present (PowerServicesDevice* self,
                                           gboolean value);
static void power_services_device_set_is_rechargeable (PowerServicesDevice* self,
                                                gboolean value);
static void power_services_device_set_online (PowerServicesDevice* self,
                                       gboolean value);
static void power_services_device_set_power_supply (PowerServicesDevice* self,
                                             gboolean value);
static void power_services_device_set_capacity (PowerServicesDevice* self,
                                         gdouble value);
static void power_services_device_set_energy (PowerServicesDevice* self,
                                       gdouble value);
static void power_services_device_set_energy_empty (PowerServicesDevice* self,
                                             gdouble value);
static void power_services_device_set_energy_full (PowerServicesDevice* self,
                                            gdouble value);
static void power_services_device_set_energy_full_design (PowerServicesDevice* self,
                                                   gdouble value);
static void power_services_device_set_energy_rate (PowerServicesDevice* self,
                                            gdouble value);
static void power_services_device_set_luminosity (PowerServicesDevice* self,
                                           gdouble value);
static void power_services_device_set_percentage (PowerServicesDevice* self,
                                           gdouble value);
static void power_services_device_set_temperature (PowerServicesDevice* self,
                                            gdouble value);
static void power_services_device_set_voltage (PowerServicesDevice* self,
                                        gdouble value);
static void power_services_device_set_time_to_empty (PowerServicesDevice* self,
                                              gint64 value);
static void power_services_device_set_time_to_full (PowerServicesDevice* self,
                                             gint64 value);
static void power_services_device_set_model (PowerServicesDevice* self,
                                      const gchar* value);
static void power_services_device_set_native_path (PowerServicesDevice* self,
                                            const gchar* value);
static void power_services_device_set_serial (PowerServicesDevice* self,
                                       const gchar* value);
static void power_services_device_set_vendor (PowerServicesDevice* self,
                                       const gchar* value);
static PowerServicesDeviceType power_services_device_determine_device_type (PowerServicesDevice* self);
static void power_services_device_set_device_type (PowerServicesDevice* self,
                                            PowerServicesDeviceType value);
static void power_services_device_set_state (PowerServicesDevice* self,
                                      PowerServicesDeviceState value);
static void power_services_device_set_technology (PowerServicesDevice* self,
                                           PowerServicesDeviceTechnology value);
static void power_services_device_set_update_time (PowerServicesDevice* self,
                                            guint64 value);
static void power_services_device_set_is_charging (PowerServicesDevice* self,
                                            gboolean value);
static void power_services_device_set_is_a_battery (PowerServicesDevice* self,
                                             gboolean value);
static const gchar* power_services_device_get_battery_icon (PowerServicesDevice* self);
static void power_services_device_finalize (GObject * obj);
static GType power_services_device_get_type_once (void);
static void _vala_power_services_device_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_power_services_device_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
power_services_device_get_instance_private (PowerServicesDevice* self)
{
	return G_STRUCT_MEMBER_P (self, PowerServicesDevice_private_offset);
}

static GType
power_services_device_state_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_SERVICES_DEVICE_STATE_UNKNOWN, "POWER_SERVICES_DEVICE_STATE_UNKNOWN", "unknown"}, {POWER_SERVICES_DEVICE_STATE_CHARGING, "POWER_SERVICES_DEVICE_STATE_CHARGING", "charging"}, {POWER_SERVICES_DEVICE_STATE_DISCHARGING, "POWER_SERVICES_DEVICE_STATE_DISCHARGING", "discharging"}, {POWER_SERVICES_DEVICE_STATE_EMPTY, "POWER_SERVICES_DEVICE_STATE_EMPTY", "empty"}, {POWER_SERVICES_DEVICE_STATE_FULLY_CHARGED, "POWER_SERVICES_DEVICE_STATE_FULLY_CHARGED", "fully-charged"}, {POWER_SERVICES_DEVICE_STATE_PENDING_CHARGE, "POWER_SERVICES_DEVICE_STATE_PENDING_CHARGE", "pending-charge"}, {POWER_SERVICES_DEVICE_STATE_PENDING_DISCHARGE, "POWER_SERVICES_DEVICE_STATE_PENDING_DISCHARGE", "pending-discharge"}, {0, NULL, NULL}};
	GType power_services_device_state_type_id;
	power_services_device_state_type_id = g_enum_register_static ("PowerServicesDeviceState", values);
	return power_services_device_state_type_id;
}

GType
power_services_device_state_get_type (void)
{
	static volatile gsize power_services_device_state_type_id__once = 0;
	if (g_once_init_enter (&power_services_device_state_type_id__once)) {
		GType power_services_device_state_type_id;
		power_services_device_state_type_id = power_services_device_state_get_type_once ();
		g_once_init_leave (&power_services_device_state_type_id__once, power_services_device_state_type_id);
	}
	return power_services_device_state_type_id__once;
}

static GType
power_services_device_technology_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_SERVICES_DEVICE_TECHNOLOGY_UNKNOWN, "POWER_SERVICES_DEVICE_TECHNOLOGY_UNKNOWN", "unknown"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_ION, "POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_ION", "lithium-ion"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_POLYMER, "POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_POLYMER", "lithium-polymer"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_IRON_PHOSPHATE, "POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_IRON_PHOSPHATE", "lithium-iron-phosphate"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_LEAD_ACID, "POWER_SERVICES_DEVICE_TECHNOLOGY_LEAD_ACID", "lead-acid"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_NICKEL_CADMIUM, "POWER_SERVICES_DEVICE_TECHNOLOGY_NICKEL_CADMIUM", "nickel-cadmium"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_NICKEL_METAL_HYDRIDE, "POWER_SERVICES_DEVICE_TECHNOLOGY_NICKEL_METAL_HYDRIDE", "nickel-metal-hydride"}, {0, NULL, NULL}};
	GType power_services_device_technology_type_id;
	power_services_device_technology_type_id = g_enum_register_static ("PowerServicesDeviceTechnology", values);
	return power_services_device_technology_type_id;
}

GType
power_services_device_technology_get_type (void)
{
	static volatile gsize power_services_device_technology_type_id__once = 0;
	if (g_once_init_enter (&power_services_device_technology_type_id__once)) {
		GType power_services_device_technology_type_id;
		power_services_device_technology_type_id = power_services_device_technology_get_type_once ();
		g_once_init_leave (&power_services_device_technology_type_id__once, power_services_device_technology_type_id);
	}
	return power_services_device_technology_type_id__once;
}

const gchar*
power_services_device_type_get_name (PowerServicesDeviceType self)
{
	const gchar* result;
	switch (self) {
		case POWER_SERVICES_DEVICE_TYPE_BATTERY:
		{
			result = _ ("Battery");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_UPS:
		{
			result = _ ("UPS");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MONITOR:
		{
			result = _ ("Display");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MOUSE:
		{
			result = _ ("Mouse");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_KEYBOARD:
		{
			result = _ ("Keyboard");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_PDA:
		{
			result = _ ("PDA");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_PHONE:
		{
			result = _ ("Phone");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MEDIA_PLAYER:
		{
			result = _ ("Media Player");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_TABLET:
		{
			result = _ ("Tablet");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_COMPUTER:
		{
			result = _ ("Computer");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_GAMING_INPUT:
		{
			result = _ ("Controller");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_PEN:
		{
			result = _ ("Pen");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_LINE_POWER:
		{
			result = _ ("Plugged In");
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

const gchar*
power_services_device_type_get_icon_name (PowerServicesDeviceType self)
{
	const gchar* result;
	switch (self) {
		case POWER_SERVICES_DEVICE_TYPE_UPS:
		{
			result = "uninterruptible-power-supply";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MOUSE:
		{
			result = "input-mouse";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_KEYBOARD:
		{
			result = "input-keyboard";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_PDA:
		case POWER_SERVICES_DEVICE_TYPE_PHONE:
		{
			result = "phone";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MEDIA_PLAYER:
		{
			result = "multimedia-player";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_TABLET:
		case POWER_SERVICES_DEVICE_TYPE_PEN:
		{
			result = "input-tablet";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_GAMING_INPUT:
		{
			result = "input-gaming";
			return result;
		}
		default:
		case POWER_SERVICES_DEVICE_TYPE_COMPUTER:
		case POWER_SERVICES_DEVICE_TYPE_MONITOR:
		case POWER_SERVICES_DEVICE_TYPE_UNKNOWN:
		case POWER_SERVICES_DEVICE_TYPE_BATTERY:
		case POWER_SERVICES_DEVICE_TYPE_LINE_POWER:
		{
			result = NULL;
			return result;
		}
	}
}

static GType
power_services_device_type_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_SERVICES_DEVICE_TYPE_UNKNOWN, "POWER_SERVICES_DEVICE_TYPE_UNKNOWN", "unknown"}, {POWER_SERVICES_DEVICE_TYPE_LINE_POWER, "POWER_SERVICES_DEVICE_TYPE_LINE_POWER", "line-power"}, {POWER_SERVICES_DEVICE_TYPE_BATTERY, "POWER_SERVICES_DEVICE_TYPE_BATTERY", "battery"}, {POWER_SERVICES_DEVICE_TYPE_UPS, "POWER_SERVICES_DEVICE_TYPE_UPS", "ups"}, {POWER_SERVICES_DEVICE_TYPE_MONITOR, "POWER_SERVICES_DEVICE_TYPE_MONITOR", "monitor"}, {POWER_SERVICES_DEVICE_TYPE_MOUSE, "POWER_SERVICES_DEVICE_TYPE_MOUSE", "mouse"}, {POWER_SERVICES_DEVICE_TYPE_KEYBOARD, "POWER_SERVICES_DEVICE_TYPE_KEYBOARD", "keyboard"}, {POWER_SERVICES_DEVICE_TYPE_PDA, "POWER_SERVICES_DEVICE_TYPE_PDA", "pda"}, {POWER_SERVICES_DEVICE_TYPE_PHONE, "POWER_SERVICES_DEVICE_TYPE_PHONE", "phone"}, {POWER_SERVICES_DEVICE_TYPE_MEDIA_PLAYER, "POWER_SERVICES_DEVICE_TYPE_MEDIA_PLAYER", "media-player"}, {POWER_SERVICES_DEVICE_TYPE_TABLET, "POWER_SERVICES_DEVICE_TYPE_TABLET", "tablet"}, {POWER_SERVICES_DEVICE_TYPE_COMPUTER, "POWER_SERVICES_DEVICE_TYPE_COMPUTER", "computer"}, {POWER_SERVICES_DEVICE_TYPE_GAMING_INPUT, "POWER_SERVICES_DEVICE_TYPE_GAMING_INPUT", "gaming-input"}, {POWER_SERVICES_DEVICE_TYPE_PEN, "POWER_SERVICES_DEVICE_TYPE_PEN", "pen"}, {0, NULL, NULL}};
	GType power_services_device_type_type_id;
	power_services_device_type_type_id = g_enum_register_static ("PowerServicesDeviceType", values);
	return power_services_device_type_type_id;
}

GType
power_services_device_type_get_type (void)
{
	static volatile gsize power_services_device_type_type_id__once = 0;
	if (g_once_init_enter (&power_services_device_type_type_id__once)) {
		GType power_services_device_type_type_id;
		power_services_device_type_type_id = power_services_device_type_get_type_once ();
		g_once_init_leave (&power_services_device_type_type_id__once, power_services_device_type_type_id);
	}
	return power_services_device_type_type_id__once;
}

PowerServicesDevice*
power_services_device_construct (GType object_type,
                                 const gchar* device_path)
{
	PowerServicesDevice * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (device_path != NULL, NULL);
	self = (PowerServicesDevice*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (device_path);
	_g_free0 (self->priv->device_path);
	self->priv->device_path = _tmp0_;
	if (power_services_device_connect_to_bus (self)) {
		power_services_device_update_properties (self);
		power_services_device_connect_signals (self);
	}
	return self;
}

PowerServicesDevice*
power_services_device_new (const gchar* device_path)
{
	return power_services_device_construct (POWER_SERVICES_TYPE_DEVICE, device_path);
}

static gboolean
power_services_device_connect_to_bus (PowerServicesDevice* self)
{
	PowerServicesDBusInterfacesDevice* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PowerServicesDBusInterfacesDevice* _tmp0_ = NULL;
		const gchar* _tmp1_;
		PowerServicesDBusInterfacesDevice* _tmp2_;
		PowerServicesDBusInterfacesDevice* _tmp3_;
		_tmp1_ = self->priv->device_path;
		_tmp2_ = (PowerServicesDBusInterfacesDevice*) g_initable_new (POWER_SERVICES_DBUS_INTERFACES_TYPE_DEVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", POWER_SERVICES_DEVICE_DEVICE_INTERFACE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp1_, "g-interface-name", "org.freedesktop.UPower.Device", NULL);
		_tmp0_ = (PowerServicesDBusInterfacesDevice*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->device);
		self->priv->device = _tmp3_;
		g_debug ("Device.vala:174: Connection to UPower device established");
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("Device.vala:176: Connecting to UPower device failed: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	_tmp7_ = self->priv->device;
	result = _tmp7_ != NULL;
	return result;
}

static void
_power_services_device_update_properties_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                            GVariant* changed_properties,
                                                                            gchar** invalidated_properties,
                                                                            gpointer self)
{
	power_services_device_update_properties ((PowerServicesDevice*) self);
}

static void
power_services_device_connect_signals (PowerServicesDevice* self)
{
	PowerServicesDBusInterfacesDevice* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->device;
	g_signal_connect_object ((GDBusProxy*) _tmp0_, "g-properties-changed", (GCallback) _power_services_device_update_properties_g_dbus_proxy_g_properties_changed, self, 0);
}

static void
power_services_device_update_properties (PowerServicesDevice* self)
{
	PowerServicesDBusInterfacesDevice* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	PowerServicesDBusInterfacesDevice* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	PowerServicesDBusInterfacesDevice* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	PowerServicesDBusInterfacesDevice* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	PowerServicesDBusInterfacesDevice* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	PowerServicesDBusInterfacesDevice* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	PowerServicesDBusInterfacesDevice* _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	PowerServicesDBusInterfacesDevice* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	PowerServicesDBusInterfacesDevice* _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	PowerServicesDBusInterfacesDevice* _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	PowerServicesDBusInterfacesDevice* _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	PowerServicesDBusInterfacesDevice* _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	PowerServicesDBusInterfacesDevice* _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	PowerServicesDBusInterfacesDevice* _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	PowerServicesDBusInterfacesDevice* _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	PowerServicesDBusInterfacesDevice* _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	PowerServicesDBusInterfacesDevice* _tmp48_;
	gint64 _tmp49_;
	gint64 _tmp50_;
	PowerServicesDBusInterfacesDevice* _tmp51_;
	gint64 _tmp52_;
	gint64 _tmp53_;
	PowerServicesDBusInterfacesDevice* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	PowerServicesDBusInterfacesDevice* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	PowerServicesDBusInterfacesDevice* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	PowerServicesDBusInterfacesDevice* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	PowerServicesDBusInterfacesDevice* _tmp70_;
	guint32 _tmp71_;
	guint32 _tmp72_;
	PowerServicesDBusInterfacesDevice* _tmp73_;
	guint32 _tmp74_;
	guint32 _tmp75_;
	PowerServicesDBusInterfacesDevice* _tmp76_;
	guint64 _tmp77_;
	guint64 _tmp78_;
	gboolean _tmp79_ = FALSE;
	PowerServicesDeviceState _tmp80_;
	gboolean _tmp82_ = FALSE;
	PowerServicesDeviceType _tmp83_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->device;
	_tmp1_ = power_services_dbus_interfaces_device_get_has_history (_tmp0_);
	_tmp2_ = _tmp1_;
	power_services_device_set_has_history (self, _tmp2_);
	_tmp3_ = self->priv->device;
	_tmp4_ = power_services_dbus_interfaces_device_get_has_statistics (_tmp3_);
	_tmp5_ = _tmp4_;
	power_services_device_set_has_statistics (self, _tmp5_);
	_tmp6_ = self->priv->device;
	_tmp7_ = power_services_dbus_interfaces_device_get_is_present (_tmp6_);
	_tmp8_ = _tmp7_;
	power_services_device_set_is_present (self, _tmp8_);
	_tmp9_ = self->priv->device;
	_tmp10_ = power_services_dbus_interfaces_device_get_is_rechargeable (_tmp9_);
	_tmp11_ = _tmp10_;
	power_services_device_set_is_rechargeable (self, _tmp11_);
	_tmp12_ = self->priv->device;
	_tmp13_ = power_services_dbus_interfaces_device_get_online (_tmp12_);
	_tmp14_ = _tmp13_;
	power_services_device_set_online (self, _tmp14_);
	_tmp15_ = self->priv->device;
	_tmp16_ = power_services_dbus_interfaces_device_get_power_supply (_tmp15_);
	_tmp17_ = _tmp16_;
	power_services_device_set_power_supply (self, _tmp17_);
	_tmp18_ = self->priv->device;
	_tmp19_ = power_services_dbus_interfaces_device_get_capacity (_tmp18_);
	_tmp20_ = _tmp19_;
	power_services_device_set_capacity (self, _tmp20_);
	_tmp21_ = self->priv->device;
	_tmp22_ = power_services_dbus_interfaces_device_get_energy (_tmp21_);
	_tmp23_ = _tmp22_;
	power_services_device_set_energy (self, _tmp23_);
	_tmp24_ = self->priv->device;
	_tmp25_ = power_services_dbus_interfaces_device_get_energy_empty (_tmp24_);
	_tmp26_ = _tmp25_;
	power_services_device_set_energy_empty (self, _tmp26_);
	_tmp27_ = self->priv->device;
	_tmp28_ = power_services_dbus_interfaces_device_get_energy_full (_tmp27_);
	_tmp29_ = _tmp28_;
	power_services_device_set_energy_full (self, _tmp29_);
	_tmp30_ = self->priv->device;
	_tmp31_ = power_services_dbus_interfaces_device_get_energy_full_design (_tmp30_);
	_tmp32_ = _tmp31_;
	power_services_device_set_energy_full_design (self, _tmp32_);
	_tmp33_ = self->priv->device;
	_tmp34_ = power_services_dbus_interfaces_device_get_energy_rate (_tmp33_);
	_tmp35_ = _tmp34_;
	power_services_device_set_energy_rate (self, _tmp35_);
	_tmp36_ = self->priv->device;
	_tmp37_ = power_services_dbus_interfaces_device_get_luminosity (_tmp36_);
	_tmp38_ = _tmp37_;
	power_services_device_set_luminosity (self, _tmp38_);
	_tmp39_ = self->priv->device;
	_tmp40_ = power_services_dbus_interfaces_device_get_percentage (_tmp39_);
	_tmp41_ = _tmp40_;
	power_services_device_set_percentage (self, _tmp41_);
	_tmp42_ = self->priv->device;
	_tmp43_ = power_services_dbus_interfaces_device_get_temperature (_tmp42_);
	_tmp44_ = _tmp43_;
	power_services_device_set_temperature (self, _tmp44_);
	_tmp45_ = self->priv->device;
	_tmp46_ = power_services_dbus_interfaces_device_get_voltage (_tmp45_);
	_tmp47_ = _tmp46_;
	power_services_device_set_voltage (self, _tmp47_);
	_tmp48_ = self->priv->device;
	_tmp49_ = power_services_dbus_interfaces_device_get_time_to_empty (_tmp48_);
	_tmp50_ = _tmp49_;
	power_services_device_set_time_to_empty (self, _tmp50_);
	_tmp51_ = self->priv->device;
	_tmp52_ = power_services_dbus_interfaces_device_get_time_to_full (_tmp51_);
	_tmp53_ = _tmp52_;
	power_services_device_set_time_to_full (self, _tmp53_);
	_tmp54_ = self->priv->device;
	_tmp55_ = power_services_dbus_interfaces_device_get_model (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = _tmp56_;
	power_services_device_set_model (self, _tmp57_);
	_g_free0 (_tmp57_);
	_tmp58_ = self->priv->device;
	_tmp59_ = power_services_dbus_interfaces_device_get_native_path (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = _tmp60_;
	power_services_device_set_native_path (self, _tmp61_);
	_g_free0 (_tmp61_);
	_tmp62_ = self->priv->device;
	_tmp63_ = power_services_dbus_interfaces_device_get_serial (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = _tmp64_;
	power_services_device_set_serial (self, _tmp65_);
	_g_free0 (_tmp65_);
	_tmp66_ = self->priv->device;
	_tmp67_ = power_services_dbus_interfaces_device_get_vendor (_tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = _tmp68_;
	power_services_device_set_vendor (self, _tmp69_);
	_g_free0 (_tmp69_);
	power_services_device_set_device_type (self, power_services_device_determine_device_type (self));
	_tmp70_ = self->priv->device;
	_tmp71_ = power_services_dbus_interfaces_device_get_state (_tmp70_);
	_tmp72_ = _tmp71_;
	power_services_device_set_state (self, (PowerServicesDeviceState) _tmp72_);
	_tmp73_ = self->priv->device;
	_tmp74_ = power_services_dbus_interfaces_device_get_technology (_tmp73_);
	_tmp75_ = _tmp74_;
	power_services_device_set_technology (self, (PowerServicesDeviceTechnology) _tmp75_);
	_tmp76_ = self->priv->device;
	_tmp77_ = power_services_dbus_interfaces_device_get_update_time (_tmp76_);
	_tmp78_ = _tmp77_;
	power_services_device_set_update_time (self, _tmp78_);
	_tmp80_ = self->priv->_state;
	if (_tmp80_ == POWER_SERVICES_DEVICE_STATE_FULLY_CHARGED) {
		_tmp79_ = TRUE;
	} else {
		PowerServicesDeviceState _tmp81_;
		_tmp81_ = self->priv->_state;
		_tmp79_ = _tmp81_ == POWER_SERVICES_DEVICE_STATE_CHARGING;
	}
	power_services_device_set_is_charging (self, _tmp79_);
	_tmp83_ = self->priv->_device_type;
	if (_tmp83_ != POWER_SERVICES_DEVICE_TYPE_UNKNOWN) {
		PowerServicesDeviceType _tmp84_;
		_tmp84_ = self->priv->_device_type;
		_tmp82_ = _tmp84_ != POWER_SERVICES_DEVICE_TYPE_LINE_POWER;
	} else {
		_tmp82_ = FALSE;
	}
	power_services_device_set_is_a_battery (self, _tmp82_);
	g_signal_emit (self, power_services_device_signals[POWER_SERVICES_DEVICE_PROPERTIES_UPDATED_SIGNAL], 0);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static PowerServicesDeviceType
power_services_device_determine_device_type (PowerServicesDevice* self)
{
	gboolean _tmp0_ = FALSE;
	PowerServicesDBusInterfacesDevice* _tmp1_;
	guint32 _tmp2_;
	guint32 _tmp3_;
	PowerServicesDBusInterfacesDevice* _tmp8_;
	guint32 _tmp9_;
	guint32 _tmp10_;
	PowerServicesDeviceType result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->device;
	_tmp2_ = power_services_dbus_interfaces_device_get_Type (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == ((guint32) POWER_SERVICES_DEVICE_TYPE_MOUSE)) {
		PowerServicesDBusInterfacesDevice* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = self->priv->device;
		_tmp5_ = power_services_dbus_interfaces_device_get_model (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp0_ = string_contains (_tmp7_, "keyboard");
		_g_free0 (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (PowerServicesDeviceType) POWER_SERVICES_DEVICE_TYPE_KEYBOARD;
		return result;
	}
	_tmp8_ = self->priv->device;
	_tmp9_ = power_services_dbus_interfaces_device_get_Type (_tmp8_);
	_tmp10_ = _tmp9_;
	result = (PowerServicesDeviceType) _tmp10_;
	return result;
}

gchar*
power_services_device_get_symbolic_icon_name_for_battery (PowerServicesDevice* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = power_services_device_get_icon_name_for_battery (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "-symbolic", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
power_services_device_get_icon_name_for_battery (PowerServicesDevice* self)
{
	gboolean _tmp0_;
	gboolean _tmp2_ = FALSE;
	gdouble _tmp3_;
	const gchar* battery_icon = NULL;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_is_a_battery;
	if (!_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("preferences-system-power-symbolic");
		result = _tmp1_;
		return result;
	}
	_tmp3_ = self->priv->_percentage;
	if (_tmp3_ == ((gdouble) 100)) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_is_charging;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("battery-full-charged");
		result = _tmp5_;
		return result;
	}
	_tmp6_ = power_services_device_get_battery_icon (self);
	battery_icon = _tmp6_;
	_tmp7_ = self->priv->_is_charging;
	if (_tmp7_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = battery_icon;
		_tmp9_ = g_strconcat (_tmp8_, "-charging", NULL);
		result = _tmp9_;
		return result;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = battery_icon;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
}

static const gchar*
power_services_device_get_battery_icon (PowerServicesDevice* self)
{
	gdouble _tmp0_;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_percentage;
	if (_tmp0_ <= ((gdouble) 0)) {
		result = "battery-good";
		return result;
	}
	_tmp2_ = self->priv->_percentage;
	if (_tmp2_ < ((gdouble) 10)) {
		gboolean _tmp3_ = FALSE;
		gint64 _tmp4_;
		_tmp4_ = self->priv->_time_to_empty;
		if (_tmp4_ == ((gint64) 0)) {
			_tmp3_ = TRUE;
		} else {
			gint64 _tmp5_;
			_tmp5_ = self->priv->_time_to_empty;
			_tmp3_ = _tmp5_ < ((gint64) (30 * 60));
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = "battery-empty";
		return result;
	}
	_tmp6_ = self->priv->_percentage;
	if (_tmp6_ < ((gdouble) 37.5f)) {
		result = "battery-caution";
		return result;
	}
	_tmp7_ = self->priv->_percentage;
	if (_tmp7_ < ((gdouble) 62.5f)) {
		result = "battery-low";
		return result;
	}
	_tmp8_ = self->priv->_percentage;
	if (_tmp8_ < ((gdouble) 87.5f)) {
		result = "battery-good";
		return result;
	}
	result = "battery-full";
	return result;
}

gchar*
power_services_device_get_info (PowerServicesDevice* self)
{
	gint percent = 0;
	gdouble _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gchar* info = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_percentage;
	percent = (gint) round (_tmp0_);
	_tmp1_ = self->priv->_is_a_battery;
	if (!_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	}
	if (percent <= 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("Calculating…"));
		result = _tmp3_;
		return result;
	}
	if (percent == 100) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_is_charging;
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (_ ("Fully charged"));
		result = _tmp6_;
		return result;
	}
	_tmp7_ = g_strdup ("");
	info = _tmp7_;
	_tmp8_ = self->priv->_is_charging;
	if (_tmp8_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gint64 _tmp13_;
		_tmp9_ = info;
		_tmp10_ = g_strdup_printf (_ ("%i%% charged"), percent);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
		_g_free0 (info);
		info = _tmp12_;
		_g_free0 (_tmp11_);
		_tmp13_ = self->priv->_time_to_full;
		if (_tmp13_ > ((gint64) 0)) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gint64 _tmp16_;
			_tmp14_ = info;
			_tmp15_ = g_strconcat (_tmp14_, " - ", NULL);
			_g_free0 (info);
			info = _tmp15_;
			_tmp16_ = self->priv->_time_to_full;
			if (_tmp16_ >= ((gint64) 3600)) {
				gint64 hours = 0LL;
				gint64 _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp17_ = self->priv->_time_to_full;
				hours = _tmp17_ / 3600;
				_tmp18_ = info;
				_tmp19_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld hour until full", "%lld hours until full", (gulong) hours), hours);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat (_tmp18_, _tmp20_, NULL);
				_g_free0 (info);
				info = _tmp21_;
				_g_free0 (_tmp20_);
			} else {
				gint64 _tmp22_;
				_tmp22_ = self->priv->_time_to_full;
				if (_tmp22_ >= ((gint64) 60)) {
					gint64 minutes = 0LL;
					gint64 _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp23_ = self->priv->_time_to_full;
					minutes = _tmp23_ / 60;
					_tmp24_ = info;
					_tmp25_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld minute until full", "%lld minutes until full", (gulong) minutes), minutes);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp24_, _tmp26_, NULL);
					_g_free0 (info);
					info = _tmp27_;
					_g_free0 (_tmp26_);
				} else {
					const gchar* _tmp28_;
					gint64 _tmp29_;
					gint64 _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					_tmp28_ = info;
					_tmp29_ = self->priv->_time_to_full;
					_tmp30_ = self->priv->_time_to_full;
					_tmp31_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld second until full", "%lld seconds until full", (gulong) _tmp29_), _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strconcat (_tmp28_, _tmp32_, NULL);
					_g_free0 (info);
					info = _tmp33_;
					_g_free0 (_tmp32_);
				}
			}
		}
	} else {
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gint64 _tmp38_;
		_tmp34_ = info;
		_tmp35_ = g_strdup_printf (_ ("%i%% remaining"), percent);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp34_, _tmp36_, NULL);
		_g_free0 (info);
		info = _tmp37_;
		_g_free0 (_tmp36_);
		_tmp38_ = self->priv->_time_to_empty;
		if (_tmp38_ > ((gint64) 0)) {
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gint64 _tmp41_;
			_tmp39_ = info;
			_tmp40_ = g_strconcat (_tmp39_, " - ", NULL);
			_g_free0 (info);
			info = _tmp40_;
			_tmp41_ = self->priv->_time_to_empty;
			if (_tmp41_ >= ((gint64) 3600)) {
				gint64 hours = 0LL;
				gint64 _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				_tmp42_ = self->priv->_time_to_empty;
				hours = _tmp42_ / 3600;
				_tmp43_ = info;
				_tmp44_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld hour until empty", "%lld hours until empty", (gulong) hours), hours);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strconcat (_tmp43_, _tmp45_, NULL);
				_g_free0 (info);
				info = _tmp46_;
				_g_free0 (_tmp45_);
			} else {
				gint64 _tmp47_;
				_tmp47_ = self->priv->_time_to_empty;
				if (_tmp47_ >= ((gint64) 60)) {
					gint64 minutes = 0LL;
					gint64 _tmp48_;
					const gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					_tmp48_ = self->priv->_time_to_empty;
					minutes = _tmp48_ / 60;
					_tmp49_ = info;
					_tmp50_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld minute until empty", "%lld minutes until empty", (gulong) minutes), minutes);
					_tmp51_ = _tmp50_;
					_tmp52_ = g_strconcat (_tmp49_, _tmp51_, NULL);
					_g_free0 (info);
					info = _tmp52_;
					_g_free0 (_tmp51_);
				} else {
					const gchar* _tmp53_;
					gint64 _tmp54_;
					gint64 _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					_tmp53_ = info;
					_tmp54_ = self->priv->_time_to_empty;
					_tmp55_ = self->priv->_time_to_empty;
					_tmp56_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld second until empty", "%lld seconds until empty", (gulong) _tmp54_), _tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = g_strconcat (_tmp53_, _tmp57_, NULL);
					_g_free0 (info);
					info = _tmp58_;
					_g_free0 (_tmp57_);
				}
			}
		}
	}
	result = info;
	return result;
}

gboolean
power_services_device_get_has_history (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_history;
	return result;
}

static void
power_services_device_set_has_history (PowerServicesDevice* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_has_history (self);
	if (old_value != value) {
		self->priv->_has_history = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY]);
	}
}

gboolean
power_services_device_get_has_statistics (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_statistics;
	return result;
}

static void
power_services_device_set_has_statistics (PowerServicesDevice* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_has_statistics (self);
	if (old_value != value) {
		self->priv->_has_statistics = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY]);
	}
}

gboolean
power_services_device_get_is_present (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_present;
	return result;
}

static void
power_services_device_set_is_present (PowerServicesDevice* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_is_present (self);
	if (old_value != value) {
		self->priv->_is_present = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY]);
	}
}

gboolean
power_services_device_get_is_rechargeable (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_rechargeable;
	return result;
}

static void
power_services_device_set_is_rechargeable (PowerServicesDevice* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_is_rechargeable (self);
	if (old_value != value) {
		self->priv->_is_rechargeable = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY]);
	}
}

gboolean
power_services_device_get_online (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_online;
	return result;
}

static void
power_services_device_set_online (PowerServicesDevice* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_online (self);
	if (old_value != value) {
		self->priv->_online = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ONLINE_PROPERTY]);
	}
}

gboolean
power_services_device_get_power_supply (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_power_supply;
	return result;
}

static void
power_services_device_set_power_supply (PowerServicesDevice* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_power_supply (self);
	if (old_value != value) {
		self->priv->_power_supply = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY]);
	}
}

gdouble
power_services_device_get_capacity (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_capacity;
	return result;
}

static void
power_services_device_set_capacity (PowerServicesDevice* self,
                                    gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_capacity (self);
	if (old_value != value) {
		self->priv->_capacity = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_CAPACITY_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy;
	return result;
}

static void
power_services_device_set_energy (PowerServicesDevice* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy (self);
	if (old_value != value) {
		self->priv->_energy = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy_empty (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy_empty;
	return result;
}

static void
power_services_device_set_energy_empty (PowerServicesDevice* self,
                                        gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy_empty (self);
	if (old_value != value) {
		self->priv->_energy_empty = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy_full (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy_full;
	return result;
}

static void
power_services_device_set_energy_full (PowerServicesDevice* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy_full (self);
	if (old_value != value) {
		self->priv->_energy_full = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy_full_design (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy_full_design;
	return result;
}

static void
power_services_device_set_energy_full_design (PowerServicesDevice* self,
                                              gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy_full_design (self);
	if (old_value != value) {
		self->priv->_energy_full_design = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy_rate (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy_rate;
	return result;
}

static void
power_services_device_set_energy_rate (PowerServicesDevice* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy_rate (self);
	if (old_value != value) {
		self->priv->_energy_rate = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY]);
	}
}

gdouble
power_services_device_get_luminosity (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_luminosity;
	return result;
}

static void
power_services_device_set_luminosity (PowerServicesDevice* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_luminosity (self);
	if (old_value != value) {
		self->priv->_luminosity = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY]);
	}
}

gdouble
power_services_device_get_percentage (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_percentage;
	return result;
}

static void
power_services_device_set_percentage (PowerServicesDevice* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_percentage (self);
	if (old_value != value) {
		self->priv->_percentage = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY]);
	}
}

gdouble
power_services_device_get_temperature (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_temperature;
	return result;
}

static void
power_services_device_set_temperature (PowerServicesDevice* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_temperature (self);
	if (old_value != value) {
		self->priv->_temperature = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY]);
	}
}

gdouble
power_services_device_get_voltage (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_voltage;
	return result;
}

static void
power_services_device_set_voltage (PowerServicesDevice* self,
                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_voltage (self);
	if (old_value != value) {
		self->priv->_voltage = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY]);
	}
}

gint64
power_services_device_get_time_to_empty (PowerServicesDevice* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_time_to_empty;
	return result;
}

static void
power_services_device_set_time_to_empty (PowerServicesDevice* self,
                                         gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_time_to_empty (self);
	if (old_value != value) {
		self->priv->_time_to_empty = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY]);
	}
}

gint64
power_services_device_get_time_to_full (PowerServicesDevice* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_time_to_full;
	return result;
}

static void
power_services_device_set_time_to_full (PowerServicesDevice* self,
                                        gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_time_to_full (self);
	if (old_value != value) {
		self->priv->_time_to_full = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY]);
	}
}

const gchar*
power_services_device_get_model (PowerServicesDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

static void
power_services_device_set_model (PowerServicesDevice* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_model (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_MODEL_PROPERTY]);
	}
}

const gchar*
power_services_device_get_native_path (PowerServicesDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_native_path;
	result = _tmp0_;
	return result;
}

static void
power_services_device_set_native_path (PowerServicesDevice* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_native_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_native_path);
		self->priv->_native_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY]);
	}
}

const gchar*
power_services_device_get_serial (PowerServicesDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serial;
	result = _tmp0_;
	return result;
}

static void
power_services_device_set_serial (PowerServicesDevice* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_serial (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_serial);
		self->priv->_serial = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_SERIAL_PROPERTY]);
	}
}

const gchar*
power_services_device_get_vendor (PowerServicesDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_vendor;
	result = _tmp0_;
	return result;
}

static void
power_services_device_set_vendor (PowerServicesDevice* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_vendor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_vendor);
		self->priv->_vendor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_VENDOR_PROPERTY]);
	}
}

PowerServicesDeviceState
power_services_device_get_state (PowerServicesDevice* self)
{
	PowerServicesDeviceState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
power_services_device_set_state (PowerServicesDevice* self,
                                 PowerServicesDeviceState value)
{
	PowerServicesDeviceState old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_STATE_PROPERTY]);
	}
}

PowerServicesDeviceTechnology
power_services_device_get_technology (PowerServicesDevice* self)
{
	PowerServicesDeviceTechnology result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_technology;
	return result;
}

static void
power_services_device_set_technology (PowerServicesDevice* self,
                                      PowerServicesDeviceTechnology value)
{
	PowerServicesDeviceTechnology old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_technology (self);
	if (old_value != value) {
		self->priv->_technology = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY]);
	}
}

PowerServicesDeviceType
power_services_device_get_device_type (PowerServicesDevice* self)
{
	PowerServicesDeviceType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_device_type;
	return result;
}

static void
power_services_device_set_device_type (PowerServicesDevice* self,
                                       PowerServicesDeviceType value)
{
	PowerServicesDeviceType old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_device_type (self);
	if (old_value != value) {
		self->priv->_device_type = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY]);
	}
}

guint64
power_services_device_get_update_time (PowerServicesDevice* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_update_time;
	return result;
}

static void
power_services_device_set_update_time (PowerServicesDevice* self,
                                       guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_update_time (self);
	if (old_value != value) {
		self->priv->_update_time = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY]);
	}
}

gboolean
power_services_device_get_is_charging (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_charging;
	return result;
}

static void
power_services_device_set_is_charging (PowerServicesDevice* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_is_charging (self);
	if (old_value != value) {
		self->priv->_is_charging = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY]);
	}
}

gboolean
power_services_device_get_is_a_battery (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_a_battery;
	return result;
}

static void
power_services_device_set_is_a_battery (PowerServicesDevice* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_is_a_battery (self);
	if (old_value != value) {
		self->priv->_is_a_battery = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY]);
	}
}

static void
power_services_device_class_init (PowerServicesDeviceClass * klass,
                                  gpointer klass_data)
{
	power_services_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerServicesDevice_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_services_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_services_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = power_services_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY] = g_param_spec_boolean ("has-history", "has-history", "has-history", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY] = g_param_spec_boolean ("has-statistics", "has-statistics", "has-statistics", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY] = g_param_spec_boolean ("is-present", "is-present", "is-present", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY] = g_param_spec_boolean ("is-rechargeable", "is-rechargeable", "is-rechargeable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ONLINE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ONLINE_PROPERTY] = g_param_spec_boolean ("online", "online", "online", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY] = g_param_spec_boolean ("power-supply", "power-supply", "power-supply", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_CAPACITY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_CAPACITY_PROPERTY] = g_param_spec_double ("capacity", "capacity", "capacity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_PROPERTY] = g_param_spec_double ("energy", "energy", "energy", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY] = g_param_spec_double ("energy-empty", "energy-empty", "energy-empty", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY] = g_param_spec_double ("energy-full", "energy-full", "energy-full", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY] = g_param_spec_double ("energy-full-design", "energy-full-design", "energy-full-design", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY] = g_param_spec_double ("energy-rate", "energy-rate", "energy-rate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY] = g_param_spec_double ("luminosity", "luminosity", "luminosity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY] = g_param_spec_double ("percentage", "percentage", "percentage", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY] = g_param_spec_double ("temperature", "temperature", "temperature", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY] = g_param_spec_double ("voltage", "voltage", "voltage", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY] = g_param_spec_int64 ("time-to-empty", "time-to-empty", "time-to-empty", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY] = g_param_spec_int64 ("time-to-full", "time-to-full", "time-to-full", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MODEL_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_MODEL_PROPERTY] = g_param_spec_string ("model", "model", "model", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY] = g_param_spec_string ("native-path", "native-path", "native-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_SERIAL_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_SERIAL_PROPERTY] = g_param_spec_string ("serial", "serial", "serial", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_VENDOR_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_VENDOR_PROPERTY] = g_param_spec_string ("vendor", "vendor", "vendor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_STATE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", POWER_SERVICES_DEVICE_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY] = g_param_spec_enum ("technology", "technology", "technology", POWER_SERVICES_DEVICE_TYPE_TECHNOLOGY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY] = g_param_spec_enum ("device-type", "device-type", "device-type", POWER_SERVICES_DEVICE_TYPE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY] = g_param_spec_uint64 ("update-time", "update-time", "update-time", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY] = g_param_spec_boolean ("is-charging", "is-charging", "is-charging", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY] = g_param_spec_boolean ("is-a-battery", "is-a-battery", "is-a-battery", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	power_services_device_signals[POWER_SERVICES_DEVICE_PROPERTIES_UPDATED_SIGNAL] = g_signal_new ("properties-updated", POWER_SERVICES_TYPE_DEVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
power_services_device_instance_init (PowerServicesDevice * self,
                                     gpointer klass)
{
	gchar* _tmp0_;
	self->priv = power_services_device_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->device_path = _tmp0_;
	self->priv->device = NULL;
}

static void
power_services_device_finalize (GObject * obj)
{
	PowerServicesDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_SERVICES_TYPE_DEVICE, PowerServicesDevice);
	_g_free0 (self->priv->device_path);
	_g_object_unref0 (self->priv->device);
	_g_free0 (self->priv->_model);
	_g_free0 (self->priv->_native_path);
	_g_free0 (self->priv->_serial);
	_g_free0 (self->priv->_vendor);
	G_OBJECT_CLASS (power_services_device_parent_class)->finalize (obj);
}

static GType
power_services_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerServicesDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_services_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerServicesDevice), 0, (GInstanceInitFunc) power_services_device_instance_init, NULL };
	GType power_services_device_type_id;
	power_services_device_type_id = g_type_register_static (G_TYPE_OBJECT, "PowerServicesDevice", &g_define_type_info, 0);
	PowerServicesDevice_private_offset = g_type_add_instance_private (power_services_device_type_id, sizeof (PowerServicesDevicePrivate));
	return power_services_device_type_id;
}

GType
power_services_device_get_type (void)
{
	static volatile gsize power_services_device_type_id__once = 0;
	if (g_once_init_enter (&power_services_device_type_id__once)) {
		GType power_services_device_type_id;
		power_services_device_type_id = power_services_device_get_type_once ();
		g_once_init_leave (&power_services_device_type_id__once, power_services_device_type_id);
	}
	return power_services_device_type_id__once;
}

static void
_vala_power_services_device_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PowerServicesDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_SERVICES_TYPE_DEVICE, PowerServicesDevice);
	switch (property_id) {
		case POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_has_history (self));
		break;
		case POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_has_statistics (self));
		break;
		case POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_is_present (self));
		break;
		case POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_is_rechargeable (self));
		break;
		case POWER_SERVICES_DEVICE_ONLINE_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_online (self));
		break;
		case POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_power_supply (self));
		break;
		case POWER_SERVICES_DEVICE_CAPACITY_PROPERTY:
		g_value_set_double (value, power_services_device_get_capacity (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy_empty (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy_full (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy_full_design (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy_rate (self));
		break;
		case POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY:
		g_value_set_double (value, power_services_device_get_luminosity (self));
		break;
		case POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY:
		g_value_set_double (value, power_services_device_get_percentage (self));
		break;
		case POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY:
		g_value_set_double (value, power_services_device_get_temperature (self));
		break;
		case POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY:
		g_value_set_double (value, power_services_device_get_voltage (self));
		break;
		case POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY:
		g_value_set_int64 (value, power_services_device_get_time_to_empty (self));
		break;
		case POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY:
		g_value_set_int64 (value, power_services_device_get_time_to_full (self));
		break;
		case POWER_SERVICES_DEVICE_MODEL_PROPERTY:
		g_value_set_string (value, power_services_device_get_model (self));
		break;
		case POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY:
		g_value_set_string (value, power_services_device_get_native_path (self));
		break;
		case POWER_SERVICES_DEVICE_SERIAL_PROPERTY:
		g_value_set_string (value, power_services_device_get_serial (self));
		break;
		case POWER_SERVICES_DEVICE_VENDOR_PROPERTY:
		g_value_set_string (value, power_services_device_get_vendor (self));
		break;
		case POWER_SERVICES_DEVICE_STATE_PROPERTY:
		g_value_set_enum (value, power_services_device_get_state (self));
		break;
		case POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY:
		g_value_set_enum (value, power_services_device_get_technology (self));
		break;
		case POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY:
		g_value_set_enum (value, power_services_device_get_device_type (self));
		break;
		case POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY:
		g_value_set_uint64 (value, power_services_device_get_update_time (self));
		break;
		case POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_is_charging (self));
		break;
		case POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_is_a_battery (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_services_device_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	PowerServicesDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_SERVICES_TYPE_DEVICE, PowerServicesDevice);
	switch (property_id) {
		case POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY:
		power_services_device_set_has_history (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY:
		power_services_device_set_has_statistics (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY:
		power_services_device_set_is_present (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY:
		power_services_device_set_is_rechargeable (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_ONLINE_PROPERTY:
		power_services_device_set_online (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY:
		power_services_device_set_power_supply (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_CAPACITY_PROPERTY:
		power_services_device_set_capacity (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_PROPERTY:
		power_services_device_set_energy (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY:
		power_services_device_set_energy_empty (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY:
		power_services_device_set_energy_full (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY:
		power_services_device_set_energy_full_design (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY:
		power_services_device_set_energy_rate (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY:
		power_services_device_set_luminosity (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY:
		power_services_device_set_percentage (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY:
		power_services_device_set_temperature (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY:
		power_services_device_set_voltage (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY:
		power_services_device_set_time_to_empty (self, g_value_get_int64 (value));
		break;
		case POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY:
		power_services_device_set_time_to_full (self, g_value_get_int64 (value));
		break;
		case POWER_SERVICES_DEVICE_MODEL_PROPERTY:
		power_services_device_set_model (self, g_value_get_string (value));
		break;
		case POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY:
		power_services_device_set_native_path (self, g_value_get_string (value));
		break;
		case POWER_SERVICES_DEVICE_SERIAL_PROPERTY:
		power_services_device_set_serial (self, g_value_get_string (value));
		break;
		case POWER_SERVICES_DEVICE_VENDOR_PROPERTY:
		power_services_device_set_vendor (self, g_value_get_string (value));
		break;
		case POWER_SERVICES_DEVICE_STATE_PROPERTY:
		power_services_device_set_state (self, g_value_get_enum (value));
		break;
		case POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY:
		power_services_device_set_technology (self, g_value_get_enum (value));
		break;
		case POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY:
		power_services_device_set_device_type (self, g_value_get_enum (value));
		break;
		case POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY:
		power_services_device_set_update_time (self, g_value_get_uint64 (value));
		break;
		case POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY:
		power_services_device_set_is_charging (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY:
		power_services_device_set_is_a_battery (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

