/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureDimension.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUTextureDimension enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("1d"),
        MAKE_STATIC_STRING_IMPL("2d"),
        MAKE_STATIC_STRING_IMPL("3d"),
    };
    static_assert(static_cast<size_t>(GPUTextureDimension::_1d) == 0, "GPUTextureDimension::_1d is not 0 as expected");
    static_assert(static_cast<size_t>(GPUTextureDimension::_2d) == 1, "GPUTextureDimension::_2d is not 1 as expected");
    static_assert(static_cast<size_t>(GPUTextureDimension::_3d) == 2, "GPUTextureDimension::_3d is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUTextureDimension enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUTextureDimension> parseEnumerationFromString<GPUTextureDimension>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GPUTextureDimension>, 3> mappings {
        std::pair<ComparableASCIILiteral, GPUTextureDimension> { "1d"_s, GPUTextureDimension::_1d },
        std::pair<ComparableASCIILiteral, GPUTextureDimension> { "2d"_s, GPUTextureDimension::_2d },
        std::pair<ComparableASCIILiteral, GPUTextureDimension> { "3d"_s, GPUTextureDimension::_3d },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUTextureDimension> parseEnumeration<GPUTextureDimension>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUTextureDimension>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUTextureDimension>()
{
    return "\"1d\", \"2d\", \"3d\""_s;
}

} // namespace WebCore

