/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_CAPTURE_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define TREELAND_CAPTURE_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_capture_unstable_v1 The treeland_capture_unstable_v1 protocol
 * protocol for capturing output contents or window contents
 *
 * @section page_desc_treeland_capture_unstable_v1 Description
 *
 * This protocol allows authorized application to capture output contents or window
 * contents(useful for window streaming).
 *
 * @section page_ifaces_treeland_capture_unstable_v1 Interfaces
 * - @subpage page_iface_treeland_capture_session_v1 - 
 * - @subpage page_iface_treeland_capture_frame_v1 - 
 * - @subpage page_iface_treeland_capture_context_v1 - 
 * - @subpage page_iface_treeland_capture_manager_v1 - 
 * @section page_copyright_treeland_capture_unstable_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_capture_context_v1;
struct treeland_capture_frame_v1;
struct treeland_capture_manager_v1;
struct treeland_capture_session_v1;
struct wl_buffer;
struct wl_surface;

#ifndef TREELAND_CAPTURE_SESSION_V1_INTERFACE
#define TREELAND_CAPTURE_SESSION_V1_INTERFACE
/**
 * @page page_iface_treeland_capture_session_v1 treeland_capture_session_v1
 * @section page_iface_treeland_capture_session_v1_api API
 * See @ref iface_treeland_capture_session_v1.
 */
/**
 * @defgroup iface_treeland_capture_session_v1 The treeland_capture_session_v1 interface
 */
extern const struct wl_interface treeland_capture_session_v1_interface;
#endif
#ifndef TREELAND_CAPTURE_FRAME_V1_INTERFACE
#define TREELAND_CAPTURE_FRAME_V1_INTERFACE
/**
 * @page page_iface_treeland_capture_frame_v1 treeland_capture_frame_v1
 * @section page_iface_treeland_capture_frame_v1_api API
 * See @ref iface_treeland_capture_frame_v1.
 */
/**
 * @defgroup iface_treeland_capture_frame_v1 The treeland_capture_frame_v1 interface
 */
extern const struct wl_interface treeland_capture_frame_v1_interface;
#endif
#ifndef TREELAND_CAPTURE_CONTEXT_V1_INTERFACE
#define TREELAND_CAPTURE_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_capture_context_v1 treeland_capture_context_v1
 * @section page_iface_treeland_capture_context_v1_api API
 * See @ref iface_treeland_capture_context_v1.
 */
/**
 * @defgroup iface_treeland_capture_context_v1 The treeland_capture_context_v1 interface
 */
extern const struct wl_interface treeland_capture_context_v1_interface;
#endif
#ifndef TREELAND_CAPTURE_MANAGER_V1_INTERFACE
#define TREELAND_CAPTURE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_capture_manager_v1 treeland_capture_manager_v1
 * @section page_iface_treeland_capture_manager_v1_api API
 * See @ref iface_treeland_capture_manager_v1.
 */
/**
 * @defgroup iface_treeland_capture_manager_v1 The treeland_capture_manager_v1 interface
 */
extern const struct wl_interface treeland_capture_manager_v1_interface;
#endif

#ifndef TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_ENUM
#define TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_ENUM
enum treeland_capture_session_v1_cancel_reason {
	/**
	 * temporary error, source will produce more frames
	 */
	TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_TEMPORARY = 0,
	/**
	 * fatal error, source will not produce frames
	 */
	TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_PERMANENT = 1,
	/**
	 * temporary error, source will produce more frames
	 */
	TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_RESIZING = 2,
};
#endif /* TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_ENUM */

#ifndef TREELAND_CAPTURE_SESSION_V1_FLAGS_ENUM
#define TREELAND_CAPTURE_SESSION_V1_FLAGS_ENUM
enum treeland_capture_session_v1_flags {
	/**
	 * clients should copy frame before processing
	 */
	TREELAND_CAPTURE_SESSION_V1_FLAGS_TRANSIENT = 0x1,
};
#endif /* TREELAND_CAPTURE_SESSION_V1_FLAGS_ENUM */

/**
 * @ingroup iface_treeland_capture_session_v1
 * @struct treeland_capture_session_v1_listener
 */
struct treeland_capture_session_v1_listener {
	/**
	 * supply the client with information about the frame
	 *
	 * Main event supplying the client with information about the
	 * frame. If the capture didn't fail, this event is always emitted
	 * first before any other events. When mask is provided, x and y
	 * should be offset relative to mask surface origin. Otherwise
	 * offset_x and offset_y should always be zero.
	 * @param offset_x crop offset x
	 * @param offset_y crop offset y
	 */
	void (*frame)(void *data,
		      struct treeland_capture_session_v1 *treeland_capture_session_v1,
		      int32_t offset_x,
		      int32_t offset_y,
		      uint32_t width,
		      uint32_t height,
		      uint32_t buffer_flags,
		      uint32_t flags,
		      uint32_t format,
		      uint32_t mod_high,
		      uint32_t mod_low,
		      uint32_t num_objects);
	/**
	 * supply the client with object fd
	 *
	 * 
	 */
	void (*object)(void *data,
		       struct treeland_capture_session_v1 *treeland_capture_session_v1,
		       uint32_t index,
		       int32_t fd,
		       uint32_t size,
		       uint32_t offset,
		       uint32_t stride,
		       uint32_t plane_index);
	/**
	 * indicates frame is available for reading
	 *
	 * This event is sent as soon as the frame is presented,
	 * indicating it is available for reading. This event includes the
	 * time at which presentation happened at.
	 */
	void (*ready)(void *data,
		      struct treeland_capture_session_v1 *treeland_capture_session_v1,
		      uint32_t tv_sec_hi,
		      uint32_t tv_sec_lo,
		      uint32_t tv_nsec);
	/**
	 * Notifies current frame is no longer valid.
	 *
	 * If the capture failed or if the frame is no longer valid after
	 * the "frame" event has been emitted, this event will be used to
	 * inform the client to scrap the frame.
	 */
	void (*cancel)(void *data,
		       struct treeland_capture_session_v1 *treeland_capture_session_v1,
		       uint32_t reason);
};

/**
 * @ingroup iface_treeland_capture_session_v1
 */
static inline int
treeland_capture_session_v1_add_listener(struct treeland_capture_session_v1 *treeland_capture_session_v1,
					 const struct treeland_capture_session_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_capture_session_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_CAPTURE_SESSION_V1_DESTROY 0
#define TREELAND_CAPTURE_SESSION_V1_START 1
#define TREELAND_CAPTURE_SESSION_V1_FRAME_DONE 2

/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_FRAME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_OBJECT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_READY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_CANCEL_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_START_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_FRAME_DONE_SINCE_VERSION 1

/** @ingroup iface_treeland_capture_session_v1 */
static inline void
treeland_capture_session_v1_set_user_data(struct treeland_capture_session_v1 *treeland_capture_session_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_capture_session_v1, user_data);
}

/** @ingroup iface_treeland_capture_session_v1 */
static inline void *
treeland_capture_session_v1_get_user_data(struct treeland_capture_session_v1 *treeland_capture_session_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_capture_session_v1);
}

static inline uint32_t
treeland_capture_session_v1_get_version(struct treeland_capture_session_v1 *treeland_capture_session_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_capture_session_v1);
}

/**
 * @ingroup iface_treeland_capture_session_v1
 *
 * Unreferences the frame. This request must be called as soon as it's no longer valid.
 */
static inline void
treeland_capture_session_v1_destroy(struct treeland_capture_session_v1 *treeland_capture_session_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_session_v1,
			 TREELAND_CAPTURE_SESSION_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_capture_session_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_capture_session_v1
 *
 * Start session and keeps sending frame.
 */
static inline void
treeland_capture_session_v1_start(struct treeland_capture_session_v1 *treeland_capture_session_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_session_v1,
			 TREELAND_CAPTURE_SESSION_V1_START, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_capture_session_v1), 0);
}

/**
 * @ingroup iface_treeland_capture_session_v1
 *
 * This is the ACK to the current "ready" event. The next "frame" event will be sent only when current
 * "ready" event is acknowledged. The timestamp should be the same as the one sent in "ready" event.
 * If the frame has the "transient" flag, all objects sent before become invalid after this event.
 */
static inline void
treeland_capture_session_v1_frame_done(struct treeland_capture_session_v1 *treeland_capture_session_v1, uint32_t tv_sec_hi, uint32_t tv_sec_lo, uint32_t tv_usec)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_session_v1,
			 TREELAND_CAPTURE_SESSION_V1_FRAME_DONE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_capture_session_v1), 0, tv_sec_hi, tv_sec_lo, tv_usec);
}

#ifndef TREELAND_CAPTURE_FRAME_V1_FLAGS_ENUM
#define TREELAND_CAPTURE_FRAME_V1_FLAGS_ENUM
enum treeland_capture_frame_v1_flags {
	/**
	 * contents are y-inverted
	 */
	TREELAND_CAPTURE_FRAME_V1_FLAGS_Y_INVERTED = 0x1,
};
#endif /* TREELAND_CAPTURE_FRAME_V1_FLAGS_ENUM */

/**
 * @ingroup iface_treeland_capture_frame_v1
 * @struct treeland_capture_frame_v1_listener
 */
struct treeland_capture_frame_v1_listener {
	/**
	 * inform client to prepare buffer
	 *
	 * Inform client to prepare buffer.
	 */
	void (*buffer)(void *data,
		       struct treeland_capture_frame_v1 *treeland_capture_frame_v1,
		       uint32_t format,
		       uint32_t width,
		       uint32_t height,
		       uint32_t stride);
	/**
	 * all buffer formats have done
	 *
	 * Inform client that all buffer formats supported are emitted.
	 */
	void (*buffer_done)(void *data,
			    struct treeland_capture_frame_v1 *treeland_capture_frame_v1);
	/**
	 * frame flags
	 *
	 * Provides flags about the frame. This event is sent once before
	 * the "ready" event.
	 * @param flags frame flags
	 */
	void (*flags)(void *data,
		      struct treeland_capture_frame_v1 *treeland_capture_frame_v1,
		      uint32_t flags);
	/**
	 * buffer is copied
	 *
	 * Inform that buffer is ready for reading
	 */
	void (*ready)(void *data,
		      struct treeland_capture_frame_v1 *treeland_capture_frame_v1);
	/**
	 * frame copy failed
	 *
	 * Inform that frame copy fails.
	 */
	void (*failed)(void *data,
		       struct treeland_capture_frame_v1 *treeland_capture_frame_v1);
};

/**
 * @ingroup iface_treeland_capture_frame_v1
 */
static inline int
treeland_capture_frame_v1_add_listener(struct treeland_capture_frame_v1 *treeland_capture_frame_v1,
				       const struct treeland_capture_frame_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_capture_frame_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_CAPTURE_FRAME_V1_DESTROY 0
#define TREELAND_CAPTURE_FRAME_V1_COPY 1

/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_BUFFER_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_FLAGS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_READY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_COPY_SINCE_VERSION 1

/** @ingroup iface_treeland_capture_frame_v1 */
static inline void
treeland_capture_frame_v1_set_user_data(struct treeland_capture_frame_v1 *treeland_capture_frame_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_capture_frame_v1, user_data);
}

/** @ingroup iface_treeland_capture_frame_v1 */
static inline void *
treeland_capture_frame_v1_get_user_data(struct treeland_capture_frame_v1 *treeland_capture_frame_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_capture_frame_v1);
}

static inline uint32_t
treeland_capture_frame_v1_get_version(struct treeland_capture_frame_v1 *treeland_capture_frame_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_capture_frame_v1);
}

/**
 * @ingroup iface_treeland_capture_frame_v1
 *
 * Destroys the context. This request can be sent at any time by the client.
 */
static inline void
treeland_capture_frame_v1_destroy(struct treeland_capture_frame_v1 *treeland_capture_frame_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_frame_v1,
			 TREELAND_CAPTURE_FRAME_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_capture_frame_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_capture_frame_v1
 *
 * Copy capture contents to provided buffer
 */
static inline void
treeland_capture_frame_v1_copy(struct treeland_capture_frame_v1 *treeland_capture_frame_v1, struct wl_buffer *buffer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_frame_v1,
			 TREELAND_CAPTURE_FRAME_V1_COPY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_capture_frame_v1), 0, buffer);
}

#ifndef TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_ENUM
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_ENUM
enum treeland_capture_context_v1_source_type {
	/**
	 * output source type
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_OUTPUT = 0x1,
	/**
	 * window source type
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_WINDOW = 0x2,
	/**
	 * region source type
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_REGION = 0x4,
};
#endif /* TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_ENUM */

#ifndef TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_ENUM
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_ENUM
/**
 * @ingroup iface_treeland_capture_context_v1
 * source failure reason
 *
 */
enum treeland_capture_context_v1_source_failure {
	/**
	 * selector is occupied by other context
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_SELECTOR_BUSY = 1,
	/**
	 * User cancel this context from compositor
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_USER_CANCEL = 2,
	/**
	 * Source has been destroyed
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_SOURCE_DESTROYED = 3,
	/**
	 * other failure
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_OTHER = 4,
};
#endif /* TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_ENUM */

/**
 * @ingroup iface_treeland_capture_context_v1
 * @struct treeland_capture_context_v1_listener
 */
struct treeland_capture_context_v1_listener {
	/**
	 * notify client that source is ready
	 *
	 * This event supplies the client some information about the
	 * capture source, including the capture region relative to mask
	 * and source type.
	 * @param region_x offset x of capture region relative to mask for capture contents
	 * @param region_y offset y of capture region relative to mask for capture contents
	 * @param region_width width of capture region
	 * @param region_height height of capture region
	 * @param source_type final capture source type
	 */
	void (*source_ready)(void *data,
			     struct treeland_capture_context_v1 *treeland_capture_context_v1,
			     int32_t region_x,
			     int32_t region_y,
			     uint32_t region_width,
			     uint32_t region_height,
			     uint32_t source_type);
	/**
	 * notify client that source selection is failed
	 *
	 * There could a lot of reasons but the most common one is that
	 * selector is busy
	 */
	void (*source_failed)(void *data,
			      struct treeland_capture_context_v1 *treeland_capture_context_v1,
			      uint32_t reason);
};

/**
 * @ingroup iface_treeland_capture_context_v1
 */
static inline int
treeland_capture_context_v1_add_listener(struct treeland_capture_context_v1 *treeland_capture_context_v1,
					 const struct treeland_capture_context_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_capture_context_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_CAPTURE_CONTEXT_V1_DESTROY 0
#define TREELAND_CAPTURE_CONTEXT_V1_SELECT_SOURCE 1
#define TREELAND_CAPTURE_CONTEXT_V1_CAPTURE 2
#define TREELAND_CAPTURE_CONTEXT_V1_CREATE_SESSION 3

/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_READY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_SELECT_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_CAPTURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_CREATE_SESSION_SINCE_VERSION 1

/** @ingroup iface_treeland_capture_context_v1 */
static inline void
treeland_capture_context_v1_set_user_data(struct treeland_capture_context_v1 *treeland_capture_context_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_capture_context_v1, user_data);
}

/** @ingroup iface_treeland_capture_context_v1 */
static inline void *
treeland_capture_context_v1_get_user_data(struct treeland_capture_context_v1 *treeland_capture_context_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_capture_context_v1);
}

static inline uint32_t
treeland_capture_context_v1_get_version(struct treeland_capture_context_v1 *treeland_capture_context_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_capture_context_v1);
}

/**
 * @ingroup iface_treeland_capture_context_v1
 *
 * Destroys the context. This request can be sent at any time by the client.
 */
static inline void
treeland_capture_context_v1_destroy(struct treeland_capture_context_v1 *treeland_capture_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_context_v1,
			 TREELAND_CAPTURE_CONTEXT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_capture_context_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_capture_context_v1
 *
 * Selector is provided by compositor. Client can provide source hint to hint compositor
 * to provide certain kinds of source.
 */
static inline void
treeland_capture_context_v1_select_source(struct treeland_capture_context_v1 *treeland_capture_context_v1, uint32_t source_hint, uint32_t freeze, uint32_t with_cursor, struct wl_surface *mask)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_context_v1,
			 TREELAND_CAPTURE_CONTEXT_V1_SELECT_SOURCE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_capture_context_v1), 0, source_hint, freeze, with_cursor, mask);
}

/**
 * @ingroup iface_treeland_capture_context_v1
 *
 * This event can be called just once. A second call might result in a protocol error cause
 * we just provide transient
 */
static inline struct treeland_capture_frame_v1 *
treeland_capture_context_v1_capture(struct treeland_capture_context_v1 *treeland_capture_context_v1)
{
	struct wl_proxy *frame;

	frame = wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_context_v1,
			 TREELAND_CAPTURE_CONTEXT_V1_CAPTURE, &treeland_capture_frame_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_capture_context_v1), 0, NULL);

	return (struct treeland_capture_frame_v1 *) frame;
}

/**
 * @ingroup iface_treeland_capture_context_v1
 *
 * Often used by a screen recorder.
 */
static inline struct treeland_capture_session_v1 *
treeland_capture_context_v1_create_session(struct treeland_capture_context_v1 *treeland_capture_context_v1)
{
	struct wl_proxy *session;

	session = wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_context_v1,
			 TREELAND_CAPTURE_CONTEXT_V1_CREATE_SESSION, &treeland_capture_session_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_capture_context_v1), 0, NULL);

	return (struct treeland_capture_session_v1 *) session;
}

#define TREELAND_CAPTURE_MANAGER_V1_DESTROY 0
#define TREELAND_CAPTURE_MANAGER_V1_GET_CONTEXT 1


/**
 * @ingroup iface_treeland_capture_manager_v1
 */
#define TREELAND_CAPTURE_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_manager_v1
 */
#define TREELAND_CAPTURE_MANAGER_V1_GET_CONTEXT_SINCE_VERSION 1

/** @ingroup iface_treeland_capture_manager_v1 */
static inline void
treeland_capture_manager_v1_set_user_data(struct treeland_capture_manager_v1 *treeland_capture_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_capture_manager_v1, user_data);
}

/** @ingroup iface_treeland_capture_manager_v1 */
static inline void *
treeland_capture_manager_v1_get_user_data(struct treeland_capture_manager_v1 *treeland_capture_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_capture_manager_v1);
}

static inline uint32_t
treeland_capture_manager_v1_get_version(struct treeland_capture_manager_v1 *treeland_capture_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_capture_manager_v1);
}

/**
 * @ingroup iface_treeland_capture_manager_v1
 *
 * Destroy the treeland_capture_manager_v1 object.
 */
static inline void
treeland_capture_manager_v1_destroy(struct treeland_capture_manager_v1 *treeland_capture_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_manager_v1,
			 TREELAND_CAPTURE_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_capture_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_capture_manager_v1
 *
 */
static inline struct treeland_capture_context_v1 *
treeland_capture_manager_v1_get_context(struct treeland_capture_manager_v1 *treeland_capture_manager_v1)
{
	struct wl_proxy *context;

	context = wl_proxy_marshal_flags((struct wl_proxy *) treeland_capture_manager_v1,
			 TREELAND_CAPTURE_MANAGER_V1_GET_CONTEXT, &treeland_capture_context_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_capture_manager_v1), 0, NULL);

	return (struct treeland_capture_context_v1 *) context;
}

#ifdef  __cplusplus
}
#endif

#endif
