// components/language_detection/content/common/language_detection.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_LANGUAGE_DETECTION_CONTENT_COMMON_LANGUAGE_DETECTION_MOJOM_H_
#define COMPONENTS_LANGUAGE_DETECTION_CONTENT_COMMON_LANGUAGE_DETECTION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/language_detection/content/common/language_detection.mojom-features.h"  // IWYU pragma: export
#include "components/language_detection/content/common/language_detection.mojom-shared.h"  // IWYU pragma: export
#include "components/language_detection/content/common/language_detection.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace language_detection::mojom {

class ContentLanguageDetectionDriverProxy;

template <typename ImplRefTraits>
class ContentLanguageDetectionDriverStub;

class ContentLanguageDetectionDriverRequestValidator;
class ContentLanguageDetectionDriverResponseValidator;


class ContentLanguageDetectionDriver
    : public ContentLanguageDetectionDriverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContentLanguageDetectionDriverInterfaceBase;
  using Proxy_ = ContentLanguageDetectionDriverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContentLanguageDetectionDriverStub<ImplRefTraits>;

  using RequestValidator_ = ContentLanguageDetectionDriverRequestValidator;
  using ResponseValidator_ = ContentLanguageDetectionDriverResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetLanguageDetectionModelMinVersion = 0,
    kGetLanguageDetectionModelStatusMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetLanguageDetectionModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetLanguageDetectionModelStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ContentLanguageDetectionDriver() = default;


  using GetLanguageDetectionModelCallback = base::OnceCallback<void(::base::File)>;
  
  virtual void GetLanguageDetectionModel(GetLanguageDetectionModelCallback callback) = 0;


  using GetLanguageDetectionModelStatusCallback = base::OnceCallback<void(LanguageDetectionModelStatus)>;
  
  virtual void GetLanguageDetectionModelStatus(GetLanguageDetectionModelStatusCallback callback) = 0;
};



class  ContentLanguageDetectionDriverProxy
    : public ContentLanguageDetectionDriver {
 public:
  using InterfaceType = ContentLanguageDetectionDriver;

  explicit ContentLanguageDetectionDriverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetLanguageDetectionModel(GetLanguageDetectionModelCallback callback) final;
  
  void GetLanguageDetectionModelStatus(GetLanguageDetectionModelStatusCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ContentLanguageDetectionDriverStubDispatch {
 public:
  static bool Accept(ContentLanguageDetectionDriver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContentLanguageDetectionDriver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContentLanguageDetectionDriver>>
class ContentLanguageDetectionDriverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContentLanguageDetectionDriverStub() = default;
  ~ContentLanguageDetectionDriverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentLanguageDetectionDriverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentLanguageDetectionDriverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContentLanguageDetectionDriverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ContentLanguageDetectionDriverResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // language_detection::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_LANGUAGE_DETECTION_CONTENT_COMMON_LANGUAGE_DETECTION_MOJOM_H_