// gpu/ipc/common/vulkan_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/vulkan_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/vulkan_types.mojom-params-data.h"
namespace gpu {
namespace mojom {

NOINLINE static const char* VkPhysicalDeviceTypeToStringHelper(VkPhysicalDeviceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VkPhysicalDeviceType::INVALID_VALUE:
      return "INVALID_VALUE";
    case VkPhysicalDeviceType::OTHER:
      return "OTHER";
    case VkPhysicalDeviceType::INTEGRATED_GPU:
      return "INTEGRATED_GPU";
    case VkPhysicalDeviceType::DISCRETE_GPU:
      return "DISCRETE_GPU";
    case VkPhysicalDeviceType::VIRTUAL_GPU:
      return "VIRTUAL_GPU";
    case VkPhysicalDeviceType::CPU:
      return "CPU";
    default:
      return nullptr;
  }
}

std::string VkPhysicalDeviceTypeToString(VkPhysicalDeviceType value) {
  const char *str = VkPhysicalDeviceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VkPhysicalDeviceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VkPhysicalDeviceType value) {
  return os << VkPhysicalDeviceTypeToString(value);
}

namespace internal {


// static
bool VkExtensionProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VkExtensionProperties_Data* object =
      static_cast<const VkExtensionProperties_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extensionName, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extensionName_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extensionName, validation_context,
                                         &extensionName_validate_params)) {
    return false;
  }

  return true;
}

VkExtensionProperties_Data::VkExtensionProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkLayerProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VkLayerProperties_Data* object =
      static_cast<const VkLayerProperties_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layerName, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& layerName_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->layerName, validation_context,
                                         &layerName_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

VkLayerProperties_Data::VkLayerProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkPhysicalDeviceLimits_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 488, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VkPhysicalDeviceLimits_Data* object =
      static_cast<const VkPhysicalDeviceLimits_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->maxComputeWorkGroupCount, 53, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& maxComputeWorkGroupCount_validate_params =
      mojo::internal::GetArrayValidator<3, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->maxComputeWorkGroupCount, validation_context,
                                         &maxComputeWorkGroupCount_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->maxComputeWorkGroupSize, 55, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& maxComputeWorkGroupSize_validate_params =
      mojo::internal::GetArrayValidator<3, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->maxComputeWorkGroupSize, validation_context,
                                         &maxComputeWorkGroupSize_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->maxViewportDimensions, 64, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& maxViewportDimensions_validate_params =
      mojo::internal::GetArrayValidator<2, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->maxViewportDimensions, validation_context,
                                         &maxViewportDimensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewportBoundsRange, 65, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& viewportBoundsRange_validate_params =
      mojo::internal::GetArrayValidator<2, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->viewportBoundsRange, validation_context,
                                         &viewportBoundsRange_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pointSizeRange, 98, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pointSizeRange_validate_params =
      mojo::internal::GetArrayValidator<2, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pointSizeRange, validation_context,
                                         &pointSizeRange_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lineWidthRange, 99, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& lineWidthRange_validate_params =
      mojo::internal::GetArrayValidator<2, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->lineWidthRange, validation_context,
                                         &lineWidthRange_validate_params)) {
    return false;
  }

  return true;
}

VkPhysicalDeviceLimits_Data::VkPhysicalDeviceLimits_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkPhysicalDeviceSparseProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VkPhysicalDeviceSparseProperties_Data* object =
      static_cast<const VkPhysicalDeviceSparseProperties_Data*>(data);

  return true;
}

VkPhysicalDeviceSparseProperties_Data::VkPhysicalDeviceSparseProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkPhysicalDeviceProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VkPhysicalDeviceProperties_Data* object =
      static_cast<const VkPhysicalDeviceProperties_Data*>(data);


  if (!::gpu::mojom::internal::VkPhysicalDeviceType_Data
        ::Validate(object->deviceType, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deviceName, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& deviceName_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->deviceName, validation_context,
                                         &deviceName_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pipelineCacheUUID, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pipelineCacheUUID_validate_params =
      mojo::internal::GetArrayValidator<16, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pipelineCacheUUID, validation_context,
                                         &pipelineCacheUUID_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->limits, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->limits, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sparseProperties, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sparseProperties, validation_context))
    return false;

  return true;
}

VkPhysicalDeviceProperties_Data::VkPhysicalDeviceProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkPhysicalDeviceFeatures_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VkPhysicalDeviceFeatures_Data* object =
      static_cast<const VkPhysicalDeviceFeatures_Data*>(data);

  return true;
}

VkPhysicalDeviceFeatures_Data::VkPhysicalDeviceFeatures_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkExtent3D_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VkExtent3D_Data* object =
      static_cast<const VkExtent3D_Data*>(data);

  return true;
}

VkExtent3D_Data::VkExtent3D_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkQueueFamilyProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VkQueueFamilyProperties_Data* object =
      static_cast<const VkQueueFamilyProperties_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->minImageTransferGranularity, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->minImageTransferGranularity, validation_context))
    return false;

  return true;
}

VkQueueFamilyProperties_Data::VkQueueFamilyProperties_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::VkPhysicalDeviceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::VkPhysicalDeviceType value) {
  return std::move(context).WriteString(::gpu::mojom::VkPhysicalDeviceTypeToString(value));
}

} // namespace perfetto