// third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/scroll/scrollbar_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/color_scheme.mojom-shared.h"
#include "third_party/blink/public/mojom/css/preferred_color_scheme.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class FrameOwnerPropertiesDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FrameOwnerPropertiesDataView> {
  using Data = ::blink::mojom::internal::FrameOwnerProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class FrameOwnerPropertiesDataView {
 public:
  FrameOwnerPropertiesDataView() = default;

  FrameOwnerPropertiesDataView(
      internal::FrameOwnerProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScrollbarMode(UserType* output) const {
    auto data_value = data_->scrollbar_mode;
    return mojo::internal::Deserialize<::blink::mojom::ScrollbarMode>(
        data_value, output);
  }
  ::blink::mojom::ScrollbarMode scrollbar_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScrollbarMode>(data_->scrollbar_mode));
  }
  int32_t margin_width() const {
    return data_->margin_width;
  }
  int32_t margin_height() const {
    return data_->margin_height;
  }
  bool allow_fullscreen() const {
    return data_->allow_fullscreen;
  }
  bool allow_payment_request() const {
    return data_->allow_payment_request;
  }
  bool is_display_none() const {
    return data_->is_display_none;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColorScheme(UserType* output) const {
    auto data_value = data_->color_scheme;
    return mojo::internal::Deserialize<::blink::mojom::ColorScheme>(
        data_value, output);
  }
  ::blink::mojom::ColorScheme color_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ColorScheme>(data_->color_scheme));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredColorScheme(UserType* output) const {
    auto data_value = data_->preferred_color_scheme;
    return mojo::internal::Deserialize<::blink::mojom::PreferredColorScheme>(
        data_value, output);
  }
  ::blink::mojom::PreferredColorScheme preferred_color_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PreferredColorScheme>(data_->preferred_color_scheme));
  }
 private:
  internal::FrameOwnerProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FrameOwnerPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FrameOwnerPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FrameOwnerProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in FrameOwnerProperties struct");
    mojo::internal::Serialize<::blink::mojom::ScrollbarMode>(
        Traits::scrollbar_mode(input), &fragment->scrollbar_mode);
    fragment->margin_width = Traits::margin_width(input);
    fragment->margin_height = Traits::margin_height(input);
    fragment->allow_fullscreen = Traits::allow_fullscreen(input);
    fragment->allow_payment_request = Traits::allow_payment_request(input);
    fragment->is_display_none = Traits::is_display_none(input);
    mojo::internal::Serialize<::blink::mojom::ColorScheme>(
        Traits::color_scheme(input), &fragment->color_scheme);
    mojo::internal::Serialize<::blink::mojom::PreferredColorScheme>(
        Traits::preferred_color_scheme(input), &fragment->preferred_color_scheme);
  }

  static bool Deserialize(::blink::mojom::internal::FrameOwnerProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FrameOwnerPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FrameOwnerPropertiesDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_SHARED_H_