// ui/gfx/mojom/gpu_fence_handle.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_GPU_FENCE_HANDLE_MOJOM_H_
#define UI_GFX_MOJOM_GPU_FENCE_HANDLE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/gpu_fence_handle.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/gpu_fence_handle.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "ui/gfx/mojom/gpu_fence_handle_mojom_traits.h"




namespace gfx::mojom {








class  GpuFenceHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuFenceHandle, T>::value>;
  using DataView = GpuFenceHandleDataView;
  using Data_ = internal::GpuFenceHandle_Data;

  template <typename... Args>
  static GpuFenceHandlePtr New(Args&&... args) {
    return GpuFenceHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuFenceHandlePtr From(const U& u) {
    return mojo::TypeConverter<GpuFenceHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuFenceHandle>::Convert(*this);
  }


  GpuFenceHandle();

  explicit GpuFenceHandle(
      ::mojo::PlatformHandle native_fd);

GpuFenceHandle(const GpuFenceHandle&) = delete;
GpuFenceHandle& operator=(const GpuFenceHandle&) = delete;

  ~GpuFenceHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuFenceHandlePtr>
  GpuFenceHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuFenceHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuFenceHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuFenceHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuFenceHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuFenceHandle_UnserializedMessageContext<
            UserType, GpuFenceHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuFenceHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuFenceHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuFenceHandle_UnserializedMessageContext<
            UserType, GpuFenceHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuFenceHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PlatformHandle native_fd;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuFenceHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuFenceHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuFenceHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuFenceHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GpuFenceHandlePtr GpuFenceHandle::Clone() const {
  return New(
      mojo::Clone(native_fd)
  );
}

template <typename T, GpuFenceHandle::EnableIfSame<T>*>
bool GpuFenceHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->native_fd, other_struct.native_fd))
    return false;
  return true;
}

template <typename T, GpuFenceHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.native_fd < rhs.native_fd)
    return true;
  if (rhs.native_fd < lhs.native_fd)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::GpuFenceHandle::DataView,
                                         ::gfx::mojom::GpuFenceHandlePtr> {
  static bool IsNull(const ::gfx::mojom::GpuFenceHandlePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::GpuFenceHandlePtr* output) { output->reset(); }

  static  decltype(::gfx::mojom::GpuFenceHandle::native_fd)& native_fd(
       ::gfx::mojom::GpuFenceHandlePtr& input) {
    return input->native_fd;
  }

  static bool Read(::gfx::mojom::GpuFenceHandle::DataView input, ::gfx::mojom::GpuFenceHandlePtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_GPU_FENCE_HANDLE_MOJOM_H_