// ui/gl/mojom/gl_implementation.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GL_MOJOM_GL_IMPLEMENTATION_MOJOM_SHARED_H_
#define UI_GL_MOJOM_GL_IMPLEMENTATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gl/mojom/gl_implementation.mojom-shared-internal.h"



#include "base/component_export.h"




namespace gl::mojom {
class GLImplementationPartsDataView;



}  // gl::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gl::mojom::GLImplementationPartsDataView> {
  using Data = ::gl::mojom::internal::GLImplementationParts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gl::mojom {


enum class GLImplementation : int32_t {
  
  kGLImplementationNone = 0,
  
  kGLImplementationEGLGLES2 = 1,
  
  kGLImplementationMockGL = 2,
  
  kGLImplementationStubGL = 3,
  
  kGLImplementationDisabled = 4,
  
  kGLImplementationEGLANGLE = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(GL_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GLImplementation value);
inline bool IsKnownEnumValue(GLImplementation value) {
  return internal::GLImplementation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ANGLEImplementation : int32_t {
  
  kNone = 0,
  
  kD3D9 = 1,
  
  kD3D11 = 2,
  
  kOpenGL = 3,
  
  kOpenGLES = 4,
  
  kNull = 5,
  
  kVulkan = 6,
  
  kSwiftShader = 7,
  
  kMetal = 8,
  
  kDefault = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(GL_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ANGLEImplementation value);
inline bool IsKnownEnumValue(ANGLEImplementation value) {
  return internal::ANGLEImplementation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GLImplementationPartsDataView {
 public:
  GLImplementationPartsDataView() = default;

  GLImplementationPartsDataView(
      internal::GLImplementationParts_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadGl(UserType* output) const {
    auto data_value = data_->gl;
    return mojo::internal::Deserialize<::gl::mojom::GLImplementation>(
        data_value, output);
  }
  GLImplementation gl() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gl::mojom::GLImplementation>(data_->gl));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAngle(UserType* output) const {
    auto data_value = data_->angle;
    return mojo::internal::Deserialize<::gl::mojom::ANGLEImplementation>(
        data_value, output);
  }
  ANGLEImplementation angle() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gl::mojom::ANGLEImplementation>(data_->angle));
  }
 private:
  internal::GLImplementationParts_Data* data_ = nullptr;
};


}  // gl::mojom

namespace std {

template <>
struct hash<::gl::mojom::GLImplementation>
    : public mojo::internal::EnumHashImpl<::gl::mojom::GLImplementation> {};

template <>
struct hash<::gl::mojom::ANGLEImplementation>
    : public mojo::internal::EnumHashImpl<::gl::mojom::ANGLEImplementation> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gl::mojom::GLImplementation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gl::mojom::GLImplementation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gl::mojom::GLImplementation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gl::mojom::ANGLEImplementation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gl::mojom::ANGLEImplementation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gl::mojom::ANGLEImplementation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gl::mojom::GLImplementationPartsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gl::mojom::GLImplementationPartsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gl::mojom::internal::GLImplementationParts_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::gl::mojom::GLImplementation>(
        Traits::gl(input), &fragment->gl);
    mojo::internal::Serialize<::gl::mojom::ANGLEImplementation>(
        Traits::angle(input), &fragment->angle);
  }

  static bool Deserialize(::gl::mojom::internal::GLImplementationParts_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gl::mojom::GLImplementationPartsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gl::mojom {




}  // gl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(GL_MOJOM_SHARED) TraceFormatTraits<::gl::mojom::GLImplementation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gl::mojom::GLImplementation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(GL_MOJOM_SHARED) TraceFormatTraits<::gl::mojom::ANGLEImplementation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gl::mojom::ANGLEImplementation value);
};

} // namespace perfetto

#endif  // UI_GL_MOJOM_GL_IMPLEMENTATION_MOJOM_SHARED_H_