/* RestoreBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RestoreBox.vala, do not modify */

/*
 * RestoreBox.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <libxapp/xapp-gtk-window.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_RESTORE_BOX (restore_box_get_type ())
#define RESTORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTORE_BOX, RestoreBox))
#define RESTORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTORE_BOX, RestoreBoxClass))
#define IS_RESTORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTORE_BOX))
#define IS_RESTORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTORE_BOX))
#define RESTORE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTORE_BOX, RestoreBoxClass))

typedef struct _RestoreBox RestoreBox;
typedef struct _RestoreBoxClass RestoreBoxClass;
typedef struct _RestoreBoxPrivate RestoreBoxPrivate;
enum  {
	RESTORE_BOX_0_PROPERTY,
	RESTORE_BOX_NUM_PROPERTIES
};
static GParamSpec* restore_box_properties[RESTORE_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
typedef struct _RsyncTaskPrivate RsyncTaskPrivate;

struct _RestoreBox {
	GtkBox parent_instance;
	RestoreBoxPrivate * priv;
	GtkLabel* lbl_header;
	GtkLabel* lbl_msg;
	GtkLabel* lbl_status;
	GtkLabel* lbl_remaining;
	GtkProgressBar* progressbar;
	GtkLabel* lbl_unchanged;
	GtkLabel* lbl_created;
	GtkLabel* lbl_deleted;
	GtkLabel* lbl_modified;
	GtkLabel* lbl_checksum;
	GtkLabel* lbl_size;
	GtkLabel* lbl_timestamp;
	GtkLabel* lbl_permissions;
	GtkLabel* lbl_owner;
	GtkLabel* lbl_group;
};

struct _RestoreBoxClass {
	GtkBoxClass parent_class;
};

struct _RestoreBoxPrivate {
	GtkSpinner* spinner;
	GtkWindow* parent_window;
	gboolean thread_is_running;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _RsyncTask {
	AsyncTask parent_instance;
	RsyncTaskPrivate * priv;
	gboolean delete_extra;
	gboolean delete_after;
	gboolean delete_excluded;
	gboolean relative;
	gchar* rsync_log_file;
	gchar* exclude_from_file;
	gchar* link_from_path;
	gchar* source_path;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean dry_run;
	GQueue* status_lines;
	gint64 status_line_count;
	gint64 total_size;
	gint64 count_created;
	gint64 count_deleted;
	gint64 count_modified;
	gint64 count_checksum;
	gint64 count_size;
	gint64 count_timestamp;
	gint64 count_permissions;
	gint64 count_owner;
	gint64 count_group;
	gint64 count_unchanged;
	GString* log;
};

struct _RsyncTaskClass {
	AsyncTaskClass parent_class;
};

static gint RestoreBox_private_offset;
static gpointer restore_box_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType restore_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RestoreBox, g_object_unref)
VALA_EXTERN RestoreBox* restore_box_new (GtkWindow* _parent_window);
VALA_EXTERN RestoreBox* restore_box_construct (GType object_type,
                                   GtkWindow* _parent_window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label_header (GtkBox* box,
                                               const gchar* text,
                                               gboolean large_heading);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label (GtkBox* box,
                                        const gchar* text,
                                        gboolean bold,
                                        gboolean italic,
                                        gboolean large);
static GtkLabel* restore_box_add_count_label (RestoreBox* self,
                                       GtkBox* box,
                                       const gchar* text,
                                       GtkSizeGroup** sg_label,
                                       GtkSizeGroup** sg_value,
                                       gint add_margin_bottom);
VALA_EXTERN gboolean restore_box_restore (RestoreBox* self);
VALA_EXTERN gboolean main_get_restore_current_system (Main* self);
VALA_EXTERN gchar* tee_jee_gtk_helper_format_text (const gchar* text,
                                       gboolean bold,
                                       gboolean italic,
                                       gboolean large);
static void ___lambda119_ (RestoreBox* self);
static void restore_box_restore_thread (RestoreBox* self);
static gpointer ____lambda119__gthread_func (gpointer self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN gchar* tee_jee_misc_escape_html (const gchar* html);
VALA_EXTERN gchar* async_task_get_status_line (AsyncTask* self);
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* async_task_get_stat_time_remaining (AsyncTask* self);
VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN gboolean main_restore_snapshot (Main* self,
                                GtkWindow* parent_win);
static void restore_box_finalize (GObject * obj);
static GType restore_box_get_type_once (void);

static inline gpointer
restore_box_get_instance_private (RestoreBox* self)
{
	return G_STRUCT_MEMBER_P (self, RestoreBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RestoreBox*
restore_box_construct (GType object_type,
                       GtkWindow* _parent_window)
{
	RestoreBox * self = NULL;
	GtkWindow* _tmp0_;
	Main* _tmp1_;
	GtkBox* hbox_status = NULL;
	GtkBox* _tmp4_;
	GtkSpinner* _tmp5_;
	GtkSpinner* _tmp6_;
	GtkSpinner* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkProgressBar* _tmp13_;
	GtkProgressBar* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkSizeGroup* sg_label = NULL;
	GtkSizeGroup* sg_value = NULL;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	g_return_val_if_fail (_parent_window != NULL, NULL);
	tee_jee_logging_log_debug ("RestoreBox: RestoreBox()");
	self = (RestoreBox*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 6, NULL);
	_tmp0_ = _g_object_ref0 (_parent_window);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp0_;
	g_object_set ((GtkWidget*) self, "margin", 12, NULL);
	_tmp1_ = App;
	if (_tmp1_->dry_run) {
		GtkLabel* _tmp2_;
		_tmp2_ = tee_jee_gtk_helper_add_label_header ((GtkBox*) self, _ ("Comparing Files (Dry Run)..."), TRUE);
		_g_object_unref0 (self->lbl_header);
		self->lbl_header = _tmp2_;
	} else {
		GtkLabel* _tmp3_;
		_tmp3_ = tee_jee_gtk_helper_add_label_header ((GtkBox*) self, _ ("Restoring Snapshot..."), TRUE);
		_g_object_unref0 (self->lbl_header);
		self->lbl_header = _tmp3_;
	}
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp4_);
	hbox_status = _tmp4_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox_status);
	_tmp5_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp5_;
	_tmp6_ = self->priv->spinner;
	g_object_set (_tmp6_, "active", TRUE, NULL);
	_tmp7_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) hbox_status, (GtkWidget*) _tmp7_);
	_tmp8_ = tee_jee_gtk_helper_add_label (hbox_status, _ ("Preparing..."), FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_msg);
	self->lbl_msg = _tmp8_;
	_tmp9_ = self->lbl_msg;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = self->lbl_msg;
	gtk_label_set_ellipsize (_tmp10_, PANGO_ELLIPSIZE_END);
	_tmp11_ = self->lbl_msg;
	gtk_label_set_max_width_chars (_tmp11_, 50);
	_tmp12_ = tee_jee_gtk_helper_add_label (hbox_status, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_remaining);
	self->lbl_remaining = _tmp12_;
	_tmp13_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->progressbar);
	self->progressbar = _tmp13_;
	_tmp14_ = self->progressbar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
	_tmp15_ = tee_jee_gtk_helper_add_label ((GtkBox*) self, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_status);
	self->lbl_status = _tmp15_;
	_tmp16_ = self->lbl_status;
	gtk_label_set_ellipsize (_tmp16_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp17_ = self->lbl_status;
	gtk_label_set_max_width_chars (_tmp17_, 45);
	_tmp18_ = self->lbl_status;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp18_, 12);
	_tmp19_ = tee_jee_gtk_helper_add_label ((GtkBox*) self, "", FALSE, FALSE, FALSE);
	label = _tmp19_;
	_tmp20_ = label;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp20_, TRUE);
	sg_label = NULL;
	sg_value = NULL;
	_tmp21_ = tee_jee_gtk_helper_add_label ((GtkBox*) self, _ ("Files and directory counts:"), TRUE, FALSE, FALSE);
	_g_object_unref0 (label);
	label = _tmp21_;
	_tmp22_ = label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp22_, 6);
	_tmp23_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("No Change"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_unchanged);
	self->lbl_unchanged = _tmp23_;
	_tmp24_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("Created"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_created);
	self->lbl_created = _tmp24_;
	_tmp25_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("Deleted"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_deleted);
	self->lbl_deleted = _tmp25_;
	_tmp26_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("Changed"), &sg_label, &sg_value, 12);
	_g_object_unref0 (self->lbl_modified);
	self->lbl_modified = _tmp26_;
	_tmp27_ = tee_jee_gtk_helper_add_label ((GtkBox*) self, _ ("Changed items:"), TRUE, FALSE, FALSE);
	_g_object_unref0 (label);
	label = _tmp27_;
	_tmp28_ = label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp28_, 6);
	_tmp29_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("Checksum"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_checksum);
	self->lbl_checksum = _tmp29_;
	_tmp30_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("Size"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_size);
	self->lbl_size = _tmp30_;
	_tmp31_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("Timestamp"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_timestamp);
	self->lbl_timestamp = _tmp31_;
	_tmp32_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("Permissions"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_permissions);
	self->lbl_permissions = _tmp32_;
	_tmp33_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("Owner"), &sg_label, &sg_value, 0);
	_g_object_unref0 (self->lbl_owner);
	self->lbl_owner = _tmp33_;
	_tmp34_ = restore_box_add_count_label (self, (GtkBox*) self, _ ("Group"), &sg_label, &sg_value, 24);
	_g_object_unref0 (self->lbl_group);
	self->lbl_group = _tmp34_;
	tee_jee_logging_log_debug ("RestoreBox: RestoreBox(): exit");
	_g_object_unref0 (sg_value);
	_g_object_unref0 (sg_label);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox_status);
	return self;
}

RestoreBox*
restore_box_new (GtkWindow* _parent_window)
{
	return restore_box_construct (TYPE_RESTORE_BOX, _parent_window);
}

static GtkLabel*
restore_box_add_count_label (RestoreBox* self,
                             GtkBox* box,
                             const gchar* text,
                             GtkSizeGroup** sg_label,
                             GtkSizeGroup** sg_value,
                             gint add_margin_bottom)
{
	GtkBox* hbox = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkLabel* label = NULL;
	GtkBox* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp12_;
	GtkBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp18_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	hbox = _tmp0_;
	_tmp1_ = hbox;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp1_);
	_tmp2_ = hbox;
	_tmp3_ = g_strconcat (text, ":", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = tee_jee_gtk_helper_add_label (_tmp2_, _tmp4_, FALSE, FALSE, FALSE);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	label = _tmp6_;
	_tmp7_ = label;
	gtk_label_set_xalign (_tmp7_, (gfloat) 1.0);
	_tmp8_ = label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 12);
	_tmp9_ = label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 6);
	if (add_margin_bottom > 0) {
		GtkLabel* _tmp10_;
		_tmp10_ = label;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp10_, add_margin_bottom);
	}
	if ((*sg_label) == NULL) {
		GtkSizeGroup* _tmp11_;
		_tmp11_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		_g_object_unref0 (*sg_label);
		*sg_label = _tmp11_;
	}
	_tmp12_ = label;
	gtk_size_group_add_widget (*sg_label, (GtkWidget*) _tmp12_);
	_tmp13_ = hbox;
	_tmp14_ = tee_jee_gtk_helper_add_label (_tmp13_, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (label);
	label = _tmp14_;
	_tmp15_ = label;
	gtk_label_set_xalign (_tmp15_, (gfloat) 0.0);
	if (add_margin_bottom > 0) {
		GtkLabel* _tmp16_;
		_tmp16_ = label;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp16_, add_margin_bottom);
	}
	if ((*sg_value) == NULL) {
		GtkSizeGroup* _tmp17_;
		_tmp17_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		_g_object_unref0 (*sg_value);
		*sg_value = _tmp17_;
	}
	_tmp18_ = label;
	gtk_size_group_add_widget (*sg_value, (GtkWidget*) _tmp18_);
	result = label;
	_g_object_unref0 (hbox);
	return result;
}

static void
___lambda119_ (RestoreBox* self)
{
	restore_box_restore_thread (self);
}

static gpointer
____lambda119__gthread_func (gpointer self)
{
	gpointer result;
	___lambda119_ ((RestoreBox*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

gboolean
restore_box_restore (RestoreBox* self)
{
	gboolean _tmp0_ = FALSE;
	Main* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	Main* _tmp6_;
	gint wait_interval_millis = 0;
	gint status_line_counter = 0;
	gint status_line_counter_default = 0;
	gchar* status_line = NULL;
	gchar* _tmp18_;
	gchar* last_status_line = NULL;
	gchar* _tmp19_;
	gint remaining_counter = 0;
	GtkWindow* _tmp102_;
	gboolean _tmp103_ = FALSE;
	Main* _tmp104_;
	gboolean _tmp105_;
	gboolean _tmp106_;
	Main* _tmp109_;
	RsyncTask* _tmp110_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("RestoreBox: restore()");
	_tmp1_ = App;
	_tmp2_ = main_get_restore_current_system (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Main* _tmp4_;
		_tmp4_ = App;
		_tmp0_ = !_tmp4_->dry_run;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWindow* _tmp5_;
		_tmp5_ = self->priv->parent_window;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	}
	_tmp6_ = App;
	if (_tmp6_->dry_run) {
		GtkLabel* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->lbl_header;
		_tmp8_ = tee_jee_gtk_helper_format_text (_ ("Comparing Files (Dry Run)..."), TRUE, FALSE, TRUE);
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
	} else {
		GtkLabel* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->lbl_header;
		_tmp11_ = tee_jee_gtk_helper_format_text (_ ("Restoring Snapshot..."), TRUE, FALSE, TRUE);
		_tmp12_ = _tmp11_;
		gtk_label_set_label (_tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	{
		GThread* _tmp13_;
		GThread* _tmp14_;
		self->priv->thread_is_running = TRUE;
		_tmp13_ = g_thread_try_new ("restore", ____lambda119__gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp14_ = _tmp13_;
		_g_thread_unref0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	wait_interval_millis = 100;
	status_line_counter = 0;
	status_line_counter_default = 1000 / wait_interval_millis;
	_tmp18_ = g_strdup ("");
	status_line = _tmp18_;
	_tmp19_ = g_strdup ("");
	last_status_line = _tmp19_;
	remaining_counter = 10;
	while (TRUE) {
		Main* _tmp20_;
		RsyncTask* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gdouble fraction = 0.0;
		Main* _tmp34_;
		RsyncTask* _tmp35_;
		gint _tmp36_;
		GtkLabel* _tmp49_;
		Main* _tmp50_;
		const gchar* _tmp51_;
		GtkLabel* _tmp52_;
		Main* _tmp53_;
		RsyncTask* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		GtkLabel* _tmp57_;
		Main* _tmp58_;
		RsyncTask* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		GtkLabel* _tmp62_;
		Main* _tmp63_;
		RsyncTask* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		GtkLabel* _tmp67_;
		Main* _tmp68_;
		RsyncTask* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		GtkLabel* _tmp72_;
		Main* _tmp73_;
		RsyncTask* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		GtkLabel* _tmp77_;
		Main* _tmp78_;
		RsyncTask* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		GtkLabel* _tmp82_;
		Main* _tmp83_;
		RsyncTask* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		GtkLabel* _tmp87_;
		Main* _tmp88_;
		RsyncTask* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		GtkLabel* _tmp92_;
		Main* _tmp93_;
		RsyncTask* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		GtkLabel* _tmp97_;
		Main* _tmp98_;
		RsyncTask* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		if (!self->priv->thread_is_running) {
			break;
		}
		_tmp20_ = App;
		_tmp21_ = _tmp20_->task;
		_tmp22_ = async_task_get_status_line ((AsyncTask*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp25_ = tee_jee_misc_escape_html (_tmp24_);
		_g_free0 (status_line);
		status_line = _tmp25_;
		_g_free0 (_tmp24_);
		_tmp26_ = status_line;
		_tmp27_ = last_status_line;
		if (g_strcmp0 (_tmp26_, _tmp27_) != 0) {
			GtkLabel* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp28_ = self->lbl_status;
			_tmp29_ = status_line;
			gtk_label_set_label (_tmp28_, _tmp29_);
			_tmp30_ = status_line;
			_tmp31_ = g_strdup (_tmp30_);
			_g_free0 (last_status_line);
			last_status_line = _tmp31_;
			status_line_counter = status_line_counter_default;
		} else {
			gint _tmp32_;
			_tmp32_ = status_line_counter;
			status_line_counter = _tmp32_ - 1;
			if (status_line_counter < 0) {
				GtkLabel* _tmp33_;
				status_line_counter = status_line_counter_default;
				_tmp33_ = self->lbl_status;
				gtk_label_set_label (_tmp33_, "");
			}
		}
		_tmp34_ = App;
		_tmp35_ = _tmp34_->task;
		fraction = ((AsyncTask*) _tmp35_)->progress;
		_tmp36_ = remaining_counter;
		remaining_counter = _tmp36_ - 1;
		if (remaining_counter == 0) {
			GtkLabel* _tmp37_;
			Main* _tmp38_;
			RsyncTask* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp37_ = self->lbl_remaining;
			_tmp38_ = App;
			_tmp39_ = _tmp38_->task;
			_tmp40_ = async_task_get_stat_time_remaining ((AsyncTask*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, " ", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strconcat (_tmp44_, _ ("remaining"), NULL);
			_tmp46_ = _tmp45_;
			gtk_label_set_label (_tmp37_, _tmp46_);
			_g_free0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			remaining_counter = 10;
		}
		if (fraction < 0.99) {
			GtkProgressBar* _tmp47_;
			GtkWindow* _tmp48_;
			_tmp47_ = self->progressbar;
			gtk_progress_bar_set_fraction (_tmp47_, fraction);
			_tmp48_ = self->priv->parent_window;
			xapp_set_window_progress (_tmp48_, (gint) (fraction * 100.0));
		}
		_tmp49_ = self->lbl_msg;
		_tmp50_ = App;
		_tmp51_ = _tmp50_->progress_text;
		gtk_label_set_label (_tmp49_, _tmp51_);
		_tmp52_ = self->lbl_unchanged;
		_tmp53_ = App;
		_tmp54_ = _tmp53_->task;
		_tmp55_ = g_strdup_printf ("%'d", _tmp54_->count_unchanged);
		_tmp56_ = _tmp55_;
		gtk_label_set_label (_tmp52_, _tmp56_);
		_g_free0 (_tmp56_);
		_tmp57_ = self->lbl_created;
		_tmp58_ = App;
		_tmp59_ = _tmp58_->task;
		_tmp60_ = g_strdup_printf ("%'d", _tmp59_->count_created);
		_tmp61_ = _tmp60_;
		gtk_label_set_label (_tmp57_, _tmp61_);
		_g_free0 (_tmp61_);
		_tmp62_ = self->lbl_deleted;
		_tmp63_ = App;
		_tmp64_ = _tmp63_->task;
		_tmp65_ = g_strdup_printf ("%'d", _tmp64_->count_deleted);
		_tmp66_ = _tmp65_;
		gtk_label_set_label (_tmp62_, _tmp66_);
		_g_free0 (_tmp66_);
		_tmp67_ = self->lbl_modified;
		_tmp68_ = App;
		_tmp69_ = _tmp68_->task;
		_tmp70_ = g_strdup_printf ("%'d", _tmp69_->count_modified);
		_tmp71_ = _tmp70_;
		gtk_label_set_label (_tmp67_, _tmp71_);
		_g_free0 (_tmp71_);
		_tmp72_ = self->lbl_checksum;
		_tmp73_ = App;
		_tmp74_ = _tmp73_->task;
		_tmp75_ = g_strdup_printf ("%'d", _tmp74_->count_checksum);
		_tmp76_ = _tmp75_;
		gtk_label_set_label (_tmp72_, _tmp76_);
		_g_free0 (_tmp76_);
		_tmp77_ = self->lbl_size;
		_tmp78_ = App;
		_tmp79_ = _tmp78_->task;
		_tmp80_ = g_strdup_printf ("%'d", _tmp79_->count_size);
		_tmp81_ = _tmp80_;
		gtk_label_set_label (_tmp77_, _tmp81_);
		_g_free0 (_tmp81_);
		_tmp82_ = self->lbl_timestamp;
		_tmp83_ = App;
		_tmp84_ = _tmp83_->task;
		_tmp85_ = g_strdup_printf ("%'d", _tmp84_->count_timestamp);
		_tmp86_ = _tmp85_;
		gtk_label_set_label (_tmp82_, _tmp86_);
		_g_free0 (_tmp86_);
		_tmp87_ = self->lbl_permissions;
		_tmp88_ = App;
		_tmp89_ = _tmp88_->task;
		_tmp90_ = g_strdup_printf ("%'d", _tmp89_->count_permissions);
		_tmp91_ = _tmp90_;
		gtk_label_set_label (_tmp87_, _tmp91_);
		_g_free0 (_tmp91_);
		_tmp92_ = self->lbl_owner;
		_tmp93_ = App;
		_tmp94_ = _tmp93_->task;
		_tmp95_ = g_strdup_printf ("%'d", _tmp94_->count_owner);
		_tmp96_ = _tmp95_;
		gtk_label_set_label (_tmp92_, _tmp96_);
		_g_free0 (_tmp96_);
		_tmp97_ = self->lbl_group;
		_tmp98_ = App;
		_tmp99_ = _tmp98_->task;
		_tmp100_ = g_strdup_printf ("%'d", _tmp99_->count_group);
		_tmp101_ = _tmp100_;
		gtk_label_set_label (_tmp97_, _tmp101_);
		_g_free0 (_tmp101_);
		tee_jee_gtk_helper_gtk_do_events ();
		tee_jee_system_sleep (100);
	}
	_tmp102_ = self->priv->parent_window;
	xapp_set_window_progress (_tmp102_, 0);
	_tmp104_ = App;
	_tmp105_ = main_get_restore_current_system (_tmp104_);
	_tmp106_ = _tmp105_;
	if (_tmp106_) {
		Main* _tmp107_;
		_tmp107_ = App;
		_tmp103_ = !_tmp107_->dry_run;
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		GtkWindow* _tmp108_;
		_tmp108_ = self->priv->parent_window;
		gtk_widget_show ((GtkWidget*) _tmp108_);
	}
	tee_jee_logging_log_debug ("RestoreBox: restore(): exit");
	_tmp109_ = App;
	_tmp110_ = _tmp109_->task;
	result = ((AsyncTask*) _tmp110_)->exit_code == 0;
	_g_free0 (last_status_line);
	_g_free0 (status_line);
	return result;
}

static void
restore_box_restore_thread (RestoreBox* self)
{
	Main* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("RestoreBox: restore_thread()");
	_tmp0_ = App;
	_tmp1_ = self->priv->parent_window;
	main_restore_snapshot (_tmp0_, _tmp1_);
	self->priv->thread_is_running = FALSE;
	tee_jee_logging_log_debug ("RestoreBox: restore_thread(): exit");
}

static void
restore_box_class_init (RestoreBoxClass * klass,
                        gpointer klass_data)
{
	restore_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RestoreBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = restore_box_finalize;
}

static void
restore_box_instance_init (RestoreBox * self,
                           gpointer klass)
{
	self->priv = restore_box_get_instance_private (self);
	self->priv->thread_is_running = FALSE;
}

static void
restore_box_finalize (GObject * obj)
{
	RestoreBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RESTORE_BOX, RestoreBox);
	_g_object_unref0 (self->lbl_header);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->lbl_msg);
	_g_object_unref0 (self->lbl_status);
	_g_object_unref0 (self->lbl_remaining);
	_g_object_unref0 (self->progressbar);
	_g_object_unref0 (self->lbl_unchanged);
	_g_object_unref0 (self->lbl_created);
	_g_object_unref0 (self->lbl_deleted);
	_g_object_unref0 (self->lbl_modified);
	_g_object_unref0 (self->lbl_checksum);
	_g_object_unref0 (self->lbl_size);
	_g_object_unref0 (self->lbl_timestamp);
	_g_object_unref0 (self->lbl_permissions);
	_g_object_unref0 (self->lbl_owner);
	_g_object_unref0 (self->lbl_group);
	_g_object_unref0 (self->priv->parent_window);
	G_OBJECT_CLASS (restore_box_parent_class)->finalize (obj);
}

static GType
restore_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RestoreBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) restore_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RestoreBox), 0, (GInstanceInitFunc) restore_box_instance_init, NULL };
	GType restore_box_type_id;
	restore_box_type_id = g_type_register_static (gtk_box_get_type (), "RestoreBox", &g_define_type_info, 0);
	RestoreBox_private_offset = g_type_add_instance_private (restore_box_type_id, sizeof (RestoreBoxPrivate));
	return restore_box_type_id;
}

GType
restore_box_get_type (void)
{
	static volatile gsize restore_box_type_id__once = 0;
	if (g_once_init_enter (&restore_box_type_id__once)) {
		GType restore_box_type_id;
		restore_box_type_id = restore_box_get_type_once ();
		g_once_init_leave (&restore_box_type_id__once, restore_box_type_id);
	}
	return restore_box_type_id__once;
}

