/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.util;

import io.sf.carte.util.SimpleWriter;

public class BufferSimpleWriter
implements SimpleWriter {
    private final StringBuilder buffer;

    public BufferSimpleWriter() {
        this.buffer = new StringBuilder(128);
    }

    public BufferSimpleWriter(int n) {
        this.buffer = new StringBuilder(n);
    }

    public BufferSimpleWriter(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public int length() {
        return this.buffer.length();
    }

    @Override
    public void newLine() {
        this.buffer.append('\n');
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void unwrite() {
        int n = this.buffer.length();
        if (n != 0) {
            this.buffer.setLength(n - 1);
        }
    }

    public void unwrite(int n) {
        int n2 = this.buffer.length() - n;
        if (n2 < 0) {
            n2 = 0;
        }
        this.buffer.setLength(n2);
    }

    @Override
    public void write(CharSequence charSequence) {
        this.buffer.append(charSequence);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        this.buffer.append(cArray, n, n2);
    }

    @Override
    public void write(char c) {
        this.buffer.append(c);
    }

    @Override
    public void write(int n) {
        this.buffer.append(n);
    }
}

