/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.undo.UndoManager;
import net.iharder.dnd.FileDrop;
import org.fibs.geotag.GlobalUndoManager;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.dcraw.Dcraw;
import org.fibs.geotag.exif.Exiftool;
import org.fibs.geotag.external.ClipboardUpdate;
import org.fibs.geotag.external.ClipboardWorker;
import org.fibs.geotag.external.ExternalUpdate;
import org.fibs.geotag.external.ExternalUpdateConsumer;
import org.fibs.geotag.googleearth.KmlRequestHandler;
import org.fibs.geotag.gpsbabel.GPSBabel;
import org.fibs.geotag.gui.AboutDialog;
import org.fibs.geotag.gui.ImagesTablePopupMenu;
import org.fibs.geotag.gui.PreviewComponent;
import org.fibs.geotag.gui.WhatNext;
import org.fibs.geotag.gui.flattr.FlattrMenuItem;
import org.fibs.geotag.gui.menus.FileMenu;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.BackgroundTask;
import org.fibs.geotag.tasks.BackgroundTaskListener;
import org.fibs.geotag.tasks.ClipboardUpdateTask;
import org.fibs.geotag.tasks.ExifReaderTask;
import org.fibs.geotag.tasks.ExternalUpdateTask;
import org.fibs.geotag.tasks.TaskExecutor;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.BrowserLauncher;
import org.fibs.geotag.util.ImageUtil;
import org.fibs.geotag.webserver.GeonamesHandler;
import org.fibs.geotag.webserver.ImageInfoHandler;
import org.fibs.geotag.webserver.MapHandler;
import org.fibs.geotag.webserver.ResourceHandler;
import org.fibs.geotag.webserver.SettingsHandler;
import org.fibs.geotag.webserver.ThumbnailHandler;
import org.fibs.geotag.webserver.TracksHandler;
import org.fibs.geotag.webserver.UpdateHandler;
import org.fibs.geotag.webserver.WebServer;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MainWindow
extends JFrame
implements BackgroundTaskListener,
ExternalUpdateConsumer,
MenuConstants {
    private static final I18n i18n = I18nFactory.getI18n(MainWindow.class);
    private static final int PREVIEW_ASPECT_RATIO_X = 4;
    private static final int PREVIEW_ASPECT_RATIO_Y = 3;
    private static final int WEB_SERVER_PORT = 4321;
    private static final String ICON_DIRECTORY = "images";
    private static final String[] ICON_NAMES = new String[]{"geotag-32.png", "geotag-64.png", "geotag-128.png"};
    private ImagesTableModel tableModel;
    private ImagesTable table;
    private JMenuBar menuBar = new JMenuBar();
    private JScrollPane tableScrollPane;
    private PreviewComponent previewComponent;
    private JProgressBar progressBar;
    private BackgroundTask<?> backgroundTask = null;
    private Vector<ExternalUpdate> pendingExternalUpdates = new Vector();
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private JMenuItem cancelItem;
    private FileMenu fileMenu;

    public MainWindow() {
        super("Geotag");
        Exiftool.checkExiftoolAvailable();
        GPSBabel.checkGPSBabelAvailable();
        Dcraw.checkDcrawAvailable();
        ArrayList<Image> iconImageList = new ArrayList<Image>();
        String[] stringArray = ICON_NAMES;
        int n = ICON_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String iconName = stringArray[n2];
            System.out.println("images/" + iconName);
            Image image = ImageUtil.loadImage("images/" + iconName);
            iconImageList.add(image);
            ++n2;
        }
        this.setIconImages(iconImageList);
        this.setLayout(new BorderLayout());
        this.setupTable();
        this.setupMenuBar();
        this.setJMenuBar(this.menuBar);
        this.setupSizeAndPosition();
        this.tableScrollPane = new JScrollPane(this.table);
        this.setupPreviewComponent();
        final JSplitPane splitPane = new JSplitPane(0, false, this.tableScrollPane, this.previewComponent);
        this.add((Component)splitPane, "Center");
        this.add((Component)this.getProgressBar(), "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                int previewHeight = (int)((double)MainWindow.this.getWidth() / 1.3333333333333333);
                previewHeight = Settings.get(Settings.SETTING.PREVIEW_HEIGHT, previewHeight);
                splitPane.setDividerLocation(MainWindow.this.getHeight() - previewHeight);
            }

            @Override
            public void windowClosing(WindowEvent we) {
                if (JOptionPane.showConfirmDialog(MainWindow.this, i18n.tr("Do you really want to exit Geotag?"), i18n.tr("Exit Program"), 0) == 0) {
                    Settings.put(Settings.SETTING.MAIN_WINDOW_X, MainWindow.this.getLocation().x);
                    Settings.put(Settings.SETTING.MAIN_WINDOW_Y, MainWindow.this.getLocation().y);
                    Settings.put(Settings.SETTING.MAIN_WINDOW_HEIGHT, MainWindow.this.getHeight());
                    Settings.put(Settings.SETTING.MAIN_WINDOW_WIDHTH, MainWindow.this.getWidth());
                    Settings.put(Settings.SETTING.PREVIEW_HEIGHT, MainWindow.this.getHeight() - splitPane.getDividerLocation());
                    MainWindow.this.getTable().saveColumnSettings();
                    Settings.flush();
                    System.exit(0);
                }
            }
        });
        GlobalUndoManager.getManager().setLimit(-1);
        new FileDrop(this, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                ExifReaderTask task = new ExifReaderTask(ADD_FILES, MainWindow.this.getTableModel(), files);
                TaskExecutor.execute(task);
            }
        });
        ClipboardWorker clipboardMonitor = new ClipboardWorker(this){

            @Override
            protected void process(List<ClipboardUpdate> clipboardUpdates) {
                MainWindow.this.processClipboardUpdates(clipboardUpdates);
            }
        };
        TaskExecutor.execute(clipboardMonitor);
        BackgroundTask.addBackgroundTaskListener(this);
        this.setupWebServer();
    }

    private void setupWebServer() {
        try {
            WebServer webServer = new WebServer(4321, this.tableModel);
            webServer.createContext("/", new ResourceHandler());
            webServer.createContext("/images", new ThumbnailHandler());
            webServer.createContext("/update", new UpdateHandler(this));
            webServer.createContext("/kml", new KmlRequestHandler(this));
            webServer.createContext("/tracks", new TracksHandler());
            webServer.createContext("/settings", new SettingsHandler());
            webServer.createContext("/imageinfo", new ImageInfoHandler());
            webServer.createContext("/map", new MapHandler());
            webServer.createContext("/geonames", new GeonamesHandler());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupPreviewComponent() {
        this.previewComponent = new PreviewComponent(i18n.tr("Image viewer"));
        this.previewComponent.addMouseListener(new MouseAdapter(){

            private void popupMenu(MouseEvent event) {
                ImageInfo imageInfo = MainWindow.this.getPreviewComponent().getImageInfo();
                int tableRow = MainWindow.this.getTableModel().getRow(imageInfo);
                if (imageInfo != null) {
                    ImagesTablePopupMenu popupMenu = new ImagesTablePopupMenu(MainWindow.this, MainWindow.this.getTable(), tableRow, MainWindow.this.getBackgroundTask() != null);
                    popupMenu.show((Component)event.getSource(), event.getX(), event.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent event) {
                super.mousePressed(event);
                if (event.isPopupTrigger()) {
                    this.popupMenu(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                super.mouseReleased(event);
                if (event.isPopupTrigger()) {
                    this.popupMenu(event);
                }
            }
        });
    }

    private void setupSizeAndPosition() {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (int)(screenSize.getWidth() / 2.0);
            width = Settings.get(Settings.SETTING.MAIN_WINDOW_WIDHTH, width);
            double factor = 0.95;
            int height = (int)(screenSize.getHeight() * 0.95);
            height = Settings.get(Settings.SETTING.MAIN_WINDOW_HEIGHT, height);
            this.setSize(width, height);
            int x = Settings.get(Settings.SETTING.MAIN_WINDOW_X, 0);
            int y = Settings.get(Settings.SETTING.MAIN_WINDOW_Y, 0);
            this.setLocation(x, y);
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
    }

    private void setupTable() {
        this.tableModel = new ImagesTableModel();
        this.table = new ImagesTable(this.tableModel){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ListSelectionModel newSelectionModel = (ListSelectionModel)event.getSource();
                if (newSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                int lead = newSelectionModel.getLeadSelectionIndex();
                if (newSelectionModel.isSelectedIndex(lead)) {
                    ImageInfo imageInfo = MainWindow.this.getTableModel().getImageInfo(lead);
                    MainWindow.this.getPreviewComponent().setImageInfo(imageInfo);
                }
                super.valueChanged(event);
            }
        };
        this.table.addMouseListener(new MouseAdapter(){

            private void popupMenu(MouseEvent event) {
                int mouseOnRow = MainWindow.this.getTable().rowAtPoint(event.getPoint());
                ImagesTablePopupMenu popupMenu = new ImagesTablePopupMenu(MainWindow.this, MainWindow.this.getTable(), mouseOnRow, MainWindow.this.getBackgroundTask() != null);
                popupMenu.show((Component)event.getSource(), event.getX(), event.getY());
            }

            @Override
            public void mousePressed(MouseEvent event) {
                super.mousePressed(event);
                if (event.isPopupTrigger()) {
                    this.popupMenu(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                super.mouseReleased(event);
                if (event.isPopupTrigger()) {
                    this.popupMenu(event);
                }
            }
        });
    }

    private void setupMenuBar() {
        this.fileMenu = new FileMenu(this.table, this.getProgressBar());
        this.menuBar.add(this.fileMenu);
        JMenu editMenu = this.setupEditMenu();
        this.menuBar.add(editMenu);
        JMenu helpMenu = this.setupHelpMenu();
        this.menuBar.add(helpMenu);
    }

    private JMenu setupHelpMenu() {
        JMenu helpMenu = new JMenu(i18n.tr("Help"));
        JMenuItem whatNextItem = new JMenuItem(i18n.tr("What next?"));
        whatNextItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WhatNext.helpWhatNext(MainWindow.this, MainWindow.this.getTableModel());
            }
        });
        helpMenu.add(whatNextItem);
        final String about = String.valueOf(i18n.tr("About")) + ' ' + "Geotag";
        JMenuItem aboutItem = new JMenuItem(String.valueOf(about) + "...");
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog((Window)MainWindow.this, about).setVisible(true);
            }
        });
        helpMenu.add(aboutItem);
        JMenuItem websiteItem = new JMenuItem(String.format(String.valueOf(i18n.tr("%s web site")) + "...", "Geotag"));
        websiteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserLauncher.openURL(Settings.get(Settings.SETTING.BROWSER, null), "http://geotag.sourceforge.net");
            }
        });
        helpMenu.add(websiteItem);
        FlattrMenuItem flattrItem = new FlattrMenuItem();
        helpMenu.add((Component)flattrItem);
        return helpMenu;
    }

    private JMenu setupEditMenu() {
        JMenu editMenu = new JMenu(i18n.tr("Edit"));
        this.undoItem = new JMenuItem();
        this.undoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String action = GlobalUndoManager.getManager().getUndoPresentationName();
                GlobalUndoManager.getManager().undo();
                MainWindow.this.updateUndoMenuItems();
                MainWindow.this.getTableModel().sortRows();
                MainWindow.this.getProgressBar().setString(String.valueOf(i18n.tr("Done")) + ": " + action);
            }
        });
        editMenu.add(this.undoItem);
        this.redoItem = new JMenuItem();
        this.redoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String action = GlobalUndoManager.getManager().getRedoPresentationName();
                GlobalUndoManager.getManager().redo();
                MainWindow.this.updateUndoMenuItems();
                MainWindow.this.getTableModel().sortRows();
                MainWindow.this.getProgressBar().setString(String.valueOf(i18n.tr("Done")) + ": " + action);
            }
        });
        editMenu.add(this.redoItem);
        this.cancelItem = new JMenuItem(i18n.tr("Cancel"));
        this.cancelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainWindow.this.getBackgroundTask() != null) {
                    MainWindow.this.getBackgroundTask().interruptRequest();
                    MainWindow.this.getCancelItem().setVisible(false);
                }
            }
        });
        this.cancelItem.setVisible(false);
        editMenu.add(this.cancelItem);
        this.updateUndoMenuItems();
        JMenu selectMenu = new JMenu(i18n.tr("Select"));
        JMenuItem selectAllItem = new JMenuItem(i18n.tr("All images"));
        selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.getTable().selectAll();
            }
        });
        selectMenu.add(selectAllItem);
        JMenuItem selectWithLocationItem = new JMenuItem(i18n.tr("Images with locations"));
        selectWithLocationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.getTable().selectAllWithLocation();
            }
        });
        selectMenu.add(selectWithLocationItem);
        JMenuItem selectWithNewLocationItem = new JMenuItem(i18n.tr("Images with new locations"));
        selectWithNewLocationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.getTable().selectAllWithNewLocation();
            }
        });
        selectMenu.add(selectWithNewLocationItem);
        JMenuItem selectNoneItem = new JMenuItem(i18n.tr("No images"));
        selectNoneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.getTable().selectNone();
            }
        });
        selectMenu.add(selectNoneItem);
        editMenu.add(selectMenu);
        return editMenu;
    }

    @Override
    public void processExternalUpdates(List<ExternalUpdate> externalUpdates) {
        for (ExternalUpdate externalUpdate : externalUpdates) {
            this.pendingExternalUpdates.add(externalUpdate);
            if (this.backgroundTask != null) continue;
            this.processExternalUpdates();
        }
    }

    public void processClipboardUpdates(List<ClipboardUpdate> clipboardUpdates) {
        int[] selectedRows;
        if (this.backgroundTask == null && (selectedRows = this.getTable().getSelectedRows()).length > 0) {
            ArrayList<ImageInfo> selectedImages = new ArrayList<ImageInfo>();
            int row = 0;
            while (row < selectedRows.length) {
                selectedImages.add(this.tableModel.getImageInfo(selectedRows[row]));
                ++row;
            }
            ClipboardUpdateTask task = new ClipboardUpdateTask(i18n.tr("Coordinates from clipboard"), clipboardUpdates, selectedImages){

                @Override
                protected void process(List<ImageInfo> imageInfo) {
                    for (ImageInfo image : imageInfo) {
                        int row = MainWindow.this.getTableModel().getRow(image);
                        if (row < 0) continue;
                        MainWindow.this.getTableModel().fireTableRowsUpdated(row, row);
                    }
                }
            };
            TaskExecutor.execute(task);
        }
    }

    void processExternalUpdates() {
        if (this.pendingExternalUpdates.size() > 0) {
            ExternalUpdate externalUpdate = this.pendingExternalUpdates.firstElement();
            ExternalUpdateTask task = new ExternalUpdateTask(i18n.tr("External coordinates"), externalUpdate){

                @Override
                protected void process(List<ImageInfo> imageInfo) {
                    for (ImageInfo image : imageInfo) {
                        int row = MainWindow.this.getTableModel().getRow(image);
                        if (row < 0) continue;
                        MainWindow.this.getTableModel().fireTableRowsUpdated(row, row);
                    }
                }
            };
            this.pendingExternalUpdates.remove(0);
            TaskExecutor.execute(task);
        }
    }

    void updateUndoMenuItems() {
        UndoManager undoManager = GlobalUndoManager.getManager();
        this.undoItem.setText(undoManager.getUndoPresentationName());
        this.undoItem.setEnabled(undoManager.canUndo());
        this.redoItem.setText(undoManager.getRedoPresentationName());
        this.redoItem.setEnabled(undoManager.canRedo());
    }

    private void validatePreview() {
        ImageInfo previewImage = this.previewComponent.getImageInfo();
        if (previewImage != null && this.tableModel.getRow(previewImage) < 0) {
            this.previewComponent.setImage(null);
        }
    }

    @Override
    public void backgroundTaskStarted(BackgroundTask<?> task) {
        this.backgroundTask = task;
        int minProgress = task.getMinProgress();
        int maxProgress = task.getMaxProgress();
        this.getProgressBar().setMinimum(minProgress);
        this.getProgressBar().setMaximum(maxProgress);
        this.getProgressBar().setValue(minProgress);
        this.getProgressBar().setIndeterminate(minProgress == maxProgress);
        this.getProgressBar().setString("");
        this.fileMenu.updateMenuAvailability(false);
        this.undoItem.setEnabled(false);
        this.redoItem.setEnabled(false);
        String name = task.getName();
        if (task instanceof UndoableBackgroundTask) {
            name = ((UndoableBackgroundTask)task).getPresentationName();
        }
        this.cancelItem.setText(String.valueOf(i18n.tr("Cancel")) + ' ' + name);
        this.cancelItem.setVisible(true);
        this.tableModel.setEditingForbidden(true);
    }

    @Override
    public void backgroundTaskProgress(BackgroundTask<?> task, String progressMessage) {
        int minProgress = task.getMinProgress();
        int maxProgress = task.getMaxProgress();
        this.getProgressBar().setString(progressMessage);
        this.getProgressBar().setMinimum(minProgress);
        this.getProgressBar().setMaximum(maxProgress);
        this.getProgressBar().setValue(task.getCurrentProgress());
        this.getProgressBar().setIndeterminate(minProgress == maxProgress);
    }

    @Override
    public void backgroundTaskFinished(BackgroundTask<?> task) {
        this.getProgressBar().setValue(task.getMinProgress());
        String result = "";
        try {
            result = (String)task.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.getProgressBar().setString(result);
        this.getProgressBar().setIndeterminate(false);
        this.backgroundTask = null;
        this.fileMenu.updateMenuAvailability(true);
        this.updateUndoMenuItems();
        this.validatePreview();
        this.cancelItem.setVisible(false);
        this.tableModel.setEditingForbidden(false);
        this.processExternalUpdates();
    }

    PreviewComponent getPreviewComponent() {
        return this.previewComponent;
    }

    public ImagesTableModel getTableModel() {
        return this.tableModel;
    }

    ImagesTable getTable() {
        return this.table;
    }

    JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setStringPainted(true);
            this.progressBar.setBorderPainted(false);
            this.progressBar.setString("");
        }
        return this.progressBar;
    }

    BackgroundTask<?> getBackgroundTask() {
        return this.backgroundTask;
    }

    Vector<ExternalUpdate> getPendingExternalUpdates() {
        return this.pendingExternalUpdates;
    }

    JMenuItem getCancelItem() {
        return this.cancelItem;
    }

    public static JFrame getMainWindow(Component component) {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, component);
    }
}

