/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;
import org.netbeans.swing.laf.flatlaf.HiDPIUtils;

final class DPISafeBorder
implements Border {
    private final Insets insets;
    private final Color color;

    public static Border matte(int top, int left, int bottom, int right, Color color) {
        return new DPISafeBorder(new Insets(top, left, bottom, right), color);
    }

    private DPISafeBorder(Insets insets, Color color) {
        if (insets == null) {
            throw new NullPointerException();
        }
        if (color == null) {
            throw new NullPointerException();
        }
        this.insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.color = color;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        boolean roundXdown = this.insets.left == 0;
        boolean roundYdown = this.insets.top == 0;
        HiDPIUtils.paintAtScale1x(g, x, y, width, height, roundXdown, roundYdown, this::paintBorderAtScale1x);
    }

    private void paintBorderAtScale1x(Graphics2D g, int deviceWidth, int deviceHeight, double scale) {
        Color oldColor = g.getColor();
        int deviceLeft = HiDPIUtils.deviceBorderWidth(scale, this.insets.left);
        int deviceRight = HiDPIUtils.deviceBorderWidth(scale, this.insets.right);
        int deviceTop = HiDPIUtils.deviceBorderWidth(scale, this.insets.top);
        int deviceBottom = HiDPIUtils.deviceBorderWidth(scale, this.insets.bottom);
        g.setColor(this.color);
        g.fillRect(0, 0, deviceWidth - deviceRight, deviceTop);
        g.fillRect(0, deviceTop, deviceLeft, deviceHeight - deviceTop);
        g.fillRect(deviceLeft, deviceHeight - deviceBottom, deviceWidth - deviceLeft, deviceBottom);
        g.fillRect(deviceWidth - deviceRight, 0, deviceRight, deviceHeight - deviceBottom);
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

