/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This class computes the transform that aligns the fixed and moving
images given a set of pair landmarks. The class is templated over the Transform type as well as fixed image and moving image types. The transform
computed gives the best fit transform that maps the fixed and moving
images in a least squares sense. The indices are taken to correspond,
so point 1 in the first set will get mapped close to point 1 in the
second set, etc.

Currently, the following transforms are supported by the class:
VersorRigid3DTransform

Similarity3DTransform

Rigid2DTransform

AffineTransform

BSplineTransform


An equal number of fixed and moving landmarks need to be specified
using SetFixedLandmarks() and SetMovingLandmarks() . Any number of landmarks may be specified. In the case of using
Affine or BSpline transforms, each landmark pair can contribute in the
final transform based on its defined weight. Number of weights should
be equal to the number of landmarks and can be specified using SetLandmarkWeight() . By defaults are weights are set to one. Call InitializeTransform()
to initialize the transform.

The class is based in part on Hybrid/vtkLandmarkTransform originally
implemented in python by David G. Gobbi.

The solution is based on Berthold K. P. Horn (1987), "Closed-form
solution of absolute orientation using unit quaternions," http://people.csail.mit.edu/bkph/papers/Absolute_Orientation.pdf

The Affine Transform initializer is based on an algorithm by H Spaeth, and is described in
the Insight Journal Article "Affine Transformation for Landmark Based
Registration Initializer in ITK" by Kim E.Y., Johnson H., Williams N.
available at https://www.midasjournal.org/browse/publication/825

Wiki Examples:

All Examples

Rigidly register one image to another using manually specified
landmarks
See:
 itk::simple::LandmarkBasedTransformInitializerFilter for the procedural interface

 itk::LandmarkBasedTransformInitializer for the Doxygen on the original ITK class.



C++ includes: sitkLandmarkBasedTransformInitializerFilter.h
*/
public class LandmarkBasedTransformInitializerFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LandmarkBasedTransformInitializerFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LandmarkBasedTransformInitializerFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LandmarkBasedTransformInitializerFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LandmarkBasedTransformInitializerFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::LandmarkBasedTransformInitializerFilter::~LandmarkBasedTransformInitializerFilter() override

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LandmarkBasedTransformInitializerFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LandmarkBasedTransformInitializerFilter::LandmarkBasedTransformInitializerFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LandmarkBasedTransformInitializerFilter() {
    this(SimpleITKJNI.new_LandmarkBasedTransformInitializerFilter(), true);
  }

  /**
Self&amp; itk::simple::LandmarkBasedTransformInitializerFilter::SetFixedLandmarks(const std::vector&lt; double &gt; &amp;FixedLandmarks)

Set the Fixed landmark point containers

*/
public  void setFixedLandmarks(VectorDouble FixedLandmarks) {
    SimpleITKJNI.LandmarkBasedTransformInitializerFilter_setFixedLandmarks(swigCPtr, this, VectorDouble.getCPtr(FixedLandmarks), FixedLandmarks);
  }

  /**
std::vector&lt;double&gt; itk::simple::LandmarkBasedTransformInitializerFilter::GetFixedLandmarks() const
*/
public  VectorDouble getFixedLandmarks() {
    return new VectorDouble(SimpleITKJNI.LandmarkBasedTransformInitializerFilter_getFixedLandmarks(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::LandmarkBasedTransformInitializerFilter::SetMovingLandmarks(const std::vector&lt; double &gt; &amp;MovingLandmarks)

Set the Moving landmark point containers

*/
public  void setMovingLandmarks(VectorDouble MovingLandmarks) {
    SimpleITKJNI.LandmarkBasedTransformInitializerFilter_setMovingLandmarks(swigCPtr, this, VectorDouble.getCPtr(MovingLandmarks), MovingLandmarks);
  }

  /**
std::vector&lt;double&gt; itk::simple::LandmarkBasedTransformInitializerFilter::GetMovingLandmarks() const

Get the shrink factors.

*/
public  VectorDouble getMovingLandmarks() {
    return new VectorDouble(SimpleITKJNI.LandmarkBasedTransformInitializerFilter_getMovingLandmarks(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::LandmarkBasedTransformInitializerFilter::SetLandmarkWeight(const std::vector&lt; double &gt; &amp;LandmarkWeight)

Set the landmark weight point containers Weight includes diagonal
elements of weight matrix

*/
public  void setLandmarkWeight(VectorDouble LandmarkWeight) {
    SimpleITKJNI.LandmarkBasedTransformInitializerFilter_setLandmarkWeight(swigCPtr, this, VectorDouble.getCPtr(LandmarkWeight), LandmarkWeight);
  }

  /**
std::vector&lt;double&gt; itk::simple::LandmarkBasedTransformInitializerFilter::GetLandmarkWeight() const
*/
public  VectorDouble getLandmarkWeight() {
    return new VectorDouble(SimpleITKJNI.LandmarkBasedTransformInitializerFilter_getLandmarkWeight(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::LandmarkBasedTransformInitializerFilter::SetReferenceImage(const Image &amp;ReferenceImage)

Set the reference image to define the parametric domain for the
BSpline transform

*/
public  void setReferenceImage(Image ReferenceImage) {
    SimpleITKJNI.LandmarkBasedTransformInitializerFilter_setReferenceImage(swigCPtr, this, Image.getCPtr(ReferenceImage), ReferenceImage);
  }

  /**
Image itk::simple::LandmarkBasedTransformInitializerFilter::GetReferenceImage() const
*/
public  Image getReferenceImage() {
    return new Image(SimpleITKJNI.LandmarkBasedTransformInitializerFilter_getReferenceImage(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::LandmarkBasedTransformInitializerFilter::SetBSplineNumberOfControlPoints(unsigned int BSplineNumberOfControlPoints)

Set/Get the number of control points

*/
public  void setBSplineNumberOfControlPoints(long BSplineNumberOfControlPoints) {
    SimpleITKJNI.LandmarkBasedTransformInitializerFilter_setBSplineNumberOfControlPoints(swigCPtr, this, BSplineNumberOfControlPoints);
  }

  /**
unsigned int itk::simple::LandmarkBasedTransformInitializerFilter::GetBSplineNumberOfControlPoints() const

Set/Get the number of control points

*/
public  long getBSplineNumberOfControlPoints() {
    return SimpleITKJNI.LandmarkBasedTransformInitializerFilter_getBSplineNumberOfControlPoints(swigCPtr, this);
  }

  /**
std::string itk::simple::LandmarkBasedTransformInitializerFilter::GetName() const override

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LandmarkBasedTransformInitializerFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LandmarkBasedTransformInitializerFilter::ToString() const override

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LandmarkBasedTransformInitializerFilter_toString(swigCPtr, this);
  }

  /**
Transform itk::simple::LandmarkBasedTransformInitializerFilter::Execute(const Transform &amp;transform)

Execute the filter on the input image

*/
public  Transform execute(Transform transform) {
    return new Transform(SimpleITKJNI.LandmarkBasedTransformInitializerFilter_execute(swigCPtr, this, Transform.getCPtr(transform), transform), true);
  }

}
