/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.daten.FilmListMetaData;
import mediathek.daten.ListeFilme;
import mediathek.gui.messages.FilmListReadStopEvent;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.jetbrains.annotations.NotNull;

public class FilmListCreationDateLabel
extends JLabel
implements PropertyChangeListener {
    public FilmListCreationDateLabel() {
        ListeFilme blacklist = Daten.getInstance().getListeFilmeNachBlackList();
        this.setText(blacklist.getMetaData());
        blacklist.addMetaDataChangeListener(this);
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    private void setText(@NotNull FilmListMetaData metaData) {
        String text = String.format("Filmliste erstellt: %s Uhr", metaData.getGenerationDateTimeAsString());
        SwingUtilities.invokeLater(() -> this.setText(text));
    }

    @Handler
    private void handleFilmListStop(@NotNull FilmListReadStopEvent e) {
        this.setText(Daten.getInstance().getListeFilmeNachBlackList().getMetaData());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FilmListMetaData metaData = (FilmListMetaData)evt.getNewValue();
        this.setText(metaData);
    }
}

