/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.output;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.output.OutputDisplayer;
import org.netbeans.modules.gradle.api.output.OutputListeners;
import org.netbeans.modules.gradle.api.output.OutputProcessor;
import org.netbeans.modules.gradle.api.output.OutputProcessorFactory;
import org.openide.util.Utilities;

public class GatlingReportProcessorFactory
implements OutputProcessorFactory {
    static final OutputProcessor GATLING_OUTPUT_PROCESSOR = new GatlingOutputProcessor();

    public Set<? extends OutputProcessor> createOutputProcessors(RunConfig cfg) {
        return Collections.singleton(GATLING_OUTPUT_PROCESSOR);
    }

    private static class GatlingOutputProcessor
    implements OutputProcessor {
        private static final Pattern GATLING_REPORT = Pattern.compile("(Please open the following file: )((.+)index.html)");

        private GatlingOutputProcessor() {
        }

        public boolean processLine(OutputDisplayer out, String line) {
            Matcher matcher = GATLING_REPORT.matcher(line);
            if (matcher.matches()) {
                String txt = matcher.group(1);
                String lnk = matcher.group(2);
                out.print(txt);
                File report = new File(lnk);
                if (report.isFile()) {
                    try {
                        out.print(lnk, OutputListeners.openURL((URL)Utilities.toURI((File)report).toURL()));
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    out.print(lnk);
                }
                return true;
            }
            return false;
        }
    }
}

