/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

final class Processes {
    private static final String CMD_UNIX = "ps -x -o pid,command";
    private static final String CMD_WIN = "tasklist /FO CSV";

    Processes() {
    }

    static List<ProcessInfo> getAllProcesses() {
        List<ProcessInfo> processInfos;
        Function<Stream<ProcessInfo>, List<ProcessInfo>> collector = infoStream -> infoStream.filter(info -> info != null).sorted((info1, info2) -> info1.getPid() == info2.getPid() ? 0 : (info1.getPid() > info2.getPid() ? -1 : 1)).collect(Collectors.toList());
        try {
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            processInfos = Processes.getProcesses(processHandleClass, collector);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ex) {
            processInfos = Utilities.isWindows() ? Processes.getProcessesWinCmd(collector) : Processes.getProcessesUNIXCmd(collector);
        }
        return processInfos;
    }

    private static List<ProcessInfo> getProcesses(Class<?> processHandleClass, Function<Stream<ProcessInfo>, List<ProcessInfo>> collector) throws NoSuchMethodException, IllegalAccessException {
        Method allProcessesMethod = processHandleClass.getMethod("allProcesses", new Class[0]);
        try {
            Stream allProcesses = (Stream)allProcessesMethod.invoke(null, new Object[0]);
            return collector.apply(allProcesses.map(new ProcessHandle2Info(processHandleClass)));
        }
        catch (IllegalArgumentException | InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    private static List<ProcessInfo> getProcessesUNIXCmd(Function<Stream<ProcessInfo>, List<ProcessInfo>> collector) {
        return Processes.getProcesses(CMD_UNIX, line -> {
            long pid;
            int i2 = line.indexOf(32);
            if (i2 < 0) {
                return null;
            }
            String pidStr = line.substring(0, i2);
            try {
                pid = Long.parseLong(pidStr);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            int i1 = i2 + 1;
            String commandLine = line.substring(i1).trim();
            if (CMD_UNIX.equals(commandLine)) {
                return null;
            }
            return new ProcessInfo(pid, null, commandLine);
        }, collector);
    }

    private static List<ProcessInfo> getProcessesWinCmd(Function<Stream<ProcessInfo>, List<ProcessInfo>> collector) {
        return Processes.getProcesses(CMD_WIN, line -> {
            long pid;
            if (!line.startsWith("")) {
                return null;
            }
            int i1 = 1;
            int i2 = line.indexOf(34, i1);
            if (i2 < 0) {
                return null;
            }
            String execName = line.substring(i1, i2);
            i1 = line.indexOf(34, i2 + 1);
            if (i1 < 0) {
                return null;
            }
            if ((i2 = line.indexOf(34, ++i1)) < 0) {
                return null;
            }
            String pidStr = line.substring(i1, i2);
            try {
                pid = Long.parseLong(pidStr);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            return new ProcessInfo(pid, execName, execName);
        }, collector);
    }

    private static List<ProcessInfo> getProcesses(String cmd, Function<? super String, ? extends ProcessInfo> pmap, Function<Stream<ProcessInfo>, List<ProcessInfo>> collector) {
        List<ProcessInfo> list;
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            list = collector.apply(reader.lines().map(line -> line.trim()).map(pmap));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return Collections.emptyList();
            }
        }
        reader.close();
        return list;
    }

    private static class ProcessHandle2Info
    implements Function<Object, ProcessInfo> {
        private final Method pidMethod;
        private final Method infoMethod;
        private final Method commandMethod;
        private final Method commandLineMethod;

        ProcessHandle2Info(Class<?> processHandleClass) throws NoSuchMethodException {
            this.pidMethod = processHandleClass.getMethod("pid", new Class[0]);
            this.infoMethod = processHandleClass.getMethod("info", new Class[0]);
            this.commandMethod = this.infoMethod.getReturnType().getMethod("command", new Class[0]);
            this.commandLineMethod = this.infoMethod.getReturnType().getMethod("commandLine", new Class[0]);
        }

        @Override
        public ProcessInfo apply(Object processHandle) {
            try {
                long pid = (Long)this.pidMethod.invoke(processHandle, new Object[0]);
                Object info = this.infoMethod.invoke(processHandle, new Object[0]);
                Optional command = (Optional)this.commandMethod.invoke(info, new Object[0]);
                Optional commandLine = (Optional)this.commandLineMethod.invoke(info, new Object[0]);
                if (command.isPresent() && commandLine.isPresent()) {
                    return new ProcessInfo(pid, (String)command.get(), (String)commandLine.get());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
    }

    static final class ProcessInfo {
        private final long pid;
        private final String executable;
        private final String command;

        ProcessInfo(long id, String executable, String command) {
            assert (command != null);
            this.pid = id;
            this.executable = executable;
            this.command = command;
        }

        long getPid() {
            return this.pid;
        }

        String getExecutable() {
            int i;
            if (this.executable != null) {
                return this.executable;
            }
            File exeFile = new File("/proc/" + this.pid + "/exe");
            if (exeFile.exists()) {
                try {
                    return exeFile.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return (i = this.command.indexOf(32)) > 0 ? this.command.substring(0, i) : this.command;
        }

        String getCommand() {
            return this.command;
        }
    }
}

